/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    hal_voice.c
 * File Mark:
 * Description:  This file contains the hal layer routines for voice driver.
 * Others:
 * Version:       V0.5
 * Author:        WangJun
 * Date:          2008-12-12
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

/****************************************************************************
*                                             Include files
****************************************************************************/
//#include "pub_typedef.h"
#include "drvs_general.h"

#include "drvs_io_voice.h"
#include "hal_voice.h"
#include "drvs_volte.h"

//#include "bastypes.h"
//#include "dsp_sgold3_aud_ext.h"
//#include "dsp_sgold3_ext.h"
#include "aud_drv.h"
#include "aud_ext_intf.h"
#include "drvs_pwr.h"   /*add by psm*/
#include "aud_com.h"
#include "aud_nv.h"
//#include "sio_api.h"

//#include "dsp_sgold3_cmn_ext.h"

/*add for hardware test tools.[lvwenhua-2010-9-1]*/
#ifdef _USE_HAL_HDTTST
#include "hal_hrdtst_basevoice.h"
#include "hal_hrdtst_voice.h"
#endif

#include "drvs_voiceprocess.h"
#include "hal_audiointf.h"
#include "drvs_audiomanager.h"

/****************************************************************************
*                                             Local Macros
****************************************************************************/
#define VOICE_FRAMETYPE_NUM 16
#define VOICE_SHAREMDATA_NUM 32
#define VOICE_RECDATA_NUM 34
#define VOICE_RECDATABUF_NUM 2
#define VOICE_UMTS_FRAMETIME 20000

/*[Begin] decrease volume when loop to avoid howling.[lv.wenhua-2010/5/28]*/
#define VOICE_MASTER_VOLUME aud_volume_85
#define VOICE_LOOP_MASTER_VOLUME aud_volume_60
/*[End] [lv.wenhua-2010/5/28]*/

#define PSV_CTRL_AUD_VOICE   7 /* audio voice*/  //add by xxq for psm
//#define USE_UART   //Use on the plat of 7502
#define Voice_Record_Test  //Use on the plat of 7502
#define VOICE_RECORD_FUNCTION//add by xuxinqiang for voice record

/****************************************************************************
*                                             Local Types
****************************************************************************/
typedef enum
{
    VOICE_IDLE = 0,
    VOICE_OPEN,
    VOICE_INUSE,
    VOICE_MAX
} T_Voice_Status;

typedef enum
{
    VOICE_RECORD_IDLE = 0,
    VOICE_RECORD_OPEN ,
    VOICE_RECORD_INUSE,
    VOICE_RECORD_MAX
} T_Voice_RecordStatus;

typedef enum
{
    VOICE_SYNC_FIRST = 1,
    VOICE_SYNC_REPEAT,
    VOICE_SYNC_MAX
} T_Voice_SyncStatus;

typedef enum
{
    VOICE_SYNC_NO = 0,
    VOICE_SYNC_DOWNLINK,
    VOICE_SYNC_UPLINK,
    VOICE_SYNC_UPDOWNLINK,
    VOICE_SYNC_UPDOWN_MAX
} T_Voice_SyncDirection;

typedef enum
{
    NOISEREDUCT_DISABLE = 0,
    NOISEREDUCT_ENABLE,
    NOISEREDUCT_MAX
} T_Voice_NoiseReduction;

typedef enum
{
    ECHOCANCEL_DISABLE = 0,
    ECHOCANCEL_ENABLE,
    ECHOCANCEL_MAX
} T_Voice_EchoCancellation;

typedef enum
{
    VOICE_UMTS_OFF = 0,
    VOICE_UMTS_ON,
    VOICE_UMTS_MAX
} T_Voice_Umts;

typedef struct _T_Voice_RecBuf
{
    UINT8 recDataBuf[VOICE_RECDATA_NUM];
    UINT8 isValid;
}
T_Voice_RecBuf;

typedef enum
{
    VOICE_LOOP_IDLE = 0,
    VOICE_LOOP_INUSE,
    VOICE_LOOP_MAX
} T_Voice_LoopStatus;


/****************************************************************************
*                                             Local Constants
****************************************************************************/

/****************************************************************************
*                                             Local Function Prototypes
****************************************************************************/
extern void aud_voice_record_channel(T_ZDrvVoice_RecordChannel channel );
extern SINT32 aud_SetCodecPWOnOff(BOOL onOff);
extern void aud_dsp_umts_on(BOOL switch_par);


static SINT32 voice_Open(VOID);
static SINT32 voice_Close(VOID);
SINT32 voice_RcdStart(T_ZDrvRcd_InfoParam *pParam);
SINT32 voice_RcdStop(VOID);
static SINT32 voice_SetSample(T_HalVoice_Block* pVoiceBlock);
static SINT32 voice_SetPathIn(T_HalVoice_Block* pVoiceBlock);
static SINT32 voice_SetPathOut(T_HalVoice_Block* pVoiceBlock);
static SINT32 voice_SetVolIn(T_HalVoice_Block * pVoiceBlock);
static SINT32 voice_SetVolOut(T_HalVoice_Block* pVoiceBlock);
//static SINT32 voice_RecordDataRead(T_ZDrvVoice_BufInfo *pVoiceDataInfo);
SINT32 voice_SetMute(T_ZDrvVoice_MuteInfo* pVoiceMuteInfo);
static SINT32 voice_Loop(T_ZDrvVoice_Switch enable);
static SINT32 voice_Enable(VOID);
static SINT32 voice_Disable(VOID);
//static SINT32 voice_FreeRcdBuf(VOID *pBuf);

//static SINT32 voice_CreateSem(VOID);
//static SINT32 voice_DeleteSem(VOID);
//static SINT32 voice_CreateRecSem(VOID);
//static SINT32 voice_DeleteRecSem(VOID);
//static VOID voice_PutRecSemCallBack(VOID);
//static VOID voice_UpdataLenCallBack(UINT32 frameLength);

#ifdef _USE_HAL_HDTTST
static T_ZDrvVoice_PathMode voice_GetPathMode(VOID);
static SINT32 voice_PmicLoop(T_ZDrvVoice_Switch enable);

static SINT32 voice_GetStatus(BOOL *pIsWorking, T_ZDrvVoice_PathMode *pPath);
static VOID voice_SetTestCallback(T_ZDrvVoice_CallbackFunc cb);
static SINT32 voice_initpaths(void);
#endif

//static SINT32 halHrdTstBaseVoice_Initiate(VOID);
//static SINT32 halHrdTstVoice_Initiate(VOID);

static VOID Voice_RecordAmrThreadEntry(SINT32 argu);
//static SINT32 voice_InnerRcdStop(VOID);
S8 AUD_configure_afei2s(
    U8 handle,                  /* not used */
    aud_I2Sx_mode_enum mode); //xiu
void aud_disable_standby_l1g(U8 resource);//xiu
void aud_enable_standby_l1g(U8 resource);//xiu
SINT32 zDrvVoice_Init(VOID);//xiu
/****************************************************************************
*                                            Global Constants
****************************************************************************/

/****************************************************************************
*                                            Global Variables
****************************************************************************/
static SINT8 s_voiceAudSpeechHandler = 0;                          /* handle of Speech */
//static SINT8 s_voiceAudRecordHandler = 0;                          /* handle of Voice memo */

T_ZDrvVoice_OutputVolLevel  s_voiceVolout = MAX_VOICE_OUTPUT_VOL_LEVEL;

//static ZOSS_SEMAPHORE_ID s_voiceReadSemID = NULL;
//static ZOSS_SEMAPHORE_ID s_voiceWriteSemID = NULL;
static ZOSS_SEMAPHORE_ID s_voiceRecSemID = NULL;
static T_Voice_RecordStatus  s_voiceRecordStatus = VOICE_RECORD_IDLE;
static T_Voice_Status s_voiceStatus = VOICE_IDLE;
static T_Voice_LoopStatus s_voiceLoopStatus = VOICE_LOOP_IDLE;

//BOOL isRecording = TRUE;
//SINT32 AudUartFd = 0;
static ZOSS_THREAD_ID s_VoiceRecStatusThreadID = NULL;
ZOSS_SEMAPHORE_ID s_voiceOnlineRecSemID = NULL;
//static SINT32 s_hwTimerId = 0;//xiu
//static UINT32 s_uplinkCount = 0;
//static UINT32 s_downlinkCount = 0;
//static UINT32 s_voiceRecRate = 0;
//static UINT8 s_sMemoUplinkData[VOICE_SHAREMDATA_NUM] = {0};
//static UINT8 s_sMemoDownlinkData[VOICE_SHAREMDATA_NUM] = {0};
//static UINT8 s_amrEnFrameType[VOICE_FRAMETYPE_NUM] = {13, 14, 16, 18, 20, 21, 27, 32, 6, 0, 0, 0, 0, 0, 0, 1};
//static UINT8 s_amrDeFrameType[VOICE_FRAMETYPE_NUM] = {13, 14, 16, 18, 19, 21, 26, 31, 6, 0, 0, 0, 0, 0, 0, 1};
#ifdef _USE_VOICE_TEAKLIT_LOOP
UINT16 *g_p_speech_amr_umts_ul_ctrl = NULL;
UINT16 *g_p_speech_amr_umts_ul_data = NULL;
UINT16 *g_p_speech_amr_umts_dl_data = NULL;
UINT16 *g_p_speech_amr_rec_data = NULL;
#endif
extern T_DSP_CMD_VB_SET_GAIN_PAR  aud_dsp_gain_parms;
extern aud_eep_static_type  	  aud_EEP_static;

//extern BOOL g_innerI2sIsMaster;
//extern UINT8 g_isUseSlicCodec;
//extern BOOL g_innerI2sIsI2sMode;
//extern T_ZDrv_VpPath g_vpPath;

extern T_zDrvVoice_GbVar g_voiceVar;

#define BASEADR_SM_INT      (UINT16 *) 0xF6001000
#define UMTS_UL_CTRL              (UINT16 *) (BASEADR_SM_INT + 1061 )
#define UMTS_UL_DATA             (UINT16 *) (BASEADR_SM_INT + 1062 )
#define UMTS_DL_DATA             (UINT16 *) (BASEADR_SM_INT + 1078 )
#define RECORD_DATA               (UINT16 *) (BASEADR_SM_INT + 227 )
#ifdef _USE_VOICE_TEAKLIT_LOOP
#define SPEECH_UL_SM_ADRESS_PTR   ((UINT8*)g_p_speech_amr_umts_ul_data)
#define SPEECH_DL_SM_ADRESS_PTR   ((UINT8*)g_p_speech_amr_umts_dl_data)
#define RECORD_DATA_PTR                   ((UINT8*)g_p_speech_amr_rec_data)
#endif
T_Voice_RecBuf g_voiceRecDataBuf[VOICE_RECDATABUF_NUM] = {0};//xiu
//T_ZDrvI2S_Id I2S_ID = I2S_1;
static T_HalVoice_Opt s_voiceObjOpt =
{
    NULL,//voice_InitCodec,
    voice_Open,
    voice_Close,
    NULL,//voice_Read,
    NULL,//voice_Write,
    voice_SetSample,
    voice_SetPathIn,
    voice_SetPathOut,
    voice_SetVolIn,
    voice_SetVolOut,
    voice_Loop,
    voice_SetMute,
    voice_Enable,
    voice_Disable,
    NULL,//voice_VtStart,
    NULL,//voice_VtStop,
    NULL,//voice_RecordDataRead,
    voice_RcdStart,
    voice_RcdStop,
    NULL,//voice_FreeRcdBuf,
    NULL,
    NULL
};


#ifdef _USE_HAL_HDTTST
/*add for hardware test tools.[lvwenhua-2010-9-1]*/
static T_HalHrdTst_BaseVoice_Opt gHalHrdTst_BaseVoice_Opt =
{
    voice_initpaths,
    voice_Open,
    voice_Close,
    voice_SetPathIn,
    voice_SetPathOut,
    voice_SetVolOut,
    voice_PmicLoop,
    voice_Enable,
    voice_Disable
};

static T_HalHrdTst_Voice_Opt gHalHrdTst_Voice_Opt =
{
    voice_GetStatus,
    voice_SetTestCallback
};

static T_ZDrvVoice_CallbackFunc gHalHrdTst_Voice_TestCb = NULL;
#endif

static T_ZDrv_VoiceInputPath   s_voicePathin = MAX_CODEC_INPUT_PATH;
T_ZDrv_VoiceOutputPath  s_voicePathout = MAX_CODEC_OUTPUT_PATH;
static aud_uplink_source_enum s_voicePathInConvertTbl[MAX_CODEC_INPUT_PATH] =
{
    aud_handset_mic,
    aud_headset_mic,
    aud_I2S1_rx
};

static aud_downlink_source_enum s_voicePathOutConvertTbl[MAX_CODEC_OUTPUT_PATH] =
{
    aud_normal_earpiece,
    aud_backspeaker,
    aud_stereo_headset,
    aud_I2S1_tx,
    aud_backspeaker_stereo
};

T_ZDrvVp_Cfg voiceCfgParam= {8000,1,160,16,VOICE_GSM_MODE};



/****************************************************************************
*                                            Global Function Prototypes
****************************************************************************/

extern void aud_dsp_set_vb_gains(void);

#ifdef _USE_PSM
extern SINT32 zDrvPow_SetDevActive(T_ZDrvPow_IdleFlag devId);
extern SINT32 zDrvPow_SetDevIdle(T_ZDrvPow_IdleFlag devId);
#endif

extern SINT32 Aud_TaskInt_Init(VOID);


extern SINT32 vp_Open(T_ZDrvVoice_MODE voiceMode);
extern SINT32 vp_CfgParam(T_ZDrvVp_Cfg *cfgParam);

extern SINT32 vp_Close(T_ZDrvVoice_MODE voiceMode);
extern SINT32 vp_VoiceWorkStart(VOID);
extern SINT32 zDrvVp_VoiceWorkStop(VOID);

#if 0//xiu
/****************************************************************************
*                                            Function Definitions
****************************************************************************/

/*******************************************************************************
 * Function: voice_CreateSem
 * Description: This function is used to Create Semophone.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_CreateSem(VOID)
{
    s_voiceReadSemID = zOss_CreateSemaphore("Voice_ReadSemID", 0);
    if (s_voiceReadSemID == NULL)
    {
        return DRV_ERROR;
    }

    s_voiceWriteSemID = zOss_CreateSemaphore("Voice_WriteSemID", 0);
    if (s_voiceWriteSemID == NULL)
    {
        zOss_DeleteSemaphore(s_voiceReadSemID);
        return DRV_ERROR;
    }

    return DRV_SUCCESS;
}

/*******************************************************************************
 * Function: voice_CreateSem
 * Description: This function is used to Create Semophone of record.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_CreateRecSem(VOID)
{
    s_voiceRecSemID = zOss_CreateSemaphore("Voice_RecordSemID", 0);
    if (s_voiceRecSemID == NULL)
    {
        return DRV_ERROR;
    }

    return DRV_SUCCESS;
}
#if 0
/*******************************************************************************
 * Function: voice_CreateSem
 * Description: This function is used to Create Semophone of voice online record.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_CreateOnlineRecordSem(VOID)    /*add for 7502 Online Record*/
{

    if (s_voiceOnlineRecSemID == NULL)
    {
        s_voiceOnlineRecSemID = zOss_CreateSemaphore("Voice_OnlineRecordSemID", 0);
    }

    return DRV_SUCCESS;
}
#endif
/*******************************************************************************
 * Function: voice_DeleteSem
 * Description: This function is used to delete Semophone.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_DeleteSem(VOID)
{
    UINT32  ret = 0;
    ret = zOss_DeleteSemaphore(s_voiceReadSemID);
    ret += zOss_DeleteSemaphore(s_voiceWriteSemID);
    if (ret != DRV_SUCCESS)
    {
        return DRV_ERROR;
    }
    s_voiceReadSemID = NULL;
    s_voiceWriteSemID = NULL;

    return DRV_SUCCESS;
}

/*******************************************************************************
 * Function: voice_DeleteRecSem
 * Description: This function is used to delete Semophone.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_DeleteRecSem(VOID)
{
    UINT32  ret = 0;
    ret = zOss_DeleteSemaphore(s_voiceRecSemID);
    if (ret != DRV_SUCCESS)
    {
        return DRV_ERROR;
    }
    s_voiceRecSemID = NULL;

    return DRV_SUCCESS;
}

/*******************************************************************************
 * Function: voice_PutRecSemCallBack
 * Description: This function is used to call back.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: None
 *
 *
 * Others:
 ********************************************************************************/
VOID voice_PutRecSemCallBack(VOID)
{
    zOss_PutSemaphore(s_voiceRecSemID);
}

/*******************************************************************************
 * Function: voice_UpdataLenCallBack
 * Description: This function is used to call back.
 * Parameters:
 *   Input:frameLength: the length of a frame
 *   Output:None
 *
 * Returns: None
 *
 *
 * Others:
 ********************************************************************************/
VOID voice_UpdataLenCallBack(UINT32 frameLength)
{
    s_voiceRecRate = frameLength;
}
#endif

/*******************************************************************************
 * Function: voice_InitCodec
 * Description: This function is used to init codec.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
SINT32 voice_InitCodec(VOID)
{
    /*init global variant*/
    //g_p_speech_amr_umts_ul_ctrl = UMTS_UL_CTRL;
    //g_p_speech_amr_umts_ul_data = UMTS_UL_DATA;
    //g_p_speech_amr_umts_dl_data = UMTS_DL_DATA;
#ifdef _USE_VOICE_TEAKLIT_LOOP
    g_p_speech_amr_rec_data = RECORD_DATA;

    g_voiceRecDataBuf[0].isValid = 0;
    g_voiceRecDataBuf[1].isValid = 0;
#endif
    return  DRV_SUCCESS;
}

/*******************************************************************************
 * Function: voice_Open
 * Description: This function is used to open source.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_Open(VOID)
{

    SINT32  ret = 0;
    //BOOL onOff = TRUE;//xiu
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " voice_Open start\n");
   zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"voice_Open start!\n");

    ret = zDrvAudioM_GetResource(AUDIO_MANAGER_RESOURCE_VOICE);
    if(ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " voice_Open fail to get voice resource\n");
        return ret;
    }
    if (s_voiceStatus != VOICE_IDLE)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " voice_Open status err s_voiceStatus=%d \n",s_voiceStatus);
        zDrvAudioM_FreeResource(AUDIO_MANAGER_RESOURCE_VOICE);
        return DRV_ERROR;
    }
    /*end*/

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Open before s_voiceStatus(0=idle,1=open,2=use)=%d\n",s_voiceStatus);
    ret =vp_Open(VOICE_GSM_MODE);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " voice_Open vp_Open ret=%d \n",ret);
        zDrvAudioM_FreeResource(AUDIO_MANAGER_RESOURCE_VOICE);
        return DRV_ERROR;
    }
    ret =vp_CfgParam(&voiceCfgParam);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Open vp_CfgParam ret=%d \n",ret);
		ret = vp_Close(VOICE_GSM_MODE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "voice_Open  vp_Close err ret =%d \r\n",ret);
		}
        zDrvAudioM_FreeResource(AUDIO_MANAGER_RESOURCE_VOICE);
        return DRV_ERROR;
    }
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Open vp_Open and vp_CfgParam\n");

#if PS_RAT_GSM
    /* open teak*/
    s_voiceAudSpeechHandler = AUD_allocate_resource(1, aud_resource_speech, aud_priority_normal);
    if (s_voiceAudSpeechHandler < 0)
    {
		ret = vp_Close(VOICE_GSM_MODE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "voice_Open  vp_Close err ret =%d \r\n",ret);
		}    
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Open AUD_allocate_resource error s_voiceAudSpeechHandler=0x%x\n",s_voiceAudSpeechHandler);
        zDrvAudioM_FreeResource(AUDIO_MANAGER_RESOURCE_VOICE);
        return DRV_ERROR;
    }
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Open AUD_allocate_resource ret(s_voiceAudSpeechHandler)=0x%x\n",s_voiceAudSpeechHandler);


    if (g_voiceVar.innerI2sIsI2sMode == TRUE)

    {
        /*Mode 3: 16 bit 8 kHz Master, Normal Mode, Mono */
        if (g_voiceVar.innerI2sIsMaster != TRUE)
        {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Open aud_I2Sx_mode3 g_voiceVar.innerI2sIsMaster=%d\n",g_voiceVar.innerI2sIsMaster);

            ret = AUD_configure_afei2s((U8)s_voiceAudSpeechHandler, aud_I2Sx_mode3);//master
        }
        else
        {

            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Open aud_I2Sx_mode4 g_voiceVar.innerI2sIsMaster=%d\n",g_voiceVar.innerI2sIsMaster);
            ret = AUD_configure_afei2s((U8)s_voiceAudSpeechHandler, aud_I2Sx_mode4);//slave

        }
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Open AUD_configure_afei2s ret=0x%x\n",ret);
    }
    else
    {
        if (g_voiceVar.innerI2sIsMaster != TRUE)
        {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Open pcm aud_I2Sx_mode1 \n");

            ret = AUD_configure_bluetooth((U8)s_voiceAudSpeechHandler, aud_I2Sx_mode1);
        }
        else
        {
              zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Open pcm aud_I2Sx_mode2 \n");
            ret = AUD_configure_bluetooth((U8)s_voiceAudSpeechHandler, aud_I2Sx_mode2);

        }
    }
    if (ret  != aud_rc_ok)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Open AUD_configure error ret=0x%x\n",ret);
        AUD_release_resource((U8)s_voiceAudSpeechHandler);
        s_voiceAudSpeechHandler = 0;
		ret = vp_Close(VOICE_GSM_MODE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "voice_Open  vp_Close err ret =%d \r\n",ret);
		}
        zDrvAudioM_FreeResource(AUDIO_MANAGER_RESOURCE_VOICE);
        return DRV_ERROR;
    }

    /*noise reduction and echo cancellation*/
#if (defined(_USE_NXP_AUD) || defined(_USE_AUDIENCE))
    AUD_set_EC_NR(ECHOCANCEL_DISABLE, NOISEREDUCT_DISABLE);
#else
    //AUD_set_EC_NR(ECHOCANCEL_ENABLE, NOISEREDUCT_DISABLE);
    AUD_set_EC_NR(ECHOCANCEL_DISABLE, NOISEREDUCT_DISABLE);
#endif
#endif
    s_voiceStatus = VOICE_OPEN;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Open after  s_voiceStatus(0=idle,1=open,2=use)=0x%x\n",s_voiceStatus);

    s_voicePathin = MAX_CODEC_INPUT_PATH;
    s_voicePathout = MAX_CODEC_OUTPUT_PATH;
    s_voiceVolout = MAX_VOICE_OUTPUT_VOL_LEVEL;
	
#ifdef _USE_PSM
    /*voice psm idle*/
    zDrvPow_SetDevActive((UINT32)IDLE_FLAG_VOICE);
#if PS_RAT_GSM
    /*add for power saving 20100610*/
    aud_disable_standby_l1g(PSV_CTRL_AUD_VOICE);
#endif
    /*end*/
#endif
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Open end ret=0x%x tick=%d.\n", ret,zOss_GetTickCount());
	zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"voice_Open end!\n");

    //g_voiceInGsmTdMode=1;

    return DRV_SUCCESS;
}

/*******************************************************************************
 * Function: voice_Close
 * Description: This function is used to close source.
 * Parameters:
 *    Input:None
 *    Output:None
 *
 * Returns:success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_Close(VOID)
{
    SINT32  ret = 0;


    aud_uplink_source_enum audUplinkPath = aud_handset_mic ;
    aud_downlink_source_enum audDownlinkPath = aud_normal_earpiece;

    voice_RcdStop();//add by xuxinqiang
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Close start");
    if ((s_voiceRecordStatus == VOICE_RECORD_INUSE) ||(s_voiceStatus == VOICE_INUSE))
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Close the state of voice is wrong.\n");
        return DRV_ERROR;
    }
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_close s_voicePathin=%d\n",s_voicePathin);
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_close s_voicePathout=%d\n",s_voicePathout);

    if (s_voicePathin < MAX_CODEC_INPUT_PATH)
    {
        audUplinkPath = s_voicePathInConvertTbl[s_voicePathin];
#if PS_RAT_GSM        
        ret = AUD_remove_uplinkpath(audUplinkPath);
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Close AUD_remove_uplinkpath ret=%d\n",ret);
        if (ret !=  aud_rc_ok)
        {
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Close AUD_remove_uplinkpath error! ret=%d\n",ret);        
            //return DRV_ERROR;
        }
#endif        
    }

    if (s_voicePathout < MAX_CODEC_OUTPUT_PATH)
    {
        audDownlinkPath = s_voicePathOutConvertTbl[s_voicePathout];
#if PS_RAT_GSM        
        ret = AUD_remove_downlinkpath(audDownlinkPath);
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Close AUD_remove_downlinkpath ret=%d\n",ret);
        if (ret !=  aud_rc_ok)
        {
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Close AUD_remove_downlinkpath error! ret=%d\n",ret);
		   // return DRV_ERROR;
        }
#endif        
    }

#if PS_RAT_GSM
    /* release the handle of Speech */
    ret =  AUD_release_resource((U8)s_voiceAudSpeechHandler);
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Close AUD_release_resource ret=%d\n",ret);
    if (ret != aud_rc_ok)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Close AUD_release_resource error! ret=%d\n",ret);
        //return DRV_ERROR;
    }
#endif

    s_voiceAudSpeechHandler = 0;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Close  s_voiceStatus(0=idle,1=open,2=use)=%d\n",s_voiceStatus);

#if PS_RAT_GSM

    /*[Begin]clear ec and nr setting. [lvwenhua-2010/7/28]*/
    AUD_set_EC_NR(ECHOCANCEL_DISABLE, ECHOCANCEL_DISABLE);
    /*[End] [lvwenhua-2010/7/28]*/
#endif
    ret = vp_Close(VOICE_GSM_MODE);
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Close vp_Close = %d.\n",ret);
    if (ret != DRV_SUCCESS)
    {
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Close vp_Close err ret= %d.\n",ret);
    }



#ifdef _USE_PSM
    /*voice psm idle*/
    zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_VOICE);
#if PS_RAT_GSM

    /*add for power saving 20100610*/
    aud_enable_standby_l1g(PSV_CTRL_AUD_VOICE);
#endif
    /*end*/
#endif

    s_voiceStatus = VOICE_IDLE;
    // g_voiceInGsmTdMode=0;
    zDrvAudioM_FreeResource(AUDIO_MANAGER_RESOURCE_VOICE);

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Close end");
	zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"voice_Close end!\n");

    return DRV_SUCCESS;
}

/*******************************************************************************
 * Function: voice_Enable
 * Description: This function is used to enable the voice of Teak.
 * Parameters:
 *   Input:None
 *
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_Enable(VOID)
{

    SINT32  ret = DRV_SUCCESS;
#ifdef _USE_HAL_HDTTST
    T_ZDrvVoice_PathMode path = MAX_VOICE_PATH_MODE;
#endif
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO," voice_Enable start.");

    if (s_voiceStatus == VOICE_OPEN)
    {
#if PS_RAT_GSM        
        /* enable the voice of Teak */
        ret = AUD_speech_enable((U8)s_voiceAudSpeechHandler);
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO," AUD_speech_enable ret=%d\n",ret);
        if (ret != aud_rc_ok)
        {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Enable AUD_speech_enable error ret=%x!\n",ret);
            return DRV_ERROR;
        }
#endif        
        s_voiceStatus = VOICE_INUSE;
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Enable  s_voiceStatus(0=idle,1=open,2=use)=%d\n",s_voiceStatus);
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_Enable voice status error,voiceStatus=%x!\n",s_voiceStatus);
        return DRV_ERROR;
    }

    /*add for pc test tools[Begin] [lvwenhua-2010/9/14]*/
#ifdef _USE_HAL_HDTTST
    if (NULL != gHalHrdTst_Voice_TestCb)
    {
        path = voice_GetPathMode();

        if (path < MAX_VOICE_PATH_MODE)
        {
            (*gHalHrdTst_Voice_TestCb)(TRUE, path);
        }
    }
#endif
    /*[End] [lvwenhua-2010/9/14]*/

    ret = vp_VoiceWorkStart();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceWorkStart ret = %d.\n",ret);
	
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Enable end");

    return ret;
}

/*******************************************************************************
 * Function: voice_Disable
 * Description: This function is used to disable the voice of Teak.
 * Parameters:
 *   Input:None
 *
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_Disable(VOID)
{
    SINT32  ret = DRV_SUCCESS;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Disable start!\n");

    if (s_voiceStatus == VOICE_INUSE)
    {
#if PS_RAT_GSM
        /* disable the voice of Teak */
        ret = AUD_speech_disable((U8)s_voiceAudSpeechHandler);
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO," voice_Disable AUD_speech_disable ret=%d\n",ret);
#endif

        s_voiceStatus = VOICE_OPEN;
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Disable  s_voiceStatus(0=idle,1=open,2=use)=%d\n",s_voiceStatus);
    }
    else
    {
        return DRV_ERROR;
    }

    /*add for pc test tools[Begin] [lvwenhua-2010/9/14]*/
#ifdef _USE_HAL_HDTTST
    if (NULL != gHalHrdTst_Voice_TestCb)
    {
        (*gHalHrdTst_Voice_TestCb)(FALSE, MAX_VOICE_PATH_MODE);
    }
#endif
    /*[End] [lvwenhua-2010/9/14]*/

    ret = zDrvVp_VoiceWorkStop();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Disable zDrvVp_VoiceWorkStop ret = %d\n",ret);

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_Disable  end\n");


    return ret;
}


/*******************************************************************************
 * Function: Voice_SetSample
 * Description: This function is used to do nothing.
 * Parameters:
 *   Input:pVoiceBlock: the pointer of audio parameter
 *
 *   Output:None
 *
 * Returns: DRV_ERR_NOT_SUPPORTED
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_SetSample(T_HalVoice_Block* pVoiceBlock)
{
    return DRV_ERR_NOT_SUPPORTED;
}

/*[Begin]add for reading output volume from nv. [lvwenhua-2010/9/17]*/
static SINT32 voice_SetMasterVolumein(VOID)
{
    SINT32  ret = 0;
    aud_uplink_source_enum voicePathIn = aud_handset_mic;

    switch (s_voicePathin)
    {
    case CODEC_INPUT_MICPHONE:
        voicePathIn = aud_handset_mic ;
        break;
    case CODEC_INPUT_HEADSET:
        voicePathIn = aud_headset_mic ;
        break;
    case CODEC_INPUT_BLUETOOTH:
        voicePathIn = aud_I2S1_rx ;
    default:
        return DRV_ERR_INVALID_PARAM;
    }
//	if( voicePathIn );//xiu	warning:unused voicePathIn

    return ret;
}


static SINT32 voice_SetMasterVolumeout(VOID)
{
    SINT8  ret = 0;
    aud_downlink_source_enum voicePathOut = aud_normal_earpiece;

    switch (s_voicePathout)
    {
    case CODEC_OUTPUT_RECEIVER:
        voicePathOut = aud_normal_earpiece;
        break;
    case CODEC_OUTPUT_SPEAKER:
        voicePathOut = aud_backspeaker;
        break;
    case CODEC_OUTPUT_HEADSET:
        voicePathOut = aud_stereo_headset;
        break;
    case CODEC_OUTPUT_BLUETOOTH:
        voicePathOut = aud_I2S1_tx;
    default:
        return DRV_ERROR;
    }

#if PS_RAT_GSM

    ret = AUD_set_master_volume(VOICE_MASTER_VOLUME);
#endif
	/*klocwork 3 INVARIANT_CONDITION.UNREACH delete if*/
	/*
    if (ret != aud_rc_ok)
    {
        return DRV_ERROR;
    }*/
//    if( voicePathOut );//xiu	warning:unused voicePathIn	
    return ret;
}
/*[End] [lvwenhua-2010/9/17]*/

/*******************************************************************************
 * Function: voice_SetPathIn
 * Description: This function is used to set codec input path.
 * Parameters:
 *   Input:
 *      pVoiceBlock:T_HalVoice_Block type, including input path information.
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_SetPathIn(T_HalVoice_Block* pVoiceBlock)
{
#if 1
    SINT32  ret = 0;
    aud_uplink_source_enum audUplinkPath = aud_handset_mic ;
    T_ZDrv_VpPath path=VP_PATH_HANDSET;

#ifdef _USE_HAL_HDTTST
    T_ZDrvVoice_PathMode path = MAX_VOICE_PATH_MODE;
#endif

    if (pVoiceBlock == NULL || pVoiceBlock->pathin >= MAX_CODEC_INPUT_PATH)
    {
        return DRV_ERR_INVALID_PARAM;
    }
	
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_SetPathIn start pathin=%d\n",pVoiceBlock->pathin);

    if (s_voiceStatus == VOICE_IDLE)
    {
        return DRV_ERR_NOT_OPENED;
    }



    if (s_voicePathin < MAX_CODEC_INPUT_PATH)
    {
        audUplinkPath = s_voicePathInConvertTbl[s_voicePathin];
#if PS_RAT_GSM        
        ret = AUD_remove_uplinkpath(audUplinkPath);
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_SetPathIn start ret=%d\n",ret);
        if (ret !=  aud_rc_ok)
        {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "AUD_remove_uplinkpath ret=%d",ret);
            return DRV_ERROR;
        }
#endif        
    }

    if(pVoiceBlock->pathin==CODEC_INPUT_MICPHONE)
    {
        path=VP_PATH_HANDSET;
    }
    else if(pVoiceBlock->pathin==CODEC_INPUT_HEADSET)
    {
        path=VP_PATH_HEADSET;
    }
    else if(pVoiceBlock->pathin==CODEC_INPUT_HANDSFREE)
    {
        path=VP_PATH_SPEAKER;
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_SetPahtIn the path not support\n");

    }

    audUplinkPath = s_voicePathInConvertTbl[pVoiceBlock->pathin];
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_SetPathIn s_voicePathInConvertTbl start pVoiceBlock->pathin=%d,audUplinkPath=%d\n",pVoiceBlock->pathin,audUplinkPath);

#if PS_RAT_GSM

    ret = AUD_add_uplinkpath(audUplinkPath);
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_SetPathIn AUD_add_uplinkpath ret=%d\n",ret);
    if (ret !=  aud_rc_ok)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "AUD_add_uplinkpath ret=%d\n",ret);
        return DRV_ERROR;
    }
#endif    
    s_voicePathin = pVoiceBlock->pathin;
    ret += voice_SetMasterVolumein();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_SetPathIn voice_SetMasterVolumein ret=%d,s_voicePathin = %d.\n",ret,s_voicePathin);
    /*add for pc test tools[Begin] [lvwenhua-2010/9/14]*/

#ifdef _USE_HAL_HDTTST
    if ((NULL != gHalHrdTst_Voice_TestCb) && (VOICE_INUSE == s_voiceStatus))
    {
        path = voice_GetPathMode();

        if (path < MAX_VOICE_PATH_MODE)
        {
            (*gHalHrdTst_Voice_TestCb)(TRUE, path);
        }
    }
#endif
    /*[End] [lvwenhua-2010/9/14]*/
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_SetPathIn end\n");
#endif
	//if( path );/*coverity medium STRAY_SEMICOLON ENUM_AS_BOOLEAN delete if*/	
    return DRV_SUCCESS;
}


/*******************************************************************************
 * Function: voice_SetPathOut
 * Description: This function is used to set codec output path.
 * Parameters:
 *   Input:
 *      pVoiceBlock:T_HalVoice_Block type, including output path information.
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
//extern SINT8 s_vpInitGain;//is usd for xinke 20150709 lvwenhua

static SINT32 voice_SetPathOut(T_HalVoice_Block* pVoiceBlock)
{
#if 1
    SINT32  ret = 0;
    aud_volume_enum OutPutVol = aud_volume_0;
    aud_downlink_source_enum audDownlinkPath = aud_normal_earpiece;
    T_ZDrv_VpPath path=VP_PATH_HANDSET;

#ifdef _USE_HAL_HDTTST
    T_ZDrvVoice_PathMode path = MAX_VOICE_PATH_MODE;
#endif

    if (pVoiceBlock == NULL)
    {
        return DRV_ERR_INVALID_PARAM;
    }
    if (pVoiceBlock->pathout >= MAX_CODEC_OUTPUT_PATH)
    {
        return DRV_ERR_INVALID_PARAM;
    }
    if (s_voiceStatus == VOICE_IDLE)
    {
        return DRV_ERR_NOT_OPENED;
    }


#if PS_RAT_GSM

    if (s_voicePathout < MAX_CODEC_OUTPUT_PATH)
    {
        audDownlinkPath = s_voicePathOutConvertTbl[s_voicePathout];
        ret = AUD_remove_downlinkpath(audDownlinkPath);
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_SetPathOut AUD_remove_downlinkpath ret=%d\n",ret);
        if (ret !=  aud_rc_ok)
        {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "AUD_remove_downlinkpath ret=%d",ret);
            return DRV_ERROR;
        }

    }

    audDownlinkPath = s_voicePathOutConvertTbl[pVoiceBlock->pathout];
    ret = AUD_add_downlinkpath(audDownlinkPath);
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_SetPathOut AUD_add_downlinkpath pathout=%d,ret=%d\n",pVoiceBlock->pathout,ret);
    if (ret !=  aud_rc_ok)
    {
        return DRV_ERROR;
    }
#endif
    /*[Begin]change for reading output volume from nv. [lvwenhua-2010/9/19]*/
#ifdef _USE_AUDIO_ON_7520

    s_voiceVolout = g_voiceVar.vpInitGain;

#endif
    s_voicePathout = pVoiceBlock->pathout;

#if PS_RAT_GSM
    OutPutVol = aud_EEP_static.aud_volume_config.voice_vol_gain_config[s_voicePathout].gain[s_voiceVolout];
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_SetPathOut s_voicePathout=%d,invol=%d,OutPutVol=%d\n",s_voicePathout,s_voiceVolout,OutPutVol);
    ret = AUD_set_resource_volume((U8)s_voiceAudSpeechHandler, OutPutVol);
#endif
    ret += voice_SetMasterVolumeout();
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_SetPathOut AUD_add_downlinkpath ret=%d\n",ret);
    /*[End] [lvwenhua-2010/9/19]*/

    /*add for pc test tools[Begin] [lvwenhua-2010/9/14]*/

#ifdef _USE_HAL_HDTTST
    if ((NULL != gHalHrdTst_Voice_TestCb) && (VOICE_INUSE == s_voiceStatus))
    {
        path = voice_GetPathMode();

        if (path < MAX_VOICE_PATH_MODE)
        {
            (*gHalHrdTst_Voice_TestCb)(TRUE, path);
        }
    }
#endif
    /*[End] [lvwenhua-2010/9/14]*/
#endif
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_SetPathOut\n");
//    if( path );//xiu
    return DRV_SUCCESS;
}

/*******************************************************************************
 * Function: voice_SetVolIn
 * Description: This function is used to set codec input volume.
 * Parameters:
 *   Input:
 *      pVoiceBlock:T_HalVoice_Block type, including input volume information.
 *   Output:None
 *
 * Returns:  DRV_ERR_NOT_SUPPORTED
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_SetVolIn(T_HalVoice_Block * pVoiceBlock)
{
    return DRV_ERR_NOT_SUPPORTED;
}




/*******************************************************************************
 * Function: voice_SetVolOut
 * Description: This function is used to set codec output volume.
 * Parameters:
 *   Input:
 *      pVoiceBlock:T_HalVoice_Block type, including output volume information.
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_SetVolOut(T_HalVoice_Block* pVoiceBlock)
{
#if 1
    SINT8  ret = 0;
    aud_volume_enum OutPutVol = aud_volume_0;

    if (pVoiceBlock == NULL || pVoiceBlock->volout >= MAX_VOICE_OUTPUT_VOL_LEVEL)
    {
        return DRV_ERR_INVALID_PARAM;
    }
	
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_SetVolOut start volout=%d\n",pVoiceBlock->volout);
	
    if (s_voiceStatus == VOICE_IDLE)
    {
        return DRV_ERR_NOT_OPENED;
    }

    //is usd for xinke 20150709 lvwenhua
    if((g_voiceVar.vpInitGain >= 0)&&(g_voiceVar.vpInitGain <= 100))
    {
        /*[Begin]change for reading output volume from nv. [lvwenhua-2010/9/19]*/
        // s_voiceVolout = pVoiceBlock->volout;
        //s_voiceVolout =g_VoiceVol;

        OutPutVol = g_voiceVar.vpInitGain;
    }
    else
    {
        s_voiceVolout = pVoiceBlock->volout;
#if PS_RAT_GSM
        OutPutVol = aud_EEP_static.aud_volume_config.voice_vol_gain_config[s_voicePathout].gain[s_voiceVolout];
        /*[End] [lvwenhua-2010/9/19]*/
        zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "  voice_SetVolOut s_voicePathout=%d,invol=%d,OutPutVol=%d\n",s_voicePathout,s_voiceVolout,OutPutVol);
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_SetVolOut s_voicePathout=%d,invol=%d,OutPutVol=%d\n",s_voicePathout,s_voiceVolout,OutPutVol);
#endif
    }
#if PS_RAT_GSM

    ret = AUD_set_resource_volume((U8)s_voiceAudSpeechHandler, OutPutVol);
#endif
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_SetVolOut  ret=%d\n",ret);
    if (ret != aud_rc_ok)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "AUD_set_resource_volume ret=%d\n",ret);
        return DRV_ERROR;
    }

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_SetVolOut end\n");
#endif

    return DRV_SUCCESS;

}


/*******************************************************************************
 * Function: voice_SetMute
 * Description: This function is used to set mute.
 * Parameters:
 *   Input:
 *             pVoiceMuteInfo:T_ZDrvVoice_MuteInfo type, including the path of the data linkpath.
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
SINT32 voice_SetMute(T_ZDrvVoice_MuteInfo* pVoiceMuteInfo)
{
#if 1
    SINT8  ret = 0;
    aud_mute_enum enable_disable = aud_mute_enable;
    aud_ul_dl_direction_enum direction = aud_direction_resource_uplink;

    if (pVoiceMuteInfo == NULL)
    {
        return DRV_ERR_INVALID_PARAM;
    }

    switch (pVoiceMuteInfo->enable)
    {
    case VOICE_MUTE_DISABLE:
        enable_disable = aud_mute_disable;
        break;
    case VOICE_MUTE_ENABLE:
        enable_disable = aud_mute_enable;
        break;
    default:
        return DRV_ERR_INVALID_PARAM;
    }

    switch (pVoiceMuteInfo->channel)
    {
    case VOICE_UPLINK:
        direction = aud_direction_resource_uplink;
        break;
    case VOICE_DOWNLINK:
        direction = aud_direction_resource_downlink;
        break;
    case VOICE_UPLINK_AND_DOWNLINK:
        direction = aud_direction_resource_updownlink;
        break;

    default:
        return DRV_ERR_INVALID_PARAM;
    }

#if PS_RAT_GSM
    /*set Teak mute*/
    ret = AUD_mute_resource((U8)s_voiceAudSpeechHandler,  /*speech handler*/
                            enable_disable,                                                 /*set   mute */
                            direction);                                                        /*mute path*/
#endif
    if (ret != aud_rc_ok)
    {
        return DRV_ERROR;
    }
#endif

    return DRV_SUCCESS;
}

/*******************************************************************************
 * Function: voice_Loop
 * Description: This function is used to test loop.
 * Parameters:
 *   Input:
 *          enable:T_ZDrvVoice_Switch type, enable or disable loopback.
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_Loop(T_ZDrvVoice_Switch enable)
{
    UINT16 daiMode = 0;

    if (enable == VOICE_ENABLE)
    {
        if(VOICE_LOOP_INUSE == s_voiceLoopStatus)
        {
            return DRV_SUCCESS;
        }
        /*[begin][liubaogang-2012/5/8*/
        daiMode =3;
#if PS_RAT_GSM
        DSP_ASYNC_VB_DAI(&daiMode);
#endif
        /*[end]liubaogang-2012/5/8*/
        s_voiceLoopStatus = VOICE_LOOP_INUSE;
    }
    else
    {
        if(VOICE_LOOP_IDLE == s_voiceLoopStatus)
        {
            return DRV_SUCCESS;
        }
        /*[begin][liubaogang-2012/5/8*/
        daiMode =0;
#if PS_RAT_GSM        
        DSP_ASYNC_VB_DAI(&daiMode);
#endif
        /*[end]liubaogang-2012/5/8*/
        s_voiceLoopStatus = VOICE_LOOP_IDLE;
    }

    return DRV_SUCCESS;
}


/*******************************************************************************
 * Function: voice_CreateRcdSemAndThread
 * Description: This function is used to Create Semophone of record,ctrl ,and thread.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
SINT32 voice_CreateRcdSemAndThread(VOID)
{
    SINT32 ret = DRV_SUCCESS;

    s_voiceRecSemID = zOss_CreateSemaphore("Voice_RecordSemID", 0);

    s_voiceOnlineRecSemID = zOss_CreateSemaphore("Voice_OnlineRecordSemID", 0);

    s_VoiceRecStatusThreadID=zOss_CreateThread("VoiceTestRecordThreadEntry", Voice_RecordAmrThreadEntry, 0,1024, 20, 0, 1);   /*add for 7502 Online Record*/

    if((NULL == s_voiceRecSemID) || (NULL == s_voiceOnlineRecSemID)||(NULL == s_VoiceRecStatusThreadID))
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "create voice record sem and thread err! \r\n");
        ret = DRV_ERROR;
    }

    return ret;
}
/*******************************************************************************
 * Function: Voice_RcdStart
 * Description: This function is used to start voice record.
 * Parameters:
 *   Input:
 *          pParam:T_ZDrvRcd_InfoParam type, including amr type.
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
SINT32 voice_RcdStart(T_ZDrvRcd_InfoParam *pParam)
{
#if 0

    SINT32 ret = 0;
    //isRecording = TRUE;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "pParam->channel = %d,pParam->dataformat =%d.\n",pParam->channel,pParam->dataformat );

    if (pParam == NULL)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_RcdStart err invalid para!\n");
        //zDrv_ASSERT(0);
        return DRV_ERR_INVALID_PARAM;
    }

    if( (s_voiceRecordStatus == VOICE_RECORD_OPEN)||(s_voiceRecordStatus == VOICE_RECORD_INUSE))
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "pParam->channel = %d,pParam->dataformat =%d.\n",pParam->channel,pParam->dataformat );
        return DRV_ERR_BUSY;
    }


    if(AudUartFd<=0)
    {
        AudUartFd = zDrv_Open("/mux/30",SIO_WRONLY);
    }
    if (AudUartFd<= 0)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"UART Open failed!fd=%d", AudUartFd);
        //zDrv_ASSERT(0);
        return DRV_ERROR;


    }
    else
    {

        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"UART open OK! fd=%d", AudUartFd);
    }
    s_voiceAudRecordHandler = AUD_allocate_resource(0, aud_resource_record_vm, aud_priority_normal);

    if (s_voiceAudRecordHandler < 0)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_RcdStart err s_voiceAudRecordHandler < 0!\n");
        //zDrv_ASSERT(0);
        return DRV_ERROR;
    }

    s_voiceRecordStatus = VOICE_RECORD_OPEN;





    aud_voice_record_channel(pParam->channel);  /*add for 7502 Online Record*/


    if (pParam->dataformat == RECORD_DATA_FORMAT_AMR)
    {
        ret = AUD_vm_start_recording_def((U8)s_voiceAudRecordHandler,       /* handle to the voice memo recorder */
                                         aud_vm_mode_tch,                     /* choose beween standby and tch mode */
                                         aud_media_ram,                         /* where to store the recording */
                                         aud_dsp_format_amr,                  /* which speech codec to use for recording */
                                         7,                                               /* sample rate if AMR is chosen af format */
                                         (UINT32)voice_PutRecSemCallBack,    /* pointer to the buffer where the recording should be stored */
                                         (UINT32)voice_UpdataLenCallBack,    /* the size of the buffer if RAM media is selected */
                                         0);                                               /* the number of bytes to be left blank at the beginning of the buffer */
    }
    else
    {
        ret = AUD_vm_start_recording_def((U8)s_voiceAudRecordHandler,       /* handle to the voice memo recorder */
                                         aud_vm_mode_tch,                     /* choose beween standby and tch mode */
                                         aud_media_ram,                         /* where to store the recording */
                                         aud_dsp_format_fr,                     /* which speech codec to use for recording */
                                         7,                                               /* sample rate if AMR is chosen af format */
                                         (UINT32)voice_PutRecSemCallBack,       /* pointer to the buffer where the recording should be stored */
                                         (UINT32)voice_UpdataLenCallBack,       /* the size of the buffer if RAM media is selected */
                                         0);                                               /* the number of bytes to be left blank at the beginning of the buffer */
    }

    if (ret != aud_rc_ok)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_RcdStart err AUD_vm_start_recording_def ret=%d!\n",ret);
        //zDrv_ASSERT(0);
        return DRV_ERROR;
    }



    if(s_voiceOnlineRecSemID==NULL)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_RcdStart err s_voiceOnlineRecSemID==NULL!");
        //zDrv_ASSERT(0);
        return DRV_ERROR;

    }
    ret=zOss_PutSemaphore(s_voiceOnlineRecSemID);

    if(ret!=ZOSS_SUCCESS)
    {
#if 0
        ret= zDrv_Close(AudUartFd);
        if (ret== DRV_SUCCESS)
        {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"uart close OK! fd=%d", AudUartFd);
        }
        else
        {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"uart close failed! fd=%d", AudUartFd);
        }
#endif
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice_RcdStart put sem err !,ret=%d",ret);
        //zDrv_ASSERT(0);
        return DRV_ERROR;
    }
    s_voiceRecordStatus = VOICE_RECORD_INUSE;
#endif
    return DRV_SUCCESS;
}

#if 0//ndef VOICE_RECORD_FUNCTION

#define VM_REC_ARRAY_SIZE 10240

#define REC_FLASH_SIZE 819200

UINT8  aud_vm_rec_array[REC_FLASH_SIZE];

//UINT8  aud_vm_rec_array[VM_REC_ARRAY_SIZE];

static VOID Voice_RecordAmrThreadEntry(SINT32 argu)     /*add for 7502 Online Record*/
{
    T_ZDrvVoice_BufInfo pVoiceDataInfo = {NULL} ;
    SINT32 ret = 0;
    UINT32 LenTx=0;
    UINT8 *recBuf;
    UINT8 *read_buf = NULL;
    UINT32 realbuffersize = 0;
    UINT32 configbuffersize = 0;
    UINT32 flash_wr_addr=0;
    recBuf = aud_vm_rec_array;

    while(isRecording)
    {
        voice_RecordDataRead(&pVoiceDataInfo);
        realbuffersize = pVoiceDataInfo.bufferSize;
        read_buf = pVoiceDataInfo.pBuf;

        //memcpy(recBuf , (UINT8*)pVoiceDataInfo.pBuf, realbuffersize);
        zOss_Memcpy(recBuf, read_buf, realbuffersize);
        recBuf += realbuffersize;
        configbuffersize += realbuffersize;

        voice_FreeRcdBuf(read_buf);

        if(configbuffersize >= REC_FLASH_SIZE)
        {
            configbuffersize=0;
            recBuf = aud_vm_rec_array;
        }

#if 0
        if (configbuffersize >= VM_REC_ARRAY_SIZE)
        {
            if(flash_wr_addr >= REC_FLASH_SIZE)
            {
                flash_wr_addr=0;
            }
            nand_NvProgram(flash_wr_addr,VM_REC_ARRAY_SIZE,recBuf);/*nand_NvProgram(0x64000,424288,s_voiceRxInBuffer)*/
            flash_wr_addr += VM_REC_ARRAY_SIZE;

            recBuf = aud_vm_rec_array;
            configbuffersize=0;
        }
#endif
    }
    //nand_NvProgram(flash_wr_addr,configbuffersize,recBuf);/*nand_NvProgram(0x64000,424288,s_voiceRxInBuffer)*/

    voice_InnerRcdStop();
    nand_NvProgram(0,REC_FLASH_SIZE,aud_vm_rec_array);/*nand_NvProgram(0x64000,424288,s_voiceRxInBuffer)*/
}

#else
#define VOICE_MEMO_ARRAY_SIZE 32
//UINT32 rec_errdata_count = 0;
static VOID Voice_RecordAmrThreadEntry(SINT32 argu)
{
    /*must add for 7520 Online Record, lvwenhua 20150317*/

#if 0
    T_ZDrvVoice_BufInfo pVoiceDataInfo = {NULL} ;


    SINT32 ret=0;
    UINT32 LenTx=0;
    UINT8 *read_buf = NULL;
    UINT32 realbuffersize = 0;
    //UINT32 cur_recdatacount =0;
    UINT8  aud_vm_rec_array[VOICE_MEMO_ARRAY_SIZE] = {NULL} ;
    //UINT8 *record_buf = s_voiceRcdBuffer;

    while(1)
    {
        if(zOss_GetSemaphore(s_voiceOnlineRecSemID, ZOSS_WAIT_FOREVER) == ZOSS_SUCCESS)
        {
            //cur_recdatacount=0;
            rec_errdata_count	=0;
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"Voice_RecordAmrThreadEntry start!");
            while(s_voiceRecordStatus == VOICE_RECORD_INUSE)
            {
                voice_RecordDataRead(&pVoiceDataInfo);
                //add by xuxinqiang for last data deal
                if(s_voiceRecordStatus != VOICE_RECORD_INUSE)
                {
                    voice_FreeRcdBuf(pVoiceDataInfo.pBuf);
                    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice record state error s_voiceRecordStatus=%d!\n", s_voiceRecordStatus);

                    continue;
                }

                read_buf=(UINT8 *)pVoiceDataInfo.pBuf;
                realbuffersize = pVoiceDataInfo.bufferSize;
                if(*read_buf != 0x3c)
                {
                    rec_errdata_count++;
                    voice_FreeRcdBuf(pVoiceDataInfo.pBuf);
                    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice record data error errcount=%d!\n", rec_errdata_count);

                    continue;
                }

                if( realbuffersize>VOICE_MEMO_ARRAY_SIZE)
                {
                    realbuffersize=VOICE_MEMO_ARRAY_SIZE;
                }
#if 1
                zOss_Memcpy(aud_vm_rec_array, read_buf, realbuffersize);
                // zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"Voice_RecordAmrThreadEntry realbuffersize=%d\n!",realbuffersize);



                LenTx = zDrv_Write(AudUartFd, aud_vm_rec_array, realbuffersize);
#else

                zOss_Memcpy(record_buf, read_buf, realbuffersize);
                record_buf+=realbuffersize;
                cur_recdatacount+=realbuffersize;
                if(cur_recdatacount>=VOICE_MEMO_BUF_SIZE)
                {
                    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"record start DATA =%x,end DATA =%x!\n", *(record_buf-realbuffersize),*(record_buf-1));


                    record_buf=s_voiceRcdBuffer;
                    cur_recdatacount=0;
                    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"cur_recdatacount>=VOICE_MEMO_BUF_SIZE!\n");

                }
#endif
                //zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"Uart Tx LenTx=%d", LenTx);

                if (LenTx<=0)
                {
                    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"Uart Tx failed!len=%d", LenTx);
                }

                voice_FreeRcdBuf(pVoiceDataInfo.pBuf);
            }


            voice_InnerRcdStop();

            //zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"record cur_recdatacount=%d,realbuffersize=%d!\n", cur_recdatacount,realbuffersize);
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"voice record  total errdata_count=%d!\n", rec_errdata_count);


            //nand_NvProgram(0x400000,VOICE_MEMO_BUF_SIZE,s_voiceRcdBuffer);   /*record amr data*/


        }

    }

#endif
}
#endif


/*******************************************************************************
 * Function: voice_RcdStop
 * Description: This function is used to set while condition delete thread and stop uart write
 * Parameters:
 *   Input:None
 *
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
SINT32 voice_RcdStop(VOID)   /*add for 7502 Online Record*/
{

    SINT32 ret = DRV_SUCCESS;

    s_voiceRecordStatus = VOICE_RECORD_IDLE;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_RcdStop !\n");
    //zOss_Sleep(20);





    return ret;

}
#if 0//xiu
/*******************************************************************************
 * Function: voice_RcdStop
 * Description: This function is used to stop voice record.
 * Parameters:
 *   Input:None
 *
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_InnerRcdStop(VOID)
{

    SINT32 ret = 0;


    ret = AUD_vm_stop_recording((U8)s_voiceAudRecordHandler);
    if (ret != aud_rc_ok)
    {
        return DRV_ERROR;
    }

    //s_voiceRecordStatus = VOICE_RECORD_OPEN;



    /* release the handle of Record */
    ret =  AUD_release_resource((U8)s_voiceAudRecordHandler);
    s_voiceAudRecordHandler = 0;
    if (ret != aud_rc_ok)
    {
        return DRV_ERROR;
    }



    aud_voice_record_channel(MAX_VOICE_RECORD_CHANNEL);  /*add for 7502 Online Record*/

    //s_voiceRecordStatus = VOICE_RECORD_IDLE;
#if 0
    ret= zDrv_Close(AudUartFd);
    if (ret== DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"uart close OK! fd=%d", AudUartFd);
    }
    else
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"uart close failed! fd=%d", AudUartFd);
    }

#endif
    return ret;
}

/*******************************************************************************
 * Function: Voice_RecordDataRead
 * Description: This function is used to read voice record data.
 * Parameters:
 *   Input:pVoiceDataInfo: including the buffer size and the pointer of the buffer
 *
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_RecordDataRead(T_ZDrvVoice_BufInfo *pVoiceDataInfo)
{
    UINT32 i = 0;
    UINT32 rate = 0;
    UINT32 semCount = 0;
    if (pVoiceDataInfo == NULL)
    {
        return DRV_ERR_INVALID_PARAM;
    }

    if (zOss_GetSemaphore(s_voiceRecSemID, ZOSS_WAIT_FOREVER) == ZOSS_SUCCESS)
    {
        if (g_voiceRecDataBuf[0].isValid == 0)
        {
            rate = s_voiceRecRate;
            zOss_Memcpy(g_voiceRecDataBuf[0].recDataBuf, RECORD_DATA_PTR, rate);
            g_voiceRecDataBuf[0].isValid = 1;
            pVoiceDataInfo->bufferSize = rate;
            pVoiceDataInfo->pBuf = g_voiceRecDataBuf[0].recDataBuf;

            semCount = zOss_GetSemaphoreCount(s_voiceRecSemID);
            if (semCount > 0)
            {
                for (i = 0; i < semCount; i++)
                {
                    zOss_GetSemaphore(s_voiceRecSemID, ZOSS_NO_WAIT);
                }
            }

            return DRV_SUCCESS;
        }
        else if (g_voiceRecDataBuf[1].isValid == 0)
        {
            rate = s_voiceRecRate;
            zOss_Memcpy(g_voiceRecDataBuf[1].recDataBuf, RECORD_DATA_PTR, rate);
            g_voiceRecDataBuf[1].isValid = 1;
            pVoiceDataInfo->bufferSize = rate;
            pVoiceDataInfo->pBuf = g_voiceRecDataBuf[1].recDataBuf;

            semCount = zOss_GetSemaphoreCount(s_voiceRecSemID);
            if (semCount > 0)
            {
                for (i = 0; i < semCount; i++)
                {
                    zOss_GetSemaphore(s_voiceRecSemID, ZOSS_NO_WAIT);
                }
            }
            return DRV_SUCCESS;
        }
        else
        {
            semCount = zOss_GetSemaphoreCount(s_voiceRecSemID);
            if (semCount > 0)
            {
                for (i = 0; i < semCount; i++)
                {
                    zOss_GetSemaphore(s_voiceRecSemID, ZOSS_NO_WAIT);
                }
            }
            return DRV_ERROR;
        }


    }

    return DRV_ERROR;
}

/*******************************************************************************
 * Function: voice_FreeRcdBuf
 * Description: This function is used to free buffer.
 * Parameters:
 *   Input:pBuf: the address of the buffer
 *
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_FreeRcdBuf(VOID *pBuf)
{
    if (pBuf == NULL)
    {
        return DRV_ERR_INVALID_PARAM;
    }

    if (pBuf == g_voiceRecDataBuf[0].recDataBuf)
    {
        g_voiceRecDataBuf[0].isValid = 0;
    }
    else if (pBuf == g_voiceRecDataBuf[1].recDataBuf)
    {
        g_voiceRecDataBuf[1].isValid = 0;
    }
    else
    {
        return DRV_ERROR;
    }

    return DRV_SUCCESS;
}

#endif
/*********************************************************************************
 * Function: Voice_SetInstance
 * Description: This function is used to set the voice instance of hal layer.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 * Others:
 ********************************************************************************/

SINT32 zDrvVoice_Initiate(VOID)
{

    SINT32 ret = DRV_SUCCESS;

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"zDrvVoice_Initiate start!");

    zDrvVoice_SetOperations(&s_voiceObjOpt);
    //halHrdTstBaseVoice_Initiate();
    //halHrdTstVoice_Initiate();

    zDrvVoice_Init();
//#ifndef _USE_AUDIO_ON_7510
#if PS_RAT_GSM

    ret =Aud_TaskInt_Init();
    if(ret != ZOSS_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"zDrvVoice_Initiate: Aud_TaskInt_Init Fail, ret=%d!", ret);
        return ret;
    }
#endif
    return DRV_SUCCESS;
}

#ifdef _USE_HAL_HDTTST
/*******************************************************************************
 * Function: voice_GetPathMode
 * Description: This function is used to convert input and output path to path mode.
 * Parameters:
 *   Input:None
 *
 *   Output:None
 *
 * Returns: path mode
 *
 *
 * Others:
 ********************************************************************************/
static T_ZDrvVoice_PathMode voice_GetPathMode(VOID)
{
    T_ZDrvVoice_PathMode path = MAX_VOICE_PATH_MODE;

    if ((CODEC_INPUT_MICPHONE == s_voicePathin) && (CODEC_OUTPUT_RECEIVER == s_voicePathout))
    {
        path = VOICE_PATH_MODE_HANDSET;
    }
    else if ((CODEC_INPUT_MICPHONE == s_voicePathin) && (CODEC_OUTPUT_SPEAKER == s_voicePathout))
    {
        path = VOICE_PATH_MODE_SPEAKER;
    }
    else if ((CODEC_INPUT_HEADSET == s_voicePathin) && (CODEC_OUTPUT_HEADSET == s_voicePathout))
    {
        path = VOICE_PATH_MODE_HANDSET;
    }
    else if ((CODEC_INPUT_BLUETOOTH == s_voicePathin) && (CODEC_OUTPUT_BLUETOOTH == s_voicePathout))
    {
        path = VOICE_PATH_MODE_HANDSET;
    }
    else
    {
        path = MAX_VOICE_PATH_MODE;
    }

    return path;
}

/*******************************************************************************
* Function: voice_GetStatus
* Description: This function is called when enter voice parameter setting,
*               it is used to get voice path and working status.
* Parameters:
*   Input:
*      pIsWorking: The pointer to the voice working status
*      pPath: The pointer to the voice path mode
*
*   Output:
*      pIsWorking: the voice working status
*      pPath: the voice path mode
*
* Returns: 0:success
*          other:check T_ZDrv_ErrCode or hal error code
*
* Others:
********************************************************************************/
static SINT32 voice_GetStatus(BOOL *pIsWorking, T_ZDrvVoice_PathMode *pPath)
{
    if ((NULL == pIsWorking) || (NULL == pPath))
    {
        return DRV_ERR_INVALID_PARAM;
    }

    if (s_voiceStatus != VOICE_INUSE)
    {
        *pIsWorking = FALSE;
        *pPath = MAX_VOICE_PATH_MODE;
    }
    else
    {
        *pIsWorking = TRUE;
        *pPath = voice_GetPathMode();
    }

    return DRV_SUCCESS;
}

/*******************************************************************************
* Function: voice_SetTestCallback
* Description: This function is used to set callback function which will be called when voice status changes.
* Parameters:
*   Input: none
*   Output:None
*
* Returns: 0:success
*          DRV_ERR_NOT_SUPPORTED:not support
*
* Others:
********************************************************************************/
static VOID voice_SetTestCallback(T_ZDrvVoice_CallbackFunc cb)
{
    gHalHrdTst_Voice_TestCb = cb;
}

/*******************************************************************************
 * Function: voice_PmicLoop
 * Description: This function is used to test loop.
 * Parameters:
 *   Input:
 *          enable:T_ZDrvVoice_Switch type, enable or disable loopback.
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 voice_PmicLoop(T_ZDrvVoice_Switch enable)
{
    SINT32  ret = 0;
    /* SINT32 aud_pmic_handle = 0;

     aud_pmic_handle = gCodecHandle;
     if (aud_pmic_handle == 0)
     {
         return DRV_ERROR;
     }
    */
    if (enable == VOICE_ENABLE)
    {
#if PS_RAT_GSM        
        /*[Begin] decrease volume when loop to avoid howling.[lv.wenhua-2010/5/28]*/
        ret = AUD_set_master_volume(VOICE_LOOP_MASTER_VOLUME);
        if (ret != aud_rc_ok)
        {
            return DRV_ERROR;
        }
#endif        
        /*[End] [lv.wenhua-2010/5/28]*/
#ifdef _USE_CODEC_MC13783
        ret = halPmic_AudioVcodecSetConfig(aud_pmic_handle,
                                           DIGITAL_LOOPBACK);
        if (DRV_SUCCESS!= ret)
        {
            return DRV_ERROR;
        }

        ret = halPmic_AudioVcodecEnableBypass(aud_pmic_handle);
        if (DRV_SUCCESS!= ret)
        {
            return DRV_ERROR;
        }
#elif defined  _USE_CODEC_SNA9029

        ret = zDrvPmSna9029_AudioSetSideTone(gCodecHandle, SIDETONE_GAIN_0DB);
        if (DRV_SUCCESS!= ret)
        {
            return DRV_ERROR;
        }
#elif defined  _USE_CODEC_TLV3100
        ret = zDrvCodec_SetSideTone (gCodecHandle, TRUE);
        if (DRV_SUCCESS!= ret)
        {
            return DRV_ERROR;
        }
        /*added by miaolin 20130805*/
#elif defined _USE_CODEC_TLV3212
        ret = zDrvCodec_SetSideTone (gCodecHandle, TRUE);
        if (DRV_SUCCESS!= ret)
        {
            return DRV_ERROR;
        }
        /*added by miaolin 20130805*/
#endif
    }
    else
    {
#if PS_RAT_GSM

        /*[Begin] restore voice master volume when stop looping.[lv.wenhua-2010/5/28]*/
        ret = AUD_set_master_volume(VOICE_MASTER_VOLUME);
        if (ret != aud_rc_ok)
        {
            return DRV_ERROR;
        }
#endif        
        /*[End] [lv.wenhua-2010/5/28]*/
    }

    return DRV_SUCCESS;
}

/*******************************************************************************
* Function: voice_initpaths
* Description: Initialises the array holding active paths. Default paths are
*              added as well.
* Parameters:
*   Input: none
*   Output:None
*
* Returns: 0:success
*          DRV_ERR_NOT_SUPPORTED:not support
*
* Others:
********************************************************************************/
static SINT32 voice_initpaths(void)
{
#if PS_RAT_GSM
    aud_init_set_paths();
#endif

    return DRV_SUCCESS;
}



#endif







#if 0
/*******************************************************************************
 * Function: halHrdTstBaseVoice_Initiate
 * Description: This function is used to set the hardware test tools basevoice instance of hal layer.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 * Others:
 ********************************************************************************/

static SINT32 halHrdTstBaseVoice_Initiate(VOID)
{
#ifdef _USE_HAL_HDTTST
//    halHrdTstBaseVoice_SetOperations(&gHalHrdTst_BaseVoice_Opt);
#endif
    return DRV_SUCCESS;
}

/*******************************************************************************
 * Function: halHrdTstVoice_Initiate
 * Description: This function is used to set the hardware test tools voice instance of hal layer.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 * Others:
 ********************************************************************************/

static SINT32 halHrdTstVoice_Initiate(VOID)
{
#ifdef _USE_HAL_HDTTST
    halHrdTstVoice_SetOperations(&gHalHrdTst_Voice_Opt);
#endif
    return DRV_SUCCESS;
}
#endif
#ifdef _USE_VOICE_TEAKLIT_LOOP
static T_HalVoice_Block s_voice_Block =
{
        VOICE_SAMPLE_8K,
        CODEC_INPUT_HEADSET,
        CODEC_OUTPUT_HEADSET,
        VOICE_INPUT_VOL_LEVEL_3,
        VOICE_OUTPUT_VOL_LEVEL_5,
        {
            VOICE_MUTE_DISABLE,
            VOICE_UPLINK_AND_DOWNLINK
        }
};

static UINT16 *s_speech_amr_umts_ul_ctrl = NULL;
static UINT16 *s_speech_amr_umts_ul_data = NULL;
static UINT16 *s_speech_amr_umts_dl_data = NULL;

//#define reg32(addr)          (*(volatile unsigned long*)(addr))//xiu
#define LOOP_UMTS_UL_CTRL             (UINT16 *) (BASEADR_SM_INT + 1061 )
#define LOOP_UMTS_UL_DATA             (UINT16 *) (BASEADR_SM_INT + 1062 )
#define LOOP_UMTS_DL_DATA             (UINT16 *) (BASEADR_SM_INT + 1078 )

static ZOSS_SEMAPHORE_ID s_voiceLoopSemaphore = NULL;

static ZOSS_THREAD_ID voiceLoopThread;
static int s_voiceLoopTestEn = 0;




void hal_testVoiceRW(SINT32 CESHI)//xiu
{

    UINT8 ShareMemoData[32] = {0};
	while(1)
	{
        zOss_GetSemaphore(s_voiceLoopSemaphore, ZOSS_WAIT_FOREVER);

        while (s_voiceLoopTestEn == 1)
        {	

        zOss_Sleep(20);
        zOss_Memcpy(ShareMemoData, (UINT8*)s_speech_amr_umts_ul_data, sizeof(UINT8)*32);
        zOss_Memcpy((UINT8 *)s_speech_amr_umts_dl_data, ShareMemoData, sizeof(UINT8)*32);

    	}
	}
    //return 0;//xiu
}

static int  hal_testVoiceLoopEn(VOID)
{
    voiceLoopThread = zOss_CreateThread("voice_looptest", hal_testVoiceRW, 0, 1024*2, 15,  1, 1);

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "Voiceloop success!");

    return 0;
}

SINT32 zDrvVoice_LoopStart(VOID)
{
    SINT32 ret = DRV_SUCCESS;
    //UINT16 daiMode = 0;//xiu
	g_voiceVar.vpPath =VP_PATH_HEADSET; 

    //BYTE   bOutputPath     = CODEC_OUTPUT_RECEIVER;    /*Ͳ*/
    //BYTE   bInputPath      = CODEC_INPUT_MICPHONE;     /**/
    //BYTE   bOutputVal      = VOICE_OUTPUT_VOL_LEVEL_5; /**/ 

    s_speech_amr_umts_ul_ctrl = LOOP_UMTS_UL_CTRL;
    s_speech_amr_umts_ul_data = LOOP_UMTS_UL_DATA;
    s_speech_amr_umts_dl_data = LOOP_UMTS_DL_DATA;

    *s_speech_amr_umts_ul_ctrl = 7;

#if PS_RAT_GSM
    aud_dsp_umts_on(1);

    umac_amr_sync(2, 1, 80, 6);                 /*UP LINK*/
    umac_amr_sync(1, 1, 80, 6);                 /*DOWN LINK*/
#endif
    zOss_Sleep(5);

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVoice_LoopStart start!");

    if (NULL == s_voiceLoopSemaphore)
    {
        s_voiceLoopSemaphore = zOss_CreateSemaphore("voiceLoopSemaphore", 0);
    }

    hal_testVoiceLoopEn();
     zOss_Sleep(5);


	
    ret = voice_Open();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVoice_LoopStart  voice_Open err ret =%d \r\n",ret);
    }
    zOss_Sleep(5);

    ret =voice_SetPathOut(&s_voice_Block);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVoice_LoopStart  voice_SetPathOut err ret =%d \r\n",ret);
    }
	

    ret =voice_SetPathIn(&s_voice_Block);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVoice_LoopStart  voice_SetPathIn err ret =%d \r\n",ret);
    }
	
    ret =voice_SetVolOut(&s_voice_Block);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVoice_LoopStart  voice_SetVolOut err ret =%d \r\n",ret);
    }

    ret =voice_Enable();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVoice_LoopStart  voice_Enable err ret =%d \r\n",ret);
    }

	

        zOss_Sleep(5);
	

    //ret =voice_SetMute(&s_voice_Block);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVoice_LoopStart  voice_SetMute err ret =%d \r\n",ret);
    }
	
	s_voiceLoopTestEn = 1;	

    if (s_voiceLoopSemaphore != NULL)
    {
        zOss_PutSemaphore(s_voiceLoopSemaphore);
    }

	
    //enable loop
    //daiMode =3;
    //DSP_ASYNC_VB_DAI(&daiMode);




    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVoice_LoopStart end \r\n");
	
    return DRV_SUCCESS;	
}

SINT32 zDrvVoice_LoopStop(VOID)
{
    SINT32 ret = DRV_SUCCESS;
	s_voiceLoopTestEn = 0;		
    ret = voice_Disable();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVoice_LoopStop voice_Disable err ret =%d \r\n",ret);
    }
    ret = voice_Close();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVoice_LoopStop voice_Close err ret =%d \r\n",ret);
    }

#if PS_RAT_GSM
    aud_dsp_umts_on(0);	
#endif
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVoice_LoopStop end \r\n");


    return ret;
}

#endif
