/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    uicc_drv.h
 * File Mark:    
 * Description:  This header file contains timer and UART driver declarations.
 * Others:        
 * Version:       v1.0
 * Author:        mtr
 * Date:          2007-01-12
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ******************************************************************************/


#ifndef _UICC_DRV_H
#define _UICC_DRV_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_uicc.h"
/****************************************************************************
* 	                                        Macros
****************************************************************************/
#ifdef INTERRUPT_TRACE
  #define UICC_UART_OK_INT  0x1000
  #define UICC_UART_ERR_INT 0x2000
  #define UICC_IN_OUT_INT   0x3000
  #define UICC_DMA_INT      0x4000
  #define UICC_TIMER_INT    0x5000
  
  #define UICC_INTERRUPT_CNT_SIZE 30
#endif

/****************************************************************************
* 	                                        Types
****************************************************************************/

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/
#ifdef INTERRUPT_TRACE
    extern ulong  UICC_interrupt_trace[];
    extern ushort UICC_interrupt_cnt;  
#endif


/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
extern void UICC_init_card_interface(void);
extern void UICC_reset_card_interface(void);
extern void UICC_enable_card_interface(void);
extern void UICC_disable_card_interface(void);
extern void UICC_select_character_mode(void);
extern void UICC_select_T0_instruction_mode(void);
extern void UICC_switch_uart_clock_on(void);
extern void UICC_switch_uart_clock_off(void);
extern void UICC_select_direct_convention(void);
extern void UICC_select_inverse_convention(void);
extern void UICC_transmission_rate_control(ubyte brf_factor);
extern void UICC_set_rxtx_space(ubyte rxtx_space);
extern void UICC_set_txtx_space(ubyte txtx_space);

extern void UICC_start_auto_deactivation(void);
extern void UICC_end_auto_deactivation(void);

extern void UICC_activate_vcc(T_UICC_CARD_SELECTOR card_selector, 
                              T_UICC_VOLTAGE_CLASS voltage_class,
                              ubyte sequence_number);
extern void UICC_deactivate_vcc(T_UICC_CARD_SELECTOR card_selector);
extern void UICC_activate_rst(T_UICC_CARD_SELECTOR card_selector);
extern void UICC_deactivate_rst(T_UICC_CARD_SELECTOR card_selector);
extern void UICC_activate_clk(T_UICC_CARD_SELECTOR card_selector);
extern void UICC_deactivate_clk(T_UICC_CARD_SELECTOR card_selector);
extern void UICC_set_high_clock_stop_level(T_UICC_CARD_SELECTOR card_selector);
extern void UICC_set_low_clock_stop_level(T_UICC_CARD_SELECTOR card_selector);
extern void UICC_select_high_clock_freq(void);
extern void UICC_select_low_clock_freq(void);
extern void UICC_enable_io(T_UICC_CARD_SELECTOR card_selector);
extern void UICC_disable_io(T_UICC_CARD_SELECTOR card_selector);
extern void UICC_select_operative_card(T_UICC_CARD_SELECTOR card_selector);
extern void UICC_enable_parity_error_detection(void);
extern void UICC_disable_parity_error_detection(void);
extern void UICC_enable_character_retransmission(void);
extern void UICC_disable_character_retransmission(void);

extern void UICC_send_character(ubyte character);
extern ubyte UICC_get_character(void);

extern void UICC_commence_t0_command (ubyte p3, ubyte ins, T_UICC_CMD_DIR cmd);
extern T_UICC_CMD_RSP UICC_get_t0_command_response(void);

extern void UICC_enable_character_interrupt(void);
extern void UICC_disable_character_interrupt(void);
extern void UICC_enable_t0_end_interrupt(void);
extern void UICC_disable_t0_end_interrupt(void);
extern void UICC_enable_t1_end_interrupt(void);
extern void UICC_disable_t1_end_interrupt(void);
extern void UICC_enable_t1_bwt_interrupt(void);
extern void UICC_disable_t1_bwt_interrupt(void);
extern void UICC_enable_parity_error_interrupt(void);
extern void UICC_disable_parity_error_interrupt(void);
extern void UICC_enable_overrun_error_interrupt(void);
extern void UICC_disable_overrun_error_interrupt(void);
extern void UICC_enable_char_timeout_interrupt(void);
extern void UICC_disable_char_timeout_interrupt(void);

extern void UICC_set_bwt_timer(ulong timer_etu_value);
extern void UICC_start_bwt_timer(void);
extern void UICC_stop_bwt_timer(void);
extern void UICC_enable_bgt_timer(void);
extern void UICC_disable_bgt_timer(void);
extern void UICC_set_character_timer(ulong timer_etu_value);

extern void UICC_start_t1_mode(ubyte data_length);
extern void UICC_select_T1_tx_instruction_mode(void);
extern void UICC_select_T1_rx_instruction_mode(void);

extern ulong UICC_get_simstatus(void);  

#ifndef UICC_FIFO_ONLY
extern void UICC_dma_rx_control(ushort nof_bytes, ubyte *dest_ptr, T_UICC_DMA_FLOW_CONTROL flow_ctrl);
extern void UICC_dma_tx_control(ushort nof_bytes, ubyte *src_ptr, T_UICC_DMA_FLOW_CONTROL flow_ctrl);
extern void UICC_dma_disable_control(void);
extern ulong UICC_dma_get_transfer_cnt(void);
extern void UICC_enable_dma_channel(void);
#endif

extern void UICC_disable_dma_channel(void);

extern void UICC_enable_usim_ok_isr(void);
extern void UICC_disable_usim_ok_isr(void);
extern void UICC_enable_usim_err_isr(void);
extern void UICC_disable_usim_err_isr(void);
extern void UICC_enable_usim_in_isr(void);
extern void UICC_disable_usim_in_isr(void);

extern void UICC_usim_ok_lisr(void);
extern void UICC_usim_err_lisr(void);
extern void UICC_usim_in_out_lisr(void);
//extern void UICC_dma_lisr(INT vector_number);
extern void UICC_usim_fifo_lisr(void);


#ifdef UICC_ENABLE_IN_OUT_DETECTION 
  extern ubyte UICC_check_card_presence(void);
#endif

/*===============*/
/* TIMER drivers */
/*===============*/
extern void UICC_init_timer(void);
extern void UICC_stop_timer(void);
extern void UICC_start_timer(ulong microseconds);
extern void UICC_start_guard_timer(ushort usec);
extern void UICC_force_timeout(void);

#ifdef UICC_ENABLE_IN_OUT_DETECTION 
  void UICC_start_inout_timer(ulong usec);
  void UICC_stop_inout_timer(void);
#endif
extern void UICC_timeout_callback(void);

#ifdef UICC_ENABLE_IN_OUT_DETECTION 

 extern void UICC_in_out_timeout_callback(void);
#endif

/*===============*/
/* ISR */
/*===============*/
extern SINT32 UICC_InstallIsr(VOID *pIsr,UINT32 intLine);
extern SINT32 UICC_UninstallIsr(UINT32 intLine);
extern SINT32 UICC_PowerUp_1V8(VOID);
extern SINT32 UICC_PowerUp_2V9(VOID);
extern SINT32 UICC_PowerDown(VOID);

#endif /* _UICC_DRV_H */ 
                                                 /* End of file.              */
