/*******************************************************************************
* Ȩ (C)2014, ͨѶɷ޹˾
* 
* ļ:     oss_timer.c
* ļʶ:     oss_timer.c
* ժҪ:     OSS֧Ų㶨ʱʵģ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2014/07/15      V1.0        Create                    
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "oss_api.h"
#include "osa.h"
#include "sup.h"

#ifdef _OS_TOS
#include <cyg/kernel/kapi.h>
#include <pkgconf/kernel.h>
#elif defined (_OS_LINUX)
#include "drvs_timer.h"
#include <linux/kernel.h>
#include <linux/timer.h>
#include <linux/hrtimer.h>
#endif

#ifdef __cplusplus
extern "C" 
{
#endif

#if defined (_OS_OSE) || defined (_OS_TOS) || defined (_OS_LINUX)

/*******************************************************************************
*                                 ⲿ                                 *
*******************************************************************************/
#ifdef _USE_PSM
extern SINT32 zOss_PsmGetSleepFlag(VOID);
#endif

/*******************************************************************************
*                                 ⲿ                                 *
*******************************************************************************/
#ifdef _USE_PSM
# ifndef _USE_PSM_NEW_FRAMEWORK
extern UINT32 gPsm_SleepTime;
# endif
#endif

#endif  // #if defined (_OS_OSE) || defined (_OS_TOS)

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define TIMER_TICK              (ZOSS_MS_PER_TICK)
#define TIMER_SCHEDULE_THREAD   "Timer_ScheduleThread"
#define TIMER_SCHEDULE_STACK    (UINT32)4096

#ifdef _OS_LINUX
# define LINUX_OSS_HRTIMER       0
# define LINUX_OSS_DRV_TIMER     1
# define LINUX_KERNEL_TICK_TIMER 2
# define LINUX_OSS_TIMER        LINUX_KERNEL_TICK_TIMER
#endif

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/
#ifdef _OS_LINUX
static VOID Timer_InterruptRoutine(void);
#if (LINUX_OSS_TIMER == LINUX_OSS_HRTIMER)
static enum hrtimer_restart linux_oss_hrtimer_function(struct hrtimer *hrtimer);
#endif

#endif

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/
static BOOL                 gTimer_IsInit;
static UINT32               gTimer_Tick;
static T_TIMER_PARAM        *gpTimer_Param;
static T_ZOss_List          gTimer_IdleList;
static ZOSS_MUTEX_ID        gTimer_TimerMutex_ID;
static ZOSS_SEMAPHORE_ID    gTimer_TimerSem_ID;
static ZOSS_THREAD_ID       gTimer_SchThread_id;

#ifdef _OS_LINUX

#if (LINUX_OSS_TIMER == LINUX_OSS_HRTIMER)
static struct hrtimer linux_oss_hrtimer_id;
#elif (LINUX_OSS_TIMER == LINUX_OSS_DRV_TIMER)
static UINT32 linux_oss_drv_timer_id;
#elif (LINUX_OSS_TIMER == LINUX_KERNEL_TICK_TIMER)
static struct timer_list linux_oss_tick_timer_id;
static unsigned long linux_last_timer_jiffies;
#define KERNEL_TICK_PER_TIMER_TICK  1           /*One OSS timer tick is equal to how many kernel tick*/
#endif

#endif

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/
UINT64      gTimer_CurTime;
T_ZOss_List gTimer_UseList;

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

#ifdef _OS_LINUX

#if (LINUX_OSS_TIMER == LINUX_OSS_HRTIMER)
/*******************************************************************************
* :     linux֧Ų߷ֱʶʱص
* ˵:     
*   ()  hrtimer:    ߷ֱʶʱṹָ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static enum hrtimer_restart linux_oss_hrtimer_function(struct hrtimer *hrtimer)
{
    Timer_InterruptRoutine();

    hrtimer_forward_now(&linux_oss_hrtimer_id, ms_to_ktime(TIMER_TICK));

    return HRTIMER_RESTART;
}
#endif

#if (LINUX_OSS_TIMER == LINUX_KERNEL_TICK_TIMER)
/*******************************************************************************
* :     linuxں˶ʱص
* ˵:     
*   ()  data:
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void linux_oss_tick_timer_function(void)
{
	if(gTimer_IsInit) {
		Timer_InterruptRoutine();
		linux_last_timer_jiffies = jiffies;
	}
}
#endif

#endif

/*******************************************************************************
* :     ʱ
* ˵:     
*   ()  num:    еܽڵ
*   ()  void
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     void
*******************************************************************************/
static UINT32 Timer_CreateIdleNode(UINT32 num)
{
    T_TIMER_NODE    *pTimerNode = NULL;
    UINT32          node_len    = (sizeof(T_TIMER_NODE)+ sizeof(UINT32)-1) & ~(sizeof(UINT32)-1);
    UINT32          cnt         = 0;
    UINT32          nodeSize    = node_len * num;

    pTimerNode = (T_TIMER_NODE *)zOss_Malloc(nodeSize);
    zOss_AssertEx(NULL != pTimerNode, ZOSS_ERROR);

    zOss_Memset(pTimerNode, 0, nodeSize);

    for (cnt = 0; cnt < num; cnt++) 
    {
        zOss_ListAdd(&gTimer_IdleList, &pTimerNode->Node);
        pTimerNode = (T_TIMER_NODE *)((UINT32)pTimerNode + node_len);
    }

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ʱʹвһڵ
* ˵:     
*   ()  pTimerNode: Ķʱڵ
                time_len:   ʱڵԴʱ
*   ()  void
*   ֵ:     void
* ˵:     1. ڵʱҪʹڵ㰴վԴʱ;
                2. time_lenΪԴʱ䣬ҪϵǰʱΪԴʱ;
*******************************************************************************/
static VOID Timer_AddTimerNode(T_TIMER_NODE *pTimerNode, UINT32 time_len)
{
    T_TIMER_NODE *pNode = NULL;
    T_TIMER_NODE *pPrev = NULL;

    pTimerNode->ExpireTime = time_len + gTimer_CurTime;
    pTimerNode->Flag = TIMER_USE;

    pNode = (T_TIMER_NODE *)zOss_ListFirst(&gTimer_UseList);
    while (pNode != NULL && pTimerNode->ExpireTime >= pNode->ExpireTime) 
    {
        pPrev = pNode;
        pNode = (T_TIMER_NODE *)(pNode->Node.next);
    }
    zOss_ListInsert (&gTimer_UseList, (T_ZOss_Node *)pPrev, (T_ZOss_Node *)pTimerNode);
}

/*******************************************************************************
* :     ʱ߳
* ˵:     
*   ()  arg:    ߳
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static VOID Timer_SchThread(SINT32 arg)
{
    T_TIMER_NODE *pTimerNode = NULL;
    
    for(;;)
    {
        zOss_GetSemaphore(gTimer_TimerSem_ID, ZOSS_WAIT_FOREVER);
        zOss_GetMutex(gTimer_TimerMutex_ID, ZOSS_WAIT_FOREVER);
        
        pTimerNode = (T_TIMER_NODE*)zOss_ListFirst(&gTimer_UseList);
        while (pTimerNode != NULL && pTimerNode->ExpireTime <= gTimer_CurTime) 
        {
            pTimerNode->tm_callback(pTimerNode->tm_param);
            
            if (pTimerNode->Flag == TIMER_USE && pTimerNode->ExpireTime <= gTimer_CurTime) 
            {
                zOss_ListDelete(&gTimer_UseList, &pTimerNode->Node);
                pTimerNode->Flag = TIMER_SUSPEND;
                
                if (pTimerNode->bPeriod)
                {
                    Timer_AddTimerNode(pTimerNode, (UINT32)pTimerNode->TimeLength);
                }
            }
            
            pTimerNode = (T_TIMER_NODE*)zOss_ListFirst(&gTimer_UseList);
        }
        
        zOss_PutMutex(gTimer_TimerMutex_ID);
    }
}

/*******************************************************************************
* :     ϵͳʱ˺ͷźԻѶʱ߳
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
#if defined (_OS_OSE) || defined (_OS_TOS) || defined (_OS_LINUX)
static VOID Timer_InterruptRoutine(void)
#elif defined _OS_WIN
static VOID CALLBACK Timer_InterruptRoutine(UINT wtimerid, UINT msg, DWORD dwuser, DWORD dw1, DWORD dw2)
#endif
{
    T_TIMER_NODE *pTimerNode = NULL;
#if defined (_OS_OSE) || defined (_OS_TOS) || defined (_OS_LINUX)
# ifdef _USE_PSM
#  ifndef _USE_PSM_NEW_FRAMEWORK
    SINT32 PsmFlag  = 0;
#  endif
# endif
#endif

#ifdef _OS_LINUX
UINT32 delta;
#endif

#ifdef _OS_LINUX
#if (LINUX_OSS_TIMER == LINUX_KERNEL_TICK_TIMER)
	if(linux_last_timer_jiffies > jiffies)
		delta = ((0xFFFFFFFF - linux_last_timer_jiffies + jiffies + 1)*(1000/HZ));
	else
		delta = ((jiffies - linux_last_timer_jiffies)*(1000/HZ));
#endif
    gTimer_CurTime += delta;
#else
	gTimer_CurTime += gTimer_Tick;
#endif

#if defined (_OS_OSE) || defined (_OS_TOS) || defined (_OS_LINUX)

# ifdef _USE_PSM
#  ifdef _USE_PSM_NEW_FRAMEWORK
    zOss_ClearSleepTime();
#  else
    PsmFlag = PSM_NO_SLEEP;
    if(gPsm_SleepTime > 0)
    {
        gPsm_SleepTime = 0;
    }
    PsmFlag = zOss_PsmGetSleepFlag();
    if((PSM_NO_SLEEP == PsmFlag) || (PSM_KENEL_SLEEP == PsmFlag))
    {
        zOss_PsmClearArm1SleepTime();
    }
#  endif

# endif

#endif
    
    pTimerNode = (T_TIMER_NODE*)zOss_ListFirst(&gTimer_UseList);
    if (pTimerNode != NULL && pTimerNode->ExpireTime <= gTimer_CurTime)
    {
        zOss_PutSemaphore(gTimer_TimerSem_ID);
    }
}

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

/*******************************************************************************
* : Osa_GetTimerInitStatus
* : ضʱģĳʼ״̬
* ˵: 
*   ֵ: 
* ˵:
*******************************************************************************/
BOOL Osa_GetTimerInitStatus(VOID)
{
    return gTimer_IsInit;
}

/*******************************************************************************
* :     ʱ,zOss_StartTimer()ʱ
* ˵:     
*   ()  tm_name:        δʹ
                tm_callback:    ʱҪõĻص
                tm_param:       ص
                bPeriod:        TRUE:Զʱ;
                                FALSE:Զʱ
*   ()  void
*   ֵ:     ɹ:ӦĶʱʶ; ʧ:ZOSS_INVALID_TIMER_ID
* ˵:     صִʱڶʱʱ,ɴʱӳ;
                صвֱӻӵԽӿڣzOss_Sleep
*******************************************************************************/
ZOSS_TIMER_ID zOss_CreateTimer(const CHAR       *tm_name,
                               ZOSS_TIMER_FUN   tm_callback,
                               SINT32           tm_param,
                               BOOL             bPeriod)
{
    T_TIMER_NODE    *pTimerNode = NULL;
    
    zOss_AssertEx(tm_callback != NULL, ZOSS_INVALID_TIMER_ID);

    zOss_GetMutex(gTimer_TimerMutex_ID, ZOSS_WAIT_FOREVER);
    pTimerNode = (T_TIMER_NODE *)zOss_ListFirst(&gTimer_IdleList);
    zOss_ASSERT(pTimerNode != ZOSS_INVALID_TIMER_ID);
    if (pTimerNode == ZOSS_INVALID_TIMER_ID) 
    {
        zOss_PutMutex(gTimer_TimerMutex_ID);
        return ZOSS_INVALID_TIMER_ID;
    }
    zOss_ListDelete(&gTimer_IdleList, &pTimerNode->Node);
    zOss_PutMutex(gTimer_TimerMutex_ID);
    
    pTimerNode->Flag        = TIMER_SUSPEND;    /* ״̬Ϊֹ̬ͣ */
    pTimerNode->tm_callback = tm_callback;      /* ص     */    
    pTimerNode->tm_param    = tm_param;         /* ص */
    pTimerNode->bPeriod     = bPeriod;          /* Ըֵ   */
#ifdef _USE_PSM
    pTimerNode->psmFlag     = FALSE;
#endif
    return (ZOSS_TIMER_ID)pTimerNode;
}

/*******************************************************************************
* :     ʱ, ʱΪο,ָʱ,ûص
* ˵:     
*   ()  timer_id:       ʱID
                time_len:       ʱʱ
                tm_callback:    ʱҪõĻص
                tm_param:       ص
*   ()  void
*   ֵ:     ɹ:ZOSS_SUCCESS;ʧZOSS_ERROR
* ˵:     صִʱڶʱʱ,ܻɴʱȷ
*******************************************************************************/
UINT32 zOss_StartTimer(ZOSS_TIMER_ID   timer_id,
                       UINT32          time_len,
                       ZOSS_TIMER_FUN  tm_callback,
                       SINT32          tm_param)
{
    T_TIMER_NODE *pTimerNode = NULL;
    
    zOss_AssertEx(timer_id != NULL && time_len >= gpTimer_Param->MinTimeLen, ZOSS_ERROR);
    
    time_len    = (time_len + gTimer_Tick - 1) & ~(gTimer_Tick - 1);
    pTimerNode  = (T_TIMER_NODE *)timer_id;
    
    zOss_GetMutex(gTimer_TimerMutex_ID, ZOSS_WAIT_FOREVER);
    
    if (pTimerNode->Flag == TIMER_USE) 
    {
        zOss_ListDelete(&gTimer_UseList, (T_ZOss_Node *)pTimerNode);
        pTimerNode->Flag = TIMER_SUSPEND;
    }
    
    if (pTimerNode->Flag != TIMER_SUSPEND) 
    {
        zOss_PutMutex(gTimer_TimerMutex_ID);
        return ZOSS_ERROR;
    }
    
    if (tm_callback != NULL) 
    {
        if (pTimerNode->attached != NULL)
        {
            zOss_PutMutex(gTimer_TimerMutex_ID);
            return ZOSS_ERROR;
        }
        pTimerNode->tm_callback = tm_callback;
        pTimerNode->tm_param	= tm_param;
    }
    pTimerNode->TimeLength = time_len;
    pTimerNode->RemainTime = 0;

    Timer_AddTimerNode(pTimerNode, (UINT32)pTimerNode->TimeLength);

    zOss_PutMutex(gTimer_TimerMutex_ID);

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ֹͣʱļʱzOss_StartTimer()¿ʼʱ
                ʱڱ,ִ굱ǰȺֹͣʱ
* ˵:     
*   ()  timer_id:   ʱID
*   ()  void
*   ֵ:     ɹ:ZOSS_SUCCESS; ʧ:ZOSS_ERROR
* ˵:     void
*******************************************************************************/
UINT32 zOss_StopTimer(ZOSS_TIMER_ID timer_id)
{
    T_TIMER_NODE *pTimerNode = NULL;

    zOss_AssertEx(timer_id != NULL, ZOSS_ERROR);

    pTimerNode = (T_TIMER_NODE *)timer_id;
    
    zOss_GetMutex(gTimer_TimerMutex_ID, ZOSS_WAIT_FOREVER);

    if (pTimerNode->Flag != TIMER_USE) 
    {
        zOss_PutMutex(gTimer_TimerMutex_ID);
        return ZOSS_ERROR;
    }
    
    zOss_ListDelete(&gTimer_UseList, &pTimerNode->Node);
    
    pTimerNode->Flag        = TIMER_SUSPEND;
    pTimerNode->RemainTime  = pTimerNode->TimeLength;

    zOss_PutMutex(gTimer_TimerMutex_ID);

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ָͣʱļʱ,¼ʣʱ; 
                zOss_ResumeTime()ʱ
                ʱڱ,ִ굱ǰȺͣʱ
* ˵:     
*   ()  timer_id:   ʱID
*   ()  void
*   ֵ:     ɹ:ZOSS_SUCCESS; ʧ:ZOSS_ERROR
* ˵:     void
*******************************************************************************/
UINT32 zOss_PauseTimer(ZOSS_TIMER_ID timer_id)
{
    T_TIMER_NODE *pTimerNode = NULL;
    
    zOss_AssertEx(timer_id != NULL, ZOSS_ERROR);
    
    pTimerNode = (T_TIMER_NODE *)timer_id;
    
    zOss_GetMutex(gTimer_TimerMutex_ID, ZOSS_WAIT_FOREVER);
    
    if (pTimerNode->Flag != TIMER_USE) 
    {
        zOss_PutMutex(gTimer_TimerMutex_ID);
        return ZOSS_ERROR;
    }
    
    zOss_ListDelete(&gTimer_UseList, &pTimerNode->Node);
    
    pTimerNode->Flag = TIMER_SUSPEND;
    
    if (pTimerNode->ExpireTime > gTimer_CurTime)
    {
        pTimerNode->RemainTime = pTimerNode->ExpireTime - gTimer_CurTime;
    }
    else
    {
        pTimerNode->RemainTime = gpTimer_Param->MinTimeLen;
    }
    
    zOss_PutMutex(gTimer_TimerMutex_ID);
    
    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ʹͣĶʱʱ
* ˵:     
*   ()  timer_id:   ʱID
*   ()  void
*   ֵ:     ɹ:ZOSS_SUCCESS; ʧ:ZOSS_ERROR
* ˵:     void
*******************************************************************************/
UINT32 zOss_ResumeTimer(ZOSS_TIMER_ID timer_id)
{
    T_TIMER_NODE *pTimerNode = NULL;

    zOss_AssertEx(timer_id != NULL, ZOSS_ERROR);

    pTimerNode = (T_TIMER_NODE *)timer_id;
    
    zOss_GetMutex(gTimer_TimerMutex_ID, ZOSS_WAIT_FOREVER);

    if (pTimerNode->Flag != TIMER_SUSPEND || pTimerNode->RemainTime == 0)
    {
        zOss_PutMutex(gTimer_TimerMutex_ID);
        return ZOSS_ERROR;
    }

    Timer_AddTimerNode(pTimerNode, (UINT32)pTimerNode->RemainTime);
    
    pTimerNode->RemainTime = 0;
    
    zOss_PutMutex(gTimer_TimerMutex_ID);

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ɾָʱ
* ˵:     
*   ()  timer_id:    ʱID
*   ()  void
*   ֵ:     ɹ:ZOSS_SUCCESS; ʧ:ZOSS_ERROR
* ˵:     void
*******************************************************************************/
UINT32 zOss_KillTimer(ZOSS_TIMER_ID timer_id)
{
    T_TIMER_NODE    *pTimerNode = NULL;
    UINT32          node_len    = (sizeof(T_TIMER_NODE) + 3) & ~3;
    
    zOss_AssertEx(timer_id != NULL, ZOSS_ERROR);
    
    pTimerNode = (T_TIMER_NODE *)timer_id;
    
    zOss_GetMutex(gTimer_TimerMutex_ID, ZOSS_WAIT_FOREVER);
    
    if (pTimerNode->Flag != TIMER_USE && pTimerNode->Flag != TIMER_SUSPEND) 
    {
        zOss_PutMutex(gTimer_TimerMutex_ID);
        return ZOSS_ERROR;
    }
    
    if (pTimerNode->Flag == TIMER_USE)
    {
        zOss_ListDelete(&gTimer_UseList, (T_ZOss_Node *)pTimerNode);
    }
    
    if (pTimerNode->attached != NULL)
    {
        zOss_Free(pTimerNode->attached);
    }
    
    zOss_Memset(pTimerNode, 0, node_len);
    
    zOss_ListAdd(&gTimer_IdleList, (T_ZOss_Node *)pTimerNode);
    
    zOss_PutMutex(gTimer_TimerMutex_ID);
    
    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ȡʱϢ
* ˵:     
*   ()  void
*   ()  pMonTimerInfo: ʱϢŵַ
*   ֵ:     void
* ˵:     ˺ڴռ䣬ʹͷţڴй¶
*******************************************************************************/
VOID zOss_GetTimerInfo(T_ZOss_Mon_Timer *pMonTimerInfo)
{
#ifdef _USE_MONITOR
    T_ZOss_Mon_Timer timerInfo  = {0};
    T_TIMER_NODE    *pNode      = NULL;
    UINT32          cnt         = 0;

    if (pMonTimerInfo == NULL)
    {
        return;
    }

    if (ZOSS_SUCCESS == zOss_GetMutex(gTimer_TimerMutex_ID, ZOSS_WAIT_FOREVER))
    {
        pNode = (T_TIMER_NODE *)zOss_ListFirst(&gTimer_UseList);
        while (pNode != NULL)
        {    
            cnt++;
            pNode = (T_TIMER_NODE *)(pNode->Node.next);
        }

        if (cnt == 0)
        {
            pMonTimerInfo->num = 0;
            pMonTimerInfo->ele = NULL;
            zOss_PutMutex(gTimer_TimerMutex_ID);
            return;
        }

        timerInfo.ele = (T_ZOss_Mon_Timer_Ele *)zOss_GetUB(cnt * sizeof(T_ZOss_Mon_Timer_Ele));
        zOss_AssertExN(timerInfo.ele != NULL);

        cnt = 0;
        pNode = (T_TIMER_NODE *)zOss_ListFirst(&gTimer_UseList);
        while (pNode != NULL)
        {
            timerInfo.ele[cnt].start_time       = (UINT32)(pNode->ExpireTime - pNode->TimeLength);
            timerInfo.ele[cnt].expire_time      = (UINT32)pNode->ExpireTime;
            timerInfo.ele[cnt].callback_func    = (UINT32)pNode->tm_callback;
            timerInfo.ele[cnt].is_period        = (unsigned char)pNode->bPeriod;
            timerInfo.ele[cnt++].handle         = (UINT32)((ZOSS_TIMER_ID)pNode);
            pNode = (T_TIMER_NODE *)(pNode->Node.next);
        }
        zOss_PutMutex(gTimer_TimerMutex_ID);

        pMonTimerInfo->num = cnt;
        pMonTimerInfo->ele = timerInfo.ele;
    }
#endif
}

/*******************************************************************************
* :     ʼʱģ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
UINT32 TIMER_Init(VOID)
{
    T_OSS_PARAM *pOssParam = NULL;
#ifdef _OS_WIN
    UINT        waccuracy;
    TIMECAPS    tc;
#endif
    
    if (!gTimer_IsInit) 
    {
        gTimer_Tick     = TIMER_TICK;
        
        pOssParam       = zOss_GetOssCfg();
        gpTimer_Param   = &(pOssParam->TimerCfg);
        
        zOss_ListInit(&gTimer_UseList);
        zOss_ListInit(&gTimer_IdleList);
  
        zOss_AssertEx(Timer_CreateIdleNode(gpTimer_Param->MaxTimeNum) == ZOSS_SUCCESS, ZOSS_ERROR);

        gTimer_TimerMutex_ID = zOss_CreateMutex("TIMER_LIST_MUTEX", ZOSS_INHERIT);
        zOss_AssertEx(gTimer_TimerMutex_ID != NULL, ZOSS_ERROR);

        gTimer_TimerSem_ID = zOss_CreateSemaphore("TIMER_LIST_SEM", 0);
        zOss_ASSERT(gTimer_TimerSem_ID != NULL);
        if (gTimer_TimerSem_ID == NULL) 
        {
            zOss_DeleteMutex(gTimer_TimerMutex_ID);
            gTimer_TimerMutex_ID = NULL;
            return ZOSS_ERROR;
        }

        gTimer_SchThread_id = zOss_CreateThread(TIMER_SCHEDULE_THREAD,   /* name                 */
                                                Timer_SchThread,         /* entry                */
                                                0,                       /* arguments pointer    */
                                                TIMER_SCHEDULE_STACK,    /* stack size           */
                                                gpTimer_Param->SchPrio,  /* priority             */
                                                1,                       /* useless              */
                                                1);                      /* auto start           */
        zOss_ASSERT(gTimer_SchThread_id != NULL);
        if (gTimer_SchThread_id == NULL) 
        {
            zOss_DeleteMutex(gTimer_TimerMutex_ID);
            gTimer_TimerMutex_ID = NULL;
            zOss_DeleteSemaphore(gTimer_TimerSem_ID);
            gTimer_TimerSem_ID = NULL;
            return ZOSS_ERROR;
        }

#ifdef _OS_OSE
        zOss_Sleep(100);    /* öʱ߳ */
        
        /* ҽж, */
        /* ʱOSEtimer process */
        start(create_process(OS_TI_PROC, 
                             "OSA_TIMER_ISR", 
                             (OSENTRYPOINT *)Timer_InterruptRoutine, 
                             (OSADDRESS)200,
                             (OSPRIORITY)0, 
                             (OSTIME)gTimer_Tick, 
                             (PROCESS)0, 
                             (struct OS_redir_entry *) NULL,  
                             (OSVECTOR) 0, 
                             (OSUSER) 0));
                             
#elif defined (_OS_WIN)
        zOss_Sleep(100);    /* öʱ߳ */
        
        /* ҽж, */
        if (timeGetDevCaps(&tc, sizeof(TIMECAPS)) != TIMERR_NOERROR)
        {
            zOss_ASSERT(0);
        }

        /* ֱʵֵܳϵͳȡֵΧ */
        waccuracy = min(max(tc.wPeriodMin, gTimer_Tick), tc.wPeriodMax);

        if (TIMERR_NOERROR != timeBeginPeriod(waccuracy))    /* timebeginperiodöʱķֱ */
        {
            zOss_ASSERT(0);
        }

        /* װ1붨ʱ */
        if (0 == timeSetEvent(waccuracy, waccuracy, (LPTIMECALLBACK)Timer_InterruptRoutine, (DWORD)NULL, TIME_PERIODIC))
        {
            zOss_ASSERT(0);
        }
#elif defined (_OS_LINUX)

# if (LINUX_OSS_TIMER == LINUX_OSS_HRTIMER)
        hrtimer_init(&linux_oss_hrtimer_id, CLOCK_MONOTONIC, HRTIMER_MODE_REL);
        linux_oss_hrtimer_id.irqsafe  = 1;
        linux_oss_hrtimer_id.function = linux_oss_hrtimer_function;
        hrtimer_start(&linux_oss_hrtimer_id, ms_to_ktime(TIMER_TICK), HRTIMER_MODE_REL);
# elif (LINUX_OSS_TIMER == LINUX_OSS_DRV_TIMER)
        linux_oss_drv_timer_id = (UINT32)zDrvTimer_Create(Timer_InterruptRoutine, TRUE);
        zDrvTimer_Start(linux_oss_drv_timer_id, 1000);
# elif (LINUX_OSS_TIMER == LINUX_KERNEL_TICK_TIMER)
        //setup_timer(&linux_oss_tick_timer_id,linux_oss_tick_timer_function,0);
        //linux_oss_tick_timer_id.expires = jiffies + KERNEL_TICK_PER_TIMER_TICK;
        linux_last_timer_jiffies = jiffies;
        //add_timer(&linux_oss_tick_timer_id);
# endif

#endif

        gTimer_IsInit = TRUE;
    }

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     TOS 3.0ϵͳʱжdsr̵ĹӺ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
#if defined (_OS_TOS) && defined (CYGOPT_KERNEL_EXTEND_CLOCK_DSR)
void tos_clock_dsr(void)
{
    if (gTimer_IsInit) 
    {
        Timer_InterruptRoutine();

#ifdef _USE_CPU_DFM
# ifdef _USE_PSM_NEW_FRAMEWORK
        zOss_DfmIntRoutine();
# else
        PSM_CpuIntRoutine();
# endif
#endif
    }
}
#endif  // #if defined (_OS_TOS) && defined (CYGOPT_KERNEL_EXTEND_CLOCK_DSR)

#ifdef _USE_PSM
/**************************************************************************
* : zOss_SetTimer_PsmFlag
* : öʱ߱־
* ˵: (IN)
            time_id:ʱid
            Flag:flag
            (OUT)
*   ֵ: 
* ˵: 
**************************************************************************/
VOID zOss_SetTimer_PsmFlag(ZOSS_TIMER_ID time_id, BOOL Flag)
{
    T_TIMER_NODE    *pTimerNode = NULL;

    zOss_AssertExN(time_id != NULL);
    pTimerNode  = (T_TIMER_NODE *)time_id;
    pTimerNode->psmFlag = Flag;
}

/**************************************************************************
* : zOss_GetPs_SleepTimer
* : ȡǰʱ̵絽Эջʡ綨ʱʱ(λms)
* ˵: (IN)
            (OUT)
*   ֵ: ʱΪ:ǰʱ̵絽ڶʱʱ; Ϊ:ZOSS_WAIT_FOREVER
* ˵:
**************************************************************************/
UINT32 zOss_GetPs_SleepTimer(VOID)
{
    T_TIMER_NODE    *pNode          = NULL;
    UINT64          remainedTime    = 0;
    ZOSS_INTR       old_intr;

    ZOSS_SAVE_IRQ(old_intr);
    pNode = (T_TIMER_NODE *)zOss_ListFirst(&gTimer_UseList);
    
    while(pNode != NULL)
    {
        if(pNode->psmFlag)
        {
        	if(pNode->ExpireTime <= gTimer_CurTime)
				remainedTime = 0;
			else
            	remainedTime = pNode->ExpireTime - gTimer_CurTime;
			
            ZOSS_RESTORE_IRQ(old_intr);
            return ((UINT32)remainedTime);
        }
        pNode = (T_TIMER_NODE *)zOss_ListNext(&pNode->Node);
    }
    ZOSS_RESTORE_IRQ(old_intr);
    return ZOSS_WAIT_FOREVER;
}

/**************************************************************************
* : zOss_TimerCompensate
* : ֧ŲʱᲹ(λms)
* ˵: (IN)
            sleepTime:˯ʱ
            (OUT)
*   ֵ: 
* ˵: ʡģ
**************************************************************************/
VOID zOss_TimerCompensate(UINT32 sleepTime)
{
#if defined(_OS_LINUX) && (LINUX_OSS_TIMER == LINUX_KERNEL_TICK_TIMER)
    UINT32 delta;

	if(linux_last_timer_jiffies > jiffies)
		delta = ((0xFFFFFFFF - linux_last_timer_jiffies + jiffies + 1)*(1000/HZ));
	else
		delta = ((jiffies - linux_last_timer_jiffies)*(1000/HZ));

    gTimer_CurTime += delta;
	linux_last_timer_jiffies = jiffies;
#else
    gTimer_CurTime += sleepTime;
#endif
}

#endif

#ifdef __cplusplus
}
#endif

