/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : ose_card.c
*    : ose_card.c
* ļ : 
* ʵֹ : uģ
*      : 
*      : V1.0
*  : 2010/10/08
* ˵ :          
**************************************************************************/
/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : junkuiZhao
* ޸ : 2012/09/15
* ޸ : PC-LINTڱ淶޸ EC: 617001781881  
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : junkuiZhao
* ޸ : 2012/10/10
* ޸ : ߲ EC: 617001781957
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/stat.h>
#include "ose.h"
#include "ose_err.h"
#include "osetypes.h"
#include "assert.h"
#include "stdlib.h"
#include "efs.h"
#include "efs_err.h"
#include "efs.sig"
#include "fss.sig"
#include "ddb.sig"
#include "cpu.h"
#include "ramlog.h"
#include "sysparam.h"
#include "oss_api.h"
#include "Hal_fsms.h"

#ifdef __cplusplus
extern "C"
{
#endif
/**************************************************************************
* 
**************************************************************************/
#define DDBUNIT             2
#define DDBNAME             "udisk"
#define DDBWHAT             "EFS udisk ddb"
#define BIOSHANDLE          0   /* Bios/trap interface not used. */
#define BLOCK_SIZE          512

#ifndef UDISK_MAX_CLIENTS
#define UDISK_MAX_CLIENTS   4
#endif

#define DISCNUM             0

/**************************************************************************
* ݽṹ
**************************************************************************/ 

typedef union SIGNAL 
{
    SIGSELECT sigNo;
} T_ZOsa_Card_Signal;

typedef struct 
{
    PROCESS     pid;
    OSATTREF    attref;
    UINT32      low_blk;
    UINT32      high_blk;
} T_ZOsa_Card_Client;

typedef struct 
{
    PROCESS             fss_pid;
    OSATTREF            fss_attref;
    UINT32              num_blks;   /* udisk size   */
    T_ZOsa_Card_Client  clients[UDISK_MAX_CLIENTS];
    int                 fd;
} T_ZOsa_Card_State;

/**************************************************************************
* ֲ̬
**************************************************************************/

/**************************************************************************
* ȫֱ
**************************************************************************/

/************************************************************************** 
* ⲿ
**************************************************************************/   

/**************************************************************************  
* ⲿ
**************************************************************************/
//Ӧͷļ
extern FS_MS_ERROR_TYPE FS_MS_GetGeometry( unsigned int DiscNR, 
                                           unsigned int *total_lba, 
                                           unsigned int* sector_size);

extern PROCESS create_and_supervise( const char *name,
                                     OSENTRYPOINT *entrypoint,
                                     OSADDRESS stacksize,
                                     OSPRIORITY priority,
                                     OSATTREF *attref);

/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* ƣstatic UINT32 udisk_number_clients(const T_ZOsa_Card_State *st)
* udiskаװĿͻ(ĳļϵͳ)
* ˵(IN)    st  udisk״̬ṹָ
            (OUT)   VOID
*   ֵudiskѾmountļϵͳ
* ˵VOID
**************************************************************************/
static UINT32 udisk_number_clients(const T_ZOsa_Card_State *st)
{
    UINT32 cnt    = 0;
    UINT32 count  = 0;

    zOss_AssertEx(st != NULL, 0);

    for (; cnt < UDISK_MAX_CLIENTS; cnt++)
    {
        if (st->clients[cnt].pid != 0)
        {
            count++;
        }
    }

    return count;
}

/**************************************************************************
* ƣstatic T_ZOsa_Card_Client   *udisk_find_match(T_ZOsa_Card_State *st,
                                                   PROCESS pid,
                                                   UINT32 low_blk,
                                                   UINT32 high_blk)
* udiskѾװĿͻУָļϵͳ߳idźָblockΧ
            ļϵͳ
* ˵(IN)    st: udisk״̬ṹָ
                    pid: ļϵͳĹ߳id
                    low_blk: Сblock
                    high_blk: block
            (OUT)   VOID
*   ֵҵļϵͳͻ
* ˵VOID
**************************************************************************/
static T_ZOsa_Card_Client   *udisk_find_match( T_ZOsa_Card_State *st,
                                        PROCESS pid,
                                        UINT32 low_blk,
                                        UINT32 high_blk )
{
    UINT32              cnt     = 0;
    T_ZOsa_Card_Client *client  = NULL;

    zOss_ASSERT(low_blk <= high_blk);

    zOss_AssertEx(st != NULL, NULL);

    for (; cnt < UDISK_MAX_CLIENTS; cnt++)
    {
        client = &st->clients[cnt];

        if (client->pid != 0 &&
            pid == client->pid &&
            low_blk >= client->low_blk &&
            high_blk <= client->high_blk)
        {
            return client;
        }
    }

    return NULL;
}

/**************************************************************************
* ƣstatic VOID udisk_init_state(T_ZOsa_Card_State *st)
* ʼudisk״̬ṹ
* ˵(IN)    st  ʼudisk״̬ṹָ
            (OUT)   VOID
*   ֵVOID
* ˵VOID
**************************************************************************/
static VOID udisk_init_state(T_ZOsa_Card_State *st)
{
    UINT32 total_lba      = 0;
    UINT32 sector_size    = 0;
    
    T_ZOsa_Card_Signal *sig = alloc(sizeof(SIGSELECT), HUNT_FSS);
    
    zOss_AssertExN(st != NULL);

    hunt("ose_fss", 0, NULL, &sig);

    zOss_Memset(st, 0, sizeof(*st));

    FS_MS_GetGeometry(DISCNUM, (unsigned int *)&total_lba, (unsigned int *)&sector_size);

    st->num_blks = total_lba;
    
}

/**************************************************************************
* ƣstatic BOOL udisk_read_block(const T_ZOsa_Card_State *st,
                                            UINT32 blk_nr,
                                            UINT32 *dest_addr)
* udiskжȡһblockڴַ:dest_addr
* ˵(IN)    st:udisk״̬ṹָ
                    blk_nr:ȡblock
                    dest_addr:Ŀĵַ
            (OUT)   VOID
*   ֵȡɹTRUE򷵻FALSE
* ˵VOID
**************************************************************************/
static BOOL udisk_read_block( const T_ZOsa_Card_State *st,
                              UINT32 blk_nr,
                              UINT32 num_blks,
                              UINT32 *dest_addr )
{        
    if( FS_MS_OK == hal_FsMs_Read(DISCNUM, (UINT32)blk_nr, num_blks, (VOID * )dest_addr))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

/**************************************************************************
* ƣstatic BOOL udisk_write_block(const T_ZOsa_Card_State *st,
                                             UINT32 blk_nr,
                                             const UINT32 *src_addr)
* һڴblockдudisk
* ˵(IN)    st:udisk״̬ṹָ
                    blk_nr:дudiskblock
                    src_addr:Դַ
            (OUT)   VOID
*   ֵдɹTRUE򷵻FALSE
* ˵VOID
**************************************************************************/
static BOOL udisk_write_block( const T_ZOsa_Card_State *st,
                               UINT32 blk_nr,
                               UINT32 num_blks,
                               const UINT32 *src_addr )
{
    if( FS_MS_OK == hal_FsMs_Write(DISCNUM , (UINT32) blk_nr, num_blks, (const VOID *) src_addr))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

/**************************************************************************
* ƣstatic VOID udisk_examine_disk(struct DdbExamineDiskRequest *req,
                                           const T_ZOsa_Card_State *st)
* DDB_EXAMINE_DISK_REQUESTϢĴ
* ˵(IN)    req:DDB_EXAMINE_DISK_REQUESTĽṹָ
                    st:udisk״̬ṹָ
            (OUT)   VOID
*   ֵVOID
* ˵VOID
**************************************************************************/
static VOID udisk_examine_disk(struct DdbExamineDiskRequest *req, const T_ZOsa_Card_State *st)
{
    struct DdbExamineDiskReply *reply = NULL;

    zOss_AssertExN(req != NULL);

    if (req->unit == DDBUNIT)
    {
        struct DdbDiskInfo  *info       = NULL;
        UINT32            cnt         = 0;
        UINT32            client_cnt  = 0;
        UINT32            num_clients = udisk_number_clients(st);
        zOss_AssertExN(st != NULL); 
        reply = (struct DdbExamineDiskReply *) alloc(sizeof (struct DdbExamineDiskReply) + 
                (num_clients - 1) * sizeof (struct DdbBlockRange), DDB_EXAMINE_DISK_REPLY);
         
        reply->status           = EFS_SUCCESS;
        info                    = &reply->info;
        info->diskSize          = st->num_blks;
        info->cylinders         = 1;
        info->surfaces          = 1;
        info->blocksPerTrack    = st->num_blks;
        info->blockSize         = BLOCK_SIZE;
        info->interleave        = 0;    /* No interleaving necessary.       */
        info->dmaAddrMask       = ~0UL; /* All addresses are ok for DMA.    */
        info->dmaAddrLo         = 0;    /* Lowest address ok for DMA.       */
        info->dmaAddrHi         = ~0UL; /* Highest address ok for DMA.      */
        info->access            = (UINT32)DDB_ACCESS_READ | (UINT32)DDB_ACCESS_WRITE | (UINT32)DDB_ACCESS_RANDOM;
        info->verify            = FALSE;
        info->cacheSize         = 0;
        info->numLocks          = num_clients;
        for (; cnt < UDISK_MAX_CLIENTS; cnt++)
        {
            const T_ZOsa_Card_Client   *client = &st->clients[cnt];
            if (client->pid != 0)
            {
                zOss_ASSERT(client_cnt < num_clients);
                 
                info->locks[client_cnt].loBlock = client->low_blk;
                info->locks[client_cnt].hiBlock = client->high_blk;
                info->locks[client_cnt].owner   = client->pid;
                info->locks[client_cnt].pad     = 0;
                client_cnt++;
            }
        }
    }
    else
    {
        reply           = (struct DdbExamineDiskReply *)alloc(sizeof(struct DdbExamineDiskReply),
                                                               DDB_EXAMINE_DISK_REPLY);
        reply->status   = DDB_EINVALID_PARAMETER;
    }
    send((T_ZOsa_Card_Signal **) &reply, sender((T_ZOsa_Card_Signal **) &req));
    free_buf((T_ZOsa_Card_Signal **) &req);
}

/**************************************************************************
* ƣstatic BOOL udisk_check_overlap(const T_ZOsa_Card_State *st,
                                               UINT32 low_blk,
                                               UINT32 high_blk)
* udisk_mountһЩǷЧ
* ˵(IN)    st:udisk״̬ṹָ
                    low_blk:Сblock
                    high_blk:block
            (OUT)   VOID
*   ֵɹTRUE򷵻FALSE
* ˵VOID
**************************************************************************/
static BOOL udisk_check_overlap(const T_ZOsa_Card_State *st,
                                UINT32 low_blk,
                                UINT32 high_blk)
{
    UINT32 cnt = 0;

    zOss_ASSERT(low_blk <= high_blk);
    
    for (; cnt < UDISK_MAX_CLIENTS; cnt++)
    {
        const T_ZOsa_Card_Client   *client = &st->clients[cnt];

        if (client->pid != 0 &&
            low_blk <= client->high_blk &&
            high_blk >= client->low_blk)
        {
            return TRUE;
        }
    }

    return FALSE;
}

/**************************************************************************
* ƣstatic BOOL udisk_new_client(T_ZOsa_Card_State *st,
                                            PROCESS pid,
                                            OSATTREF attref,
                                            UINT32 low_blk,
                                            UINT32 high_blk)
* udiskĿͻѰһеĿͻ
* ˵(IN     st:udisk״̬ṹָ
                    pid:ļϵͳ̵߳pid
                    attref:attach(ļϵͳ߳)ķֵ
                    low_blk:Сblock
                    high_blk:block
            (OUT)	VOID
*   ֵɹTRUE򷵻FALSE
* ˵VOID
**************************************************************************/
static BOOL udisk_new_client(T_ZOsa_Card_State *st,
                             PROCESS pid,
                             OSATTREF attref,
                             UINT32 low_blk,
                             UINT32 high_blk)
{
    UINT32 cnt = 0;

    for (; cnt < UDISK_MAX_CLIENTS; cnt++)
    {
        T_ZOsa_Card_Client   *client = &st->clients[cnt];

        if (client->pid == 0)
        {
            client->pid         = pid;
            client->attref      = attref;
            client->low_blk     = low_blk;
            client->high_blk    = high_blk;
            return TRUE;
        }
    }

    return FALSE;
}

/**************************************************************************
* ƣstatic VOID udisk_mount(struct DdbMount *req, T_ZOsa_Card_State *st)
* DDB_MOUNT_REQUESTϢĴ
* ˵(IN)    req:DDB_MOUNT_REQUESTϢĽṹָ
                    st:udisk״̬ṹָ
            (OUT)   VOID
*   ֵVOID
* ˵VOID
**************************************************************************/
static VOID udisk_mount(struct DdbMount *req, T_ZOsa_Card_State *st)
{
    PROCESS sender_pid  = sender((T_ZOsa_Card_Signal **) &req);
    SINT32  low_blk     = 0;
    SINT32  high_blk    = 0;

    zOss_AssertExN(req != NULL && st != NULL);

    req->sigNo = DDB_MOUNT_REPLY;
    if (0 == st->num_blks)      // udiskblock
    {
        req->status = DDB_ENO_DISK;
        send((T_ZOsa_Card_Signal **) &req, sender_pid);
        return;
    }
    if (efs_get_number(req->params, "lo", &low_blk) &&
        efs_get_number(req->params, "hi", &high_blk))
    {
        if (req->unit == DDBUNIT &&
            low_blk >= 0 &&
            high_blk < (SINT32)st->num_blks &&
            low_blk <= high_blk)
        {
            if (!udisk_check_overlap(st, (UINT32)low_blk, (UINT32)high_blk))
            {
                if (udisk_new_client(st, sender_pid,
                                     attach(NULL, sender_pid),
                                     (UINT32) low_blk,
                                     (UINT32) high_blk))
                {
                    req->status = EFS_SUCCESS;
                }
                else /* Too many clients. */
                {
                    req->status = DDB_EDISK_IN_USE;
                }
            }
            else
            {
                req->status = DDB_EDISK_IN_USE;
            }
        }
        else
        {
            req->status = DDB_EINVALID_PARAMETER;
        }
    }
    else
    {
        req->status = DDB_EINVALID_PARAMETER;
    }
    
    send((T_ZOsa_Card_Signal **)&req, sender_pid);
}

/**************************************************************************
* ƣstatic VOID udisk_unmount(struct DdbUnmount *req, T_ZOsa_Card_State *st)
* DDB_UNMOUNT_REQUESTϢĴ
* ˵(IN)    req:DDB_MOUNT_REQUESTϢĽṹָ
                    st:udisk״̬ṹָ
            (OUT)   VOID
*   ֵVOID
* ˵VOID
**************************************************************************/
static VOID udisk_unmount(struct DdbUnmount *req, T_ZOsa_Card_State *st)
{
    PROCESS sender_pid  = sender((T_ZOsa_Card_Signal **) &req);
    SINT32  low_blk     = 0;
    SINT32  high_blk    = 0;

    zOss_AssertExN(req != NULL);

    req->sigNo = DDB_UNMOUNT_REPLY;

    if (efs_get_number(req->params, "lo", &low_blk) &&
        efs_get_number(req->params, "hi", &high_blk) &&
        low_blk <= high_blk && req->unit == DDBUNIT)
    {
        T_ZOsa_Card_Client   *client = udisk_find_match(st, sender_pid, (UINT32)low_blk, (UINT32)high_blk);

        if (client != NULL && client->low_blk == (UINT32)low_blk && client->high_blk == (UINT32)high_blk)
        {
            detach(&client->attref);
            
            client->pid = 0;
            req->status = EFS_SUCCESS;
        }
        else
        {
            req->status = DDB_EINVALID_PARAMETER;
        }
    }
    else
    {
        req->status = DDB_EINVALID_PARAMETER;
    }

    send((T_ZOsa_Card_Signal **)&req, sender_pid);
}

/**************************************************************************
* ƣstatic VOID udisk_read(struct DdbRead *req, T_ZOsa_Card_State *st)
* 
* ˵(IN)    req:ṹָ
                    st:udisk״̬ṹָ
            (OUT)   VOID
*   ֵVOID
* ˵VOID
**************************************************************************/
static VOID udisk_read(struct DdbRead *req, T_ZOsa_Card_State *st)
{
    PROCESS             sender_pid  = sender((T_ZOsa_Card_Signal **)&req);
    UINT32              cnt         = 0;
    UINT32              block       = 0;
    UINT32              num_blks    = 0;
    BOOL                ret         = FALSE;
    UINT8               *buffer     = NULL;
    struct DdbOperation *oper       = NULL;

    zOss_AssertExN(req != NULL && st != NULL);

    req->status = EFS_SUCCESS;

    for (; cnt < req->numOps; cnt++)
    {
        oper        = &req->ops[cnt];
        block       = oper->position;
        num_blks    = oper->requested;
        buffer      = (UINT8 *) oper->buffer;
        zOss_ASSERT(num_blks > 0);
        if(num_blks > 0)
        {
            ret = udisk_read_block(st, block, num_blks, (UINT32*)buffer);
        }
        else
        {
            ret = FALSE;
        }
        zOss_ASSERT(ret == TRUE);
        
        if(ret)
        {
            oper->actual = num_blks;
        }
        else
        {
            oper->actual = 0x00;
        }
    }

    req->sigNo = DDB_READ_REPLY;
    send((T_ZOsa_Card_Signal **) &req, sender((T_ZOsa_Card_Signal **) &req));
}

/**************************************************************************
* ƣstatic VOID udisk_write(struct DdbWrite *req, T_ZOsa_Card_State *st)
* д
* ˵(IN)    req:дṹָ
                    st:udisk״̬ṹָ
            (OUT)   VOID
*   ֵVOID
* ˵VOID
**************************************************************************/
static VOID udisk_write(struct DdbWrite *req, T_ZOsa_Card_State *st)
{
    PROCESS             sender_pid  = sender((T_ZOsa_Card_Signal **)&req);
    UINT32              cnt         = 0;
    UINT32              block       = 0;
    UINT32              num_blks    = 0;
    BOOL                ret         = FALSE;
    UINT8               *buffer     = NULL;      
    struct DdbOperation *oper       = NULL;  
    T_ZOsa_Card_Client  *client     = NULL;  

    zOss_AssertExN(req != NULL && st != NULL);
    
    req->status = EFS_SUCCESS;
    for (cnt = 0; cnt < req->numOps; cnt++)
    {
        oper        = &req->ops[cnt];
        buffer      = (UINT8 *)oper->buffer;
        block       = oper->position;
        num_blks    = oper->requested;
        client      = udisk_find_match(st, sender_pid, block, block + num_blks - 1);
        if (client == NULL)
        {
            req->status = DDB_EINVALID_PARAMETER;  /* Sender has not mounted/locked (complete) block range. */
            break;
        }
        zOss_ASSERT(num_blks > 0);
        if(num_blks > 0)
        {
            ret = udisk_write_block(st, block, num_blks, (UINT32*)buffer);
        }
        else
        {
            ret = FALSE;
        }
        zOss_ASSERT(ret == TRUE);
        
        if(ret)
        {
            oper->actual = num_blks;
        }
        else
        {
            oper->actual = 0x0;
        }
    }
    
    req->sigNo = DDB_WRITE_REPLY;
    send((T_ZOsa_Card_Signal **)&req, sender((T_ZOsa_Card_Signal **)&req));
}

/**************************************************************************
* ƣstatic VOID udisk_format_disk(struct DdbFormatDisk *req, T_ZOsa_Card_State *st)
* ʽ
* ˵(IN)    req:ʽṹָ
                    st:udisk״̬ṹָ
            (OUT)   VOID
*   ֵVOID
* ˵VOID
**************************************************************************/
static VOID udisk_format_disk(struct DdbFormatDisk *req, T_ZOsa_Card_State *st)
{
    PROCESS sender_pid = sender((T_ZOsa_Card_Signal **)&req);
    SINT32 low  = 0;
    SINT32 high = 0;

    zOss_AssertExN(req != NULL);

    if (efs_get_number(req->params, "lo", &low) &&
        efs_get_number(req->params, "hi", &high))
    {
        T_ZOsa_Card_Client   *client = udisk_find_match(st, sender_pid, (UINT32) low, (UINT32) high);

        if (client != NULL)
        {
            req->status = EFS_SUCCESS;
        }
        else
        {
            req->status = DDB_EINVALID_PARAMETER;
        }
    }
    else
    {
        req->status = DDB_EINVALID_PARAMETER;
    }

    req->sigNo = DDB_FORMAT_DISK_REPLY;
    send((T_ZOsa_Card_Signal **)&req, sender_pid);
}

/**************************************************************************
* ƣ static VOID udisk_client_lost(PROCESS pid, T_ZOsa_Card_State *st)
*  ļϵͳ̱߳killʱudiskյԸļϵͳ̵߳
             һϢĬOS_ATTACH_SIGñϢ
* ˵ (IN)   pid:ļϵͳ̵߳pid
                    st:udisk״̬ṹָ
             (OUT)  VOID
*   ֵ VOID
* ˵ VOID
**************************************************************************/
static VOID udisk_client_lost(PROCESS pid, T_ZOsa_Card_State *st)
{
    UINT32 cnt = 0;

    zOss_AssertExN(st != NULL);

    for (; cnt < UDISK_MAX_CLIENTS; cnt++)
    {
        T_ZOsa_Card_Client   *client = &st->clients[cnt];

        if (client->pid == pid)
        {
            client->pid     = 0;
            client->attref  = 0;
            return;
        }
    }

    abort();    /* Attach signal without any corresponding client structure.    */
}

/**************************************************************************
* ƣstatic BOOL udisk_register_fss(const char *name,
                                              EfsEnum type,
                                              BOO     local,
                                              PROCESS fss_)
* עudisk̵߳FSS(File System Server)
* ˵(IN)    name:udiskģ
                    type:udiskģ
                    local:udiskģfssǷȫֿɼ
                    fss:fss̵߳pid
            (OUT)   VOID
*   ֵעɹTRUE򷵻FALSE
* ˵VOID
**************************************************************************/
static Boolean udisk_register_fss(const char *name, EfsEnum type, BOOL local, PROCESS fss_)
{
    BOOL                    success     = TRUE;
    static const SIGSELECT  sigsel[]    = {2, FSS_REGISTER_REPLY, ATTACH_FSS};
    struct FssRegister      *reply      = NULL;

    sendFssRegisterRequest(name, type, local, fss_);

    reply = (struct FssRegister *)receive(sigsel);
    if (reply != NULL && reply->sigNo == FSS_REGISTER_REPLY)
    {
        if (reply->status != EFS_SUCCESS)
        {
            error2((OSE_EFATAL_MASK | OSE_EFS_EREGISTER_FAILED),
                    ((OSERRCODE)reply->status));

            kill_proc(current_process());
        }

        success = TRUE;
    }
    else
    {
        success = FALSE;
    }

    free_buf((T_ZOsa_Card_Signal **)&reply);

    return success;
}
 
/**************************************************************************
 *                           ȫֺʵ                                 *
 **************************************************************************/
VOID zOss_UdiskInit(VOID)
{
    extern OSENTRYPOINT ose_udisk;
    PROCESS ose_extfm_pid = create_and_supervise("ose_udiskfm", ose_udisk, (OSADDRESS)2000, 25, NULL);
    start(ose_extfm_pid);
}
/**************************************************************************
* ƣVOID ose_udisk(VOID)
* udisk̵߳ں
* ˵(IN)    VOID
            (OUT)   VOID
*   ֵVOID
* ˵VOID
**************************************************************************/
OS_PROCESS(ose_udisk)
{
    T_ZOsa_Card_State st = {0};
    
    udisk_init_state(&st);
    for(;;)
    {
        static const SIGSELECT  sel_all[]   = {0};
        T_ZOsa_Card_Signal      *sig        = receive(sel_all);
        PROCESS                 sender_pid  = sender(&sig);

        switch (sig->sigNo)
        {
            case OS_ATTACH_SIG:
            {
                udisk_client_lost(sender_pid, &st);
                free_buf(&sig);
                break;
            }
            case HUNT_FSS:
            {
                sig->sigNo      = ATTACH_FSS;
                st.fss_pid      = sender_pid;
                st.fss_attref   = attach(&sig, st.fss_pid);
                if (FALSE == udisk_register_fss(DDBNAME, FSS_TYPE_BLOCKDEV, TRUE, st.fss_pid))
                {                    
                    sig = alloc(sizeof (SIGSELECT), HUNT_FSS); /* Lost contact with FSS. */

                    hunt("ose_fss", 0, NULL, &sig);
                    st.fss_pid  = 0;
                }
                break;
            }
            case ATTACH_FSS:
            {
                sig->sigNo = HUNT_FSS;
                
                hunt("ose_fss", 0, NULL, &sig);
                st.fss_pid = 0;
                break;
            }
            case DDB_EXAMINE_DISK_REQUEST:
            {
                udisk_examine_disk((struct DdbExamineDiskRequest *) sig, &st);
                break;
            }
            case DDB_INTERFACE_REQUEST:
            {
                sendDdbInterfaceReply(EFS_SUCCESS, DDBWHAT, BIOSHANDLE,
                                      DDB_INTERFACE_REQUEST,
                                      DDB_FORMAT_DISK_REQUEST, sender_pid);
                free_buf(&sig);
                break;
            }
            case DDB_MOUNT_REQUEST:
            {
                udisk_mount((struct DdbMount *)sig, &st);
                break;
            }
            case DDB_UNMOUNT_REQUEST:
            {
                udisk_unmount((struct DdbUnmount *)sig, &st);
                break;
            }
            case DDB_READ_REQUEST:
            {
                udisk_read((struct DdbRead *)sig, &st);
                break;
            }
            case DDB_WRITE_REQUEST:
            {
                udisk_write((struct DdbWrite *)sig, &st);
                break;
            }
            case DDB_FORMAT_DISK_REQUEST:
            {
                udisk_format_disk((struct DdbFormatDisk *)sig, &st);
                break;
            }
            default:
            {
                error2(OSE_EFS_EUNKNOWN_SIGNAL, (OSERRCODE)sig);
                free_buf(&sig);
                break;
            }
        }
    }
}

#ifdef __cplusplus
}
#endif
