/*
 * linux/ipc/shm_ctrl.h
 * Copyright (C) 2023 Sanechips Technology Co., Ltd.
 */
#ifndef _SHM_CTRL_H
#define _SHM_CTRL_H

#ifdef CONFIG_SYSVIPC_CROSS_SHM
/**
 * 궨
 */
#include <linux/slab.h>
#include <linux/mm.h>
#include <linux/shm.h>
#include <linux/io.h> 
#include <linux/init.h>
#include <linux/file.h>
#include <linux/list.h>
#include <linux/mman.h>
#include <linux/shmem_fs.h>
#include <linux/audit.h>
#include <linux/capability.h>
#include <linux/ptrace.h>
#include <linux/rwsem.h>
#include <linux/nsproxy.h>
#include <linux/ipc_namespace.h> 
#include <linux/module.h>
#include <linux/dma-mapping.h>
#include <mach/spinlock.h>

/**
 * 궨
*/
#define TRUE   1
#define FALSE  0

#define SHM_CTRL_OK               (0)
#define SHM_CTRL_ERROR            (-1)
#define SHM_CTRL_VMA_LINK_NUM     (2)
#define SHM_CTRL_MEMSYNC_CHANNEL  (15)
#define SHM_CTRL_CHANNEL_SIZE     (0x40)
#define SHM_CTRL_LONG_32BIT       (32)
#define SHM_REMOTE_SYSV_YES       (0x73797376) /*SYSV ASCII*/
#define SHM_REMOTE_POSIX_YES      (0x706F7378)  /*POSX ASCII*/
#define SHM_REMOTE_SYSV_MASK      (0xFFFFF800) /*(key:-1~-2047)*/

/**
 * Ͷ
 */
struct shm_pool_msg
{
    unsigned int shm_len;
    unsigned int key_manage_len;
    phys_addr_t  shm_memory_phy;
    phys_addr_t  key_manage_phy;
};

extern int shm_remote_free_pages(key_t key);
extern key_t shm_hash_name_to_key(const char *name, int len);
extern int shm_do_newseg_check(key_t key, unsigned long len);
extern int shm_do_remote_map_vma(struct vm_area_struct *vma, key_t key);
extern void shm_unmap_page_range(struct mm_struct *mm, struct vm_area_struct *vma,
                                 unsigned long addr, unsigned long end);
#endif
#endif // _SHM_CTRL_H

