/*******************************************************************************
* Ȩ (C)2016, ͨѶɷ޹˾
* 
* ļ:     ramdump_server_trans.c
* ļʶ:     ramdump_server_trans.c
* ժҪ:     ramdump쳣ֳݵʵ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2016/3/10      V1.0        Create           Ծ          
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "ramdump_pub.h"
#include "ramdump_oss.h"
#include <linux/module.h>
#include <asm/cacheflush.h>

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                                                      *
*******************************************************************************/
#define __USE_TRANS_WITH_COLLECT__  1

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define RAMDUMP_ON_DEFAULT_VAL  (1)

#define RAMDUMP_MMAP_SUCCESS    (RAMDUMP_SUCCESS)
#define RAMDUMP_MMAP_FAILED     (RAMDUMP_FAILED)

#define RP_MSG_PS_PHY_RAMDUMP_CHANNEL  channel_40 //armzsp֮ramdumpͨ
#define RP_MSG_PS_PHY_RAMDUMP_SIZE     0x40       //armzsp֮ramdumpͨ

#ifdef _USE_CAP_SYS
#define RAMDUMP_ICP_MSG_CAP_SIZE       0x40 
#endif

/* ramdump  PCԼ */
/*ͬ*/
#define RAMDUMP_PC_INTERACTIVE_REQ                  1
/*ͬӦ,ramdumpļĿ*/
#define RAMDUMP_TRANS_SERVER_INTERACTIVE_RSP        2
/*󴫵ָļŵļϢ*/
#define RAMDUMP_PC_FILE_INFO_READ_REQ               3
/*󴫵ָļŵļϢӦ𣬴ļС*/
#define RAMDUMP_TRANS_SERVER_FILE_INFO_READ_RSP     4
/*ȡָļŵļ*/
#define RAMDUMP_PC_FILE_DATA_TRANS_REQ              5
/*ȡָļŵļݵӦ𣬴ļ*/
#define RAMDUMP_TRANS_SERVER_FILE_DATA_TRANS_RSP    6
/**/
#define RAMDUMP_PC_FILE_TRANS_DONE_REQ              7
/*Ӧ*/ 
#define RAMDUMP_TRANS_SERVER_FILE_TRANS_DONE_RSP    8

/*  */
/*ָ*/
#define RAMDUMP_INTERACTIVE_CMD_ERROR       9
/*󴫵ָļŴ*/
#define RAMDUMP_FILE_NUMBER_ERROR           10
/*󴫵ָļλôС*/
#define RAMDUMP_FILE_SIZE_ERROR             11
/*ָ֡ */
#define RAMDUMP_INTERACTIVE_DATA_LEN        16

#define RAMDUMP_TRANS_SERVER_DDR_BINNAME  "trans_server_ddr.bin"
#define RAMDUMP_TRANS_SERVER_CMM_SCRNAME  "trans_server_cmm.cmm"
#define RAMDUMP_TRANS_SERVER_ERR_LOG      "trans_server_error_log.txt"
#define RAMDUMP_TRANS_SERVER_DEF_BINNAME  "trans_server_"

#define RAMDUMP_CAP_CMM_BUF_ADDR_PHY    (RAMDUMP_CAP_CMM_BUF_ADDR_PA)
#define RAMDUMP_CAP_CMM_BUF_LEN_REAL    ((3 * 1024UL)>>CPU_SHIFT)
#define RAMDUMP_CAP_LOG_BUF_ADDR        (RAMDUMP_CAP_CMM_BUF_ADDR_PHY + RAMDUMP_CAP_CMM_BUF_LEN_REAL)
#define RAMDUMP_CAP_LOG_BUF_LEN         ((1 * 1024UL)>>CPU_SHIFT)

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
/*
 * struct TRANS WITH PC
 */

/* trans_server rsp pc, interactive msg struct */
typedef struct
{
    unsigned int cmd;
    unsigned int file_num;
} ramdump_trans_server_interactive_rsp;

/* trans_server rsp pc, file info msg struct */
typedef struct
{
    unsigned int cmd;
    char    file_name[RAMDUMP_RAMCONF_FILENAME_MAXLEN];
    unsigned int file_size;
} ramdump_trans_server_file_info_rsp;

/* pc req trans_server, file info msg struct */
typedef struct
{
    unsigned int cmd;
    unsigned int file_id;
} ramdump_pc_file_info_req;

/* trans_server rsp pc, trans data msg struct */
typedef struct
{
    unsigned int cmd;
    unsigned int buf_addr;
    unsigned int buf_left_size;
} ramdump_trans_server_data_trans_rsp;

/* pc req trans_server, trans data msg struct */
typedef struct
{
    unsigned int   cmd;
    unsigned int   file_id;      /* ļ         */
    unsigned int   offset;       /* offsetΪƫ */
    unsigned int   length;       /* lengthΪݳ */
} ramdump_pc_trans_data_req;


/*******************************************************************************
*                                                                  *
*******************************************************************************/
#ifndef CONFIG_SYSTEM_RECOVERY
extern unsigned int zOss_GetExceptResetFlag(void);
extern int zSys_ExceptReboot(unsigned int  except_cpu);
#else
extern void emergency_restart(void);
#endif

extern void zxic_reset_reason(int reason, const char *cpu, const char *app);
extern void zx_wdt_m0_stop(void);
extern struct meminfo meminfo;
#ifdef _USE_VEHICLE_DC
extern void ramdump_shared_mem_init(void);
#endif
/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/
static int ramdump_server_init_flag;
static int ramdump_count;
static int ramdump_file_num;

static DEFINE_MUTEX(ramdump_mutex);

/* Cmm file content */
static unsigned char ramdump_server_cmm_buf[RAMDUMP_CMM_SIZE];
/* err log file */
static char ramdump_server_error_log[RAMDUMP_ERROR_LOG_SIZE];

/* trans server ram conf table */
ramdump_ram_config_t ramdump_trans_server_ram_conf[RAMDUMP_RAMCONF_TABLE_MAX_ENTRYS];
static unsigned int ddr_ap_size;

#ifndef __USE_TRANS_WITH_COLLECT__ 
/* trans server ram conf data done flag*/
static unsigned long ramdump_trans_server_data_done_flag = RAMDUMP_SYNC_RESET;
/* collect server ram conf addr */
static ramdump_ram_config_sync_msg_t ramdump_collect_server_ram_conf;

static ramdump_ram_config_msg_t ramdump_ap_config;
static int ramdump_ap_file_num;

#endif

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/
/*
 * run time control dump or not, use ( echo "0" > ramdump_on ) to close ramdump
 */
int sysctl_ramdump_on_panic = RAMDUMP_ON_DEFAULT_VAL;

/* diff server crash or client crash */
int ramdump_trans_server_force_panic_flag = RAMDUMP_FALSE;

char ramdump_shm_export_file[][RAMDUMP_RAMCONF_FILENAME_MAXLEN] = 
{
#if 0 
	"cap_ddr.bin",
	"cap.cmm",
	"cap_err_log.txt"
#endif
};

unsigned int ramdump_shm_file_num = 0;
unsigned int ramdump_exprot_file_num = 0;
unsigned int ramdump_export_file_index[RAMDUMP_RAMCONF_TABLE_MAX_ENTRYS] = {0};
unsigned int *cap_ddr_size = (unsigned int *)IRAM_BASE_ADDR_BOOT_DDR;

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ramdump_trans_server_dynamic_ram_conf_collect
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used to collect server ram conf before client mmap
*******************************************************************************/
unsigned long ramdump_phy_to_vir(ramdump_ram_config_t * ram_config)
{
    unsigned long pfn = 0;
    unsigned long vir_addr = 0;

    if(ram_config->vir != 0)
        return ram_config->vir;

    pfn = OSS_PHY_TO_PFN((unsigned long)(ram_config->phy));
    if (OSS_PFN_VALID(pfn))
        vir_addr = OSS_PHY_TO_VIRT((unsigned long)ram_config->phy);
    else 
        if (ram_config->copy  != 0 &&
                 ram_config->copy  != ram_config->phy)
        {
            vir_addr =(unsigned long)ram_config->copy;
        }
         else if (ram_config->exter  != 0 && ram_config->exter  != ram_config->phy)
        {
            vir_addr = (unsigned long)ram_config->exter;
        }
        else
        {
            /* Started by AICoder, pid:9f8438a77cc012714d370bb0a0e4e40d45274517 */
#ifdef _USE_VEHICLE_DC
            if(!strncmp(RAMDUMP_CAP_DDR_BIN, ram_config->name, strlen(RAMDUMP_CAP_DDR_BIN)))
                vir_addr = (unsigned long)ioremap_cached(ram_config->phy, ram_config->size);
            else
#endif
                vir_addr = (unsigned long)OSS_MMAP(ram_config->phy, ram_config->size);
            /* Ended by AICoder, pid:9f8438a77cc012714d370bb0a0e4e40d45274517 */
        }
        
    return vir_addr;
}

#ifndef __USE_TRANS_WITH_COLLECT__ 
/*******************************************************************************
* :     ramdump_trans_server_ram_conf_table_mmap
* ˵:     
*   ()  array: ram conf table addr
*               nr: ram conf table size
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump trans to mmap addr table space
*******************************************************************************/
static void ramdump_trans_server_ram_conf_table_mmap(
                void *array, 
                unsigned int nr)
{
    unsigned long cpu_id = 0;
    unsigned long vir_addr = 0;
    unsigned long pfn = 0;
    while (cpu_id < nr)
    {
        vir_addr = 0;
        pfn = 0;
        ramdump_ram_config_msg_t *array_entry = 
            (ramdump_ram_config_msg_t *)(&(ramdump_collect_server_ram_conf.array[cpu_id]));
        if (((((ramdump_ram_config_msg_t *)array)[cpu_id]).array) == NULL || 
            ((((ramdump_ram_config_msg_t *)array)[cpu_id]).nr) == 0)
        {
            cpu_id++;
            continue;
        }

        pfn = OSS_PHY_TO_PFN((unsigned long)((((ramdump_ram_config_msg_t *)array)[cpu_id]).array));
        if (OSS_PFN_VALID(pfn))
            vir_addr = OSS_PHY_TO_VIRT((unsigned long)((((ramdump_ram_config_msg_t *)array)[cpu_id]).array));
        else 
            vir_addr = (unsigned long)OSS_MMAP(
                (unsigned long)((((ramdump_ram_config_msg_t *)array)[cpu_id]).array),
                ((((ramdump_ram_config_msg_t *)array)[cpu_id].nr) * sizeof(ramdump_ram_config_t)));
        if (vir_addr == 0)
        {
            OSS_PRINTF("[ramdump] trans server mmap collect server ram conf table entry failed!\n");
            cpu_id++;
            continue;
        }
        else
        {
            array_entry->array = (ramdump_ram_config_t *)vir_addr;
            array_entry->nr = (((ramdump_ram_config_msg_t *)array)[cpu_id].nr);
        }

        /* mmap collect ram conf table space sync done flag */
        vir_addr = 0;
        pfn = OSS_PHY_TO_PFN((unsigned long)((((ramdump_ram_config_msg_t *)array)[cpu_id]).done_flag));
        if (OSS_PFN_VALID(pfn))
            vir_addr = OSS_PHY_TO_VIRT((unsigned long)((((ramdump_ram_config_msg_t *)array)[cpu_id]).done_flag));
        else
            vir_addr = (unsigned long)OSS_MMAP(
                (unsigned long)((((ramdump_ram_config_msg_t *)array)[cpu_id]).done_flag),
                sizeof(*((((ramdump_ram_config_msg_t *)array)[cpu_id]).done_flag)));
        if (vir_addr == 0)
        {
            OSS_PRINTF("[ramdump] trans server mmap collect server table entry done flag failed!\n");
            cpu_id++;
            continue;
        }
        else
        {
            array_entry->done_flag = vir_addr;
        }
        cpu_id++;
    }

}

/*******************************************************************************
* :     ramdump_dump_ram_conf_mmap_init
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump client mmap init
*******************************************************************************/
static void ramdump_dump_ram_conf_mmap_init(void)
{
    unsigned long vir_addr = 0;
    int cpu_id = 0; 

    /* iterate all cpu */
    while (cpu_id < ramdump_collect_server_ram_conf.nr)
    {
        int tb_index = 0;
        unsigned long pfn = 0;
        ramdump_ram_config_msg_t *array_entry = 
            (ramdump_ram_config_msg_t *)(&(ramdump_collect_server_ram_conf.array[cpu_id]));
        if (array_entry->array == NULL || array_entry->nr == 0 || array_entry->done_flag == NULL)
        {
            OSS_PRINTF("Ramdump maybe happens before collect server init done, please check!\n");
            cpu_id++;
            continue;
        }

        /* wait collect data done */
        while (*(array_entry->done_flag) == RAMDUMP_SYNC_RESET) 
            ramdump_wait_done_delay(
                RAMDUMP_WAIT_TIMELEN, 
                (volatile unsigned long *)array_entry->done_flag, 
                RAMDUMP_SYNC_RAM_CONFIG_DONE);

         /* iterate all ram conf table entry */
        while (tb_index < array_entry->nr)
        {
            if (array_entry->array[tb_index].phy == 0 ||
                array_entry->array[tb_index].size == 0)
            {
                tb_index++;
                continue;
            }

            vir_addr = ramdump_phy_to_vir(&array_entry->array[tb_index]);
            if (vir_addr == 0)
                OSS_PRINTF("Ramdump init failed, client mem mmap init wrong!\n");
            else
                array_entry->array[tb_index].vir = vir_addr;
            tb_index++;
        }
        cpu_id++;
    }

}

/*******************************************************************************
* :    ramdump_dump_file_num_recalc
* ˵:     
*   () void
*   () void
*   ֵ:    void
* ˵:    This function is used to create err log file
*******************************************************************************/
static void ramdump_dump_file_num_recalc(void)
{
    unsigned long cpu_id    = 0;
    if (ramdump_collect_server_ram_conf.nr == 0 || 
        ramdump_collect_server_ram_conf.array == NULL)
        while(TRUE); /* except happends before sync with other core done */

    while (cpu_id < ramdump_collect_server_ram_conf.nr)
    {
        unsigned long arr_num = 0;
        unsigned long file_num  = 0;
        while(arr_num < ramdump_collect_server_ram_conf.array[cpu_id].nr)
        {
            /* ram conf have contents,need to dump */
            if (ramdump_collect_server_ram_conf.array[cpu_id].array[arr_num].vir != 0 &&
                ramdump_collect_server_ram_conf.array[cpu_id].array[arr_num].size != 0)
                file_num++;
            arr_num++;
        }
        ramdump_collect_server_ram_conf.array[cpu_id].nr = file_num;
        cpu_id++;
    }
}

/*******************************************************************************
* :    ramdump_find_collect_ram_conf_entry_id
* ˵:     
*   () file_id: file number
*   () cpu_id : cpu index
*   ֵ:    unsigned long: file id
* ˵:    This function is used for ramdump to 
*******************************************************************************/
static unsigned long ramdump_find_collect_ram_conf_entry_id(
                        unsigned long file_id, 
                        unsigned long* cpu_id)
{
    unsigned long cpu_index = 0;
    while (cpu_index < RAMDUMP_CPU_MAX)
    {
        if (file_id >= ramdump_collect_server_ram_conf.array[cpu_index].nr)
            file_id -= ramdump_collect_server_ram_conf.array[cpu_index].nr;
        else
            break;
        cpu_index++;
    }

    *cpu_id = cpu_index;
    return file_id;
}

/*******************************************************************************
* :     ramdump_wait_clients_dump_done
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump client dump done charge
*******************************************************************************/
static void ramdump_wait_clients_dump_done(void)
{    
    unsigned long cpu_id = 0;
    while (cpu_id < RAMDUMP_CPU_MAX)
    {
        if (ramdump_collect_server_ram_conf.array[cpu_id].array == NULL ||
            ramdump_collect_server_ram_conf.array[cpu_id].nr == NULL ||
            ramdump_collect_server_ram_conf.array[cpu_id].done_flag == NULL)
            break;
        while (*(ramdump_collect_server_ram_conf.array[cpu_id].done_flag) == RAMDUMP_SYNC_RESET) 
            ramdump_wait_done_delay(
                RAMDUMP_WAIT_TIMELEN, 
                (volatile unsigned long *)(ramdump_collect_server_ram_conf.array[cpu_id].done_flag),
                RAMDUMP_SYNC_RAM_CONTENT_DONE);
        cpu_id++;
    }
}
#endif //#ifndef __USE_TRANS_WITH_COLLECT__ 

/*******************************************************************************
* :     ramdump_do_panic
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump client icp msg handle, do panic
*******************************************************************************/
static void ramdump_do_panic(void)
{
    if (ramdump_trans_server_force_panic_flag == RAMDUMP_CLIENT_ZSP)
        OSS_PANIC("trans server received forced dump request from zsp client!\n");
    else if (ramdump_trans_server_force_panic_flag == RAMDUMP_CLIENT_CAP)
        OSS_PANIC("trans server received forced dump request from cap client!\n");
    else
        OSS_PANIC("AP server recv error icp msg\n");
}

/*******************************************************************************
* :     ramdump_clients_icp_handle
* ˵:     
*   ()  buf: icp msg addr
*               len: icp msg len
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump client icp msg handle, common entry
*******************************************************************************/
static void ramdump_clients_icp_handle(void *buf, unsigned int len)
{
    unsigned long vir_addr = 0;
    ramdump_msg_t *icp_msg = (ramdump_msg_t *)buf;
    switch(icp_msg->msg_id)
    {
#ifndef __USE_TRANS_WITH_COLLECT__ 
        case RAMDUMP_MSG_INIT_REQ:
        {
            /* trans ram conf send to collect server */
            ramdump_msg_t icp_msg_to_server = {0};
            icp_msg_to_server.msg_id        = RAMDUMP_MSG_INIT_RSP;
            icp_msg_to_server.cpu_id        = ramdump_cpu_id[RAMDUMP_CPU_1];
            icp_msg_to_server.msg_data_t.ram_config.array = 
                OSS_VIRT_TO_PHY(ramdump_trans_server_ram_conf);
            icp_msg_to_server.msg_data_t.ram_config.nr = 
                RAMDUMP_ARRAY_NR(ramdump_trans_server_ram_conf);
            icp_msg_to_server.msg_data_t.ram_config.done_flag = 
                OSS_VIRT_TO_PHY((unsigned long*)&ramdump_trans_server_data_done_flag);
            
            ramdump_oss_icp_send(&icp_msg_to_server, ramdump_cpu_id[RAMDUMP_CPU_0]);
            break;
        }
        case RAMDUMP_MSG_SYNC: /* handle collect ram conf */
        {
            unsigned long addr = RAMDUMP_SYNC_RESET;
            if (icp_msg->msg_data_t.ram_config_sync.array == NULL || 
                icp_msg->msg_data_t.ram_config_sync.nr == 0)
                break;

            /* mmap collect ram conf table space */
            vir_addr = (unsigned long)OSS_MMAP(
                (unsigned long)icp_msg->msg_data_t.ram_config_sync.array,
                ((icp_msg->msg_data_t.ram_config_sync.nr) * sizeof(ramdump_ram_config_msg_t)));
            if (vir_addr == 0)
            {
                OSS_PRINTF("[ramdump] trans server mmap collect server ram conf table failed!\n");
                break;
            }
            ramdump_collect_server_ram_conf.array = (ramdump_ram_config_msg_t *)vir_addr;
            ramdump_collect_server_ram_conf.nr = icp_msg->msg_data_t.ram_config_sync.nr;

            /* mmap collect ram conf table entry space */
            ramdump_trans_server_ram_conf_table_mmap(
                ramdump_collect_server_ram_conf.array, 
                ramdump_collect_server_ram_conf.nr);

            /* wait ioremap work */
            ramdump_wait_done_delay(RAMDUMP_WAIT_TIMELEN, &addr, RAMDUMP_SYNC_RAM_CONFIG_DONE);

            /* we have to mmap first,sometime except happend in interrupt 
            handlers , then we can`t mmap - -! */
            ramdump_dump_ram_conf_mmap_init();

            break;
        }
#endif
        case RAMDUMP_MSG_EXCEPT:
        {
            ramdump_do_panic();
            break;
        }
        default:
        {
            ramdump_do_panic();	
            break;
        }
    }
}

/**************************************************************************
 * ƣ   ramdump_icp_msg_from_zsp
 *    server zspICPϢ
 * ˵
*   ()  pMsg: ic msg buf
*   ()  void
 *   ֵ   void   
 * ˵   void
**************************************************************************/
static void ramdump_icp_msg_from_zsp(void *buf, unsigned int len)
{
    ramdump_trans_server_force_panic_flag = RAMDUMP_CLIENT_ZSP;
    zxic_reset_reason(1, "phy", "zsp");

    ramdump_clients_icp_handle(buf, len);
}

/**************************************************************************
 * ƣ   ramdump_icp_msg_from_cap
 *    server zspICPϢ
 * ˵
*   ()  pMsg: ic msg buf
*   ()  void
 *   ֵ   void   
 * ˵   void
**************************************************************************/
static void ramdump_icp_msg_from_cap(void *buf, unsigned int len)
{
    ramdump_trans_server_force_panic_flag = RAMDUMP_CLIENT_CAP;

    ramdump_clients_icp_handle(buf, len);
}

/**************************************************************************
 * ƣ   ramdump_icp_msg_from_m0
 *    server zspICPϢ
 * ˵
*   ()  pMsg: ic msg buf
*   ()  void
 *   ֵ   void   
 * ˵   void
**************************************************************************/
void ramdump_icp_msg_from_m0(void *buf, int len)
{
    ramdump_trans_server_force_panic_flag = RAMDUMP_CLIENT_M0;
    zxic_reset_reason(1, "rpm", "m0");
    OSS_PANIC("trans server received forced dump request from M0 client!\n");
}

/*******************************************************************************
* :     ramdump_icp_init
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump client icp init
*******************************************************************************/
static int ramdump_icp_init(void)
{
    int ret = 0;
#ifndef __USE_TRANS_WITH_COLLECT__ 
    ret = ramdump_oss_icp_create_channel(
            ramdump_cpu_id[RAMDUMP_CPU_0], 
            RAMDUMP_CHANNEL, 
            RAMDUMP_CHANNEL_SIZE);
    if (ret != RAMDUMP_SUCCESS) 
        return ret;

    ret = ramdump_oss_icp_regcallback(
            ramdump_cpu_id[RAMDUMP_CPU_0],
            RAMDUMP_CHANNEL, 
            ramdump_collect_server_icp_handle);
    if (ret != RAMDUMP_SUCCESS) 
        return ret;
#else
#ifdef _USE_CAP_SYS
  ret = zDrvRpMsg_CreateChannel_Cap(
            CAP_ID, 
            RAMDUMP_CHANNEL,
            RAMDUMP_ICP_MSG_CAP_SIZE);
    if (ret != RAMDUMP_SUCCESS) 
        return ret;
    ret = zDrvRpMsg_RegCallBack_Cap(
            CAP_ID,
            RAMDUMP_CHANNEL, 
            ramdump_icp_msg_from_cap);
    if (ret != RAMDUMP_SUCCESS) 
        return ret;
#endif
    ret = ramdump_oss_icp_create_channel(
            ramdump_cpu_id[RAMDUMP_CPU_2], 
            RP_MSG_PS_PHY_RAMDUMP_CHANNEL, 
            RP_MSG_PS_PHY_RAMDUMP_SIZE);
    if (ret != RAMDUMP_SUCCESS) 
        return ret;

    ret = ramdump_oss_icp_regcallback(
            ramdump_cpu_id[RAMDUMP_CPU_2],
            RP_MSG_PS_PHY_RAMDUMP_CHANNEL, 
            ramdump_icp_msg_from_zsp);
    if (ret != RAMDUMP_SUCCESS) 
        return ret;

    ret = ramdump_oss_icp_create_channel(
            M0_ID, 
            channel_3, 
            0x14);
    if (ret != RAMDUMP_SUCCESS) 
        return ret;

    ret = ramdump_oss_icp_regcallback(
            M0_ID,
            channel_3, 
            ramdump_icp_msg_from_m0);

    if (ret != RAMDUMP_SUCCESS) 
        return ret;

#endif

    return RAMDUMP_SUCCESS;
}

/*******************************************************************************
* :     ramdump_notify_client_dump
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for 
*******************************************************************************/
static void ramdump_notify_client_dump(void)
{
    ramdump_msg_t icp_msg = {0};
#ifndef __USE_TRANS_WITH_COLLECT__ 

    /* client except interactive */
    icp_msg.msg_id = RAMDUMP_MSG_EXCEPT;
    icp_msg.cpu_id = RAMDUMP_CPU_1;
    ramdump_oss_icp_send(&icp_msg, ramdump_cpu_id[RAMDUMP_CPU_0]);
#else
#ifdef _USE_CAP_SYS
  /* client except interactive */
    icp_msg.msg_id = RAMDUMP_MSG_EXCEPT;
    icp_msg.cpu_id = RAMDUMP_CPU_0;
    ramdump_oss_icp_send_cap(&icp_msg, CAP_ID);
#endif
    /* client except interactive */
    icp_msg.msg_id = RAMDUMP_MSG_EXCEPT;
    icp_msg.cpu_id = RAMDUMP_CPU_0;
    ramdump_oss_icp_send(&icp_msg, ramdump_cpu_id[RAMDUMP_CPU_2]);
#endif
}

/*******************************************************************************
* :     ramdump_file_skip
* ˵:     
*   ()  index 
*   ()  void
*   ֵ:     Ƿ
* ˵:     This function is used for judge file is skip or not
*******************************************************************************/
/* Started by AICoder, pid:z865016281f2eb61401a0bbbf042be1ce3921564 */
bool ramdump_file_skip(unsigned int index)
{
    unsigned int cnt = 0;
    ramdump_shm_file_num = sizeof(ramdump_shm_export_file) / sizeof(ramdump_shm_export_file[0]);

    for (; cnt < ramdump_shm_file_num; cnt++) {
        if (strcmp(ramdump_trans_server_ram_conf[index].name, ramdump_shm_export_file[cnt]) == 0) {
            return true;
        }
    }
    return false;
}
/* Ended by AICoder, pid:z865016281f2eb61401a0bbbf042be1ce3921564 */

/*******************************************************************************
* :     ramdump_cmm_script_skip
* ˵:     
*   ()  index 
*   ()  void
*   ֵ:     Ƿ
* ˵:     This function is used for judge file is skip or not
*******************************************************************************/
bool ramdump_cmm_script_skip(unsigned int index)
{
    char *ramconf_name = ramdump_trans_server_ram_conf[index].name;

    if((strcmp(ramconf_name, "cap_ddr.bin") == 0)
        || (strcmp(ramconf_name, "cap.cmm") == 0)
        || (strcmp(ramconf_name, "cap_err_log.txt") == 0))
    {
        return true;
    }
    return false;
}

/*******************************************************************************
* :    ramdump_server_store_ram_conf
* ˵:     
*   () mem: addr
*   () void 
*   ֵ:    unsigend char*: changed addr
* ˵:    This function is used to store ram conf
*******************************************************************************/
static unsigned char *ramdump_server_store_ram_conf(unsigned char *mem)
{
    unsigned long        i_ram_conf    = 0;
    ramdump_ram_config_t *config_entry = NULL;

    while (ramdump_trans_server_ram_conf[i_ram_conf].vir != 0 && 
           ramdump_trans_server_ram_conf[i_ram_conf].size != 0) {
#ifdef _USE_VEHICLE_DC 
        if ((ramdump_export_mode == RAMDUMP_MODE_EMMC)
            || (ramdump_export_mode == RAMDUMP_MODE_SPINAND)){
            if ((ramdump_file_skip(i_ram_conf) == true) 
                || (ramdump_cmm_script_skip(i_ram_conf) == true)){
                i_ram_conf++;
                continue;
            }
        }
#endif
        config_entry = &(ramdump_trans_server_ram_conf[i_ram_conf]);
        /* session can be access */
        if (config_entry->callback == NULL ||
        (config_entry->callback != NULL &&
        (*(config_entry->callback))() == RAMDUMP_TRUE))
            mem += sprintf(
                mem, 
                "data.load.binary &ramdump_dir\\%s 0x%x--0x%x /noclear\n",
                (config_entry->name),
                    (unsigned int)config_entry->phy, 
                (unsigned int)(config_entry->phy + config_entry->size));
        
        i_ram_conf++;
    }
    return mem;
}

/*******************************************************************************
* :    ramdump_trans_server_cmm_create
* ˵:     
*   () void
*   () void
*   ֵ:    void
* ˵:    This function is used for server to generate cmm scripts
*******************************************************************************/
static void ramdump_trans_server_cmm_create(void)
{
    unsigned char *pcmm_buf = ramdump_server_cmm_buf;
    unsigned int cmm_buf_len = 0;
    char cmm_name[RAMDUMP_RAMCONF_FILENAME_MAXLEN] = {0};

    // store the cmm BEGIN
    pcmm_buf += sprintf(pcmm_buf, "ENTRY &ramdump_dir\n");
    // store procmodes regs
    pcmm_buf = ramdump_arch_store_modes_regs(pcmm_buf);
    // store ram config 
    pcmm_buf = ramdump_server_store_ram_conf(pcmm_buf);
    // store memory map control regs
    pcmm_buf = ramdump_arch_store_mm_regs(pcmm_buf);

    // store end symbol
    pcmm_buf += sprintf(pcmm_buf, "ENDDO\n");

    // generate cmm name
    sprintf(
        cmm_name, 
        "%s-%s", 
        ramdump_cpu_name[RAMDUMP_CPU_1], 
        RAMDUMP_TRANS_SERVER_CMM_SCRNAME);

    //if out of buf, since we can`t stop it, then cut it
    cmm_buf_len = ((unsigned int)pcmm_buf - (unsigned int)ramdump_server_cmm_buf);
    if (cmm_buf_len <= RAMDUMP_CMM_SIZE)
        ramdump_ram_conf_table_add(
            cmm_name,
            (unsigned long)OSS_VIRT_TO_PHY(ramdump_server_cmm_buf), 
            cmm_buf_len, 
            (unsigned long)ramdump_server_cmm_buf,
            RAMDUMP_FLAG_LEVEL_HIGH,
            0);
    else
        ramdump_ram_conf_table_add(
            cmm_name, 
            (unsigned long)OSS_VIRT_TO_PHY(ramdump_server_cmm_buf), 
            RAMDUMP_CMM_SIZE, 
            (unsigned long)ramdump_server_cmm_buf,
            RAMDUMP_FLAG_LEVEL_HIGH,
            0);
}

/*******************************************************************************
* :    ramdump_trans_server_error_log_create
* ˵:     
*   () void
*   () void
*   ֵ:    void
* ˵:    This function is used to create err log file
*******************************************************************************/
static void ramdump_trans_server_error_log_create(void)
{
    int offset = 0;
    char err_log_name[RAMDUMP_RAMCONF_FILENAME_MAXLEN] = {0};
    
    if (ramdump_trans_server_force_panic_flag == RAMDUMP_CLIENT_ZSP)
        offset = sprintf(ramdump_server_error_log, "trans server received force dump request from ZSP client !\n");
    else if (ramdump_trans_server_force_panic_flag == RAMDUMP_CLIENT_M0)
        offset = sprintf(ramdump_server_error_log, "trans server received force dump request from M0 client !\n");
    else if (ramdump_trans_server_force_panic_flag == RAMDUMP_CLIENT_CAP)
        offset = sprintf(ramdump_server_error_log, "trans server received force dump request from CAP client !\n");
    else
        offset = sprintf(ramdump_server_error_log, "AP server breakdown happens !\n");
    
    ramdump_oss_error_log_creat(ramdump_server_error_log + offset);
    // generate err_log name
    sprintf(
        err_log_name, 
        "%s-%s", 
        ramdump_cpu_name[RAMDUMP_CPU_1], 
        RAMDUMP_TRANS_SERVER_ERR_LOG);
    ramdump_ram_conf_table_add(
        err_log_name, 
        (unsigned long)OSS_VIRT_TO_PHY(ramdump_server_error_log), 
        ((strlen(ramdump_server_error_log) >= RAMDUMP_ERROR_LOG_SIZE) ? 
        RAMDUMP_ERROR_LOG_SIZE : strlen(ramdump_server_error_log)),
        (unsigned long)ramdump_server_error_log,
        RAMDUMP_FLAG_LEVEL_HIGH,
        0);
}

unsigned int ramdump_calc_total_regions(unsigned int prio_exp)
{
    unsigned int  index;
    unsigned int  cnt;
    unsigned long flag;
    bool  skip         = false;
     bool  export_order = false;
      
    for (index = 0; index < ramdump_file_num; index++){
#ifdef _USE_VEHICLE_DC
        if ((ramdump_export_mode == RAMDUMP_MODE_EMMC)
            || (ramdump_export_mode == RAMDUMP_MODE_SPINAND)) {

            skip = ramdump_file_skip(index);
            flag = ramdump_trans_server_ram_conf[index].flag;

            if (prio_exp == RAMDUMP_FLAG_NONE)
                export_order = ((flag & RAMDUMP_CLEAR_PRIO_FLAG) == flag);
            else
                export_order =  ((flag & prio_exp) == prio_exp);

            if (skip == false && (export_order == true)) {
                ramdump_export_file_index[ramdump_exprot_file_num] = index;
                ramdump_exprot_file_num++;
            }
            else
                skip = false;
        }else{
#endif
            ramdump_export_file_index[ramdump_exprot_file_num] = index;
            ramdump_exprot_file_num++;
#ifdef _USE_VEHICLE_DC
        }
#endif
    }
    return ramdump_exprot_file_num;
}

static inline void ramdump_wait_delay(unsigned long ms)
{
    volatile int j = 0;
    for (j = 0; j < 50000 * ms; j++);
}

void ramdump_sortprio_getnum(void)
{
#ifdef _USE_VEHICLE_DC
    if((ramdump_export_mode != RAMDUMP_MODE_EMMC) 
        &&(ramdump_export_mode != RAMDUMP_MODE_SPINAND))
    {
#endif
        ramdump_calc_total_regions(RAMDUMP_FLAG_NONE);
#ifdef _USE_VEHICLE_DC
    }
    else
    {
        ramdump_calc_total_regions(RAMDUMP_FLAG_LEVEL_HIGH);
        ramdump_calc_total_regions(RAMDUMP_FLAG_LEVEL_MEDIUM);
        ramdump_calc_total_regions(RAMDUMP_FLAG_LEVEL_LOW);
        ramdump_calc_total_regions(RAMDUMP_FLAG_NONE);
    }
#endif
}

/*******************************************************************************
* :    ramdump_data_transfer_to_pc
* ˵:     
*   () void
*   () void
*   ֵ:    void 
* ˵:    This function is used for ramdump to trans dump data to PC
*******************************************************************************/
static void ramdump_data_transfer_to_pc(void)
{
    int file_id = 0;
    char req_buf[RAMDUMP_INTERACTIVE_DATA_LEN] = {0};

    /* interactive begin */
    ramdump_oss_data_trans_init();
    ramdump_sortprio_getnum();

    for(;;)
    {
        ramdump_oss_data_trans_read((unsigned char *)req_buf, RAMDUMP_INTERACTIVE_DATA_LEN);
        switch (*(unsigned int *)req_buf)
        {
        case RAMDUMP_PC_INTERACTIVE_REQ:
            {
                ramdump_trans_server_interactive_rsp server_to_pc_msg = {0};
                server_to_pc_msg.cmd = RAMDUMP_TRANS_SERVER_INTERACTIVE_RSP;
                server_to_pc_msg.file_num = ramdump_exprot_file_num;

                ramdump_oss_data_trans_write(
                    (unsigned char*)(&server_to_pc_msg),
                    sizeof(server_to_pc_msg));

                break;
            }
        case RAMDUMP_PC_FILE_INFO_READ_REQ:
            {
                ramdump_trans_server_file_info_rsp server_to_pc_msg = {0};
                /* data from pc to server  */
                ramdump_pc_file_info_req *pc_to_server_msg = (ramdump_pc_file_info_req *)req_buf;
                file_id = pc_to_server_msg->file_id;
                /* data respond pc from server  */
                server_to_pc_msg.cmd = RAMDUMP_TRANS_SERVER_FILE_INFO_READ_RSP;
                strncpy(server_to_pc_msg.file_name, 
                        ramdump_trans_server_ram_conf[ramdump_export_file_index[file_id]].name, 
                        RAMDUMP_RAMCONF_FILENAME_MAXLEN - 1);
                server_to_pc_msg.file_name[RAMDUMP_RAMCONF_FILENAME_MAXLEN - 1] = '\0';
                server_to_pc_msg.file_size = ramdump_trans_server_ram_conf[ramdump_export_file_index[file_id]].size;
                if (ramdump_trans_server_ram_conf[ramdump_export_file_index[file_id]].callback != NULL &&
                    (ramdump_trans_server_ram_conf[ramdump_export_file_index[file_id]].callback)() == RAMDUMP_FALSE)
                    server_to_pc_msg.file_size = 0;
                /* interactive data trans */
                ramdump_oss_data_trans_write(
                    (unsigned char*)(&server_to_pc_msg), 
                    sizeof(server_to_pc_msg));
            
                /* Started by AICoder, pid:2e42db9f80sd7e4145f809c4e0570d087c188fb0 */
#ifdef _USE_VEHICLE_DC
                if(!strncmp(server_to_pc_msg.file_name, RAMDUMP_CAP_DDR_BIN, strlen(RAMDUMP_CAP_DDR_BIN)))
                {
                    invalidate_kernel_vmap_range(ramdump_trans_server_ram_conf[ramdump_export_file_index[file_id]].vir ,
                                                 ramdump_trans_server_ram_conf[ramdump_export_file_index[file_id]].size);
                }
#endif
                /* Ended by AICoder, pid:2e42db9f80sd7e4145f809c4e0570d087c188fb0 */

                break;
            }
        case RAMDUMP_PC_FILE_DATA_TRANS_REQ:
            {
                ramdump_trans_server_data_trans_rsp server_to_pc_msg = {0};
                /* data from pc to server  */
                ramdump_pc_trans_data_req *pc_to_server_msg = (ramdump_pc_trans_data_req *)req_buf;
                file_id = pc_to_server_msg->file_id;
                /* data respond pc from server  */
                server_to_pc_msg.cmd = RAMDUMP_TRANS_SERVER_FILE_DATA_TRANS_RSP;
                server_to_pc_msg.buf_addr = 
                    (ramdump_trans_server_ram_conf[ramdump_export_file_index[file_id]].vir + 
                    pc_to_server_msg->offset);
                server_to_pc_msg.buf_left_size = pc_to_server_msg->length;
                /* interactive data trans */
                /* 
                 * TODO!
                 * now multiplex old interactive flow.
                 * need to be optimize, write once is better.
                 * like this ramdump_oss_data_trans_write((unsigned char *)(&server_to_pc_msg), 
                 * sizeof(server_to_pc_msg));
                 */
                ramdump_oss_data_trans_write(
                    (unsigned char *)(&(server_to_pc_msg.cmd)),
                    sizeof(server_to_pc_msg.cmd));
                ramdump_oss_data_trans_write_data(
                    (unsigned char *)(server_to_pc_msg.buf_addr), 
                    server_to_pc_msg.buf_left_size);
                
                continue;
            }
        case RAMDUMP_PC_FILE_TRANS_DONE_REQ:
            {
                unsigned long finish_cmd = RAMDUMP_TRANS_SERVER_FILE_TRANS_DONE_RSP;
                /* interactive data trans */
                ramdump_oss_data_trans_write(
                    (unsigned char *)(&finish_cmd), 
                    sizeof(finish_cmd));
                ramdump_oss_data_trans_done();
                ramdump_wait_delay(1000);
                return;
            }
        default:
            {
                unsigned long error_cmd = RAMDUMP_INTERACTIVE_CMD_ERROR;
                /* interactive data trans */
                ramdump_oss_data_trans_write((unsigned char *)(&error_cmd), 
                                              sizeof(error_cmd));
                break;
            }
        } 
    }
}

/*******************************************************************************
* :    ramdump_client_copy_data
* ˵:     
*   () void
*   () void
*   ֵ:    void
* ˵:    This function is used to create err log file
*******************************************************************************/
static void ramdump_trans_copy_data(void)
{
    unsigned long i_ram_conf = 0;

    while (ramdump_trans_server_ram_conf[i_ram_conf].phy != 0 && 
           ramdump_trans_server_ram_conf[i_ram_conf].size != 0)
    {
        if (ramdump_trans_server_ram_conf[i_ram_conf].flag == RAMDUMP_FLAG_NEED_COPY &&
            ramdump_trans_server_ram_conf[i_ram_conf].copy != 0 &&
           (ramdump_trans_server_ram_conf[i_ram_conf].phy != 
           ramdump_trans_server_ram_conf[i_ram_conf].copy))
            memcpy(
                ramdump_trans_server_ram_conf[i_ram_conf].copy,
                ramdump_trans_server_ram_conf[i_ram_conf].phy,
                ramdump_trans_server_ram_conf[i_ram_conf].size);
        i_ram_conf++;
    }
}

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ramdump_ram_conf_table_add
* ˵:     
*   ()  ram_name:    dump ram name
                ram_start:   dump ram start(virtual addr)
                ram_size:    dump ram size
                ram_virt:    dump ram virt addr
                ram_flag:    dump ram flag(copy/exter/callback)
                ram_extra:   dump ram extra access addr
*   ()  void
*   ֵ:     void
* ˵:     This function is used to add dump ram conf into public table
*******************************************************************************/
void ramdump_ram_conf_table_add(
        char *ram_name, 
        unsigned long ram_phy, 
        unsigned long ram_size, 
        unsigned long ram_virt,
        unsigned long ram_flag,
        unsigned long ram_extra)
{
    static unsigned int i_entry  = 0;
    
    if ((ram_phy == 0) && (ram_size == 0))
        return;

    mutex_lock(&ramdump_mutex);
    
    strncpy(ramdump_trans_server_ram_conf[i_entry].name, 
            ram_name, 
            RAMDUMP_RAMCONF_FILENAME_MAXLEN - 1);
    ramdump_trans_server_ram_conf[i_entry].name[RAMDUMP_RAMCONF_FILENAME_MAXLEN - 1] = '\0';
    ramdump_trans_server_ram_conf[i_entry].phy   = ram_phy;
    ramdump_trans_server_ram_conf[i_entry].size  = ram_size;
    ramdump_trans_server_ram_conf[i_entry].vir   = ram_virt;
    ramdump_trans_server_ram_conf[i_entry].flag  = ram_flag;

    switch (ram_flag & RAMDUMP_CLEAR_PRIO_FLAG)
    {
        case RAMDUMP_FLAG_NEED_COPY:
            ramdump_trans_server_ram_conf[i_entry].exter  = ram_extra;
            ramdump_trans_server_ram_conf[i_entry].flag = RAMDUMP_FLAG_HAS_EXTERNAL;
            break;
        case RAMDUMP_FLAG_HAS_EXTERNAL:
            ramdump_trans_server_ram_conf[i_entry].exter  = ram_extra;
            break;
        case RAMDUMP_FLAG_HAS_CALLBACK:
            ramdump_trans_server_ram_conf[i_entry].callback  = ram_extra;
            break;
        default:
            break;
    }
    
    if (ram_phy != 0 && ram_size != 0)
        ramdump_trans_server_ram_conf[i_entry].vir = ramdump_phy_to_vir(&ramdump_trans_server_ram_conf[i_entry]);
    
    i_entry++;
    
    if (i_entry >= RAMDUMP_RAMCONF_TABLE_MAX_ENTRYS)      
        i_entry = 0;

    ramdump_file_num ++;
    mutex_unlock(&ramdump_mutex); 
}
EXPORT_SYMBOL(ramdump_ram_conf_table_add);

/*******************************************************************************
* :     ramdump_init
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     RAMDUMP_SUCCESS or RAMDUMP_FAILED
* ˵:     This function is used for ramdump init
*******************************************************************************/
static int test_fun(void)
{
    return RAMDUMP_TRUE;
}

int ramdump_init(void)
{
    if (ramdump_server_init_flag == RAMDUMP_TRUE)
        return RAMDUMP_SUCCESS;

    int ret = 0;
    int i = 0;
    char bin_name[RAMDUMP_RAMCONF_FILENAME_MAXLEN] = {0};
    
    for(i = 0;i < meminfo.nr_banks;i++) {
        if(meminfo.bank[i].start == RAMDUMP_SERVER_DDR_BASE)
            ddr_ap_size = meminfo.bank[i].size;
    }
    BUG_ON(ddr_ap_size == 0);

    /* change the interactive cpu value */
    ramdump_cpu_id[RAMDUMP_CPU_2] = ICP_MSG_ACTOR_ZSP;
    
    /* client icp init */
    ret = ramdump_icp_init();
    if (ret != RAMDUMP_ICP_SUCCESS)
        return ret;

    sprintf(
        bin_name, 
        "%s-%s", 
        ramdump_cpu_name[RAMDUMP_CPU_1], 
        RAMDUMP_TRANS_SERVER_DDR_BINNAME);
    ramdump_ram_conf_table_add(
        bin_name, 
        RAMDUMP_SERVER_DDR_BASE, 
        ddr_ap_size, 
        (unsigned long)OSS_PHY_TO_VIRT(RAMDUMP_SERVER_DDR_BASE),
        RAMDUMP_FLAG_LEVEL_MEDIUM,
        0);

    ramdump_ram_conf_table_add(
        "AP_test_bus_call_false.bin", 
        RAMDUMP_SERVER_DDR_BASE, 
        0x1000, 
        (unsigned long)OSS_PHY_TO_VIRT(RAMDUMP_SERVER_DDR_BASE),
        RAMDUMP_FLAG_HAS_CALLBACK|RAMDUMP_FLAG_LEVEL_LOW,
        test_fun);
    
#ifdef CONFIG_MEM_TRACKER    
    ramdump_ram_conf_table_add(
        "mem_tracker.bin", 
        ZX29_MEM_TRACKER_PHYS, 
        ZX_MEM_TRACKER_SIZE,
        ZX_MEM_TRACKER_BASE,
        RAMDUMP_FLAG_LEVEL_LOW,
        0);
    ramdump_ram_conf_table_add(
        "kmalloc_tracker.bin", 
        ZX29_KMALLOC_TRACKER_PHYS,
        ZX_KMALLOC_TRACKER_SIZE,
        ZX_KMALLOC_TRACKER_BASE,
        RAMDUMP_FLAG_LEVEL_LOW,
        0);
#endif
#ifdef _USE_CAP_SYS
    /* cap ramdump cmm */
    ramdump_ram_conf_table_add(
            "cap_ddr.bin", 
            DDR_BASE_CAP_ADDR_PA, 
            *cap_ddr_size,
            0,
            RAMDUMP_FLAG_NONE,
            0);

    ramdump_ram_conf_table_add(
        "cap.cmm", 
        RAMDUMP_CAP_CMM_BUF_ADDR_PHY,
        RAMDUMP_CAP_CMM_BUF_LEN_REAL,
        0,
        RAMDUMP_FLAG_LEVEL_LOW,
        0);
    ramdump_ram_conf_table_add(
        "cap_err_log.txt", 
        RAMDUMP_CAP_LOG_BUF_ADDR,
        RAMDUMP_CAP_LOG_BUF_LEN,
        0,
        RAMDUMP_FLAG_LEVEL_HIGH,
        0);
    ramdump_ram_conf_table_add(
        "rpmsg_cap.bin", 
        ICP_CAP_BUF_ADDR_PA,
        ICP_CAP_BUF_LEN,
        0,
        RAMDUMP_FLAG_LEVEL_LOW,
        0);
    ramdump_ram_conf_table_add(
        "phy_log_buffer.bin", 
        TOOL_ZSP_TO_CAP_LOG_ADDR_PA,
        TOOL_ZSP_TO_CAP_LOG_LEN,
        0,
        RAMDUMP_FLAG_LEVEL_LOW,
        0);
    ramdump_ram_conf_table_add(
        "TEE.bin", 
        TEE_SHARE_BUF_ADDR_PA,
        TEE_SHARE_BUF_LEN,
        0,
        RAMDUMP_FLAG_LEVEL_LOW,
        0);
    ramdump_ram_conf_table_add(
        "cap_kapp_log.bin", 
        TOOL_CAP_BUF_ADDR_PA,
        TOOL_CAP_BUF_LEN,
        0,
        RAMDUMP_FLAG_LEVEL_LOW,
        0);
#endif

#ifdef _USE_VEHICLE_DC
    ramdump_shared_mem_init();
#endif

    /* set trans ram data done flag */
//    ramdump_trans_server_data_done_flag = RAMDUMP_SYNC_RAM_CONTENT_DONE;

    OSS_PRINTF("Ramdump server init success!\n");
    ramdump_server_init_flag = RAMDUMP_TRUE;

    return RAMDUMP_SUCCESS;
}
//OSS_INIT(ramdump_init); 
EXPORT_SYMBOL(ramdump_init);
extern void show_stack_state();

/*******************************************************************************
* :     ramdump_info
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for print ramdump info
*******************************************************************************/
void ramdump_info(void)
{
    if (CPPS_FUNC(cpps_callbacks, zOss_GetExceptResetFlag) != NULL)
    {
        if(CPPS_FUNC(cpps_callbacks, zOss_GetExceptResetFlag)() == 1)
            printk(KERN_EMERG "Ramdump info: Ramdump Except Reboot enabled!\n");
        else if(CPPS_FUNC(cpps_callbacks, zOss_GetExceptResetFlag)() == 2)
            printk(KERN_EMERG "Ramdump info: Ramdump Except Reboot after export!\n");
    }
    if (sysctl_ramdump_on_panic == FALSE)
        printk(KERN_EMERG "Ramdump info: Ramdump disabled!\n");
    printk(KERN_EMERG "Ramdump info: Current Process is: %s, pid is %i!\n", current->comm, current->pid);
    if (ramdump_trans_server_force_panic_flag == RAMDUMP_FALSE)
        zxic_reset_reason(1, "ap", current->comm); //ap ramdump
}

/*******************************************************************************
* :     ramdump_get_trans_mode
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for read ramdump mode
*******************************************************************************/
void ramdump_get_trans_mode(void)
{
#ifdef _USE_VEHICLE_DC 
    ramdump_export_mode = *(unsigned int *)RAMDUMP_EMMC_TRANS_FLAG_ADDR; 
#endif
}

/*******************************************************************************
* :     ramdump_entry
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump entry
*******************************************************************************/
void ramdump_entry (void)
{
    unsigned long flags;

#ifndef CONFIG_SYSTEM_RECOVERY
    if (CPPS_FUNC(cpps_callbacks, zOss_GetExceptResetFlag) != NULL)
    {
        if(CPPS_FUNC(cpps_callbacks, zOss_GetExceptResetFlag)() == 1)
            CPPS_FUNC(cpps_callbacks, zSys_ExceptReboot)(0);
    }
#else
    emergency_restart();
#endif

#ifdef CONFIG_ZX29_WATCHDOG
    zx_wdt_m0_stop();
#endif

    if (sysctl_ramdump_on_panic == FALSE)
        return;

    /*
     * we need lock the irq, this can`t be interrupt.
     */
    OSS_LOCK(flags);
#ifdef CONFIG_STACK_SIZE
    show_stack_state();
#endif
    if (!ramdump_server_init_flag)
        while(TRUE); /* endless circle */

    if (++ramdump_count > 1)
        while(TRUE); /* endless circle */

    ramdump_get_trans_mode();

    /*
     * save all regs first.
     */
    ramdump_arch_save_all_regs();

    //cmműĵ
    ramdump_trans_server_cmm_create();

    /* error log file */
    ramdump_trans_server_error_log_create();

    /* log buf */
    ramdump_oss_logbuf_create();

    /* notify client ramdump */
    ramdump_notify_client_dump();

    /* special data copy to the copy addr
     * then other core read from the copy addr
     */
    ramdump_trans_copy_data();

#ifndef __USE_TRANS_WITH_COLLECT__ // if not collect server, need to do this
    /* wait client all data done */
    ramdump_wait_clients_dump_done();
#endif

    /* caculate the true dump file num */
    //ramdump_dump_file_num_recalc();
    /* ram data trans to pc */
    ramdump_data_transfer_to_pc();

    /*
     * TODO! 
     * now endless circle, e.g., config restart or not is more better.
     */
#ifndef CONFIG_SYSTEM_RECOVERY
    if (CPPS_FUNC(cpps_callbacks, zOss_GetExceptResetFlag) != NULL)
    {
        if(CPPS_FUNC(cpps_callbacks, zOss_GetExceptResetFlag)() == 2)
            CPPS_FUNC(cpps_callbacks, zSys_ExceptReboot)(0);
        else
            while(TRUE);
    }
#endif
        while(TRUE);

    OSS_UNLOCK(flags);
}

#ifdef __cplusplus
}
#endif


MODULE_LICENSE("GPL");
