#include <softap_api.h>
#include <errno.h>
#include <wifi.h>
#include "wlan_interface.h"

/*char to hex*/
char c2x(char c)
{
    if ((c >= '0') && (c <= '9'))
    {
        return c - '0';
    }
    if ((c >= 'a') && (c <= 'f'))
    {
        return (c - 'a') + 10;
    }
    if ((c >= 'A') && (c <= 'F'))
    {
        return (c - 'A') + 10;
    }
    return 0;
}

/*string to hex*/
unsigned char s2x(char *s)
{
    int     i;
    char    str[3];
    unsigned char result;


    for (i = 0; i < 3; i++)
    {
        str[i] = *s++;
        if (str[i] == '\0')
        {
            break;
        }
    }

    result = 0;
    for (i = 0; i < 3; i++)
    {
        if (str[i] == '\0')
        {
            break;
        }
        result = (unsigned char)( c2x(str[i]) + (result << 4));
    }

    return result;
}

//cov
__attribute__((visibility("hidden"))) 
void base64_encode(const char* data, int data_len, char* encode, int encode_len) 
{ 
    //int data_len = strlen(data); 
    int prepare = 0; 
    int ret_len; 
    int temp = 0; 
    char *ret = NULL; 
    char *f = NULL; 
    int tmp = 0; 
    char changed[4]; 
    int i = 0; 
	const char base[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="; 

	if(data == NULL)
	{
		return;
	}
	if(encode == NULL)
	{
		return;
	}
	if(data_len == 0)
	{
		return;
	}
    ret_len = data_len / 3; 
    temp = data_len % 3; 
    if (temp > 0) 
    { 
        ret_len += 1; 
    } 
    ret_len = ret_len*4 + 1; 
    ret = (char *)malloc(ret_len); 
      
    if (ret == NULL) 
    { 
        printf("No enough memory.\n"); 
        return;
    } 
    memset(ret, 0, ret_len); 
    f = ret; 
    while (tmp < data_len) 
    { 
        temp = 0; 
        prepare = 0; 
        memset(changed, '\0', 4); 
        while (temp < 3) 
        { 
            //printf("tmp = %d\n", tmp); 
            if (tmp >= data_len) 
            { 
                break; 
            } 
            prepare = ((prepare << 8) | (data[tmp] & 0xFF)); 
            tmp++; 
            temp++; 
        } 
        prepare = (prepare<<((3-temp)*8)); 
        //printf("before for : temp = %d, prepare = %d\n", temp, prepare); 
        for (i = 0; i < 4 ;i++ ) 
        { 
            if (temp < i) 
            { 
                changed[i] = 0x40; 
            } 
            else 
            { 
                changed[i] = (prepare>>((3-i)*6)) & 0x3F; 
            } 
            *f = base[changed[i]]; 
            //printf("%.2X", changed[i]); 
            f++; 
        } 
    } 
    *f = '\0'; 
	strncpy(encode, ret, encode_len - 1);
    free(ret); //cov
} 

static int get_msg_qid(int module_id)
{
	int msg_qid=-1;
	printf("module_id = %d\n",module_id);
AGAIN:	
	msg_qid = msgget(module_id,0);
	
	if(msg_qid == -1)
	{
            printf("[%s] fail,module_id=%d, errno=%d\n", __FUNCTION__, module_id, errno);
        
    	    goto AGAIN;
	}
	
	return msg_qid;
	
}
#if 0 //kw 3
int pipecmd(const char *cmd, char *result) 
{
    FILE *pp = NULL;
    int tmp_len = 0;
    char tmp[128]={0};

    if (cmd == NULL)
    {
        return -1;
    }
    
    pp = popen(cmd, "r"); //ܵ
    if (!pp)
    {
        return -1;
    }

    if (result != NULL)
    {
	    while (fgets(tmp, sizeof(tmp), pp) != NULL) 
	    {
	        tmp_len = strlen(tmp);
	        if (tmp_len > 0)
	        {
	            if (tmp[tmp_len - 1] == '\n') 
	            {
	                tmp[tmp_len - 1] = '\0'; //ȥз
	            }

	            strncpy(result,tmp,tmp_len);
	            printf("[%s]pcmd:tmp = %s\n",__FUNCTION__, tmp);
	        }
	    }
    }
    pclose(pp); //رչܵ
    return 0;
}
#endif
#ifdef __NO_WIFI__
void zte_get_wifi_sta_list(RT_802_11_MAC_TABLE *staList)
{
	printf("[%s]WIFI function closed\n", __FUNCTION__);
}

int zte_wlan_capture_sta_num()
{
	printf("[%s]WIFI function closed\n", __FUNCTION__);
    return 0;
}

int get_channel()
{
	printf("[%s]WIFI function closed\n", __FUNCTION__);
	return 1;
}

#endif

