DESCRIPTION = "fsmonitor"
DEPENDS     = "libflags"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
		  file://fsmonitor \
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://fsmonitor.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://fsmonitor.service","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://fsmonitor.sysvinit","", d)} \
          "
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"
S_SRC_PATH = "${S}/fsmonitor"

#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
include ${BSPDIR}/sources/meta-zxic/conf/pub.inc
CFLAGS_append = "${ZXIC_EXTRA_CFLAGS}"


do_compile() {
	make -C ${S_SRC_PATH}
}

do_install () {
	install -d ${D}${bindir}/		
	install -m 0755 ${S_SRC_PATH}/fsmonitor ${D}${bindir}/
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/fsmonitor.init ${D}${sysconfdir}/init.d/fsmonitor
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/fsmonitor.service ${D}${systemd_unitdir}/system
	fi
	
	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/fsmonitor.sysvinit ${D}${sysconfdir}/init.d/fsmonitor
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/fsmonitor ${D}${sysconfdir}/rcS.d/S75ubi_nl
		ln -s ../init.d/fsmonitor ${D}${sysconfdir}/rcS.d/K25ubi_nl
	fi
	
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S_SRC_PATH}/fsmonitor ${ELFS-PATH}/
}

do_cleanlibs () {
	rm -fr ${ELFS-PATH}/fsmonitor
	rm -fr ${D}${bindir}/fsmonitor
}

addtask  cleanlibs after do_clean  before do_cleansstate

FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/fsmonitor","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "fsmonitor.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"

#RDEPENDS_${PN} = ""
