DESCRIPTION = "atchn_test"
DEPENDS     = "libatchn libsoftap libnvram libsofttimer"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}:"
SRC_URI = " \
          file://test/atchn_test \
		  file://platform/libatchn/inc \
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://atchn_test.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://atchn_test.service","", d)} \
          "
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"
S_SRC_PATH = "${S}/test/atchn_test"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#inherit autotools pkgconfig systemd

do_compile() {
	make -C ${S_SRC_PATH}
}

do_install () {
	install -d ${D}${bindir}/
	install -m 0755 ${S_SRC_PATH}/atchn_test ${D}${bindir}/
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/atchn_test.init ${D}${sysconfdir}/init.d/atchn_test
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/atchn_test.service ${D}${systemd_unitdir}/system
	fi
	
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S_SRC_PATH}/atchn_test ${ELFS-PATH}/	
}

do_cleanlibs () {
	rm -fr ${ELFS-PATH}/atchn_test
}

addtask  cleanlibs after do_clean  before do_cleansstate

FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/atchn_test","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "atchn_test.service"
SYSTEMD_AUTO_ENABLE_${PN} = "disable"

RDEPENDS_${PN} = " libatchn libsoftap libnvram libsofttimer"
