DESCRIPTION = "libbinder"
DEPENDS     = ""
SECTION     = "lib"
LICENSE     = "zte"
PV          = "1.0.0"
PR          = "r0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/sdk:"
SRC_URI = " \
          file://binder \
          "

S = "${WORKDIR}"
#引用公用头文件和编译选项。
#include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#编译
do_compile () {
	make -C binder
}

#库和头文件的安装
do_install () {
	install -d ${D}${libdir}/
	install -d ${D}/usr/include/android
	install -d ${D}/usr/include/binder
	install -d ${D}/usr/include/cutils
	install -d ${D}/usr/include/linux
	install -d ${D}/usr/include/log
	install -d ${D}/usr/include/private
	install -d ${D}/usr/include/private/binder
	install -d ${D}/usr/include/system
	install -d ${D}/usr/include/utils
	
	install -m 0755 ${S}/binder/libbinder.so  ${D}${libdir}/
	install -m 0755 ${S}/binder/libcutils/libcutils.so  ${D}${libdir}/
	install -m 0755 ${S}/binder/liblog/liblog.so  ${D}${libdir}/
	install -m 0755 ${S}/binder/libutils/libutils.so  ${D}${libdir}/

	install -m 0644 ${S}/binder/include/android/*.h ${D}/usr/include/android
	install -m 0644 ${S}/binder/include/binder/*.h ${D}/usr/include/binder
	install -m 0644 ${S}/binder/include/cutils/*.h ${D}/usr/include/cutils
	install -m 0644 ${S}/binder/include/linux/*.h ${D}/usr/include/linux
	install -m 0644 ${S}/binder/include/log/*.h ${D}/usr/include/log
	install -m 0644 ${S}/binder/include/private/*.h ${D}/usr/include/private
	install -m 0644 ${S}/binder/include/private/binder/*.h ${D}/usr/include/private/binder
	install -m 0644 ${S}/binder/include/system/*.h ${D}/usr/include/system
	install -m 0644 ${S}/binder/include/utils/*.h ${D}/usr/include/utils
	
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/binder/libbinder.so ${ELFS-PATH}/
	install -m 0755 ${S}/binder/libcutils/libcutils.so ${ELFS-PATH}/
	install -m 0755 ${S}/binder/liblog/liblog.so ${ELFS-PATH}/
	install -m 0755 ${S}/binder/libutils/libutils.so ${ELFS-PATH}/
}

#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/libbinder.so
	rm -fr ${ELFS-PATH}/libcutils.so
	rm -fr ${ELFS-PATH}/liblog.so
	rm -fr ${ELFS-PATH}/libutils.so
}

#rootfs包含的文件
FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"
