DESCRIPTION = "libbsp"
#DEPENDS    = "libnvram"
SECTION     = "lib"
LICENSE     = "zte"
PV          = "1.0.0"
PR          = "r0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/sdk:"
SRC_URI = " \
           file://libbsp \
          "

S       = "${WORKDIR}"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
include ${BSPDIR}/sources/meta-zxic/conf/pub.inc

do_compile () {
	make -C libbsp
}

#库和头文件的安装
do_install () {
	install -d ${D}${libdir}/
	install -d ${D}/usr/include
	install -m 0755 ${S}/libbsp/libbsp.so  ${D}${libdir}/
	install -m 0755 ${S}/libbsp/libbsp.a   ${D}${libdir}/
	install -m 0644 ${S}/libbsp/sc_uart.h     ${D}/usr/include/
	install -m 0644 ${S}/libbsp/sc_i2c.h     ${D}/usr/include/
	install -m 0644 ${S}/libbsp/sc_spi.h     ${D}/usr/include/
	install -m 0644 ${S}/libbsp/sc_gpio.h     ${D}/usr/include/
	install -m 0644 ${S}/libbsp/sc_irq.h     ${D}/usr/include/
	install -m 0644 ${S}/libbsp/sc_pm.h     ${D}/usr/include/
	install -m 0644 ${S}/libbsp/sc_bsp.h     ${D}/usr/include/
	install -m 0644 ${S}/libbsp/sc_eth.h     ${D}/usr/include/
	install -m 0644 ${S}/libbsp/sc_adc.h     ${D}/usr/include/
	install -m 0644 ${S}/libbsp/sc_tsc.h     ${D}/usr/include/
	install -m 0644 ${S}/libbsp/sc_usb.h     ${D}/usr/include/

	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/libbsp/libbsp.so ${ELFS-PATH}/

}

#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/libbsp.so
}


FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"

