DESCRIPTION = "libcodec"
DEPENDS     = ""
SECTION     = "lib"
LICENSE     = "zte"
PV          = "1.0.0"
PR          = "r0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
          file://libcodec \
          "		 

S = "${WORKDIR}"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#编译
#do_compile () {
#	make -C libcodec
#}

#库和头文件的安装
do_install () {
	install -d ${D}${libdir}/

	install -d ${D}/usr/include
	install -d ${D}/usr/include/libavcodec
	install -d ${D}/usr/include/libavformat
	install -d ${D}/usr/include/libavutil
	
	install -d ${D}/usr/include/opencore-amrnb
	install -d ${D}/usr/include/opencore-amrwb
	
	install -d ${D}/usr/include/vo-amrwbenc
	install -d ${D}/usr/include/fdk-aac

	install -m 0755 ${S}/libcodec/lib/*.a   ${D}${libdir}/
	
	install -m 0644 ${S}/libcodec/include/libavcodec/*.h ${D}/usr/include/libavcodec
	install -m 0644 ${S}/libcodec/include/libavformat/*.h ${D}/usr/include/libavformat
	install -m 0644 ${S}/libcodec/include/libavutil/*.h ${D}/usr/include/libavutil
	
	install -m 0644 ${S}/libcodec/include/opencore-amrnb/*.h ${D}/usr/include/opencore-amrnb
	install -m 0644 ${S}/libcodec/include/opencore-amrwb/*.h ${D}/usr/include/opencore-amrwb
	
	install -m 0644 ${S}/libcodec/include/vo-amrwbenc/*.h ${D}/usr/include/vo-amrwbenc
	install -m 0644 ${S}/libcodec/include/fdk-aac/*.h ${D}/usr/include/fdk-aac

	
	#install elfs
	install -d ${ELFS-PATH}/

	install -m 0755 ${S}/libcodec/lib/*.a ${ELFS-PATH}/
}

#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/libfdk-aac.a
	rm -fr ${ELFS-PATH}/libvo-amrwbenc.a
	rm -fr ${ELFS-PATH}/libopencore-amrnb.a
	rm -fr ${ELFS-PATH}/libopencore-amrwb.a
	rm -fr ${ELFS-PATH}/libavcodec.a
	rm -fr ${ELFS-PATH}/libavformat.a
	rm -fr ${ELFS-PATH}/libavutil.a
}

#rootfs包含的文件
FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"
