DESCRIPTION = "libtelsvr"
SECTION     = "lib"
LICENSE     = "zte"
PV          = "1.0.0"
PR          = "r0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
          file://libtelsvr \
          "

S = "${WORKDIR}"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#编译
do_compile () {
	make -C libtelsvr
}

#库和头文件的安装
do_install () {
	install -d ${D}${libdir}/
	install -d ${D}/usr/include	
	install -d ${D}/etc_ro/sc_tel/system/data
	install -d ${D}/etc_ro/sc_tel/zbl/sms
	#install -m 0755 ${S}/libtelsvr/libtelsvr.so  ${D}${libdir}/
	install -m 0755 ${S}/libtelsvr/lib/libtelsvr.a   ${D}${libdir}/
	
	install -m 0644 ${S}/libtelsvr/include/*.h ${D}/usr/include/
	install -m 0644 ${S}/libtelsvr/include/pal/os/*.h ${D}/usr/include/
	install -m 0644 ${S}/libtelsvr/include/pal/dm/*.h ${D}/usr/include/
	
	#install elfs
	install -d ${ELFS-PATH}/

	install -m 0755 ${S}/libtelsvr/lib/libtelsvr.a ${ELFS-PATH}/
	install -m 0644 ${S}/libtelsvr/sc_tel/system/data/* ${D}/etc_ro/sc_tel/system/data/
	install -m 0644 ${S}/libtelsvr/sc_tel/zbl/sms/* ${D}/etc_ro/sc_tel/zbl/sms/
	install -m 0644 ${S}/libtelsvr/sc_tel/zbl/zbl_config.cfg ${D}/etc_ro/sc_tel/zbl/
}

#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/libtelsvr.a
}

#rootfs包含的文件
FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}       += "etc_ro/"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"
