/**
 * @file Netapi.c
 * @brief Implementation of Sanechips
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author linxu Gebin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <syslog.h>
#include <sys/klog.h>
#include <sys/msg.h>
#include <sys/socket.h>
#include <linux/sockios.h>
#include <sys/un.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "softap_api.h"
#include <net/if.h>

/************************ ӿ ************************/



//豸ȡӦ豸ID,ȼNVе豸ƥ䣬ʧܷ-1
int getDevId_byname(char *dev_name)
{
	char ps_wan[NETIF_NAME_LEN] = {0};
	char psext_wan1[NETIF_NAME_LEN] = {0};
	char psext_wan2[NETIF_NAME_LEN] = {0};
	char psext_wan3[NETIF_NAME_LEN] = {0};
	char psext_wan4[NETIF_NAME_LEN] = {0};
	char psext_wan5[NETIF_NAME_LEN] = {0};
	char psext_wan6[NETIF_NAME_LEN] = {0};
	char psext_wan7[NETIF_NAME_LEN] = {0};
	char psext_wan8[NETIF_NAME_LEN] = {0};
	char swwanstr[NETIF_NAME_LEN] = {0};
	char swlanstr[NETIF_NAME_LEN] = {0};
	char eth_wan[NETIF_NAME_LEN] = {0};
	char wifi_wan[NETIF_NAME_LEN] = {0};
	char eth_lan[NETIF_NAME_LEN] = {0};
	char wifi_lan[NETIF_NAME_LEN] = {0};
	char usb_lan[NETIF_NAME_LEN] = {0};
	char sw_name[NV_NAME_LEN] = {0};
	char lan_enable[NV_NAME_LEN] = {0};
	printf("netapi:getDevId_byname start!dev_name=%s\n", dev_name);

	//ȱʡΪʱҲطϢadd by zpm 20160628 begin
	if (strlen(dev_name) == 0) {
		return NO_DEV;
	}
	//ȱʡΪʱҲطϢadd by zpm 20160628 end

	sc_cfg_get("pswan", ps_wan, sizeof(ps_wan));
	sc_cfg_get("ps_ext1", psext_wan1, sizeof(psext_wan1));
	sc_cfg_get("ps_ext2", psext_wan2, sizeof(psext_wan2));
	sc_cfg_get("ps_ext3", psext_wan3, sizeof(psext_wan3));
	sc_cfg_get("ps_ext4", psext_wan4, sizeof(psext_wan4));
	sc_cfg_get("ps_ext5", psext_wan5, sizeof(psext_wan1));
	sc_cfg_get("ps_ext6", psext_wan6, sizeof(psext_wan2));
	sc_cfg_get("ps_ext7", psext_wan7, sizeof(psext_wan3));
	sc_cfg_get("ps_ext8", psext_wan8, sizeof(psext_wan4));
	sc_cfg_get("wifiwan", wifi_wan, sizeof(wifi_wan));
	sc_cfg_get("swwanstr", swwanstr, sizeof(swwanstr));
	sc_cfg_get("swlanstr", swlanstr, sizeof(swlanstr));
	sc_cfg_get("ethwan", eth_wan, sizeof(eth_wan));
	sc_cfg_get("ethlan", eth_lan, sizeof(eth_lan));
	sc_cfg_get("wifilan", wifi_lan, sizeof(wifi_lan));
	sc_cfg_get("usblan", usb_lan, sizeof(usb_lan));
	sc_cfg_get("sw", sw_name, sizeof(sw_name));
	sc_cfg_get("LanEnable", lan_enable, sizeof(lan_enable));

	if (!strncmp(dev_name, ps_wan, strlen(dev_name)))
		return PS_NET_DEV;
	if ((0 != strcmp(lan_enable, "0")) && !strncmp(dev_name, usb_lan, strlen(dev_name)))
		return USB_LAN_DEV;
	if (!strncmp(dev_name, psext_wan1, strlen(dev_name)))
		return PS_EXT_DEV1;
	if (!strncmp(dev_name, psext_wan2, strlen(dev_name)))
		return PS_EXT_DEV2;
	if (!strncmp(dev_name, psext_wan3, strlen(dev_name)))
		return PS_EXT_DEV3;
	if (!strncmp(dev_name, psext_wan4, strlen(dev_name)))
		return PS_EXT_DEV4;
	if (!strncmp(dev_name, psext_wan5, strlen(dev_name)))
		return PS_EXT_DEV5;
	if (!strncmp(dev_name, psext_wan6, strlen(dev_name)))
		return PS_EXT_DEV6;
	if (!strncmp(dev_name, psext_wan7, strlen(dev_name)))
		return PS_EXT_DEV7;
	if (!strncmp(dev_name, psext_wan8, strlen(dev_name)))
		return PS_EXT_DEV8;
	//һRJ45ʱʼյãټeth_typeʵ
	if (!strncmp(dev_name, eth_wan, strlen(dev_name)) || !strncmp(dev_name, swwanstr, strlen(dev_name)))
		return RJ45_WAN_DEV;
	//RJ45ʱڴһ̶RJ45
	if (!strncmp(dev_name, eth_lan, strlen(dev_name)) || !strncmp(dev_name, swlanstr, strlen(dev_name)))
		return RJ45_LAN_DEV;
	if (!strncmp(dev_name, wifi_wan, strlen(dev_name)))
		return WIFI_WAN_DEV;
	if (!strncmp(dev_name, wifi_lan, strlen(dev_name)))
		return WIFI_LAN_DEV;

	return -1;
}

/**************************************************************************
* ƣ set_pswanstate
*  ps豸IPv6״̬NVֵ
* ˵ c_id(IN) :PDPc_id
*            state(IN):豸״̬
*   ֵ
* ˵
**************************************************************************/

static void set_pswan_v6state(int c_id, int state)
{
	char ps_wan[NV_NAME_LEN] = {0};
	char pswan_state[NETIF_NAME_LEN] = {0};

	sc_cfg_get("pswan", ps_wan, sizeof(ps_wan));

	snprintf(pswan_state, sizeof(pswan_state), "%s%d_ipv6_state", ps_wan, c_id);

	if (state == DEV_STATE_WORKING) {
		sc_cfg_set(pswan_state, "working");
		return;
	}

	if (state == DEV_STATE_CONNECT) {
		sc_cfg_set(pswan_state, "connect");
		return;
	}
	if (state == DEV_STATE_DEAD) {
		sc_cfg_set(pswan_state, "dead");
		return;
	}
}

static int pdp_state_check(struct pdp_active_info *actinfo)
{
	char pdp_act_state[NV_NAME_LEN] = {0};
	char nv_pdp_state[NV_NAME_LEN] = {0};
	sprintf(nv_pdp_state, "pdp_act_state_%d", actinfo->c_id);
	sc_cfg_get(nv_pdp_state, pdp_act_state, sizeof(pdp_act_state));
	if (0 != strcmp(pdp_act_state, "act")) {
		sc_cfg_set(nv_pdp_state, "acting");
		return 0;
	}
	return 1;
}

static void plugin_state_set(unsigned char netdev_id)
{
	int plugstate;
	char rj45_pluginstate[NV_NAME_LEN] = {0};
	char temp[NV_NAME_LEN] = {0};
	sc_cfg_get("rj45_pluginstate", rj45_pluginstate, sizeof(rj45_pluginstate));

	plugstate = atoi(rj45_pluginstate);
	if (netdev_id == RJ45_WAN_DEV || netdev_id == SW_WAN_DEV) {
		plugstate |= RJ45_WAN_IN;
		sprintf(temp, "%d", plugstate);
		sc_cfg_set("rj45_pluginstate", temp);
	} else if (netdev_id == RJ45_LAN_DEV || netdev_id == SW_LAN_DEV) {
		plugstate |= RJ45_LAN_IN;
		sprintf(temp, "%d", plugstate);
		sc_cfg_set("rj45_pluginstate", temp);
	} else if (netdev_id == USB_LAN_DEV) {
		plugstate = USB_LAN_IN;
		sprintf(temp, "%d", plugstate);
		sc_cfg_set("usb_pluginstate", temp);
	} else if (netdev_id >= PS_EXT_DEV1 && netdev_id <= PS_EXT_DEV8) {
		sprintf(temp, "psext%d_pluginstate", netdev_id);
		sc_cfg_set(temp, "1");
	}
}

static void plugout_state_set(unsigned char netdev_id)
{
	int plugstate;
	char rj45_pluginstate[NV_NAME_LEN] = {0};
	char temp[NV_NAME_LEN] = {0};

	sc_cfg_get("rj45_pluginstate", rj45_pluginstate, sizeof(rj45_pluginstate));
	plugstate = atoi(rj45_pluginstate);

	if (netdev_id == RJ45_WAN_DEV || netdev_id == SW_WAN_DEV) {
		plugstate &= ~RJ45_WAN_IN;
		sprintf(temp, "%d", plugstate);
		sc_cfg_set("rj45_pluginstate", temp);
	} else if (netdev_id == RJ45_LAN_DEV || netdev_id == SW_LAN_DEV) {
		plugstate &= ~RJ45_LAN_IN;
		sprintf(temp, "%d", plugstate);
		sc_cfg_set("rj45_pluginstate", temp);
	} else if (netdev_id == USB_LAN_DEV) {
		plugstate = USB_LAN_OUT;
		sprintf(temp, "%d", plugstate);
		sc_cfg_set("usb_pluginstate", temp);
	} else if (netdev_id >= PS_EXT_DEV1 && netdev_id <= PS_EXT_DEV8) {
		sprintf(temp, "psext%d_pluginstate", netdev_id);
		sc_cfg_set(temp, "0");
	}
}

/**************************************************************************
* ƣ pdp_act_proc
*  PS豸ӿ
* ˵ pdp_active_info(IN):PDPϢ
*   ֵ ɹ1.
* ˵ atӦý̵ãatserverpcserverVoLTEŵӦỵ́
* ӿڲʵֶڵPS豸ļӦ
**************************************************************************/
int ppp_act_proc(char *ttyname)
{
	char cmd[200] = {0};
	char path_sh[50] = {0};

	slog(NET_PRINT, SLOG_ERR, "netapi:calling ppp_act_proc, %s\n", ttyname);
	sc_cfg_set("ppp_pdpstate", "");
	sc_cfg_get("path_sh", path_sh, sizeof(path_sh));
	if (!ttyname)
		return -1;
	sprintf(cmd, "%s/pppd_up.sh %s", path_sh, ttyname);
	slog(NET_PRINT, SLOG_ERR, "cmd is %s\n", cmd);
	soft_system(cmd);
	return 0;
}

int pdp_act_proc(struct pdp_active_info *actinfo, int src_id)
{
	int ret = 0;
	//klocwork
	//int c_id = actinfo->c_id;
	//unsigned char ip46flag = actinfo->act_info.ip46flag;

	system("cat /proc/uptime 1>dev/console 2>&1");
	
	if (!actinfo || actinfo->act_info.ip46flag == V4V6_INVALID) {
		slog(NET_PRINT, SLOG_ERR, "pdp_act_proc, src_id = %d, actinfo->act_info.ip46flag == V4V6_INVALID\n", src_id);

		softap_assert("ip46flag error"); //klocwork
		return -1;
	}
	slog(NET_PRINT, SLOG_ERR, "netapi:pdp_act_proc: src_id=0x%x, cid=%d pdp_type=%u ip46flag=%u\n", src_id, actinfo->c_id, actinfo->pdp_type, actinfo->act_info.ip46flag);

#if 1  // cov M  actinfo->pdp_type is unsigned, could not compare with 0
    if (PDP_PPP < actinfo->pdp_type) {
#else
	if (PDP_PPP < actinfo->pdp_type || PDP_LOCAL > actinfo->pdp_type) {
#endif        

		slog(NET_PRINT, SLOG_ERR, "pdp_act_proc, src_id = %d, pdp_type is error: cid=%d pdp_type=%u ip46flag=%u\n", src_id, actinfo->c_id, actinfo->pdp_type, actinfo->act_info.ip46flag);
		softap_assert("pdp_type=%u error", actinfo->pdp_type);
		return -1;
	}

	if (1 == pdp_state_check(actinfo)) {

		slog(NET_PRINT, SLOG_ERR, "pdp_act_init: already act c_id = %d, src_id = %d\n", actinfo->c_id, src_id);
		//softap_assert("already act");
		return -1;
	}

	if (actinfo->act_info.ip46flag == V6_VALID || actinfo->act_info.ip46flag == V46_VALID) {
		set_pswan_v6state(actinfo->c_id, DEV_STATE_CONNECT);
	}

	ret = ipc_send_message(src_id, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_PDP_ACT, sizeof(struct pdp_active_info), (UCHAR *)actinfo, 0);  /*lint !e26 !e55*/
	if (0 != ret) {
		softap_assert("send msg to zte_router error");
		return -1;
	}

	slog(NET_PRINT, SLOG_ERR, "pdp_act_proc: success!\n");
	return 0;
}

/**************************************************************************
* ƣ pdp_deact_proc
*  PS豸ȥӿ
* ˵ c_id(IN):PDPc_id.
*   ֵ ɹ1.
* ˵ atӦý̵ãatserverpcserverVoLTEŵӦỵ́
ӿڲʵֶڵPS豸ȥ֧46ջȥҪָʾ46
**************************************************************************/
int pdp_deact_proc(int c_id, unsigned char ip46flag, int src_id)
{
	int ret = 0;
	struct pdp_deactive_info temp;
	char nv_pdp_state[NV_NAME_LEN] = {0};

	slog(NET_PRINT, SLOG_ERR, "netapi:pdp_deact_proc: src_id=%d, cid=%d ip46flag=%u\n", src_id, c_id, ip46flag);

	sprintf(nv_pdp_state, "pdp_act_state_%d", c_id);

	temp.c_id = c_id;
	temp.ip46flag = ip46flag;

	if (ip46flag == V4V6_INVALID) {
		slog(NET_PRINT, SLOG_ERR, "pdp_deact_proc,src_id = %d, ip46flag is error: cid=%d ip46flag=%u\n", src_id, c_id, ip46flag);
		softap_assert("ip46flag=%u error", ip46flag);
		return -1;
	}

	sc_cfg_set(nv_pdp_state, "deacting");
	ret = ipc_send_message(src_id, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_PDP_DEACT, sizeof(struct pdp_deactive_info), (UCHAR *)&temp, 0); /*lint !e26 !e55*/
	if (0 != ret) {
		softap_assert("send msg to zte_router error");
		return -1;
	}
	slog(NET_PRINT, SLOG_ERR, "pdp_deact_proc: success!\n");
	return 0;
}

/**************************************************************************
* ƣ netdev_connect_internet
*  webui͵,ӿڲifconfig upӦĵַ
* ˵ netdev_id豸ӦĺμUSB_NET_DEVȺֵ
*   ֵ ɹ1.
* ˵ 豸ģô˽ӿǰҪ⵱ǰ豸ͨ·ͨӦõô˽ӿڣ
* ģҪϿظĵøýӿڣΪÿһθýӿڣڲԻִһĵַ̣
**************************************************************************/
int netdev_connect_internet(unsigned char netdev_id, int src_id)
{
	int ret = 0;

	slog(NET_PRINT, SLOG_ERR, "netapi:netdev_connect_internet: netdev_id=%u\n", netdev_id);

	if (netdev_id != RJ45_WAN_DEV && netdev_id != WIFI_WAN_DEV && netdev_id != RJ45_LAN_DEV && netdev_id != WIFI_LAN_DEV) {
		slog(NET_PRINT, SLOG_ERR, "connect_internet:%u don't support connect op!\n", netdev_id);
		softap_assert("netdev_id=%d error", netdev_id);
		return 0;
	}

	ret = ipc_send_message(src_id, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_CONNECT, sizeof(unsigned char), (UCHAR *)&netdev_id, 0); /*lint !e26 !e55*/
	if (0 != ret) {
		softap_assert("send msg to zte_router error");
		return 0;
	}
	return 1;
}

/**************************************************************************
* ƣ netdev_disconnect_internet
*  webui͵ĶϿ,ӿڲifconfig downɱӦĵַ
* ˵ netdev_id豸ӦĺμUSB_NET_DEVȺֵ
*   ֵ ɹ1.
* ˵ 豸ģô˽ӿ
**************************************************************************/
int netdev_disconnect_internet(unsigned char netdev_id, int src_id)
{
	int ret = 0;

	printf("netapi:netdev_disconnect_internet start!netdev_id=%u\n", netdev_id);
	slog(NET_PRINT, SLOG_ERR, "netapi:netdev_disconnect_internet: netdev_id=%u\n", netdev_id);

	if (netdev_id != RJ45_WAN_DEV && netdev_id != WIFI_WAN_DEV && netdev_id != RJ45_LAN_DEV && netdev_id != WIFI_LAN_DEV) {
		slog(NET_PRINT, SLOG_ERR, "disconnect_internet:%u don't support disconnect op!\n", netdev_id);
		softap_assert("netdev_id=%d error", netdev_id);

		return 0;
	}

	ret = ipc_send_message(src_id, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_DISCON, sizeof(unsigned char), (UCHAR *)&netdev_id, 0); /*lint !e26 !e55*/
	if (0 != ret) {
		softap_assert("send msg to zte_router error");
		return 0;
	}
	return 1;
}

/**************************************************************************
* ƣ netdev_plugin_proc_byname
*  Ȳ豸,ӿڲǷҪԶţҪִеַ䡢
* ˵ netdev_name豸source_id plugģID
*   ֵ ɹ1.
* ˵ 豸صô˽ӿʱ豸ͨ·ͨԽIPݰշ
**************************************************************************/
int netdev_plugin_proc_byname(char *netdev_name, int src_id)
{
	int netdev_id = 0;
	slog(NET_PRINT, SLOG_ERR, "netdev_plugin_byname, netdev %s is plugin, src_id = %d\n", netdev_name, src_id);
	netdev_id = getDevId_byname(netdev_name);

	if (netdev_id == -1) {
		slog(NET_PRINT, SLOG_ERR, "netdev_plugin_proc_byname,netdev_name is error,please connect main control");
		return -1;
	} else {
		return netdev_plugin_proc(netdev_id, src_id);
	}
}

/**************************************************************************
* ƣ netdev_plugout_proc
*  Ȳ豸γ,ӿڲifconfig downɱӦĵַ
* ˵ netdev_name豸source_id plugģID
*   ֵ ɹ1.
* ˵ 豸صô˽ӿʱ豸ͨ·ѶϣҪٽIPݰշ
**************************************************************************/
int netdev_plugout_proc_byname(char *netdev_name, int src_id)
{
	int netdev_id = 0;
	slog(NET_PRINT, SLOG_ERR, "netdev_plugout_byname, netdev %s is plugout, src_id = %d\n", netdev_name, src_id);
	netdev_id = getDevId_byname(netdev_name);

	if (netdev_id == -1) {
		slog(NET_PRINT, SLOG_ERR, "netdev_plugout_proc_byname,netdev_name is error,please connect main control");
		return -1;
	} else {
		return netdev_plugout_proc(netdev_id, src_id);
	}
}

/**************************************************************************
* ƣ netdev_plugin_proc
*  Ȳ豸,ӿڲǷҪԶţҪִеַ䡢
* ˵ netdev_id豸ӦĺμUSB_NET_DEVȺֵ
*   ֵ ɹ1.
* ˵ 豸صô˽ӿʱ豸ͨ·ͨԽIPݰշ
**************************************************************************/
int netdev_plugin_proc(unsigned char netdev_id, int src_id)
{
	int ret = 0;

	printf("netapi:netdev_plugin_proc start!netdev_id=%u\n", netdev_id);
	slog(NET_PRINT, SLOG_ERR, "netapi:netdev_plugin_proc: netdev_id=%u\n", netdev_id);
	plugin_state_set(netdev_id);
	ret = ipc_send_message2(src_id, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_PLUGIN, sizeof(unsigned char), (UCHAR *)&netdev_id, 0); /*lint !e26 !e55*/

	if (0 != ret) {
		softap_assert("send msg to zte_router error");
		return 0;
	}
#ifdef _USE_MBIM	
	slog(NET_PRINT, SLOG_ERR, "netapi:netdev_plugin_proc: send MSG_CMD_NET_PLUGIN to MBIM\n");
	ipc_send_message2(src_id, MODULE_ID_MBIM, MSG_CMD_NET_PLUGIN, sizeof(unsigned char), (UCHAR *)&netdev_id, 0); 
#endif
	return 1;
}

/**************************************************************************
* ƣ netdev_plugout_proc
*  Ȳ豸γ,ӿڲifconfig downɱӦĵַ
* ˵ netdev_id豸ӦĺμUSB_NET_DEVȺֵ
*   ֵ ɹ1.
* ˵ 豸صô˽ӿʱ豸ͨ·ѶϣҪٽIPݰշ
**************************************************************************/
int netdev_plugout_proc(unsigned char netdev_id, int src_id)
{
	int ret = 0;

	printf("netapi:netdev_plugout_proc start!netdev_id=%u\n", netdev_id);
	slog(NET_PRINT, SLOG_ERR, "netapi:netdev_plugout_proc: netdev_id=%u\n", netdev_id);
	plugout_state_set(netdev_id);
	slog(NET_PRINT, SLOG_ERR, "netdev_plugout_proc: netdev_id=%u\n", netdev_id);
	ret = ipc_send_message2(src_id, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_PLUGOUT, sizeof(unsigned char), (UCHAR *)&netdev_id, 0); /*lint !e26 !e55*/

	if (0 != ret) {
		softap_assert("send msg to zte_router error");
		return 0;
	}
#ifdef _USE_MBIM
	ipc_send_message2(src_id, MODULE_ID_MBIM, MSG_CMD_NET_PLUGOUT, sizeof(unsigned char), (UCHAR *)&netdev_id, 0);
#endif
	return 1;
}
/********************************************************************
* ƣ tcpip_reset_configure
*  ָʱzte_blc̵ãɾɵļ
* ˵ 
*   ֵ 
* ˵
**********************************************************************/
void tcpip_reset_configure()
{
	char cmd[200] = {0};
	char path_script[50] = {0};
	char path_conf[50] = {0};
	char path_file[200] = {0};
	printf("netapi:tcpip_reset_configure start!\n");
	sc_cfg_get("path_conf", path_conf, sizeof(path_conf));
	sprintf(path_file, "%s/hostname_mac_file", path_conf);


	//ָʱɾhostname_mac_fileļ
	sprintf(cmd, "/bin/rm -rf %s", path_file);
	zxic_system(cmd);
	//ָʱɾstatic_macip_file  ļ
	memset(path_file, 0, sizeof(path_file));
	sprintf(path_file, "%s/static_macip_file", path_conf);
	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "/bin/rm -rf %s", path_file);
	zxic_system(cmd);

	memset(path_file, 0, sizeof(path_file));
	sprintf(path_file, "%s/children_device_file", path_conf);
	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "/bin/rm -rf %s", path_file);
	zxic_system(cmd);

	memset(path_file, 0, sizeof(path_file));
	sprintf(path_file, "%s/white_site_file", path_conf);
	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "/bin/rm -rf %s", path_file);
	zxic_system(cmd);

	/*reset DDNS status file*/
	memset(path_file, 0, sizeof(path_file));
	sprintf(path_file, "%s/inadyn.status", path_conf);
	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "/bin/rm -rf %s", path_file);
	zxic_system(cmd);

	//ָʱMAC-IP󶨹
	sc_cfg_get("path_sh", path_script, sizeof(path_script));
	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "%s/config-udhcpd.sh \"lan\" -S", path_script);
	soft_system(cmd);
}

/**************************************************************************
* ƣ tc_control
*  
* ˵ ҪصݿҪcidufiģʽҪ
*            0ʾҪأλ:bitlinux׼Ƕֽڴֵ8
*   ֵ ɹ1.
* ˵ ҪƵӦõãҪأٵã޷ȡڽ
*                 ػ¿֮ǰõȻЧ
**************************************************************************/
int tc_control(struct tc_control_info *tcinfo, int src_id)
{
	int ret = 0;

	printf("netapi:tc_control start! c_id:%d, down:%u, up:%u\n, src:%d \n", tcinfo->c_id, tcinfo->tc_downlink, tcinfo->tc_uplink, src_id);

	ret = ipc_send_message(src_id, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_TC_CTRL, sizeof(struct tc_control_info), (UCHAR *)tcinfo, 0);
	if (0 != ret) {
		softap_assert("send msg to zte_router error");
		return 0;
	}
	return 1;
}

#define SIOCDEVPRIVATE 0X89F0
#define SIOCVLAN		SIOCDEVPRIVATE+0x0	

/**************************************************************************
* ƣ set_ethwan_mode
*  switch豸eth0.200ڶӦport3Ϊwanڻlan
* ˵ mode:1 => wanڣ0 => lan
*   ֵ .
* ˵ 
**************************************************************************/
void set_ethwan_port_mode(int mode)
{
	struct ifreq ifr;
	int fd;
	char eth_name[IFNAMSIZ] = {'e','t','h','0'};
	
	if(mode != 0 && mode != 1)
	{
		return;
	}
	slog(NET_PRINT, SLOG_ERR, "set_ethwan_port_mode() mode=%d\n", mode);	
	if ((fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		slog(NET_PRINT, SLOG_ERR, "set_eth200_mode() socket(AF_INET,SOCK_STREAM) fail");
		return;
	}
	memset(&ifr, 0, sizeof(ifr));
	memcpy((void*)ifr.ifr_name, (void*)eth_name, strlen("eth0"));//gmaceth0Ƿͨnvȡ
	ifr.ifr_data = (void*)&mode;

	if (ioctl(fd, SIOCVLAN, &ifr) < 0 && errno != EINVAL) {
		slog(NET_PRINT, SLOG_ERR, "set_eth200_mode() ioctl fail");		
		close(fd);
		return;
	}

	close(fd);

}

/*
 * ether_to_eui64 - Convert 48-bit Ethernet address into 64-bit EUI
 *
 * convert the 48-bit MAC address of eth0 into EUI 64. caller also assumes
 * that the system has a properly configured Ethernet interface for this
 * function to return non-zero.
 */
int netapi_ether_to_eui64(const char *dev_name, netapi_eui64_t *p_eui64)
{
    struct ifreq ifr;
    int skfd;
    const unsigned char *ptr;

    skfd = socket(PF_INET6, SOCK_DGRAM, 0);
    if(skfd == -1)
    {
        slog(NET_PRINT, SLOG_ERR, "eui64 open IPv6 socket fail");
        return 0;
    }

    strcpy(ifr.ifr_name, dev_name);
    if(ioctl(skfd, SIOCGIFHWADDR, &ifr) < 0)
    {
        close(skfd);
        slog(NET_PRINT, SLOG_ERR, "eui64 obtain hardware address for %s fail", dev_name);
        return 0;
    }
    close(skfd);

    /*
     * And convert the EUI-48 into EUI-64, per RFC 2472 [sec 4.1]
     */
    ptr = ifr.ifr_hwaddr.sa_data;
    p_eui64->e8[0] = ptr[0] | 0x02;
    p_eui64->e8[1] = ptr[1];
    p_eui64->e8[2] = ptr[2];
    p_eui64->e8[3] = 0xFF;
    p_eui64->e8[4] = 0xFE;
    p_eui64->e8[5] = ptr[3];
    p_eui64->e8[6] = ptr[4];
    p_eui64->e8[7] = ptr[5];

    return 1;
}

