/*
 * 
 * Copyright (C)  2023
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details
 *
 * FileName : zlog_com.h
 * This program Capture module's trace log.
 */

#ifndef __ZLOG_COM_H__
#define __ZLOG_COM_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <syslog.h>
#include <signal.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

/**
 * ⲿ
 */
extern int set_tty(int fd,char *settings);

/**
 * 궨
 */
#define ZLOG_DEFAULT_TTYBAUD  "921600 raw"

#define PRINTF_DBG_INFO(fmt, args...) \
		do 							\
		{ 							\
			printf("INFO:%s(%d)-%s:\n"fmt":\n", __FILE__,__LINE__,__FUNCTION__); \
		} while (0)

#define PRINTF_DBG_ERROR(fmt, args...) \
		do 							\
		{ 							\
			printf("ERROR:%s(line %d)--%s: "fmt": %s\n", __FILE__,__LINE__,__FUNCTION__,##args, strerror(errno)); \
		} while (0)

#define dbg_time(fmt, args...)  \
		do {   \
			fprintf(stdout, "[%s-%d] " fmt, __func__, __LINE__, ##args); \
			fflush(stdout); \
		} while (0)
		
typedef unsigned long UINT32;
typedef unsigned long ULONG32;

/**
 * ṹ嶨
 */
typedef struct 
{
	UINT32  curfd;
	UINT32  uFileNum;
	UINT32  uFileSize;
	UINT32  tmaxLogNum;
	ULONG32 tMaxLogsize;
	char    *localFsPath;
}T_COMM_FS_PARAM;

#endif


