/*******************************************************************************
* Copyright (C) 2014, ZTE Corporation.
*
* File Name:
* File Mark:
* Description:
* Others:
* Version:       V1.0
* Author:        shideyou
* Date:          2014-04-01
* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
********************************************************************************/
#ifndef __DRVS_GPIO_REF_H_
#define __DRVS_GPIO_REF_H_

/*************************************************************************
*								   Include files																		 *
*************************************************************************/
#include "drvs_gpio.h"
/*************************************************************************
*								   Macro																				  *
*************************************************************************/


/**************************************************************************
*								  Types 																				  *
**************************************************************************/
typedef struct _T_ZDrvGpio_Config{
	UINT32 number;	  //GPIO number
	const char *name;	   
}T_ZDrvGpio_Config;

typedef struct _T_Gpio_ConfigData{
	T_ZDrvGpio_Config *config_table;
	UINT32 ngpios;
}T_Gpio_ConfigData;

typedef struct _T_Gpio_Init{
	UINT32 number;			//gpio number
	UINT32 topFuncSel;			//top func
	UINT32 pdFuncSel;			//pd func
	UINT32 aonFuncSel;			//aon func
	UINT32 pullUpDownSel;       //up down sel
	T_ZDrvGpio_IoDirection  inout;
	T_ZDrvGpio_IoVal    highlow;	
}T_Gpio_Init;

typedef struct _T_Gpio_InitData{
	T_Gpio_Init *init_table;
	UINT32 ngpios;
}T_Gpio_InitData;


/**************************************************************************
*						   Global  Variable 																			*
**************************************************************************/


/**************************************************************************
* 						  Function Prototypes																			 *
**************************************************************************/


/**************************************************************************
* 						  Function Defines																			  *
**************************************************************************/

/**************************************************************************
* Functin: Gpio_GetConfig
* Description: This function is used to get the table of gpio config.
* Parameters:
* 	  Input:
*		NONE
* 			
* 	  Output:
*		pointer of config table
* 			 
* Returns:
* 	 	NONE
*
* Others:
* 	  None.
**************************************************************************/
VOID Gpio_GetConfigTable(T_Gpio_ConfigData *gpio_conf, T_Gpio_InitData *gpio_init);


#endif
