/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  This source file contains the T=0 protocol instruction (INS) statemachine engine.
 * Others:        
 * Version:       v0.1
 * Author:        mtr
 * Date:          2007-03-29
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/


/****************************************************************************
*                                              Include files
****************************************************************************/
#include "uicc_stub.h"
    
    
#include "uicc.h"
#include "uicc_ctrl.h"
#include "uicc_access.h"
#include "uicc_drv.h"
#include "uicc_trc.h"
#include "USIM_reg.h"
    
#include "oss_api.h"
#include "drvs_ramlog.h"
#include "drvs_assert.h"
#include "drvs_ref_cfg.h"
/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
#define NULL_ACK_BYTE   0x60
    
    
#define T_CLK_PU  1000  /* [us] The time waiting before initiating an instruction after
                              enabling the clock. */
    
#define T_CLK_PD 1000  /* [us] The time waiting before disabling the clock after having
                              executed an initiating. */
    
#define T_CLK_DIST  1000 /* [us] The time to ensure a distance between two successive 
                              commands. */
                              
    
#define INS_DATA_GUARD 6000000 /* [us] The guard timer value is used to ensure that UICC is not
                                      waiting forever in case of a broken communication link. */
    
#define T_CLK_FAIL 10000 /* [us] A guard time in case the instruction fail. */ 
#define T_AWAIT_DMA_END  1000 /* [us] The time waiting for DMA_END, if timeout then not received any data . */ 
    
#define CMD_HEADER_SIZE 5 /* The number of command header bytes. */
#define NOF_VOLTAGE_RECOGNITION_CMDS 2
    
#define T_FIFO_REQ_GUARD    0x7270E00/*6000000*//*200000*/  /* [us] The time waiting before FIFO TX Request*/

#define NAME_LENGTH 40
/****************************************************************************
* 	                                           Local Types
****************************************************************************/
typedef struct _T_UiccDebugInfo
{
	CHAR debugInfo[NAME_LENGTH + 1];
}
T_UiccDebugInfo;

extern T_Drv_Hisr s_simHalHisr;

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/
ushort err_type_chtimeout = 0;

/****************************************************************************
* 	                                           Local Variables
****************************************************************************/
T_UiccDebugInfo UiccStatusInfo[] =
{
    "UICC_T0_CMD_NONE",
    "UICC_T0_CMD_READY_CLK_OFF",
    "UICC_T0_CMD_READY",
    "UICC_RX_HEADER",
    "UICC_CMD_DATA",

    "UICC_CMD_SUCCEEDED",
    "UICC_CMD_FAILED",
    "UICC_AWAIT_CLK_POWER_DOWN",
    "UICC_TX_CMD_DATA",
    "UICC_RX_CMD_DATA",
    "UICC_CMD_AWAIT_DMA_END",
    "UICC_CMD_SUCCEEDED_WITH_NO_DATA",
    "UICC_TX_AWAIT_FIFO_REQUEST",
    "UICC_TX_PACK_TRANS",
    "UICC_RX_AWAIT_FIFO_REQ",
    "UICC_RX_PACK_TRANS"  
};

T_UiccDebugInfo UiccEventInfo[] =
{
  /* 0x00  (0) */  "UICC_DUMMY_INT_EVENT",
  /* 0x01  (1) */  "UICC_TIMER_EXPIRED",          
  /* 0x02  (2) */  "UICC_GUARD_TIMER_EXPIRED",
  /* 0x03  (3) */  "UICC_CHARACTER_OK",
  /* 0x04  (4) */  "UICC_T0_END",
  /* 0x05  (5) */  "UICC_T1_END",
  /* 0x06  (6) */  "UICC_DMA_END",
  /* 0x07  (7) */  "UICC_PARITY_ERROR",
  /* 0x08  (8) */  "UICC_OVERRUN_ERROR",
  /* 0x09  (9) */  "UICC_CARD_IN",
  /* 0x0A (10) */  "UICC_CARD_OUT",
  /* 0x0B (11) */  "UICC_CHTIMEOUT",
  /* 0x0C (12) */  "UICC_T1_PARITY_ERROR",
  /* 0x0D (13) */  "UICC_T1_BWT_EXPIRED",
  /* 0x0E (14) */  "UICC_UNKNOWN_INT",
  /* 0x0F (15) */  "UICC_FIFO_INT",
  /* 0x10 (16) */  "UICC_RX_LSREQ",  
  /* 0x11 (17) */  "UICC_TX_LSREQ",  
  /* 0x12 (18) */  "UICC_RX_SREQ",  
  /* 0x13 (19) */  "UICC_TX_SREQ",    
  /* 0x14 (20) */  "UICC_RX_LBREQ",  
  /* 0x15 (21) */  "UICC_TX_LBREQ",  
  /* 0x16 (22) */  "UICC_RX_BREQ",  
  /* 0x17 (23) */  "UICC_TX_BREQ",  
  /* 0x18 (24) */  "UICC_TXF_OFL_IRQ",  
  /* 0x19 (25) */  "UICC_RXF_UFL_IRQ",
  /* 0x1A (26) */  "UICC_FIFO_UNKNOWN_INT",
    			 "UICC_INITIATE_CMD",
  				 "UICC_STOP_CMD_CLOCK",
  				 "UICC_RESET_CMD",
  				 "UICC_LAST_CMD_EVENT"
};


#ifdef UICC_FIFO_ONLY
  static ushort transfer_cnt = 0;
#endif

#ifndef UICC_HW_CONTROLLED_T0
  static ubyte  head_cnt;
  static ushort data_cnt;
  static ushort tx_spc;
#endif

static ulong cmd_wwt;  
static ubyte sim_work_around;/*add 071219*/
  
#ifndef UICC_NO_DEBUG
  static T_UICC_T0_CMD_CTRL_STATE debug = UICC_T0_CMD_NONE;
#endif

static ubyte *cmd_data_ptr;
static ubyte *cmd_header_ptr;

static char s_localStringBuf_uicc[512]=
    {
        0
    };

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
T_UICC_T0_CMD_CTRL_STATE UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
    
#ifndef UICC_NO_DEBUG
  T_UICC_TRACE UICC_trace;
#endif

extern volatile UINT8 uiccPlugFlag;

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
/*******************************************************************************
 * Function: uiccDebug_Printf
 * Description:
 * Parameters:
 * Input:None
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
VOID uiccDebug_Printf(char *fmt,...)
{
    va_list ap;
    zDrv_ASSERT(fmt!=NULL);
    va_start(ap,fmt);
    vsprintf(s_localStringBuf_uicc,fmt,ap);
    zDrvRamlog_PRINTF(RAMLOG_MOD_UICC,"%s", s_localStringBuf_uicc);
    va_end(ap);
}
/*******************************************************************************
* Function:... prepare_instruction
* Parameters:. None.
* Returns:.... the next instruction control state.
* Description: This function is setting up the T=0 controller
* Created:.... 05.06.00 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
static void prepare_instruction(void)
{
  #ifndef UICC_NO_DEBUG
    /* Start debug logging of the current instruction. */
    ushort cnt;

    UICC_trace.nof_ins_cnt++;

    if(UICC_trace.log_buf_cnt < (UICC_TRACE_NOF_BUFFERS-1))
      cnt = ++UICC_trace.log_buf_cnt;
    else
      cnt = UICC_trace.log_buf_cnt = 0;

    memcpy(&UICC_trace.log_buf[cnt][0], &UICC_tpdu_data[UICC_CLA_POS], 7);

    if(UICC_t0_tpdu_ctrl.cmd_direction == UICC_RX_CMD)
    {
      UICC_trace.log_buf[cnt][5] = 0xCC;
      UICC_trace.log_buf[cnt][6] = 0xDD;
    }

    UICC_trace.log_buf[cnt][7] = 0xEE;
    UICC_trace.log_buf[cnt][8] = 0xFF;
  #endif

  /* Now carry out the actial instruction handling! */
  UICC_tpdu_footer.sw1 = 0xAC;
  UICC_tpdu_footer.sw2 = 0xDC;
  
  cmd_header_ptr = &UICC_tpdu_data[UICC_CLA_POS];    
  #if defined (UICC_FIFO_MODE)
    cmd_data_ptr   = UICC_tpdu_data_ptr+3; //plus 3 for word alignment
  #else
     cmd_data_ptr   = UICC_tpdu_data_ptr;
  #endif

  #ifdef UICC_IT3_27_12_1_PATCH
    /* Mark that the instruction about to be executed is the RUN GSM ALGORITHM ('88'). */
    if(UICC_tpdu_data[UICC_INS_POS] == 0x88)
    {
      UICC_authentication_cmd_executing = TRUE;
    }
    else
    {  
      UICC_authentication_cmd_executing = FALSE;  
    }
  #endif

  
#ifdef UICC_HW_CONTROLLED_T0

  #ifdef UICC_ADD_TO_WWT_SAFETY_MARGIN
    /* WWT = 960 * WI * D -> because the timer value programmed into the USIM HW timer has the ETU value
       as base unit. The addition of 240 is to ensure a sufficient safety margin. */
    cmd_wwt = (960 + 240) * UICC_card_profile[UICC_current_reader].wi * 
                                UICC_baud_rate_table[UICC_card_profile[UICC_current_reader].d_used];
  #else
    /* WWT = 960 * WI * D -> because the timer value programmed into the USIM HW timer has the ETU value
       as base unit. 2 ETU safety margin is used to ensure the current FTA requirements (which is: terminate 
       after WWT + 5ETU). */
    cmd_wwt =   2 * UICC_baud_rate_table[UICC_card_profile[UICC_current_reader].d_used] + 
              960 * UICC_card_profile[UICC_current_reader].wi * 
                    UICC_baud_rate_table[UICC_card_profile[UICC_current_reader].d_used];
    cmd_wwt +=  480 * UICC_card_profile[UICC_current_reader].wi * 
                    UICC_baud_rate_table[UICC_card_profile[UICC_current_reader].d_used];
	#if 0
/*add 071219*/
    switch(UICC_tpdu_data[UICC_INS_POS])
    { /* Extend the WWT timer for STK related commands to accommodate unscrupulous SIM cards 
         violating the specified WWT window */ 
      case 0x10: /* TERMINAl PROFILE  */
      case 0x12: /* FETCH             */
      case 0x14: /* TERMINAL RESPONSE */
      case 0xC2: /* ENVELOPE          */        
	  case 0xa4: /* add by wujinlei 2011.9.30          */
        cmd_wwt +=  240 * UICC_card_profile[UICC_current_reader].wi * 
                          UICC_baud_rate_table[UICC_card_profile[UICC_current_reader].d_used];
        break;
    }
	#endif
  #endif
/*end add*/
  cmd_wwt += UICC_profile_parameter.wwt_extension;
	cmd_wwt = cmd_wwt *3;

#else /*UICC_HW_CONTROLLED_T0 -> SW Controlled instruction. */

  #if defined (SGOLD2) || defined (SGOLD3) || defined (SGOLDRADIO)
    tx_spc = (ushort)UICC_etu2usec(0x02);  /* Tx Spacing. */
  #else
    if((UICC_baseband_profile.version == SYS_BB_VER_SGOLD) && 
       (UICC_baseband_profile.revision < SYS_BB_REV_12))
    {  /* ONLY for S-GOLD < ES2.5 */
      tx_spc = (ushort)UICC_etu2usec(0x03);  /* Spacing between TX characters. Must be larger than 2 
                                                to avoid 'ghost' characters in after parity error 
                                                retransmission. */
    }
    else
    { /* UTP: WS00002548 corrected. Tx space does not need to hold the TX space value of minimum 3. */
      tx_spc = (ushort)UICC_etu2usec(0x02);  /* Tx Spacing. */
    }
  #endif
 
  head_cnt = CMD_HEADER_SIZE - 1; 

  if(UICC_t0_tpdu_ctrl.data_size)
  {
    data_cnt = UICC_t0_tpdu_ctrl.data_size;
  }
  else
  {
    data_cnt = 0;
  }
  
  cmd_wwt = UICC_T_WWT;
#endif
}

/*******************************************************************************
* Function:... instruction_failed
* Parameters:. None.
* Returns:.... the next instruction control state.
* Description: This function is informing the controlling driver statemachine
*              that the instruction execution has failed. Note that this
*              function must only be called from the timeout interrupt.
* Created:.... 05.06.00 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
#ifndef UICC_HW_CONTROLLED_T0
  static void instruction_failed(void)
  {
    UICC_stop_clock_conditional(UICC_card_profile[UICC_current_reader].used_clock_stop_mode, UICC_current_reader);
    UICC_switch_uart_clock_off();
    UICC_t0_transport_handler(UICC_T0_CMD_FAILED);
  }
#endif

#ifdef UICC_HW_CONTROLLED_T0
/*******************************************************************************
* Function:... UICC_t0_cmd_handler
* Parameters:. event: The event triggering the statemachine.
* Returns:.... -
* Description: This statemachine/engine is controlling the execution of the T=0
*              protocol instructions.
* Created:.... 25.05.00 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_reset_t0_cmd_handler(void)
{
  UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;

  #ifndef UICC_NO_DEBUG  
    UICC_trace.log_buf_cnt = 0;
  #endif
}

#ifdef UICC_FIFO_ONLY
ushort status = 0;
static ushort err_type;
static ushort err_type_cnt = 0;
void UICC_t0_cmd_handler(T_UICC_T0_CMD_EVENTS event)
{
ubyte ch;
ushort i;

uiccDebug_Printf("[%d]state=%s,event=%s,sw1=0x%x,sw2=0x%x!\n", zOss_GetTickCount(),(char *)(&UiccStatusInfo[UICC_t0_cmd_ctrl_state]),(char *)(&UiccEventInfo[event]),SIM_SW1,SIM_SW2);
uiccramlog_Printf("[%d]state=%s,event=%s,sw1=0x%x,sw2=0x%x!\n", zOss_GetTickCount(),(char *)(&UiccStatusInfo[UICC_t0_cmd_ctrl_state]),(char *)(&UiccEventInfo[event]),SIM_SW1,SIM_SW2);
  switch(UICC_t0_cmd_ctrl_state)
  {
    /*==========================================*/
    /* Inactive - ready to execute instructions */
    /*==========================================*/
    case UICC_T0_CMD_READY_CLK_OFF:
      switch(event)
      {
        /*----------------------------*/
        case UICC_INITIATE_CMD:
        /*----------------------------*/
          UICC_init_fifo();
          /* An instruction request has been received. Prepar the instruction
             execution while waiting for that card to become alive again after
             the clock has been activated/re-activated. */
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY;
          UICC_enable_card_interface(); /* Includes UART ON */
          UICC_set_rxtx_space(120);     /* Spacing between last Rx character and the first Tx 
                                           character 120/16 ~ 7,5 ETU counted 9.5 ETU after 
                                           leading character edge (app. 17 ETU in total). */


          UICC_set_txtx_space(0x02);      /* Tx Spacing. */

          UICC_select_T0_instruction_mode();
          UICC_disable_parity_error_interrupt();
          UICC_disable_usim_ok_isr();
          UICC_disable_character_interrupt();  
          UICC_enable_overrun_error_interrupt();
          UICC_enable_t0_end_interrupt();
          UICC_select_high_clock_freq();
          UICC_activate_clk(UICC_current_reader);
          UICC_start_timer(T_CLK_PU);


#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif


          break;

        /*----------------------------*/
        case UICC_STOP_CMD_CLOCK:
        /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_AWAIT_CLK_POWER_DOWN;
          UICC_start_timer(T_CLK_PD);          


#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif

 
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /* Active - waiting for the card to wakeup. */
    /*==========================================*/
    case UICC_T0_CMD_READY:
      switch(event)
      {
        /*----------------------------*/
        case UICC_INITIATE_CMD:
        /*----------------------------*/
          UICC_enable_card_interface(); /* Includes UART ON */
          UICC_start_timer(T_CLK_DIST); /* Start timer to ensure distance between two
                                           successive commands. Stay in this state. */


#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif

								   
          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
        {
          prepare_instruction();
          UICC_set_character_timer(cmd_wwt);
          UICC_enable_char_timeout_interrupt();
          transfer_cnt = 0;
          sim_work_around = FALSE; /*add 080109 Init the variable*/
          
          if(UICC_t0_tpdu_ctrl.cmd_direction == UICC_TX_CMD)
          { /* Tx command */

            /*Set FIFO transmit packed size*/                      
            UICC_t0_cmd_ctrl_state = UICC_TX_AWAIT_FIFO_REQUEST;

          /*Set FIFO transmit packed size*/
          #ifdef UICC_MODULE_TEST

            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&UICC_hw_tx_store[0], &cmd_header_ptr[0], CMD_HEADER_SIZE + UICC_t0_tpdu_ctrl.data_size);
            else  
              SIM_TPS_CTRL = CMD_HEADER_SIZE + UICC_t0_tpdu_ctrl.data_size; 

          #else
            SIM_TPS_CTRL = CMD_HEADER_SIZE + UICC_t0_tpdu_ctrl.data_size; 
          #endif

          }
          else /* Rx command */
          {
            UICC_t0_cmd_ctrl_state = UICC_RX_AWAIT_FIFO_REQ;
            
            /*Set FIFO transmit packed size*/
            #ifdef UICC_MODULE_TEST

              if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
                memcpy(&UICC_hw_tx_store[0], &cmd_header_ptr[0], CMD_HEADER_SIZE);
              else  
                SIM_TPS_CTRL = CMD_HEADER_SIZE; 

            #else
              SIM_TPS_CTRL = CMD_HEADER_SIZE; 
            #endif
          }

	  UICC_start_timer(T_FIFO_REQ_GUARD); /*Timeout await */
        }
        break;

        /*----------------------------*/
        case UICC_STOP_CMD_CLOCK:
        /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_AWAIT_CLK_POWER_DOWN;
          UICC_start_timer(T_CLK_PD);          


#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif

	  
          break;

        /*----------------------------*/
        case UICC_OVERRUN_ERROR:        
        /*----------------------------*/
          zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_disable_char_timeout_interrupt();
          UICC_switch_uart_clock_off();
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_start_timer(T_CLK_FAIL);
          zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);
	   uiccramlog_Printf("(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /*Wait for FIFO TX request                                                           */
    /*==========================================*/
    case UICC_TX_AWAIT_FIFO_REQUEST:
      /*Start T1 when receivei TX_BREQ(16bytes),TX_LBREQ(13-16 bytes) or combination: TX_SREQ(+TX_SREQ)+LSREQ = 4+(+4)+1-4=9-12 bytes */			
      switch(event)
      {
        /*----------------------------*/
        case UICC_TX_SREQ:
        /*----------------------------*/
         /*TX single request 4 bytes */
          #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[0],&cmd_header_ptr[transfer_cnt], 4);
            else
              SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #else
            SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #endif

          transfer_cnt += 4;
          UICC_start_timer(T_FIFO_REQ_GUARD); /*Timeout await FIFO request*/    
          break;

        /*----------------------------*/
        case UICC_TX_BREQ:
        /*----------------------------*/
          /*Burst request 16 bytes = 4 * 4 bytes*/
          UICC_t0_cmd_ctrl_state = UICC_TX_PACK_TRANS;
        
          #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[0],&cmd_header_ptr[transfer_cnt], 4);
            else
              SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #else
            SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #endif

          transfer_cnt += 4;
                  
          /* Initiate the actual command. */
          UICC_commence_t0_command(UICC_tpdu_data[UICC_P3_POS], 
                                     UICC_tpdu_data[UICC_INS_POS], 
                                     UICC_TX_CMD);

          /*The remain 12 bytes (16-4)*/ 
          for (i=1;i<=3;i++)
          {
             #ifdef UICC_MODULE_TEST
               if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
                 memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[i*4],&cmd_header_ptr[transfer_cnt], 4);
               else
                 SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
             #else
               SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
             #endif

            transfer_cnt += 4;
          }

          UICC_start_timer(T_FIFO_REQ_GUARD); /*Timeout await FIFO request*/    
          
          break;

        /*----------------------------*/
        case UICC_TX_LSREQ:
        /*----------------------------*/
          /*TX Last single request 1-4 bytes */
          UICC_t0_cmd_ctrl_state = UICC_TX_CMD_DATA;
          UICC_stop_timer();

          #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[0],&cmd_header_ptr[transfer_cnt], 4);
            else
              SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #else
            SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #endif

          /* Initiate the actual command. */
          UICC_commence_t0_command(UICC_tpdu_data[UICC_P3_POS], 
                                     UICC_tpdu_data[UICC_INS_POS], 
                                     UICC_TX_CMD);
		  UICC_start_timer(T_FIFO_REQ_GUARD);//xjy add
          break;

        /*----------------------------*/
        case UICC_TX_LBREQ:
        /*----------------------------*/
          /*Burst request 13-16 bytes = 4 * 4 bytes*/
          UICC_t0_cmd_ctrl_state = UICC_TX_CMD_DATA;
          UICC_stop_timer();
        
          #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[0],&cmd_header_ptr[transfer_cnt], 4);
            else
              SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #else
            SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #endif

          transfer_cnt += 4;
                  
          /* Initiate the actual command. */
          UICC_commence_t0_command(UICC_tpdu_data[UICC_P3_POS], 
                                     UICC_tpdu_data[UICC_INS_POS], 
                                     UICC_TX_CMD);

          /*The remain 12 bytes (16-4)*/ 
          for (i=1;i<=3;i++)
          {
           #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[i*4],&cmd_header_ptr[transfer_cnt], 4);
            else
              SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #else
            SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #endif

            transfer_cnt += 4;
          }
           UICC_start_timer(T_FIFO_REQ_GUARD);//xjy add
          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        case UICC_OVERRUN_ERROR:        
        /*----------------------------*/
	    zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_disable_char_timeout_interrupt();
          UICC_switch_uart_clock_off();
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_start_timer(T_CLK_FAIL); 
          zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);
	   uiccramlog_Printf("(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /* TX the next packes to the FIFO. */
    /*==========================================*/
    case UICC_TX_PACK_TRANS:
      switch(event)
      {
        /*----------------------------*/
        case UICC_TX_SREQ:
        /*----------------------------*/
        /*TX single request 4 bytes */
          #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[0],&cmd_header_ptr[transfer_cnt], 4);
            else
              SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #else
            SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #endif

          transfer_cnt += 4;
          UICC_start_timer(T_FIFO_REQ_GUARD); /*Timeout await FIFO request*/    

          break;

        /*----------------------------*/
        case UICC_TX_BREQ:
        /*----------------------------*/
          /*Burst request 16 bytes = 4 * 4 bytes*/
          #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[0],&cmd_header_ptr[transfer_cnt], 4);
            else
              SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #else
            SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #endif

          transfer_cnt += 4;
                  
          /*The remain 12 bytes (16-4)*/ 
          for (i=1;i<=3;i++)
          {
            #ifdef UICC_MODULE_TEST
              if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
                memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[i*4],&cmd_header_ptr[transfer_cnt], 4);
              else
                SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
            #else
              SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
            #endif

            transfer_cnt += 4;
          }

          UICC_start_timer(T_FIFO_REQ_GUARD); /*Timeout await FIFO request*/              
          break;

        /*----------------------------*/
        case UICC_TX_LSREQ:
        /*----------------------------*/
          /*TX Last single request 1-4 bytes */
          UICC_t0_cmd_ctrl_state = UICC_TX_CMD_DATA;
          UICC_stop_timer();

          #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[0],&cmd_header_ptr[transfer_cnt], 4);
            else
              SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #else
            SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #endif
		  UICC_start_timer(T_FIFO_REQ_GUARD);//xjy add
          break;

        /*----------------------------*/
        case UICC_TX_LBREQ:
        /*----------------------------*/
          /*Burst request 13-16 bytes = 4 * 4 bytes*/
          UICC_t0_cmd_ctrl_state = UICC_TX_CMD_DATA;
          UICC_stop_timer();
        
          #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[0],&cmd_header_ptr[transfer_cnt], 4);
            else
              SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #else
            SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #endif

          transfer_cnt += 4;
                  
          /*The remain 12 bytes (16-4)*/ 
          for (i=1;i<=3;i++)
          {
          #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[i*4],&cmd_header_ptr[transfer_cnt], 4);
            else
              SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #else
            SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #endif

            transfer_cnt += 4;
          }
          UICC_start_timer(T_FIFO_REQ_GUARD);//xjy add
          break;

        /*----------------------------*/
        case UICC_T0_END:
        /*----------------------------*/
          /* Instruction ended successfully - In this state the SW1 & SW2 received without ACK byte */       

          //Clear FIFO
          SIM_RUN_CTRL = 0; //RUN = 0
          SIM_FIFO_ICR = 0x3FF; //Clear FIFO interrupt register
          SIM_RUN_CTRL = 1; //RUN = 1                

          UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED;
          UICC_force_timeout();			
          break;		  

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        case UICC_OVERRUN_ERROR:        
        /*----------------------------*/
	    zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_disable_char_timeout_interrupt();
          UICC_switch_uart_clock_off();
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_start_timer(T_CLK_FAIL);
          zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);
	   uiccramlog_Printf("(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*=============================================================*/
    /* Waiting for FIFO TX request - Transmit RX header                                                                                                */
    /*=============================================================*/
    case UICC_RX_AWAIT_FIFO_REQ:
      /*Wait for TX_SREQ + TX_LSREQ = 5 bytes*/	
      switch(event)
      {
        /*----------------------------*/
        case UICC_TX_SREQ:
        /*----------------------------*/
         /*TX single request 4 bytes */
          UICC_start_timer(T_FIFO_REQ_GUARD); /*Timeout await FIFO request*/    

          #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[0],&cmd_header_ptr[transfer_cnt], 4);
            else
              SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #else
            SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #endif

          transfer_cnt += 4;

		  UICC_start_timer(T_FIFO_REQ_GUARD); /*Timeout await FIFO request*/  
          break;

        /*----------------------------*/
        case UICC_TX_LSREQ:
        /*----------------------------*/
         /*TX single request 4 bytes */
          UICC_t0_cmd_ctrl_state = UICC_RX_PACK_TRANS;
          UICC_stop_timer();

          #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&UICC_simulated_hw_reg._SIM_FIFO_TXD[0],&cmd_header_ptr[transfer_cnt], 4);
            else
              SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #else
            SIM_FIFO_TXD = (ulong) *((ulong *)(&cmd_header_ptr[transfer_cnt]));  
          #endif

          transfer_cnt = 0;

         /* Initiate the actual command. */
         UICC_commence_t0_command(UICC_tpdu_data[UICC_P3_POS], 
                                     UICC_tpdu_data[UICC_INS_POS], 
                                     UICC_RX_CMD);  					

		 UICC_start_timer(T_FIFO_REQ_GUARD); /*Timeout await FIFO request*/  
          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:		
        case UICC_OVERRUN_ERROR:        
        /*----------------------------*/
          zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_disable_char_timeout_interrupt();
          UICC_switch_uart_clock_off();
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_start_timer(T_CLK_FAIL);          
          zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*===========================================================*/
    /* Receive the data from the card as a FIFO pack */
    /*===========================================================*/
    case UICC_RX_PACK_TRANS:
      switch(event)
      {
        /*----------------------------*/
        case UICC_RX_LSREQ:
        /*----------------------------*/
          /*Last single request 1-4 bytes*/
		  UICC_stop_timer();

          UICC_t0_cmd_ctrl_state = UICC_RX_CMD_DATA;

          #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&cmd_data_ptr[transfer_cnt], &UICC_simulated_hw_reg._SIM_FIFO_RXD[0], 4);
            else
              memcpy(&cmd_data_ptr[transfer_cnt], &SIM_FIFO_RXD, 4);
          #else
            memcpy(&cmd_data_ptr[transfer_cnt], (const void *)(&SIM_FIFO_RXD), 4);
          #endif

		  UICC_start_timer(T_FIFO_REQ_GUARD); /*Timeout await FIFO request*/  
          break;

        /*----------------------------*/
        case UICC_RX_SREQ:
        /*----------------------------*/
			UICC_stop_timer();
          #ifdef UICC_MODULE_TEST
            if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
              memcpy(&cmd_data_ptr[transfer_cnt], &UICC_simulated_hw_reg._SIM_FIFO_RXD[0], 4);
            else
              memcpy(&cmd_data_ptr[transfer_cnt], &SIM_FIFO_RXD, 4);
          #else
            memcpy(&cmd_data_ptr[transfer_cnt], (const void *)(&SIM_FIFO_RXD), 4);
          #endif

          transfer_cnt += 4;
		  UICC_start_timer(T_FIFO_REQ_GUARD);//xjy add
          break;

        /*----------------------------*/
        case UICC_RX_LBREQ:
        /*----------------------------*/
          /*Last burst request 13-16 bytes = 4 * 4 bytes*/
		  UICC_stop_timer();
          UICC_t0_cmd_ctrl_state = UICC_RX_CMD_DATA;
        
          for (i=1;i<=4;i++)
          {
            #ifdef UICC_MODULE_TEST
              if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
                memcpy(&cmd_data_ptr[transfer_cnt], &UICC_simulated_hw_reg._SIM_FIFO_RXD[(i-1)*4], 4);
              else
                memcpy(&cmd_data_ptr[transfer_cnt], &SIM_FIFO_RXD, 4);
            #else
              memcpy(&cmd_data_ptr[transfer_cnt], (const void *)(&SIM_FIFO_RXD), 4);
            #endif

            transfer_cnt += 4;
          }
          
          UICC_start_timer(T_FIFO_REQ_GUARD); /*Timeout await FIFO request*/  
          break;

        /*----------------------------*/
        case UICC_RX_BREQ:
        /*----------------------------*/
          /*Burst request 16 bytes = 4 * 4 bytes*/
		  UICC_stop_timer();
          for (i=1;i<=4;i++)
          {
            #ifdef UICC_MODULE_TEST
              if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
                memcpy(&cmd_data_ptr[transfer_cnt], &UICC_simulated_hw_reg._SIM_FIFO_RXD[(i-1)*4], 4);
              else
                memcpy(&cmd_data_ptr[transfer_cnt], &SIM_FIFO_RXD, 4);
            #else
              memcpy(&cmd_data_ptr[transfer_cnt], (const void *)(&SIM_FIFO_RXD), 4);
            #endif

            transfer_cnt += 4;
          }
		  UICC_start_timer(T_FIFO_REQ_GUARD);//xjy add
          break;


        /* Instruction ended successfully - SW1 & SW2 received. */
          /*----------------------------*/
          case UICC_T0_END:
          /*----------------------------*/
            UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED_WITH_NO_DATA;
            UICC_force_timeout();  
            break;

        /*----------------------------*/
        case UICC_CHTIMEOUT:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_BRF =  %x,  SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_BRF,SIM_FFS_STAT,SIM_TX,SIM_RX);

          /* The command header has for some reason not been sent and the
             command fails. */
            status = SIM_STATUS;
            if (status & 0x0008)
            {
                UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED_WITH_NO_DATA;
                UICC_force_timeout();
            }
            else
            {
                UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
		if(UICC_apdu.header.cla == 0x80 && UICC_apdu.header.ins == 0xf2 && UICC_apdu.header.p1 == 0 && uiccPlugFlag == UICC_SIM_PLUGIN)
		{
			err_type = UICC_CHTIMEOUT;
			//err_type_cnt++;
		}
                UICC_force_timeout();
            }
          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:/*add by wangxia 2010.0915*/		
	    zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
            status = SIM_STATUS;

            if (status & 0x0008)
            {
                UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED_WITH_NO_DATA;
                UICC_force_timeout();
            }
            else
            {
                UICC_disable_char_timeout_interrupt();
                UICC_switch_uart_clock_off();
                UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
                UICC_start_timer(T_CLK_FAIL);
            }
		
	    zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

		  break;
        case UICC_OVERRUN_ERROR:        
        /*----------------------------*/
	    zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
            status = SIM_STATUS;

            if (status & 0x0008)
            {
                UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED_WITH_NO_DATA;
                UICC_force_timeout();
            }
            else
            {
                UICC_disable_char_timeout_interrupt();
                UICC_switch_uart_clock_off();
                UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
				if(UICC_apdu.header.cla == 0x80 && UICC_apdu.header.ins == 0xf2 && UICC_apdu.header.p1 == 0)
				{
					err_type = UICC_OVERRUN_ERROR;
					err_type_cnt++;
				}
                UICC_start_timer(T_CLK_FAIL);
            }
		
	    zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    case UICC_TX_CMD_DATA:
      switch(event)
      {
          /*----------------------------*/
          case UICC_T0_END:
          /*----------------------------*/
          /* Instruction ended successfully - SW1 & SW2 received. */       
            ch= SIM_SW1;
            if((ch != 0x60) && ((ch & 0xF0) == 0x60)) // If SW1 = 6X (except 60)
            {
                //Clear FIFO
              SIM_RUN_CTRL = 0; //RUN = 0
              SIM_FIFO_ICR = 0x3FF; //Clear FIFO interrupt register
              SIM_RUN_CTRL = 1; //RUN = 1                
           }
            UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED;
            UICC_force_timeout();			
            break;

        /*----------------------------*/
        case UICC_CHTIMEOUT:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_BRF =  %x,  SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_BRF,SIM_FFS_STAT,SIM_TX,SIM_RX);

          /* All data has not been handled correct and the command fails. */
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_force_timeout();
          break;
        /*----------------------------*/
        case UICC_TIMER_EXPIRED: /*add by wangxia for check T0_END interrupt 2010.09.15*/
        /*----------------------------*/
		   status = SIM_STATUS;
		  if(status & 0x0008)
           {
             ch= SIM_SW1;
             if((ch != 0x60) && ((ch & 0xF0) == 0x60)) // If SW1 = 6X (except 60)
             {
                //Clear FIFO
              SIM_RUN_CTRL = 0; //RUN = 0
              SIM_FIFO_ICR = 0x3FF; //Clear FIFO interrupt register
              SIM_ICR = 0x7;//Clear in/ok/err interrupt register
              SIM_RUN_CTRL = 1; //RUN = 1                
            }
            UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED;
            UICC_force_timeout();	 
           }
		  else
		   {
			  UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
			  UICC_force_timeout();
		   }
		  break;
        /*----------------------------*/
        case UICC_OVERRUN_ERROR:        
        /*----------------------------*/
        zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

       /* add 080109 Work around Bad SIM card caused overrun error*/
          UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED;
          
           //Clear FIFO
          sim_work_around = TRUE; 
          SIM_RUN_CTRL = 0;       //RUN = 0
          SIM_FIFO_ICR = 0x3FF; //Clear FIFO interrupt register
          SIM_RUN_CTRL = 1;      //RUN = 1    
    
          UICC_disable_char_timeout_interrupt();
          UICC_switch_uart_clock_off();
          UICC_force_timeout();	
          zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

        /*End add*/
          break;

       /*----------------------------*/
        default:
       /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    case UICC_RX_CMD_DATA:
      switch(event)
      {
        /* Instruction ended successfully - SW1 & SW2 received. */
          /*----------------------------*/
          case UICC_T0_END:
          /*----------------------------*/
            UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED;
            UICC_force_timeout();  
            break;

        /*----------------------------*/
        case UICC_CHTIMEOUT:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_BRF =  %x,  SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_BRF,SIM_FFS_STAT,SIM_TX,SIM_RX);
            status = SIM_STATUS;
            if (status & 0x0008)
            {
                UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED;
                UICC_force_timeout();
            }
            else
            {

                /* All data has not been handled correct and the command fails. */
                UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
                UICC_force_timeout();
            }
          break;
        /*----------------------------*/
        case UICC_TIMER_EXPIRED: /*add by wangxia for check T0_END interrupt 2010.9.15*/
        /*----------------------------*/
		   status = SIM_STATUS;
		  if(status & 0x0008)
           {
            UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED;
            UICC_force_timeout();  	 
           }
		  else
		   {
			  UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
			  UICC_force_timeout();
		   }
		  break;
        /*----------------------------*/
        case UICC_OVERRUN_ERROR:        
          zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_disable_char_timeout_interrupt();
          UICC_switch_uart_clock_off();
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_start_timer(T_CLK_FAIL);
          zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

          break;

       /*----------------------------*/
        default:
       /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*===============================================================*/
    /* Command sucessfully executed - wait before powering CLK down. */
    /*===============================================================*/
    case UICC_CMD_SUCCEEDED:
      switch(event)
      {
      /*----------------------------*/
        case UICC_TIMER_EXPIRED:
      /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY;
          UICC_disable_char_timeout_interrupt();
          
          /* SW1 & SW2 is retreived. */
          UICC_tpdu_footer = UICC_get_t0_command_response();
          /*add 090109*/
          /*Work around Bad SIM card caused overrun error*/
          if(sim_work_around == TRUE)
          {
            UICC_tpdu_footer.sw1 = 0x90;
            UICC_tpdu_footer.sw2 = 0x00;
          }
           /*End Add*/
          #ifndef UICC_NO_DEBUG
            UICC_trace.log_buf[UICC_trace.log_buf_cnt][7] = UICC_tpdu_footer.sw1;
            UICC_trace.log_buf[UICC_trace.log_buf_cnt][8] = UICC_tpdu_footer.sw2;
          #endif

          UICC_t0_transport_handler(UICC_T0_CMD_SUCCEEDED);
          break;

       /*----------------------------*/
        default:
       /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;
  
    case UICC_CMD_SUCCEEDED_WITH_NO_DATA:
      switch(event)
      {
      /*----------------------------*/
        case UICC_TIMER_EXPIRED:
      /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY;
          UICC_disable_char_timeout_interrupt();
          
          /* SW1 & SW2 is retreived. */
          UICC_tpdu_footer = UICC_get_t0_command_response();

          #ifndef UICC_NO_DEBUG
            UICC_trace.log_buf[UICC_trace.log_buf_cnt][7] = UICC_tpdu_footer.sw1;
            UICC_trace.log_buf[UICC_trace.log_buf_cnt][8] = UICC_tpdu_footer.sw2;
          #endif

          /* Inform main statemachine of the execution result */
          /* In this state the SW1 and SW2 was received without the requested data pool. */ 
          UICC_t0_transport_handler(UICC_T0_CMD_SUCCEEDED_NO_DATA);

          break;

       /*----------------------------*/
        default:
       /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;
  
    /*===============================================================*/
    /* Command execution failed.                                     */
    /*===============================================================*/
    case UICC_CMD_FAILED:
      switch(event)
      {
      /*----------------------------*/
        case UICC_TIMER_EXPIRED:
      /*----------------------------*/
		UICC_disable_char_timeout_interrupt();
		UICC_switch_uart_clock_off();
		UICC_disable_card_interface(); /* To reset the HW for a potential new command. */
		UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
		
		if((UICC_apdu.header.cla == 0x80 && UICC_apdu.header.ins == 0xf2 && UICC_apdu.header.p1 == 0)&&\
		((err_type == UICC_OVERRUN_ERROR)&& (err_type_cnt != 2)))
		{
			UICC_t0_transport_handler(UICC_T0_CMD_SUCCEEDED);
			uiccDebug_Printf("[%d]UICC_T0_CMD_SUCCEEDED,uiccPlugFlag = %d,err_type=%d,err_type_cnt=%d!\n", zOss_GetTickCount(), uiccPlugFlag,err_type,err_type_cnt);
		}
		else
		{
			UICC_t0_transport_handler(UICC_T0_CMD_FAILED);
			uiccDebug_Printf("[%d]UICC_T0_CMD_FAILED,uiccPlugFlag = %d,err_type=%d,err_type_cnt=%d!\n", zOss_GetTickCount(),uiccPlugFlag, err_type,err_type_cnt);
			err_type_cnt = 0;
		}
          break;

      /*----------------------------*/
        default:
      /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*=========================*/
    /* Awaiting CLK power down */
    /*=========================*/
    case UICC_AWAIT_CLK_POWER_DOWN:
      switch(event)
      {
        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;

          #ifdef UICC_IT3_27_12_1_PATCH
          /* Refrain from stopping the clock if the instruction just executed was the RUN GSM ALGORITHM (0x88) 
             to accomodate the Orga IT3 test requirements. The clock will be stopped again after the following 
             command. */
            if(!UICC_authentication_cmd_executing)
            {
              /* Examine the clock stop level (if any) supported by the card. */
              UICC_stop_clock_conditional(UICC_card_profile[UICC_current_reader].used_clock_stop_mode, UICC_current_reader);
            }
          #else
            /* Examine the clock stop level (if any) supported by the card. */
            UICC_stop_clock_conditional(UICC_card_profile[UICC_current_reader].used_clock_stop_mode, UICC_current_reader);
          #endif

          UICC_switch_uart_clock_off();

          /* Inform main statemachine of the execution result, that the
             clock now is stopped and that power down can be accepted. */
          UICC_t0_transport_handler(UICC_T0_CLOCK_STOPPED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /* Default                                  */
    /*==========================================*/
    default:
      #ifndef UICC_NO_DEBUG
        debug = UICC_t0_cmd_ctrl_state;
      #endif
      break;
  }

  #ifndef UICC_NO_DEBUG
    if(debug != UICC_T0_CMD_NONE)
    {
      UICC_log_data_ptr[0] = debug;
      if(UICC_t0_tpdu_ctrl.cmd_direction)
        UICC_log_data_ptr[1] = event | 0x80; /* Rx Command */
      else
        UICC_log_data_ptr[1] = event;	  	
      UICC_log_data_ptr[2] = (ubyte) (UICC_trace.nof_ins_cnt>>8);     
      UICC_log_data_ptr[3] = UICC_trace.nof_ins_cnt;     	  
      UICC_log_data_ptr[4] = UICC_t0_tpdu_ctrl.data_size;
      memcpy(&UICC_log_data_ptr[5], &UICC_tpdu_data[UICC_CLA_POS], 5);
      UICC_log_data_ptr[10] = (ubyte) (SIM_CTRL>>8);
      UICC_log_data_ptr[11]  = SIM_CTRL;
      UICC_log_data_ptr[12]  = ((ubyte) (SIM_STATUS>>8)) | ((ubyte)SIM_DMA<<7);
      UICC_log_data_ptr[13]  = SIM_STATUS;
      UICC_log_data_ptr[14]  = SIM_BRF;
      UICC_log_data_ptr[15]  = SIM_IRQEN;
      UICC_log_data_ptr[16]  = SIM_RXSPC;
      UICC_log_data_ptr[17]  = SIM_TXSPC;
      UICC_log_data_ptr[18]  = SIM_INS;
      UICC_log_data_ptr[19]  = SIM_TX;
      UICC_log_data_ptr[20]  = SIM_RX;
      UICC_log_data_ptr[21]  = SIM_P3;
      UICC_log_data_ptr[22]  = SIM_SW1;
      UICC_log_data_ptr[23]  = SIM_SW2;
      UICC_log_data_ptr[24]  = (ubyte) ((ubyte)(SIM_RIS<<4) | SIM_MIS);
      UICC_log_data_ptr[25]  = (ubyte) ((ubyte)(SIM_ICR<<4) | SIM_ISR);
      UICC_raise_exception(TRAP_UICC_T0_CMD, UICC_T0_INSTRUCTION_FAILED_1, 26); 

      debug = UICC_T0_CMD_NONE;
    }
  #endif
}

#else /*HW control T0 and not FIFO stand alone*/

void UICC_t0_cmd_handler(T_UICC_T0_CMD_EVENTS event)
{

#if defined (UICC_FIFO_MODE)
  ubyte ch;
#endif

#ifdef UICC_DEBUG_INF
 UICC_debug_t0[UICC_debug_count_t0][0] = 42;  
UICC_debug_t0[UICC_debug_count_t0][1] = UICC_t0_cmd_ctrl_state;
UICC_debug_t0[UICC_debug_count_t0][2] = event;
UICC_debug_count_t0 = (UICC_debug_count_t0+1) % 200;
#endif

  switch(UICC_t0_cmd_ctrl_state)
  {
    /*==========================================*/
    /* Inactive - ready to execute instructions */
    /*==========================================*/
    case UICC_T0_CMD_READY_CLK_OFF:
      switch(event)
      {
        /*----------------------------*/
        case UICC_INITIATE_CMD:
        /*----------------------------*/
          #if defined (UICC_FIFO_MODE)
            UICC_init_fifo();
          #endif
          /* An instruction request has been received. Prepar the instruction
             execution while waiting for that card to become alive again after
             the clock has been activated/re-activated. */
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY;
          UICC_enable_card_interface(); /* Includes UART ON */
          UICC_set_rxtx_space(120);     /* Spacing between last Rx character and the first Tx 
                                           character 120/16 ~ 7,5 ETU counted 9.5 ETU after 
                                           leading character edge (app. 17 ETU in total). */

          #if defined (SGOLD2) || defined (SGOLD3) || defined (SGOLDRADIO)
            UICC_set_txtx_space(0x02);      /* Tx Spacing. */
          #else
            if((UICC_baseband_profile.version == SYS_BB_VER_SGOLD) && 
               (UICC_baseband_profile.revision < SYS_BB_REV_12))
            { /* ONLY for S-GOLD < ES2.5 */
              /* UTP: WS00002548. Tx space should be set to 0 in order to by pass Tx Parity error 
                      handling problem in the HW block. */
              if((UICC_clock_rate_table[UICC_card_profile[UICC_current_reader].f_used] == 372) && 
                 (UICC_baud_rate_table[UICC_card_profile[UICC_current_reader].d_used] == 1))
              { /* Normal speed: TXSPC=0 */
                UICC_set_txtx_space(0x00);    /* Spacing between TX characters: 0 ETU */          
              }
              else
              { /* High Speed: TXSPC>2 */
                UICC_set_txtx_space(0x03);    /* Spacing between TX characters: 3 ETU */
              }
            }
            else
            {
              UICC_set_txtx_space(0x02);      /* Tx Spacing. */
            }
          #endif

          UICC_select_T0_instruction_mode();
          UICC_disable_parity_error_interrupt();
          UICC_disable_usim_ok_isr();
          UICC_disable_character_interrupt();  
          UICC_enable_overrun_error_interrupt();
          UICC_enable_t0_end_interrupt();
          UICC_enable_dma_channel();
          UICC_select_high_clock_freq();
          UICC_activate_clk(UICC_current_reader);
          UICC_start_timer(T_CLK_PU);


#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif

	  
          break;

        /*----------------------------*/
        case UICC_STOP_CMD_CLOCK:
        /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_AWAIT_CLK_POWER_DOWN;
          UICC_start_timer(T_CLK_PD);          


#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif


          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /* Active - waiting for the card to wakeup. */
    /*==========================================*/
    case UICC_T0_CMD_READY:
      switch(event)
      {
        /*----------------------------*/
        case UICC_INITIATE_CMD:
        /*----------------------------*/
          UICC_enable_card_interface(); /* Includes UART ON */
          UICC_enable_dma_channel();
          UICC_start_timer(T_CLK_DIST); /* Start timer to ensure distance between two
                                           successive commands. Stay in this state. */


#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif


          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
        {
          prepare_instruction();
          UICC_set_character_timer(cmd_wwt);
          UICC_enable_char_timeout_interrupt();

          if(UICC_t0_tpdu_ctrl.cmd_direction == UICC_TX_CMD)
          { /* Tx command */
            #if defined (UICC_FIFO_MODE)
              UICC_t0_cmd_ctrl_state = UICC_TX_CMD_DATA;
            #else
              UICC_t0_cmd_ctrl_state = UICC_CMD_DATA;		 
            #endif 

            /* Setup the DMA to be ready to transfer the 5 command header bytes and the TX command data. */
            UICC_dma_tx_control(CMD_HEADER_SIZE + UICC_t0_tpdu_ctrl.data_size, 
                                cmd_header_ptr, 
                                UICC_USIM_FLOW_CONTROL);

            /* Initiate the actiual command. */
            UICC_commence_t0_command(UICC_tpdu_data[UICC_P3_POS], 
                                     UICC_tpdu_data[UICC_INS_POS], 
                                     UICC_TX_CMD);
          }
          else /* Rx command */
          {
            UICC_t0_cmd_ctrl_state = UICC_RX_HEADER;
            
            /* Setup the DMA to be ready to transfer the 5 command header bytes. */
            #if defined (UICC_FIFO_MODE)
              /*For RX command in FIFO mode wait to start T0 command (UICC_commence_t0_command ()) until the header is transfer from DMA
              to the FIFO, then start T0 command and setup the DMA in RX mode at  the same time. This is the advandtage when using FIFO */
              
              UICC_dma_tx_control(CMD_HEADER_SIZE, 
                                cmd_header_ptr, 
                                UICC_USIM_FLOW_CONTROL_WITH_DMA_INT);   
            #else
              UICC_dma_tx_control(CMD_HEADER_SIZE, 
                                cmd_header_ptr, 
                                UICC_DMA_FLOW_CONTROL);

              /* Initiate the actiual command. */
              UICC_commence_t0_command(UICC_tpdu_data[UICC_P3_POS], 
                                     UICC_tpdu_data[UICC_INS_POS], 
                                     UICC_RX_CMD);
            #endif  
          }
        }
        break;

        /*----------------------------*/
        case UICC_STOP_CMD_CLOCK:
        /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_AWAIT_CLK_POWER_DOWN;
          UICC_start_timer(T_CLK_PD);          


#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif

  
          break;

        /*----------------------------*/
        case UICC_OVERRUN_ERROR:        
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_dma_disable_control();
          UICC_disable_char_timeout_interrupt();
          UICC_switch_uart_clock_off();
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_start_timer(T_CLK_FAIL);          


#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif


          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*===========================================================*/
    /* Active - sending command header to the card (Rx-command). */
    /*===========================================================*/
    case UICC_RX_HEADER:
      switch(event)
      {
        /*----------------------------*/
        case UICC_DMA_END:               
        /*----------------------------*/
          /* The command header has now been sent to the card and the Rx command
             data (the command body) will now be handlede. */
          #if defined (UICC_FIFO_MODE)
            UICC_t0_cmd_ctrl_state = UICC_RX_CMD_DATA;	

            /* Initiate the actual command. */
            UICC_commence_t0_command(UICC_tpdu_data[UICC_P3_POS], 
                                     UICC_tpdu_data[UICC_INS_POS], 
                                     UICC_RX_CMD);
            UICC_dma_rx_control(UICC_t0_tpdu_ctrl.data_size, cmd_data_ptr, UICC_USIM_FLOW_CONTROL_WITH_DMA_INT);
                                     
         #else	
           UICC_t0_cmd_ctrl_state = UICC_CMD_DATA;
           UICC_dma_rx_control(UICC_t0_tpdu_ctrl.data_size, cmd_data_ptr, UICC_USIM_FLOW_CONTROL); 
         #endif

          break;

        /*----------------------------*/
        case UICC_CHTIMEOUT:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif

          /* The command header has for some reason not been sent and the
             command fails. */
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_force_timeout();
          break;

        /*----------------------------*/
        case UICC_OVERRUN_ERROR:        
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_dma_disable_control();
          UICC_disable_char_timeout_interrupt();
          UICC_switch_uart_clock_off();
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_start_timer(T_CLK_FAIL);          


#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif

	  
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /* Handling the block data interchange.     */
    /*==========================================*/
    case UICC_CMD_DATA:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T0_END:
        /*----------------------------*/
          /* Instruction ended successfully - SW1 & SW2 received. */
          UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED;
          UICC_force_timeout();
          break;

        /*----------------------------*/
        case UICC_CHTIMEOUT:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif

          /* All data has not been handled correct and the command fails. */
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_force_timeout();
          break;

        /*----------------------------*/
        case UICC_OVERRUN_ERROR:        
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_dma_disable_control();
          UICC_disable_char_timeout_interrupt();
          UICC_switch_uart_clock_off();
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_start_timer(T_CLK_FAIL);          


#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif

		  
          break;

       /*----------------------------*/
        default:
       /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    #if defined (UICC_FIFO_MODE)
    case UICC_TX_CMD_DATA:
      switch(event)
      {
          /*----------------------------*/
          case UICC_T0_END:
          /*----------------------------*/
          /* Instruction ended successfully - SW1 & SW2 received. */       
            ch= SIM_SW1;
            if((ch != 0x60) && ((ch & 0xF0) == 0x60)) // If SW1 = 6X (except 60)
            {
                //Clear FIFO
              SIM_RUN_CTRL = 0; //RUN = 0
              SIM_FIFO_ICR = 0x3FF; //Clear FIFO interrupt register
              SIM_RUN_CTRL = 1; //RUN = 1                
           }
            UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED;
            UICC_force_timeout();			
            break;

        /*----------------------------*/
        case UICC_CHTIMEOUT:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "(%d),SIM_FIFO_ISR = %x, SIM_STATUS = %x, cmd_wwt = %x,SIM_FFS_STAT = %x ,SIM_TX=%x,SIM_RX=%x \n",zOss_GetTickCount(), SIM_FIFO_MIS,SIM_STATUS,cmd_wwt,SIM_FFS_STAT,SIM_TX,SIM_RX);

          /* All data has not been handled correct and the command fails. */
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_force_timeout();
          break;

        /*----------------------------*/
        case UICC_OVERRUN_ERROR:        
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_dma_disable_control();
          UICC_disable_char_timeout_interrupt();
          UICC_switch_uart_clock_off();
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_start_timer(T_CLK_FAIL);          


#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif


          break;

       /*----------------------------*/
        default:
       /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    case UICC_RX_CMD_DATA:
      switch(event)
      {
        /* Instruction ended successfully - SW1 & SW2 received. */
          /*----------------------------*/
          case UICC_T0_END:
          /*----------------------------*/
            UICC_t0_cmd_ctrl_state = UICC_CMD_AWAIT_DMA_END;
            UICC_start_timer(T_AWAIT_DMA_END); 	     
            break;

        /*----------------------------*/
        case UICC_CHTIMEOUT:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif

          /* All data has not been handled correct and the command fails. */
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_force_timeout();
          break;

        /*----------------------------*/
        case UICC_OVERRUN_ERROR:        
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_dma_disable_control();
          UICC_disable_char_timeout_interrupt();
          UICC_switch_uart_clock_off();
          UICC_t0_cmd_ctrl_state = UICC_CMD_FAILED;
          UICC_start_timer(T_CLK_FAIL);          


#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif

		  
          break;

       /*----------------------------*/
        default:
       /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    case UICC_CMD_AWAIT_DMA_END:
      switch(event)
      {
        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          /* Do not received DMA_END that mean No data received*/
          UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED_WITH_NO_DATA;
          UICC_force_timeout();
          break;

        /*----------------------------*/
        case UICC_DMA_END:               
        /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_CMD_SUCCEEDED;
          UICC_force_timeout();		
          break;

       /*----------------------------*/
        default:
       /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;	

#endif //FIFO_MODE

    /*===============================================================*/
    /* Command sucessfully executed - wait before powering CLK down. */
    /*===============================================================*/
    case UICC_CMD_SUCCEEDED:
      switch(event)
      {
      /*----------------------------*/
        case UICC_TIMER_EXPIRED:
      /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY;
          UICC_dma_disable_control();
          UICC_disable_char_timeout_interrupt();
          
          /* SW1 & SW2 is retreived. */
          UICC_tpdu_footer = UICC_get_t0_command_response();

          #ifndef UICC_NO_DEBUG
            UICC_trace.log_buf[UICC_trace.log_buf_cnt][7] = UICC_tpdu_footer.sw1;
            UICC_trace.log_buf[UICC_trace.log_buf_cnt][8] = UICC_tpdu_footer.sw2;
          #endif

          #if defined (UICC_FIFO_MODE)
              UICC_t0_transport_handler(UICC_T0_CMD_SUCCEEDED);
          #else	  
          /* Inform main statemachine of the execution result. But first see is all data
             has been transferred: */
          if(UICC_dma_get_transfer_cnt())
          {
            /* SW1 and SW2 has been received allright and seen from that perspective did the 
               command execution succeed - BUT since the DMA counter is not zero, this means 
               that SW1 and SW2 was received without sending/receiving the requested data pool. */ 
            UICC_t0_transport_handler(UICC_T0_CMD_SUCCEEDED_NO_DATA);
          }
          else
          {
            UICC_t0_transport_handler(UICC_T0_CMD_SUCCEEDED);
          }
            #endif 	  
          break;

       /*----------------------------*/
        default:
       /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    #if defined (UICC_FIFO_MODE)

    case UICC_CMD_SUCCEEDED_WITH_NO_DATA:
      switch(event)
      {
      /*----------------------------*/
        case UICC_TIMER_EXPIRED:
      /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY;
          UICC_dma_disable_control();
          UICC_disable_char_timeout_interrupt();
          
          /* SW1 & SW2 is retreived. */
          UICC_tpdu_footer = UICC_get_t0_command_response();

          #ifndef UICC_NO_DEBUG
            UICC_trace.log_buf[UICC_trace.log_buf_cnt][7] = UICC_tpdu_footer.sw1;
            UICC_trace.log_buf[UICC_trace.log_buf_cnt][8] = UICC_tpdu_footer.sw2;
          #endif

          /* Inform main statemachine of the execution result */
          /* In this state the SW1 and SW2 was received without the requested data pool. */ 
          UICC_t0_transport_handler(UICC_T0_CMD_SUCCEEDED_NO_DATA);

          break;

       /*----------------------------*/
        default:
       /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;
      #endif

    /*===============================================================*/
    /* Command execution failed.                                     */
    /*===============================================================*/
    case UICC_CMD_FAILED:
      switch(event)
      {
      /*----------------------------*/
        case UICC_TIMER_EXPIRED:
      /*----------------------------*/
          UICC_dma_disable_control();
          UICC_disable_char_timeout_interrupt();
          UICC_switch_uart_clock_off();
          UICC_disable_card_interface(); /* To reset the HW for a potential new command. */
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
          UICC_t0_transport_handler(UICC_T0_CMD_FAILED);
          break;

      /*----------------------------*/
        default:
      /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*=========================*/
    /* Awaiting CLK power down */
    /*=========================*/
    case UICC_AWAIT_CLK_POWER_DOWN:
      switch(event)
      {
        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;

          #ifdef UICC_IT3_27_12_1_PATCH
          /* Refrain from stopping the clock if the instruction just executed was the RUN GSM ALGORITHM (0x88) 
             to accomodate the Orga IT3 test requirements. The clock will be stopped again after the following 
             command. */
            if(!UICC_authentication_cmd_executing)
            {
              /* Examine the clock stop level (if any) supported by the card. */
              UICC_stop_clock_conditional(UICC_card_profile[UICC_current_reader].used_clock_stop_mode, UICC_current_reader);
            }
          #else
            /* Examine the clock stop level (if any) supported by the card. */
            UICC_stop_clock_conditional(UICC_card_profile[UICC_current_reader].used_clock_stop_mode, UICC_current_reader);
          #endif

          UICC_switch_uart_clock_off();

          /* Inform main statemachine of the execution result, that the
             clock now is stopped and that power down can be accepted. */
          UICC_t0_transport_handler(UICC_T0_CLOCK_STOPPED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /* Default                                  */
    /*==========================================*/
    default:
      #ifndef UICC_NO_DEBUG
        debug = UICC_t0_cmd_ctrl_state;
      #endif
      break;
  }

  #ifndef UICC_NO_DEBUG
    if(debug != UICC_T0_CMD_NONE)
    {
      UICC_log_data_ptr[0] = debug;
      if(UICC_t0_tpdu_ctrl.cmd_direction)
        UICC_log_data_ptr[1] = event | 0x80; /* Rx Command */
      else
        UICC_log_data_ptr[1] = event;	  	
      UICC_log_data_ptr[2] = (ubyte) (UICC_trace.nof_ins_cnt>>8);     
      UICC_log_data_ptr[3] = UICC_trace.nof_ins_cnt;     	  
      UICC_log_data_ptr[4] = UICC_t0_tpdu_ctrl.data_size;
      memcpy(&UICC_log_data_ptr[5], &UICC_tpdu_data[UICC_CLA_POS], 5);
      UICC_log_data_ptr[10] = (ubyte) (SIM_CTRL>>8);
      UICC_log_data_ptr[11]  = SIM_CTRL;
      UICC_log_data_ptr[12]  = ((ubyte) (SIM_STATUS>>8)) | ((ubyte)SIM_DMA<<7);
      UICC_log_data_ptr[13]  = SIM_STATUS;
      UICC_log_data_ptr[14]  = SIM_BRF;
      UICC_log_data_ptr[15]  = SIM_IRQEN;
      UICC_log_data_ptr[16]  = SIM_RXSPC;
      UICC_log_data_ptr[17]  = SIM_TXSPC;
      UICC_log_data_ptr[18]  = SIM_INS;
      UICC_log_data_ptr[19]  = SIM_TX;
      UICC_log_data_ptr[20]  = SIM_RX;
      UICC_log_data_ptr[21]  = SIM_P3;
      UICC_log_data_ptr[22]  = SIM_SW1;
      UICC_log_data_ptr[23]  = SIM_SW2;
      UICC_log_data_ptr[24]  = (ubyte) ((ubyte)(SIM_RIS<<4) | SIM_MIS);
      UICC_log_data_ptr[25]  = (ubyte) ((ubyte)(SIM_ICR<<4) | SIM_ISR);
      UICC_log_data_ptr[26]  = (ubyte)(UICC_dma_get_transfer_cnt());	  
      UICC_raise_exception(TRAP_UICC_T0_CMD, UICC_T0_INSTRUCTION_FAILED_1, 27); 

      debug = UICC_T0_CMD_NONE;
    }
  #endif
}
#endif /*FIFO ONLY*/

#else /* end UICC_HW_CONTROLLED_T0 -> SW controlled INSTRUCTION HANDLING. */

void UICC_reset_t0_cmd_handler(void)
{
  UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;

  #ifndef UICC_NO_DEBUG  
    UICC_trace.log_buf_cnt = 0;
  #endif
}

/*******************************************************************************
* Function:... UICC_ctrl_ins
* Parameters:. event: The event triggering the statemachine.
* Returns:.... -
* Description: This statemachine/engine is controlling the execution of the T=0
*              protocol instructions.
* Created:.... 26.09.01 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_t0_cmd_handler(T_UICC_T0_CMD_EVENTS event)
{
  ubyte ch;

  switch(UICC_t0_cmd_ctrl_state)
  {
    /*==========================================*/
    /* Inactive - ready to execute instructions */
    /*==========================================*/
    case UICC_T0_CMD_READY_CLK_OFF:
      switch(event)
      {
        /*----------------------------*/
         case UICC_INITIATE_CMD:
        /*----------------------------*/
          /* An instruction request has been received. Prepar the instruction
             execution while waiting for that card to become alive again after
             the clock has been activated/re-activated. */
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY;
          UICC_enable_card_interface(); /* Includes UART ON */  
          UICC_set_rxtx_space(120);     /* Spacing between last Rx character and the first Tx 
                                           character 120/16 ~ 7,5 ETU counted 9.5 ETU after 
                                           leading character edge (app. 17 ETU in total). */
          UICC_disable_parity_error_interrupt();
          UICC_enable_usim_ok_isr();
          UICC_enable_character_interrupt();
          UICC_select_high_clock_freq();
          UICC_activate_clk(UICC_current_reader);
          UICC_start_timer(T_CLK_PU);
          break;

        /*----------------------------*/
        case UICC_STOP_CMD_CLOCK:
        /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_AWAIT_CLK_POWER_DOWN;
          UICC_start_timer(T_CLK_PD);          
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /* Active - waiting for the card to wakeup. */
    /*==========================================*/
    case UICC_T0_CMD_READY:
      switch(event)
      {

        /*----------------------------*/
        case UICC_INITIATE_CMD:
        /*----------------------------*/
          UICC_enable_card_interface(); /* Includes UART ON */  
          /* break removed bu purpose. */

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_CMD_HEADER;
          prepare_instruction();
          UICC_start_timer(cmd_wwt); /* Ensure that we do not wait for the HW forever. */
          UICC_send_character(*cmd_header_ptr);
          cmd_header_ptr++;
          break;

        /*----------------------------*/
        case UICC_STOP_CMD_CLOCK:
        /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_AWAIT_CLK_POWER_DOWN;
          UICC_start_timer(T_CLK_PD);          
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /*                                          */
    /*==========================================*/
    case UICC_CMD_HEADER_GUARD:
      switch(event)
      {
        /*----------------------------*/
        case UICC_GUARD_TIMER_EXPIRED:
        /*----------------------------*/
          head_cnt--;
          UICC_start_timer(cmd_wwt);
          UICC_t0_cmd_ctrl_state = UICC_CMD_HEADER;
          UICC_send_character(*cmd_header_ptr);
          cmd_header_ptr++;
          break;
  
        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
          instruction_failed();
          break;

        /*----------------------------*/
        case UICC_CHARACTER_OK:
        /*----------------------------*/
          UICC_get_character();
          break;
      } 
      break;
     
    /*==========================================*/
    /* Receiving the command header.            */
    /*==========================================*/
    case UICC_CMD_HEADER:
      switch(event)
      {
        /*----------------------------*/
        case UICC_CHARACTER_OK:
        /*----------------------------*/
          UICC_stop_timer();
          if(head_cnt)                      
          {
            UICC_t0_cmd_ctrl_state = UICC_CMD_HEADER_GUARD;
            UICC_start_guard_timer(tx_spc); /* Create distance to the next Tx-character. */


          }
          else 
          { /* Header transmitted - await procedure byte! */

            if(UICC_t0_tpdu_ctrl.cmd_direction == UICC_TX_CMD) /* Continue with the TX data transmission */
            {                                                 /* by awaiting the procedure byte.        */
              UICC_t0_cmd_ctrl_state = UICC_TX_PROCEDURE_BYTE;
            }
            else /* Continue with the RX data reception by awaiting the procedure byte. */
            { 
              UICC_enable_parity_error_interrupt();
              UICC_t0_cmd_ctrl_state = UICC_RX_PROCEDURE_BYTE;
            }

            UICC_start_timer(cmd_wwt);        
          }
          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
          instruction_failed();
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;
  
    /*==========================================*/
    /* Receiving the TX procedure byte.         */
    /*==========================================*/
    case UICC_TX_PROCEDURE_BYTE:
      switch(event)
      {
        /*----------------------------*/
        case UICC_CHARACTER_OK:
        /*----------------------------*/
          UICC_stop_timer();
          ch = UICC_get_character();

          if(ch == NULL_ACK_BYTE)  
          { /* NULL byte - just extend the WWT and await the next procedure byte. */
            UICC_start_timer(cmd_wwt);
          }
          else if((ch>>4 == 6) || /* (ch & 0xF0) == 0x60 */ 
                  (ch>>4 == 9))   /* (ch & 0xF0) == 0x90 */
          { /* Status Word SW1 received. */
            UICC_t0_cmd_ctrl_state = UICC_CMD_RESULT;
            UICC_tpdu_footer.sw1 = ch;
            UICC_start_timer(cmd_wwt);
          }
          else
          { /* More data to send? */
            if(data_cnt)
            {
              if(ch == (UICC_tpdu_data[UICC_INS_POS] & 0xFE)) /* Go ahead with block transter */
              {
                data_cnt--;
                UICC_start_timer(cmd_wwt);
                UICC_t0_cmd_ctrl_state = UICC_TX_MORE_DATA;
                UICC_send_character(*cmd_data_ptr);
                cmd_data_ptr++;
              }
              else                                  /* Just transfer one byte */
              {
                UICC_t0_cmd_ctrl_state = UICC_TX_ONE_DATA_GUARD;
              }

              UICC_start_guard_timer(tx_spc); /* To make appropriate distance to the next 
                                                 Tx character. */
            }
            else
            {
              UICC_start_timer(cmd_wwt);
            }
          }
          break;
 
        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
          instruction_failed();
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;
      
    /*==========================================*/
    /* Receiving ONE TX data byte.              */
    /*==========================================*/
    case UICC_TX_ONE_DATA_GUARD:
      switch(event)
      {
        /*----------------------------*/
        case UICC_GUARD_TIMER_EXPIRED:
        /*----------------------------*/
          data_cnt--;
          UICC_start_timer(cmd_wwt);
          UICC_t0_cmd_ctrl_state = UICC_TX_ONE_DATA;
          UICC_send_character(*cmd_data_ptr);
          cmd_data_ptr++;
          break;

        /*----------------------------*/
        case UICC_CHARACTER_OK:
        /*----------------------------*/
          UICC_get_character();
          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
          instruction_failed();
          break;
          
        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /* Receiving ONE TX data byte.              */
    /*==========================================*/
    case UICC_TX_ONE_DATA:
      switch(event)
      {
        /*----------------------------*/
        case UICC_CHARACTER_OK:
        /*----------------------------*/
          UICC_stop_timer();
          UICC_t0_cmd_ctrl_state = UICC_TX_PROCEDURE_BYTE;
          UICC_start_timer(cmd_wwt);
          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
          instruction_failed();
          break;
          
        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /* Receiving ALL TX data bytes.             */
    /*==========================================*/
    case UICC_TX_MORE_DATA_GUARD:
      switch(event)
      {
        /*----------------------------*/
        case UICC_CHARACTER_OK:
        /*----------------------------*/
          UICC_get_character();
          break;

        /*----------------------------*/
        case UICC_GUARD_TIMER_EXPIRED:
        /*----------------------------*/        
          data_cnt--;
          UICC_start_timer(cmd_wwt);
          UICC_t0_cmd_ctrl_state = UICC_TX_MORE_DATA;
          UICC_send_character(*cmd_data_ptr);
          cmd_data_ptr++;
          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/        
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
          instruction_failed();
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /* Receiving ALL TX data bytes.             */
    /*==========================================*/
    case UICC_TX_MORE_DATA:
      switch(event)
      {
        /*----------------------------*/
        case UICC_CHARACTER_OK:
        /*----------------------------*/
          UICC_stop_timer();
          if(data_cnt) /* More data */
          {
            UICC_t0_cmd_ctrl_state = UICC_TX_MORE_DATA_GUARD;
            UICC_start_guard_timer(tx_spc);
          }
          else
          { /* Transfer accomplished. */
            UICC_t0_cmd_ctrl_state = UICC_TX_PROCEDURE_BYTE;
            UICC_start_timer(cmd_wwt);
          }
          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/        
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
          instruction_failed();
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /* Receiving the RX procedure byte.         */
    /*==========================================*/
    case UICC_RX_PROCEDURE_BYTE:
      switch(event)
      {
        /*----------------------------*/
        case UICC_CHARACTER_OK:
        /*----------------------------*/
          ch = UICC_get_character();

          if(ch == NULL_ACK_BYTE)                        
          {
            /* Restart Work Waiting Timer */
            ;
          }
          else if((ch>>4 == 6) || /* (ch & 0xF0) == 0x60 */ 
                  (ch>>4 == 9))   /* (ch & 0xF0) == 0x90 */
          { /* Status Word SW1 received. */
            UICC_t0_cmd_ctrl_state = UICC_CMD_RESULT;
            UICC_tpdu_footer.sw1 = ch;
          }
          else
          {
            /* Still more data to receive? - otherwise awaite SW1 */
            if(data_cnt)
            {
              if(ch == (UICC_tpdu_data[UICC_INS_POS] & 0xFE)) /* Block transter */
              {
                UICC_t0_cmd_ctrl_state = UICC_RX_MORE_DATA;
              }
              else                                  /* Receive one byte */
              {
                UICC_t0_cmd_ctrl_state = UICC_RX_ONE_DATA;
              }
            }
          }

          UICC_start_timer(cmd_wwt);
          break;

        /*----------------------------*/
        case UICC_PARITY_ERROR:
        /*----------------------------*/
          UICC_start_timer(cmd_wwt);
          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
          instruction_failed();
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;
      
    /*==========================================*/
    /* Receiving ONE RX data byte.              */
    /*==========================================*/
    case UICC_RX_ONE_DATA:
      switch(event)
      {
        /*----------------------------*/
        case UICC_CHARACTER_OK:
        /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_RX_PROCEDURE_BYTE;
          *cmd_data_ptr = UICC_get_character();
          cmd_data_ptr++;
          data_cnt--;
          UICC_start_timer(cmd_wwt);
          break;

        /*----------------------------*/
        case UICC_PARITY_ERROR:
        /*----------------------------*/
          UICC_start_timer(cmd_wwt);
          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
          instruction_failed();
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;
      
    /*==========================================*/
    /* Receiving ALL RX data bytes.             */
    /*==========================================*/
    case UICC_RX_MORE_DATA:
      switch(event)
      {
        /*----------------------------*/
        case UICC_CHARACTER_OK:
        /*----------------------------*/
          *cmd_data_ptr = UICC_get_character();
          cmd_data_ptr++;
          data_cnt--;

          /* More data characters to be received? */
          if(data_cnt == 0)
          { 
            UICC_t0_cmd_ctrl_state = UICC_RX_PROCEDURE_BYTE;
          }
          //else  /* More characters to come - stay in this state. */

          UICC_start_timer(cmd_wwt);
          break;

        /*----------------------------*/
        case UICC_PARITY_ERROR:
        /*----------------------------*/
          UICC_start_timer(cmd_wwt);
          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
          instruction_failed();
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*==========================================*/
    /* Receiving the command result (SW2)       */
    /*==========================================*/
    case UICC_CMD_RESULT:
      switch(event)
      {
        /*----------------------------*/
        case UICC_CHARACTER_OK:
        /*----------------------------*/
          UICC_tpdu_footer.sw2 = UICC_get_character();
          UICC_t0_cmd_ctrl_state =  UICC_CMD_SUCCEEDED;
          UICC_force_timeout();
          break;

        /*----------------------------*/
        case UICC_PARITY_ERROR:
        /*----------------------------*/
          UICC_start_timer(cmd_wwt);
          break;

        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;
          instruction_failed();
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;
      
    /*==========================================*/
    /* The command succeeded - await the clock  */
    /*==========================================*/
    case UICC_CMD_SUCCEEDED:
      switch(event)
      {
        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/        
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY;

          /* Inform main statemachine of the execution result, that the
             clock now is stopped and that power down can be accepted. */
          if(data_cnt)
          {
            /* SW1 and SW2 has been received allright aand seen from that perspective did the 
               command execution succeed - BUT since the counter is not zero, this means that
               SW1 and SW2 was received without sending/receiving the requested data pool. */ 
            UICC_t0_transport_handler(UICC_T0_CMD_SUCCEEDED_NO_DATA);
          }
          else
          {
            /* The requested data pool has been sent/received (data_cnt==0) .*/
            UICC_t0_transport_handler(UICC_T0_CMD_SUCCEEDED);
          }
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;

    /*=========================*/
    /* Awaiting CLK power down */
    /*=========================*/
    case UICC_AWAIT_CLK_POWER_DOWN:
      switch(event)
      {
        /*----------------------------*/
        case UICC_TIMER_EXPIRED:
        /*----------------------------*/
          UICC_t0_cmd_ctrl_state = UICC_T0_CMD_READY_CLK_OFF;

          #ifdef UICC_IT3_27_12_1_PATCH
          /* Refrain from stopping the clock if the instruction just executed was the RUN GSM ALGORITHM (0x88) 
             to accomodate the Orga IT3 test requirements. The clock will be stopped again after the following 
             command. */
            if(!UICC_authentication_cmd_executing)
            {
              /* Examine the clock stop level (if any) supported by the card. */
              UICC_stop_clock_conditional(UICC_card_profile[UICC_current_reader].used_clock_stop_mode, UICC_current_reader);
            }
          #else
            /* Examine the clock stop level (if any) supported by the card. */
            UICC_stop_clock_conditional(UICC_card_profile[UICC_current_reader].used_clock_stop_mode, UICC_current_reader);
          #endif

          UICC_switch_uart_clock_off();

          /* Inform main statemachine of the execution result, that the
             clock now is stopped and that power down can be accepted. */
          UICC_t0_transport_handler(UICC_T0_CLOCK_STOPPED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t0_cmd_ctrl_state;
          #endif
          break;
      }
      break;
          
    /*==========================================*/
    /* Default                                  */
    /*==========================================*/
    default:
      #ifndef UICC_NO_DEBUG
        debug = UICC_t0_cmd_ctrl_state;
      #endif
      break;
  }
  #ifndef UICC_NO_DEBUG
    if(debug)
    {
      UICC_log_data_ptr[0] = debug;
      UICC_log_data_ptr[1] = event;
      memcpy(&UICC_log_data_ptr[2],  &UICC_trace.nof_ins_req, 8);
      UICC_log_data_ptr[9] = UICC_t0_tpdu_ctrl.cmd_direction;
      memcpy(&UICC_log_data_ptr[10], &UICC_trace.log_buf[UICC_trace.log_buf_cnt], 9);
      UICC_raise_exception(TRAP_UICC_T0_CMD, UICC_T0_INSTRUCTION_FAILED_1, 19); 

      UICC_log_data_ptr[0]  = (ubyte) (SIM_CTRL>>8);
      UICC_log_data_ptr[1]  = SIM_CTRL;
      UICC_log_data_ptr[2]  = ((ubyte) (SIM_STATUS>>8)) | ((ubyte)SIM_DMA<<7);
      UICC_log_data_ptr[3]  = SIM_STATUS;
      UICC_log_data_ptr[4]  = SIM_BRF;
      UICC_log_data_ptr[5]  = SIM_IRQEN;
      UICC_log_data_ptr[6]  = SIM_RXSPC;
      UICC_log_data_ptr[7]  = SIM_TXSPC;
      UICC_log_data_ptr[8]  = SIM_CTRL2;
      UICC_log_data_ptr[9]  = SIM_T1CTRL;
      UICC_log_data_ptr[10] = (ubyte) (SIM_INS>>8);
      UICC_log_data_ptr[11] = SIM_INS;
      UICC_log_data_ptr[12] = SIM_TX;
      UICC_log_data_ptr[13] = SIM_RX;
      UICC_log_data_ptr[14] = SIM_P3;
      UICC_log_data_ptr[15] = SIM_SW1;
      UICC_log_data_ptr[16] = SIM_SW2;
      UICC_log_data_ptr[17] = (ubyte) ((ubyte)(SIM_RIS<<4) | SIM_MIS);
      UICC_log_data_ptr[18] = (ubyte) ((ubyte)(SIM_ICR<<4) | SIM_ISR);
      UICC_raise_exception(TRAP_UICC_T0_CMD, UICC_T0_INSTRUCTION_FAILED_2, 19); 

      debug = 0;
    }
  #endif
}
#endif

                                                 /* End of file.              */
