/**************************************************************************
*
*             Protocol Stack Adapter Layer Telephone Interface
*
*                  Copyright (c) 2007 ZTE Corporation.
*
***************************************************************************
*
*   汾 :   ͨѶɷ޹˾ ֻҵ 
*   ģ   :   ATI2ģԴļ
*      :   zati_com.c
*   ļʶ :   
*   ļ : 
*   ʵֹ :   
*        :   
*        :   1.0
*    :   2012/01/09
*   ˵ :
***************************************************************************/

#include "ps/src/nas/ati/inc/zati_com.h"
#include "ps/src/nas/ati/inc/zat_com.h"

/**************************************************************************
*                           ȫֱ                                      *
**************************************************************************/
T_zAti_Data *g_zAti_ptData;  /* ATI */
T_zAti_Data_Ex g_zAti_atDataEx[Z_ATI_INSTANCE_MAX_NUM] = {0};

T_ZAti_Context                 g_zAti_Context                  = {0};
T_ZAti_SmContext            g_zAti_SmContext[Z_ATI_INSTANCE_MAX_NUM]  = {0};
T_ZAti_EmInfo g_zAti_EmInfo[Z_ATI_INSTANCE_MAX_NUM] = {0};
T_ZAti_EmInfoSemaphore g_zAti_EmInfoSemaphore[Z_ATI_INSTANCE_MAX_NUM] = {0};
T_ZAti_EmInfoMutex g_zAti_EmInfoMutex[Z_ATI_INSTANCE_MAX_NUM] = {0};

#ifdef  _USE_GLOBAL_TRACE
T_zAti_AtmemData    g_zAti_Atmem = {0};
T_zAti_Golbal_Data    g_zAti_GlobData = {0};
#endif

UINT8 g_zAti_CurInstance = 0;  /* ǰATIϢӦĴЭջ*/


SINT32 __ps_static_func zAti_SendFnc(BYTE chID, BYTE *data, UINT16 dataLen, T_zAti2_CtrmChInd chInd)
{
    if(g_zAti_Context.sendFnc != NULL)
    {
        return g_zAti_Context.sendFnc(chID, data, dataLen, chInd);
    }
    return ZATI2_FALSE;
}
/**************************************************************************
* : zAti_memCheck
* : ĳڴǷȫbValǷZ_SUCC, ǷZ_FAIL
* :
*    pBuff       ڴ׵ַ
*    wBuffLen    ҪڴС
*    bVal        ֵ֤
*     أZ_FAIL/Z_SUCC
* ע    ͣ
****************************************************************************/
BYTE __ps_static_func zAti_memCheck(BYTE *pBuff, WORD wBuffLen, BYTE bVal)
{
    WORD i = 0;

    for (i = 0; i < wBuffLen; i ++)
    {
        if (pBuff[i] != bVal)
        {
            return Z_FAIL;
        }
    }

    return Z_SUCC;
}

/***************************************************************************
: zAti_GetLittle
: ȡBYTE͵С
: 
  ֵ:
    :
ע    : 
***************************************************************************/
BYTE zAti_GetLittle(BYTE bP1, BYTE bP2)
{
    return ((bP1 >= bP2) ? bP2 : bP1);    
}

/***************************************************************************
* : zAti_CheckQryPbResult
* : PBѯ绰صĽм
* :
*           ptQryResult: ѯĽ
*   ֵ:
*           Z_ATI_QRYPB_SUCC          PBҳɹм¼
*           Z_ATI_QRYPB_FAIL          PBʧܣش
*           Z_ATI_QRYPB_INVALIDPARA   PBصĲд
*     :
* ע    : 
***************************************************************************/
BYTE zAti_CheckQryPbResult(T_zApMmia_QryPhoneResult *ptQryResult)
{
    if ((ptQryResult->bResult != Z_APMMIA_OPERATION_FAILURE) && 
        (ptQryResult->bResult != Z_APMMIA_OPERATION_SUCCESS))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return Z_ATI_QRYPB_INVALIDPARA;
    }

    if (Z_APMMIA_OPERATION_FAILURE == ptQryResult->bResult)
    {
        return Z_ATI_QRYPB_FAIL;
    }  
    
    if (ptQryResult->tNum.bNumLen > Z_MAX_CALLNUM_LEN)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return Z_ATI_QRYPB_INVALIDPARA;
    }
        
    return Z_ATI_QRYPB_SUCC;
}

#ifdef USE_VOICE_SUPPORT
/**************************************************************************
: zAti_LongToArray
: ڽת
    :  
    
    أתɹbLongParaBytesNumʧ򷵻0
ע    ͣbArraySizeĴСҲСڳ
                    ʵռеֽbArraySize2޷
                    0x123456Ҫ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
VOID zAti_LongToArray(BYTE *pbArray, DWORD dwPara, BYTE bArraySize)
{
    BYTE i = 0;
#ifdef BIG_ENDIAN
    for (i = 0; i < bArraySize; i++)
    {
        pbArray[i] = *((BYTE *)&dwPara + i);
    }
#else
    for (i = 0; bArraySize > 0; i++, bArraySize--)
    {
        pbArray[bArraySize - 1] = *((BYTE *)&dwPara + i);
    }
#endif
}

/**************************************************************************
: zAti_ArrayToLong
: ڽתɳ
    :  
    
    أ
ע    ͣbArraySizeдŵķ0ֵֽڸ
                    СΪ40x123400bArraySize
                    ӦΪ34
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
BYTE zAti_HexArrayToLong (DWORD *pdwPara, BYTE *pbArray, BYTE bArraySize)
{
    BYTE i = 0;
    DWORD dwTmp = 0;

#ifdef BIG_ENDIAN
    for (i = 0; i < bArraySize; i++)
    {
        *((BYTE *)&dwTmp + i) = pbArray[i];
    }
#else
    for (i = 0; bArraySize > 0; i++, bArraySize--)
    {
        *((BYTE *)&dwTmp + i) = pbArray[bArraySize - 1];
    }
#endif

    *pdwPara = dwTmp;
    return Z_SUCC;
}

VOID zAti_DecArrayToLong(DWORD *pdwPara, BYTE *pbArray, BYTE bArraySize)
{
    BYTE i = 0;
    DWORD dwTmp = 0;

    for (i = 0; i < bArraySize; i++)
    {
        dwTmp *= 10;
        dwTmp += pbArray[i];
    }

    *pdwPara = dwTmp;
}
#endif
/******************************************************
*:zAti_HexToDecimal
*:ֽ16תΪʮ
*˵:0X32תΪʮƵ32
******************************************************/
BYTE zAti_HexToDecimal(BYTE bHexVal)
{
    return (BYTE)((bHexVal>>4)*10 + (bHexVal&0x0f));
}
/*****************************************************
*:zAti_HexToDecimal
*:ʮתΪӦİֽ16
*˵:ʮƵ43תΪ0x43
*****************************************************/
BYTE zAti_DcimalToHex(BYTE bDcimVal)
{
    return (BYTE)(((bDcimVal/10) << 4) | (bDcimVal%10));
}

WORD zAti_GetDataSizeByKeyId(WORD wKeyId)
{
    WORD wDataSize = 0;

    switch (wKeyId)
    {
        case Z_APUICC_KEYID_SST:
            wDataSize = sizeof(T_z_UICC_SST);
            break;

        case Z_APUICC_KEYID_CBMI:
            wDataSize = sizeof(T_z_UICC_CBMI);
            break;

        case Z_APUICC_KEYID_CBMIR:
            wDataSize = sizeof(T_z_UICC_Cbmir);
            break;

        case Z_APUICC_KEYID_SPN:
        case Z_APUICC_KEYID_GSM_SPN:
            wDataSize = sizeof(T_z_UICC_SPN);
            break;

        case Z_APUICC_KEYID_SPDI:
        case Z_APUICC_KEYID_GSM_SPDI:
            wDataSize = sizeof(T_z_UICC_Spdi);
            break;

        case Z_APUICC_KEYID_IMG:
            wDataSize = sizeof(T_zApUicc_Img);
            break;

        case Z_APUICC_KEYID_IMGINST_1:
        case Z_APUICC_KEYID_IMGINST_2:
        case Z_APUICC_KEYID_IMGINST_3:
        case Z_APUICC_KEYID_IMGINST_4:
        case Z_APUICC_KEYID_IMGINST_5:
        case Z_APUICC_KEYID_IMGINST_6:
        case Z_APUICC_KEYID_IMGINST_7:
        case Z_APUICC_KEYID_IMGINST_8:
        case Z_APUICC_KEYID_IMGINST_9:
        case Z_APUICC_KEYID_IMGINST_10:
        case Z_APUICC_KEYID_IMGINST_11:
        case Z_APUICC_KEYID_IMGINST_12:
        case Z_APUICC_KEYID_IMGINST_13:
        case Z_APUICC_KEYID_IMGINST_14:
        case Z_APUICC_KEYID_IMGINST_15:
        case Z_APUICC_KEYID_IMGINST_16:
        case Z_APUICC_KEYID_IMGINST_17:
        case Z_APUICC_KEYID_IMGINST_18:
        case Z_APUICC_KEYID_IMGINST_19:
        case Z_APUICC_KEYID_IMGINST_20:
        case Z_APUICC_KEYID_IMGINST_21:
        case Z_APUICC_KEYID_IMGINST_22:
        case Z_APUICC_KEYID_IMGINST_23:
        case Z_APUICC_KEYID_IMGINST_24:
        case Z_APUICC_KEYID_IMGINST_25:
        case Z_APUICC_KEYID_IMGINST_26:
        case Z_APUICC_KEYID_IMGINST_27:
        case Z_APUICC_KEYID_IMGINST_28:
            wDataSize = sizeof(T_z_UICC_ImgInst);
            break;
            
        case Z_APUICC_KEYID_CFIS:
            wDataSize = sizeof(T_z_UICC_Cfis);
            break;
                
        default:
            break;
    }

    return wDataSize;
}

/***************************************************************************
: zAti_CheckUPlmnInfo
: UPLMN
:
  ֵ:
    Z_SUCC/Z_FAIL
    :
ע    : LHȷϣЧԪؿǰۼ 
***************************************************************************/
BYTE zAti_CheckUPlmnInfo(T_z_UiccId_UPlmnInfo *ptUplmnInfo)
{
    BYTE    bValidMaxNum  = 0;  /* ʵЧ */
    BYTE    i             = 0;
    BYTE    bCounter      = 0;

    if ((ZOSS_NULL == ptUplmnInfo) || 
        (Z_SUCC  == zAti_memCheck((BYTE*)ptUplmnInfo, sizeof(T_z_UiccId_UPlmnInfo), 0xff)) )
    {
        return Z_FAIL;
    }
    
    bValidMaxNum = zAti_GetLittle(ptUplmnInfo->bMaxNum, Z_MaxUiccPlmnNum);

    if (ptUplmnInfo->bNum > bValidMaxNum)
    {
        return Z_FAIL;
    }

    for (i = 0; i < bValidMaxNum; i ++)
    {
        if (Z_VALID == ptUplmnInfo->abPlmnValidFg[i])
        {
            bCounter ++;
        }
    }

    if (ptUplmnInfo->bNum != bCounter)
    {
        return Z_FAIL;
    }

    return Z_SUCC;
}



/***************************************************************************
: zAti_CheckPlmnInfoSel
: UPLMN
:
  ֵ:
    Z_SUCC/Z_FAIL
    :
ע    : LHȷϣЧԪؿǰۼ 
***************************************************************************/
BYTE zAti_CheckPlmnInfoSel(T_z_UiccId_PlmnSel *ptplmnSel)
{
    BYTE    bValidMaxNum  = 0;  /* ʵЧ */
    BYTE    i             = 0;
    BYTE    bCounter      = 0;

    if ((ZOSS_NULL == ptplmnSel) || 
        (Z_SUCC  == zAti_memCheck((BYTE*)ptplmnSel, sizeof(T_z_UiccId_PlmnSel), 0xff)) )
    {
        return Z_FAIL;
    }
    
    bValidMaxNum = zAti_GetLittle(ptplmnSel->bMaxNum, Z_MaxUiccPlmnSelNum);

    if (ptplmnSel->bNum > bValidMaxNum)
    {
        return Z_FAIL;
    }

    for (i = 0; i < bValidMaxNum; i ++)
    {
        if (Z_VALID == ptplmnSel->abPlmnValidFg[i])
        {
            bCounter ++;
        }
    }

    if (ptplmnSel->bNum != bCounter)
    {
        return Z_FAIL;
    }

    return Z_SUCC;
}
/***************************************************************************
: zAti_CheckFplmnInfo
: FPLMN
:
  ֵ:
    Z_SUCC/Z_FAIL
    :
***************************************************************************/
BYTE zAti_CheckFplmnInfo(T_z_UICC_FPlmnList *ptFplmnList)
{
    BYTE    bValidMaxNum  = 0;  /* ʵЧ */

    if ((ZOSS_NULL == ptFplmnList) || 
        (Z_SUCC  == zAti_memCheck((BYTE*)ptFplmnList, sizeof(T_z_UICC_FPlmnList), 0xff)) )
    {
        return Z_FAIL;
    }

    bValidMaxNum = zAti_GetLittle(ptFplmnList->bMaxNum, Z_MaxUiccFPlmnNum);

    if (ptFplmnList->bNum > bValidMaxNum)
    {
        return Z_FAIL;
    }

    return Z_SUCC;
}
/**************************************************************************
* : zAti_ReadItem
* : KEYIDȡļ
* :
*     أZ_FAIL/Z_SUCC
* ע    ͣĿǰȡļ
*     cbmi      ,     cbmir     ,     smsp  ,     smss  ,     ecc   ,     ueinfo (imsi,imei)
*     uplmn     ,     oplmn ,     hplmn ,     uicc State 
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
****************************************************************************/
DWORD __ps_static_func zAti_ReadItem (BYTE bKeyId, BYTE bStartRec, BYTE bEndRec, VOID *pValBuf)
{
    DWORD dwCmdRlt = 0;

    switch (bKeyId)
    {
        case Z_UiccId_ECC_REC:
        case Z_UiccId_SMSS_BIN:
        case Z_UiccId_SMSP_REC:
        case Z_UiccId_IMEI:
        case Z_UiccId_IMEISV:
        case Z_UiccId_IMSI_BIN:
        case Z_UiccId_ACM_CYC:
        case Z_UiccId_ACMMAX_BIN:
        case Z_UiccId_PUCT_BIN:
        case Z_UiccId_LI_BIN:
        case Z_UiccId_PL_BIN:
        case Z_UiccId_USTSST:
        case Z_UiccId_EST_BIN:
        case Z_UiccId_ACL_BIN:
        case Z_UiccId_ICCID_BIN:
        case Z_UiccId_OPL_REC:
        case Z_UiccId_PNN_REC:
            dwCmdRlt = zDev_ReadItem_NoBackup(bKeyId, bStartRec, bEndRec, (PBYTE)pValBuf, g_zAti_CurInstance);
            break;

        case Z_UiccId_UPLMN_BIN:
            dwCmdRlt = zDev_ReadItem_NoBackup(Z_UiccId_UPLMN_BIN, bStartRec, bEndRec, (PBYTE)pValBuf, g_zAti_CurInstance);
            if (dwCmdRlt == Z_APUICC_CMD_OK &&
                Z_FAIL == zAti_CheckUPlmnInfo((T_z_UiccId_UPlmnInfo *)pValBuf))
            {
                return Z_APMMIA_SIMFAILURE_ERR;
            }
            break;
      
        case Z_UiccId_PLMNSEL_BIN:
            dwCmdRlt = zDev_ReadItem_NoBackup(Z_UiccId_PLMNSEL_BIN, bStartRec, bEndRec, (PBYTE)pValBuf, g_zAti_CurInstance);
            if (dwCmdRlt == Z_APUICC_CMD_OK &&
                Z_FAIL == zAti_CheckPlmnInfoSel((T_z_UiccId_PlmnSel *)pValBuf))
            {
                return Z_APMMIA_SIMFAILURE_ERR;
            }
            break;
     
        case Z_UiccId_UICC_STATE:
            dwCmdRlt = zDev_ReadItem_NoBackup(Z_UiccId_UICC_STATE, bStartRec, bEndRec, (PBYTE)pValBuf, g_zAti_CurInstance);
            if (dwCmdRlt == Z_APUICC_CMD_OK)
            {
                switch (*(PBYTE)pValBuf)
                {
                    case Z_Uicc_CardOk:               
                    case Z_Uicc_NoCard:                           
                    case Z_Uicc_StateInvalid:                    
                    case Z_Uicc_StateLogicInvalid:           
                    case Z_Uicc_PinNotVerify:                    
                    case Z_Uicc_CardLocked:
                    case Z_Uicc_WaitDeact:
                        break;
                    default:
                        return Z_APMMIA_SIMFAILURE_ERR;
                }
            }            
            break;
              
        case Z_UiccId_HPLMN_BIN:
        case Z_UiccId_OPLMN_BIN:
            dwCmdRlt = zDev_ReadItem_NoBackup(bKeyId, bStartRec, bEndRec, (PBYTE)pValBuf, g_zAti_CurInstance); 
            if (dwCmdRlt == Z_APUICC_CMD_OK &&
                ((T_z_UiccId_PlmnInfo *)pValBuf)->bNum > Z_MaxUiccPlmnNum)
            {
                    return Z_APMMIA_SIMFAILURE_ERR;
            }           
            break;
        case Z_UiccId_FPLMN_BIN:
            dwCmdRlt = zDev_ReadItem_NoBackup(bKeyId, bStartRec, bEndRec, (PBYTE)pValBuf, g_zAti_CurInstance); 
            if(dwCmdRlt == Z_APUICC_CMD_OK &&
                Z_FAIL == zAti_CheckFplmnInfo((T_z_UICC_FPlmnList*)pValBuf))
            {
                return Z_APMMIA_SIMFAILURE_ERR;
            }
            break;
        default:
            break;
    }

    return dwCmdRlt;
}

VOID zAti_SaveValWhenReadUicc (T_zAti_UiccInfo *ptSaveVal)
{
    zOss_Memcpy(&g_zAti_atDataEx[g_zAti_CurInstance].tUiccInfo, ptSaveVal, sizeof(T_zAti_UiccInfo));
}

/*T_zAti_UiccInfo *zAti_GetValRecReadUiccCnf (VOID)
{
    return &g_zAti_atDataEx[g_zAti_CurInstance].tUiccInfo;
}*/

VOID zAti_UiccUpdateItemReq (VOID *pData, DWORD dwDataSize, BYTE bUiccKeyId, BYTE bSrcIndex, BYTE bDesIndex)
{
    T_zApUicc_UpdateItem_Req *ptUpdateItemReq = (T_zApUicc_UpdateItem_Req *)zAti_GetUB(sizeof(T_zApUicc_UpdateItem_Req));

    ptUpdateItemReq->bSrcIndex = bSrcIndex;
    ptUpdateItemReq->bDesIndex = bDesIndex;
    ptUpdateItemReq->bUiccIdNum = 1;
    ptUpdateItemReq->tItemData[0].bUiccKeyId = bUiccKeyId;
    ptUpdateItemReq->tItemData[0].bRecNum = 1;
    ptUpdateItemReq->tItemData[0].pData = (PBYTE)zAti_GetUB(dwDataSize);
    zOss_Memcpy(ptUpdateItemReq->tItemData[0].pData, pData, dwDataSize);

    zAti_MsgSend(AP_UICC_UPDATE_ITEM_REQ_EV,  (PBYTE)ptUpdateItemReq, sizeof(T_zApUicc_UpdateItem_Req), Z_ATI_TASKID_UICC);
}

VOID zAti_UiccUpdateItemAndSaveInfo (VOID *pData, DWORD dwDataSize, BYTE bUiccKeyId, BYTE bReadKey, BYTE bSrcIndex, BYTE bDesIndex)
{
    T_zAti_UiccInfo tSaveVal = {0};
    zAti_UiccUpdateItemReq(pData, dwDataSize, bUiccKeyId, bSrcIndex, bDesIndex);

    tSaveVal.bSrcIndex = bSrcIndex;
    tSaveVal.bDesIndex = bDesIndex;
    tSaveVal.bReadKey = bReadKey;
    zAti_SaveValWhenReadUicc(&tSaveVal);    
}

/*жϵǰǷΪ˫LTE*/
BOOL zAti_IsDualPsOneCardNonGsm(BYTE bInsNo)
{
    if(zAti_IsSingleCardForTwoStandby() && zAti_IsLteStandBy(bInsNo))
    {
        return TRUE;
    }
    return FALSE;
}

BYTE __ps_static_func zAti_GetAutoStartState (VOID)
{
    return g_zAti_atDataEx[g_zAti_CurInstance].bAutoStartFlg;
}

/*********************************************************************
*:    zAti_IsEWalkUiccInit
*:    жϵǰĿʼǷE
*:    UICC͸ATIĿʼӦϢеĿ
*˵:    Eпʼʹ251252Ϊ
*                                 ֵ
**********************************************************************/
BOOL __ps_static_func zAti_IsEWalkUiccInit(BYTE bDesIndex)
{
    return (bDesIndex == ZATI2_CHANNEL_ID_NUM251 || bDesIndex == ZATI2_CHANNEL_ID_NUM252);
}
#ifdef Z_DUALCARD_ADAPT
/**********************************************************************
*:zAti_IsCardSelfAdaptCnf
*:жǷΪӦģʽϢ
*˵:жǷΪͨ
**********************************************************************/
BOOL __ps_static_func zAti_IsCardSelfAdaptCnf(BYTE bDesIndex)
{
    return (bDesIndex == ZATI2_CHANNEL_ID_NUM251 || bDesIndex == ZATI2_CHANNEL_ID_NUM252);
}
#endif
BYTE zAti_GetAnothAutoStartState(VOID)
{
    BYTE bInNo = (g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_2: Z_ATI_INSNO_1;
    return g_zAti_atDataEx[bInNo].bAutoStartFlg;
}

VOID zAti_SetAutoStartState (BYTE bAutoStartState)
{
    g_zAti_atDataEx[g_zAti_CurInstance].bAutoStartFlg = bAutoStartState;
}

#ifdef CXT_MOV
VOID __ps_static_func zAti_SetPsMovStat(BYTE bPsMovStat)
{
    g_zAti_ptData->tPsMovInfo.bPsMovStatus = bPsMovStat;
    return;
}

VOID __ps_static_func zAti_SetChnlWhenUserDisConn(UINT8 iChnelId )
{
    BYTE i = 0;

    for(i = 0; i<Z_MMIASM_MAX_CID_NUM; i++)
    {
        if(iChnelId == g_zAti_ptData->tPsMovInfo.abDisConnChnl[i])
        {
            return;
        }
    }

    for(i = 0; i<Z_MMIASM_MAX_CID_NUM; i++)
    {
        if(0 == g_zAti_ptData->tPsMovInfo.abDisConnChnl[i])
        {
            g_zAti_ptData->tPsMovInfo.abDisConnChnl[i] = iChnelId;
            return;
        }
    }
    return;
}

VOID zAti_ClearPsMovStat()
{
    if(Z_ATI_PS_MOVE_INSERT_USER_DISCONNECT == zAti_GetPsMovStat())
    {
        g_zAti_ptData->tPsMovInfo.bPsMovStatus = Z_ATI_PS_MOVE_ORIGIN;
        zAti_SendUserDisConnect();
    }
    zOss_Memset(&g_zAti_ptData->tPsMovInfo, 0, sizeof(T_zAti_PsMovInfo));
}

BYTE __ps_static_func zAti_GetPsMovStat()
{
    return g_zAti_ptData->tPsMovInfo.bPsMovStatus;
}
/********************************************************
:zAti_SendUserDisConnect
:ûҶ
*********************************************************/
VOID zAti_SendUserDisConnect()
{
    BYTE i = 0;

    for(i = 0; i < Z_MMIASM_MAX_CID_NUM; i++)
    {
        if(g_zAti_ptData->tPsMovInfo.abDisConnChnl[i] != 0)
        {
            zAti_UsbSioDeactiveByAtiReq(g_zAti_ptData->tPsMovInfo.abDisConnChnl[i]);
        }
    }
}
/********************************************************
:zAti_HandStoredCmdInPsmov
:Ǩл
*********************************************************/
VOID zAti_HandStoredCmdInPsmov()
{
    T_ZAti_ChannelInfo *pChnelNode = g_zAti_ptData->tAtChnelList.pChnelNode;
    BYTE bTempInsNo = g_zAti_CurInstance;
    while(pChnelNode != NULL)
    {
        if(pChnelNode->IsCmdStored)
        {
            pChnelNode->IsCmdStored = FALSE;
            g_zAti_CurInstance = zAti_GetTaskInstantByChnlId(pChnelNode->iChnelId);
            
            zAti_DecMultiCmd(pChnelNode);
        }
        pChnelNode = pChnelNode->pNextCnNode;
    }
    g_zAti_CurInstance = bTempInsNo;
}
#endif

DWORD zAti_CopyStrFromUiccVal (VOID *pNewVal, WORD wKeyId, T_zApUicc_Read_Cnf *ptUiccReadCnf)
{
    WORD wDataSize = 0;

    if (ptUiccReadCnf->dwExecuteStatus != Z_APUICC_CMD_OK)
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");                       
        return ptUiccReadCnf->dwExecuteStatus;
    }

    wDataSize = zAti_GetDataSizeByKeyId(wKeyId);
    if (!wDataSize ||wDataSize > Z_APUICC_MAX_DATA_VAL)
    {    
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");                       
        return Z_APMMIA_NVFAILURE_ERR;
    }

    zOss_Memcpy((PBYTE)pNewVal, (PBYTE)ptUiccReadCnf->abVal, wDataSize);
    return Z_APMMIA_NOERROR_ERR;
}

DWORD zAti_UiccReadReq (BYTE bUiccKeyId, BYTE bRecNum, BYTE bSrcIndex, BYTE bDstIndex)
{
    BYTE bApplMode = 0;
    T_zApUicc_Read_Req *ptUiccReadReq = ZOSS_NULL;

    bApplMode = zDev_UiccGetCardAppType(g_zAti_CurInstance);
    if (!bApplMode)
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");                       
        return Z_APMMIA_NVFAILURE_ERR;
    }

    ptUiccReadReq = (T_zApUicc_Read_Req *)zAti_GetUB(sizeof(T_zApUicc_Read_Req));
    ptUiccReadReq->bSrcIndex = bSrcIndex;
    ptUiccReadReq->bDesIndex = bDstIndex;
    ptUiccReadReq->bApplMode = bApplMode;
    ptUiccReadReq->bRecId = bRecNum;
    ptUiccReadReq->wKeyId = bUiccKeyId;
    
    zAti_MsgSend(AP_UICC_READ_REQ_EV, (PBYTE)ptUiccReadReq, sizeof(T_zApUicc_Read_Req), Z_ATI_TASKID_UICC);
    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_GETCMSERR
: UICCصĴӳ䵽
          curr=totalOK, FAIL
    : 
    
    أZ_APMMIA_OPERATION_SUCCESSZ_APMMIA_OPERATION_FAILURE
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_GETCMSERR(DWORD dwErrCod)
{
    switch(dwErrCod) 
    {
        case Z_APUICC_NO_CARD:
            return Z_APMMIA_CMSUSIMNOTINSERT_ERR;
        case Z_APUICC_NEED_PIN:
            return Z_APMMIA_CMSUSIMPINREQ_ERR;
        case Z_APUICC_NEED_UNBLPIN:
            return Z_APMMIA_CMSUSIMPUKREQ_ERR;
        case Z_APUICC_CARD_FAILED:
            return Z_APMMIA_CMSUSIMFAIL_ERR;
        case Z_APUICC_CARD_BUSY:
            return Z_APMMIA_CMSUSIMBUSY_ERR;
        case Z_APUICC_CARD_WRONG:
            return Z_APMMIA_CMSUSIMWRONG_ERR;
        case Z_APUICC_PIN_INCORRECT:  /* 27005 ޶Ӧ */
            return  dwErrCod;
        case Z_APUICC_NEED_PIN2:
            return Z_APMMIA_CMSUSIMPIN2REQ_ERR;
        case Z_APUICC_NEED_UNBLPIN2:
            return Z_APMMIA_CMSUSIMPUK2REQ_ERR;
        default:
            return  dwErrCod;
    }
}

DWORD zAti_UiccUpdateReq (VOID *pData, BYTE bUiccKeyId, BYTE bSrcIndex, BYTE bDstIndex)
{
    BYTE bApplMode = 0;
    WORD wDataSize = 0;
    T_zApUicc_Update_Req *ptUpdateReq = ZOSS_NULL;

    wDataSize = zAti_GetDataSizeByKeyId(bUiccKeyId);
    if (!wDataSize || wDataSize > Z_APUICC_MAX_DATA_VAL)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");   
        return Z_APMMIA_NVFAILURE_ERR;
    }

    bApplMode = zDev_UiccGetCardAppType(g_zAti_CurInstance);
    if (!bApplMode)
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");                               
        return Z_APMMIA_NVFAILURE_ERR;
    }

    ptUpdateReq = (T_zApUicc_Update_Req *)zAti_GetUB(sizeof(T_zApUicc_Update_Req));

    ptUpdateReq->bSrcIndex = bSrcIndex;
    ptUpdateReq->bDesIndex = bDstIndex;
    ptUpdateReq->bApplMode = bApplMode;
    ptUpdateReq->bRecId = 1;
    ptUpdateReq->wKeyId = bUiccKeyId;
    ptUpdateReq->wValLen = wDataSize;
    zOss_Memcpy(ptUpdateReq->abVal, pData, wDataSize);

    zAti_MsgSend(AP_UICC_UPDATE_REQ_EV, (PBYTE)ptUpdateReq, sizeof(T_zApUicc_Update_Req), Z_ATI_TASKID_UICC);
    return Z_APMMIA_NORESULT;
}

VOID __ps_static_func zAti_UiccInfoInit(BYTE bInstance)
{
    zOss_Memset(&g_zAti_atDataEx[bInstance].tUiccInfo, 0, sizeof(T_zAti_UiccInfo));
    g_zAti_atDataEx[bInstance].tUiccInfo.bReadKey = Z_ATI_INVALID_BYTE;
}

/***************************************************************************
: zAti_CheckParam
: 
:
BYTE bParam     Ƚϵı
BYTE bUpVal     ȡֵ
BYTE bAnotherVal ȡֵ֮һЧֵ0xff
  ֵ:
    :
ע    : bAnotherVal==0ʱΪbAnotherValЧֵ
***************************************************************************/
BYTE __ps_static_func zAti_CheckParam(BYTE bParam,BYTE bUpVal,BYTE bAnotherVal)
{
    if(bAnotherVal == 0)
    {
        if(bParam > bUpVal)
        {
            return Z_FAIL;
        }
    }
    else
    {
        if(bParam > bUpVal && bParam != bAnotherVal)
        {
            return Z_FAIL;
        }
    }
  
    return Z_SUCC;
}

BYTE __ps_static_func zAti_SelectEffectiveSubact(BYTE bGsmSubact, BYTE bTdSubact, BYTE bWsubact,BYTE bLteSubact)
{
    if (bLteSubact != Z_ATI_INVALID_BYTE)
    {
        return bLteSubact;
    }
    if (bTdSubact != Z_ATI_INVALID_BYTE)
    {
        return bTdSubact;
    }
    if (bWsubact != Z_ATI_INVALID_BYTE)
    {
        return bWsubact;
    }
    if (bGsmSubact != Z_ATI_INVALID_BYTE)
    {
        return bGsmSubact;
    }
    return Z_ATI_INVALID_BYTE;
}
/********************************************
*:zAti_AdaptSubMode
*:ʽת
*616000237711ʶH+ʾ֧
********************************************/
BYTE zAti_AdaptSubMode(BYTE bSelAct)
{
    switch(bSelAct)
    {
        case Z_APMMIA_COPSACT_UTRAN_HSDPA:
            return Z_SUBMODE_HSDPA;
        case Z_APMMIA_COPSACT_UTRAN_HSUPA:
            return Z_SUBMODE_HSUPA;
        case Z_APMMIA_COPSACT_UTRAN_HSDPA_HSUPA:
            return Z_SUBMODE_DPA_UPA;
        case Z_APMMIA_COPSACT_UTRAN_HSPA_PLUS:
            return Z_SUBMODE_HSPA_PLUS;
        default:
            break;
    }
    return 0xff;
}

VOID zAti_ConvertByte2ActStruct(BYTE bAct, BYTE bSubActFg, BYTE bSubAct,T_z_PlmnAct *ptPlmnAct)
{
    switch(bAct)
    {
        case Z_APMMIA_COPSACT_GSM:
        case Z_APMMIA_COPSACT_GSM_EGPRS:
            ptPlmnAct->tAct.bGsm = Z_VALID;
            if (bAct == Z_APMMIA_COPSACT_GSM)
            {
                ptPlmnAct->bGsmSubAct = Z_SUBMODE_GSM;
            }
            else
            {
                ptPlmnAct->bGsmSubAct = Z_SUBMODE_EDGE;
            }
            break;

        case Z_APMMIA_COPSACT_GSMCOMPACT:
            ptPlmnAct->tAct.bGsmCompact = Z_VALID;
            break;

        case Z_APMMIA_COPSACT_UTRAN:
        case Z_APMMIA_COPSACT_UTRAN_HSDPA:
        case Z_APMMIA_COPSACT_UTRAN_HSUPA:
        case Z_APMMIA_COPSACT_UTRAN_HSDPA_HSUPA:
        case Z_APMMIA_COPSACT_UTRAN_HSPA_PLUS:
            if (!bSubActFg)//12.10.24Wʽ
            {
                bSubAct = TDD_SUBACT;
            }
            if (bAct == Z_APMMIA_COPSACT_UTRAN)
            {
                if (bSubAct == TDD_SUBACT)
                {
                    ptPlmnAct->tAct.bTD = Z_VALID;            
                    ptPlmnAct->bTdSubAct = Z_SUBMODE_TD;            
                }
                else
                {
                    ptPlmnAct->tAct.bW = Z_VALID;
                    ptPlmnAct->bWSubAct = Z_SUBMODE_WCDMA;            
                }
            }
            else
            {
                if (bSubAct == TDD_SUBACT)
                {
                    ptPlmnAct->tAct.bTD = Z_VALID;            
                    ptPlmnAct->bTdSubAct = zAti_AdaptSubMode(bAct);
                }
                else
                {
                    ptPlmnAct->tAct.bW = Z_VALID;
                    ptPlmnAct->bWSubAct = zAti_AdaptSubMode(bAct);
                }
            }
            break;

        case Z_APMMIA_COPSACT_E_UTRAN:
            ptPlmnAct->tAct.bLte = Z_VALID;
            if (bSubActFg)//12.10.24LTEʽ
            {
                if (bSubAct == TDD_SUBACT)
                {
                    ptPlmnAct->bLteSubAct = Z_SUBMODE_LTE_TDD;            
                }
                else
                {
                    ptPlmnAct->bLteSubAct = Z_SUBMODE_LTE_FDD;            
                }
            }
            else//12.19LTEʽʱZ_SUBMODE_LTEUMM
            {
                ptPlmnAct->bLteSubAct = Z_SUBMODE_LTE;            
            }
            break;

        default:
            break;
    }
}

VOID __ps_static_func zAti_SendMsgTrace(BYTE bDirect, UINT8 iChannel, UINT16 iDataLen, CHAR *ptStrData)
{
#ifdef _USE_SIG_TRACE 
    if (!zCatAgt_IsPsOrigTraced())
    {
        return;
    }
    {
        T_z_MsgInfo tMsgInfo = {0};
        T_zAtInfo tAtInfo = {0};
        UINT16 wAtInfoLen = ((iDataLen > 255) ? 255 :iDataLen); 
        tAtInfo.bChNum = iChannel;
        //if (iDataLen > 255)
        //{
        //    zOss_Memcpy(tAtInfo.bAtInfo, ptStrData, 255);
        //}
        //else
        //{
        zOss_Memcpy(tAtInfo.bAtInfo, ptStrData, wAtInfoLen);
        //}
 
        tMsgInfo.bStackIndex = (BYTE)(iChannel <= Z_ATI_INSTANCE_ONE_CHNL_MAX ? Z_ATI_INSNO_1+1: Z_ATI_INSNO_2+1);
        tMsgInfo.wMsgLen = sizeof(T_zAtInfo);
        tMsgInfo.pMsg = (PBYTE)&tAtInfo;
        if(bDirect == Z_SIGTRACE_RECV)
        {
            tMsgInfo.tSrcTask = 0;
            tMsgInfo.tDestTask = zDev_GetTaskId(Z_ATI_TASKID_ATI, 0);
            tMsgInfo.bSrcMod = 0;
            tMsgInfo.bDestMod = SUBMDL_Z_ATI;
            tMsgInfo.dwMsgId = AT_INFO_RECEIVED_EV; 
        }
        else
        {
            tMsgInfo.tSrcTask = zDev_GetTaskId(Z_ATI_TASKID_ATI, 0);
            tMsgInfo.tDestTask = 0;
            tMsgInfo.bSrcMod = SUBMDL_Z_ATI;
            tMsgInfo.bDestMod = 0;
            tMsgInfo.dwMsgId = AT_INFO_SENT_EV;  
        }
 
        zMsgTrace (bDirect,&tMsgInfo);
    }
#endif
}

/* 617001559992  TDD-LTE/TDSڡTMTߡЭջLOGдӡػšȥšAT */
VOID __ps_static_func zAti_SendRecvCmdStr2Trace (UINT8 iChannel, UINT16 iDataLen, CHAR *ptStrData)
{
    zAti_SendMsgTrace(Z_SIGTRACE_RECV, iChannel, iDataLen, ptStrData);
}

/* 617001559992  TDD-LTE/TDSڡTMTߡЭջLOGдӡػšȥšAT */
VOID __ps_static_func zAti_SendRspCmdStr2Trace (UINT8 iChannel, UINT16 iDataLen, CHAR *ptStrData)
{
    zAti_SendMsgTrace(Z_SIGTRACE_SEND, iChannel, iDataLen, ptStrData);
}

// ǷϱϱϢ
BOOL __ps_static_func zAti_IsPureDeliverMsg(UINT32 iEvId)
{
    switch(iEvId)
    {
    /* CC   */
    case AP_MMIA_CC_PROC_INFO_IND_EV:
    case AP_MMIA_COLP_IND_EV: /* Ϊ */
    case AP_MMIA_CR_IND_EV:
    case AP_MMIA_MT_CALL_SS_NOTIFY_IND_EV:
    case AP_MMIA_CLIP_IND_EV:
    case AP_MMIA_RING_IND_EV:
    case AP_MMIA_CRING_IND_EV:
    case AP_MMIA_CCWA_IND_EV:
    case AP_MMIA_MO_CALL_SS_NOTIFY_IND_EV:
    case AP_MMIA_CONN_IND_EV:
    case AP_MMIA_ORIG_IND_EV:
    case AP_MMIA_CONF_IND_EV:    /* 617002487424 © CONFϱ --hyc-- */
    case AP_MMIA_CEND_IND_EV:
    case MMIA_CC_CALL_STATE_IND_EV:
    case AP_MMIA_REDIALEND_IND_EV:
    /* PDP   */
    case MMIA_SM_PDP_ACTIVATE_IND_EV:
    case MMIA_ESM_MT_EPS_BEARER_ACT_IND_EV:
    case EV_ZATI2_SM_ZGIPDNS_IND:
    case MMIA_SM_CGEV_IND_EV:
    /* SMS MT(յϢ)  */
    case AP_MMIA_SMS_STORE_REC_IND_EV:
    case AP_MMIA_SMS_TCMT_IND_EV:
    case AP_MMIA_SMS_TCDS_IND_EV:
    case AP_MMIA_SMS_PCMTIND_EV:
    case AP_MMIA_SMS_ZCMTIND_EV:
    case AP_MMIA_SMS_PCDSIND_EV:
    case AP_MMIA_CBS_PCBM_IND_EV:
    case AP_MMIA_CBS_TCBM_IND_EV:
    case AP_MMIA_SMS_SAVE_FAILURE_IND_EV:
    case AP_MMIA_CCCM_IND_EV:
    case MMIA_CC_CCWV_IND_EV:
    case AP_UICC_SLOT_IND_EV:
    case MMIA_UMM_CS_SRV_IND_Ev:
    case MMIA_UMM_SRVCC_IND_EV:
    case MMIA_SM_NOTIFICATION_IND_EV:
    case AP_MMIA_IMSVOPS_IND_EV:
#ifdef Z_DUALSTANDBY
    case MMIA_UMM_NOTIFY_PS_STATE_EV:
#endif
    case AP_MMIA_ICCID_IND_EV:
#ifdef NAS_ISIM_SUPPORT
    case AP_MMIA_ZISIMINIT_IND_EV:
#endif
    case AP_MMIA_ZPBIC_IND_EV:
    case MMIA_EUSIR_ETWS_PRIMARY_IND_EV:
    case MMIA_EUSIR_ETWS_SECONDARY_IND_EV:
    case AP_MMIA_ZETWS_PRIMARY_IND_EV:
    case EV_ZATI2_LTE_ZCONSTAT_IND:
    case EV_ZATI2_ZMSRI_IND:
    case MMIA_CC_MODE_TO_MULTMEDIAIND_EV:
    case AP_MMIA_EMERNUM_IND_EV:
    case AP_MMIA_EMERBER_IND_EV:
    case MMIA_AS_TMGI_LIST_IND_EV:
    case MMIA_AS_SAI_LIST_IND_EV:
    case MMIA_AS_MBMS_SERVICE_SUSPEND_IND_EV:
    case MMIA_AS_MBMS_SERVICE_RESUME_IND_EV:
    case AP_UICC_REFRESH_HAPPEN_IND_EV:
    case AP_MMIA_PSCFGSTART_IND_EV:
    case AP_MMIA_PSCFGEND_IND_EV:
    case AP_MMIA_USER_CARD_SEL_IND_EV:
    case MMIA_UMM_IMSNOTSUPPORT_IND_EV:
    case MMIA_UMM_MM_INFO_IND_EV:
    case AP_MMIA_TIMEZONE_IND_EV:
    case MMIA_ASC_LTE_LOSTCOVERAGE_IND_EV:
    case AP_UICC_AIR_AUTH_REQ_IND_EV:
    case MMIA_CC_STOP_LOCALVOICE_IND_EV:
    case MMIA_CC_START_LOCALVOICE_IND_EV:
    /* USAT  */
    case AP_UICC_USAT_PROV_CMD_IND_EV:
    case AP_UICC_NO_PROC_NOTIFY_IND_EV:
    case AP_UICC_USAT_FETCH_IND_EV:
    case AP_MMIA_ZULRTIND_IND_EV:
#ifdef _USE_LPP_ECID
    case MMIA_SS_MOLR_RES_IND_EV:
    case MMIA_SS_MTLOCIREQ_NOTIFY_IND_EV:
#endif
#ifdef DSDS_VSIM
    case MMIA_UMM_CARDSWITCH_REQ_IND_EV:
#endif

    /*LTE GoTa */
#ifdef BTRUNK_SUPPORT
    case ATI_TSM_FLOORGRT_IND_EV:
    case ATI_TSM_FLOORRLS_IND_EV:
    case ATI_TSM_FLOORREJ_IND_EV:
    case ATI_TSM_FLOORWAIT_IND_EV:
    case ATI_TSM_FLOORINFORM_IND_EV:
    case ATI_TSM_STUNINFO_IND_EV:
    case ATI_TSM_GROUPINFO_UPDATE_IND_EV:
    case ATI_TSM_GROUPCALL_IND_EV:
    case ATI_TSM_SCANGROUPINFO_IND_EV:
    case ATI_TSM_SHORT_DATA_IND_EV:
    case ATI_TSM_LOCATINFO_TYPE_IND_EV:
    case ATI_TSM_FALLBACK_IND_EV:
    case ATI_TSM_REGSTATE_IND_EV:
    case ATI_TSM_CALL_IND_EV:
    case ATI_TSM_CALLPROCEED_IND_EV:
    case ATI_TSM_CALLALERTING_IND_EV:
    case ATI_TSM_CALLCONNECTACK_IND_EV:
    case ATI_TSM_CALLRLS_IND_EV:
    case ATI_TSM_SPEAKINGTIMEROUT_IND_EV:
    case ATI_TSM_VIDEOSOURCE_IND_EV:
    case ATI_TSM_SRSTATUS_IND_EV:
    case ATI_EUCSR_HIGHT_CALL_IND_EV:
    case ATI_TSM_CALLHOLD_IND_EV:
    case ATI_TSM_PTTBEAR_IND_EV:
    case ATI_TSM_BUSY_ALERTING_IND_EV:
    case ATI_EUCSR_BUSY_ALERTING_IND_EV:
    case ATI_TSM_CALLFORWARD_IND_EV:
    case ATI_TSM_CALLMODIFY_REQ_EV:
    case ATI_TSM_CALLMODIFY_ACK_EV:
    case ATI_TSM_REG_CNF_EV:
    case ATI_TSM_CALL_CNF_EV:
    case ATI_TSM_CALLRLS_CNF_EV:
    case ATI_TSM_FLOORRLS_CNF_EV:
    case ATI_TSM_STUNINFO_QUERY_CNF_EV:
    case ATI_TSM_GROUPINFO_QUERY_CNF_EV:
    case ATI_TSM_SHAKEHAND_CNF_EV:
    case ATI_TSM_SCANGROUPINFO_CNF_EV:
    case PTT_MMIA_ESM_TAUTYPE_CNF_EV:
    case AS_EM_CELL_INFO_IND_EV:
#ifdef _R2_SUPPORT
    case ATI_TSM_REGEXTINFO_IND_EV:
#endif
    case AP_MMIA_MODE_IND_EV:    /*LTE GoTaģ MODEָҲ޸ΪҲϱ --hzq-- */
    #ifdef PS_RAT_LTE
    /*LTE */
    case AP_MMIA_CEREG_IND_EV:   /* LTE GoTaģCEREGָҲ޸ΪҲϱ --hzq-- */
    #endif
#endif

        return TRUE;

    default:
        return FALSE;
    }    
}


// ϱϱϢ
BOOL __ps_static_func zAti_IsDeliverMsgByPower(UINT32 iEvId)
{
    switch(iEvId)
    {
    /* MM   */
    case AP_MMIA_CREG_IND_EV:
    case AP_MMIA_CGREG_IND_EV:
    case EV_ZAT2_AUTOSTART_IND:
    case AP_MMIA_ZRPT_RXLEVIND_EV:
    /* PDP   */
#ifndef BTRUNK_SUPPORT
    case AP_MMIA_MODE_IND_EV:    /*LTE GoTaģ MODEָҲ޸ΪҲϱ --hzq-- */
#endif
    /* SS  */
    case MMIA_SS_CUSD_MT_IND_EV:
    /* EM    */
    case MMIA_AS_EM_UCELL_INFO_IND_EV:
    case RR_EM_CELL_INFO_IND:
    case MMIA_AS_EM_EUCELL_INFO_IND_EV:
    case AP_MMIA_EM_HO_INFO_IND_EV:
#ifndef BTRUNK_SUPPORT
    case AS_EM_CELL_INFO_IND_EV:
#endif
    case MMIA_AS_EM_LTE_HO_INFO_IND_EV:
    /* COM  */
    case AP_UICC_INIT_IND_EV:
    case AP_MMIA_UICC_OKIND_EV:
    case AP_UICC_ATR_IND_EV:
    /* PB  */
    case AP_MMIA_PB_CHG_INDEX_IND_EV:
#ifdef PS_RAT_LTE
    /*LTE */
    #ifndef BTRUNK_SUPPORT
    case AP_MMIA_CEREG_IND_EV:            /* LTE GoTaģCEREGָҲ޸ΪҲϱ --hzq-- */
    #endif
    case MMIA_EUCSR_LTEINFO_IND_EV: 
#endif
#ifdef R9_SUPPORT
    /*R9*/
    case MMIA_CC_CNAP_IND_EV:
#endif
#ifdef R8_SUPPORT
    case MMIA_SM_CPSB_IND_EV:
#endif
        return TRUE;

    default:
        return FALSE;
    }

}
/*Ҫϱ*/
BOOL __ps_static_func zAti_IsBlackScreenReportMsg(UINT32 iEvId)
{
    return (g_zAti_ptData->bPowerIndFlag && zAti_IsDeliverMsgByPower(iEvId) && (zAti_GetAlwaysReportChnel((BYTE)(g_zAti_CurInstance+1)) != 0XFF));
}

/**************************************************************************
* ƣ zAti_IsDeliverAllMsg
*  ͨϢIDжǷΪ֪ͨϢԷȺͨ
* ˵ (IN) 
*            iEvId         ϢID
*            (OUT)
*   ֵ ɹTRUEʧܷFALSE
* ˵ һӦһͨ
*617001747084 ZUFCH 
**************************************************************************/
BOOL __ps_static_func zAti_IsDeliverAllMsg(UINT32 iEvId)
{
    /* 617001591411 ܻ- ܻV3汾ͬʵ*/

    return zAti_IsPureDeliverMsg(iEvId) || (!g_zAti_ptData->bPowerIndFlag && zAti_IsDeliverMsgByPower(iEvId)) ||zAti_IsBlackScreenReportMsg(iEvId);
}
/************************************************************************************
*:zAti_IsIndiCateCnfMsg
*:жǷΪҪϱ̵ӦϢ
*˵:һ첽
************************************************************************************/
BOOL __ps_static_func zAti_IsIndiCateCnfMsg(UINT32 iEvId, UINT8 *pDataPtr)
{
    /*AT+ZECPG=25,1,xʱ첽ʽ,ȻظOK,
         ȡϺٻظѯ*/
    if(iEvId == MMIA_L1E_ZEPCG_CNF)
    {
        T_zMmiaL1E_Zepcg_Cnf *pZepcgCnf = (T_zMmiaL1E_Zepcg_Cnf*)pDataPtr;

        if(Z_ZEPCG_IND_CMD == pZepcgCnf->bCmd && pZepcgCnf->bMode == AP_MMIA_ZEPCG_QRY)
        {
            return TRUE;
        }
    }
    if (iEvId == MMIA_AS_LBS_CNF_EV || (iEvId == MMIA_CC_DISC_CNF_EV))
    {
        return TRUE;
    }
    return FALSE;
}

BOOL __ps_static_func zAti_IsNeedAutoSearchPlmn(T_zAti_NV_CopsMode *ptNvCopsMode)
{  /*ֶ֧NVбǰһεΪֶ*/
    if((1 == zDev_GetManualSearchFg()||2 == zDev_GetManualSearchFg()) 
        && (Z_APMMIA_COPSMODE_MANU == ptNvCopsMode->bCopsMode
        ||Z_APMMIA_COPSMODE_NANUAUTO == ptNvCopsMode->bCopsMode))
    {
        return FALSE;
    }
    return TRUE;
}

BOOL zAti_IsNeedAutoManuSearchPlmn(T_zAti_NV_CopsMode *ptNvCopsMode)
{
    if(2 == zDev_GetManualSearchFg()
        && (Z_APMMIA_COPSMODE_MANU == ptNvCopsMode->bCopsMode
        ||Z_APMMIA_COPSMODE_NANUAUTO == ptNvCopsMode->bCopsMode))
    {
        return TRUE;
    }
    return FALSE;
}

/**************************************************************************
:zAti_IsWithOutIndexDelivInd(UINT32 iEvId)
:ͨϢIDжǷΪûֵϱϢ
**************************************************************************/
BOOL __ps_static_func zAti_IsWithOutIndexDelivInd(UINT32 iEvId, UINT8 *pDataPtr)
{
    if (iEvId == MMIA_EUCSR_LTEINFO_IND_EV
        ||iEvId == MMIA_AS_EM_UCELL_INFO_IND_EV
        ||iEvId == RR_EM_CELL_INFO_IND
        ||iEvId == MMIA_AS_EM_EUCELL_INFO_IND_EV
        ||iEvId == AS_EM_CELL_INFO_IND_EV
        ||iEvId == MMIA_AS_SAI_LIST_IND_EV
        ||iEvId == MMIA_AS_TMGI_LIST_IND_EV
        ||iEvId == MMIA_AS_MBMS_SERVICE_SUSPEND_IND_EV
        ||iEvId == MMIA_AS_MBMS_SERVICE_RESUME_IND_EV
        ||iEvId == AP_UICC_REFRESH_HAPPEN_IND_EV)
    {
        return TRUE;
    }
    else if(iEvId == MMIA_L1E_ZEPCG_CNF)
    {
        T_zMmiaL1E_Zepcg_Cnf *pZepcgCnf = (T_zMmiaL1E_Zepcg_Cnf*)pDataPtr;

        if(Z_ZEPCG_IND_CMD == pZepcgCnf->bCmd && pZepcgCnf->bMode == AP_MMIA_ZEPCG_QRY)
        {
            return TRUE;
        }
    }

    return FALSE;
}

/************************************************************************
:zAti_IsGetGlobalVarMsg
:ͨϢIDжǷΪȡȫֱϢ
************************************************************************/
BOOL __ps_static_func zAti_IsGetGlobalVarMsg(UINT32 iEvId)
{
    switch(iEvId)
    {
        case GVAR_MMIA_GET_REQ_EV:
        case GVAR_ATMEM_DEV_GET_REQ_EV:
        case GVAR_NV_DEV_GET_REQ_EV:
            return TRUE;
        default:
            return FALSE;
    }
}

/**************************************************************************
:zAti_IsOtherStackHaveIdleChannel
:жϰǨĿĲĿͨǷ
**************************************************************************/
BYTE zAti_IsDestStackChannelValid(BYTE bDestInsNo)
{
    T_ZAti_ChannelInfo    *pChnelNode = NULL;
    BYTE    iCidNum = 0;
    BYTE    bChannelId = 0;

    for(iCidNum = 0; iCidNum < ZATI2_SM_MAX_SMCID_NUM; iCidNum++)
    {
        if(g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[iCidNum].isNdis
            ||g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[iCidNum].isPpp)
        {
            if(bDestInsNo == Z_ATI_INSNO_1)
            {
                bChannelId = g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[iCidNum].chnelId - Z_ATI_INSTANCE_ONE_CHNL_MAX;
            }
            else
            {
                bChannelId = g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[iCidNum].chnelId + Z_ATI_INSTANCE_ONE_CHNL_MAX;
            }

            pChnelNode = zAti_GetChannelNodePtr(bChannelId);
 
            if(pChnelNode == NULL||pChnelNode->server_mode != ZATI2_CHANNEL_MODE_CMD
                ||(ZAT2_NO_COMMAND != pChnelNode->cmd_id && ZAT2_CO_INVALID != pChnelNode->cmd_op))
            {
                return Z_INVALID;
            }
        }
    }
    return Z_VALID;
}

/*****************************************************************************
:zAti_IsEccNumValid
:жϽǷҪϱ
1)ǰIDڻûн
*****************************************************************************/
BOOL zAti_IsEccNumValid(T_zPS_PlmnId* ptPlmnAct)
{
    if(Z_SUCC == zAti_memCheck((BYTE*)ptPlmnAct, sizeof(T_z_PlmnId), 0xff))
    {
        return FALSE;/*PLMNIDΪȫF*/
    }

    return TRUE;
}
#ifdef Z_DUALCARD_ADAPT
/********************************************************
*:zAti_IsCcStateFillChangeCfgCondition
*:жϵǰCCҵ
*ж:CCûҵATIûδATD
*********************************************************/
BOOL zAti_IsCcStateFillChangeCfgCondition(VOID)
{
    if(Z_INVALID == zAti_GetCallState(Z_ATI_INSNO_1)
      && Z_INVALID == zAti_GetCallState(Z_ATI_INSNO_2)
      && 0 == g_zAti_atDataEx[Z_ATI_INSNO_1].bAtdIndex
      && 0 == g_zAti_atDataEx[Z_ATI_INSNO_2].bAtdIndex)
    {
        return TRUE;
    }

    return FALSE;
}

/*************************************************************
*:zAti_IsCardStateFillChangeCfgCondition
*:жϿ״̬Ƿǰ
*˵:ѽйʼ,
*һʼɹ
*************************************************************/
BOOL zAti_IsCardStateFillChangeCfgCondition(VOID)
{
    if(Z_CARD_INIT_SUCC == zAti_GetCardState(Z_ATI_INSNO_1)
        && Z_CARD_INIT_SUCC == zAti_GetCardState(Z_ATI_INSNO_2))
    {
        return TRUE;
    }
    else if((Z_CARD_INIT_SUCC == zAti_GetCardState(Z_ATI_INSNO_1) 
       && Z_CARD_INIT_ERR == zAti_GetCardState(Z_ATI_INSNO_2)) ||
       (Z_CARD_INIT_SUCC == zAti_GetCardState(Z_ATI_INSNO_2) 
       && Z_CARD_INIT_ERR == zAti_GetCardState(Z_ATI_INSNO_1)))
    {
        return TRUE;
    }

    return FALSE;
}

/**********************************************************
*:zAti_IsNeedChangeCfg
*:жǷҪ
*˵:1)Ƿкд
*                        2)Ƿ񿨵״̬
**********************************************************/
BYTE zAti_GetChangeCfgFlg(VOID)
{
    BYTE bNeedFg = Z_NO_NEED_CHANGE;

    /*ҵǰǷҪ*/
    if(zAti_IsCcStateFillChangeCfgCondition() && zAti_IsCardStateFillChangeCfgCondition())
    {
        bNeedFg = zUmm_IsNeedChangeCfg();
    }

    return bNeedFg;
}

VOID zAti_SendCfunSetReq(BYTE bValue, BYTE bInsNo)
{
    BYTE bTempInsNo = g_zAti_CurInstance;
    T_zApMmia_CfunSet_Req tCfunSet = {0};
    BYTE bSrcIndex = (bInsNo == 0) ? ZATI2_CHANNEL_ID_NUM251 : ZATI2_CHANNEL_ID_NUM252;
    tCfunSet.bDesIndex = 0XFF;
    tCfunSet.bSrcIndex = bSrcIndex;
    tCfunSet.bFun = bValue;
    g_zAti_CurInstance = bInsNo;
    zAti_CfunSet((VOID *) &tCfunSet);
    g_zAti_CurInstance = bTempInsNo;
}

/*****************************************************************
*:zAti_ExchangeSysconfig
*:˫˫ʱSYSCONFIG
*˵:ֱNVԼһĳ
*****************************************************************/
VOID zAti_ExchangeSysconfig(VOID)
{
    T_zAti_NV_Sysconfig tNvSysconfig1 = {0};
    T_zAti_NV_Sysconfig tNvSysconfig2 = {0};
    T_zAti_NV_Sysconfig tTempBuf = {0};

    zDev_NV_AtiReadItem(Z_ATI_NV_Sysconfig1, (PBYTE)&tNvSysconfig1);
    zDev_NV_AtiReadItem(Z_ATI_NV_Sysconfig2, (PBYTE)&tNvSysconfig2);

    zOss_Memcpy(&tTempBuf, &tNvSysconfig1, sizeof(T_zAti_NV_Sysconfig));
    zOss_Memcpy(&tNvSysconfig1, &tNvSysconfig2, sizeof(T_zAti_NV_Sysconfig));
    zOss_Memcpy(&tNvSysconfig2, &tTempBuf, sizeof(T_zAti_NV_Sysconfig));

    zDev_NV_AtiWriteItem(Z_ATI_NV_Sysconfig1, (PBYTE)&tNvSysconfig1);
    zDev_NV_AtiWriteItem(Z_ATI_NV_Sysconfig2, (PBYTE)&tNvSysconfig2);
}

/***************************************************************
*:zAti_OutFlymodeInSelfAdapt
*:ģʽ
*˵:Ƿģʽʱ
***************************************************************/
VOID zAti_OutFlymodeInSelfAdapt(VOID)
{
    BYTE bAnothInsNo = (g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_2: Z_ATI_INSNO_1;

    if(g_zAti_atDataEx[bAnothInsNo].IsNeedOutFlymode)
    {
        zAti_SendCfunSetReq(Z_APMMIA_CFUNFUN_FULLFUN, bAnothInsNo);
    }

    if(g_zAti_atDataEx[g_zAti_CurInstance].IsNeedOutFlymode)
    {
        zAti_SendCfunSetReq(Z_APMMIA_CFUNFUN_FULLFUN, g_zAti_CurInstance);
    }
}
#endif
BYTE __ps_static_func zAti_IsPlmnIdValid(T_z_PlmnId* ptPlmnId)
{
    if (ptPlmnId == ZOSS_NULL)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");
        return Z_INVALID;
    }

    if((ptPlmnId->bMCC1 > 9) ||
        (ptPlmnId->bMCC2 > 9) ||
        (ptPlmnId->bMCC3 > 9) ||
        (ptPlmnId->bMNC1 > 9) ||
        (ptPlmnId->bMNC2 > 9))
    {
        return Z_INVALID;
    }

    if((ptPlmnId->bMNC3 > 9) &&
        (ptPlmnId->bMNC3 != 15))
    {
        return Z_INVALID;
    }

    return Z_VALID;
}
/***********************************************************************
*:zAti_IsPlmnEqualWithCardPlmn
*:ǷͬPLMNID
***********************************************************************/
BOOL __ps_static_func zAti_IsPlmnEqualWithCardPlmn(T_z_PlmnId* ptPmnId, T_z_PlmnId* ptCardPlmnId, BYTE bInsNo)
{
    T_z_PlmnId  tTempPlmn = {0};

    tTempPlmn = *ptCardPlmnId;
    /*ͨĴ*/
    if(ptCardPlmnId->bMCC1 == 0xd)
    {
        tTempPlmn.bMCC1 = ptPmnId->bMCC1;
    }

    if(ptCardPlmnId->bMCC2 == 0xd)
    {
        tTempPlmn.bMCC2 = ptPmnId->bMCC2;
    }

    if(ptCardPlmnId->bMCC3 == 0xd)
    {
        tTempPlmn.bMCC3 = ptPmnId->bMCC3;
    }

    if(ptCardPlmnId->bMNC1 == 0xd)
    {
        tTempPlmn.bMNC1 = ptPmnId->bMNC1;
    }

    if(ptCardPlmnId->bMNC2 == 0xd)
    {
        tTempPlmn.bMNC2 = ptPmnId->bMNC2;
    }

    if(ptCardPlmnId->bMNC3 == 0xd)
    {
        tTempPlmn.bMNC3 = ptPmnId->bMNC3;
    }

    if(Z_VALID == zUmm_IsPlmnIdEqual(&tTempPlmn, ptPmnId, bInsNo))
    {
        return TRUE;
    }
    return FALSE;
}

BOOL __ps_static_func zAt_GetOperNameFromSimCard(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName, BYTE bInsNo)
{
    BYTE i = 0;
    T_zApMmia_NetName *ptNetName = NULL;

    ptNetName = (T_zApMmia_NetName*)ptAlphName;
    zAti_GetReadCardMutex();
    if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum == 0)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_PutReadCardMutex();
        return FALSE;//ûPLMNϢ
    }

    switch (bFlag)
    {
        case Z_ATI_OPER_NUMTOLONG:
            for(i = 0; i < g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum; i++)
            {
                if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i] != NULL &&
                    Z_VALID == zAti_IsPlmnEqualWithCardPlmn(pNumName, &g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->tPlmnId, bInsNo))
                {
                    ptNetName->bLen = (BYTE)strlen((const char*)g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abFullName);
                    if(ptNetName->bLen>0)
                    {
                        zOss_Memcpy(ptNetName->abName, g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abFullName, ptNetName->bLen);
                        zAti_PutReadCardMutex();
                        return TRUE;
                    }
                }
            }
            zAti_PutReadCardMutex();
            return FALSE;
        case Z_ATI_OPER_NUMTOSHORT:
            for(i = 0; i < g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum; i++)
            {
                if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i] != NULL &&
                    Z_VALID == zAti_IsPlmnEqualWithCardPlmn(pNumName, &g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->tPlmnId, bInsNo))
                {
                    ptNetName->bLen = (BYTE)strlen((const char*)g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abShortName);
                    if(ptNetName->bLen>0)
                    {
                        zOss_Memcpy(ptNetName->abName, g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abShortName, ptNetName->bLen);
                        zAti_PutReadCardMutex();
                        return TRUE;
                    }
                }
            }
            zAti_PutReadCardMutex();
            return FALSE;
        default:
            zAti_PutReadCardMutex();
            return FALSE;
    }

}
BOOL zAt_IsLacInRange(BYTE *abLacSatrt, BYTE *abLacEnd, WORD wLac)
{
    WORD wLacSatrt = (abLacSatrt[0]<<8)+abLacSatrt[1];
    WORD wLacEnd = (abLacEnd[0]<<8)+abLacEnd[1];

    if(wLac >= wLacSatrt && wLac <= wLacEnd)
    {
        return TRUE;
    }
    return FALSE;
}

BOOL zAt_GetCopsQryOperNameFromSimCard(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName, WORD wLac)
{
    BYTE i = 0;
    BYTE bInsNo = g_zAti_CurInstance;
    T_zApMmia_NetName *ptNetName = NULL;

    ptNetName = (T_zApMmia_NetName*)ptAlphName;
    zAti_GetReadCardMutex();
    if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum == 0)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_PutReadCardMutex();
        return FALSE;//ûPLMNϢ
    }

    switch (bFlag)
    {
        case Z_ATI_OPER_NUMTOLONG:
            for(i = 0; i < g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum; i++)
            {
                if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i] != NULL &&
                    Z_VALID == zAti_IsPlmnEqualWithCardPlmn(pNumName, &g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->tPlmnId, bInsNo))
                {
                    BYTE *pabSatrt = g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abLacStart;
                    BYTE *pabEnd = g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abLacEnd;
                    ptNetName->bLen = (BYTE)strlen((const char*)g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abFullName);
                    if(ptNetName->bLen>0 && zAt_IsLacInRange(pabSatrt, pabEnd, wLac))
                    {
                        zOss_Memcpy(ptNetName->abName, g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abFullName, ptNetName->bLen);
                        zAti_PutReadCardMutex();
                        return TRUE;
                    }
                }
            }
            zAti_PutReadCardMutex();
            return FALSE;
        case Z_ATI_OPER_NUMTOSHORT:
            for(i = 0; i < g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum; i++)
            {
                if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i] != NULL &&
                    Z_VALID == zAti_IsPlmnEqualWithCardPlmn(pNumName, &g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->tPlmnId, bInsNo))
                {
                    BYTE *pabSatrt = g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abLacStart;
                    BYTE *pabEnd = g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abLacEnd;
                    ptNetName->bLen = (BYTE)strlen((const char*)g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abShortName);
                    if(ptNetName->bLen>0&& zAt_IsLacInRange(pabSatrt, pabEnd, wLac))
                    {
                        zOss_Memcpy(ptNetName->abName, g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abShortName, ptNetName->bLen);
                        zAti_PutReadCardMutex();
                        return TRUE;
                    }
                }
            }
            zAti_PutReadCardMutex();
            return FALSE;
        default:
            zAti_PutReadCardMutex();
            return FALSE;
    }

}
BOOL zAt_GetPlmnIdFromSimCard(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName)
{
    BYTE i = 0;
    BYTE bInsNo = g_zAti_CurInstance;
    T_zApMmia_NetName *ptNetName = NULL;

    ptNetName = (T_zApMmia_NetName*)ptAlphName;
    zAti_GetReadCardMutex();
    if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum == 0)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_PutReadCardMutex();
        return FALSE;//ûPLMNϢ
    }

    switch(bFlag)
    {
        case Z_ATI_OPER_LONGTONUM:
            for(i = 0; i < g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum; i++)
            {
                if(ptNetName->bLen > 0 && g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]!= NULL &&
                    ptNetName->bLen == (BYTE)strlen((const char*)g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abFullName))
                {
                    if(zAti_MemcmpStr(ptNetName->abName, g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abFullName, ptNetName->bLen))
                    {
                        zOss_Memcpy(pNumName, &g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->tPlmnId, sizeof(T_z_PlmnId));
                        zAti_PutReadCardMutex();
                        return TRUE;
                    }
                }
            }
            zAti_PutReadCardMutex();
            return FALSE;
        case Z_ATI_OPER_SHORTTONUM:
            for(i = 0; i < g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum; i++)
            {
                if(ptNetName->bLen > 0 && g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]!= NULL &&
                    ptNetName->bLen == (BYTE)strlen((const char*)g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abShortName))
                {
                    if(zAti_MemcmpStr(ptNetName->abName, g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abShortName, ptNetName->bLen))
                    {
                        zOss_Memcpy(pNumName, &g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->tPlmnId, sizeof(T_z_PlmnId));
                        zAti_PutReadCardMutex();
                        return TRUE;
                    }
                }
            }
            zAti_PutReadCardMutex();
            return FALSE;
        default:
            zAti_PutReadCardMutex();
            return FALSE;
    }

}
BOOL __ps_static_func zAt_GetOperNameFromNetInfo(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName, BYTE bInsNo)
{
    BYTE i = 0;
    T_zApMmia_NetName *ptNetName = NULL;
    T_zAti_NV_NetPlmnInfo *ptNvNetInfo = (T_zAti_NV_NetPlmnInfo*)zAti_GetUB(sizeof(T_zAti_NV_NetPlmnInfo));
    ptNetName = (T_zApMmia_NetName*)ptAlphName;
    
    if(Z_FAIL == zDev_NV_AtiReadItem(Z_ATI_NV_NetOperPlmnID, (PBYTE)ptNvNetInfo))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_RetUB((VOID**)&ptNvNetInfo);
        return FALSE;
    }

    switch (bFlag)
    {
        case Z_ATI_OPER_NUMTOLONG:
            for(i = 0; i < Z_MAX_NET_OPER_NUM; i++)
            {
                if(Z_INVALID == zAti_IsPlmnIdValid(&ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId))
                {
                    continue;//Ч
                }
                if(Z_VALID == zUmm_IsPlmnIdEqual(pNumName, &ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId, bInsNo))
                {
                    ptNetName->bLen = (BYTE)strlen((const char*)ptNvNetInfo->atNvNetPlmnIDInfo[i].abFullName);
                    if(ptNetName->bLen > 0)
                    {
                        zOss_Memcpy(ptNetName->abName, ptNvNetInfo->atNvNetPlmnIDInfo[i].abFullName, ptNetName->bLen);
                        zAti_RetUB((VOID**)&ptNvNetInfo);
                        return TRUE;
                    }
                }
            }
            zAti_RetUB((VOID**)&ptNvNetInfo);
            return FALSE;
        case Z_ATI_OPER_NUMTOSHORT:
            for(i = 0; i < Z_MAX_NET_OPER_NUM; i++)
            {
                if(Z_INVALID == zAti_IsPlmnIdValid(&ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId))
                {
                    continue;//Ч
                }

                if(Z_VALID == zUmm_IsPlmnIdEqual(pNumName, &ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId, bInsNo))
                {
                    ptNetName->bLen = (BYTE)strlen((const char*)ptNvNetInfo->atNvNetPlmnIDInfo[i].abShortName);
                    if(ptNetName->bLen > 0)
                    {
                        zOss_Memcpy(ptNetName->abName, ptNvNetInfo->atNvNetPlmnIDInfo[i].abShortName, ptNetName->bLen);
                        zAti_RetUB((VOID**)&ptNvNetInfo);
                        return TRUE;
                    }
                }
            }
            zAti_RetUB((VOID**)&ptNvNetInfo);
            return FALSE;
        default:
            zAti_RetUB((VOID**)&ptNvNetInfo);
            return FALSE;
    }

}
BOOL zAt_GetPlmnIdFromNetInfo(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName)
{
    BYTE i = 0;
    T_zApMmia_NetName *ptNetName = NULL;
    T_zAti_NV_NetPlmnInfo *ptNvNetInfo = (T_zAti_NV_NetPlmnInfo*)zAti_GetUB(sizeof(T_zAti_NV_NetPlmnInfo));
    ptNetName = (T_zApMmia_NetName*)ptAlphName;

    if(Z_FAIL == zDev_NV_AtiReadItem(Z_ATI_NV_NetOperPlmnID, (PBYTE)ptNvNetInfo))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_RetUB((VOID**)&ptNvNetInfo);
        return FALSE;
    }

    switch(bFlag)
    {
        case Z_ATI_OPER_LONGTONUM:
            for(i = 0; i < Z_MAX_NET_OPER_NUM; i++)
            {
                if(Z_INVALID == zAti_IsPlmnIdValid(&ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId))
                {
                    continue;//Ч
                }
                if(ptNetName->bLen > 0 && ptNetName->bLen == strlen((const char*)ptNvNetInfo->atNvNetPlmnIDInfo[i].abFullName) &&
                    zAti_MemcmpStr(ptNetName->abName, ptNvNetInfo->atNvNetPlmnIDInfo[i].abFullName, ptNetName->bLen))
                {
                    zOss_Memcpy(pNumName, &ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId, sizeof(T_z_PlmnId));
                    zAti_RetUB((VOID**)&ptNvNetInfo);
                    return TRUE;
                }
            }
            zAti_RetUB((VOID**)&ptNvNetInfo);
            return FALSE;
        case Z_ATI_OPER_SHORTTONUM:
            for(i = 0; i < Z_MAX_NET_OPER_NUM; i++)
            {
                if(Z_INVALID == zAti_IsPlmnIdValid(&ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId))
                {
                    continue;//Ч
                }
                if(ptNetName->bLen > 0 && ptNetName->bLen == strlen((const char*)ptNvNetInfo->atNvNetPlmnIDInfo[i].abShortName) &&
                    zAti_MemcmpStr(ptNetName->abName, ptNvNetInfo->atNvNetPlmnIDInfo[i].abShortName, ptNetName->bLen))
                {
                    zOss_Memcpy(pNumName, &ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId, sizeof(T_z_PlmnId));
                    zAti_RetUB((VOID**)&ptNvNetInfo);
                    return TRUE;
                }
            }
            zAti_RetUB((VOID**)&ptNvNetInfo);
            return FALSE;
        default:
            zAti_RetUB((VOID**)&ptNvNetInfo);
            return FALSE;
    }
}

BOOL __ps_static_func zAt_GetOperNameFromMeInfo(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName, BYTE bInsNo)
{
    BYTE i = 0;
    T_zApMmia_NetName *ptNetName = NULL;
    T_zAti_NV_MePlmnInfo *ptNvMeInfo = NULL;
    ptNetName = (T_zApMmia_NetName*)ptAlphName;

    /*8KҪп*/
    ptNvMeInfo = (T_zAti_NV_MePlmnInfo*)zAti_GetUB(sizeof(T_zAti_NV_MePlmnInfo));
    if (ptNvMeInfo == ZOSS_NULL)
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");
        return FALSE;
    }

    if(Z_FAIL == zDev_NV_AtiReadItem(Z_ATI_NV_MeOperPlmnID, (PBYTE)ptNvMeInfo))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_RetUB((VOID**)&ptNvMeInfo);
        return FALSE;
    }

    switch (bFlag)
    {
        case Z_ATI_OPER_NUMTOLONG:
            for(i = 0; i < Z_MAX_ME_OPER_NUM; i++)
            {
                if(Z_INVALID == zAti_IsPlmnIdValid(&ptNvMeInfo->atNvMePlmnIDInfo[i].tPlmnId))
                {
                    continue;//Ч
                }
                if(Z_VALID == zUmm_IsPlmnIdEqual(pNumName, &ptNvMeInfo->atNvMePlmnIDInfo[i].tPlmnId, bInsNo))
                {
                    ptNetName->bLen = (BYTE)strlen((const char*)ptNvMeInfo->atNvMePlmnIDInfo[i].abFullName);
                    if(ptNetName->bLen > 0)
                    {
                        zOss_Memcpy(ptNetName->abName, ptNvMeInfo->atNvMePlmnIDInfo[i].abFullName, ptNetName->bLen);
                        zAti_RetUB((VOID**)&ptNvMeInfo);
                        return TRUE;
                    }
                }
            }
            zAti_RetUB((VOID**)&ptNvMeInfo);
            return FALSE;
        case Z_ATI_OPER_NUMTOSHORT:
            for(i = 0; i < Z_MAX_ME_OPER_NUM; i++)
            {
                if(Z_INVALID == zAti_IsPlmnIdValid(&ptNvMeInfo->atNvMePlmnIDInfo[i].tPlmnId))
                {
                    continue;//Ч
                }

                if(Z_VALID == zUmm_IsPlmnIdEqual(pNumName, &ptNvMeInfo->atNvMePlmnIDInfo[i].tPlmnId, bInsNo))
                {
                    ptNetName->bLen = (BYTE)strlen((const char*)ptNvMeInfo->atNvMePlmnIDInfo[i].abShortName);
                    if(ptNetName->bLen > 0)
                    {
                        zOss_Memcpy(ptNetName->abName, ptNvMeInfo->atNvMePlmnIDInfo[i].abShortName, ptNetName->bLen);
                        zAti_RetUB((VOID**)&ptNvMeInfo);
                        return TRUE;
                    }
                }
            }
            zAti_RetUB((VOID**)&ptNvMeInfo);
            return FALSE;
        default:
            zAti_RetUB((VOID**)&ptNvMeInfo);
            return FALSE;
    }
}
BOOL zAt_GetPlmnIdFromMeInfo(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName)
{
    BYTE i = 0;
    T_zApMmia_NetName *ptNetName = NULL;
    T_zAti_NV_MePlmnInfo *ptNvMeInfo = NULL;
    ptNetName = (T_zApMmia_NetName*)ptAlphName;

    /*8KҪп*/
    ptNvMeInfo = (T_zAti_NV_MePlmnInfo*)zAti_GetUB(sizeof(T_zAti_NV_MePlmnInfo));
    if (ptNvMeInfo == ZOSS_NULL)
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");
        return FALSE;
    }
    
    if(Z_FAIL == zDev_NV_AtiReadItem(Z_ATI_NV_MeOperPlmnID, (PBYTE)ptNvMeInfo))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_RetUB((VOID**)&ptNvMeInfo);
        return FALSE;
    }

    switch (bFlag)
    {
        case Z_ATI_OPER_LONGTONUM:
            for(i = 0; i < Z_MAX_ME_OPER_NUM; i++)
            {
                if(Z_INVALID == zAti_IsPlmnIdValid(&ptNvMeInfo->atNvMePlmnIDInfo[i].tPlmnId))
                {
                    continue;//Ч
                }
                if(ptNetName->bLen > 0 && ptNetName->bLen == strlen((const char*)ptNvMeInfo->atNvMePlmnIDInfo[i].abFullName)
                    && zAti_MemcmpStr(ptNetName->abName, ptNvMeInfo->atNvMePlmnIDInfo[i].abFullName, ptNetName->bLen))
                {
                    zOss_Memcpy(pNumName, &ptNvMeInfo->atNvMePlmnIDInfo[i].tPlmnId, sizeof(T_z_PlmnId));
                    zAti_RetUB((VOID**)&ptNvMeInfo);
                    return TRUE;
                }
            }
            zAti_RetUB((VOID**)&ptNvMeInfo);
            return FALSE;
        case Z_ATI_OPER_SHORTTONUM:
            for(i = 0; i < Z_MAX_ME_OPER_NUM; i++)
            {
                if(Z_INVALID == zAti_IsPlmnIdValid(&ptNvMeInfo->atNvMePlmnIDInfo[i].tPlmnId))
                {
                    continue;//Ч
                }
                if(ptNetName->bLen > 0 && ptNetName->bLen == strlen((const char*)ptNvMeInfo->atNvMePlmnIDInfo[i].abShortName)
                    && zAti_MemcmpStr(ptNetName->abName, ptNvMeInfo->atNvMePlmnIDInfo[i].abShortName, ptNetName->bLen))
                {
                    zOss_Memcpy(pNumName, &ptNvMeInfo->atNvMePlmnIDInfo[i].tPlmnId, sizeof(T_z_PlmnId));
                    zAti_RetUB((VOID**)&ptNvMeInfo);
                    return TRUE;
                }
            }
            zAti_RetUB((VOID**)&ptNvMeInfo);
            return FALSE;
        default:
            zAti_RetUB((VOID**)&ptNvMeInfo);
            return FALSE;
    }
}
BOOL zAt_GetOperNameFromGlobInfo(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName, BYTE bInsNo)
{
    WORD i = 0;
    T_zApMmia_NetName *ptNetName = NULL;
    ptNetName = (T_zApMmia_NetName*)ptAlphName;

    switch (bFlag)
    {
        case Z_ATI_OPER_NUMTOLONG:
            for(i = 0; i < Z_ATI_GLOPLMN_NUM; i++)
            {
                if(Z_VALID == zUmm_IsPlmnIdEqual(pNumName, (T_z_PlmnId*)g_zAt_Global_Plmninfo[i].abNum, bInsNo))
                {
                    ptNetName->bLen = (BYTE)strlen((const char*)g_zAt_Global_Plmninfo[i].Longstr);
                    if(ptNetName->bLen > 0)
                    {
                        zOss_Memcpy(ptNetName->abName, g_zAt_Global_Plmninfo[i].Longstr, ptNetName->bLen);
                        return TRUE;
                    }
                }
            }
            return FALSE;
        case Z_ATI_OPER_NUMTOSHORT:
            for(i = 0; i < Z_ATI_GLOPLMN_NUM; i++)
            {
                if(Z_VALID == zUmm_IsPlmnIdEqual(pNumName, (T_z_PlmnId*)g_zAt_Global_Plmninfo[i].abNum, bInsNo))
                {
                    ptNetName->bLen = (BYTE)strlen((const char*)g_zAt_Global_Plmninfo[i].Shortstr);
                    if(ptNetName->bLen > 0)
                    {
                        zOss_Memcpy(ptNetName->abName, g_zAt_Global_Plmninfo[i].Shortstr, ptNetName->bLen);
                        return TRUE;
                    }
                }
            }
            return FALSE;
        default:
            return FALSE;
    }
        
}

BOOL zAt_GetPlmnIdFromGlobInfo(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName)
{
    WORD i = 0;
    T_zApMmia_NetName *ptNetName = NULL;
    ptNetName = (T_zApMmia_NetName*)ptAlphName;

    switch (bFlag)
    {
        case Z_ATI_OPER_LONGTONUM:
            for(i = 0; i < Z_ATI_GLOPLMN_NUM; i++)
            {
                if(ptNetName->bLen > 0 && ptNetName->bLen == strlen((const char*)g_zAt_Global_Plmninfo[i].Longstr) &&
                    zAti_MemcmpStr(ptNetName->abName, (BYTE*)g_zAt_Global_Plmninfo[i].Longstr, ptNetName->bLen))
                {
                    zOss_Memcpy(pNumName, g_zAt_Global_Plmninfo[i].abNum, sizeof(T_z_PlmnId));
                    return TRUE;
                }
            }
            return FALSE;
        case Z_ATI_OPER_SHORTTONUM:
            for(i = 0; i < Z_ATI_GLOPLMN_NUM; i++)
            {
                if(ptNetName->bLen > 0 && ptNetName->bLen == strlen((const char*)g_zAt_Global_Plmninfo[i].Shortstr) &&
                    zAti_MemcmpStr(ptNetName->abName, (BYTE*)g_zAt_Global_Plmninfo[i].Shortstr, ptNetName->bLen))
                {
                    zOss_Memcpy(pNumName, g_zAt_Global_Plmninfo[i].abNum, sizeof(T_z_PlmnId));
                    return TRUE;
                }
            }
            return FALSE;
        default:
            return FALSE;
    }
}

BOOL __ps_static_func zAti_PutPlmnId(T_z_PlmnId *ptPlmnId, T_zMmiaUmm_OperPlmn *ptPlmn, BYTE bInsNo)
{
    BYTE i = 0;

    for(i = 0; i < ptPlmn->bNum; i++)
    {
        if(Z_VALID == zUmm_IsPlmnIdEqual(ptPlmnId, &ptPlmn->abOperatePlmn[i], bInsNo))
        {
            return TRUE;
        }
    }

    ptPlmn->abOperatePlmn[ptPlmn->bNum] = *ptPlmnId;
    ptPlmn->bNum++;

    if(ptPlmn->bNum >= Z_MAX_OPERATE_PLMNNUM)
    {
        return FALSE;
    }

    return TRUE;
}

VOID __ps_static_func zAti_GetAppointedPlmnIdbyFullName(BYTE *pName, T_zMmiaUmm_OperPlmn *ptPlmn, BYTE bInsNo)
{
    WORD i = 0;
    T_zAti_NV_NetPlmnInfo *ptNvNetInfo = NULL;
    T_zAti_NV_MePlmnInfo *ptNvMeInfo = NULL;

    /*SIM CARD*/
    zAti_GetReadCardMutex();
    if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum > 0)
    {
        for(i = 0; i < g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum; i++)
        {
            if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i] != NULL &&
                strlen((const char*)pName) == strlen((const char*)g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abFullName)&&
                zAti_MemcmpStr(pName, g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abFullName, (BYTE)strlen((const char*)pName)))
            {
                if(!zAti_PutPlmnId(&g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->tPlmnId, ptPlmn, bInsNo))
                {
                    zAti_PutReadCardMutex();
                    return;
                }
            }
        }
    }
    zAti_PutReadCardMutex();

    ptNvNetInfo = (T_zAti_NV_NetPlmnInfo*)zAti_GetUB(sizeof(T_zAti_NV_NetPlmnInfo));
    /*NET WORK*/
    if(Z_FAIL == zDev_NV_AtiReadItem(Z_ATI_NV_NetOperPlmnID, (PBYTE)ptNvNetInfo))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_RetUB((VOID**)&ptNvNetInfo);
        return;
    }

    for(i = 0; i < Z_MAX_NET_OPER_NUM; i++)
    {
        if(Z_VALID == zAti_IsPlmnIdValid(&ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId) &&
            strlen((const char*)pName) == strlen((const char*)ptNvNetInfo->atNvNetPlmnIDInfo[i].abFullName)&&
            zAti_MemcmpStr(pName, ptNvNetInfo->atNvNetPlmnIDInfo[i].abFullName, (BYTE)strlen((const char*)pName )))
        {
            if(!zAti_PutPlmnId(&ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId, ptPlmn, bInsNo))
            {
                zAti_RetUB((VOID**)&ptNvNetInfo);
                return;
            }
        }
    }
    zAti_RetUB((VOID**)&ptNvNetInfo);

    /*ME*/
    /*8KҪп*/
    ptNvMeInfo = (T_zAti_NV_MePlmnInfo*)zAti_GetUB(sizeof(T_zAti_NV_MePlmnInfo));
    if (ptNvMeInfo == ZOSS_NULL)
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");
        return ;
    }

    if(Z_FAIL == zDev_NV_AtiReadItem(Z_ATI_NV_MeOperPlmnID, (PBYTE)ptNvMeInfo))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_RetUB((VOID**)&ptNvMeInfo);
        return;
    }

    for(i = 0; i < Z_MAX_ME_OPER_NUM; i++)
    {
        if(Z_VALID == zAti_IsPlmnIdValid(&ptNvMeInfo->atNvMePlmnIDInfo[i].tPlmnId) &&
            strlen((const char*)pName) == strlen((const char*)ptNvMeInfo->atNvMePlmnIDInfo[i].abFullName)&&
            zAti_MemcmpStr(pName, ptNvMeInfo->atNvMePlmnIDInfo[i].abFullName, (BYTE)strlen((const char*)pName )))
        {
            if(!zAti_PutPlmnId(&ptNvMeInfo->atNvMePlmnIDInfo[i].tPlmnId, ptPlmn, bInsNo))
            {
                zAti_RetUB((VOID**)&ptNvMeInfo);
                return;
            }
        }
    }
    zAti_RetUB((VOID**)&ptNvMeInfo);

    /*GLOBAL*/
    for(i = 0; i < Z_ATI_GLOPLMN_NUM; i++)
    {
        if(strlen((const char*)pName) == strlen((const char*)g_zAt_Global_Plmninfo[i].Longstr) &&
            zAti_MemcmpStr(pName, (BYTE*)g_zAt_Global_Plmninfo[i].Longstr, (BYTE)strlen((const char*)pName )))
        {
            if(!zAti_PutPlmnId((T_z_PlmnId*)g_zAt_Global_Plmninfo[i].abNum, ptPlmn, bInsNo))
            {
                return;
            }
        }
    }
}
VOID __ps_static_func zAti_GetAppointedPlmnIdbyShortName(BYTE *pName, T_zMmiaUmm_OperPlmn *ptPlmn, BYTE bInsNo)
{
    WORD i = 0;
    T_zAti_NV_NetPlmnInfo *ptNvNetInfo = NULL;
    T_zAti_NV_MePlmnInfo *ptNvMeInfo = NULL;

    /*SIM CARD*/
    zAti_GetReadCardMutex();
    if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum > 0)
    {
        for(i = 0; i < g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum; i++)
        {
            if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i] != NULL &&
                strlen((const char*)pName) == strlen((const char*)g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abShortName)&&
                zAti_MemcmpStr(pName, g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abShortName, (BYTE)strlen((const char*)pName)))
            {
                if(!zAti_PutPlmnId(&g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->tPlmnId, ptPlmn, bInsNo))
                {
                    zAti_PutReadCardMutex();
                    return;
                }
            }
        }
    }
    zAti_PutReadCardMutex();

    ptNvNetInfo = (T_zAti_NV_NetPlmnInfo*)zAti_GetUB(sizeof(T_zAti_NV_NetPlmnInfo));
    /*NET WORK*/
    if(Z_FAIL == zDev_NV_AtiReadItem(Z_ATI_NV_NetOperPlmnID, (PBYTE)ptNvNetInfo))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_RetUB((VOID**)&ptNvNetInfo);
        return;
    }

    for(i = 0; i < Z_MAX_NET_OPER_NUM; i++)
    {
        if(Z_VALID == zAti_IsPlmnIdValid(&ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId) &&
            strlen((const char*)pName) == strlen((const char*)ptNvNetInfo->atNvNetPlmnIDInfo[i].abShortName)&&
            zAti_MemcmpStr(pName, ptNvNetInfo->atNvNetPlmnIDInfo[i].abShortName,(BYTE)strlen((const char*)pName )))
        {
            if(!zAti_PutPlmnId(&ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId, ptPlmn, bInsNo))
            {
                zAti_RetUB((VOID**)&ptNvNetInfo);
                return;
            }
        }
    }
    zAti_RetUB((VOID**)&ptNvNetInfo);

    /*ME*/
    /*8KҪп*/
    ptNvMeInfo = (T_zAti_NV_MePlmnInfo*)zAti_GetUB(sizeof(T_zAti_NV_MePlmnInfo));
    if (ptNvMeInfo == ZOSS_NULL)
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");
        return ;
    }

    if(Z_FAIL == zDev_NV_AtiReadItem(Z_ATI_NV_MeOperPlmnID, (PBYTE)ptNvMeInfo))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_RetUB((VOID**)&ptNvMeInfo);
        return;
    }

    for(i = 0; i < Z_MAX_ME_OPER_NUM; i++)
    {
        if(Z_VALID == zAti_IsPlmnIdValid(&ptNvMeInfo->atNvMePlmnIDInfo[i].tPlmnId) &&
            strlen((const char*)pName) == strlen((const char*)ptNvMeInfo->atNvMePlmnIDInfo[i].abShortName)&&
            zAti_MemcmpStr(pName, ptNvMeInfo->atNvMePlmnIDInfo[i].abShortName,(BYTE)strlen((const char*)pName )))
        {
            if(!zAti_PutPlmnId(&ptNvMeInfo->atNvMePlmnIDInfo[i].tPlmnId, ptPlmn, bInsNo))
            {
                zAti_RetUB((VOID**)&ptNvMeInfo);
                return;
            }
        }
    }
    zAti_RetUB((VOID**)&ptNvMeInfo);

    /*GLOBAL*/
    for(i = 0; i < Z_ATI_GLOPLMN_NUM; i++)
    {
        if(strlen((const char*)pName) == strlen((const char*)g_zAt_Global_Plmninfo[i].Shortstr) &&
            zAti_MemcmpStr(pName, (BYTE*)g_zAt_Global_Plmninfo[i].Shortstr,(BYTE)strlen((const char*)pName )))
        {
            if(!zAti_PutPlmnId((T_z_PlmnId*)g_zAt_Global_Plmninfo[i].abNum, ptPlmn, bInsNo))
            {
                return;
            }
        }
    }
}

/* ============================================================================
 : zAti_GetCurAct_ByIndex
 : ȡǰʽϢPDi/ATI/UICC/PDCPõĽӿ
     : 
     
     أBYTE ʽϢ,ֵ궨
 ע    ͣ
 -------------------------------------------------------------------------------
 ޸        汾        ޸        ޸ԭ
=============================================================================== */
BYTE __ps_static_func zAti_GetCurAct_ByIndex(BYTE bInsIdx)
{
    /*װUMM*/
    return zUmm_GetCurAct_NasCom_ByIndex(bInsIdx);
}
BYTE __ps_static_func zAti_GetNvRfCtrlFg(VOID)
{
    return (BYTE)zSys_GetNVCmdValue("PHY_EXIST");
}
/**************************************************************************
 : zAti_IsTdRfOpen
 : жǷ֧TDƵ
     : NvпƵĲ
     : VOID
     : Z_VALID֧/Z_INVALID֧
           
 ע    : 
---------------------------------------------------------------------------
***************************************************************************/
BYTE __ps_static_func zAti_IsTdRfOpen(BYTE bNvRfCtrlFg)
{
#ifdef PS_RAT_TDD
    if(0 == (bNvRfCtrlFg&2) || Z_INVALID == zDev_IsSupportTddBand())
    {
        return Z_INVALID;
    }
    return Z_VALID;
#else
    return Z_INVALID;
#endif
}

/**************************************************************************
 : zAti_IsWRfOpen
 : жǷ֧WƵ
     : NvпƵĲ
     : VOID
     : Z_VALID֧/Z_INVALID֧
           
 ע    : 
---------------------------------------------------------------------------
***************************************************************************/
BYTE __ps_static_func zAti_IsWRfOpen(BYTE bNvRfCtrlFg)
{
#ifdef PS_RAT_FDD
    if(0 == (bNvRfCtrlFg&4) || Z_INVALID == zDev_IsSupportFddBand())
    {
        return Z_INVALID;
    }
    return Z_VALID;
#else
    return Z_INVALID;
#endif
}
/**************************************************************************
 : zAti_IsGsmRfOpen
 : жǷ֧GsmƵ
     : NvпƵĲ
     : VOID
     : Z_VALID֧/Z_INVALID֧
           
 ע    : 
---------------------------------------------------------------------------
***************************************************************************/
BYTE __ps_static_func zAti_IsGsmRfOpen(BYTE bNvRfCtrlFg)
{
#ifdef PS_RAT_GSM
    if(0 == (bNvRfCtrlFg&1) || Z_INVALID == zDev_IsSupportGsmBand())
    {
        return Z_INVALID;
    }
    return Z_VALID;
#else
    return Z_INVALID;
#endif
}

/**************************************************************************
 : zAti_IsLteRfOpen
 : жǷ֧LTEƵ
     : NvпƵĲ
     : VOID
     : Z_VALID֧/Z_INVALID֧
           
 ע    : 
---------------------------------------------------------------------------
***************************************************************************/
BYTE __ps_static_func zAti_IsLteRfOpen(BYTE bNvRfCtrlFg)
{
#ifdef PS_RAT_LTE
    if(0 == (bNvRfCtrlFg&8) || Z_INVALID == zDev_IsSupportLteBand())
    {
        return Z_INVALID;
    }
    return Z_VALID;
#else
    return Z_INVALID;
#endif
}
/**************************************************************************
 : zAti_IsTdPhyExist
 : жǷ֧TDƵ
     : 
     : VOID
     : Z_VALID֧/Z_INVALID֧
           
 ע    : 
---------------------------------------------------------------------------
***************************************************************************/
BYTE zAti_IsTdPhyExist(VOID)
{
    if (0 == (zAti_GetNvRfCtrlFg()&2))
    {
        return Z_INVALID;
    }
    return Z_VALID;
}

/**************************************************************************
 : zAti_IsWPhyExist
 : жǷ֧WƵ
     : 
     : VOID
     : Z_VALID֧/Z_INVALID֧
           
 ע    : 
---------------------------------------------------------------------------
***************************************************************************/
BYTE zAti_IsWPhyExist(VOID)
{
    if (0 == (zAti_GetNvRfCtrlFg()&4))
    {
        return Z_INVALID;
    }
    return Z_VALID;
}

/**************************************************************************
 : zAti_IsGsmPhyExist
 : жǷ֧GsmƵ
     : 
     : VOID
     : Z_VALID֧/Z_INVALID֧
           
 ע    : 
---------------------------------------------------------------------------
***************************************************************************/
BYTE zAti_IsGsmPhyExist(VOID)
{
    if (0 == (zAti_GetNvRfCtrlFg()&1))
    {
        return Z_INVALID;
    }
    return Z_VALID;
}
/**************************************************************************
 : zAti_IsLtePhyExist
 : жǷ֧LTEƵ
     : 
     : VOID
     : Z_VALID֧/Z_INVALID֧
           
 ע    : 
---------------------------------------------------------------------------
***************************************************************************/
BYTE zAti_IsLtePhyExist(VOID)
{
    if (0 == (zAti_GetNvRfCtrlFg()&8))
    {
        return Z_INVALID;
    } 
    return Z_VALID;
}

/* ============================================================================
: zAti_GetTaskInstantIndex
: ȡʵģڵЭջʵ
    :   
    VOID
    أЭջʶ
ע    ͣ
-------------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
=============================================================================== */
BYTE  zAti_GetTaskInstantIndex(BYTE bSubMode)
{
    if (ZOSS_INVALID_TASK_ID !=  zDev_GetTaskId(bSubMode, 0))
    {
        return  0;
    }
    else
    {
        return  1;
    }
}
/**************************************************************************
 : zAti_IsDualPsDualUicc
 : жϵǰЭջǷ˫˫Эջ
     : 
     : 
     : Z_VALID/Z_INVALID
           
 ע    : 
---------------------------------------------------------------------------
***************************************************************************/
BYTE __ps_static_func zAti_IsDualPsDualUicc(VOID)
{
    if(ZOSS_INVALID_TASK_ID != zDev_GetTaskId(Z_ATI_TASKID_UICC, 0) \
        && ZOSS_INVALID_TASK_ID != zDev_GetTaskId(Z_ATI_TASKID_UICC, 1) \
        && zDev_GetTaskId(Z_ATI_TASKID_UICC, 0) != zDev_GetTaskId(Z_ATI_TASKID_UICC, 1))
    {
        return Z_VALID;
    }
    return Z_INVALID;
}
#ifdef Z_DUALCARD_ADAPT
/* ============================================================================
: zNas_GetCallState
: 鵱ǰǷں
    : 
    : 
    أZ_VALID--зͷź
          Z_INVALID--޷ͷź
ע    ͣ
-------------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
=============================================================================== */
BYTE zAti_GetCallState(BYTE bInsNo)
{
    return zCc_GetCallState(bInsNo);
}
#endif
#ifdef  PS_RAT_LTE
BYTE zAti_IsNeedLteBGplmnSearch(BYTE bInsIdx)
{
    BYTE   bStackIndex   = zAti_GetTaskInstantIndex(Z_ATI_TASKID_EMM);

    /*ǰLTE֧֣ҪLTE*/
    if (zAti_GetCurAct_ByIndex(bInsIdx) == Z_LTE_ACT)/*zNas_GetCurAct_AtiPdi*/
    {
        return Z_INVALID;
    }
    else if(Z_VALID == zAti_IsDualPsDualUicc())
    {
        return zUmm_IsSysconfigSptSpecAct(Z_LTE_ACT, bInsIdx);
    }
    else
    {
        if (bStackIndex == bInsIdx)  /*ǰЭջ֧LTEҪLTE*/
        {
            return Z_VALID;
        }
        else
        {
            return Z_INVALID;
        }
    }
}
#endif
BYTE zAti_GetRegState(VOID)
{
    BYTE bRegState = Z_APMMIA_REGSTATE_UNKNOWN;
    BYTE bInsNo = Z_ATI_INSNO_1;
	BYTE bCurAct = 0;

    bInsNo = ((g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_1 : Z_ATI_INSNO_2);

#ifdef PS_RAT_LTE
    bCurAct = zAti_GetCurAct_ByIndex(bInsNo);
    if (bCurAct == Z_LTE_ACT)
    {
        bRegState = g_zAti_atDataEx[bInsNo].bEpsState;
    }
    else
#endif
    {
        if(g_zAti_atDataEx[bInsNo].bPsState == Z_APMMIA_REGSTATE_NOREGNOSEARCH
          ||g_zAti_atDataEx[bInsNo].bPsState == Z_APMMIA_REGSTATE_REGHPLMN 
          ||g_zAti_atDataEx[bInsNo].bPsState == Z_APMMIA_REGSTATE_REGROAMING)
        {
            bRegState  =  g_zAti_atDataEx[bInsNo].bPsState;
        }
        else
        {
            bRegState  =  g_zAti_atDataEx[bInsNo].bCsState;
        }        
    }

    switch(bRegState)
    {
        case Z_APMMIA_REGSTATE_NOREGBUTSEARCH:    /**/
            return Z_ATI_REGSTATE_SEARCH;

        case Z_APMMIA_REGSTATE_NOREGNOSEARCH:     /*פ*/
        case Z_APMMIA_REGSTATE_REGHPLMN:
        case Z_APMMIA_REGSTATE_REGROAMING:
            return Z_ATI_REGSTATE_NORMAL;
            
        case Z_APMMIA_REGSTATE_REGDENIED:         /*no cell*/
        case Z_APMMIA_REGSTATE_UNKNOWN:  
        default:
            return Z_ATI_REGSTATE_NOSERVE;
    }
}

BYTE zAt_IsBeepCallNum(T_z_CallNum *ptCheckedNum)
{
    BYTE i = 0;
    BYTE bMinNumLen = 0;
    BYTE bDevNum = 0;
    BYTE bCheckedNum = 0;
    T_zAti_NV_BeepCallNum tBeepCall = {0};

    if(ptCheckedNum == ZOSS_NULL)
    {
        return Z_INVALID;
    }

    zDev_NV_AtiReadItem(Z_ATI_NV_BeepCall, (PBYTE)&tBeepCall);

    bCheckedNum = sizeof(ptCheckedNum->abNum);

    for(i = 0; i < tBeepCall.bCallNum && i < Z_DEV_MAX_BEEPCALL_GROUP; i++)
    {
        bDevNum = sizeof(tBeepCall.atCallGroup[i].abCallNum);
        bMinNumLen = (bDevNum < bCheckedNum)? bDevNum : bCheckedNum;

        if((tBeepCall.atCallGroup[i].bNumLen == ptCheckedNum->bNumLen) && (ptCheckedNum->bNumLen <= bMinNumLen)
         && (0 == memcmp(tBeepCall.atCallGroup[i].abCallNum, ptCheckedNum->abNum, ptCheckedNum->bNumLen)))
        {
            return Z_VALID;
        }
    }

    return Z_INVALID;
}

