 /***********************************************************************
* Copyright (C) 2001, ZTE Corporation.
* 
* File Name: 	tone_api.h
* File Mark:  	
* Description:  Provide tone module function prototype declaration and type declaration.
* Others:  	
* Version:  	v0.5
* Author:  	LvWenhua
* Date:  	      2007-10-25
* 
* History 1:  		
*     Date: 2007-10-25
*     Version:
*     Author: 
*     Modification:  create
* History 2: 
*     Date: 2008-05-26
*     Version:
*     Author: 
*     Modification:  1. Modify tone playing interface(T_ZDrvTone_PlayConfig structure) to make it compatible with arena hardware platform and zte hardware platform.
**********************************************************************/

#ifndef _TONE_API_H
#define _TONE_API_H




/**************************************************************************
 *                                  Include files                                                                             *
 **************************************************************************/



/**************************************************************************
 *                                  Macro                                                                                      *
 **************************************************************************/
//#define ZDRV_DEV_TONE  "tone"  /*The device name of tone driver.*/
#define ZDRV_TONE_OUTPUT_VOL_LEVEL_MAX   5     /* The max output volume level, need  to modify according to requirement.*/


/**************************************************************************
 *                                  Types                                                                                      *
 **************************************************************************/

/*Information from tone driver to upper application.*/
typedef enum 
{
    TONE_INFO_PLAY_END         = 0,
    TONE_INFO_PLAY_ERR              ,

    MAX_TONE_INFO             
} T_ZDrvTone_Info;

typedef enum
{
    TONE_OUTPUT_VOL_LEVEL_0 = 0,
    TONE_OUTPUT_VOL_LEVEL_1,
    TONE_OUTPUT_VOL_LEVEL_2,
    TONE_OUTPUT_VOL_LEVEL_3,
    TONE_OUTPUT_VOL_LEVEL_4,
    TONE_OUTPUT_VOL_LEVEL_5,
    TONE_OUTPUT_VOL_LEVEL_6,
    TONE_OUTPUT_VOL_LEVEL_7,
    TONE_OUTPUT_VOL_LEVEL_8,
    TONE_OUTPUT_VOL_LEVEL_9,
    TONE_OUTPUT_VOL_LEVEL_10,
    TONE_OUTPUT_VOL_LEVEL_11,    

    MAX_TONE_OUTPUT_VOL_LEVEL     
} T_ZDrvTone_OutputVolLevel;

typedef void (*T_ZDrvTone_CallbackFunc) (T_ZDrvTone_Info);

/*Tone type. Tone is single freqency on arena platform, whereas tone can be one, two, or three frequencys on teak dsp(zte hardware platform).[LvWenhua-2008-5-26]*/
typedef enum
{
    TONE_SINGLE_FREQ,
    TONE_DUAL_FREQ,
    TONE_TRIPLE_FREQ,
    MAX_TONE_TYPE_END
} T_ZDrvTone_TypeEnum;

/*Tone data for play,if the tone is single freqency, freq1and amp1 should be used; if the tone include two freqencys, freq1, amp1, freq2, and amp2 should be used;....[LvWenhua-2008-5-26]*/
typedef struct 
{
    UINT32 freq1; /*Tone frequency1*/
    UINT32 amp1; /*Tone frequency1 amplitude */
    UINT32 freq2;
    UINT32 amp2;
    UINT32 freq3;
    UINT32 amp3;
    UINT32 duration;/*How long the tone is played*/
}T_ZDrvTone_ToneData;

typedef struct
{

    T_ZDrvTone_TypeEnum type;           /*Tone type.*/
    T_ZDrvTone_ToneData tone_data;   /*Tone data for play.*/

    T_ZDrvTone_CallbackFunc callback;  /*Callback function which will be called when the tone stops.*/
} T_ZDrvTone_PlayConfig;


typedef enum 
{
    TONE_FIXED_DTMF_ID0, /* 0 */
    TONE_FIXED_DTMF_ID1,
    TONE_FIXED_DTMF_ID2,
    TONE_FIXED_DTMF_ID3,
    TONE_FIXED_DTMF_ID4,
    TONE_FIXED_DTMF_ID5,
    TONE_FIXED_DTMF_ID6,
    TONE_FIXED_DTMF_ID7,
    TONE_FIXED_DTMF_ID8,
    TONE_FIXED_DTMF_ID9,
    TONE_FIXED_DTMF_HASH,
    TONE_FIXED_DTMF_ASTERIX,
    TONE_FIXED_KEY_1,
    TONE_FIXED_KEY_2,
    TONE_FIXED_KEY_3,
    TONE_FIXED_KEY_4,
    TONE_FIXED_KEY_5,
    TONE_FIXED_SV_SUBSCRIBER_BUSY,
    TONE_FIXED_SV_CONGESTION,
    TONE_FIXED_SV_RADIO_ACK,
    TONE_FIXED_SV_RADIO_NOTAVAIL,
    TONE_FIXED_SV_ERROR_INFO,
    TONE_FIXED_SV_CALL_WAITING,
    TONE_FIXED_INFO_FREE_TONE,
    TONE_FIXED_INFO_CONNECTION,
    TONE_FIXED_INFO_DISCONNECT,
    TONE_FIXED_INFO_DEVICE_IN,
    TONE_FIXED_INFO_DEVICE_OUT,
    TONE_FIXED_INFO_MSG_FULL,
    TONE_FIXED_INFO_USSD,
    TONE_FIXED_INFO_MINUTE_MINDER,
    TONE_FIXED_INFO_ERROR_1,
    TONE_FIXED_INFO_ERROR_2,
    TONE_FIXED_INFO_SMS_INCALL,
    TONE_FIXED_INFO_BROADCAST_INCALL,
    TONE_FIXED_INFO_ALARM_INCALL,
    TONE_FIXED_INFO_LOWBAT_INCALL,
    TONE_FIXED_INFO_POWER_OFF,
    TONE_FIXED_INFO_POWER_ON,
    TONE_FIXED_INFO_SINGLE_BEEP,
    TONE_FIXED_INFO_POSITIVE_ACKNOWLEDGEMENT,
    TONE_FIXED_INFO_NEGATIVE_ACKNOWLEDGEMENT,
    TONE_FIXED_INFO_AUTO_REDIAL,
    TONE_FIXED_INFO_NETWORK_ATTENTION,
    TONE_FIXED_INFO_DIAL_TONE,
    TONE_FIXED_LOW_BAT,
    
    TONE_FIXED_MAXID
    
} T_ZDrvTone_FixedType;

typedef struct
{

    T_ZDrvTone_FixedType type;           /*Tone fixedid type.*/
    UINT16  repeat_times;   /*Tone play times*/

    T_ZDrvTone_CallbackFunc callback;  /*Callback function which will be called when the tone stops.*/
} T_ZDrvTone_FixedIDPlayConfig;

typedef enum 
{
    IOCTL_TONE_PLAY           = 0,   /*Start play.param :T_ZDrvTone_PlayConfig*/
    IOCTL_TONE_STOP               ,   /*Stop play.param:null*/
    IOCTL_TONE_SET_PATH        ,   /*Set play path. param:T_ZDrv_CodecOutputPath*/
    IOCTL_TONE_SET_VOL          ,   /*Set play volume.param:T_ZDrvTone_OutputVolLevel*/
    IOCTL_TONE_FIXEDID_PLAY,  /*Start play fixed id tone .param :T_ZDrvTone_FixedIDPlayConfig*/
    IOCTL_TONE_SET_MUTE,        /* set mute,param:BOOL */ 
    MAX_IOCTL_TONE
}T_ZDrvTone_IoCtl;


/**************************************************************************
 *                           Global  Variable                                                                              *
 **************************************************************************/


/**************************************************************************
 *                           Function Prototypes                                                                        *
 **************************************************************************/


/**************************************************************************
* Function: zDrv_Open
* Description: This function is used to open device according to device name.
* Parameters: 
*   Input:
            pathname:device name, ZDRV_DEV_TONE in tone 
*	     flags: no use
*   Output: None
* Returns:   
*       device file descriptor if successed. [1, ZDRV_MAX_DEV_FILE_NUM), please refer to dal_api.h
*       DRV_ERR_NO_THIS_DEVICE: this device hasn't been installed yet
*       DRV_ERR_FD_OVERFLOW: no free fd entry
*       DRV_ERR_NOT_SUPPORTED: this device don't support open operation.
*       DRV_ERR_OPEN_TIMES: has been opened already. 
*       others: others error code. for detailed information, please refer to the header file of hal layer
* Others: None
**************************************************************************/
/*SINT32 zDrv_Open (const CHAR *pathname, SINT32 flags)*/


/**************************************************************************
* Function: zDrv_Close
* Description: This function is used to close a device according to device file descriptor.
* Parameters: 
*   Input:
*              fd :device file descriptor 
*   Output:None
* Returns: 
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_FD_TABLE: device driver table has been invalid.
*       DRV_ERR_NOT_SUPPORTED: this device don't support close operation.
*       others: others error code. for detailed information, please refer to the header file of hal layer
* Others: None
**************************************************************************/
/*SINT32 zDrv_Close(UINT32 fd)*/


/**************************************************************************
* Function: zDrv_Ioctl
* Description:  This function is used to control device according to fd(device file descriptor).
* Parameters: 
*   Input:
*           fd:device file descriptor
*           cmd:command code
*           arg:command parameters
*   Output:None
* Returns: 
*       DRV_SUCCESS: successed.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_FD_TABLE: device driver table has been invalid.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_INVALID_IOCTL_CMD: this command has not been supported yet.
*       others: for detailed information, please refer to the header file of hal layer
*Other None
**************************************************************************/
/*SINT32 zDrv_Ioctl(UINT32 fd, UINT32 cmd, VOID* arg)*/

/**************************************************************************
* Function: zDrvTone_Init
* Description: This function is used to install tone driver.
* Parameters: 
*   Input:None
*   Output:None
* Returns: 
*       DRV_SUCCESS: successed.
*       DRV_ERROR: error
*       DRV_ERR_DEV_OVERFLOW: no free device driver entry in table
*       DRV_ERR_MEM_ALLOC: failed to alloc memory
* Others: None
**************************************************************************/
//SINT32 zDrvTone_Init(VOID);


/**************************************************************************
* Function: zDrvTone_Exit
* Description: This function is used to uninstall tone driver.
* Parameters: 
*   Input:None
*   Output:None
* Returns: 
*       DRV_SUCCESS: successed.
*       DRV_ERROR: error
*       DRV_ERR_DEV_TABLE: device driver table has been invalid.
*       DRV_ERR_NO_THIS_DEVICE: this device hasn't been installed yet
* Others: None
**************************************************************************/
//SINT32 zDrvTone_Exit(VOID);

#endif  /* _TONE_API_H */

