/**
 *   Copyright (C) Infineon Technologies Denmark A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Infineon
 * Technologies Denmark A/S. Passing on and copying of this document, use
 * and communication of its contents is not permitted without prior written
 * authorisation.
 *
 * Description:
 *   Headerfile for the speech state machine
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_ear.h
 *   Version: \main\13
 *   Date: 2007-04-30 15:14:50
 *   Responsible: kbj
 *   Comment:
 *     Merged code guideline updates.
 */
 
#if !defined (_AUD_EAR_H)
#define _AUD_EAR_H

/*******************************************************************************
*
*                  Public functions implemented in aud_ear.c
*
*******************************************************************************/
BOOL aud_speech_SM(aud_event_enum event, void* p_data); /* state machine */
void aud_drv_activate_hf(void); /* activates the hands-free algorithms if needed */
/* getter functions */
BOOL aud_get_HF_active(void);   /* Is the hands-free algorithm active? */
S16  aud_get_EC_NR_mask(void);  /* Used to control the current setting of EC/NR - used as a mask */

/*******************************************************************************
*
*                Public functions implemented in aud_ear_tst.c
*
*******************************************************************************/
extern U32 aud_test_speech_generic_func(void *p_func_req, BOOL *p_processed ); /* dispatcher for speech opcodes (for testing) */

#endif /* _AUD_EAR_H */
