/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:hal_voiceprocess.c
 * File Mark:
 * Description: Loop voice data from teak to arm.
                    Settings: arm iis1->top iis1(connect to ap), arm iis2 loop to teak afe.

 * Others:
 * Version:
 * Author:        lvwenhua
 * Date:          2011-8-3
 * History 1:
 *     Date: 2016-2-16
 *     Version:
 *     Author:xuxinqiang
 *     Modification: edit for union version
 * History 2:
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_volte.h"
#include "drvs_i2s.h"
#include "drvs_voiceprocess.h"
#include "hal_voiceprocess.h"
#include "drvs_voice_config.h"
//#include "hal_pcmmixer.h"
#include "NvParam_drv.h"
#include "drvs_io_voice.h"
#include "hal_ringdata.h"
#include "drvs_tdm.h"
#include "hal_dtmf_detect.h"
#include "hal_audio_data.h"
//#define TEST_WHITE_NOISE

#ifdef TEST_WHITE_NOISE
#include "Fs8000_WhiteNoise_Mon.h"
//#include "Fs8000_Sine_440Hz_Mon.h"
#endif

#include "drvs_icp.h"
#include "drvs_rpmsg.h"
//#include <linux/completion.h>
/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
//#define USE_AUDIO_RING
//#define VP_GET_TX_ALL_DATA

#define VP_BUF_LENGTH  0x7FF80 //0xFFD80   //0x7FE40  //0x4df80// (0.5M  0x80000)
#define VP_FRAME_BUFFER_SIZE 320 //20ms 800KHZ
#define VP_I2S_BUFFER_SIZE 320
#define VOICE_SYNC_TIMEOUT_TIME 100

#define VP_INOUT_BAK_BUFFER_SIZE 0x30000  // 0x60000
#define VP_INOUT_NOBAK_BUFSIZE  640
/****************************************************************************
* 	                                           Local Types
****************************************************************************/


/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/
SINT32 voice_ToneMixerStop(VOID);//xiu gai chu sheng ming
SINT32 zDrvI2S_Read_Start_Do(T_ZDrvI2S_Id tId, T_ZDrvI2s_Params *params);//xiu gai chu sheng ming
SINT32 zDrvI2S_Write_Start_Do(T_ZDrvI2S_Id tId, T_ZDrvI2s_Params *params);//xiu gai chu sheng ming
/****************************************************************************
* 	                                          Global Constants
****************************************************************************/


/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
//static T_zDrvVp_SpeechState *s_pSpeechState = NULL;
static T_zDrvVp_SpeechState s_speechState = {0};  //104 bytes

T_zDrvVoice_GbVar g_voiceVar =
{
	0,//volteIsWb 1
	0,//isUseSlicCodec 2
	0,//g_isUseTdm 3
	0,//voiceInGsmTdMode 4
	0,//voiceInVolteMode  5
	FALSE, //innerI2sIsMaster 6
	TRUE,//innerI2sIsI2sMode 7
	FALSE,//vpLoopRuning 8
	FALSE,//muteEn 9
	FALSE,//vProcIsNormal 10
	VP_I2S_IDLE,//vpI2sStatus 11
	VP_PATH_HANDSET,//vpPath 12 
	VP_PATH_HANDSET,//vpLoopPath 13
	VP_VOL_3, //vpVol 14
	MAX_VOICE_MODE,//voiceMode 15 
	-1,//vpInitGain 16
	{0},//audio_ctrlFlag 17
    DTMF_IDLE,// 18
    0,//dtmfDirSel 19
    0, //sample_rate 20 
	0, //useDtmfLoop; 21
	0, //muteCount;//mute_count 22	
    FALSE, //23 vpLoopBkRunning
	FALSE, //24 rxMuteEn
	FALSE, //25 firstRegZCATFlag
};

static T_zDrvVp_State s_vpState =
{
	NULL,
	NULL,
	NULL,
	NULL,
	0,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	{0},
	{0},
	0,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
//	{0}
};

//for test whiteNoise
#ifdef TEST_WHITE_NOISE
UINT32 tempCount = 0;
UINT8 *pVoiceTempBuf = NULL;
#endif

static T_ZDrvTdm_Params s_vpTdmReadParam = {AUDIO_MONO_CHANNEL, VP_I2S_BUFFER_SIZE, NULL};
static T_ZDrvTdm_Params s_VpTdmWriteParam = {AUDIO_MONO_CHANNEL, VP_I2S_BUFFER_SIZE, NULL};
#ifdef VOICE_TONE_MIXER_FUNCTION
extern T_HalMixerToneInfo mixerToneInfo;
#endif
/*
#ifdef VP_GET_TX_ALL_DATA
UINT8 *pVpTxInAllDataBuffer = NULL;
static UINT32 s_TxAllDataSaveLen = 0;
#endif
*/

extern T_ZDrv_VpInOutBuffer vpInOutBuffer;

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/
#ifdef CONFIG_CP_USE_SOFT_DTMF_DETECT
extern void slic_tw_dtmf_detect_open(void);
extern int  slic_tw_dtmf_detect(short *pcm, unsigned int length, unsigned int fs);
extern void slic_tw_dtmf_detect_close(void);
#endif
extern SINT32 voice_CreateRcdSemAndThread(VOID);
extern SINT32 voice_InitCodec(VOID);
//extern SINT32 zDrv_DtmfToneStart(UINT32 toneNum);
extern UINT32 zDrvTimer_Stamp(VOID);
extern SINT32 zDrvI2S_Init(VOID);
extern int nand_mtd_erase(UINT32 dwAddr);
//aduvoice config code
extern SINT32 halVpCfg_Open(T_ZDrvVp_SourceType srctype);
extern SINT32 halVpCfg_Close(VOID);
extern SINT32 halVpCfg_Enable(VOID);
extern SINT32 halVpCfg_Disable(VOID);
extern SINT32 halVpCfg_SetFs(T_ZDrv_VpFs fs);
extern SINT32 halVpCfg_SetInputPath(T_ZDrv_VpPath path, BOOL enable);
extern SINT32 halVpCfg_SetInputPath(T_ZDrv_VpPath path, BOOL enable);
extern SINT32 halVpCfg_SetMute(T_ZDrv_VpPath path, BOOL mute);
extern VOID vp_SetTopI2sConfig(VOID);
//extern SINT32 zDrvAudio_Initiate(VOID);

static VOID  vp_LoopProcessThreadEntry(SINT32 argu);
SINT32 vp_WriteDataToCodec(UINT8 *pBuf, UINT32 count);
SINT32 vp_ReadDataFromCodec(UINT8 *pBuf, UINT32 count);
SINT32 vp_VoiceI2sStart(VOID);
SINT32 zDrvVp_LoopStartDo(VOID);
extern SINT32 zDrvAud_DspSetAudSetting(BOOL useAfeI2s);
extern SINT32 zDrvI2S_Reset(T_ZDrvI2S_Id tId);
SINT32 vp_TdmCfgParam(T_ZDrvVp_Cfg *cfgParam);
SINT32 vp_I2sCfgParam(T_ZDrvVp_Cfg *cfgParam);
extern SINT32 zDrvTDM_Init(VOID);
extern SINT32 zDrvTDM_Open(T_ZDrvI2s_TransMode tdmTransMode);
extern SINT32 zDrvTDM_Reset();
extern SINT32 zDrvTDM_Close();
extern SINT32 zDrvTDM_Write_Prepare(T_ZDrvTdm_Cfg * ptCfg);
extern SINT32 zDrvTDM_Write_Start(T_ZDrvTdm_Params *params, T_ZDrvTdm_Cfg * ptCfg);
extern SINT32 zDrvTDM_Read_Prepare(T_ZDrvTdm_Cfg *ptCfg);
extern SINT32 zDrvTDM_Read_Start(T_ZDrvTdm_Params *params, T_ZDrvTdm_Cfg *ptCfg);
extern SINT32 zDrvTDM_Write(const UINT8 *pBuf, UINT32 uiLen);
extern SINT32 zDrvTDM_Read(UINT8 ** pBuf, UINT32 * uiLen);
extern SINT32 zDrvTDM_Write_Stop();
extern SINT32 zDrvTDM_Read_Stop();
extern SINT32 zDrvTDM_GetBuf(UINT8 **pBuf, UINT32 *uiLen);
extern SINT32 zDrvTDM_Both_Stop();
extern SINT32 zDrvTDM_FreeBuf(UINT8 *pBuf);
extern VOID vp_SetTopTdmConfig(VOID);
#ifdef VOICE_TONE_MIXER_FUNCTION
SINT32 voice_ToneMixerData2(UINT8 *pvdata, UINT32 size, UINT8 *pmixdata);
#endif

SINT32 halVpCfg_SetOutputPath(T_ZDrv_VpPath path, BOOL enable); //xiu gai chu sheng ming
SINT32 zDrvI2S_Write_Stop(T_ZDrvI2S_Id tId);//xiu gai chu sheng ming
SINT32 voice_ToneMixerData(UINT8 *pvdata, UINT32 size, UINT8 *pmixdata);//xiu gai chu sheng ming
SINT32 zDrvI2S_Read_Prepare(T_ZDrvI2S_Id tId, T_ZDrvI2S_Cfg *ptCfg);//xiu gai chu sheng ming
SINT32 zDrvI2S_Write_Prepare(T_ZDrvI2S_Id tId, T_ZDrvI2S_Cfg *ptCfg);//xiu gai chu sheng ming
SINT32 zDrvVolte_Initiate(VOID);//xiu gai chu sheng ming
//SINT32 VoiceProc_SetGain(SINT32 gain, UINT32 channel, T_ZDrv_VpPath path);//xiu gai chu sheng ming
SINT32 voice_RcdStop(VOID);//xiu gai chu sheng ming
SINT32 voice_RcdStart(T_ZDrvRcd_InfoParam *pParam);//xiu gai chu sheng ming
SINT32 zDrvI2S_Read_Start(T_ZDrvI2S_Id tId, T_ZDrvI2s_Params *params, T_ZDrvI2S_Cfg *ptCfg);//xiu gai chu sheng ming
SINT32 zDrvI2S_Write_Start(T_ZDrvI2S_Id tId, T_ZDrvI2s_Params *params, T_ZDrvI2S_Cfg *ptCfg);//xiu gai chu sheng ming
/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
#ifdef CONFIG_VOICE_BUFFER_DRV  
extern int voicebuffer_ulqueue_read(void *buf, unsigned int size);
extern int  voicebuffer_dlqueue_write(void  *buf, unsigned int  size);
extern void voice_inform_to_app(void);
//static DECLARE_COMPLETION(s_voice_completion);
ZOSS_TIMER_ID s_voiceTimerId ;
ZOSS_SEMAPHORE_ID s_voiceRdSema;
ZOSS_SEMAPHORE_ID s_voiceWrSema;
void voiceTimerCallBack(SINT32 para)
{
//	complete_all(&s_voice_completion);
	zOss_PutSemaphore(s_voiceWrSema);
	zOss_PutSemaphore(s_voiceRdSema);
	voice_inform_to_app();
//	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voiceTimerCallBack timer=%u\n", cpu_clock(0)>>10);
}

SINT32 vp_rxsem_count_Init(void)
{
	UINT32 i = 0;
	UINT32 semCount = 0;
	SINT32 Count = 0;

	semCount = zOss_GetSemaphoreCount(s_voiceRdSema);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_rxsem_count_Init rxSem count=%d\n",  semCount);

	Count = semCount;
	if(Count > 0)  {
		for(i = 0; i < Count; i++) {
			zOss_GetSemaphore(s_voiceRdSema, ZOSS_NO_WAIT);
		}
	}

	return DRV_SUCCESS;
}

SINT32 vp_txsem_count_Init(void)
{
	UINT32 i = 0;
	UINT32 semCount = 0;
	SINT32 Count = 0;

	semCount = zOss_GetSemaphoreCount(s_voiceWrSema);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_txsem_count_Init txSem count=%d \n",  semCount);

	Count = 3 - semCount;
	if(Count > 0) {
		for(i = 0; i < Count; i++) {
			zOss_PutSemaphore(s_voiceWrSema);
		}
	} else if(Count < 0) {
		Count = 0 - Count;
		for(i = 0; i < Count; i++) {
			zOss_GetSemaphore(s_voiceWrSema, ZOSS_NO_WAIT);
		}
	}
	
	return DRV_SUCCESS;
}

#endif


SINT32 zDrv_Init(VOID)
{
	if (g_voiceVar.g_isUseTdm != 1)
	{
		zDrvI2S_Init();
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		zDrvI2S_Init();
		zDrvTDM_Init();
	}
	return DRV_SUCCESS;
}

SINT32 zDrvExtAudio_Open(T_ZDrvI2s_TransMode i2sTransMode)
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Open(I2S_1, i2sTransMode);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Open(i2sTransMode);
	}
#endif	
	return ret;
}

SINT32 zDrvExtAudio_Reset()
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else	
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Reset(I2S_1);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Reset();
	}
#endif	
	return ret;
}
SINT32 zDrvExtAudio_Close()
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else	
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Close(I2S_1);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Close();
	}
#endif	
	return ret;
}

SINT32 zDrvExtAudio_Write_Prepare(T_ZDrvI2S_Cfg *i2sCfg, T_ZDrvTdm_Cfg *tdmCfg)
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else	
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Write_Prepare(I2S_1, i2sCfg);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Write_Prepare(tdmCfg);
	}
#endif	
	return ret;
}

SINT32 zDrvExtAudio_Write_Start(T_ZDrvI2s_Params *i2sParams, T_ZDrvI2S_Cfg *i2sCfg,
                                T_ZDrvTdm_Params *tdmParams, T_ZDrvTdm_Cfg *tdmCfg)
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else	
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Write_Start(I2S_1, i2sParams, i2sCfg);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Write_Start(tdmParams, tdmCfg);
	}
#endif	
	return ret;
}
SINT32 zDrvExtAudio_Write_Start_Do(T_ZDrvI2s_Params *i2sParams, T_ZDrvI2S_Cfg *i2sCfg,
                                   T_ZDrvTdm_Params *tdmParams, T_ZDrvTdm_Cfg *tdmCfg)
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else	
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Write_Start_Do(I2S_1, i2sParams);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Write_Start_Do(tdmParams);
	}
#endif	
	return ret;
}
SINT32 zDrvExtAudio_Read_Prepare(T_ZDrvI2S_Cfg *i2sCfg, T_ZDrvTdm_Cfg *tdmCfg)
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else	
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Read_Prepare(I2S_1, i2sCfg);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Read_Prepare(tdmCfg);
	}
#endif	
	return ret;
}

SINT32 zDrvExtAudio_Read_Start(T_ZDrvI2s_Params *i2sParams, T_ZDrvI2S_Cfg *i2sCfg,
                               T_ZDrvTdm_Params *tdmParams, T_ZDrvTdm_Cfg *tdmCfg)
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else	
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Read_Start(I2S_1, i2sParams, i2sCfg);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Read_Start(tdmParams, tdmCfg);
	}
#endif	
	return ret;
}
SINT32 zDrvExtAudio_Read_Start_Do(T_ZDrvI2s_Params *i2sParams, T_ZDrvI2S_Cfg *i2sCfg,
                                  T_ZDrvTdm_Params *tdmParams, T_ZDrvTdm_Cfg *tdmCfg)
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else	
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Read_Start_Do(I2S_1, i2sParams);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Read_Start_Do(tdmParams);
	}
#endif
	return ret;
}
SINT32 zDrvExtAudio_Write(const UINT8 *pBuf, UINT32 uiLen)
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Write(I2S_1, pBuf, uiLen);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Write(pBuf, uiLen);
	}
#endif	
	return ret;
}

SINT32 zDrvExtAudio_Read(const UINT8 **pBuf, UINT32 *uiLen)
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  	
#else	
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Read(I2S_1, pBuf, uiLen);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Read(pBuf, uiLen);
	}
#endif	
	return ret;
}
SINT32 zDrvExtAudio_Write_Stop()
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else	
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Write_Stop(I2S_1);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Write_Stop();
	}
#endif	
	return ret;
}

SINT32 zDrvExtAudio_Read_Stop()
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else	
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Read_Stop(I2S_1);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Read_Stop();
	}
#endif	
	return ret;
}

SINT32 zDrvExtAudio_GetBuf(UINT8 **pBuf, UINT32 *uiLen)
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  	
#else
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_GetBuf(I2S_1, pBuf, uiLen);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_GetBuf(pBuf, uiLen);
	}
#endif
	return ret;
}
#if 0
SINT32 zDrvExtAudio_Both_Stop()
{
	int ret = 0;
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Both_Stop(I2S_1);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Both_Stop();
	}
	return ret;
}
#endif
SINT32 zDrvExtAudio_FreeBuf(UINT8 *pBuf)
{
	int ret = 0;
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else		
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_FreeBuf(I2S_1, pBuf);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_FreeBuf(pBuf);
	}
#endif	
	return ret;
}

void zDrvExtAudio_RlsAllSemaBeforeStop(void)
{
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else		
	if (g_voiceVar.g_isUseTdm == 1)
	{
		zDrvTdm_RxRlsSemaBeforeStop();
		zDrvTdm_TxRlsSemaBeforeStop();
	}
	else
	{
		zDrvI2s_RxRlsSemaBeforeStop(I2S_1);
		zDrvI2s_TxRlsSemaBeforeStop(I2S_1);
	}
#endif	
}

void zDrvExtAudio_RxRlsSemaBeforeStop(void)
{
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else		
	if (g_voiceVar.g_isUseTdm == 1)
	{
		zDrvTdm_RxRlsSemaBeforeStop();
	}
	else
	{
		zDrvI2s_RxRlsSemaBeforeStop(I2S_1);
	}
#endif	
}

void zDrvExtAudio_TxRlsSemaBeforeStop(void)
{
#ifdef CONFIG_VOICE_BUFFER_DRV  
#else		
	if (g_voiceVar.g_isUseTdm == 1)
	{
		zDrvTdm_TxRlsSemaBeforeStop();
	}
	else
	{
		zDrvI2s_TxRlsSemaBeforeStop(I2S_1);
	}
#endif	
}

VOID vp_SetTopConfig(VOID)
{
	if (g_voiceVar.g_isUseTdm != 1)
	{
		vp_SetTopI2sConfig();
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		vp_SetTopTdmConfig();
	}
}
#if 0
//dtmf检测-测试用
T_DrvDtmf_Detect_Opt dtmf_test;
void drv_dtmfrx_report(char *dtmf_string, unsigned char string_len)
{
    //printk("cp drv_dtmfrx_report, dtmf_string=%c, string_len=%d\n", *dtmf_string, string_len);
    zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "cp drv_dtmfrx_report, dtmf_string=%c, string_len=%d\n", *dtmf_string, string_len);
}
void drv_dtmftx_report(char *dtmf_string, unsigned char string_len)
{
    //printk("cp drv_dtmftx_report, dtmf_string=%c, string_len=%d\n", *dtmf_string, string_len);
    zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "cp drv_dtmftx_report, dtmf_string=%c, string_len=%d\n", *dtmf_string, string_len);
}
#endif
SINT32 vp_Open(T_ZDrvVoice_MODE voiceMode)
{
	SINT32 ret = DRV_SUCCESS;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open  start voiceMode = %d\n", voiceMode);

	if (g_voiceVar.vpI2sStatus !=  VP_I2S_IDLE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open error: vpI2sStatus ! =  VP_I2S_IDLE vpI2sStatus=%d\n", g_voiceVar.vpI2sStatus);
		return DRV_ERR_OPEN_TIMES;
	}

	if (g_voiceVar.vpLoopRuning == TRUE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open Err, vpLoop is Runing \n");
		return DRV_ERROR;
	}

	g_voiceVar.voiceInGsmTdMode = 0;
	g_voiceVar.voiceInVolteMode = 0;

	if (voiceMode == VOICE_GSM_MODE)
	{
		g_voiceVar.voiceInGsmTdMode = 1;
	}
	else if ((voiceMode == VOICE_LTE_MODE) || (voiceMode == VOICE_WCDMA_MODE) || (voiceMode == VOICE_TD_MODE))
	{
		g_voiceVar.voiceInVolteMode = 1;
		s_speechState.volteVpWriteStopFlag = 0;//together control vp vpstate
		s_speechState.volteVpReadStopFlag = 0;//together control vp vpstate

	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open voicemode not support !\n");
		return DRV_ERROR;
	}

	if ((NULL != s_vpState.pVpRxInBuffer) && (NULL != s_vpState.pVpTxInBuffer) && (NULL != s_vpState.pVpRxOutPutBuffer) && (NULL != s_vpState.pVpTxOutPutBuffer))
	{
		zOss_Memset(s_vpState.pVpRxInBuffer, 0, s_vpState.inOutBufSize);
		zOss_Memset(s_vpState.pVpTxInBuffer, 0, s_vpState.inOutBufSize);
		zOss_Memset(s_vpState.pVpTxOutPutBuffer, 0, s_vpState.inOutBufSize);
#ifdef _USE_VP_OUTPUT_RXOUT_DATA
        zOss_Memset(s_vpState.pVpRxOutPutBuffer, 0, s_vpState.inOutBufSize);
#else
		zOss_Memset(s_vpState.pVpRxOutPutBuffer, 0, 640);
#endif

		s_speechState.pVpTempRxInBuffer = s_vpState.pVpRxInBuffer;
		s_speechState.pVpTempTxInBuffer = s_vpState.pVpTxInBuffer;
		s_speechState.pVpTempRxOutPutBuffer = s_vpState.pVpRxOutPutBuffer;
		s_speechState.pVpTempTxOutPutBuffer = s_vpState.pVpTxOutPutBuffer;

	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open s_voiceBuffer is NULL");
		return DRV_ERROR;

	}

	ret = halVpCfg_Open(VP_VOICE_SOURCE);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open halVpCfg_Open err ret=%d !\n", ret);
		return DRV_ERROR;
	}


	if (g_voiceVar.isUseSlicCodec != 1)
	{
		ret = zDrvExtAudio_Open(TRANS_DMA_MODE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open zDrvI2S_Open(TRANS_DMA_MODE) err ret=%d ", ret);
			ret = halVpCfg_Close();
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open hal_VpCfg_Close err ret=%d", ret);
			}

			return DRV_ERROR;
		}

	}
	if (voiceMode == VOICE_GSM_MODE)
	{
		ret = zDrvI2S_Open(I2S_2, TRANS_DMA_MODE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open zDrvI2S_Open(I2S_2,TRANS_DMA_MODE) err ret=%d ", ret);
			if (g_voiceVar.isUseSlicCodec != 1)
			{
				ret = zDrvExtAudio_Close();
				if (ret != DRV_SUCCESS)
				{
					zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open zDrvI2S_Close i2s1 err ret=%d", ret);
				}
			}

			ret = halVpCfg_Close();
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open hal_VpCfg_Close err ret=%d", ret);
			}

			return DRV_ERROR;
		}
	}
	/*
	#ifdef VP_GET_TX_ALL_DATA
	    pVpTxInAllDataBuffer=(UINT8 *)0x25500000;
	    zOss_Memset(pVpTxInAllDataBuffer,0,0x100000);
	    s_TxAllDataSaveLen=0;
	#endif
	*/
#ifdef TEST_WHITE_NOISE
	pVoiceTempBuf = s_voiceTempBuffer;//for test
	tempCount = 0;
#endif
#ifdef CONFIG_CP_USE_SOFT_DTMF_DETECT
	slic_tw_dtmf_detect_open();
#endif
#ifdef CONFIG_VOICE_BUFFER_DRV  
//	INIT_COMPLETION(s_voice_copletion);
	vp_rxsem_count_Init();
	vp_txsem_count_Init();
#endif
	
	g_voiceVar.muteCount = 0;
	s_speechState.txSaveLen = 0;
	s_speechState.rxSaveLen = 0;
	s_speechState.saveLen = 0;
	s_speechState.volteVpCfgEnFlag = 0;
	s_speechState.i2sIsRstFlag = FALSE;
	s_speechState.firstWriteDataFlag = FALSE;
	s_speechState.firstReadDataFlag = FALSE;

	g_voiceVar.voiceMode = voiceMode;
	g_voiceVar.muteEn = FALSE;
	g_voiceVar.rxMuteEn = FALSE;
	g_voiceVar.vpI2sStatus = VP_I2S_OPEN;
	g_voiceVar.vProcIsNormal = FALSE;
    g_voiceVar.dtmfDirSel = DTMF_IDLE;

    if (FALSE == g_voiceVar.firstRegZCATFlag) {
        ret = zCatAgt_Audio_Reg(10,VP_INOUT_BAK_BUFFER_SIZE,(UINT32)vpInOutBuffer.p_voiceRxInBuffer);
        if(ret != DRV_SUCCESS){
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open RXIN register zCatAgt_Audio_Reg err\n");
        }
        
        ret = zCatAgt_Audio_Reg(12,VP_INOUT_BAK_BUFFER_SIZE,(UINT32)vpInOutBuffer.p_voiceTxInBuffer);
        if(ret != DRV_SUCCESS){
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open TXIN register zCatAgt_Audio_Reg err\n");
        }
            
		ret = zCatAgt_Audio_Reg(13,VP_INOUT_BAK_BUFFER_SIZE,(UINT32)vpInOutBuffer.p_voiceTxOutPutBuffer);
        if(ret != DRV_SUCCESS){
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open TXOUT register zCatAgt_Audio_Reg err\n");
        }

#ifdef _USE_VP_OUTPUT_RXOUT_DATA
		ret = zCatAgt_Audio_Reg(11, VP_INOUT_BAK_BUFFER_SIZE, (UINT32)vpInOutBuffer.p_voiceRxOutPutBuffer);
        if(ret != DRV_SUCCESS){
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open RXOUT register zCatAgt_Audio_Reg err\n");
        }

#else
		ret = zCatAgt_Audio_Reg(11,VP_INOUT_NOBAK_BUFSIZE,(UINT32)vpInOutBuffer.p_voiceRxOutPutBuffer);
        if(ret != DRV_SUCCESS){
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open RXOUT register zCatAgt_Audio_Reg err\n");
        }
#endif

        g_voiceVar.firstRegZCATFlag = TRUE;   
    }
   
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open  end!\n");
#if 0
    //dtmf检测-测试用
    dtmf_test.drv_dtmfrx_report_cb = drv_dtmfrx_report;
    dtmf_test.drv_dtmftx_report_cb = drv_dtmftx_report;
    zDrvDtmf_Detect_RegCallbacks(dtmf_test);
#endif
	return DRV_SUCCESS;

}

SINT32 vp_CfgParam(T_ZDrvVp_Cfg *cfgParam)
{
	int ret = 0;
	if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = vp_I2sCfgParam(cfgParam);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = vp_TdmCfgParam(cfgParam);
	}
    g_voiceVar.sample_rate = s_speechState.vpCfgParam.clock_rate;

    //dtmf检测启动
    if((g_voiceVar.audio_ctrlFlag.isUseRxDtmfDet == 1) || (g_voiceVar.audio_ctrlFlag.isUseTxDtmfDet == 1))
	{
        if((g_voiceVar.audio_ctrlFlag.isUseRxDtmfDet == 1) && (g_voiceVar.audio_ctrlFlag.isUseTxDtmfDet == 1))
        {
            g_voiceVar.dtmfDirSel = DTMF_TXRX;
        }
        else if(g_voiceVar.audio_ctrlFlag.isUseRxDtmfDet == 1)
        {
            g_voiceVar.dtmfDirSel = DTMF_RX;
        }
        else
        {
            g_voiceVar.dtmfDirSel = DTMF_TX;
        }

        ret = zDrvVp_DtmfSoftwareStart(g_voiceVar.dtmfDirSel , s_speechState.vpCfgParam.clock_rate);
        if (ret != DRV_SUCCESS)
        {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam zDrvVp_DtmfSoftwareStart err, ret=%d\n", ret);
        }
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam zDrvVp_DtmfSoftwareStart end\n");
    }
    
	return ret;
}

VOID zDrvVp_Status(UINT32 *sample_rate, UINT32 *voice_status)
{
    *sample_rate = g_voiceVar.sample_rate;
    *voice_status = g_voiceVar.vpI2sStatus;
}

SINT32 vp_TdmCfgParam(T_ZDrvVp_Cfg *cfgParam)
{
	SINT32 ret = DRV_SUCCESS;
	T_ZDrv_VpFs fs = VP_FS_8000;


	if ((cfgParam == NULL) || (cfgParam->channel_count != 1) || (cfgParam->bits_per_sample != 16))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam err \r\n");
		ret = DRV_ERR_INVALID_PARAM;
		goto err_exit;
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_TdmCfgParam start,cfgParam->rate = %d", cfgParam->clock_rate);
	if (((cfgParam->clock_rate == 8000) && (cfgParam->samples_per_frame != 160)) || ((cfgParam->clock_rate == 16000) && (cfgParam->samples_per_frame != 320)))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam  samples_per_frame err, cfgParam->clock_rate=%d,cfgParam->samples_per_frame=%d! \r\n", cfgParam->clock_rate, cfgParam->samples_per_frame);
		ret = DRV_ERR_INVALID_PARAM;
		goto err_exit;
	}
	s_speechState.vpCfgParam = *cfgParam;

	if ((s_vpState.s_pVpTdmCfg == NULL) || (s_vpState.s_pVpTdmWbCfg == NULL))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam error s_pVpExtI2sCfg not init! \r\n");
		ret = DRV_ERROR;
		goto err_exit;
	}
	else
	{
		if (cfgParam->clock_rate == 16000)
		{
			s_vpState.pVpTdmCfg = s_vpState.s_pVpTdmWbCfg;
			g_voiceVar.volteIsWb = 1;
			s_speechState.frameCount = cfgParam->samples_per_frame;
			s_speechState.pVpI2sCfg = s_vpState.pVpExtI2sWbCfg;
		}
		else if (cfgParam->clock_rate == 8000)
		{
			s_vpState.pVpTdmCfg = s_vpState.s_pVpTdmCfg;
			g_voiceVar.volteIsWb = 0;
			s_speechState.frameCount = cfgParam->samples_per_frame;
			s_speechState.pVpI2sCfg = s_vpState.pVpExtI2sCfg;
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam the fs not support! \r\n");
			ret = DRV_ERR_INVALID_PARAM;
			goto err_exit;
		}

		if (s_vpState.pVpTdmCfg->tTsEnable == TDM_2TS_ENABLE)
		{
			s_vpTdmReadParam.channel = AUDIO_DUAL_CHANNEL;
			s_VpTdmWriteParam.channel = AUDIO_DUAL_CHANNEL;
		}

		s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2);

		s_VpTdmWriteParam.buffersize = s_speechState.totalFrameBufSize;
		s_vpTdmReadParam.buffersize = s_speechState.totalFrameBufSize;
		s_speechState.inOutBufUseSize = s_vpState.inOutBufSize - s_speechState.totalFrameBufSize;

		if (s_vpState.pVpInnerI2sCfg->tClkMode == I2S_TIME_MODE)
		{
			if (s_vpState.pVpInnerI2sCfg->tTrackFmt == DOUBLE_TRACK)
			{
				s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2);
				(s_speechState.i2sWriteParam).channel = AUDIO_DUAL_CHANNEL;
				(s_speechState.i2sReadParam).channel = AUDIO_DUAL_CHANNEL;
			}

			else if ((s_vpState.pVpInnerI2sCfg->tTrackFmt == LEFT_TRACK) || (s_vpState.pVpInnerI2sCfg->tTrackFmt == RIGHT_TRACK))
			{
				s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2);
				(s_speechState.i2sWriteParam).channel = AUDIO_MONO_CHANNEL;
				(s_speechState.i2sReadParam).channel = AUDIO_MONO_CHANNEL;
			}
			else
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam tTrackFmt not support! \r\n");
				ret = DRV_ERR_INVALID_PARAM;
				goto err_exit;
			}

			s_speechState.i2sWriteParam.buffersize = s_speechState.totalFrameBufSize;
			s_speechState.i2sReadParam.buffersize = s_speechState.totalFrameBufSize;
		}


		s_speechState.i2sWriteParam.p_cb = NULL;
		s_speechState.i2sReadParam.p_cb = NULL;

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam Tdm read/write buffersize=%d\n", s_speechState.i2sWriteParam.buffersize);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam  VpI2sStatus=%d,s_inOutBufUseSize=%d\n", g_voiceVar.vpI2sStatus, s_speechState.inOutBufUseSize);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam set totalFrameBufSize=%d,s_vpFrameCount=%d\n", s_speechState.totalFrameBufSize, s_speechState.frameCount);
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam set read /wirte Param end! \r\n");


	if (cfgParam->clock_rate == 8000)
	{
		fs = VP_FS_8000;
	}
	else if (cfgParam->clock_rate == 16000)
	{
		fs = VP_FS_16000;

	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam the fs not support ,only support 8k,16k !\n");
		ret = DRV_ERROR;
		goto err_exit;
	}

	ret = halVpCfg_SetFs(fs);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam halVpCfg_SetFs err ret=%d !\n", ret);
		ret = DRV_ERROR;
		goto err_exit;
	}

	if ((g_voiceVar.vpPath == VP_PATH_HANDSET) || (g_voiceVar.vpPath == VP_PATH_HEADSET) || (g_voiceVar.vpPath == VP_PATH_SPEAKER))
	{
		ret = halVpCfg_SetInputPath(g_voiceVar.vpPath, TRUE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam voice_SetPahtIn halVpCfg_SetInputPath err ret=%d !\n", ret);
			ret = DRV_ERROR;
			goto err_exit;
		}
		ret = halVpCfg_SetOutputPath(g_voiceVar.vpPath, TRUE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam voice_SetPahtOut halVpCfg_SetOutputPath err ret=%d !\n", ret);
			ret = DRV_ERROR;
			goto err_exit;
		}
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam voice_SetPahtOut the path not support !\n");
		ret = DRV_ERROR;
		goto err_exit;
	}


	if (cfgParam->clock_rate == 16000)
	{
		ret = VoiceProc_Open(16000);
	}
	else if (cfgParam->clock_rate == 8000)
	{
		ret = VoiceProc_Open(8000);

	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam VoiceProc_Open fs not support\n");
		ret = DRV_ERR_INVALID_PARAM;
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam VoiceProc_Open s_voiceMode=%d, ret=%d \n", g_voiceVar.voiceMode, ret);

	if (ret == DRV_SUCCESS)
	{
		ret = VoiceProc_GetParam(g_voiceVar.voiceMode, g_voiceVar.vpPath);
		if (ret == DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " vp_CfgParam VoiceProc_GetParam OK!\r\n");
			g_voiceVar.vProcIsNormal = TRUE;
			ret = VoiceProc_SetParam(g_voiceVar.voiceMode, g_voiceVar.vpPath, g_voiceVar.vpVol, FALSE);
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam VoiceProc_SetParam ret=%d \n", ret);
			if (ret != DRV_SUCCESS)
			{
				g_voiceVar.vProcIsNormal = FALSE;
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam VoiceProc_SetParam ret=%d ,voice process don't use! \n", ret);
				VoiceProc_Close();
			}
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam VoiceProc_GetParam error ret=%d ! \r\n", ret);
			g_voiceVar.vProcIsNormal = FALSE;
			VoiceProc_Close();

		}
	}
	else
	{
		g_voiceVar.vProcIsNormal = FALSE;
	}

	return DRV_SUCCESS;
err_exit:
	if (g_voiceVar.voiceMode == VOICE_GSM_MODE)
	{
		zDrvI2S_Close(I2S_2);
	}
	if (g_voiceVar.isUseSlicCodec != 1)
	{
		zDrvExtAudio_Close();
	}
	return ret;
}


SINT32 vp_I2sCfgParam(T_ZDrvVp_Cfg *cfgParam)
{
	SINT32 ret = DRV_SUCCESS;
	T_ZDrv_VpFs fs = VP_FS_8000;

	if ((cfgParam == NULL) || (cfgParam->channel_count != 1) || (cfgParam->bits_per_sample != 16))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam err \r\n");

		ret = DRV_ERR_INVALID_PARAM;
		goto err_exit;
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam  start,cfgParam->rate = %d", cfgParam->clock_rate);
	if (((cfgParam->clock_rate == 8000) && (cfgParam->samples_per_frame != 160)) || ((cfgParam->clock_rate == 16000) && (cfgParam->samples_per_frame != 320)))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam  samples_per_frame err, cfgParam->clock_rate=%d,cfgParam->samples_per_frame=%d! \r\n", cfgParam->clock_rate, cfgParam->samples_per_frame);

		ret = DRV_ERR_INVALID_PARAM;
		goto err_exit;
	}
	s_speechState.vpCfgParam = *cfgParam;

	if ((s_vpState.pVpExtI2sCfg == NULL) || (s_vpState.pVpExtI2sWbCfg == NULL))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam error s_vpState.pVpExtI2sCfg not init! \r\n");
		ret = DRV_ERROR;
		goto err_exit;

	}
	else
	{
		if (cfgParam->clock_rate == 16000)
		{
			s_speechState.pVpI2sCfg = s_vpState.pVpExtI2sWbCfg;
			g_voiceVar.volteIsWb = 1;
			s_speechState.frameCount = cfgParam->samples_per_frame;
			s_vpState.pVpTdmCfg = s_vpState.s_pVpTdmWbCfg;

		}
		else if (cfgParam->clock_rate == 8000)
		{

			s_speechState.pVpI2sCfg = s_vpState.pVpExtI2sCfg;

			g_voiceVar.volteIsWb = 0;
			s_speechState.frameCount = cfgParam->samples_per_frame;
			s_vpState.pVpTdmCfg = s_vpState.s_pVpTdmCfg;

		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam the fs not support! \r\n");
			ret = DRV_ERR_INVALID_PARAM;
			goto err_exit;
		}

		/*
		        if((s_speechState.pVpI2sCfg->tClkMode == I2S_TIME_MODE)&&(s_speechState.pVpI2sCfg->tTrackFmt == DOUBLE_TRACK))
		        {
		            (s_speechState.i2sReadParam).channel = AUDIO_DUAL_CHANNEL;
		            (s_speechState.i2sWriteParam).channel = AUDIO_DUAL_CHANNEL;

		        }
		*/
		if (s_speechState.pVpI2sCfg->tClkMode == I2S_TIME_MODE)
		{
			if (s_speechState.pVpI2sCfg->tTrackFmt == DOUBLE_TRACK)
			{
				s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2);
				(s_speechState.i2sWriteParam).channel = AUDIO_DUAL_CHANNEL;
				(s_speechState.i2sReadParam).channel = AUDIO_DUAL_CHANNEL;
			}

			else if ((s_speechState.pVpI2sCfg->tTrackFmt == LEFT_TRACK) || (s_speechState.pVpI2sCfg->tTrackFmt == RIGHT_TRACK))
			{
				s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2);
				(s_speechState.i2sWriteParam).channel = AUDIO_MONO_CHANNEL;
				(s_speechState.i2sReadParam).channel = AUDIO_MONO_CHANNEL;
			}
			else
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam tTrackFmt not support! \r\n");

				ret = DRV_ERR_INVALID_PARAM;
				goto err_exit;

			}
			s_speechState.i2sWriteParam.buffersize = s_speechState.totalFrameBufSize;
			s_speechState.i2sReadParam.buffersize = s_speechState.totalFrameBufSize;

		}
		else if ((s_speechState.pVpI2sCfg->tClkMode == PCM_TIME_MODE) && (s_speechState.pVpI2sCfg->tPcmSlotNum == PCM_1TIME_SLOT))
		{
			s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2);
			s_speechState.i2sWriteParam.buffersize = s_speechState.totalFrameBufSize;
			s_speechState.i2sReadParam.buffersize = s_speechState.totalFrameBufSize;

		}
		else if ((s_speechState.pVpI2sCfg->tClkMode == PCM_TIME_MODE) && (s_speechState.pVpI2sCfg->tPcmSlotNum != PCM_1TIME_SLOT))
		{
			s_speechState.pcmSlotNum = s_speechState.pVpI2sCfg->tPcmSlotNum + 1;

			if (s_speechState.pVpI2sCfg->tPcmSlotNum == PCM_16TIME_SLOT)
			{
				s_speechState.pcmWbSecDataPosition = 16;
			}
			else if (s_speechState.pVpI2sCfg->tPcmSlotNum == PCM_4TIME_SLOT)
			{
				s_speechState.pcmWbSecDataPosition = 4;
			}
			else
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam s_speechState.pVpI2sCfg->tPcmSlotNum=%d,not support !\n", s_speechState.pVpI2sCfg->tPcmSlotNum);
				ret = DRV_ERROR;
				goto err_exit;

			}
			s_speechState.totalFrameBufSize = s_speechState.frameCount * 2;
			s_speechState.i2sWriteParam.buffersize = s_speechState.pcmSlotNum * s_speechState.totalFrameBufSize;
			s_speechState.i2sReadParam.buffersize = s_speechState.pcmSlotNum * s_speechState.totalFrameBufSize;
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam s_speechState.pVpI2sCfg->tClkMode=%d,not support !\n", s_speechState.pVpI2sCfg->tClkMode);
			ret = DRV_ERROR;
			goto err_exit;
		}
		s_speechState.i2sWriteParam.p_cb = NULL;
		s_speechState.i2sReadParam.p_cb = NULL;

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam I2S zDrvI2S_Write_Start buffersize=%d\n", s_speechState.i2sWriteParam.buffersize);
		s_speechState.inOutBufUseSize = s_vpState.inOutBufSize - s_speechState.totalFrameBufSize;

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam  g_voiceVar.vpI2sStatus=%d,s_speechState.inOutBufUseSize=%d\n", g_voiceVar.vpI2sStatus, s_speechState.inOutBufUseSize);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam set totalFrameBufSize=%d,s_speechState.frameCount=%d\n", s_speechState.totalFrameBufSize, s_speechState.frameCount);


	}
#if 0
	if (g_voiceVar.isUseSlicCodec != 1)
	{
		if (s_speechState.pVpI2sCfg->sample_rate != cfgParam->clock_rate)
		{
			s_speechState.pVpI2sCfg->sample_rate = cfgParam->clock_rate;
		}
	}
#endif
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam set read /wirte Param end! \r\n");


	if (cfgParam->clock_rate == 8000)
	{
		fs = VP_FS_8000;
	}
	else if (cfgParam->clock_rate == 16000)
	{
		fs = VP_FS_16000;

	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam the fs not support ,only support 8k,16k !\n");
		ret = DRV_ERROR;
		goto err_exit;
	}

	ret = halVpCfg_SetFs(fs);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam halVpCfg_SetFs err ret=%d !\n", ret);
		ret = DRV_ERROR;
		goto err_exit;

	}

	if ((g_voiceVar.vpPath == VP_PATH_HANDSET) || (g_voiceVar.vpPath == VP_PATH_HEADSET) || (g_voiceVar.vpPath == VP_PATH_SPEAKER))
	{
		ret = halVpCfg_SetInputPath(g_voiceVar.vpPath, TRUE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam voice_SetPahtIn halVpCfg_SetInputPath err ret=%d !\n", ret);
			ret = DRV_ERROR;
			goto err_exit;
		}
		ret = halVpCfg_SetOutputPath(g_voiceVar.vpPath, TRUE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam voice_SetPahtOut halVpCfg_SetOutputPath err ret=%d !\n", ret);
			ret = DRV_ERROR;
			goto err_exit;
		}
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam voice_SetPahtOut the path not support !\n");
		ret = DRV_ERROR;
		goto err_exit;
	}

	if (cfgParam->clock_rate == 16000)
	{
		ret = VoiceProc_Open(16000);
	}
	else if (cfgParam->clock_rate == 8000)
	{
		ret = VoiceProc_Open(8000);
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam VoiceProc_Open fs not support\n");
		ret = DRV_ERR_NOT_SUPPORTED;
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam VoiceProc_Open g_voiceVar.voiceMode=%d, ret=%d \n", g_voiceVar.voiceMode, ret);
	//g_voiceVar.vpPath = VP_PATH_HANDSET;
	//g_voiceVar.vpVol = VP_VOL_3;
	if (ret == DRV_SUCCESS)
	{
		//g_voiceVar.vpPath = VP_PATH_HEADSET;
		//g_voiceVar.vpVol = VP_VOL_3;
		ret = VoiceProc_GetParam(g_voiceVar.voiceMode, g_voiceVar.vpPath);
		if (ret == DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " vp_CfgParam VoiceProc_GetParam OK!\r\n");
			g_voiceVar.vProcIsNormal = TRUE;
			ret = VoiceProc_SetParam(g_voiceVar.voiceMode, g_voiceVar.vpPath, g_voiceVar.vpVol, FALSE);
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam VoiceProc_SetParam ret=%d \n", ret);
			if (ret != DRV_SUCCESS)
			{
				g_voiceVar.vProcIsNormal = FALSE;
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam VoiceProc_SetParam ret=%d ,voiceprocess don't use! \n", ret);
				VoiceProc_Close();
			}
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam VoiceProc_GetParam error ret=%d ! \r\n", ret);
			g_voiceVar.vProcIsNormal = FALSE;
			VoiceProc_Close();
		}
	}
	else
	{
		g_voiceVar.vProcIsNormal = FALSE;
	}

	return DRV_SUCCESS;
err_exit:
	if (g_voiceVar.voiceMode == VOICE_GSM_MODE)
	{
		zDrvI2S_Close(I2S_2);
	}
	if (g_voiceVar.isUseSlicCodec != 1)
	{
		zDrvExtAudio_Close();
	}
	return ret;
}

SINT32 vp_Close(T_ZDrvVoice_MODE voiceMode)
{
	SINT32 ret = DRV_SUCCESS;

	if (g_voiceVar.vpI2sStatus != VP_I2S_OPEN)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close error: g_voiceVar.vpI2sStatus != VP_I2S_OPEN g_voiceVar.vpI2sStatus=%d\n", g_voiceVar.vpI2sStatus);
		return DRV_ERROR;
	}

	if (g_voiceVar.vpI2sStatus == VP_I2S_IDLE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close: vp is closed already");
		return DRV_SUCCESS;
	}

	g_voiceVar.vpPath = VP_PATH_HANDSET;

#ifdef CONFIG_CP_USE_SOFT_DTMF_DETECT
	slic_tw_dtmf_detect_close();
#endif
	if ((voiceMode == VOICE_LTE_MODE) || (voiceMode == VOICE_WCDMA_MODE) || (voiceMode == VOICE_TD_MODE))
	{
#if 1//move from stop. lvwenhua 20150910
		ret = zDrvExtAudio_Read_Stop();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_ReadStop I2S1 Stop wrong  ret=%d \n", ret);
		}
#endif

#if 1//move from stop. lvwenhua 20150910
#ifdef VOICE_TONE_MIXER_FUNCTION
		voice_ToneMixerStop();
#endif

		ret = zDrvExtAudio_Write_Stop();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_WriteStop I2S1 Stop wrong  ret=%d \n", ret);
		}

#endif

		if (g_voiceVar.isUseSlicCodec != 1)
		{

			ret = zDrvExtAudio_Close();
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "ret=%d zDrvExtAudio_Close() \n", ret);
			}

			ret = halVpCfg_Close();
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp hal_VpCfg_Close err ret=%d", ret);
			}


		}
		zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "volte I2S Close end!\n");

		if (g_voiceVar.vProcIsNormal == TRUE)
		{
			ret = VoiceProc_Close();

			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close VoiceProc_Close wrong  ret=%d \n", ret);
			}
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close VoiceProc_Close   ret=%d \n", ret);

			g_voiceVar.vProcIsNormal = FALSE;
		}

		g_voiceVar.voiceInVolteMode = 0;
		g_voiceVar.volteIsWb = 0;

	}
	else if (voiceMode == VOICE_GSM_MODE)
	{
		g_voiceVar.voiceInGsmTdMode = 0;
		ret = halVpCfg_Close();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp hal_VpCfg_Close err ret=%d", ret);
		}

		if (s_vpState.vpThreadQuitSema != NULL)
		{
			zOss_GetSemaphore(s_vpState.vpThreadQuitSema, VOICE_SYNC_TIMEOUT_TIME);
			zOss_DeleteSemaphore(s_vpState.vpThreadQuitSema);
			s_vpState.vpThreadQuitSema = NULL;
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close,zOss_DeleteSemaphore tick=%d\n", zOss_GetTickCount());
		}

	}

    //dtmf检测关闭
    if(g_voiceVar.dtmfDirSel != DTMF_IDLE)
    {
        ret = zDrvVp_DtmfSoftwareStop();
        if (ret != DRV_SUCCESS)
    	{
    		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close zDrvVp_DtmfSoftwareStop err, ret=%d\n", ret);
    	}
        
        g_voiceVar.dtmfDirSel = DTMF_IDLE;
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close zDrvVp_DtmfSoftwareStop end\n");
    }

	g_voiceVar.vpI2sStatus = VP_I2S_IDLE;
	g_voiceVar.voiceMode = MAX_VOICE_MODE;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close,g_voiceVar.vpI2sStatus=%d\n", g_voiceVar.vpI2sStatus);

	s_speechState.i2sIsRstFlag = FALSE;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close end voiceMode = %d\n", voiceMode);

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close,s_vpState.pVpRxInBuffer=%p\n", s_vpState.pVpRxInBuffer);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close,s_vpState.pVpTxInBuffer=%p\n", s_vpState.pVpTxInBuffer);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close,s_vpState.pVpRxOutPutBuffer=%p\n", s_vpState.pVpRxOutPutBuffer);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close,s_vpState.pVpTxOutPutBuffer=%p\n", s_vpState.pVpTxOutPutBuffer);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close,s_vpState.inOutBufSize=%x\n", s_vpState.inOutBufSize);

	return DRV_SUCCESS;
}




SINT32 vp_VoiceI2sStart(VOID)
{
	SINT32 ret = DRV_SUCCESS;

	UINT8 *read_buf = NULL;
	UINT8 *write_buf = NULL;
	UINT32 read_len = 0;
	UINT32 write_len = 0;


	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart start.\n");

	if (((s_speechState.pVpI2sCfg == NULL) && (s_vpState.pVpTdmCfg == NULL)) || (s_vpState.pVpInnerI2sCfg == NULL))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart NULL err s_speechState.pVpI2sCfg=%p,s_vpState.pVpInnerI2sCfg=%p ! \n", s_speechState.pVpI2sCfg, s_vpState.pVpInnerI2sCfg);
		return DRV_ERROR;
	}

//	if (s_speechState.pVpI2sCfg->tTestMode == I2S_LOOPBACK_MODE)
//	{
//		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "is the i2s loopback mode");
//	}
#ifdef  CONFIG_VOICE_BUFFER_DRV  	
	ret = zDrvI2S_Read_Start(I2S_2, &s_speechState.i2sReadParam, s_vpState.pVpInnerI2sCfg);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S2_Read_Start failed ret is %d .\n", ret);
		return DRV_ERROR;
	}
	
	zOss_StartTimer(s_voiceTimerId, 20, voiceTimerCallBack, 0);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart zOss_StartTimer\n");

	ret = zDrvI2S_Write_Start(I2S_2, &s_speechState.i2sWriteParam, s_vpState.pVpInnerI2sCfg);

	ret += zDrvI2S_GetBuf(I2S_2, &write_buf, &write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error7:zDrvI2S_GetBuf I2S_2 ret=%d", ret);
		return DRV_ERROR;
	}
	zOss_Memset(write_buf, 0, write_len);
	ret = zDrvI2S_Write(I2S_2, write_buf, write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error12:zDrvI2S_Write I2S_2 ret=%d", ret);
	}

	voicebuffer_dlqueue_write(s_speechState.pVpTempRxOutPutBuffer, s_speechState.totalFrameBufSize);
#else	
	if (g_voiceVar.isUseSlicCodec == 1)
	{

		if (s_speechState.i2sIsRstFlag == FALSE)
		{
			ret = zDrvExtAudio_Reset();
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart zDrvExtAudio_Reset() err ret=%d ", ret);
				return DRV_ERROR;
			}
			s_speechState.i2sIsRstFlag = TRUE;
		}

	}

	ret = zDrvI2S_Read_Start(I2S_2, &s_speechState.i2sReadParam, s_vpState.pVpInnerI2sCfg);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S2_Read_Start failed ret is %d .\n", ret);
		return DRV_ERROR;
	}

	ret += zDrvExtAudio_Read_Start(&s_speechState.i2sReadParam, s_speechState.pVpI2sCfg, &s_vpTdmReadParam, s_vpState.pVpTdmCfg);

	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S1_Read_Start failed ret is %d .\n", ret);
		zDrvI2S_Read_Stop(I2S_2);
		return DRV_ERROR;
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart zDrvI2S_Read_Start  ret=%d", ret);

	ret = zDrvI2S_Read(I2S_2, &read_buf, &read_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error:zDrvI2S_Read I2S_2 ret=%d", ret);
		return DRV_ERROR;
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart zDrvI2S_Read I2S_2 ret=%d", ret);

	ret = zDrvExtAudio_Read(&read_buf, &read_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error:zDrvI2S_Read  ret=%d", ret);
		return DRV_ERROR;
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart zDrvI2S_Read I2S_1 ret=%d", ret);

	ret += zDrvExtAudio_Read_Stop();
	ret += zDrvI2S_Read_Stop(I2S_2);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error:zDrvI2S_Read  ret=%d", ret);
		return DRV_ERROR;
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart first read/write stop ret=%d", ret);

	ret += zDrvExtAudio_Read_Start(&s_speechState.i2sReadParam, s_speechState.pVpI2sCfg, &s_vpTdmReadParam, s_vpState.pVpTdmCfg);

	ret += zDrvI2S_Read_Start(I2S_2, &s_speechState.i2sReadParam, s_vpState.pVpInnerI2sCfg);

	ret += zDrvExtAudio_Write_Start(&s_speechState.i2sWriteParam, s_speechState.pVpI2sCfg, &s_VpTdmWriteParam, s_vpState.pVpTdmCfg);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error4:zDrvI2S_Write_Start  ret=%d", ret);
		return DRV_ERROR;
	}
	ret += zDrvExtAudio_GetBuf(&write_buf, &write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error5:zDrvI2S_GetBuf  ret=%d", ret);
		return DRV_ERROR;
	}

	zOss_Memset(write_buf, 0, write_len);
	ret += zDrvExtAudio_Write(write_buf, write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error6:zDrvI2S_Write  ret=%d", ret);
		return DRV_ERROR;
	}
	ret = zDrvI2S_Write_Start(I2S_2, &s_speechState.i2sWriteParam, s_vpState.pVpInnerI2sCfg);
	ret += zDrvI2S_GetBuf(I2S_2, &write_buf, &write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error7:zDrvI2S_GetBuf I2S_2 ret=%d", ret);
		return DRV_ERROR;
	}
	zOss_Memset(write_buf, 0, write_len);
	ret = zDrvI2S_Write(I2S_2, write_buf, write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error8:zDrvI2S_Write I2S_2 ret=%d", ret);
		return DRV_ERROR;
	}
	ret += zDrvExtAudio_GetBuf(&write_buf, &write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error9:zDrvI2S_GetBuf  ret=%d", ret);
		return DRV_ERROR;
	}
	zOss_Memset(write_buf, 0, write_len);
	ret += zDrvExtAudio_Write(write_buf, write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error10:zDrvI2S_Write  ret=%d", ret);
		return DRV_ERROR;
	}
	ret += zDrvI2S_GetBuf(I2S_2, &write_buf, &write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error11:zDrvI2S_GetBuf I2S_2 ret=%d", ret);
		return DRV_ERROR;
	}
	zOss_Memset(write_buf, 0, write_len);
	ret = zDrvI2S_Write(I2S_2, write_buf, write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart error12:zDrvI2S_Write I2S_2 ret=%d", ret);
	}

#endif
	
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart end.\n");
	return ret;
}
VOID vp_VoiceI2sStop(VOID)
{
	SINT32 ret = DRV_SUCCESS;

	ret = zDrvExtAudio_Read_Stop();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStop error: zDrvI2S_Read_Stop I2S1 wrong  ret=%d", ret);
	}
	ret = zDrvExtAudio_Write_Stop();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStop error: zDrvI2S_Write_Stop I2S1 wrong  ret=%d", ret);
	}

	ret = zDrvI2S_Read_Stop(I2S_2);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStop error: zDrvI2S_Read_Stop I2S2 wrong  ret=%d", ret);
	}

	ret = zDrvI2S_Write_Stop(I2S_2);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStop error: zDrvI2S_Write_Stop I2S2 wrong  ret=%d", ret);
	}

	if (g_voiceVar.vProcIsNormal == TRUE)
	{
		ret = VoiceProc_Close();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStop error: VoiceProc_Close wrong  ret=%d", ret);
		}
		g_voiceVar.vProcIsNormal = FALSE;
	}
	if (g_voiceVar.isUseSlicCodec != 1)
	{
		ret = zDrvExtAudio_Close();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStop error: zDrvI2S_Close I2S1  ret=%d", ret);
		}
	}
	ret = zDrvI2S_Close(I2S_2);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStop error: zDrvI2S_Write_Stop I2S2  ret=%d", ret);
	}

	if (s_vpState.vpThreadQuitSema != NULL)
	{
		zOss_PutSemaphore(s_vpState.vpThreadQuitSema);
	}
}

SINT32 vp_VoiceWorkStart(VOID)
{
	SINT32 ret = DRV_SUCCESS;
	//T_ZDrvI2s_Params parameter = {0};//xiu gai chu

	//UINT8 *write_buf = NULL;//xiu gai chu
	//UINT32 write_len = 0;//xiu gai chu
	//UINT8 *read_buf = NULL;//xiu gai chu
	//UINT32 read_len = 0;//xiu gai chu


	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceWorkStart start\n");

	if (g_voiceVar.vpI2sStatus != VP_I2S_OPEN)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceWorkStart error: g_voiceVar.vpI2sStatus != VP_I2S_OPEN g_voiceVar.vpI2sStatus=%d\n", g_voiceVar.vpI2sStatus);
		vp_VoiceI2sStop();
		return DRV_ERROR;
	}

	ret = halVpCfg_Enable();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_enable halVpCfg_Enable err ret=%x !\n", ret);
		vp_VoiceI2sStop();
		return DRV_ERROR;
	}

	if (s_vpState.vpThreadQuitSema == NULL)
	{
		s_vpState.vpThreadQuitSema = zOss_CreateSemaphore("VpDataThreadQuitSemaphore", 0);
		if (NULL == s_vpState.vpThreadQuitSema)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "create s_vpState.vpThreadQuitSema err \r\n");
			return DRV_ERROR;
		}
	}

	g_voiceVar.vpI2sStatus = VP_I2S_INUSE;

	if (ZOSS_SUCCESS != zOss_PutSemaphore(s_vpState.vpSemaphore))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceWorkStart put sema error.\n");
		g_voiceVar.vpI2sStatus = VP_I2S_OPEN;
		return DRV_ERROR;
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceWorkStart end,and put sema success.\n");

	return DRV_SUCCESS;
}

SINT32 zDrvVp_VoiceWorkStop(VOID)
{
	SINT32  ret = DRV_SUCCESS;

	if (g_voiceVar.vpI2sStatus != VP_I2S_INUSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_VoiceWorkStop error: g_voiceVar.vpI2sStatus != VP_I2S_INUSE g_voiceVar.vpI2sStatus=%d\n", g_voiceVar.vpI2sStatus);
		//return DRV_ERROR;
	}



#ifdef VOICE_TONE_MIXER_FUNCTION
	voice_ToneMixerStop();
#endif
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_VoiceWorkStop call voice_ToneMixerStop !\n");

	g_voiceVar.vpI2sStatus = VP_I2S_OPEN;
#ifdef  CONFIG_VOICE_BUFFER_DRV 
	//complete_all(&s_voice_completion);
	zOss_PutSemaphore(s_voiceRdSema);
	zOss_PutSemaphore(s_voiceWrSema);
	zOss_StopTimer(s_voiceTimerId);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_VoiceWorkStop zOss_StopTimer\n");
#else
	//zDrvI2s_RxRlsSemaBeforeStop(I2S_1);
	//zDrvI2s_TxRlsSemaBeforeStop(I2S_1);
	zDrvExtAudio_RlsAllSemaBeforeStop();
#endif
	zDrvI2s_RxRlsSemaBeforeStop(I2S_2);
	zDrvI2s_TxRlsSemaBeforeStop(I2S_2);

	ret = halVpCfg_Disable();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_disable halVpCfg_Disable err ret=%x !\n", ret);
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_VoiceWorkStop success");
	return DRV_SUCCESS;
}


SINT32 vp_VolteReadStart(VOID)
{
	SINT32 ret = DRV_SUCCESS;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStart start\n");

	g_voiceVar.vpI2sStatus = VP_I2S_OPEN;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "I2S_1 vp_VolteReadStart buffersize=%d\n", s_speechState.i2sReadParam.buffersize);
	if (g_voiceVar.isUseSlicCodec == 1)
	{
		if (s_speechState.i2sIsRstFlag == FALSE)
		{
			ret = zDrvExtAudio_Reset();
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStart zDrvI2S_Reset() err ret=%d ", ret);
				return DRV_ERROR;
			}
			s_speechState.i2sIsRstFlag = TRUE;
		}

	}
	if ((s_speechState.pVpI2sCfg == NULL) && (s_vpState.pVpTdmCfg == NULL))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStart  s_speechState.pVpI2sCfg is NULL! \r\n");
		return DRV_ERROR;
	}

	if (s_speechState.volteVpCfgEnFlag == 0)
	{
		ret = halVpCfg_Enable();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStart halVpCfg_Enable err ret=%x !\n", ret);
			return DRV_ERROR;
		}
		else
		{
			s_speechState.volteVpCfgEnFlag = 1;
		}
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "I2S_1 vp_VolteReadStart\n");

	ret = zDrvExtAudio_Read_Start(&s_speechState.i2sReadParam, s_speechState.pVpI2sCfg, &s_vpTdmReadParam, s_vpState.pVpTdmCfg);

	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStart failed ret is %d .\n", ret);
		return DRV_ERROR;
	}

	g_voiceVar.vpI2sStatus = VP_I2S_INUSE;
#ifdef  CONFIG_VOICE_BUFFER_DRV
	zOss_StartTimer(s_voiceTimerId, 20, voiceTimerCallBack, 0);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStart zOss_StartTimer start\n");
#endif	
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "vp_VolteReadStart \n");

	return DRV_SUCCESS;
}

SINT32 vp_VolteReadStop(VOID)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef  CONFIG_VOICE_BUFFER_DRV  
	zOss_PutSemaphore(s_voiceRdSema);
#else

	//zDrvI2s_RxRlsSemaBeforeStop(I2S_1);
	zDrvExtAudio_RxRlsSemaBeforeStop();

#if 0//move to close lvwenhua 20150910
	ret = zDrvExtAudio_Read_Stop();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_ReadStop I2S1 Stop wrong  ret=%d", ret);
	}
#endif
#endif

	if (s_speechState.volteVpCfgEnFlag == 1)
	{
		ret = halVpCfg_Disable();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStart halVpCfg_Enable err ret=%x !\n", ret);
		}
		else
		{
			s_speechState.volteVpCfgEnFlag = 0;
		}
	}

	s_speechState.volteVpReadStopFlag = 1;//together control vp s_speechState
	if ((s_speechState.volteVpWriteStopFlag == 1) && (s_speechState.volteVpReadStopFlag == 1))
	{
		g_voiceVar.vpI2sStatus = VP_I2S_OPEN;
#ifdef  CONFIG_VOICE_BUFFER_DRV  	
		zOss_StopTimer(s_voiceTimerId);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStop zOss_StopTimer\n");
#endif
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_ReadStop\n");
	return ret;
}

SINT32 vp_VolteWriteStart(VOID)
{
	SINT32 ret = DRV_SUCCESS;
	UINT8 *write_buf = NULL;
	UINT32 write_len = 0;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteWriteStart start\n");

	g_voiceVar.vpI2sStatus = VP_I2S_OPEN;

	if (g_voiceVar.isUseSlicCodec == 1)
	{
		if (s_speechState.i2sIsRstFlag == FALSE)
		{
			ret = zDrvExtAudio_Reset();
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStart zDrvI2S_Reset(I2S_1) err ret=%d ", ret);
				return DRV_ERROR;
			}
			s_speechState.i2sIsRstFlag = TRUE;

		}
	}

	if ((s_speechState.pVpI2sCfg == NULL) && (s_vpState.pVpTdmCfg == NULL))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteWriteStart  s_speechState.pVpI2sCfg is NULL! \r\n");
		return DRV_ERROR;
	}

	if (s_speechState.volteVpCfgEnFlag == 0)
	{
		ret = halVpCfg_Enable();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStart halVpCfg_Enable err ret=%x !\n", ret);
			return DRV_ERROR;
		}
		else
		{
			s_speechState.volteVpCfgEnFlag = 1;
		}
	}

	ret = zDrvExtAudio_Write_Start(&s_speechState.i2sWriteParam, s_speechState.pVpI2sCfg, &s_VpTdmWriteParam, s_vpState.pVpTdmCfg);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "I2S_1 vp_VolteWriteStart ret=%d\n", ret);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteWriteStart failed ret is %d .\n", ret);
		return DRV_ERROR;
	}

	g_voiceVar.vpI2sStatus = VP_I2S_INUSE;
#ifdef  CONFIG_VOICE_BUFFER_DRV  
	voicebuffer_dlqueue_write(s_speechState.pVpTempRxOutPutBuffer, s_speechState.totalFrameBufSize);
#else
	ret = zDrvExtAudio_GetBuf(&write_buf, &write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteWriteStart error1:zDrvI2S_GetBuf I2S_1 ret=%d", ret);
		zDrvExtAudio_Write_Stop();
		return DRV_ERROR;
	}
	zOss_Memset(write_buf, 0, write_len);
	ret = zDrvExtAudio_Write(write_buf, write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteWriteStart error2:zDrvI2S_Write I2S_1 ret=%d", ret);
		zDrvExtAudio_Write_Stop();
		return DRV_ERROR;
	}
	ret = zDrvExtAudio_GetBuf(&write_buf, &write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteWriteStart error3:zDrvI2S_GetBuf I2S_1 ret=%d", ret);
		zDrvExtAudio_Write_Stop();
		return DRV_ERROR;
	}
	zOss_Memset(write_buf, 0, write_len);
	ret = zDrvExtAudio_Write(write_buf, write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteWriteStart error4:zDrvI2S_Write I2S_1 ret=%d", ret);
		zDrvExtAudio_Write_Stop();
		return DRV_ERROR;
	}
#endif
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "vp_VolteWriteStart \n");

	return DRV_SUCCESS;
}

SINT32 vp_VolteWriteStop(VOID)
{
	SINT32  ret = DRV_SUCCESS;

#ifdef  CONFIG_VOICE_BUFFER_DRV  
	//complete_all(&s_voice_completion);
	zOss_PutSemaphore(s_voiceWrSema);
#else
	//zDrvI2s_TxRlsSemaBeforeStop(I2S_1);
	zDrvExtAudio_TxRlsSemaBeforeStop();
#endif

#if 0//move to close lvwenhua 20150910
	//wait for write drain semaphore
#ifdef VOICE_TONE_MIXER_FUNCTION
	voice_ToneMixerStop();
#endif

	ret = zDrvExtAudio_Write_Stop();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_WriteStop I2S1 Stop wrong  ret=%d", ret);
	}

	//s_VolteWriteSema = 0;
#endif

	if (s_speechState.volteVpCfgEnFlag == 1)
	{
		ret = halVpCfg_Disable();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStart halVpCfg_Enable err ret=%x !\n", ret);
		}
		else
		{
			s_speechState.volteVpCfgEnFlag = 0;
		}
	}

	s_speechState.volteVpWriteStopFlag = 1;//together control vp s_speechState
	if ((s_speechState.volteVpWriteStopFlag == 1) && (s_speechState.volteVpReadStopFlag == 1))
	{
		g_voiceVar.vpI2sStatus = VP_I2S_OPEN;
#ifdef  CONFIG_VOICE_BUFFER_DRV 
		zOss_StopTimer(s_voiceTimerId);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteWriteStop zOss_StopTimer\n");
#endif
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteWriteStop \n");
	return ret;
}


/*******************************************************************************
 * For union version
 * Others:
 ********************************************************************************/
SINT32 vp_WriteDataToCodec(UINT8 *pBuf, UINT32 count)
{
	SINT32  ret = DRV_SUCCESS;
	UINT8 *write_buf = NULL;
	UINT32 write_len = 0;
	UINT32 i = 0, j = 0;

#ifdef TEST_WHITE_NOISE
	// UINT32 tempCount = 0;
	//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "test the white noise");
	//UINT8 *pVoiceTempBuf = s_voiceTempBuffer;
#endif



	if (pBuf == NULL)
	{
		return DRV_ERR_INVALID_PARAM;
	}

	if (count != s_speechState.i2sWriteParam.buffersize)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_WriteDataToCodec write data length err,count=%d,writebuffersize=%d \n", count, s_speechState.i2sWriteParam.buffersize);
		return DRV_ERR_INVALID_PARAM;
	}


#ifdef  CONFIG_VOICE_BUFFER_DRV  	

#ifdef TEST_WHITE_NOISE

		zOss_Memcpy(s_speechState.pVpTempRxInBuffer, pVoiceTempBuf, s_speechState.totalFrameBufSize);

		pVoiceTempBuf += s_speechState.totalFrameBufSize;
		tempCount += s_speechState.totalFrameBufSize;
		if (tempCount >= 0x4df80)   //307200
			//if(tempCount >= 0x4e200)   //320000
		{
			pVoiceTempBuf = s_voiceTempBuffer;
			tempCount = 0;
		}
#endif

#ifdef VOICE_TONE_MIXER_FUNCTION

		if (mixerToneInfo.StartMixer == TRUE) 
		{
			//voice_ToneMixerData( s_speechState.pVpTempRxInBuffer);
			if ((g_voiceVar.voiceInVolteMode == 1) && (g_voiceVar.volteIsWb == 1)) 
			{
				voice_ToneMixerData(s_speechState.pVpTempRxInBuffer, 640,  s_speechState.pVpTempRxInBuffer);
			} 
			else 
			{
				voice_ToneMixerData(s_speechState.pVpTempRxInBuffer, 320,  s_speechState.pVpTempRxInBuffer);
			}

		}

#endif
	if (pBuf !=  s_speechState.pVpTempRxInBuffer)
	{
		zOss_Memcpy(s_speechState.pVpTempRxInBuffer, pBuf, s_speechState.totalFrameBufSize);
	}
    
	if (g_voiceVar.vProcIsNormal == TRUE)
	{
		VoiceProc_RxProcess(& s_speechState.pVpTempRxInBuffer, & s_speechState.pVpTempRxOutPutBuffer, s_speechState.frameCount);
	}
	else
	{
		zOss_Memcpy((VOID *)(s_speechState.pVpTempRxOutPutBuffer), (VOID *) s_speechState.pVpTempRxInBuffer, s_speechState.totalFrameBufSize);
	}
	//wait_for_completion_timeout(&s_voice_completion, 60);
	zOss_GetSemaphore(s_voiceWrSema,  60);
	voicebuffer_dlqueue_write(s_speechState.pVpTempRxOutPutBuffer, s_speechState.totalFrameBufSize);

	if (g_voiceVar.voiceInVolteMode == 1)
	{
		s_speechState.rxSaveLen += s_speechState.totalFrameBufSize;
		if (s_speechState.rxSaveLen >= s_speechState.inOutBufUseSize)
		{
			s_speechState.rxSaveLen = 0;
		}
		s_speechState.pVpTempRxInBuffer = s_vpState.pVpRxInBuffer + s_speechState.rxSaveLen;
		s_speechState.pVpTempRxOutPutBuffer = s_vpState.pVpRxOutPutBuffer;
	}

#else
	ret = zDrvExtAudio_GetBuf(&write_buf, &write_len);
	if ((ret == DRV_SUCCESS) && (write_buf != NULL) && (write_len == s_speechState.i2sWriteParam.buffersize))
	{
		if (pBuf !=  s_speechState.pVpTempRxInBuffer)
		{
			zOss_Memcpy(s_speechState.pVpTempRxInBuffer, pBuf, s_speechState.totalFrameBufSize);
		}
#if 0
#ifdef TEST_WHITE_NOISE
		zOss_Memcpy(s_speechState.pVpTempRxInBuffer, pVoiceTempBuf, VP_I2S_BUFFER_SIZE);

		pVoiceTempBuf += VP_I2S_BUFFER_SIZE;
		tempCount += VP_I2S_BUFFER_SIZE;
		if (tempCount >= 0x4E200)   //307200
		{
			pVoiceTempBuf = s_voiceTempBuffer;
			tempCount = 0;
		}
#endif
#endif
#ifdef TEST_WHITE_NOISE

		zOss_Memcpy(s_speechState.pVpTempRxInBuffer, pVoiceTempBuf, s_speechState.totalFrameBufSize);

		pVoiceTempBuf += s_speechState.totalFrameBufSize;
		tempCount += s_speechState.totalFrameBufSize;
		if (tempCount >= 0x4df80)   //307200
			//if(tempCount >= 0x4e200)   //320000
		{
			pVoiceTempBuf = s_voiceTempBuffer;
			tempCount = 0;
		}
#endif

#ifdef VOICE_TONE_MIXER_FUNCTION

		if (mixerToneInfo.StartMixer == TRUE)
		{
			//voice_ToneMixerData( s_speechState.pVpTempRxInBuffer);
			if ((g_voiceVar.voiceInVolteMode == 1) && (g_voiceVar.volteIsWb == 1))
			{
				voice_ToneMixerData(s_speechState.pVpTempRxInBuffer, 640,  s_speechState.pVpTempRxInBuffer);
			}
			else
			{
				voice_ToneMixerData(s_speechState.pVpTempRxInBuffer, 320,  s_speechState.pVpTempRxInBuffer);
			}

		}

#endif

        //dtmf检测下行写入
        if((g_voiceVar.dtmfDirSel == DTMF_RX) || (g_voiceVar.dtmfDirSel == DTMF_TXRX))
        {
            dtmfRx_RingWrite(s_speechState.pVpTempRxInBuffer);
        }

        #if 0
        //+++mixdata??????,?????
        if(g_voiceVar.audio_ctrlFlag.isUseRxMixData == 1)
        {
            if((g_voiceVar.voiceInVolteMode == 1) && (g_voiceVar.volteIsWb == 1)) 
    		{
    			voice_MixerDataRx(s_speechState.pVpTempRxInBuffer, 640,  s_speechState.pVpTempRxInBuffer);
    		} 
    		else 
    		{
    			voice_MixerDataRx(s_speechState.pVpTempRxInBuffer, 320,  s_speechState.pVpTempRxInBuffer);
    		}
        }
        #endif
        
		if (g_voiceVar.vProcIsNormal == TRUE)
		{

			ret = VoiceProc_RxProcess(& s_speechState.pVpTempRxInBuffer, & s_speechState.pVpTempRxOutPutBuffer, s_speechState.frameCount);
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "write to cdec VoiceProc_RxProcess err ret=%d !\n", ret);

			}
			//zOss_Memcpy(write_buf, s_speechState.pVpTempRxOutPutBuffer,write_len);
			//pvpRxMidBuffer= s_speechState.pVpTempRxOutPutBuffer;
		}
		else
		{
			//zOss_Memcpy(write_buf, s_speechState.pVpTempRxInBuffer,write_len);
			//pVpRxMidBuffer= s_speechState.pVpTempRxInBuffer;
			zOss_Memcpy((VOID *)(s_speechState.pVpTempRxOutPutBuffer), (VOID *) s_speechState.pVpTempRxInBuffer, s_speechState.totalFrameBufSize);

		}


		if ((s_speechState.pVpI2sCfg->tClkMode == PCM_TIME_MODE) && (s_speechState.pVpI2sCfg->tPcmSlotNum != PCM_1TIME_SLOT))
		{
			zOss_Memset(write_buf, 0, write_len);
			//for(i=0;i<VP_FRAME_BUFFER_SIZE;)
			for (i = 0; i < s_speechState.totalFrameBufSize;)
			{

				* (write_buf + j * s_speechState.pcmSlotNum) = * (s_speechState.pVpTempRxOutPutBuffer + i);
				* (write_buf + j * s_speechState.pcmSlotNum + 1) = (* (s_speechState.pVpTempRxOutPutBuffer + i + 1));
				//i+=2;
#if 1

				if (s_speechState.vpCfgParam.clock_rate == 16000)
				{

					* (write_buf + j * s_speechState.pcmSlotNum + s_speechState.pcmWbSecDataPosition) = * (s_speechState.pVpTempRxOutPutBuffer + i + 2);
					* (write_buf + j * s_speechState.pcmSlotNum + s_speechState.pcmWbSecDataPosition + 1) = (* (s_speechState.pVpTempRxOutPutBuffer + i + 3));
					i += 2;
					// j+=1;


				}
#endif
				j += 2;
				i += 2;

			}
		}
		else
		{
			zOss_Memcpy(write_buf, s_speechState.pVpTempRxOutPutBuffer, s_speechState.totalFrameBufSize);
		}


		if (g_voiceVar.voiceInVolteMode == 1)
		{
			// s_speechState.rxSaveLen += VP_FRAME_BUFFER_SIZE;
			s_speechState.rxSaveLen += s_speechState.totalFrameBufSize;
			if (s_speechState.rxSaveLen >= s_speechState.inOutBufUseSize)
			{
				s_speechState.rxSaveLen = 0;
			}
			s_speechState.pVpTempRxInBuffer = s_vpState.pVpRxInBuffer + s_speechState.rxSaveLen;
#ifdef _USE_VP_OUTPUT_RXOUT_DATA
			s_speechState.pVpTempRxOutPutBuffer = s_vpState.pVpRxOutPutBuffer + s_speechState.rxSaveLen;

#else
			s_speechState.pVpTempRxOutPutBuffer = s_vpState.pVpRxOutPutBuffer;
#endif

		}

	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_WriteDataToCodec zDrvI2S_GetBuf:I2S1:ret=%d,write_buf = %p,write_len = %d.\n", ret, write_buf, write_len);
		return DRV_ERROR;
	}
	ret = zDrvExtAudio_Write(write_buf, write_len);

#endif

	if (s_speechState.firstWriteDataFlag == FALSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_WriteDataToCodec first write ret=%d,tick=%d.\n", ret, zOss_GetTickCount());
		s_speechState.firstWriteDataFlag = TRUE;
	}

	return ret;
}


SINT32 vp_ReadDataFromCodec(UINT8 *pBuf, UINT32 count)
{
	SINT32  ret = DRV_SUCCESS;
	UINT8 *read_buf = NULL;
	UINT32 read_len = 0;
	UINT32 i = 0, j = 0;
#ifdef CONFIG_ARCH_ZX297520V3_CPE_SWITCH
	UINT8 temp8bit = 0;
	UINT8 *ptemp8bit = NULL;
#endif
	if (pBuf == NULL)
	{
		return DRV_ERR_INVALID_PARAM;
	}

	if (count != s_speechState.i2sReadParam.buffersize)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_ReadDataFromCodec read data length err,count=%d,readbuffersize=%d \n", count, s_speechState.i2sReadParam.buffersize);
		return DRV_ERR_INVALID_PARAM;
	}
#ifdef  CONFIG_VOICE_BUFFER_DRV  

//	wait_for_completion_timeout(&s_voice_completion, 60);
	zOss_GetSemaphore(s_voiceRdSema,  60);
	voicebuffer_ulqueue_read(s_speechState.pVpTempTxInBuffer,  s_speechState.totalFrameBufSize);
	if (g_voiceVar.vProcIsNormal == TRUE)
	{
		VoiceProc_TxProcess(&s_speechState.pVpTempTxInBuffer, NULL, &s_speechState.pVpTempTxOutPutBuffer, s_speechState.frameCount);	
	}
	else
	{
		zOss_Memcpy((VOID *)(s_speechState.pVpTempTxOutPutBuffer), (VOID *) s_speechState.pVpTempTxInBuffer, s_speechState.totalFrameBufSize);
	}

	if (pBuf !=  s_speechState.pVpTempTxOutPutBuffer)
	{
		zOss_Memcpy(pBuf, s_speechState.pVpTempTxOutPutBuffer, s_speechState.totalFrameBufSize);
	}
	
	if (g_voiceVar.voiceInVolteMode == 1)
	{
		// s_speechState.txSaveLen += VP_FRAME_BUFFER_SIZE;
		s_speechState.txSaveLen += s_speechState.totalFrameBufSize;
		if (s_speechState.txSaveLen >= s_speechState.inOutBufUseSize)
		{
			s_speechState.txSaveLen = 0;
		}
		s_speechState.pVpTempTxInBuffer = s_vpState.pVpTxInBuffer + s_speechState.txSaveLen;
		s_speechState.pVpTempTxOutPutBuffer = s_vpState.pVpTxOutPutBuffer + s_speechState.txSaveLen;
	}
	
#else 
	ret = zDrvExtAudio_Read(&read_buf, &read_len);
	if ((ret == DRV_SUCCESS) && (read_buf != NULL) && (read_len == s_speechState.i2sReadParam.buffersize))
	{
		if ((s_speechState.pVpI2sCfg->tClkMode == PCM_TIME_MODE) && (s_speechState.pVpI2sCfg->tPcmSlotNum != PCM_1TIME_SLOT))
		{


			//for(i=0;i<VP_FRAME_BUFFER_SIZE;)
			for (i = 0; i < s_speechState.totalFrameBufSize;)
			{
				* (s_speechState.pVpTempTxInBuffer + i) = * (read_buf + j * s_speechState.pcmSlotNum);
				* (s_speechState.pVpTempTxInBuffer + i + 1) = * (read_buf + j * s_speechState.pcmSlotNum + 1);
				// i += 2;
#if 1
				if (s_speechState.vpCfgParam.clock_rate == 16000)
				{

					* (s_speechState.pVpTempTxInBuffer + i + 2) = * (read_buf + j * s_speechState.pcmSlotNum + s_speechState.pcmWbSecDataPosition);
					* (s_speechState.pVpTempTxInBuffer + i + 3) = * (read_buf + j * s_speechState.pcmSlotNum + s_speechState.pcmWbSecDataPosition + 1);

					i += 2;
					//j+= 1;
				}
#endif
				j += 2; //one slot ,two byte
				i += 2;

			}
			//zOss_Memcpy( s_speechState.pVpTempTxInBuffer,read_buf,read_len);
		}
		else
		{
			zOss_Memcpy(s_speechState.pVpTempTxInBuffer, read_buf, s_speechState.totalFrameBufSize);
		}
		/*
		#ifdef VP_GET_TX_ALL_DATA
		        zOss_Memcpy(pVpTxInAllDataBuffer,read_buf,read_len);
		        if (read_len !=  s_speechState.i2sReadParam.buffersize)
		        {
		            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte vp_ReadDataFromCodec read_len =%d\n",read_len);

		        }
		        s_TxAllDataSaveLen+=read_len;

		        //if(s_TxAllDataSaveLen>=0x100000)
		        if (s_TxAllDataSaveLen >= 0xFA000)
		        {
		            s_TxAllDataSaveLen = 0;

		        }

		        pVpTxInAllDataBuffer=(UINT8 *)0x25500000+s_TxAllDataSaveLen;
		#endif
		*/
		ret = zDrvExtAudio_FreeBuf(read_buf);
		if (ret  != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp vp_ReadDataFromCodec err ret=%d\n", ret);
			return DRV_ERROR;
		}
	#ifdef CONFIG_CP_USE_SOFT_DTMF_DETECT
		for (i = 0; i < (s_speechState.vpCfgParam.samples_per_frame / 80); )
		{
			SINT32 dtmf_ret = DRV_SUCCESS;
			dtmf_ret = slic_tw_dtmf_detect((SINT16 *)(s_speechState.pVpTempTxInBuffer + i * 160), 80, s_speechState.vpCfgParam.clock_rate);
			i++;
			if (dtmf_ret == 0x0010) {
				g_voiceVar.muteCount = 20;
				//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp slic_tw_dtmf_detect 1 ret=%d\n", ret);
			}
			else if (dtmf_ret == 0x0000) {
				g_voiceVar.muteCount = 1;
				//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp slic_tw_dtmf_detect 2  ret=%d\n", ret);
			}
		}
#endif
//le9643
#if 0
//#ifdef CONFIG_ARCH_ZX297520V3_CPE_SWITCH


		if (g_voiceVar.audio_ctrlFlag.isUseTdm == 1)
		{
			ptemp8bit = s_speechState.pVpTempTxInBuffer;
			for (i = 0; i < s_speechState.totalFrameBufSize;)
			{
				temp8bit = *(ptemp8bit + i);
				*(ptemp8bit + i) = *(ptemp8bit + i + 1);
				*(ptemp8bit + i + 1) = temp8bit;
				i += 2;
			}
		}
#endif
        
        //dtmf检测上行写入
        if((g_voiceVar.dtmfDirSel == DTMF_TX) || (g_voiceVar.dtmfDirSel == DTMF_TXRX))
        {          
            dtmfTx_RingWrite(s_speechState.pVpTempTxInBuffer);
        }
        
        //+++mixdata??????
        if((g_voiceVar.audio_ctrlFlag.isUseTxMixData == 1) && (g_voiceVar.voiceInVolteMode == 1))
        {
            if(g_voiceVar.sample_rate == 16000)//volteIsWb????????+++++
    		{
    			voice_MixerDataTx(s_speechState.pVpTempTxInBuffer, 640,  s_speechState.pVpTempTxInBuffer);//640 ??
    		} 
    		else if(g_voiceVar.sample_rate == 8000)
    		{
    			voice_MixerDataTx(s_speechState.pVpTempTxInBuffer, 320,  s_speechState.pVpTempTxInBuffer);
    		}
        }
        
		if (g_voiceVar.vProcIsNormal == TRUE)
		{
			ret = VoiceProc_TxProcess(&s_speechState.pVpTempTxInBuffer, NULL, &s_speechState.pVpTempTxOutPutBuffer, s_speechState.frameCount);
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "read from cdec VoiceProc_TxProcess err ret=%d !\n", ret);

			}
			// zOss_Memcpy(pBuf, s_speechState.pVpTempTxOutPutBuffer,VP_FRAME_BUFFER_SIZE);
			//zOss_Memcpy(pBuf, s_speechState.pVpTempTxOutPutBuffer,s_speechState.totalFrameBufSize);
		}
		else
		{
			//zOss_Memcpy(pBuf, s_speechState.pVpTempTxInBuffer,VP_FRAME_BUFFER_SIZE);
			//zOss_Memcpy(pBuf, s_speechState.pVpTempTxInBuffer,s_speechState.totalFrameBufSize);
			zOss_Memcpy((VOID *)(s_speechState.pVpTempTxOutPutBuffer), (VOID *) s_speechState.pVpTempTxInBuffer, s_speechState.totalFrameBufSize);


		}

		if (g_voiceVar.isUseSlicCodec == 1)
		{
			if (g_voiceVar.muteCount > 0)
			{
				memset(s_speechState.pVpTempTxOutPutBuffer, 0, count);
				g_voiceVar.muteCount--;
			}
		}
		if (pBuf !=  s_speechState.pVpTempTxOutPutBuffer)
		{
			zOss_Memcpy(pBuf, s_speechState.pVpTempTxOutPutBuffer, s_speechState.totalFrameBufSize);
		}
		if (g_voiceVar.voiceInVolteMode == 1)
		{
			// s_speechState.txSaveLen += VP_FRAME_BUFFER_SIZE;
			s_speechState.txSaveLen += s_speechState.totalFrameBufSize;
			if (s_speechState.txSaveLen >= s_speechState.inOutBufUseSize)
			{
				s_speechState.txSaveLen = 0;
			}
			s_speechState.pVpTempTxInBuffer = s_vpState.pVpTxInBuffer + s_speechState.txSaveLen;
			s_speechState.pVpTempTxOutPutBuffer = s_vpState.pVpTxOutPutBuffer + s_speechState.txSaveLen;
		}

	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " vp vp_ReadDataFromCodec zDrvI2S_Read:I2S1:ret=%d,read_buf = %p,read_len = %d.\n", ret, read_buf, read_len);
		return DRV_ERROR;
	}

#endif
	
	if (s_speechState.firstReadDataFlag == FALSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_ReadDataFromCodec first read tick=%d.\n", zOss_GetTickCount());
		s_speechState.firstReadDataFlag = TRUE;
	}

	return ret;
}


static VOID  vp_DataProcessThreadEntry(SINT32 argu)
{
	SINT32 ret = DRV_SUCCESS;

	UINT8 *read_buf = NULL;
	UINT8 *write_buf = NULL;
	UINT32 read_len = 0;
	UINT32 write_len = 0;

	//UINT8 * s_speechState.pVpTempRxInBuffer = NULL;
	//UINT8 * s_speechState.pVpTempTxInBuffer = NULL;

	//UINT8 * s_speechState.pVpTempRxOutPutBuffer = NULL;
	//UINT8 * s_speechState.pVpTempTxOutPutBuffer = NULL;


	//UINT32 i = 0;//xiu gai chu

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_DataProcessThreadEntry \n");

	while (1)
	{
		g_voiceVar.vpLoopRuning = FALSE;

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_DataProcessThreadEntry wait s_vpState.vpSemaphore!\n");

		zOss_GetSemaphore(s_vpState.vpSemaphore, ZOSS_WAIT_FOREVER);
		g_voiceVar.vpLoopRuning = TRUE;
		// s_speechState.pVpTempRxInBuffer = s_vpState.pVpRxInBuffer;
		// s_speechState.pVpTempTxInBuffer = s_vpState.pVpTxInBuffer;

		// s_speechState.pVpTempRxOutPutBuffer = s_vpState.pVpRxOutPutBuffer;
		// s_speechState.pVpTempTxOutPutBuffer = s_vpState.pVpTxOutPutBuffer;

		//#ifdef TEST_WHITE_NOISE
		//pVoiceTempBuf = s_voiceTempBuffer;//for test
		//#endif
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_DataProcessThreadEntry g_voiceVar.vpI2sStatus %d!\n", g_voiceVar.vpI2sStatus);

		if (g_voiceVar.vpI2sStatus != VP_I2S_INUSE)
		{
			vp_VoiceI2sStop();
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_DataProcessThreadEntry  g_voiceVar.vpI2sStatus != VP_I2S_INUSE!\n");
			continue;
		}

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_DataProcessThreadEntry start vp_VoiceI2sStart!\n");

		ret = vp_VoiceI2sStart();
		if (ret != DRV_SUCCESS)
		{
			vp_VoiceI2sStop();
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_DataProcessThreadEntry error: vp_VoiceI2sStart!\n");
			continue;
		}

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_DataProcessThreadEntry data process start!\n");
		zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "voice vp_DataProcessThreadEntry work start!\n");

		while (g_voiceVar.vpI2sStatus == VP_I2S_INUSE)
		{
			/*downlink:read from teak*/
			//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "downlink:i2s2 read from teak\n");
			ret = zDrvI2S_Read(I2S_2, &read_buf, &read_len);

			//zOss_ASSERT(read_buf != NULL);
			//zOss_ASSERT(read_len != 0);
#if 0
			if (s_speechState.saveLen == 3200)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_Read:I2S2:ret=%d,read_buf = %x,read_len = %d.\n", ret, read_buf, read_len);
			}
#endif
			//if(ret == DRV_SUCCESS)
			if ((ret == DRV_SUCCESS) && (read_buf != NULL) && (read_len != 0))
			{
				zOss_Memcpy(s_speechState.pVpTempRxInBuffer, read_buf, s_speechState.totalFrameBufSize);

			}
			else
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_Read:I2S2:ret=%d,read_buf = %p,read_len = %d.\n", ret, read_buf, read_len);
				break;
			}
			ret = zDrvI2S_FreeBuf(I2S_2, read_buf);
			if (ret != DRV_SUCCESS)
			{	/*coverity medium PRINTF_ARGS 把%x换成%p*/
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_FreeBuf:I2S_2:ret=%d,read_buf = %p.\n", ret, read_buf);
				break;
			}

			if (g_voiceVar.vpI2sStatus != VP_I2S_INUSE)
			{
				break;
			}

			/*downlink:voice process*/
			vp_WriteDataToCodec(s_speechState.pVpTempRxInBuffer, s_speechState.i2sWriteParam.buffersize);
#if 0
			if (g_voiceVar.vProcIsNormal == TRUE)
				ret = VoiceProc_RxProcess(& s_speechState.pVpTempRxInBuffer, & s_speechState.pVpTempRxOutPutBuffer);
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_DataProcessThreadEntry error:VoiceProc_RxProcess :ret=%d.\n", ret);
				break;
			}
			//zOss_Memcpy((VOID *)( s_speechState.pVpTempRxOutPutBuffer), (VOID *) s_speechState.pVpTempRxInBuffer, VP_I2S_BUFFER_SIZE);
		}
		else
		{
			zOss_Memcpy((VOID *)(s_speechState.pVpTempRxOutPutBuffer), (VOID *) s_speechState.pVpTempRxInBuffer, 320);
		}

		if (g_voiceVar.vpI2sStatus != VP_I2S_INUSE)
		{
			break;
		}

#if 1
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "downlink:i2s1 write to codec\n");
		/*downlink:write to codec*/
		ret = zDrvExtAudio_GetBuf(&write_buf, &write_len);

		//zOss_ASSERT(write_buf != NULL);
		//zOss_ASSERT(write_len != 0);
#if 0
		if (s_speechState.saveLen == 3200)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_GetBuf:I2S1:ret=%d,write_buf = %x,write_len = %d.\n", ret, write_buf, write_len);
		}
#endif
		//if(ret == DRV_SUCCESS)
		if ((ret == DRV_SUCCESS) && (write_buf != NULL) && (write_len != 0))
		{

			if ((s_vpState.pVpExtI2sCfg->tClkMode == PCM_TIME_MODE) && (s_vpState.pVpExtI2sCfg->tPcmSlotNum != PCM_1TIME_SLOT))
			{
				//It is used for xinke to set teak voice gain when open  lvwenhua 20150709
				zOss_Memset(write_buf, 0, write_len);
				for (i = 0; i < VP_I2S_BUFFER_SIZE;)
				{
					* (write_buf + i * (s_vpState.pVpExtI2sCfg->tPcmSlotNum + 1)) = * (s_speechState.pVpTempRxOutPutBuffer + i);
					* (write_buf + i * (s_vpState.pVpExtI2sCfg->tPcmSlotNum + 1) + 1) = * (s_speechState.pVpTempRxOutPutBuffer + i + 1);
					i += 2;
				}
			}
			else

			{
				zOss_Memcpy(write_buf, s_speechState.pVpTempRxOutPutBuffer, VP_I2S_BUFFER_SIZE);
				//zOss_Memcpy(write_buf, s_speechState.pVpTempRxInBuffer,320);
			}
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "write else zDrvI2S_GetBuf:I2S1:ret=%d,write_buf = %x,write_len = %d.\n", ret, write_buf, write_len);
			break;
		}
		ret = zDrvExtAudio_Write(write_buf, write_len);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_Write:I2S_1:ret=%d,write_buf = %x,write_len = %d.\n", ret, write_buf, write_len);
			break;
		}

#endif
#endif
		if (g_voiceVar.vpI2sStatus != VP_I2S_INUSE)
		{
			break;
		}

		/*uplink:read from codec*/
		// zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "downlink:i2s1 read from codec\n");
		vp_ReadDataFromCodec(s_speechState.pVpTempTxOutPutBuffer, s_speechState.i2sReadParam.buffersize);
#if 0
		ret = zDrvExtAudio_Read(&read_buf, &read_len);

		//zOss_ASSERT(read_buf != NULL);
		//zOss_ASSERT(read_len != 0);
#if 0

		if (s_speechState.saveLen == 3200)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_GetBuf:I2S1:ret=%d,read_buf = %x,read_len = %d.\n", ret, read_buf, read_len);
		}
#endif
		//if(ret == DRV_SUCCESS)
		if ((ret == DRV_SUCCESS) && (read_buf != NULL) && (read_len != 0))
		{
			if ((s_vpState.pVpExtI2sCfg->tClkMode == PCM_TIME_MODE) && (s_vpState.pVpExtI2sCfg->tPcmSlotNum != PCM_1TIME_SLOT))
			{
				//It is used for xinke to set teak voice gain when open  lvwenhua 20150709
				for (i = 0; i < VP_I2S_BUFFER_SIZE;)
				{
					* (s_speechState.pVpTempTxInBuffer + i) = * (read_buf + i * (s_vpState.pVpExtI2sCfg->tPcmSlotNum + 1));
					* (s_speechState.pVpTempTxInBuffer + i + 1) = * (read_buf + i * (s_vpState.pVpExtI2sCfg->tPcmSlotNum + 1) + 1);
					i += 2;
				}
			}
			else
			{
				zOss_Memcpy(s_speechState.pVpTempTxInBuffer, read_buf, VP_I2S_BUFFER_SIZE);
			}
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_Read:I2S1:ret=%d,read_buf = %p,read_len = %d.\n", ret, read_buf, read_len);
			break;
		}
		ret = zDrvExtAudio_FreeBuf(read_buf);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_FreeBuf:I2S1:ret=%d,read_buf = %x.\n", ret, read_buf);
			break;
		}

		if (g_voiceVar.vpI2sStatus != VP_I2S_INUSE)
		{
			break;
		}

		/*uplink:voice process*/
		if (g_voiceVar.vProcIsNormal == TRUE)
			ret = VoiceProc_TxProcess(& s_speechState.pVpTempTxInBuffer, NULL, & s_speechState.pVpTempTxOutPutBuffer);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_DataProcessThreadEntry error:VoiceProc_TxProcess :ret=%d.\n", ret);
			break;
		}
		//zOss_Memcpy((VOID *)( s_speechState.pVpTempTxOutPutBuffer), (VOID *) s_speechState.pVpTempTxInBuffer, VP_I2S_BUFFER_SIZE);
	}
	else
	{

		//no nxp lib lwenhua 20150317
		//VoiceProc_TxProcess(& s_speechState.pVpTempTxInBuffer, NULL, & s_speechState.pVpTempTxOutPutBuffer);
		zOss_Memcpy((VOID *)(s_speechState.pVpTempTxOutPutBuffer), (VOID *) s_speechState.pVpTempTxInBuffer, 320);
	}
#endif


	if (g_voiceVar.vpI2sStatus != VP_I2S_INUSE)
	{
		break;
	}

	/*uplink:write to teak*/
	//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "downlink:i2s2 write to teak\n");
	ret = zDrvI2S_GetBuf(I2S_2, &write_buf, &write_len);

	//zOss_ASSERT(write_buf != NULL);
	//zOss_ASSERT(write_len != 0);
#if 0

	if (s_speechState.saveLen == 3200)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_GetBuf:I2S2:ret=%d,write_buf = %x,write_len = %d.\n", ret, write_buf, write_len);
	}
#endif
	//if(ret == DRV_SUCCESS)
	if ((ret == DRV_SUCCESS) && (write_buf != NULL) && (write_len != 0))
	{
		zOss_Memcpy(write_buf, s_speechState.pVpTempTxOutPutBuffer, s_speechState.totalFrameBufSize);
		//zOss_Memcpy(write_buf, s_speechState.pVpTempTxInBuffer,320);
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_GetBuf:I2S2:ret=%d,write_buf = %p,write_len = %d.\n", ret, write_buf, write_len);
		break;
	}
	ret = zDrvI2S_Write(I2S_2, write_buf, write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_Write:I2S2:ret=%d,write_buf = %p,write_len = %d.\n", ret, write_buf, write_len);
		break;
	}
#if 0
	if (s_speechState.saveLen == 3200)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_DataProcessThreadEntry:  s_speechState.saveLen = %d.\n",  s_speechState.saveLen);
	}
#endif
	//if( s_speechState.saveLen < VP_BUF_LENGTH)
	{
		s_speechState.saveLen += s_speechState.totalFrameBufSize;
		if (s_speechState.saveLen >= s_speechState.inOutBufUseSize)
		{
			s_speechState.saveLen = 0;
		}
		s_speechState.pVpTempRxInBuffer = s_vpState.pVpRxInBuffer + s_speechState.saveLen;
		s_speechState.pVpTempTxInBuffer = s_vpState.pVpTxInBuffer + s_speechState.saveLen;
		s_speechState.pVpTempTxOutPutBuffer = s_vpState.pVpTxOutPutBuffer +  s_speechState.saveLen;
#ifdef _USE_VP_OUTPUT_RXOUT_DATA
		s_speechState.pVpTempRxOutPutBuffer = s_vpState.pVpRxOutPutBuffer +  s_speechState.saveLen;
#else
		s_speechState.pVpTempRxOutPutBuffer = s_vpState.pVpRxOutPutBuffer;
#endif
	}
}

vp_VoiceI2sStop();
zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_DataProcessThreadEntry work end.\n");
zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "voice vp_DataProcessThreadEntry work end!\n");

}
}

#ifdef  _OS_TOS
static void vp_rcvDtmfThread(SINT32 argu)
{
	int ret = 0;

	s_vpState.pMsg.actorID = ICP_MSG_ACTOR_A9;
	s_vpState.pMsg.chID = DTMF;
	s_vpState.pMsg.flag &= ~RPMSG_READ_POLL;
	s_vpState.pMsg.buf = s_vpState.pMsgBuf;
	s_vpState.pMsg.len = 8;

	ret = zDrvRpMsg_CreateChannel(ICP_MSG_ACTOR_A9, DTMF, 0x10);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvRpMsg_CreateChannel ret %d", ret);
	while (1)
	{
		ret = zDrvRpMsg_Read(&s_vpState.pMsg);
		if (g_voiceVar.vpI2sStatus == VP_I2S_INUSE)
		{
			g_voiceVar.muteCount = 20;
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "mute");
		}
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvRpMsg_Read ret %d", ret);
	}
}
#endif

#ifdef _OS_LINUX
VOID  zDrvVp_SetDtmfMute_Wrap(VOID)
{
	if (g_voiceVar.vpI2sStatus == VP_I2S_INUSE)
	{
		g_voiceVar.muteCount = 20;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "dtmf mute\n");
	}
}
#endif

SINT32 vp_CreateThreadSemaph(VOID)
{
	s_vpState.vpSemaphore = zOss_CreateSemaphore("VpI2sReadWriteSemaphore", 0);
#ifdef _USE_WEBRTC_AUD
	s_vpState.vpThread = zOss_CreateThread("vp_DataProcessThreadEntry", vp_DataProcessThreadEntry, 0, 8192, 15, 0, 1);
#else
	s_vpState.vpThread = zOss_CreateThread("vp_DataProcessThreadEntry", vp_DataProcessThreadEntry, 0, 1024, 15, 0, 1);
#endif

#ifdef  _OS_TOS


	if (g_voiceVar.isUseSlicCodec == 1)
	{
		s_vpState.rcvDtmfThread = zOss_CreateThread("vp_rcvDtmfThread", vp_rcvDtmfThread, 0, 1024, 10, 0, 1);
		if (NULL == s_vpState.rcvDtmfThread)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "create vp Thread s_vpState.rcvDtmfThread err \r\n");
			return DRV_ERROR;
		}
	}
#endif

	if ((NULL == s_vpState.vpThread) || (NULL == s_vpState.vpSemaphore))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "create vp Thread sem err s_vpState.vpThread=%p,s_vpState.vpSemaphore=%p !\r\n", s_vpState.vpThread, s_vpState.vpSemaphore);
		return DRV_ERROR;
	}
#ifdef CONFIG_VOICE_BUFFER_DRV  	
//	init_completion(&s_voice_completion);
	s_voiceRdSema = zOss_CreateSemaphore("voice_rx_sem", 0);
	if(NULL == s_voiceRdSema) {
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "create iis1_rx_sem err \n");
		return DRV_ERROR;
	}

	s_voiceWrSema  = zOss_CreateSemaphore("voice_tx_sem", 0);
	if(NULL == s_voiceWrSema) {
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "create iis2_rx_sem err \n");
		return DRV_ERROR;
	}
	
	 s_voiceTimerId  = zOss_CreateTimer("voice_frameTimer", voiceTimerCallBack, 0, TRUE);
	 zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "s_voiceTimerId=%p\n", s_voiceTimerId);
	if(!s_voiceTimerId)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_frameTimer  failed\n");
		return DRV_ERROR;
	}
#endif
	
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CreateThreadSemaph success. \r\n");
	return DRV_SUCCESS;
}

SINT32 vp_CreateLoopThreadSemaph(VOID)
{
	s_vpState.vpLoopSemaphore = zOss_CreateSemaphore("VpLoopSemaphore", 0);
#ifdef _USE_WEBRTC_AUD//该宏控制VoiceProc_TxProcess函数调用webrtc的云后处理，此时创建线程时应设为8K，否则栈溢出
	s_vpState.vpLoopThread = zOss_CreateThread("VpLoopThread", vp_LoopProcessThreadEntry, 0, 8192, 16, 0, 1);
#else
    s_vpState.vpLoopThread = zOss_CreateThread("VpLoopThread", vp_LoopProcessThreadEntry, 0, 1024, 16, 0, 1);
#endif

	if ((NULL == s_vpState.vpLoopThread) || (NULL == s_vpState.vpLoopSemaphore))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "create vp Loop Thread sem err \r\n");
		return DRV_ERROR;
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CreateLoopThreadSemaph success. \r\n");
	return DRV_SUCCESS;
}

SINT32 zDrvVp_Init(VOID)
{
	SINT32  ret = DRV_SUCCESS;

	ret = VoiceProc_InitNvParam();
	if (ret != DRV_SUCCESS)
	{
		return ZOSS_ERROR;
	}

	ret = vp_CreateThreadSemaph();
	if (ret != DRV_SUCCESS)
	{
		return ZOSS_ERROR;
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Init create success.\n");

	voice_InitCodec();

	ret = voice_CreateRcdSemAndThread();

	if (ret != DRV_SUCCESS)
	{
		return ZOSS_ERROR;
	}

	ret = vp_CreateLoopThreadSemaph();
	if (ret != DRV_SUCCESS)
	{
		return ZOSS_ERROR;
	}
	ret = zDrv_Init();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S__Init error.\n");
		return ZOSS_ERROR;
	}

	vp_SetTopConfig();
	//vp_SetTopI2sConfig();

	if (g_voiceVar.isUseSlicCodec == 1)
	{
		//added by zhanglixia
		ret = zDrvExtAudio_Open(TRANS_DMA_MODE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Init ret=%d zDrvI2S_Open(I2S_1,TRANS_DMA_MODE) \n", ret);
			return DRV_ERROR;
		}

#if 0
		if (s_vpState.pVpExtI2sCfg == NULL)
		{
			s_vpState.pVpExtI2sCfg = &s_VpExtI2sCfg;
		}

		if (s_pVpI2s1Cfg->tClkMode == PCM_TIME_MODE)
		{
			s_VpExtI2sparameter.buffersize = (s_pVpI2s1Cfg->tPcmSlotNum + 1) * VP_I2S_BUFFER_SIZE;
		}
#endif

		if (s_vpState.pVpExtI2sCfg != NULL || s_vpState.s_pVpTdmCfg != NULL)
		{
			//ret += tdm_clkConfigure(s_vpState.s_pVpTdmCfg);
			ret += zDrvExtAudio_Read_Prepare(s_vpState.pVpExtI2sCfg , s_vpState.s_pVpTdmCfg);
			if (ret != DRV_SUCCESS)
			{
				// zDrvI2S_Read_Stop(I2S_2);
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Init zDrvI2S_Read_Prepare err \n");
				return DRV_ERROR;
			}
			ret += zDrvExtAudio_Write_Prepare(s_vpState.pVpExtI2sCfg , s_vpState.s_pVpTdmCfg);
			if (ret != DRV_SUCCESS)
			{
				// zDrvI2S_Read_Stop(I2S_2);
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Init zDrvI2S_Write_Prepare err \n");
				return DRV_ERROR;
			}
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Init s_vpState.pVpExtI2sCfg is NULL \n");
			return DRV_ERROR;
		}

	}
#ifndef _USE_AUDIO_ON_7510
	ret = zDrvVoice_Initiate();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Init zDrvVoice_Initiate  fail ret=%d!\n", ret);
		return DRV_ERROR;
	}
#endif
	ret = zDrvVolte_Initiate();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Init  zDrvVolte_Initiate fail ret=%d!\n", ret);
		return DRV_ERROR;
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Init zDrvVolte_Initiate end \n");

	return ZOSS_SUCCESS;
}


/*******************************************************************************
 * Function: zDrvVp_SetExtI2sCfg
 * Description: This function is used to set voice process buffers.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvVp_SetExtAudioCfg(T_ZDrvI2S_Cfg *pI2sNbCfg, T_ZDrvI2S_Cfg *pI2sWbCfg,
                             T_ZDrvTdm_Cfg *pTdmNbCfg, T_ZDrvTdm_Cfg *pTdmWbCfg)
{
	SINT32  ret = DRV_SUCCESS;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetExtCfg!");
	//if(g_voiceVar.g_isUseTdm != 1)
	{
		s_vpState.pVpExtI2sCfg  = pI2sNbCfg;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetExtCfg  s_vpState.pVpExtI2sCfg =0x%p!\r\n", s_vpState.pVpExtI2sCfg);
		s_vpState.pVpExtI2sWbCfg = pI2sWbCfg;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetExtCfg  s_vpState.pVpExtI2sWbCfg = 0x%p!\r\n", s_vpState.pVpExtI2sWbCfg);
	}
	//else if(g_voiceVar.g_isUseTdm == 1)
	{
		s_vpState.s_pVpTdmCfg = pTdmNbCfg;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetExtCfg  s_pVpTdmCfg =0x%p!\r\n", s_vpState.s_pVpTdmCfg);
		s_vpState.s_pVpTdmWbCfg = pTdmWbCfg;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetExtCfg  s_pVpTdmWbCfg = 0x%p!\r\n", s_vpState.s_pVpTdmWbCfg);
	}
	return ret;
}
SINT32 zDrvVp_SetExtI2sCfg(T_ZDrvI2S_Cfg *pI2sNbCfg, T_ZDrvI2S_Cfg *pI2sWbCfg)
{
	SINT32  ret = DRV_SUCCESS;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetExtI2sCfg!");

	s_vpState.pVpExtI2sCfg = pI2sNbCfg;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetExtI2sCfg  s_vpState.pVpExtI2sCfg =0x%p! \r\n", s_vpState.pVpExtI2sCfg);
	s_vpState.pVpExtI2sWbCfg = pI2sWbCfg;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetExtI2sCfg  s_vpState.pVpExtI2sWbCfg  = 0x%p! \r\n", s_vpState.pVpExtI2sWbCfg);

	return ret;
}
#if 0
//obsolete
SINT32 zDrvVolte_SetI2sCfg(T_ZDrvI2S_Cfg *pI2sCfg)
{
	zDrvVp_SetExtI2sCfg(pI2sCfg, NULL);
	return 0;//xiu gai chu tian jia return 0
}
//obsolete
SINT32 zDrvVp_SetI2sCfg(T_ZDrvI2S_Cfg *pI2sCfg)
{
	zDrvVp_SetExtI2sCfg(pI2sCfg, NULL);
	return 0;//xiu gai chu tian jia return 0
}
#endif
//connect to teaklit
SINT32 zDrvVp_SetInnerI2sCfg(T_ZDrvI2S_Cfg *pI2sCfg)
{
	SINT32  ret = DRV_SUCCESS;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetInnerI2sCfg!\n");
	if (pI2sCfg == NULL)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetInnerI2sCfg error: pI2sCfg == NULL\n");
		return DRV_ERR_INVALID_PARAM;
	}
	s_vpState.pVpInnerI2sCfg = pI2sCfg;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetInnerI2sCfg  s_vpState.pVpInnerI2sCfg =%p! \r\n", s_vpState.pVpInnerI2sCfg);
	if (s_vpState.pVpInnerI2sCfg->bMaster == TRUE)
	{
		g_voiceVar.innerI2sIsMaster = TRUE;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetInnerI2sCfg InnerArmI2s is mater\n");
	}
	else
	{
		g_voiceVar.innerI2sIsMaster = FALSE;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetInnerI2sCfg InnerArmI2s is slave\n");

	}

	if (s_vpState.pVpInnerI2sCfg->tClkMode == I2S_TIME_MODE)
	{
		g_voiceVar.innerI2sIsI2sMode = TRUE;
#if PS_RAT_GSM
		zDrvAud_DspSetAudSetting(TRUE);
#endif
	}
	else
	{
		g_voiceVar.innerI2sIsI2sMode = FALSE;
#if PS_RAT_GSM
		zDrvAud_DspSetAudSetting(FALSE);
#endif
	}

	return ret;

}



/*******************************************************************************
 * Function: zDrvVoiceConfig_SetVpBuffer
 * Description: This function is used to set voice process buffers.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/

SINT32 zDrvVp_SetInOutBufferAddSize(T_ZDrv_VpInOutBuffer *pInOutBuffer, UINT32  bufSize)
{
	//SINT32  ret = DRV_SUCCESS;//xiu gai chu

	if (pInOutBuffer == NULL)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_SetVpBuffer error: pInOutBuffer== NULL");
		return DRV_ERR_INVALID_PARAM;
	}

	if ((pInOutBuffer->p_voiceRxInBuffer == NULL) || (pInOutBuffer->p_voiceRxOutPutBuffer == NULL) || (pInOutBuffer->p_voiceTxInBuffer == NULL) || (pInOutBuffer->p_voiceTxOutPutBuffer == NULL))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_SetVpBuffer error: Buffer== NULL");
		return DRV_ERR_MEM_ALLOC;
	}

	s_vpState.pVpRxInBuffer = pInOutBuffer->p_voiceRxInBuffer;//size >=0.5M
	s_vpState.pVpTxInBuffer = pInOutBuffer->p_voiceTxInBuffer ;//size >=0.5M
	s_vpState.pVpRxOutPutBuffer = pInOutBuffer->p_voiceRxOutPutBuffer;//size =640
	s_vpState.pVpTxOutPutBuffer = pInOutBuffer->p_voiceTxOutPutBuffer ;//size >=0.5M
	s_vpState.inOutBufSize = bufSize;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_SetVpBuffer success!");

	return DRV_SUCCESS;

}

#if 0
//obsolete
SINT32 zDrvVp_SetInOutBuffer(T_ZDrv_VpInOutBuffer *pInOutBuffer)
{
	zDrvVp_SetInOutBufferAddSize(pInOutBuffer, 524288);
	return 0;//xiu gai chu tian jia return 0
}
//obsolete
SINT32 zDrvVolte_SetInOutBuffer(T_ZDrv_VpInOutBuffer *pInOutBuffer)
{
	zDrvVp_SetInOutBufferAddSize(pInOutBuffer, 524288);
//It is used for xinke to set teak voice gain when open  lvwenhua 20150709
	return 0;//xiu gai chu tian jia return 0
}
SINT32 zDrvVp_SetGain(SINT32 vgain, UINT32 channel)
{
	SINT32  ret = DRV_SUCCESS;

	if ((vgain < -25) || (vgain > 10))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetGain vgain invalid ,vgain=%d!\n", vgain);
		return DRV_ERR_INVALID_PARAM;
	}
	if ((channel < 0) || (channel > 1))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetGain channel invalid ,channel=%d!\n", channel);
		return DRV_ERR_INVALID_PARAM;

	}

	if (g_voiceVar.vpI2sStatus == VP_I2S_IDLE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_SetGain: vpstatus not support to set gain  !\n");
		return DRV_ERROR;
	}
	else
	{
		ret = VoiceProc_SetGain(vgain, channel, g_voiceVar.vpPath);
	}
	return ret;


}
#endif

SINT32 zDrvVp_SetInitGain(UINT8 value)
{
	if (value > 100)
	{
		return DRV_ERR_INVALID_PARAM;
	}

	g_voiceVar.vpInitGain = value;
	return ZOSS_SUCCESS;
}

#ifdef _USE_VOICE_RCD
SINT32 zDrvVp_RcdOnOff(UINT32 on)
{
	SINT32  ret = DRV_SUCCESS;
	T_ZDrvRcd_InfoParam Param = {RECORD_DATA_FORMAT_AMR, 32, VOICE_RECORD_UPLINK_AND_DOWNLINK};

	if (0 == on)
	{
		ret = voice_RcdStop();
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_RcdStop ret=%d!\n", ret);
	}
	else if (1 == on)
	{
		ret = voice_RcdStart(&Param);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_RcdStart ret=%d!\n", ret);
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RcdOnOff para error!\n");
		return DRV_ERROR;

	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RcdOnOff on=%d,ret=%d!", on, ret);
	return ret;

}
#endif
#ifdef _USE_DTMF_TONE

SINT32 zDrvVp_DtmfTone(UINT32 Num)
{
	SINT32  ret = DRV_SUCCESS;
	if ((Num > 11) || (Num < 0))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfTone invalid Num=%d!\n", Num);
		return DRV_ERR_INVALID_PARAM;
	}
	if (g_voiceVar.vpI2sStatus != VP_I2S_INUSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_DtmfTone cannot call!\n");
		return 	DRV_ERR_NOT_SUPPORTED;
	}

	// ret = zDrv_DtmfToneStart( Num);

	return ret;
}
#endif
static VOID  vp_LoopProcessThreadEntry(SINT32 argu)
{
	SINT32 ret = DRV_SUCCESS;

	UINT8 *read_buf = NULL;
	UINT8 *write_buf = NULL;
	UINT32 read_len = 0;
	UINT32 write_len = 0;

	//UINT32 loop_point = 0;//xiu gai chu
	UINT32 loopCount = s_vpState.inOutBufSize - 320;

#ifdef TEST_WHITE_NOISE
	UINT32 tempLoopCount = 0;
	UINT8 *pVoiceLoopTempBuf = NULL;

#endif
	UINT32 i = 0;

	zOss_Memset(s_vpState.pVpRxInBuffer, 0, s_vpState.inOutBufSize);
	zOss_Memset(s_vpState.pVpTxInBuffer, 0, s_vpState.inOutBufSize);
	zOss_Memset(s_vpState.pVpTxOutPutBuffer, 0, s_vpState.inOutBufSize);
#ifdef _USE_VP_OUTPUT_RXOUT_DATA
        zOss_Memset(s_vpState.pVpRxOutPutBuffer, 0, s_vpState.inOutBufSize);
#else
		zOss_Memset(s_vpState.pVpRxOutPutBuffer, 0, 640);
#endif

	/*
	     s_speechState.pVpTempRxInBuffer = s_vpState.pVpRxInBuffer;
	     s_speechState.pVpTempTxInBuffer = s_vpState.pVpTxInBuffer;
	     s_speechState.pVpTempRxOutPutBuffer = s_vpState.pVpRxOutPutBuffer;
	     s_speechState.pVpTempTxOutPutBuffer = s_vpState.pVpTxOutPutBuffer;
	*/

	while (1)
	{
	    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "%s: wait vpLoopSemaphore!\n",__FUNCTION__);
		zOss_GetSemaphore(s_vpState.vpLoopSemaphore, ZOSS_WAIT_FOREVER);
	    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "%s: get vpLoopSemaphore, start loop!\n",__FUNCTION__);
		s_speechState.pVpTempRxInBuffer = s_vpState.pVpRxInBuffer;
		s_speechState.pVpTempTxInBuffer = s_vpState.pVpTxInBuffer;
		s_speechState.pVpTempRxOutPutBuffer = s_vpState.pVpRxOutPutBuffer;
		s_speechState.pVpTempTxOutPutBuffer = s_vpState.pVpTxOutPutBuffer;
		zOss_Memset(s_speechState.pVpTempRxOutPutBuffer, 0, 640);

		s_speechState.saveLen = 0;
#ifdef TEST_WHITE_NOISE
		pVoiceLoopTempBuf = s_voiceTempBuffer;//for test
		//    pVoiceLoopInSaveBuffer =  s_speechState.pVpTempTxOutPutBuffer;
		//  pVoiceLoopOutSaveBuffer =  s_speechState.pVpTempRxInBuffer;
#endif

		zOss_Sleep(500);
		ret = zDrvVp_LoopStartDo();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo err! \r\n");
			continue;
		}
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Loop thread start! \r\n");
		g_voiceVar.vpLoopBkRunning = TRUE;			

		while (g_voiceVar.vpI2sStatus == VP_LOOP_ON)
		{
			ret = zDrvExtAudio_Read(&read_buf, &read_len);
			if ((ret == DRV_SUCCESS) && (read_buf != NULL) && (read_len != 0))
			{
				if ((s_speechState.pVpI2sCfg->tClkMode == PCM_TIME_MODE) && (s_speechState.pVpI2sCfg->tPcmSlotNum != PCM_1TIME_SLOT))
				{
					for (i = 0; i < VP_I2S_BUFFER_SIZE;)
					{
						* (s_speechState.pVpTempTxInBuffer + i) = * (read_buf + i * (s_speechState.pVpI2sCfg->tPcmSlotNum + 1));
						* (s_speechState.pVpTempTxInBuffer + i + 1) = * (read_buf + i * (s_speechState.pVpI2sCfg->tPcmSlotNum + 1) + 1);
						i += 2;
					}
				}
				else
				{
					zOss_Memcpy(s_speechState.pVpTempTxInBuffer, read_buf, VP_I2S_BUFFER_SIZE);
				}


			}
			else
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_Read:I2S1:ret=%d,read_buf = %p,read_len = %d.\n", ret, read_buf, read_len);
				break;
			}
			ret = zDrvExtAudio_FreeBuf(read_buf);

            //dtmf检测-回环上行写入
            if(g_voiceVar.useDtmfLoop == 1)
            {
                ret = dtmfTx_RingWrite(s_speechState.pVpTempTxInBuffer);
                //zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "vp_LoopProcessThreadEntry dtmfTx_RingWrite end, ret=%d\n", ret);
                
                zOss_Memcpy((VOID *)(s_speechState.pVpTempTxOutPutBuffer), (VOID *) s_speechState.pVpTempTxInBuffer, VP_I2S_BUFFER_SIZE);
				s_speechState.saveLen += VP_I2S_BUFFER_SIZE;
				//			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_loopProcessThreadEntry  s_speechState.saveLen = %d\n", s_speechState.saveLen);
				if (s_speechState.saveLen >= loopCount)
				{
					s_speechState.saveLen = 0;
				}
				s_speechState.pVpTempTxInBuffer = s_vpState.pVpTxInBuffer + s_speechState.saveLen;
				s_speechState.pVpTempTxOutPutBuffer = s_vpState.pVpTxOutPutBuffer + s_speechState.saveLen;

                
            }
            else 
			/*voice process*/
			{

				if (g_voiceVar.vProcIsNormal == TRUE)
				{

					VoiceProc_TxProcess(& s_speechState.pVpTempTxInBuffer, NULL, & s_speechState.pVpTempTxOutPutBuffer, s_speechState.frameCount);

					// zOss_Memcpy(pBuf, s_speechState.pVpTempTxOutPutBuffer,VP_FRAME_BUFFER_SIZE);
					//zOss_Memcpy(pBuf, s_speechState.pVpTempTxOutPutBuffer,s_speechState.totalFrameBufSize);
				}
				else
				{
					//zOss_Memcpy(pBuf, s_speechState.pVpTempTxInBuffer,VP_FRAME_BUFFER_SIZE);
					//zOss_Memcpy(pBuf, s_speechState.pVpTempTxInBuffer,s_speechState.totalFrameBufSize);
					zOss_Memcpy((VOID *)(s_speechState.pVpTempTxOutPutBuffer), (VOID *) s_speechState.pVpTempTxInBuffer, VP_I2S_BUFFER_SIZE);


				}

				//no nxp lib lwenhua 20150317

				//   zOss_Memcpy((VOID *)( s_speechState.pVpTempRxOutPutBuffer), (VOID *) s_speechState.pVpTempTxInBuffer, 320);
			}
            if(g_voiceVar.useDtmfLoop == 1)
            {
                continue;
            }

			zOss_Memcpy((VOID *)(s_speechState.pVpTempRxInBuffer), (VOID *) s_speechState.pVpTempTxOutPutBuffer, VP_I2S_BUFFER_SIZE);

#ifdef TEST_WHITE_NOISE
			zOss_Memcpy(s_speechState.pVpTempRxInBuffer, pVoiceLoopTempBuf, VP_I2S_BUFFER_SIZE);
			pVoiceLoopTempBuf += VP_I2S_BUFFER_SIZE;
			tempLoopCount += VP_I2S_BUFFER_SIZE;
			if (tempLoopCount >= 0x4E200)
			{
				//307200
				pVoiceLoopTempBuf = s_voiceTempBuffer;
				tempLoopCount = 0;
			}

#endif

			ret = zDrvExtAudio_GetBuf(&write_buf, &write_len);
			if ((ret == DRV_SUCCESS) && (write_buf != NULL) && (write_len != 0))
			{
#if 0
				if (s_speechState.saveLen + 320 < 8000)
				{
					loop_point =  s_speechState.saveLen + 320;
				}
				else
				{
					loop_point = 0;
				}

				pvoiceInterBuffer =  s_speechState.pVpTempRxOutPutBuffer + loop_point;
#endif
				if (g_voiceVar.vProcIsNormal == TRUE)
				{

					//VoiceProc_RxProcess(&pvoiceInterBuffer, &write_buf, s_speechState.frameCount);
					VoiceProc_RxProcess(& s_speechState.pVpTempRxInBuffer, & s_speechState.pVpTempRxOutPutBuffer, s_speechState.frameCount);

					//zOss_Memcpy(write_buf, s_speechState.pVpTempRxOutPutBuffer,write_len);
					//pvpRxMidBuffer= s_speechState.pVpTempRxOutPutBuffer;
				}
				else
				{
					//zOss_Memcpy(write_buf, s_speechState.pVpTempRxInBuffer,write_len);
					//pVpRxMidBuffer= s_speechState.pVpTempRxInBuffer;
					zOss_Memcpy((VOID *)(s_speechState.pVpTempRxOutPutBuffer), (VOID *) s_speechState.pVpTempRxInBuffer, 320);

				}


				//no nxp lib lwenhua 20150317

				// zOss_Memcpy((VOID *)(write_buf), (VOID *)pvoiceInterBuffer, 320);
			}
			else
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_GetBuf:I2S1:ret=%d,write_buf = %p,write_len = %d.\n", ret, write_buf, write_len);
				break;
			}



			if ((s_speechState.pVpI2sCfg->tClkMode == PCM_TIME_MODE) && (s_speechState.pVpI2sCfg->tPcmSlotNum != PCM_1TIME_SLOT))
			{
				for (i = 0; i < VP_I2S_BUFFER_SIZE;)
				{
					* (write_buf + i * (s_speechState.pVpI2sCfg->tPcmSlotNum + 1)) = * (s_speechState.pVpTempRxInBuffer + i);
					* (write_buf + i * (s_speechState.pVpI2sCfg->tPcmSlotNum + 1) + 1) = * (s_speechState.pVpTempRxInBuffer + i + 1);
					i += 2;
				}
			}
			else
			{
				zOss_Memcpy(write_buf, s_speechState.pVpTempRxOutPutBuffer, VP_I2S_BUFFER_SIZE);
			}

			ret = zDrvExtAudio_Write(write_buf, write_len);

			/*
			            if( s_speechState.saveLen == 32000)
			            {
			                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "loop 3200\n");
			            }
			*/

			{
				s_speechState.saveLen += VP_I2S_BUFFER_SIZE;
				//			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_loopProcessThreadEntry  s_speechState.saveLen = %d\n", s_speechState.saveLen);
				if (s_speechState.saveLen >= loopCount)
				{
					s_speechState.saveLen = 0;
				}
				s_speechState.pVpTempTxInBuffer = s_vpState.pVpTxInBuffer + s_speechState.saveLen;
				s_speechState.pVpTempTxOutPutBuffer = s_vpState.pVpTxOutPutBuffer + s_speechState.saveLen;
				s_speechState.pVpTempRxInBuffer = s_vpState.pVpRxInBuffer +  s_speechState.saveLen;
				s_speechState.pVpTempRxOutPutBuffer = s_vpState.pVpRxOutPutBuffer;
			}
		}

		ret = zDrvExtAudio_Read_Stop();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_Read_Stop I2S1 Stop wrong  ret=%d\n", ret);
		}
		ret = zDrvExtAudio_Write_Stop();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_Write_Stop I2S1 Stop wrong  ret=%d\n", ret);
		}

		//no nxp lib lwenhua 20150317
//        ret += Vp_NxpClose();
		if (g_voiceVar.isUseSlicCodec != 1)
		{
			ret = zDrvExtAudio_Close();
		}

		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_Close I2S1 Stop wrong  ret=%d", ret);
		}
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_LoopProcessThreadEntry work end.\n");
		g_voiceVar.vpLoopBkRunning = FALSE;	
	}
}

SINT32 vp_StateInitUseI2s(T_ZDrvVp_Cfg cfgParam)
{

	if (cfgParam.clock_rate == 16000)
	{

		s_speechState.pVpI2sCfg = s_vpState.pVpExtI2sWbCfg;
		g_voiceVar.volteIsWb = 1;
		s_speechState.frameCount = 160;

	}
	else if (cfgParam.clock_rate == 8000)
	{

		s_speechState.pVpI2sCfg = s_vpState.pVpExtI2sCfg;
		g_voiceVar.volteIsWb = 0;
		s_speechState.frameCount = 160;

	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_StateInitUseI2s the fs not support! \r\n");
		return DRV_ERR_INVALID_PARAM;
	}
	/*
	        if((s_speechState.pVpI2sCfg->tClkMode == I2S_TIME_MODE)&&(s_speechState.pVpI2sCfg->tTrackFmt == DOUBLE_TRACK))
	        {
	            s_speechState.i2sReadParam.channel = AUDIO_DUAL_CHANNEL;
	            s_speechState.i2sWriteParam.channel = AUDIO_DUAL_CHANNEL;

	        }
	*/
	if (s_speechState.pVpI2sCfg == NULL)
	{
		return DRV_ERROR;
	}

	if (s_speechState.pVpI2sCfg->tClkMode == I2S_TIME_MODE)
	{
		if (s_speechState.pVpI2sCfg->tTrackFmt == DOUBLE_TRACK)
		{
			s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2) * 2;
			s_speechState.i2sReadParam.channel = AUDIO_DUAL_CHANNEL;
			s_speechState.i2sWriteParam.channel = AUDIO_DUAL_CHANNEL;
		}
		else if ((s_speechState.pVpI2sCfg->tTrackFmt == LEFT_TRACK) || (s_speechState.pVpI2sCfg->tTrackFmt == RIGHT_TRACK))
		{
			s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2);
			s_speechState.i2sReadParam.channel = AUDIO_MONO_CHANNEL;
			s_speechState.i2sWriteParam.channel = AUDIO_MONO_CHANNEL;
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_StateInitUseI2s tTrackFmt not support! \r\n");

			return DRV_ERR_INVALID_PARAM;

		}
		s_speechState.i2sWriteParam.buffersize = s_speechState.totalFrameBufSize;
		s_speechState.i2sReadParam.buffersize = s_speechState.totalFrameBufSize;

	}
	else if ((s_speechState.pVpI2sCfg->tClkMode == PCM_TIME_MODE) && (s_speechState.pVpI2sCfg->tPcmSlotNum == PCM_1TIME_SLOT))
	{
		s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2);
		s_speechState.i2sWriteParam.buffersize = s_speechState.totalFrameBufSize;
		s_speechState.i2sReadParam.buffersize = s_speechState.totalFrameBufSize;

	}
	else if ((s_speechState.pVpI2sCfg->tClkMode == PCM_TIME_MODE) && (s_speechState.pVpI2sCfg->tPcmSlotNum != PCM_1TIME_SLOT))
	{
		s_speechState.pcmSlotNum = s_speechState.pVpI2sCfg->tPcmSlotNum + 1;

		if (s_speechState.pVpI2sCfg->tPcmSlotNum == PCM_16TIME_SLOT)
		{
			s_speechState.pcmWbSecDataPosition = 16;
		}
		else if (s_speechState.pVpI2sCfg->tPcmSlotNum == PCM_4TIME_SLOT)
		{
			s_speechState.pcmWbSecDataPosition = 4;
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_StateInitUseI2s s_speechState.pVpI2sCfg->tPcmSlotNum=%d,not support !\n", s_speechState.pVpI2sCfg->tPcmSlotNum);
			return DRV_ERROR;

		}

		s_speechState.totalFrameBufSize = s_speechState.frameCount * 2;
		s_speechState.i2sWriteParam.buffersize = s_speechState.pcmSlotNum * s_speechState.totalFrameBufSize;
		s_speechState.i2sReadParam.buffersize = s_speechState.pcmSlotNum * s_speechState.totalFrameBufSize;
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_StateInitUseI2s s_speechState.pVpI2sCfg->tClkMode=%d,not support !\n", s_speechState.pVpI2sCfg->tClkMode);
		return DRV_ERROR;

	}

	s_speechState.i2sWriteParam.p_cb = NULL;
	s_speechState.i2sReadParam.p_cb = NULL;

	
	return DRV_SUCCESS;
}

VOID vp_StateInitUseTdm(VOID)
{
	s_vpState.pVpTdmCfg = s_vpState.s_pVpTdmCfg;
	s_speechState.pVpI2sCfg = s_vpState.pVpExtI2sCfg;

	if (s_vpState.pVpTdmCfg->tTsEnable == TDM_2TS_ENABLE)
	{
		s_vpTdmReadParam.channel = AUDIO_DUAL_CHANNEL;
		s_VpTdmWriteParam.channel = AUDIO_DUAL_CHANNEL;
	}

	g_voiceVar.volteIsWb = 0;
	s_speechState.frameCount = 160;
	s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2);
	s_VpTdmWriteParam.buffersize = s_speechState.totalFrameBufSize;
	s_vpTdmReadParam.buffersize = s_speechState.totalFrameBufSize;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_StateInitUseTdm buffersize=%d\n", s_VpTdmWriteParam.buffersize);

}



SINT32 zDrvVp_LoopStartDo(VOID)
{
	SINT32 ret = DRV_SUCCESS;
	UINT8 *write_buf = NULL;
	UINT32 write_len = 0;
	//UINT8 *read_buf = NULL;//xiu gai chu
	//UINT32 read_len = 0;//ciu gai chu
	T_ZDrvVp_Cfg loopCfgParam;
	T_ZDrv_VpFs fs = VP_FS_8000;
	loopCfgParam.clock_rate = 8000; //16000; //
	loopCfgParam.bits_per_sample = 16;
	loopCfgParam.channel_count = 1;
	loopCfgParam.samples_per_frame = 160;

	if (((s_vpState.pVpExtI2sCfg  == NULL) || (s_vpState.pVpExtI2sWbCfg == NULL)) && ((s_vpState.s_pVpTdmCfg == NULL)))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo error s_vpState.pVpExtI2sCfg not init! \r\n");
		return DRV_ERROR;

	}
	else
	{
		if (g_voiceVar.g_isUseTdm != 1)
		{
            ret = vp_StateInitUseI2s(loopCfgParam);
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_StateInitUseI2s error  ret=%d!\n", ret);
				return ret;
			}
		
#if 0
			if (loopCfgParam.clock_rate == 16000)
			{

				s_speechState.pVpI2sCfg = s_vpState.pVpExtI2sWbCfg;
				g_voiceVar.volteIsWb = 1;
				s_speechState.frameCount = 320;

			}
			else if (loopCfgParam.clock_rate == 8000)
			{

				s_speechState.pVpI2sCfg = s_vpState.pVpExtI2sCfg;
				g_voiceVar.volteIsWb = 0;
				s_speechState.frameCount = 160;

			}
			else
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo the fs not support! \r\n");
				return DRV_ERR_INVALID_PARAM;
			}
			/*
			        if((s_speechState.pVpI2sCfg->tClkMode == I2S_TIME_MODE)&&(s_speechState.pVpI2sCfg->tTrackFmt == DOUBLE_TRACK))
			        {
			            s_speechState.i2sReadParam.channel = AUDIO_DUAL_CHANNEL;
			            s_speechState.i2sWriteParam.channel = AUDIO_DUAL_CHANNEL;

			        }
			*/
			if (s_speechState.pVpI2sCfg == NULL)
			{
				return DRV_ERROR;
			}

			if (s_speechState.pVpI2sCfg->tClkMode == I2S_TIME_MODE)
			{
				if (s_speechState.pVpI2sCfg->tTrackFmt == DOUBLE_TRACK)
				{
					s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2) * 2;
					s_speechState.i2sReadParam.channel = AUDIO_DUAL_CHANNEL;
					s_speechState.i2sWriteParam.channel = AUDIO_DUAL_CHANNEL;
				}
				else if ((s_speechState.pVpI2sCfg->tTrackFmt == LEFT_TRACK) || (s_speechState.pVpI2sCfg->tTrackFmt == RIGHT_TRACK))
				{
					s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2);
					s_speechState.i2sReadParam.channel = AUDIO_MONO_CHANNEL;
					s_speechState.i2sWriteParam.channel = AUDIO_MONO_CHANNEL;
				}
				else
				{
					zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo tTrackFmt not support! \r\n");

					return DRV_ERR_INVALID_PARAM;

				}
				s_speechState.i2sWriteParam.buffersize = s_speechState.totalFrameBufSize;
				s_speechState.i2sReadParam.buffersize = s_speechState.totalFrameBufSize;

			}
			else if ((s_speechState.pVpI2sCfg->tClkMode == PCM_TIME_MODE) && (s_speechState.pVpI2sCfg->tPcmSlotNum == PCM_1TIME_SLOT))
			{
				s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2);
				s_speechState.i2sWriteParam.buffersize = s_speechState.totalFrameBufSize;
				s_speechState.i2sReadParam.buffersize = s_speechState.totalFrameBufSize;

			}
			else if ((s_speechState.pVpI2sCfg->tClkMode == PCM_TIME_MODE) && (s_speechState.pVpI2sCfg->tPcmSlotNum != PCM_1TIME_SLOT))
			{
				s_speechState.pcmSlotNum = s_speechState.pVpI2sCfg->tPcmSlotNum + 1;

				if (s_speechState.pVpI2sCfg->tPcmSlotNum == PCM_16TIME_SLOT)
				{
					s_speechState.pcmWbSecDataPosition = 16;
				}
				else if (s_speechState.pVpI2sCfg->tPcmSlotNum == PCM_4TIME_SLOT)
				{
					s_speechState.pcmWbSecDataPosition = 4;
				}
				else
				{
					zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CfgParam s_speechState.pVpI2sCfg->tPcmSlotNum=%d,not support !\n", s_speechState.pVpI2sCfg->tPcmSlotNum);
					return DRV_ERROR;

				}

				s_speechState.totalFrameBufSize = s_speechState.frameCount * 2;
				s_speechState.i2sWriteParam.buffersize = s_speechState.pcmSlotNum * s_speechState.totalFrameBufSize;
				s_speechState.i2sReadParam.buffersize = s_speechState.pcmSlotNum * s_speechState.totalFrameBufSize;
			}
			else
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo s_speechState.pVpI2sCfg->tClkMode=%d,not support !\n", s_speechState.pVpI2sCfg->tClkMode);
				return DRV_ERROR;

			}

			s_speechState.i2sWriteParam.p_cb = NULL;
			s_speechState.i2sReadParam.p_cb = NULL;
#endif		
		}
		else if (g_voiceVar.g_isUseTdm == 1)
		{
			vp_StateInitUseTdm();	
#if 0
			s_vpState.pVpTdmCfg = s_vpState.s_pVpTdmCfg;
			s_speechState.pVpI2sCfg = s_vpState.pVpExtI2sCfg;

			if (s_vpState.pVpTdmCfg->tTsEnable == TDM_2TS_ENABLE)
			{
				s_vpTdmReadParam.channel = AUDIO_DUAL_CHANNEL;
				s_VpTdmWriteParam.channel = AUDIO_DUAL_CHANNEL;
			}

			g_voiceVar.volteIsWb = 0;
			s_speechState.frameCount = 160;
			s_speechState.totalFrameBufSize = (s_speechState.frameCount * 2);
			s_VpTdmWriteParam.buffersize = s_speechState.totalFrameBufSize;
			s_vpTdmReadParam.buffersize = s_speechState.totalFrameBufSize;
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo Tdm zDrvTdm_Write_Start buffersize=%d\n", s_VpTdmWriteParam.buffersize);
#endif
		}
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo I2S zDrvI2S_Write_Start buffersize=%d\n", s_speechState.i2sWriteParam.buffersize);
		s_speechState.inOutBufUseSize = s_vpState.inOutBufSize - s_speechState.totalFrameBufSize;

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo  g_voiceVar.vpI2sStatus=%d,s_speechState.inOutBufUseSize=%d\n", g_voiceVar.vpI2sStatus, s_speechState.inOutBufUseSize);

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo set totalFrameBufSize=%d,s_speechState.frameCount=%d\n", s_speechState.totalFrameBufSize, s_speechState.frameCount);


	}

	if (g_voiceVar.isUseSlicCodec != 1)
	{
		ret = zDrvExtAudio_Open(TRANS_DMA_MODE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "ret=%d zDrvI2S_Open(I2S_1,TRANS_DMA_MODE)\n", ret);
			return DRV_ERROR;
		}
	}

	ret = halVpCfg_Open(VP_VOICE_SOURCE);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo halVpCfg_Open err ret=%d !\n", ret);
		return DRV_ERROR;
	}
	ret = halVpCfg_SetFs(fs);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo halVpCfg_SetFs err ret=%d !\n", ret);
		return DRV_ERROR;
	}

	if ((g_voiceVar.vpLoopPath == VP_PATH_HANDSET) || (g_voiceVar.vpLoopPath == VP_PATH_HEADSET) || (g_voiceVar.vpLoopPath == VP_PATH_SPEAKER))
	{
		ret = halVpCfg_SetInputPath(g_voiceVar.vpLoopPath, TRUE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo voice_SetPahtIn halVpCfg_SetInputPath err ret=%d !\n", ret);
			return DRV_ERROR;

		}
		ret = halVpCfg_SetOutputPath(g_voiceVar.vpLoopPath, TRUE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo voice_SetPahtOut halVpCfg_SetOutputPath err ret=%d !\n", ret);
			return DRV_ERROR;

		}

	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo path not support  g_voiceVar.vpLoopPath=%d !\n", g_voiceVar.vpLoopPath);
		return DRV_ERROR;

	}

	ret = halVpCfg_Enable();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo halVpCfg_Enable err ret=%x !\n", ret);
		return DRV_ERROR;
	}

#ifndef TEST_WHITE_NOISE

	if (loopCfgParam.clock_rate == 16000)
	{
		ret = VoiceProc_Open(16000);
	}
	else if (loopCfgParam.clock_rate == 8000)
	{
		ret = VoiceProc_Open(8000);

	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo VoiceProc_Open fs not support\n");


	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo VoiceProc_Open g_voiceVar.voiceMode=%d, ret=%d \n", g_voiceVar.voiceMode, ret);
	//g_voiceVar.vpPath = VP_PATH_HANDSET;
	// g_voiceVar.vpVol = VP_VOL_3;
	if (ret == DRV_SUCCESS)
	{
		//g_voiceVar.vpPath = VP_PATH_HEADSET;
		g_voiceVar.vpVol = VP_VOL_5;
		g_voiceVar.voiceInGsmTdMode = 1;
		g_voiceVar.voiceMode = VOICE_GSM_MODE;
		ret = VoiceProc_GetParam(g_voiceVar.voiceMode, g_voiceVar.vpLoopPath);
		if (ret == DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " zDrvVp_LoopStartDo VoiceProc_GetParam OK!\r\n");
			g_voiceVar.vProcIsNormal = TRUE;
			ret = VoiceProc_SetParam(g_voiceVar.voiceMode, g_voiceVar.vpLoopPath, g_voiceVar.vpVol, FALSE);
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo VoiceProc_SetParam ret=%d \n", ret);
			if (ret != DRV_SUCCESS)
			{
				g_voiceVar.vProcIsNormal = FALSE;
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo VoiceProc_SetParam ret=%d ,voice process don't use! \n", ret);
				VoiceProc_Close();
			}
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo VoiceProc_GetParam error ret=%d ! \r\n", ret);
			g_voiceVar.vProcIsNormal = FALSE;
			VoiceProc_Close();

		}
	}
	else
	{
		g_voiceVar.vProcIsNormal = FALSE;
	}
#else

	g_voiceVar.vProcIsNormal = FALSE;

#endif

	//no nxp lib lwenhua 20150317
#if 0
	//	ret = VoiceProc_Open();
	//	ret += VoiceProc_SetParam(s_vpPath, VP_VOL_5,TRUE);

	if (ret != DRV_SUCCESS)
	{
		ret += zDrvExtAudio_Close();
		return DRV_ERROR;
	}
#endif
	if (g_voiceVar.isUseSlicCodec == 1) 
	{
		ret = zDrvExtAudio_Reset();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStartDo zDrvExtAudio_Reset err ret=%d ", ret);
			return DRV_ERROR;
		}
	}
	ret = zDrvExtAudio_Read_Start(&s_speechState.i2sReadParam,s_speechState.pVpI2sCfg,&s_vpTdmReadParam,s_vpState.pVpTdmCfg);
    ret += zDrvExtAudio_Write_Start(&s_speechState.i2sWriteParam,s_speechState.pVpI2sCfg,&s_VpTdmWriteParam,s_vpState.pVpTdmCfg);
#if 0
	if (g_voiceVar.isUseSlicCodec != 1)
	{
		ret = zDrvExtAudio_Read_Start(&s_speechState.i2sReadParam, s_speechState.pVpI2sCfg, &s_vpTdmReadParam, s_vpState.pVpTdmCfg);
		ret += zDrvExtAudio_Write_Start(&s_speechState.i2sWriteParam, s_speechState.pVpI2sCfg, &s_VpTdmWriteParam, s_vpState.pVpTdmCfg);
	}
	else if (g_voiceVar.g_isUseTdm == 1)
	{
		ret = zDrvTDM_Read_Start_Do(&s_vpTdmReadParam);
		ret += zDrvTDM_Write_Start_Do(&s_VpTdmWriteParam);
	}
	else if (g_voiceVar.g_isUseTdm != 1)
	{
		ret = zDrvI2S_Read_Start_Do(I2S_1, &s_speechState.i2sReadParam);
		ret += zDrvI2S_Write_Start_Do(I2S_1, &s_speechState.i2sWriteParam);
	}
#endif
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "ret=%d zDrvI2S_Read_Start zDrvI2S_Write_Start(I2S_1)", ret);
		return DRV_ERROR;
	}
	ret = zDrvExtAudio_GetBuf(&write_buf, &write_len);
	zOss_Memset(write_buf, 0, write_len);
	ret += zDrvExtAudio_Write(write_buf, write_len);
	ret += zDrvExtAudio_GetBuf(&write_buf, &write_len);
	zOss_Memset(write_buf, 0, write_len);
	ret += zDrvExtAudio_Write(write_buf, write_len);
	ret += zDrvExtAudio_GetBuf(&write_buf, &write_len);
	zOss_Memset(write_buf, 0, write_len);
	ret += zDrvExtAudio_Write(write_buf, write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "ret=%d zDrvVp_LoopStartDo   zDrvI2S_GetBuf  zDrvI2S_Write(I2S_1)", ret);
		return DRV_ERROR;
	}

	return ret;
}

SINT32 zDrvVp_LoopStart(T_ZDrv_VpPath path)
{
	SINT32 ret = DRV_SUCCESS;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVp_LoopStart begin g_voiceVar.vpI2sStatus =%d\n", g_voiceVar.vpI2sStatus);
	//vp_SetTopI2sConfig();

	if (g_voiceVar.vpI2sStatus != VP_I2S_IDLE)
	{
		return DRV_ERROR;
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStart  start\n");
#if 0
	if (s_speechState.pVpI2sCfg == NULL)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStart error: i2s parameter is not setted");
		return DRV_ERROR;
	}
#endif

	g_voiceVar.vpLoopPath = path;

	g_voiceVar.vpI2sStatus = VP_LOOP_ON;
	if (s_vpState.vpLoopSemaphore != NULL)
	{
		zOss_PutSemaphore(s_vpState.vpLoopSemaphore);
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVp_LoopStart g_voiceVar.vpI2sStatus =%d\n", g_voiceVar.vpI2sStatus);

	return ret;
}

SINT32 zDrvVp_LoopStop(void)//xiu gai chu tian jia void
{
	SINT32  ret = DRV_SUCCESS;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStop begin g_voiceVar.vpI2sStatus=%d", g_voiceVar.vpI2sStatus);

	if (g_voiceVar.vpI2sStatus != VP_LOOP_ON)
	{
		return DRV_ERROR;
	}

	g_voiceVar.vpI2sStatus = VP_I2S_IDLE;

	//zDrvI2s_RxRlsSemaBeforeStop(I2S_1);
	//zDrvI2s_TxRlsSemaBeforeStop(I2S_1);
	zDrvExtAudio_RlsAllSemaBeforeStop();

	ret = halVpCfg_Disable();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStop halVpCfg_Enable err ret=%x !\n", ret);
	}

	ret = halVpCfg_Close();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStop hal_VpCfg_Close err ret=%d", ret);
		return DRV_ERROR;
	}

	if (g_voiceVar.vProcIsNormal == TRUE)
	{
		ret = VoiceProc_Close();

		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Close VoiceProc_Close wrong  ret=%d \n", ret);
		}
		g_voiceVar.vProcIsNormal = FALSE;
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_LoopStop success! \n");
	return DRV_SUCCESS;
}



#ifdef _USE_HAL_HDTTST
SINT32 voiceGetPcmData(UINT32 *Uplinkdata, UINT32 *Downlinkdata)
{
	(UINT8 *) *Uplinkdata =   s_speechState.pVpTempTxInBuffer;
	(UINT8 *) *Downlinkdata =  s_speechState.pVpTempRxInBuffer;
	return 0 ;
}
#endif

#ifdef USE_AUDIO_RING
static ZOSS_THREAD_ID s_ringPlayThread = NULL;
static ZOSS_SEMAPHORE_ID s_ringPlaySemaphore = NULL;
static ZOSS_SEMAPHORE_ID s_ringPlayEndSemaphore = NULL;
static BOOL s_firstStart = TRUE;

static T_ZDrvCodec_Handle s_codecRingHandle = NULL;
static T_ZDrvI2S_Cfg s_ringI2s1Cfg =  {TRUE, I2S_DATA_16BIT, I2S_TS_16CYCLE, 8000,     \
                                       I2S_TIME_MODE, TRANS_POSITIVE_NEGATIVE, \
                                       LEFT_TRACK, I2S_NORMAL_MODE, FIRST_DATA_ALIGN_TO_FIRST_CYCLE, \
                                       PCM_NORMAL_MODE, PCM_MSB_FIRST, PCM_FSYNC_LENGTH_1CLK, PCM_1TIME_SLOT, TIMING_I2S_MONO_LEFT, PCM_SHORT_FSYNC, \
                                       TDM_NO_EXTRA_CYCLE, DATA_ALIGN_STD_I2S, REF_CLK26M
                                      };//TEST FOR i2s
static  BOOL s_ringStop = TRUE;
#endif

#ifdef USE_AUDIO_RING
static VOID ringPlayEntry(SINT32 para)
{
	UINT32 ret = DRV_SUCCESS;
	T_ZDrv_VpFs fs = VP_FS_8000;
	T_ZDrvI2S_Cfg ptCfg = {0};
	UINT8 *write_buf = NULL;
	UINT32 write_len = 0;


	UINT32 arraySize = 0;

	UINT32 count = 0;
	UINT8 *bufptr = NULL;
	bufptr = callRingPcm;
	arraySize = sizeof(callRingPcm) / sizeof(UINT8);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " ringPlayEntry arraySize=%x\n", arraySize);
	while (1)
	{

		zOss_GetSemaphore(s_ringPlaySemaphore, ZOSS_WAIT_FOREVER);


		ret = halVpCfg_Open(VP_VOICE_SOURCE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop halVpCfg_Open err ret=%d !\n", ret);
			return DRV_ERROR;
		}
		ret = halVpCfg_SetFs(fs);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop halVpCfg_SetFs err ret=%d !\n", ret);
			return DRV_ERROR;

		}

		if ((g_voiceVar.vpPath == VP_PATH_HANDSET) || (g_voiceVar.vpPath == VP_PATH_HEADSET) || (g_voiceVar.vpPath == VP_PATH_SPEAKER))
		{
			ret = halVpCfg_SetInputPath(g_voiceVar.vpPath, TRUE);
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop voice_SetPahtIn halVpCfg_SetInputPath err ret=%d !\n", ret);
				return DRV_ERROR;

			}
			ret = halVpCfg_SetOutputPath(g_voiceVar.vpPath, TRUE);
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop voice_SetPahtOut halVpCfg_SetOutputPath err ret=%d !\n", ret);
				return DRV_ERROR;

			}
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop voice_SetPahtOut the path not support !\n");
			return DRV_ERROR;

		}
		ret = halVpCfg_Enable();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop halVpCfg_Enable err ret=%x !\n", ret);
			return DRV_ERROR;
		}




		ptCfg = s_ringI2s1Cfg;

		//ret = zDrvI2S_Init();
		if (g_voiceVar.isUseSlicCodec != 1)
		{
			ret += zDrvExtAudio_Open(TRANS_DMA_MODE);

		}


		T_ZDrvI2s_Params parameter = {0};
		parameter.channel = AUDIO_MONO_CHANNEL;
		parameter.buffersize = 320;
		parameter.p_cb = NULL;

		ret += zDrvI2S_Write_Start(I2S_1, &parameter, &ptCfg);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "I2S_1 zDrvI2S_Write_Start ret=%d!\n", ret);
		if (ret != DRV_SUCCESS)
		{
			zOss_Printf(1, 1, "zDrvI2S_Write_Start fail ret=%x\n", ret);
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " ringPlayEntry I2S CFG end ret=%d!\n", ret);
			continue;
		}

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " ringPlayEntry I2S CFG end!\n");


		while (s_ringStop == FALSE)
		{

			ret = zDrvI2S_GetBuf(I2S_1, &write_buf, &write_len);
			//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_GetBuf write_buf=0x%x,write_len=%d!\n",write_buf,write_len);
			///zOss_Printf(1,1,"zDrvI2S_GetBuf write_buf=0x%x,write_len=%d!\n",write_buf,write_len);

			//write_len = 160;
			zOss_Memcpy((VOID *)(write_buf), bufptr, write_len);
			ret = zDrvI2S_Write(I2S_1, write_buf, write_len);



			bufptr += write_len;
			count += write_len;

			if (count >= arraySize)
			{
				count = 0;
				//recordFileFlag = 0;
				bufptr = callRingPcm;
			}

		}

		zOss_PutSemaphore(s_ringPlayEndSemaphore);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " ringPlayEntry end !\n");

	}

}



SINT32 zDrvVp_RingStart(VOID)
{
	SINT32  ret = DRV_SUCCESS;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStart!\n");

	if (g_voiceVar.vpI2sStatus != VP_I2S_IDLE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStart err, voice active!\n");
		return DRV_ERR_BUSY;
	}


	if (s_ringStop == FALSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStart err, latest ring not stop!\n");

		return DRV_ERR_START_TIMES;
	}

	if (s_firstStart)
	{
		s_ringPlaySemaphore = zOss_CreateSemaphore("VpRingPlaySemaphore", 0);
		s_ringPlayThread = zOss_CreateThread("VpRingPlay", ringPlayEntry, 0, 1024 * 9, 25, 0, 1);
		s_ringPlayEndSemaphore = zOss_CreateSemaphore("VpRingPlayEndSemaphore", 0);

		if ((NULL == s_ringPlaySemaphore) || (NULL == s_ringPlayThread) || (NULL == s_ringPlayEndSemaphore))
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "create RingPlay Thread sem err! \r\n");
			return DRV_ERROR;
		}


		s_firstStart = FALSE;
	}
	s_ringStop = FALSE;

	//vp_SetTopI2sConfig();
	zOss_PutSemaphore(s_ringPlaySemaphore);

	return ret;
}
SINT32 zDrvVp_RingStop(VOID)
{
	SINT32  ret = DRV_SUCCESS;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " zDrvVp_RingStop  start!\n");

	if (s_ringStop == TRUE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop err, stop flag already is true!\n");
		return DRV_ERR_DEV_CLOSED;
	}

	s_ringStop = TRUE;

	if (g_voiceVar.vpI2sStatus == VP_I2S_IDLE)
	{
		zOss_GetSemaphore(s_ringPlayEndSemaphore, ZOSS_WAIT_FOREVER);

		if (g_voiceVar.vpI2sStatus != VP_I2S_IDLE)   return DRV_ERR_BUSY;


		ret = zDrvExtAudio_Write_Stop();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop zDrvI2S_Write_Stop err, ret=%d\n", ret);
		}

		ret = zDrvExtAudio_Close();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop zDrvI2S_Close err,  ret=%d\n", ret);

		}

		ret = halVpCfg_Disable();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop halVpCfg_Enable err ret=%x !\n", ret);
		}

		ret = halVpCfg_SetInputPath(g_voiceVar.vpPath, FALSE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop voice_SetPahtIn halVpCfg_SetInputPath err ret=%d !\n", ret);

		}
		ret = halVpCfg_SetOutputPath(g_voiceVar.vpPath, FALSE);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop voice_SetPahtOut halVpCfg_SetOutputPath err ret=%d !\n", ret);

		}

		ret = halVpCfg_Close();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop hal_VpCfg_Close err ret=%d", ret);
			return DRV_ERROR;
		}

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " ringstop  close dev end!\n");

	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_RingStop end\n");

	return ret;
}


#endif

#ifdef _USE_VP_I2S_SYNC

extern SINT32 gI2sDmaReadIntTime[MAX_I2S_ID];
extern SINT32 gI2sDmaWriteIntTime[MAX_I2S_ID];
extern SINT32 gI2sTimes;
extern SINT32 gI2sCntChangeTx[MAX_I2S_ID];
extern SINT32 gI2sCntChangeRx[MAX_I2S_ID];
VOID Vp_I2S1ReadChangeBufLen(VOID)
{
#if 0 //latest use
	SINT32 currentTimeDiff = 0;

	gI2sTimes++;
	if (gI2sTimes <= 2)
	{
		gI2sDmaReadIntTime[I2S_1] = zDrvTimer_Stamp();
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_I2S1ReadChangeBufLen gI2sDmaReadIntTime[I2S_1] =%d.\n", gI2sDmaReadIntTime[I2S_1]);
		if (gI2sTimes == 2)
		{
			currentTimeDiff = gI2sDmaReadIntTime[I2S_1] - 20000 - gI2sDmaWriteIntTime[I2S_1];
			gI2sCntChangeTx[I2S_1] = (currentTimeDiff - 1000) / 125 / 2 * 2;
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_I2S1ReadChangeBufLen gI2sCntChangeTx[I2S_1] =%d.\n", gI2sCntChangeTx[I2S_1]);

			currentTimeDiff = gI2sDmaReadIntTime[I2S_1] - 20000 - gI2sDmaReadIntTime[I2S_2];
			gI2sCntChangeRx[I2S_2] = (currentTimeDiff - 2000) / 125 / 2 * 2;
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_I2S1ReadChangeBufLen gI2sCntChangeRx[I2S_2] =%d.\n", gI2sCntChangeRx[I2S_2]);

			currentTimeDiff = gI2sDmaReadIntTime[I2S_1] - 20000 - gI2sDmaWriteIntTime[I2S_2];
			gI2sCntChangeTx[I2S_2] = (currentTimeDiff - 3000) / 125 / 2 * 2;
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_I2S1ReadChangeBufLen gI2sCntChangeTx[I2S_2] =%d.\n", gI2sCntChangeTx[I2S_2]);
		}
	}
#endif

#if 0
	if (gI2sTimes == 10)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "gI2sTimes == 10 gI2sDmaReadIntTime[I2S_1]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 20)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "gI2sTimes == 20 gI2sDmaReadIntTime[I2S_1]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 500)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "gI2sTimes == 500 gI2sDmaReadIntTime[I2S_1]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 1000)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "gI2sTimes == 1000 gI2sDmaReadIntTime[I2S_1]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 1500)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "gI2sTimes == 1500 gI2sDmaReadIntTime[I2S_1]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 3000)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "gI2sTimes == 3000 gI2sDmaReadIntTime[I2S_1]=%d.\n", zDrvTimer_Stamp());
	}
#endif

	gI2sDmaReadIntTime[I2S_1] += 1;
}

VOID Vp_I2S1WriteChangeBufLen(VOID)
{
#if 0 //latest use
	if (gI2sDmaWriteIntTime[I2S_1] == 0)
	{
		gI2sDmaWriteIntTime[I2S_1] = zDrvTimer_Stamp();
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_I2S2WriteChangeBufLen gI2sDmaWriteIntTime[I2S_1] =%d.\n", gI2sDmaWriteIntTime[I2S_1]);
	}
#endif

#if 0
	if (gI2sTimes == 10)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 10 gI2sDmaWriteIntTime[I2S_1]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 20)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 20 gI2sDmaWriteIntTime[I2S_1]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 500)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 500 gI2sDmaWriteIntTime[I2S_1]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 1000)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 1000 gI2sDmaWriteIntTime[I2S_1]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 1500)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 1500 gI2sDmaWriteIntTime[I2S_1]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 3000)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 3000 gI2sDmaWriteIntTime[I2S_1]=%d.\n", zDrvTimer_Stamp());
	}
#endif

}

VOID Vp_I2S2ReadChangeBufLen(VOID)
{
#if 0 //latest use
	if (gI2sDmaReadIntTime[I2S_2] == 0)
	{
		gI2sDmaReadIntTime[I2S_2] = zDrvTimer_Stamp();
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_I2S2ReadChangeBufLen gI2sDmaReadIntTime[I2S_2] =%d.\n", gI2sDmaReadIntTime[I2S_2]);
	}
#endif
#if 0
	if (gI2sTimes == 10)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 10 gI2sDmaReadIntTime[I2S_2]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 20)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 20 gI2sDmaReadIntTime[I2S_2]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 500)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 500 gI2sDmaReadIntTime[I2S_2]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 1000)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 1000 gI2sDmaReadIntTime[I2S_2]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 1500)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 1500 gI2sDmaReadIntTime[I2S_2]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 3000)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 3000 gI2sDmaReadIntTime[I2S_2]=%d.\n", zDrvTimer_Stamp());
	}
#endif
	gI2sDmaReadIntTime[I2S_2] += 1;

	if (!(gI2sDmaReadIntTime[I2S_2] % 50))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "[I2S_1]=%d;[I2S_2]=%d.\n", gI2sDmaReadIntTime[I2S_1], gI2sDmaReadIntTime[I2S_2]);
	}
}

VOID Vp_I2S2WriteChangeBufLen(VOID)
{
#if 0 //latest use
	if (gI2sDmaWriteIntTime[I2S_2] == 0)
	{
		gI2sDmaWriteIntTime[I2S_2] = zDrvTimer_Stamp();
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_I2S2WriteChangeBufLen gI2sDmaWriteIntTime[I2S_2] =%d.\n", gI2sDmaWriteIntTime[I2S_2]);
	}
#endif
#if 0
	if (gI2sTimes == 10)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 10 gI2sDmaWriteIntTime[I2S_2]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 20)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 20 gI2sDmaWriteIntTime[I2S_2]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 500)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 500 gI2sDmaWriteIntTime[I2S_2]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 1000)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 1000 gI2sDmaWriteIntTime[I2S_2]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 1500)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 1500 gI2sDmaWriteIntTime[I2S_2]=%d.\n", zDrvTimer_Stamp());
	}

	if (gI2sTimes == 3000)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " gI2sTimes == 3000 gI2sDmaWriteIntTime[I2S_2]=%d.\n", zDrvTimer_Stamp());
	}
#endif

}

#endif
SINT32 zDrvVp_GetVoiceState(VOID **pVoiceState)
{
	//SINT32 ret = DRV_SUCCESS;//xiu gai chu
	*pVoiceState = &g_voiceVar;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " zDrvVp_GetVoiceState pVoiceState=%p.\n", *pVoiceState);
	return DRV_SUCCESS;
}


