/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98D_PPPOE
*    : pppoe_fnc.h
* ļ : 
* ʵֹ : PPPoEģӿڷװ
*      : liuzhengxuan
*      : V1.0
*  : 2012-08-03
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : liuzhengxuan
* ޸ : 2012-06-18
* ޸ : EC 
*             1)617001563315 Ĺoss_api.hļƳpsbuf.h
*             ļ
*
**************************************************************************/
#ifndef _PPPOE_FNC_H 
#define _PPPOE_FNC_H

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#include "oss_ppp.h"
#include "drvs_serial_device.h"
#include "zpsi_api.h"
/* P98D-LZX-0001 2012/06/18 EC:617001563315 Ĺoss_api.hļƳpsbuf.hļ BEGIN    */
#include "psbuf.h"  
/* P98D-LZX-0001 2012/06/18 EC:617001563315 Ĺoss_api.hļƳpsbuf.hļ END      */

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 
**************************************************************************/
/* PPPoE֡ṹ峤 */
#define ZOSS_PPPOE_MAC_SIZE                 6
#define ZOSS_PPPOE_ETHER_FRAMETYPE_SIZE     2
#define ZOSS_PPPOE_ETHER_FRAMEHEAD_SIZE     (ZOSS_PPPOE_MAC_SIZE * 2 + ZOSS_PPPOE_ETHER_FRAMETYPE_SIZE)
#define ZOSS_PPPOE_ETHER_FRAMEVERIFY_SIZE   0 

#define ZOSS_PPPOE_HEAD_SIZE                6           /* Э: 4λ汾 + 4λ + 8λ + 16λỰID + 16λ    */
#define ZOSS_PPPOE_SESSIONID_SIZE           2
#define ZOSS_PPPOE_PURELOAD_LEN_SIZE        2

#define ZOSS_PPPOE_TAG_TYPE_SIZE            2
#define ZOSS_PPPOE_TAG_LEN_SIZE             2

#define ZOSS_PPPOE_PPP_PROTOCOL_LEN         2
#define ZOSS_PPPOE_PPP_VERIFY_LEN           2

/* ʼ */
#define ZOSS_PPPOE_ACNAME                   "ZTE-P98D-LTE"

/* ¸ʵ */
#define ZOSS_PPPOE_MAX_BYTE_VALUE           255
#define ZOSS_PPPOE_MAX_IPDATA_LEN           65535
#define ZOSS_PPPOE_MAX_PPPOEDATA_LEN        (65535 - 6) /* PPPoE󳤶ȵPPP󳤶ȼȥPPPoEͷ                */
#define ZOSS_PPPOE_MAX_ACNAME_LEN           20
#define ZOSS_PPPOE_MAX_SERVICENAME_LEN      20
#define ZOSS_PPPOE_MAX_RUNTIME_PROPERTY     20
#define ZOSS_PPPOE_MAX_COMMON_TAG_LEN       250
#define ZOSS_PPPOE_MAX_TAG_INC_LEN          50

/* PPPoE֡ */
#define PPPOE_ETHER_DISCOVER    0x8863
#define PPPOE_ETHER_SESSION     0x8864

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef enum
{
    PPPOE_STATE_NULL,
    PPPOE_STATE_DISCOVERY,
    PPPOE_STATE_SESSION
}T_zOss_PPPoEState;

typedef enum
{
    PPPOE_PPP_FRAMETYPE_INVLID  = 0,
    PPPOE_PPP_FRAMETYPE_IP      = 0x0021,
    PPPOE_PPP_FRAMETYPE_IPV6    = 0x0057,
    PPPOE_PPP_FRAMETYPE_LCP     = 0xC021,
    PPPOE_PPP_FRAMETYPE_NCP     = 0x8021
}T_zOss_PPPoEPPPFrameType;

typedef enum
{
    PPPOE_TAGTYPE_END_OF_LIST        = 0x0000,
    PPPOE_TAGTYPE_SERVICE_NAME       = 0x0101,
    PPPOE_TAGTYPE_AC_NAME            = 0x0102,
    PPPOE_TAGTYPE_HOST_UNIQ          = 0x0103,
    PPPOE_TAGTYPE_AC_COOKIE          = 0x0104,
    PPPOE_TAGTYPE_VERDOR_SPECOFIC    = 0x0105,
    PPPOE_TAGTYPE_RELAY_SESSION_ID   = 0x0110,
    PPPOE_TAGTYPE_SERVICE_NAME_ERROR = 0x0201,
    PPPOE_TAGTYPE_AC_SYSTEM_ERROR    = 0x0202, 
    PPPOE_TAGTYPE_GENERIC_ERROR      = 0x0203
}T_zOss_PPPoETagType;

typedef enum
{
    PPPOE_CODETYPE_PADI    = 0x09,
    PPPOE_CODETYPE_PADO    = 0x07,
    PPPOE_CODETYPE_PADR    = 0x19,
    PPPOE_CODETYPE_PADS    = 0x65,
    PPPOE_CODETYPE_SESSION = 0x00,
    PPPOE_CODETYPE_PADT    = 0xa7,
    PPPOE_CODETYPE_INVALID = 0xff
}T_zOss_PPPoEFrameType;

typedef struct
{
    UINT8 tagType[ZOSS_PPPOE_TAG_TYPE_SIZE];
    UINT8 tapLen[ZOSS_PPPOE_TAG_LEN_SIZE];
}T_zOss_PPPoETagHead;

typedef struct
{
    T_zOss_PPPoETagType tagType;
    UINT16              tagLen;
    UINT8               *pTagContent;
}T_zOss_PPPoETag;

typedef enum
{
    PPPOE_RST_EXTRMOD_ERR = -3,
    PPPOE_RST_PARAM_ERR,   
    PPPOE_RST_RUN_ERR,     
    PPPOE_RST_SUCESS,      
    PPPOE_RST_OVER,        
    PPPOP_RST_EXIT,        
    PPPOP_RST_NOTSUPT,     
    PPPOE_RST_TURN        
}T_zOss_PPPoERst;

typedef struct
{
    UINT8               atiCh; 
    UINT32              sioFd; 
    BOOL                (*GetPdpIpAddr)(VOID *pPppIpAddrs, UINT8 iChnelId);
    VOID                (*upData)(UINT32 pppOprId, T_z_UpLink_Sdu *ipPacket, SINT32 len, UINT8 chID);
    SINT32              (*sioRead)(UINT32 uiFd, T_ZDrv_BufNode *pBuf); 
    SINT32              (*sioWrite)(UINT32 uiFd, T_ZDrv_BufNode *pBuf); 
    SINT32              (*sio_free_read_buffer)(UINT32 uiFd);
    SINT32              (*sio_get_write_buffer)(UINT32 uiFd, T_ZDrv_BufNode *pBuf);
    VOID                (*sioReadUnblock)(UINT32 fd); 
    VOID                (*sioReadBlock)(UINT32 fd);
    T_z_UpLink_Sdu*     (*getUpLinkSdu)(VOID);
    VOID                (*freeUpLinkSdu)(T_z_UpLink_Sdu *pSdu);
    T_z_DownLink_Sdu*   (*getDownLinkSdu)(VOID);
    VOID                (*freeDownLinkSdu)(T_z_DownLink_Sdu *pSdu);
    VOID                (*free_upLinkSdu)(T_z_DownLink_Sdu *pSdu);
    VOID                (*get_downLinkSdu)(VOID);
    VOID                (*PPPoEStateCB)(UINT32 PPPoE_ID, UINT8 chID, T_zOss_PPPoEState serState, VOID *inputArg);
}T_ZOss_PPPoESerEnvir;

typedef struct
{
    UINT8                   clientMAC[ZOSS_PPPOE_MAC_SIZE];
    T_zOss_PPPoEFrameType   lastFrameType; 
    T_zOss_PPPoETag         runTimeTag[ZOSS_PPPOE_MAX_RUNTIME_PROPERTY];
}T_zOss_PPPoERunTime;

typedef struct
{
    T_zOss_PPPoEState       serState;
    UINT8                   pppId;
    UINT16                  sessonid;
    T_zOss_PPPoERunTime     runTime;
    T_ZOss_PPPoESerEnvir    serEnvir;
}T_zOss_PPPoEContext;

typedef struct
{
    UINT8               acName[ZOSS_PPPOE_MAX_ACNAME_LEN + 1];
    UINT8               maxPPPoECount;
    T_zOss_PPPoEContext *pPPPoEContext;
}T_zOss_PPPoEModContext;

typedef struct
{
    UINT8   destMAC[ZOSS_PPPOE_MAC_SIZE];
    UINT8   srcMAC[ZOSS_PPPOE_MAC_SIZE];
    UINT16  frameType; 
}T_zOss_PPPoEEtherFrameHead;

typedef struct
{
    UINT8   version : 4;
    UINT8   type : 4;
    UINT8   code;
    UINT16  sessionID; 
    UINT16  pureLoadLen; 
}T_zOss_PPPoEFrameHead;

typedef struct
{
    UINT8   protocol[ZOSS_PPPOE_PPP_PROTOCOL_LEN];
    UINT8   *pData;
    UINT32  dataSize;
    UINT8   verify[ZOSS_PPPOE_PPP_VERIFY_LEN];
}T_zOss_PPPoEPPPdata;

typedef struct
{
   UINT8    *data;
   UINT32   dataSize;
}T_zOss_DataHook;

typedef T_zOss_PPPoERst (*T_zOssPPPoEReceiveTag)(const T_zOss_PPPoETag *pTag, T_zOss_PPPoEContext *pPPPoECtontext);

typedef struct
{
    T_zOss_PPPoETagType     tagType;
    T_zOssPPPoEReceiveTag   tagHanle;   
}T_zOss_PPPoEReceiveTagMap;

typedef T_zOss_PPPoERst (*T_zOssPPPoERespondTag)(const T_zOss_PPPoETag *pTag, 
                                                 T_zOss_PPPoEContext *pPPPoECtontext, 
                                                 T_zOss_PPPoETag *pResTag);

typedef struct
{
    T_zOss_PPPoETagType     tagType;
    T_zOssPPPoERespondTag   tagHanle;   
}T_zOss_PPPoERespondTagMap;

/**************************************************************************
* 
**************************************************************************/
BOOL zOss_InitPPPoE(UINT8 maxPPPoECount);
UINT32 zOss_PPPoEInitPPP(VOID);
UINT32 zOss_OpenPPPoE(T_ZOss_PPPoESerEnvir *PPPoESio);
T_zOss_PPPoERst zOss_RunPPPoE(UINT32 PPPoE_ID);
BOOL zOss_WriteDataToPPPoE(UINT32 PPPoE_ID, UINT8 *buff, UINT32 buffSize);
SINT32 zOss_ClosePPPoE(UINT32 PPPoE_ID);  
T_zOss_PPPoERst zOss_CancelPPPoE(UINT32 PPPoE_ID);

/**************************************************************************
* ȫֱ
**************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* _PPPOE_FNC_H */

