/**************************************************************************
*
*             Protocol Stack Adapter Layer Telephone Interface
*
*                  Copyright (c) 2007 ZTE Corporation.
*
***************************************************************************
*
*   汾 :   ͨѶɷ޹˾ ֻҵ 
*   ģ   :   ATI2ģԴļ
*      :   zati_distribute_fnc.c
*   ļʶ :   
*   ļ : 
*   ʵֹ :   
*        :   
*        :   1.0
*    :   2012/01/09
*   ˵ :
***************************************************************************/

#include "ps/src/nas/ati/inc/zati_com.h"
#ifdef USE_VOICE_SUPPORT
#include "ps/src/nas/ati/inc/zati_cc.h"
#endif
#include "ps/src/nas/ati/inc/zati_sm.h"
#include "ps/src/nas/ati/inc/zati_sms.h"
#include "ps/src/nas/ati/inc/zati_othr.h"
#include "ps/src/nas/ati/inc/zati_umm.h"
#include "ps/src/nas/ati/inc/zati_ss.h"
#include "ps/src/nas/ati/inc/zat_com.h"
#include "ps/src/nas/ati/inc/zat_ext_fnc.h"

#ifdef USE_VOICE_SUPPORT
static VOID zAti_RingInd(const T_zMmiaCc_Mtc_Ind *ptMtcInd);
static VOID zAti_CRingInd(const T_zMmiaCc_Mtc_Ind *ptMtcInd);
static BYTE zAti_GetEndStatus(WORD wCause);
#endif
static DWORD zAti_ReadSmFromMem(const T_zApMmia_ReadSm_Cnf* ptReadSmCnf, DWORD * pdwChangedMsgId);
static VOID zAti_HandleNetEmerBerServ(T_zMmiaUmm_PlmnInfo_Ind* ptPlmnInfo,T_zDev_AtMem_Mmia_PrivateMem* ptAtData);

extern BYTE zAti_GetSubActAccord2SubMode (BYTE bSubMode);
/*2016.4.27޸ļȺ󣬿gpioػģʽgpio*/
//#ifdef BTRUNK_SUPPORT
//extern VOID zDrvGpio_SetGpio111Low(VOID);
//extern VOID zDrvGpio_SetGpio111High(VOID);
//#endif
extern VOID zAt_SmUndefineNvPdpCont(BYTE bCid);
extern BYTE zDev_IsMtNet(VOID);

VOID zAti_DecMultiCmd(T_ZAti_ChannelInfo * pChnelNode);

T_zAti_DistributeMsgTab g_atDistributeMsgMap [ATI_DISTRIBUTE_FUNC_EVENT_END + 9] = {
#ifdef USE_VOICE_SUPPORT
    {ATI_DISTRIBUTE_FUNC_CACM_SET_REQ_EV, zAti_CacmSetReq},
    {ATI_DISTRIBUTE_FUNC_CAMM_SET_REQ_EV, zAti_CammSetReq},
    {ATI_DISTRIBUTE_FUNC_CPUC_SET_REQ_EV, zAti_CpucSetReq},
#endif
    {ATI_DISTRIBUTE_FUNC_CPIN_REQ_EV, zAti_PinReq},
    {ATI_DISTRIBUTE_FUNC_EM_CELL_INFO_REQ_EV, zAti_EM_CellInfoSetReq},
    {ATI_DISTRIBUTE_FUNC_CELLINFO_QRY_REQ_EV, zAti_EM_CellInfoQryReq},
    {ATI_DISTRIBUTE_FUNC_CELLQRY_REQ_EV, zAti_EM_CellInfoQryReqByIndex},
    {ATI_DISTRIBUTE_FUNC_EM_HO_INFO_REQ_EV, zAti_EM_HoInfoSetReq},
    {ATI_DISTRIBUTE_FUNC_ZRPT_RXLEV_REQ_EV, zAti_ZRptRxlevReq},
    {ATI_DISTRIBUTE_FUNC_RXLEV_REQ_EV, zAti_RxlevReq},
    {ATI_DISTRIBUTE_FUNC_ZCSQ_REQ_EV, zAti_ZcsqReq},
    {ATI_DISTRIBUTE_FUNC_AUTO_START_REQ_EV, zAti_AutoStartReq},
    {ATI_DISTRIBUTE_FUNC_COPS_SET_REQ_EV, zAti_CopsSet},
    {ATI_DISTRIBUTE_FUNC_TCSMP_REQ_EV, zAti_SmsTcsmpReq},
    {ATI_DISTRIBUTE_FUNC_CLCK_SET_REQ_EV, zAti_SsClckSet},
    {ATI_DISTRIBUTE_FUNC_CPWD_SET_REQ_EV, zAti_SsCpwdSet},
    {ATI_DISTRIBUTE_FUNC_CUSD_SET_REQ_EV, zAti_SsCusdSetReq},
    {ATI_DISTRIBUTE_FUNC_CSCA_REQ_EV, zAti_SmsCscaReq},
    {ATI_DISTRIBUTE_FUNC_CGACT_REQ_EV, zAti_SmCgactExc},
    {ATI_DISTRIBUTE_FUNC_ZGACT_REQ_EV, zAti_SmZgactReq},
    {ATI_DISTRIBUTE_FUNC_CGANS_REQ_EV, zAti_SmAnsReq},
    {ATI_DISTRIBUTE_FUNC_CEER_REQ_EV, zAti_CeerReq},
    {ATI_DISTRIBUTE_FUNC_TCMGS_REQ_EV, zAti_SmsTcmgsReq},
    {ATI_DISTRIBUTE_FUNC_TCMGW_REQ_EV, zAti_SmsTcmgwReq},
    {ATI_DISTRIBUTE_FUNC_TCMGC_REQ_EV, zAti_SmsTcmgcReq},
    {ATI_DISTRIBUTE_FUNC_PCNMA_REQ_EV, zAti_SmsPcnmaReq},
    {ATI_DISTRIBUTE_FUNC_PCMGS_REQ_EV, zAti_SmsPcmgsReq},
    {ATI_DISTRIBUTE_FUNC_PCMGW_REQ_EV, zAti_SmsPcmgwReq},
    {ATI_DISTRIBUTE_FUNC_PCMGC_REQ_EV, zAti_SmsPcmgcReq},
#ifdef USE_VOICE_SUPPORT
    {ATI_DISTRIBUTE_FUNC_ZCFIS_SET_REQ_EV, zAti_ZcfisSetReq},
#endif
    {ATI_DISTRIBUTE_FUNC_MB_AUTH_REQ_EV, zAti_UiccMbauReq},
    {ATI_DISTRIBUTE_FUNC_CFUN_SET_REQ_EV, zAti_CfunSet},
    {ATI_DISTRIBUTE_FUNC_ZPIN2_SET_REQ_EV, zAti_Zpin2Set},
    {ATI_DISTRIBUTE_FUNC_TMGIACT_REQ_EV, zAt_ZtmgiActiveReq},
    {ATI_DISTRIBUTE_FUNC_COPN_QRY_REQ_EV, zAt_CopnQryReq},
    {ATI_DISTRIBUTE_FUNC_CESQ_REQ_EV, zAti_CesqQryReq},
    {ATI_DISTRIBUTE_FUNC_ZLBS_REQ_EV, zAti_ZlbsReq},
    {ATI_DISTRIBUTE_FUNC_ZTPMR_REQ_EV, zAti_SmsTpmrReq},
#ifdef _USE_LPP_ECID
    {ATI_DISTRIBUTE_FUNC_ZMOLR_REQ_EV, zAti_SsMolrReq},
#endif
#ifdef PS_RAT_LTE
    {ATI_DISTRIBUTE_FUNC_ZIMSDATDEL_REQ_EV, zAti_ImsDatadelReq},
#endif
#ifdef DSDS_VSIM
    {ATI_DISTRIBUTE_FUNC_CARDSWITCH_REQ_EV, zAti_CardSwitchReq},
#endif

    //  Stm 
    {EV_ZATI2_CpbrExeReq_Ev,zAti_ProcCpbr},
    {EV_ZATI2_SmsCmglReq_Ev,zAti_ProcSmsCmglReq},
    {EV_ZATI2_ZWEN_SET_REQ,zAti_ProcPbAddUserEn},
    {EV_ZATI2_SmsCmgdTestReq_Ev,zAti_ProcSmsCmgdTest},
    {EV_ZATI2_DTMF_REQ, zAti_ProcDtmfReq},

    {MMIA_SM_DATA_STATE_REQ_EV, zAti_PppTransCidAndSendActReq},
    {MMIA_SM_DISCONNECT_REQ_EV, zAti_SmDisconnectReq},
    {MMIA_L1E_ZEPCG_REQ, zAti_ZepcgReq},
};


VOID __ps_static_func zAti_HandleMsgBuff()
{
    if(g_zAti_atDataEx[g_zAti_CurInstance].ptCardInitChnlOfFirstCmd!= NULL 
      && g_zAti_atDataEx[g_zAti_CurInstance].ptCardInitChnlOfFirstCmd->bIsCardIniting == TRUE)
    {
        zAti_DecMultiCmd(g_zAti_atDataEx[g_zAti_CurInstance].ptCardInitChnlOfFirstCmd);
        g_zAti_atDataEx[g_zAti_CurInstance].ptCardInitChnlOfFirstCmd->bIsCardIniting = FALSE;
    }
}

VOID __ps_static_func zAti_IndiCatIccid(T_zApUicc_Init_Cnf* ptUiccInitCnf)
{
     T_zApUicc_Init_Cnf *pTempUiccInitCnf = ZOSS_NULL;
     pTempUiccInitCnf = (T_zApUicc_Init_Cnf*)zAti_GetUB(sizeof(T_zApUicc_Init_Cnf));

     zOss_Memcpy(pTempUiccInitCnf, ptUiccInitCnf,sizeof(T_zApUicc_Init_Cnf));
     zAti_RecvServerHandlerSlaver(AP_MMIA_ICCID_IND_EV, (PBYTE)pTempUiccInitCnf, sizeof(T_zApUicc_Init_Cnf));  
}
#ifdef USE_VOICE_SUPPORT
BYTE zAti_CcMocCnfCheckPara (T_zMmiaCc_Moc_Cnf *ptMocCnf)
{
    if ((ptMocCnf->bResult != Z_MMIACC_RESULT_OK)         && 
        (ptMocCnf->bResult != Z_MMIACC_RESULT_USERBUSY)   && 
        (ptMocCnf->bResult != Z_MMIACC_RESULT_NOCARRIER)  &&
        (ptMocCnf->bResult != Z_MMIACC_RESULT_CONNECT)    && 
        (ptMocCnf->bResult != Z_MMIACC_RESULT_NOANSWER)   &&
        (ptMocCnf->bResult != Z_MMIACC_RESULT_ERROR))
    {
        return Z_INVALID;
    }

    if(!zAti_IsValidCrOfCC(ptMocCnf->bServ))
    {
        return Z_INVALID;
    }

    if ((Z_APMMIA_VALID == ptMocCnf->bCalledNumFg) && 
        (ptMocCnf->tCalledNum.bNumLen > Z_MAX_CALLNUM_LEN))
    {
        return Z_INVALID;
    }

    if ((Z_APMMIA_VALID == ptMocCnf->bCalledSubAddrFg) && 
        (ptMocCnf->tCalledSubAddr.bSubAddrLen > Z_MAX_SUBADDR_LEN))
    {
        return Z_INVALID;
    }

    if (ptMocCnf->wCause > Z_MMIACC_NW_END)   /* շֻȡ01 */
    {
        return Z_INVALID;
    }

    return Z_VALID;
}

VOID zAti_CcConnInd (BYTE bSrcIndex, BYTE bDesIndex, BYTE bCallId, BYTE bCallType)
{
    T_zApMmia_Conn_Ind *ptConnInd = (T_zApMmia_Conn_Ind *)zAti_GetUB(sizeof(T_zApMmia_Conn_Ind));
    ptConnInd->bSrcIndex = bSrcIndex;
    ptConnInd->bDesIndex = bDesIndex;
    ptConnInd->bCallId   = bCallId;
    ptConnInd->bCallType = bCallType;

    zAti_RecvServerHandlerSlaver(AP_MMIA_CONN_IND_EV, (UINT8 *)ptConnInd, sizeof(T_zApMmia_Conn_Ind));
    return;
}

VOID zAti_CcCendInd (BYTE bSrcIndex, BYTE bDesIndex, BYTE bCallId, BYTE bResult, WORD wCause)
{
    T_zApMmia_Cend_Ind *ptCendInd = (T_zApMmia_Cend_Ind *)zAti_GetUB(sizeof(T_zApMmia_Cend_Ind));
    ptCendInd->bSrcIndex = bSrcIndex;
    ptCendInd->bDesIndex = bDesIndex;
    ptCendInd->bCallId   = bCallId;               

    if ((Z_MMIACC_RESULT_ERROR     == bResult) ||
        (Z_MMIACC_RESULT_NOCARRIER == bResult))
    {
        ptCendInd->bEndStatus = Z_APMMIA_CM_CALL_END_CONF_FAILED;
    }
    else
    {
        ptCendInd->bEndStatus = zAti_GetEndStatus(wCause);
        ptCendInd->bCcCauseFg = (Z_APMMIA_CM_CALL_END_NETWORK_END == ptCendInd->bEndStatus) ? Z_APMMIA_VALID : Z_APMMIA_INVALID;
        ptCendInd->bCcCause  = wCause & 0x00ff;
    }
    zAti_RecvServerHandlerSlaver(AP_MMIA_CEND_IND_EV, (UINT8 *)ptCendInd, sizeof(T_zApMmia_Cend_Ind));
}

VOID zAti_CcColpInd (T_zMmiaCc_Moc_Cnf *ptMocCnf)
{
    T_zApMmia_Colp_Ind *ptApColpInd = (T_zApMmia_Colp_Ind *)zAti_GetUB(sizeof(T_zApMmia_Colp_Ind));
    T_zApMmia_QryPhoneResult l_tQryPbResult = {0};

    ptApColpInd->bSrcIndex = ptMocCnf->bSrcIndex;
    ptApColpInd->bDesIndex = ptMocCnf->bDesIndex;
    ptApColpInd->bCallId   = ptMocCnf->bCallId;
    
    /* called bcdNum */
    ptApColpInd->tCalledNum = ptMocCnf->tCalledNum;
    
    /* subaddr ڱʱֻжϱ־λЧŶЧֶθֵ*/
    ptApColpInd->bSubAdrFg = (Z_APMMIA_VALID == ptMocCnf->bCalledSubAddrFg) ? Z_APMMIA_VALID : Z_APMMIA_INVALID;
    ptApColpInd->tSubAdr   = ptMocCnf->tCalledSubAddr;
    
    /* calling name */
    zStmPb_FindNameByNum(&(ptApColpInd->tCalledNum), &l_tQryPbResult, (T_zStm_TaskIdx)g_zAti_CurInstance);

    ptApColpInd->bCallingNameFg = (Z_ATI_QRYPB_SUCC == zAti_CheckQryPbResult(&l_tQryPbResult))? Z_APMMIA_VALID : Z_APMMIA_INVALID;
    ptApColpInd->tCallingName = l_tQryPbResult.tText;

    zAti_RecvServerHandlerSlaver(AP_MMIA_COLP_IND_EV, (UINT8 *)ptApColpInd, sizeof(T_zApMmia_Colp_Ind));
}

BYTE zAti_GetEndStatus(WORD wCause)
{
    return (wCause >= Z_MMIACC_NW_BASE) ? Z_APMMIA_CM_CALL_END_NETWORK_END : Z_APMMIA_CM_CALL_END_CLIENT_END;
}
#endif
VOID zAti_CrInd (BYTE bSrcIndex, BYTE bDesIndex, BYTE bServ, BYTE bCallId)
{
    T_zApMmia_Cr_Ind * ptApCrInd = (T_zApMmia_Cr_Ind *)zAti_GetUB(sizeof(T_zApMmia_Cr_Ind));
    ptApCrInd->bSrcIndex = bSrcIndex;
    ptApCrInd->bDesIndex = bDesIndex;
    ptApCrInd->bSrvType = bServ;
    ptApCrInd->bCallId = bCallId;

    zAti_RecvServerHandlerSlaver(AP_MMIA_CR_IND_EV, (UINT8 *)ptApCrInd, sizeof(T_zApMmia_Cr_Ind));
}
#ifdef USE_VOICE_SUPPORT
DWORD zAti_CcMocCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaCc_Moc_Cnf*           ptMocCnf        = (T_zMmiaCc_Moc_Cnf*)pBuff;
    T_zDev_AtMem_Mmia_PrivateMem tAtData         = {0};
#ifdef Z_DUALCARD_ADAPT
    if(Z_VALID == zAti_IsDualPsDualUicc())
    {
        if(ptMocCnf->bDesIndex == g_zAti_atDataEx[g_zAti_CurInstance].bAtdIndex)
        {
            g_zAti_atDataEx[g_zAti_CurInstance].bAtdIndex = 0;
        }
    }
#endif
    /*======================================  ====================================== */
    if (Z_INVALID == zAti_CcMocCnfCheckPara (ptMocCnf))
    {//Ӧ鲻ԣϢ Ϊ֮ǰѾظOK                    
        zAti_SendExpt2TraceAgt(ERR_InvalidPara, TRACE_ERR_LEVEL_SEVERE,"");
        return Z_APMMIA_NORESULT;
    }

    /*==617001738758 [ati]AT޸ĵ===== ´Ϣ ============= */
    switch(ptMocCnf->bResult) 
    {
        case Z_MMIACC_RESULT_OK:
        case Z_MMIACC_RESULT_CONNECT:
        {
            zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

            /*===== 1. colp ind =====================================================================*/
            /* 27007 7.8 : colp cr֮ǰϱ*/
            if ((Z_APMMIA_VALID    == ptMocCnf->bCalledNumFg) &&
                (Z_APMMIA_N_ENABLE == tAtData.bColpSet))
            {
                zAti_CcColpInd (ptMocCnf);
            }

            /*===== 2. cr ind =====================================================================*/

            if ((ptMocCnf->bServ != 0xff) && (Z_APMMIA_CR_ENABLE == tAtData.bCrSet))
            {
                zAti_CrInd (ptMocCnf->bSrcIndex, ptMocCnf->bDesIndex, ptMocCnf->bServ, ptMocCnf->bCallId);
            }

            zAti_CcConnInd (ptMocCnf->bSrcIndex, ptMocCnf->bDesIndex, ptMocCnf->bCallId, ptMocCnf->bCallType);
            break;
        }
        case Z_MMIACC_RESULT_ERROR:
        case Z_MMIACC_RESULT_NOANSWER:
        case Z_MMIACC_RESULT_USERBUSY:
        case Z_MMIACC_RESULT_NOCARRIER:
        {
            zAti_CcCendInd (ptMocCnf->bSrcIndex, ptMocCnf->bDesIndex, ptMocCnf->bCallId, ptMocCnf->bResult, ptMocCnf->wCause);
            break;
        }

        default:
            break;
    }
    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_CcSsNotifyInd
: յCCϱϢzPS_MMIACC_SsNotifyInd_Ev
    : pBuff,ָϢzPS_MMIACC_SsNotifyInd_EvϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_CcSsNotifyInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaCc_SsNotify_Ind           *ptCcSsNotify    = (T_zMmiaCc_SsNotify_Ind*)pBuff;
    T_zDev_AtMem_Mmia_PrivateMem     tAtData        = {0};

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    if (Z_MMIACC_CSSI_IND == ptCcSsNotify->bIorUFg)
    {
        if (Z_APMMIA_CSSN_CSSI_ENABLE == tAtData.tCssnSet.bCssiSet)
        {
            /*====================================== ȱʡֵ ==================================== */
            /*  syntax:   +CSSI: <code1>[,<index>]                                                   */ 
            /*  action: <index>ȱʡ                                                              */
            /*====================================================================================== */

            *pdwChangedMsgId = AP_MMIA_MO_CALL_SS_NOTIFY_IND_EV;
        }

    }
    else if (Z_MMIACC_CSSU_IND == ptCcSsNotify->bIorUFg)
    {
        if (Z_APMMIA_CSSN_CSSU_ENABLE == tAtData.tCssnSet.bCssuSet)
        {
            /*====================================== ȱʡֵ ==================================== */
            /*  syntax: +CSSU: <code2>[,<index>[,<number>,<type>[,<subaddr>,<satype>]]]              */ 
            /*  action: <index>,<number>,<subaddr>ȱʡ                                           */
            /*  action: <type>,<satype>ͺ                                                    */
            /*====================================================================================== */

            *pdwChangedMsgId = AP_MMIA_MT_CALL_SS_NOTIFY_IND_EV;
        }
    }
    else
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                       
    }

    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_CcDiscInd
: յCCϱϢzPS_MMIACC_DiscInd_Ev
    : pBuff,ָϢzPS_MMIACC_DiscInd_EvϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
617001738758 [ati]AT޸ĵ
***************************************************************************/
DWORD zAti_CcDiscInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaCc_Disc_Ind*      ptCcDiscInd = (T_zMmiaCc_Disc_Ind*)pBuff;
    
    if (ptCcDiscInd->wCause > Z_MMIACC_NW_END)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return Z_APMMIA_NORESULT;
    }

    zAti_CcCendInd (ptCcDiscInd->bSrcIndex, ptCcDiscInd->bDesIndex, ptCcDiscInd->bCallId, 1, ptCcDiscInd->wCause);
    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_CcModifyCnf
: յCCظϢzPS_MMIACC_ModifyCnf_Ev
    : pBuff,ָϢzPS_MMIACC_ModifyCnf_EvϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_CcModifyCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaCc_Modify_Cnf*        ptCcModifyCnf   = (T_zMmiaCc_Modify_Cnf*)pBuff; /* յCCظϢ */
    T_zDev_AtMem_Mmia_PrivateMem tAtData       = {0};

    if (ptCcModifyCnf->bResult == Z_SUCC)
    {
        if(!zAti_IsValidCrOfCC(ptCcModifyCnf->bServ))
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                       
            return Z_APMMIA_UNKNOWN_ERR;
        }
        
        /* NVȡ */
        zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
        
        if ((ptCcModifyCnf->bServ != 0xff) && (Z_APMMIA_CR_ENABLE == tAtData.bCrSet))
        {
            /* crϱmodifycnf */
            zAti_CrInd (ptCcModifyCnf->bSrcIndex, ptCcModifyCnf->bDesIndex, 
                    ptCcModifyCnf->bServ, ptCcModifyCnf->bCallId);
        }
    }
    *pdwChangedMsgId = AP_MMIA_CC_MODIFY_CNF_EV;
    return Z_APMMIA_NORESULT;
}

BYTE zAti_CcAnsModCnfCheckPara(T_zMmiaCc_AnsMod_Cnf *ptCcAnsModCnf)
{
    if ((ptCcAnsModCnf->bResult != Z_MMIACC_RESULT_OK)        && 
        (ptCcAnsModCnf->bResult != Z_MMIACC_RESULT_NOCARRIER) && 
        (ptCcAnsModCnf->bResult != Z_MMIACC_RESULT_CONNECT) &&
        (ptCcAnsModCnf->bResult != Z_MMIACC_RESULT_ERROR))
    {
        return Z_FAIL;
    }
    if(!zAti_IsValidCrOfCC(ptCcAnsModCnf->bServ))
    {
        return Z_FAIL;
    }

    if (ptCcAnsModCnf->wCause > Z_MMIACC_NW_END)
    {
        return Z_FAIL;
    }

    return Z_SUCC;
}

/**************************************************************************
: zAti_CcAnsModCnf
: յCCظϢzPS_MMIACC_AnsModCnf_Ev
    : pBuff,ָϢzPS_MMIACC_AnsModCnf_EvϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
1) 2009.6.22 SsFlag =1ServType=255жservTypeֵЧCRϱ
   ʱT_zApMmia_CcAnswer_CnfвSsFlagЧservTypeֵ.
2)617001738758 [ati]AT޸ĵ
***************************************************************************/
DWORD zAti_CcAnsModCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaCc_AnsMod_Cnf*        ptCcAnsModCnf   = (T_zMmiaCc_AnsMod_Cnf*)pBuff;
    T_zDev_AtMem_Mmia_PrivateMem tAtData       = {0};
    
    /*======================================  ====================================== */
    if (Z_FAIL == zAti_CcAnsModCnfCheckPara(ptCcAnsModCnf))
    {//Ӧ鲻ԣϢ Ϊ֮ǰѾظOK 
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return Z_APMMIA_NORESULT;
    }
    
    /*====================================== ´Ϣ ================================== */
    if ((Z_MMIACC_RESULT_OK      == ptCcAnsModCnf->bResult) || 
        (Z_MMIACC_RESULT_CONNECT == ptCcAnsModCnf->bResult))
    {
        /*===== 1. cr ind =====================================================================*/    
        zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

        if ((ptCcAnsModCnf->bServ != 0xff) && (Z_APMMIA_CR_ENABLE == tAtData.bCrSet))
        {
            zAti_CrInd (ptCcAnsModCnf->bSrcIndex, ptCcAnsModCnf->bDesIndex,
                    ptCcAnsModCnf->bServ, ptCcAnsModCnf->bCallId);
        }

        zAti_CcConnInd (ptCcAnsModCnf->bSrcIndex, ptCcAnsModCnf->bDesIndex, 
                 ptCcAnsModCnf->bCallId, ptCcAnsModCnf->bCallType);
    }
    else if (Z_MMIACC_RESULT_NOCARRIER == ptCcAnsModCnf->bResult)
    {
        zAti_CcCendInd (ptCcAnsModCnf->bSrcIndex, ptCcAnsModCnf->bDesIndex, ptCcAnsModCnf->bCallId, 1, ptCcAnsModCnf->wCause);
    }
    else//Z_MMIACC_RESULT_ERROR == ptCcAnsModCnf->bResult
    {
        /*ERRORʱҪϱΪѾظ*/
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
    }

    return Z_APMMIA_NORESULT;
}

/***************************************************************************
: zAti_RingInd
: MTʱϱring
:
    ptMtcInd: CCϢṹ
  ֵ:
    :
ע    : 
***************************************************************************/
static VOID zAti_RingInd(const T_zMmiaCc_Mtc_Ind *ptMtcInd)
{
    T_zApMmia_Ring_Ind*  ptRingInd = (T_zApMmia_Ring_Ind *)zAti_GetUB(sizeof(T_zApMmia_Ring_Ind));
    ptRingInd->bSrcIndex = ptMtcInd->bSrcIndex;
    ptRingInd->bDesIndex = ptMtcInd->bDesIndex;
    ptRingInd->bCallId   = ptMtcInd->bCallId;

    zAti_RecvServerHandlerSlaver(AP_MMIA_RING_IND_EV, (UINT8 *)ptRingInd, sizeof(T_zApMmia_Ring_Ind));
    return;
}

/***************************************************************************
: zAti_CRingInd
: MTʱϱCring
:
    ptMtcInd: CCϢṹ
  ֵ:
    :
ע    : 
***************************************************************************/
static VOID zAti_CRingInd(const T_zMmiaCc_Mtc_Ind *ptMtcInd)
{
    T_zApMmia_Cring_Ind* ptCringInd = (T_zApMmia_Cring_Ind *)zAti_GetUB(sizeof(T_zApMmia_Cring_Ind));
    
    /*====================================== ȱʡֵ ==================================== */
    /*  syntax:   +CRING: VOICE [,<priority>[,<subaddr>,<satype>]                            */ 
    /*  action: ȱʡ                                                                       */
    /*====================================================================================== */
    ptCringInd->bSrcIndex = ptMtcInd->bSrcIndex;
    ptCringInd->bDesIndex = ptMtcInd->bDesIndex;
    ptCringInd->bCallType = ptMtcInd->bCallType;
    ptCringInd->bPriFg    = ptMtcInd->bPriorityFg;
    ptCringInd->bPriority = ptMtcInd->bPriority;
    ptCringInd->bSubAdrFg = ptMtcInd->bCallingSubAddr;

    if (Z_APMMIA_VALID == ptMtcInd->bCallingSubAddr)
    {
        ptCringInd->tSubAdr = ptMtcInd->tCallingSubAddr;
    }

    ptCringInd->bCallId   = ptMtcInd->bCallId;

    zAti_RecvServerHandlerSlaver(AP_MMIA_CRING_IND_EV, (UINT8 *)ptCringInd, sizeof(T_zApMmia_Cring_Ind));
}

VOID zAti_CcCrcIndicate (T_zMmiaCc_Mtc_Ind *ptMtcInd, BYTE bCrcSet)
{
    if (bCrcSet == Z_APMMIA_CRC_ENABLE)
    {
        zAti_CRingInd(ptMtcInd);
    }
    else
    {
        zAti_RingInd(ptMtcInd);
    }
}

BYTE zAti_CcMtcIndSetCli (BYTE bNoCliCause, PBYTE pbCli)
{
    switch(bNoCliCause) 
    {
        case Z_MMIACC_NOCLI_REJBYUSER:
            *pbCli = Z_APMMIA_CLI_WITHHELD;
            break;
    
        case Z_MMIACC_NOCLI_UNAVAIL:
        case Z_MMIACC_NOCLI_INTERACTWITHOSRV:
        case Z_MMIACC_NOCLI_COINLINE:
            *pbCli = Z_APMMIA_CLI_NOTAVAIL;
            break;
    
        default:
            return Z_FAIL;
    }

    return Z_SUCC;
}

DWORD zAti_CcClipInd (T_zMmiaCc_Mtc_Ind *ptMtcInd)
{
    T_zApMmia_Clip_Ind * ptClipInd = (T_zApMmia_Clip_Ind *)zAti_GetUB(sizeof(T_zApMmia_Clip_Ind));
    T_zApMmia_QryPhoneResult l_tQryPbResult = {0};

    ptClipInd->bSrcIndex = ptMtcInd->bSrcIndex;
    ptClipInd->bDesIndex = ptMtcInd->bDesIndex;
    ptClipInd->bSubAdrFg = ptMtcInd->bCallingSubAddr;
    ptClipInd->bCallId = ptMtcInd->bCallId;
    
    if (Z_APMMIA_VALID == ptMtcInd->bCallingSubAddr)
    {
        ptClipInd->tSubAdr = ptMtcInd->tCallingSubAddr;
    }
    /* 
       * Э27007 7.6ΪCQNJ00185333޸
       * <CLI validity>:
       * 0  CLI valid
       * 1  CLI has been withheld by the originator.
       * 2  CLI is not available due to interworking problems or limitations of originating network. 
       */
    if (Z_VALID == ptMtcInd->bNoCliCauseFg)
    {
        if (zAti_CcMtcIndSetCli (ptMtcInd->bNoCliCause, &ptClipInd->bCli) != Z_SUCC)
        {
            zAti_RetUB((VOID **)&ptClipInd);
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
            return Z_APMMIA_NORESULT;
        }
        ptClipInd->bCliFg = Z_APMMIA_VALID;
    }
    else
    {
        /* ಻ṩcliϢΪʾ */
        ptClipInd->bCliFg = Z_APMMIA_INVALID;
    }
    
    /*=============================== кѯ ================================================*/
    /* 
       * Э27007 7.6CLI2Ӧʾnumber û;
       * CLI1пЯnumbermmiaϱҲܲmmiaϱ
       * ΪCQNJ00185333޸ 
       */
    if (ptClipInd->bCliFg == Z_APMMIA_VALID && ptClipInd->bCli == Z_APMMIA_CLI_NOTAVAIL)
    {
        ptClipInd->bCallingNameFg = Z_APMMIA_INVALID;
    }
    else if (Z_APMMIA_VALID == ptMtcInd->bCallingNumFg)
    {
        ptClipInd->tConnNum = ptMtcInd->tCallingNum;
        zStmPb_FindNameByNum(&(ptClipInd->tConnNum), &l_tQryPbResult, (T_zStm_TaskIdx)g_zAti_CurInstance);

        ptClipInd->bCallingNameFg = (Z_ATI_QRYPB_SUCC == zAti_CheckQryPbResult(&l_tQryPbResult)) ? Z_APMMIA_VALID : Z_APMMIA_INVALID;
        ptClipInd->tCallingName   = l_tQryPbResult.tText;
    }
    else
    {
        ptClipInd->bCallingNameFg = Z_APMMIA_INVALID;
    }
    zAti_RecvServerHandlerSlaver(AP_MMIA_CLIP_IND_EV, (UINT8 *)ptClipInd, sizeof(T_zApMmia_Clip_Ind));

    return Z_APMMIA_NORESULT;
}



/**************************************************************************
: zAti_CcMtcInd
: յCCϱϢzPS_MMIACC_MtcInd_Ev
    : pBuff,ָϢzPS_MMIACC_MtcInd_EvϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_NVFAILUER_ERR     дNVʧ
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_CcMtcInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaCc_Mtc_Ind*           ptMtcInd        = (T_zMmiaCc_Mtc_Ind*)pBuff;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    T_zMmiaCc_Mtc_Rsp      *pCcMtcRsp = NULL;

    if (ptMtcInd->tCallingNum.bNumLen > Z_ATI_MAX_CALLINGBCDNUM_NUM)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return Z_APMMIA_NORESULT;
    }

    pCcMtcRsp = (T_zMmiaCc_Mtc_Rsp *)zAti_GetUB(sizeof(T_zMmiaCc_Mtc_Rsp));
    pCcMtcRsp->bSrcIndex = ptMtcInd->bDesIndex;
    pCcMtcRsp->bDesIndex = ptMtcInd->bSrcIndex;
    pCcMtcRsp->bResult = Z_APMMIA_MTC_ACCEPT;
    zAti_MsgSend(MMIA_CC_MTC_RSP_EV, (PBYTE)pCcMtcRsp, sizeof(T_zMmiaCc_Mtc_Rsp),Z_ATI_TASKID_CC);

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    switch(ptMtcInd->bCwFg)
    {
        case Z_MMIACC_CALL_NORMAL:
            {
                zAti_CcCrcIndicate (ptMtcInd, tAtData.bCrcSet);

                /* 27007 7.6 : clipInd ring/cringϱ */
                if (Z_APMMIA_N_ENABLE == tAtData.bClipSet)
                {
                    return zAti_CcClipInd (ptMtcInd);
                }
                return Z_APMMIA_NORESULT;
            }
        case Z_MMIACC_CALL_WAITING:
            {
                /*====================================== ȱʡֵ ==================================== */
                /*  syntax: +CCWA: <number>,<type>,<class>,[<alpha>][,<CLI validity>                     */
                /*                 [,<subaddr>,<satype> [,<priority> ]]]                                 */ 
                /*  action: <CLI validity> Ŀǰӳ䷽ʽȱʡȱʡ                            */
                /*====================================================================================== */
                if (Z_APMMIA_N_DISABLE == tAtData.bCcwaSet)
                {
                    /*===================================================================================*/
                    /*======================== еȴϱδ򿪣ring/cringϱ =====================*/
                    /*===================================================================================*/
                    zAti_CcCrcIndicate (ptMtcInd, tAtData.bCrcSet);
                    
                    /*617001840321AT+CLIP=1յڶ·УCCATIϱ룬ATIûϱ*/
                    if (Z_APMMIA_N_ENABLE == tAtData.bClipSet)
                    {
                        return zAti_CcClipInd (ptMtcInd);
                    }
                }
                else
                {
                    /*===================================================================================*/
                    /*======================== еȴϱ򿪣ccwaInd ϱ =========================*/
                    /*===================================================================================*/
                    *pdwChangedMsgId = AP_MMIA_CCWA_IND_EV;
                    return Z_APMMIA_NORESULT;
                }

                return Z_APMMIA_NORESULT;
            }
        default:
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
                return Z_APMMIA_NORESULT;
            }
    }    
    
}

/**************************************************************************
: zAti_DoProcInfoInd
: ȽϽк
    : bEccLen pEccCodebyte,pEccCode еĺ룬ptBcdNumϲ
       
    أ
ע    ͣȡɹϢȡʧܣϲظʧԭ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
static VOID zAti_DoProcInfoInd(T_zMmiaCc_ProcInfo_Ind *ptMmiaCcProcInd) 
{
    T_zApMmia_CcProcInfo_Ind*    ptApProcInfoInd = (T_zApMmia_CcProcInfo_Ind*)zAti_GetUB(sizeof(T_zApMmia_CcProcInfo_Ind));

    ptApProcInfoInd->bSrcIndex     = ptMmiaCcProcInd->bSrcIndex;
    ptApProcInfoInd->bDesIndex     = ptMmiaCcProcInd->bDesIndex;
    ptApProcInfoInd->bCallInfo     = ptMmiaCcProcInd->bCallInfo;
    ptApProcInfoInd->bProgressFg   = ptMmiaCcProcInd->bProgressFg;
    ptApProcInfoInd->bProgDes      = ptMmiaCcProcInd->bProgDes;
    ptApProcInfoInd->bCallType     = ptMmiaCcProcInd->bCallType;
    ptApProcInfoInd->bCallId       = ptMmiaCcProcInd->bCallId;

    zAti_RecvServerHandlerSlaver(AP_MMIA_CC_PROC_INFO_IND_EV, (UINT8 *)ptApProcInfoInd, sizeof(T_zApMmia_CcProcInfo_Ind));
}

/**************************************************************************
: zAti_ProcInfoInd
: 
    : pBuff
    
    أZ_ATI_NOERROR_ERR       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
1   09.6.25   ӶbProgressFgbCallInfoĲ飬Ƿϱ
2    617001738758 [ati]AT޸ĵ
***************************************************************************/
DWORD zAti_ProcInfoInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaCc_ProcInfo_Ind*      ptCcProcInfoInd = (T_zMmiaCc_ProcInfo_Ind*)pBuff;

    switch(ptCcProcInfoInd->bCallInfo) 
    {
        case Z_MMIACC_SENDSETUPMSG_NOTIFY:
            {
                *pdwChangedMsgId = AP_MMIA_ORIG_IND_EV;
                break;
            }
        case Z_MMIACC_RADIOBEAREST_NOTIFY:
            {
                if ((ptCcProcInfoInd->bSrcIndex & 0x0f) < 7)      /* MO */
                {
                    zAti_DoProcInfoInd(ptCcProcInfoInd);   
                    *pdwChangedMsgId = AP_MMIA_CONF_IND_EV;
                }
                else                /* MT */
                {
                    *pdwChangedMsgId = AP_MMIA_CC_PROC_INFO_IND_EV;
                }

                break;
            }
        
            default:
                *pdwChangedMsgId = AP_MMIA_CC_PROC_INFO_IND_EV;
                break;
        }

    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_CcDicsCnf
: CCͳһظйVTSͨ
    : pBuff,ָϢMMIA_CC_DISC_CNF_EVϢ
    
    أZ_ATI_NOERROR_ERR       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_CcDicsCnf (VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaCc_Disc_Cnf *pDisCnf = (T_zMmiaCc_Disc_Cnf*)pBuff;

    if (pChnelNode != NULL)
    {
        pChnelNode->iEvId = ZATI2_INVAL_EVID;/*XC617001941772*/
        zAti_ChangeChnelNodeToCmd(pChnelNode);
    }
    /*ҶϳɹҪϱ룬ѾظʧֱӶ*/
    if (pDisCnf->bResult == Z_SUCC)
    {
        *pdwChangedMsgId = MMIA_CC_DISC_CNF_EV;
    }
    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_CcDtmfCnf
: MMIA_CC_DTMF_CNF_EVظVTS
    : pBuff,ָϢMMIA_CC_DTMF_CNF_EVϢ
    
    أZ_ATI_NOERROR_ERR       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_CcDtmfCnf (VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    /*617001920198dtmf⣺յccķȷϢϢж*/
    if (NULL != pChnelNode && ZAT2_CC_VTS == pChnelNode->cmd_id && ZAT2_CO_SET_REQ == pChnelNode->cmd_op) 
    {
        if (g_zAti_atDataEx[g_zAti_CurInstance].tDtmf.bCurnum < g_zAti_atDataEx[g_zAti_CurInstance].tDtmf.bTotalNum)
        {
            T_zMmiaCc_Dtmf_Cnf *pvtsSetCnf = (T_zMmiaCc_Dtmf_Cnf*)pBuff;            
            if(pvtsSetCnf->bResult == Z_SUCC)/*㲻ټ*/
            {
                return zAti_HandleVtsForCmcc(pvtsSetCnf->bDesIndex, pvtsSetCnf->bSrcIndex);
            }            
        }
    }

    *pdwChangedMsgId = MMIA_CC_DTMF_CNF_EV;
    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_CcmQueryCnf
: CCMѯĻظϢ
    : pBuff,ָϢMMIA_CC_CcmQueryCnf_EvϢ
    
    أZ_ATI_NOERROR_ERR       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_CcmQueryCnf (VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaCc_CcmQuery_Cnf *ptCcmQryCnf = (T_zMmiaCc_CcmQuery_Cnf *)pBuff;

    if (g_zAti_atDataEx[g_zAti_CurInstance].tCaocInfo.boCcmQuery)
    {
        *pdwChangedMsgId = AP_MMIA_CAOC_SET_CNF_EV;
        g_zAti_atDataEx[g_zAti_CurInstance].tCaocInfo.boCcmQuery = Z_ATI_FALSE;
        return Z_APMMIA_NORESULT;
    }

    if (ptCcmQryCnf->dwCcm != g_zAti_atDataEx[g_zAti_CurInstance].tCaocInfo.dwCurrCcm)
    {
        *pdwChangedMsgId = AP_MMIA_CCCM_IND_EV;
        g_zAti_atDataEx[g_zAti_CurInstance].tCaocInfo.dwCurrCcm = ptCcmQryCnf->dwCcm;
    }

    return Z_APMMIA_NORESULT;
}

VOID zAti_ResetAcm (BYTE bSourceIndex, BYTE bDestIndex)
{
    T_zApUicc_ResetAcm_Req *ptRstAcmReq = (T_zApUicc_ResetAcm_Req *)zAti_GetUB(sizeof(T_zApUicc_ResetAcm_Req));
    
    ptRstAcmReq->bSrcIndex = bSourceIndex;
    ptRstAcmReq->bDesIndex = bDestIndex;
    ptRstAcmReq->bUiccKeyId = Z_UiccId_ACM_CYC;
    
    zAti_MsgSend(AP_UICC_RESET_ACM_REQ_EV,  (PBYTE)ptRstAcmReq,  sizeof(T_zApUicc_ResetAcm_Req),  Z_ATI_TASKID_UICC);
}

VOID zAti_VerifyPin2Req (PBYTE abPwd, BYTE bPwdLen, BYTE bSrcIndex, BYTE bDesIndex)
{
    T_zApUicc_VerifyPin2_Req *ptVerifyPin2 = (T_zApUicc_VerifyPin2_Req *)zAti_GetUB(sizeof(T_zApUicc_VerifyPin2_Req));
    
    zOss_Memset(ptVerifyPin2->abPin, 0xff, Z_APMMIA_MAX_PIN_LEN);
    zOss_Memcpy(ptVerifyPin2->abPin, abPwd, bPwdLen);
    ptVerifyPin2->bSrcIndex = bSrcIndex;
    ptVerifyPin2->bDesIndex = bDesIndex;

    zAti_MsgSend(AP_UICC_VERIFY_PIN2_REQ_EV, (PBYTE)ptVerifyPin2,  sizeof(T_zApUicc_VerifyPin2_Req), Z_ATI_TASKID_UICC);
}

/**************************************************************************
: zAti_CacmSetReq
: յ+CACM
    : pBuff,ָϢAP_MMIA_CacmSetReq_EvϢ
    
    أZ_APMMIA_NORESULT       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_CacmSetReq (VOID *pBuff)
{
    T_zApMmia_CacmSet_Req *ptAcmClrReq = (T_zApMmia_CacmSet_Req *)pBuff;

    if (ptAcmClrReq->bPwdLen == 0)
    {
        /* ûд֤룬ֱӸUICCMngϢreset ACM  */
        zAti_ResetAcm(ptAcmClrReq->bSrcIndex, ptAcmClrReq->bDesIndex);        
    }
    else
    {
        /* */
        g_zAti_atDataEx[g_zAti_CurInstance].bAtCmd = Z_ATI_AT_CMD_CACM;
        zAti_VerifyPin2Req(ptAcmClrReq->abPwd, ptAcmClrReq->bPwdLen, ptAcmClrReq->bSrcIndex, ptAcmClrReq->bDesIndex);
    }
    return Z_APMMIA_NORESULT;
}

DWORD zAti_SetAcmMax (DWORD dwAcmMax, BYTE bSourceIndex, BYTE bDestIndex)
{
    DWORD dwRet = 0;
    T_z_UICC_ACMmax tAcmMax = {0};
    T_z_UICC_ACMmax tTmpAcmMax = {0};

    dwRet = zAti_ReadItem(Z_UiccId_ACMMAX_BIN, 1, 1, (VOID *)&tAcmMax);
    if (dwRet != Z_APUICC_CMD_OK)
    {
        return dwRet;
    }

    zOss_Memcpy(&tTmpAcmMax, &tAcmMax, sizeof(T_z_UICC_ACMmax));
    //õֵͿеֱͬӻOK¿
    if (0 == memcmp(&tTmpAcmMax, &dwAcmMax, sizeof(T_z_UICC_ACMmax)))
    {
        return Z_APMMIA_NOERROR_ERR;//ظOK
    }
    
    tTmpAcmMax = dwAcmMax;

    zAti_UiccUpdateItemAndSaveInfo((VOID *)&tTmpAcmMax, sizeof(T_z_UICC_ACMmax),
        Z_UiccId_ACMMAX_BIN, Z_ATI_READUICC_ACMMAX, bSourceIndex, bDestIndex);

    return Z_APUICC_CMD_OK;
}

/**************************************************************************
: zAti_CammSetReq
: յ+CAMM
    : pBuff,ָϢAP_ATI_CammSetReq_EvϢ
    
    أZ_ATI_NOERROR_ERR       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_CammSetReq (VOID *pBuff)
{
    DWORD dwRet = 0;
    DWORD dwAcmMax = 0;
    T_zApMmia_CammSet_Req *ptAcmMaxSet = (T_zApMmia_CammSet_Req *)pBuff;

    if (ptAcmMaxSet->bAcmMaxLen == 0)
    {
        sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
        return Z_APMMIA_NOERROR_ERR;
    }
    
    if (ptAcmMaxSet->bPwdLen > Z_APMMIA_MAX_PIN_LEN
        || Z_SUCC != zAti_HexArrayToLong(&dwAcmMax, ptAcmMaxSet->abAcmMax, Z_APMMIA_AOC_CALL_METER_LEN))
    {
        return Z_APMMIA_INVALIDPARA_ERR;
    }

    if (ptAcmMaxSet->bPwdLen == 0)
    {
        /* ûд֤룬ֱ ACMmax  */
        dwRet = zAti_SetAcmMax(dwAcmMax, ptAcmMaxSet->bSrcIndex, ptAcmMaxSet->bDesIndex);
        if (dwRet != Z_APUICC_CMD_OK)
        {
            if (dwRet == Z_APMMIA_NOERROR_ERR)//ʱûи¿ֱӻظOK
            {
                sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
            }
            return dwRet;
        }
        
        return Z_APMMIA_NORESULT;
    }

    /* */
    g_zAti_atDataEx[g_zAti_CurInstance].bAtCmd = Z_ATI_AT_CMD_CAMM;
    g_zAti_atDataEx[g_zAti_CurInstance].tAocPara.dwPara = dwAcmMax;

    zAti_VerifyPin2Req(ptAcmMaxSet->abPwd, ptAcmMaxSet->bPwdLen, ptAcmMaxSet->bSrcIndex, ptAcmMaxSet->bDesIndex);    
    return Z_APMMIA_NORESULT;
}

DWORD zAti_CalcOnIntegerAndDecimal (T_zApMmia_CpucSet_Req *ptPuctSet,
               DWORD *pdwMantissa, CHAR *pbEx)
{
    BYTE i = 0;
    PBYTE pbPtr = ZOSS_NULL;
    CHAR bTmpEx = 0;
    BYTE bExponent = 0;
    DWORD dwTmpMantissa = 0;
    DWORD dwTmp = 0;

    if ((ptPuctSet->bIntegerLen + ptPuctSet->bDecimalLen) > Z_ATI_AOC_EPPU_DIGIT_MAX_NUM)
    {
        return Z_APMMIA_NOERROR_ERR;
    }
    
    zAti_DecArrayToLong(&dwTmpMantissa, ptPuctSet->abInteger, ptPuctSet->bIntegerLen);
    
    for (i = 0; i < ptPuctSet->bDecimalLen; i++)
    {
        /* ҳСǰж0 */
        if (ptPuctSet->abDecimal[i] != 0)
            break;
        
        bExponent++;
    }
    
    /* ָСֵһ0λ*/
    pbPtr = ptPuctSet->abDecimal + bExponent;
    zAti_DecArrayToLong(&dwTmp, pbPtr, (BYTE)(ptPuctSet->bDecimalLen - bExponent));
    
    for (i = 0; i < ptPuctSet->bDecimalLen; i++)
    {
        dwTmpMantissa *= 10;
    }
    
    dwTmpMantissa += dwTmp;
    bTmpEx = (CHAR)-ptPuctSet->bDecimalLen;

    if (dwTmpMantissa > 4095)
    {
        return Z_APMMIA_NOERROR_ERR;
    }
    
    *pbEx = bTmpEx;
    *pdwMantissa = dwTmpMantissa;

    return Z_APMMIA_NOERROR_ERR;
}

DWORD zAti_CalcOnInteger(T_zApMmia_CpucSet_Req *ptPuctSet,
               DWORD *pdwMantissa, CHAR *pbEx)
{
    BYTE i = 0;
    CHAR bTmpEx = 0;
    BYTE bExponent = 0;
    DWORD dwTmpMantissa = 0;

    for (i = ptPuctSet->bIntegerLen - 1; i > 0; i--)
    {
        /* ҳֺжٸ0*/
        if (ptPuctSet->abInteger[i] != 0)
            break;
    
        bExponent++;
    }
    
    if (bExponent > Z_ATI_AOC_EX_MAX_VALUE ||
        (ptPuctSet->bIntegerLen - bExponent) > Z_ATI_AOC_EPPU_DIGIT_MAX_NUM)
    {
        /* ֵķ04شָʾ707Ҳ  */
        return Z_APMMIA_NOERROR_ERR;
    }
    zAti_DecArrayToLong(&dwTmpMantissa, ptPuctSet->abInteger, 
                  (BYTE)(ptPuctSet->bIntegerLen - bExponent));
    bTmpEx = (CHAR)bExponent;

    if (dwTmpMantissa > 4095)
    {
        return Z_APMMIA_NOERROR_ERR;
    }
    
    *pbEx = bTmpEx;
    *pdwMantissa = dwTmpMantissa;

    return Z_APMMIA_NOERROR_ERR;
}

DWORD zAti_CalcOnDecimal(T_zApMmia_CpucSet_Req *ptPuctSet, DWORD *pdwMantissa, CHAR *pbEx)
{
    BYTE i = 0;
    CHAR bTmpEx = 0;
    BYTE bExponent = 0;
    PBYTE pbPtr = ZOSS_NULL;
    DWORD dwTmpMantissa = 0;

    for (i = 0; i < ptPuctSet->bDecimalLen; i++)
    {
        /* ҳСǰж0 */
        if (ptPuctSet->abDecimal[i] != 0)
            break;
        
        bExponent++;
    }
    
    if (ptPuctSet->bDecimalLen > Z_ATI_AOC_EX_MAX_VALUE ||ptPuctSet->bDecimalLen < bExponent ||
        (ptPuctSet->bDecimalLen - bExponent) > Z_ATI_AOC_EPPU_DIGIT_MAX_NUM)
    {
        /* 
                 * Сֵķ04  شָʾС7(10ĸ7η)
                 * Сֳȳ7
                 */
        return Z_APMMIA_NOERROR_ERR;
    }
    
    /* ָСֵһ0λ*/
    pbPtr = ptPuctSet->abDecimal + bExponent;
    zAti_DecArrayToLong(&dwTmpMantissa, pbPtr, (BYTE)(ptPuctSet->bDecimalLen - bExponent)); 
    bTmpEx = (CHAR)-ptPuctSet->bDecimalLen;

    if (dwTmpMantissa > 4095)
    {
        return Z_APMMIA_NOERROR_ERR;
    }
    
    *pbEx = bTmpEx;
    *pdwMantissa = dwTmpMantissa;

    return Z_APMMIA_NOERROR_ERR;
}

DWORD zAti_CalcMantissaAndEx (T_zApMmia_CpucSet_Req *ptPuctSet, DWORD *pdwMantissa, CHAR *pbEx)
{
    if (ptPuctSet->bIntegerLen && ptPuctSet->bDecimalLen)
    {
        return zAti_CalcOnIntegerAndDecimal(ptPuctSet, pdwMantissa, pbEx);
    }
    else if (ptPuctSet->bIntegerLen)
    {
        return zAti_CalcOnInteger(ptPuctSet, pdwMantissa, pbEx);
    }
    else if (ptPuctSet->bDecimalLen)
    {
        return zAti_CalcOnDecimal(ptPuctSet, pdwMantissa, pbEx);
    }
    else
    {
        return Z_APMMIA_NOERROR_ERR;
    }
}

DWORD zAti_SetPuct (BYTE *pbCurrency, BYTE *pbPpu, BYTE bSourceIndex, BYTE bDestIndex)
{
    DWORD dwRet = 0;
    T_z_UICC_PUCT tPuct = {0};
    T_z_UICC_PUCT tTmpPuct = {0};

    dwRet = zAti_ReadItem(Z_UiccId_PUCT_BIN, 1, 1, (VOID *)&tPuct);
    
    if (dwRet != Z_APUICC_CMD_OK)
    {
        return dwRet;
    }

    zOss_Memcpy(&tTmpPuct, &tPuct, sizeof(T_z_UICC_PUCT));

    //õֵͿеֱͬӻOK¿
    if ((tTmpPuct.abPricePerUnit[0] == pbPpu[0]) && (tTmpPuct.abPricePerUnit[1] == pbPpu[1])
        && (0 == memcmp(tTmpPuct.abCurrencyCode, pbCurrency, Z_APMMIA_AOC_CURRENCY_CODE_LEN)))
    {
        return Z_APMMIA_NOERROR_ERR;//ظOK
    }

    tTmpPuct.abPricePerUnit[0] = pbPpu[0];
    tTmpPuct.abPricePerUnit[1] = pbPpu[1];
    zOss_Memcpy(tTmpPuct.abCurrencyCode, pbCurrency, Z_APMMIA_AOC_CURRENCY_CODE_LEN);

    zAti_UiccUpdateItemAndSaveInfo((VOID *)&tTmpPuct, sizeof(T_z_UICC_PUCT),
        Z_UiccId_PUCT_BIN, Z_ATI_READUICC_PUCT, bSourceIndex, bDestIndex);

    return Z_APUICC_CMD_OK;
}

/**************************************************************************
: zAti_CpucSetReq
: յ+CPUC
    : pBuff,ָϢAP_ATI_CpucSetReq_EvϢ
    
    أZ_ATI_NOERROR_ERR       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_CpucSetReq (VOID *pBuff)
{
    CHAR bEx = 0;
    BYTE abPpu[2] = {0};
    DWORD dwMantissa = 0;
    DWORD dwRet = 0;
    T_zApMmia_CpucSet_Req *ptPuctSet = (T_zApMmia_CpucSet_Req *)pBuff;

    if (ptPuctSet->bIntegerLen > Z_APMMIA_AOC_PPU_NUM_LEN ||
        ptPuctSet->bDecimalLen > Z_APMMIA_AOC_PPU_NUM_LEN ||
        Z_APMMIA_NOERROR_ERR != zAti_CalcMantissaAndEx(ptPuctSet, &dwMantissa, &bEx) )
    {
        /* ش*/
        return Z_APMMIA_INVALIDPARA_ERR;
    }

    /* ֵתָʽд*/
    abPpu[0] = (BYTE)(dwMantissa >> 4);
    abPpu[1] = (BYTE)(dwMantissa & 0x0f);

    if (bEx < 0)
    {
        bEx = -bEx;
        abPpu[1] |= (BYTE)(0x10 | ((BYTE)bEx << 5));
    }
    else
    {
        abPpu[1] |= (BYTE)((BYTE)bEx << 5);
    }

    if (ptPuctSet->bPwdLen == 0)
    {
        /* ûЯ֤룬ֱд*/
        dwRet = zAti_SetPuct(ptPuctSet->abCurrencyCode, abPpu, ptPuctSet->bSrcIndex, ptPuctSet->bDesIndex);
        if (dwRet != Z_APUICC_CMD_OK)
        {
            if (dwRet == Z_APMMIA_NOERROR_ERR)//ʱûи¿ֱӻظOK
            {
                sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
            }
            return  dwRet;
        }
        
        return Z_APMMIA_NORESULT;
    }

    /* */
    g_zAti_atDataEx[g_zAti_CurInstance].bAtCmd = Z_ATI_AT_CMD_CPUC;
    g_zAti_atDataEx[g_zAti_CurInstance].tAocPara.ab2Para[0] = abPpu[0];
    g_zAti_atDataEx[g_zAti_CurInstance].tAocPara.ab2Para[1] = abPpu[1];
    zOss_Memcpy(g_zAti_atDataEx[g_zAti_CurInstance].tAocPara.ab3Para, ptPuctSet->abCurrencyCode, Z_APMMIA_AOC_CURRENCY_CODE_LEN);

    zAti_VerifyPin2Req(ptPuctSet->abPwd, ptPuctSet->bPwdLen, ptPuctSet->bSrcIndex, ptPuctSet->bDesIndex);
    return Z_APMMIA_NORESULT;
}
#endif
/**************************************************************************
: zAti_VerifyPin2Cnf
: UICCMng͵֤
    : pBuff,ָϢZ_APUICC_VerifyPin2Cnf_EvϢ
    
    أZ_ATI_NOERROR_ERR       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_VerifyPin2Cnf (VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
#ifdef USE_VOICE_SUPPORT
    DWORD dwRet = 0;
#endif
    T_zApUicc_VerifyPin2_Cnf *ptVerifyPin2Cnf = (T_zApUicc_VerifyPin2_Cnf *)pBuff;

    if (ptVerifyPin2Cnf->dwResult != Z_APUICC_CMD_OK)
    {        
        return  ptVerifyPin2Cnf->dwResult;
    }

    switch (g_zAti_atDataEx[g_zAti_CurInstance].bAtCmd)
    {
#ifdef USE_VOICE_SUPPORT
        case Z_ATI_AT_CMD_CACM:
            zAti_ResetAcm(ptVerifyPin2Cnf->bDesIndex, ptVerifyPin2Cnf->bSrcIndex);
            break;

        case Z_ATI_AT_CMD_CAMM:
            dwRet = zAti_SetAcmMax(g_zAti_atDataEx[g_zAti_CurInstance].tAocPara.dwPara, ptVerifyPin2Cnf->bDesIndex, ptVerifyPin2Cnf->bSrcIndex);

            zOss_Memset(&g_zAti_atDataEx[g_zAti_CurInstance].tAocPara, 0, sizeof(T_zAti_AocParaRec));
            if (dwRet != Z_APUICC_CMD_OK)
            {
                return  dwRet;
            } 
            break;

        case Z_ATI_AT_CMD_CPUC:
            dwRet = zAti_SetPuct(g_zAti_atDataEx[g_zAti_CurInstance].tAocPara.ab3Para,
                             g_zAti_atDataEx[g_zAti_CurInstance].tAocPara.ab2Para, ptVerifyPin2Cnf->bDesIndex, ptVerifyPin2Cnf->bSrcIndex);
            zOss_Memset(&g_zAti_atDataEx[g_zAti_CurInstance].tAocPara, 0, sizeof(T_zAti_AocParaRec));
            if (dwRet != Z_APUICC_CMD_OK)
            {
                return dwRet;
            }
            break;
#endif
         case Z_ATI_AT_CMD_ZPIN2:
            return Z_APMMIA_NOERROR_ERR;
        default:
            return Z_APMMIA_UNKNOWN_ERR;
    }
#ifdef USE_VOICE_SUPPORT
    g_zAti_atDataEx[g_zAti_CurInstance].bAtCmd = Z_ATI_AT_CMD_MAX;
    return Z_APMMIA_NORESULT;
#endif
}

/***************************************************************************
:ϲPINUsimManagerת
:
pbBuff      Ϣָ
wMsgLen     Ϣ
:
ǰ:
:
***************************************************************************/
DWORD zAti_PinReq(VOID* pBuff)
{
    T_zApMmia_Cpin_Req*      ptCpinReq    = (T_zApMmia_Cpin_Req*)pBuff;
    T_zApUicc_Unblock_Req*       ptUnblockPinReq = ZOSS_NULL;
    T_zApUicc_Verify_Req*    ptVerify = ZOSS_NULL;
    
    if (ptCpinReq->bNewPinFlg == 1)
    {
        ptUnblockPinReq = (T_zApUicc_Unblock_Req *)zAti_GetUB(sizeof(T_zApUicc_Unblock_Req));
        ptUnblockPinReq->bSrcIndex      = ptCpinReq->bSrcIndex;
        ptUnblockPinReq->bDesIndex      = ptCpinReq->bDesIndex;
        ptUnblockPinReq->bChId = ptCpinReq->bChId;
        zOss_Memset(ptUnblockPinReq->abUnblockKey, 0xff, 8);
        zOss_Memset(ptUnblockPinReq->abNewVerifyKey, 0xff, 8);
        zOss_Memcpy(ptUnblockPinReq->abUnblockKey,ptCpinReq->abPin,ptCpinReq->bPinLen)   ;
        zOss_Memcpy(ptUnblockPinReq->abNewVerifyKey ,ptCpinReq->abNewPin,ptCpinReq->bNewPinLen);

        zAti_MsgSend(AP_UICC_UNBLOCK_REQ_EV,   (PBYTE)ptUnblockPinReq,  sizeof(T_zApUicc_Unblock_Req),  Z_ATI_TASKID_UICC);
    }
    else
    {
        ptVerify = (T_zApUicc_Verify_Req*)zAti_GetUB(sizeof(T_zApUicc_Verify_Req));
        ptVerify->bSrcIndex      = ptCpinReq->bSrcIndex;
        ptVerify->bDesIndex      = ptCpinReq->bDesIndex;
        ptVerify->bChId             = ptCpinReq->bChId;
        zOss_Memset(ptVerify->abKey, 0xff, 8);
        zOss_Memcpy(ptVerify->abKey ,ptCpinReq->abPin,ptCpinReq->bPinLen);

        zAti_MsgSend(AP_UICC_VERIFY_REQ_EV,  (PBYTE)ptVerify,  sizeof(T_zApUicc_Verify_Req),  Z_ATI_TASKID_UICC);
    }

    return Z_APMMIA_NORESULT;
}

/***************************************************************************
:UsimManagerUICCʼظϲת
:
pbBuff      Ϣָ
wMsgLen     Ϣ
:
ǰ:  ǰǵͬһı־FINISH
                      ֻ־FINISH
:lxh 12.05   617001885529
***************************************************************************/
VOID __ps_2g_func zAti_CardInitFlgClr_SigCd(BYTE bInstance, BYTE bCardInitFlg)
{
    if (zAti_IsSingleCard())
    {
        g_zAti_atDataEx[Z_ATI_INSNO_1].bCardInitiatedFlag = bCardInitFlg;
        g_zAti_atDataEx[Z_ATI_INSNO_2].bCardInitiatedFlag = bCardInitFlg;
    }
    else
    {
        g_zAti_atDataEx[bInstance].bCardInitiatedFlag = bCardInitFlg;
    }
}

VOID __ps_static_func zAti_SetCardState(BYTE bInsNo, BYTE bCardStat)
{
    g_zAti_atDataEx[bInsNo].bCardState = bCardStat;
}
#ifdef Z_DUALCARD_ADAPT
BYTE zAti_GetCardState(BYTE bInsNo)
{
    return g_zAti_atDataEx[bInsNo].bCardState;
}
#endif
#ifdef NAS_ISIM_SUPPORT
/*ϱ+ZISIMINIT*/
VOID zAti_ZisiminitIndicat(BYTE bSrcIndex, BYTE bDesIndex, BYTE bChId, DWORD dwUiccState)
{
    T_zAti_Zisiminit_Ind* ptZisiminitInd  = (T_zAti_Zisiminit_Ind*)zAti_GetUB(sizeof(T_zAti_Zisiminit_Ind));

    ptZisiminitInd->bSrcIndex = bSrcIndex;
    ptZisiminitInd->bDesIndex = bDesIndex;
    ptZisiminitInd->bChID = bChId;
    ptZisiminitInd->dwUiccState = dwUiccState;

    zAti_RecvServerHandlerSlaver(AP_MMIA_ZISIMINIT_IND_EV,(UINT8 *)ptZisiminitInd, sizeof(T_zAti_Zisiminit_Ind));
}
#endif
/***************************************************************************
:UsimManagerUICCʼظϲת
:
pbBuff      Ϣָ
wMsgLen     Ϣ
:
ǰ:
:
***************************************************************************/
DWORD __ps_static_func zAti_UiccInitCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zApUicc_Init_Cnf* ptUiccInitCnf = (T_zApUicc_Init_Cnf*)pBuff;
    BYTE bakInitFlag = g_zAti_atDataEx[g_zAti_CurInstance].bCardInitiatedFlag;
#ifdef NAS_ISIM_SUPPORT
    if(0 != ptUiccInitCnf->bChId) /*ISIM Ҫ֤ʱUICCŻᴥϢ,Ϊ0ʱΪUSIM/SIM,0ʱΪISIM,û0xff*/
    {
        zAti_ZisiminitIndicat(ptUiccInitCnf->bSrcIndex, ptUiccInitCnf->bDesIndex, ptUiccInitCnf->bChId, ptUiccInitCnf->dwUiccState);
        return Z_APMMIA_NORESULT;
    }
#endif
    /*  Z_APUICC_CMD_OK ȴAP_UICC_UICCOK_IND_EV */
    if (zAti_IsEWalkUiccInit(ptUiccInitCnf->bDesIndex) ) //E
    {
        zAti_IndiCatIccid(ptUiccInitCnf);
        if (ptUiccInitCnf->dwUiccState != Z_APUICC_CMD_OK)
        {
            zAti_SetCardState(g_zAti_CurInstance, Z_CARD_INIT_ERR);
            zAti_CardInitFlgClr_SigCd(g_zAti_CurInstance, Z_ATI_CARDINIT_FINISH);
            if(Z_ATI_CARDINIT_ING == bakInitFlag)
            {
                zAti_HandleMsgBuff ();
            }
            zAti_HandleAutoStart();
        }
    }
    else /*E*/
    {
        *pdwChangedMsgId = AP_MMIA_UICC_INIT_CNF_EV;
        if (ptUiccInitCnf->dwUiccState != Z_APUICC_CMD_OK)
        {
            zAti_SetCardState(g_zAti_CurInstance, Z_CARD_INIT_ERR);
            zAti_CardInitFlgClr_SigCd(g_zAti_CurInstance, Z_ATI_CARDINIT_FINISH);
        }
    }
#ifdef Z_DUALCARD_ADAPT
    if(Z_VALID == zAti_IsDualPsDualUicc() && ptUiccInitCnf->dwUiccState != Z_APUICC_CMD_OK)
    {
        g_zAti_ptData->bNeedChgFg = zAti_GetChangeCfgFlg();
    }
#endif
    return Z_APMMIA_NORESULT;
}

DWORD __ps_2g_func zAti_UiccZuststInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zApUicc_Init_Ind *pZustatInd = (T_zApUicc_Init_Ind*)pBuff;
    T_zDev_AtMem_Mmia_PrivateMem tAtDate = {0};
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtDate, g_zAti_CurInstance);

    if(zAti_IsEWalkUiccInit(pZustatInd->bDesIndex))
    {
        return Z_APMMIA_NORESULT;
    }

    if(pChnelNode != NULL && tAtDate.bZustatSet == Z_ATI_SetType_Enable)
    {
        *pdwChangedMsgId = AP_UICC_INIT_IND_EV;
    }

    return Z_APMMIA_NORESULT;
}

/* ֪ͨSTM ʼ*/
VOID __ps_2g_func zAti_NotifyPBUiccOKInd(T_zApUicc_UiccOk_Ind* ptUiccOkInd)
{
    T_zApMmia_PbUiccOk_Ind*  ptPbOkInd  = (T_zApMmia_PbUiccOk_Ind*)zAti_GetUB(sizeof(T_zApMmia_PbUiccOk_Ind));
    ptPbOkInd->bSrcIndex    = ptUiccOkInd->bDesIndex; 
    ptPbOkInd->bDesIndex    = ptUiccOkInd->bSrcIndex; 
    ptPbOkInd->bApplMode    = ptUiccOkInd->bApplMode; 
    ptPbOkInd->dwInitResult = ptUiccOkInd->dwInitResult; 

    zAti_MsgSend(AP_MMIA_PB_UICC_OK_IND_EV,    (PBYTE)ptPbOkInd,  sizeof(T_zApMmia_PbUiccOk_Ind),  Z_ATI_TASKID_PB);  
}
/******************************************************
:zAti_HandleAnothStackAutoStart
:ǰ໺AUTOSTART
******************************************************/
VOID zAti_AutoStartRfOn(VOID)
{
    T_ZAti_ChannelInfo  *pTempChnelNode = ZOSS_NULL;

    zAti_SetAutoStartState(Z_ATI_AUTOSTART_WAITRFON);
    pTempChnelNode = zAti_GetAtCmdChId(ZAT2_CFG_AUTOSTART);
    if(NULL == pTempChnelNode)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_SetAutoStartState(Z_ATI_AUTOSTART_CARDOK);
        return;
    }
    if (Z_SUCC!= zAti_RfCtrlReq(pTempChnelNode->iChnelId, 0xff, Z_APMMIA_CFUNFUN_FULLFUN))
    {
        zAti_SetAutoStartState(Z_ATI_AUTOSTART_CARDOK);
        zAti_ProcError(pTempChnelNode, Z_APMMIA_OPTNOTALW_ERR);
    }
}

/************************************************************
:zAti_HnadleAutoStart
:EʱAUTOSTART
*************************************************************/
VOID __ps_static_func zAti_HandleAutoStart(VOID)
{
    if (Z_ATI_AUTOSTART_WAITUICCINIT == zAti_GetAutoStartState ())
    {
        zAti_AutoStartRfOn();
    }

    /*жһǷҪAUTOSTART*/
    if(zAti_IsSingleCardForTwoStandby() && Z_ATI_AUTOSTART_WAITUICCINIT == zAti_GetAnothAutoStartState())
    {
        g_zAti_CurInstance = (g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_2: Z_ATI_INSNO_1;
        zAti_AutoStartRfOn();
        g_zAti_CurInstance = (g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_2: Z_ATI_INSNO_1;
    }
}
/*********************************************************************
*:zAti_RetUbCardPlmnInfo
*:ͷŴ洢ӪϢȫ
**********************************************************************/
VOID zAti_RetUbCardPlmnInfo(VOID)
{
    BYTE i = 0;
    BYTE bInsNo = g_zAti_CurInstance;
    zAti_GetReadCardMutex();
    for(i = 0; i < g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum; i++)
    {
        zAti_RetUB((VOID * *)&g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]);
    }

    g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum = 0;
    zAti_PutReadCardMutex();
}
/*********************************************************
*:zAti_GetCardPlmnInfo
*:ӿжȡOPL/PNNϢ
*********************************************************/
VOID __ps_2g_func zAti_GetCardPlmnInfo(BYTE bInsNo)
{
    BYTE i = 0;
    BYTE bRecNum = 0;
    T_z_UICC_Opl  tOpl = {0};
    T_z_UICC_Pnn tPnn = {0};

    zAti_GetReadCardMutex();
    if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum > 0)
    {
        zAti_PutReadCardMutex();
        return;
    }

    bRecNum = zDev_GetRecNum(Z_UiccId_OPL_REC, bInsNo);
    if (bRecNum == 0)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");//NO OPL EF
        zAti_PutReadCardMutex();
        return;
    }

    g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum = bRecNum;

    for(i = 0; i < bRecNum; i++)
    {
        g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i] = (T_zAti_Plmninfo*)zAti_GetUB(sizeof(T_zAti_Plmninfo));
        if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i] != NULL)
        {
            zOss_Memset(&tOpl, 0xff, sizeof(T_z_UICC_Opl));
            if (Z_APUICC_CMD_OK == zAti_ReadItem(Z_UiccId_OPL_REC, (BYTE)(i+1), (BYTE)(i+1), (VOID *)&tOpl))
            {
                zOss_Memcpy(&g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->tPlmnId, (T_z_PlmnId*)tOpl.abLocaAreaId, 3);
                if(Z_INVALID == zAti_IsPlmnIdValid(&g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->tPlmnId))
                {
                     continue;
                }
                zOss_Memcpy(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abLacStart, &tOpl.abLocaAreaId[3], 2);
                zOss_Memcpy(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abLacEnd, &tOpl.abLocaAreaId[5], 2);
                zOss_Memset(&tPnn, 0, sizeof(T_z_UICC_Pnn));
                if (Z_APUICC_CMD_OK == zAti_ReadItem(Z_UiccId_PNN_REC, (BYTE)tOpl.bPLMNNetNameRecId, (BYTE)tOpl.bPLMNNetNameRecId, (VOID *)&tPnn))
                {
                    if(tPnn.bFullNameLen > 0 && tPnn.bFullNameLen <= ZPS_UICC_LEN_PNN_FULL)
                    {
                        zAti_PlmnNameFromCard(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abFullName, &tPnn, Z_ATI_LONG_NAME);
                    }

                    if(tPnn.bShortNameLen > 0 && tPnn.bShortNameLen <= ZPS_UICC_LEN_PNN_SHORT)
                    {
                        zAti_PlmnNameFromCard(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abShortName, &tPnn, Z_ATI_SHORT_NAME);
                    }
                }
                else 
                {
                    zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");//Read PNN fail
                }
            }
            else 
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");//Read OPL fail
            }
        }
        
    }
    zAti_PutReadCardMutex();
}
/***************************************************************************
:UsimManagerĿϱϲת
:
pbBuff      Ϣָ
wMsgLen     Ϣ
:
ǰ:
:
***************************************************************************/
DWORD __ps_static_func zAti_UiccOkInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zApUicc_UiccOk_Ind*   ptUiccOkInd  = (T_zApUicc_UiccOk_Ind*)pBuff;
    T_zDev_AtMem_Mmia_PrivateMem tAtData        = {0};
    BYTE bakInitFlag = g_zAti_atDataEx[g_zAti_CurInstance].bCardInitiatedFlag;
#ifdef NAS_ISIM_SUPPORT
    if(0 != ptUiccOkInd->bChId)/*Ϊ0USIM/SIM,0ʱΪISIM,û0xff*/
    {
        zAti_ZisiminitIndicat(ptUiccOkInd->bSrcIndex, ptUiccOkInd->bDesIndex, ptUiccOkInd->bChId, ptUiccOkInd->dwInitResult);
        return Z_APMMIA_NORESULT;
    }
#endif

#ifdef DSDS_VSIM
    if(g_zAti_CurInstance == Z_ATI_INSNO_1)/*ƿֵ֧绰Ͷ*/
    {
#endif
        zAti_NotifyPBUiccOKInd(ptUiccOkInd);
#ifdef DSDS_VSIM
    }
#endif

    zAti_SetCardState(g_zAti_CurInstance, Z_CARD_INIT_SUCC);
    zAti_CardInitFlgClr_SigCd(g_zAti_CurInstance, Z_ATI_CARDINIT_FINISH);

    if(zAti_IsEWalkUiccInit(ptUiccOkInd->bDesIndex))
    {
        if(Z_ATI_CARDINIT_ING == bakInitFlag)
        {
            zAti_HandleMsgBuff();
        }

        zAti_HandleAutoStart();
    }

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
    if (tAtData.bZurdySet == Z_ATI_SetType_Enable)
    {
        * pdwChangedMsgId = AP_MMIA_UICC_OKIND_EV;
    }

#ifdef Z_DUALCARD_ADAPT
    if(Z_VALID == zAti_IsDualPsDualUicc())
    {
        g_zAti_ptData->bNeedChgFg = zAti_GetChangeCfgFlg();

        if(Z_NEED_USER_DECIDE == g_zAti_ptData->bNeedChgFg)
        {
            zAti_IndicatUserDecide();
        }
    }
#endif
    zAti_GetCardPlmnInfo(g_zAti_CurInstance);

    return Z_APMMIA_NORESULT;
}

/***********************************************************
*:zAti_IsCardOffCnf
*:жǷΪUICCظĹؿӦ
***********************************************************/
BOOL zAti_IsCardOffCnf(BYTE bChnelId)
{
    T_ZAti_ChannelInfo *pChnelNode = zAti_GetChannelNodePtr(bChnelId);

    if(pChnelNode != NULL && pChnelNode->cmd_id == ZAT2_MM_CFUN)
    {
        return TRUE;
    }
    return FALSE;
}

DWORD zAti_UiccCommonCnf (VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zApUicc_Common_Cnf *pUiccCommcnf = (T_zApUicc_Common_Cnf*) pBuff;
    BYTE bakInitFlag = g_zAti_atDataEx[g_zAti_CurInstance].bCardInitiatedFlag;

    if(zAti_IsEWalkUiccInit(pUiccCommcnf->bDesIndex))
    {
        if((Z_FAIL == pUiccCommcnf->bResult)&& (Z_ATI_CARDINIT_ING == bakInitFlag))
        {
            zAti_CardInitFlgClr_SigCd(g_zAti_CurInstance, Z_ATI_CARDINIT_FINISH);
            zAti_HandleMsgBuff();
        }
        zAti_HandleAutoStart();
    }
    else
    {
        *pdwChangedMsgId = AP_UICC_COMMON_CNF_EV;
    }

    /*ǶԽйʼĿйؿŻǷ
       Ҫж*/
#ifdef Z_DUALCARD_ADAPT
    if(Z_VALID == zAti_IsDualPsDualUicc() && zAti_IsCardOffCnf(pUiccCommcnf->bDesIndex)
        && Z_ATI_CARDINIT_NOT != g_zAti_atDataEx[g_zAti_CurInstance].bCardInitiatedFlag)
    {
        zAti_SetCardState(g_zAti_CurInstance, Z_CARD_INIT_ERR);
        g_zAti_ptData->bNeedChgFg = zAti_GetChangeCfgFlg();
    }
#endif
    if(zAti_IsCardOffCnf(pUiccCommcnf->bDesIndex))/*ؿSETUPMENU¼*/
    {
        //zOss_Memset(&g_zAti_atDataEx[g_zAti_CurInstance].tStUpMenu, 0, sizeof(T_zAti_SetUpMemnu));
        //zAti_RetUbCardPlmnInfo();
        zAti_CardOffInitGlobalVarByInstNo(g_zAti_CurInstance);
    }

    return Z_APMMIA_NORESULT;
}

DWORD __ps_2g_func zAti_UmmCommonCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    if(pChnelNode != NULL && pChnelNode->cmd_id == ZAT2_CFG_AUTOSTART)
    {
        zAti_SetAutoStartState (Z_ATI_AUTOSTART_CARDOK);
    }

    *pdwChangedMsgId = MMIA_UMM_COMMON_CNF_EV;
    return Z_APMMIA_NORESULT;
}
/**************************************************************************************
*:zAti_UmmCsSrvInd
*:յMMIA_UMM_CS_SRV_IND_EvʱݵǰӦģʽѡͬĴ
*                           1)ԶӦ:ֱӦϱ+ZSRVING
*                           2)˹Ӧ:ϱ+ZSRVINGȴû·Ӧ
**************************************************************************************/
DWORD zAti_UmmCsSrvInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaUmm_MtCsSrv_Cnf    *ptMtCsSrvCnf = ZOSS_NULL;
    T_zMmiaUmm_MtCsSrv_Ind    *pZsrvInd = (T_zMmiaUmm_MtCsSrv_Ind*)pBuff;

    if(Z_VALID == zDev_GetCSFBAnsModFlag())  /*ԶӦ*/
    {
        ptMtCsSrvCnf = (T_zMmiaUmm_MtCsSrv_Cnf*)zAti_GetUB(sizeof(T_zMmiaUmm_MtCsSrv_Cnf));
        ptMtCsSrvCnf->bDesIndex = pZsrvInd->bSrcIndex;
        ptMtCsSrvCnf->bSrcIndex = pZsrvInd->bDesIndex;
        ptMtCsSrvCnf->bRst = Z_VALID;  //
        zAti_MsgSend(MMIA_UMM_CS_SRV_CNF_EV,(PBYTE)ptMtCsSrvCnf, sizeof(T_zMmiaUmm_MtCsSrv_Cnf),Z_ATI_TASKID_UMM);
    }
    else    /*ֶӦ*/
    {
        *pdwChangedMsgId = MMIA_UMM_CS_SRV_IND_Ev;
    }
    return Z_APMMIA_NORESULT;
}

T_ZAti_ChannelInfo* zAti_GetAtCmdChId(T_ZAt2_CmdIdType cmd_id)
{
    BYTE bMaxChnlId = (g_zAti_CurInstance == 1)?  Z_ATI_INSTANCE_TWO_CHNL_MAX : Z_ATI_INSTANCE_ONE_CHNL_MAX;
    T_ZAti_ChannelInfo *pTempChnelNode = zAti_GetFirstChannelNodePtrByInstance(g_zAti_CurInstance);  
    
    while(ZOSS_NULL != pTempChnelNode && pTempChnelNode->iChnelId <= bMaxChnlId)
    {
        if(pTempChnelNode->cmd_id == cmd_id)
        {
            return pTempChnelNode;
        }
        pTempChnelNode = pTempChnelNode->pNextCnNode;
    }
    return ZOSS_NULL;
}

DWORD zAti_ReadSpnCnf (T_zApUicc_Read_Cnf *ptUiccReadCnf)
{
    DWORD dwRet = 0;
    BYTE bSpdiKeyId = 0;
    T_z_UICC_SPN tSpn = {0};
    T_zAti_UiccInfo tSaveVal = {0};

    dwRet = zAti_CopyStrFromUiccVal((VOID *)&tSpn, ptUiccReadCnf->wKeyId, ptUiccReadCnf);
    if (dwRet != Z_APMMIA_NOERROR_ERR)
    {
        return dwRet;
    }

    if(Z_APUICC_KEYID_SPN == ptUiccReadCnf->wKeyId)
    {
        bSpdiKeyId = Z_APUICC_KEYID_SPDI;
    }
    else
    {
        bSpdiKeyId = Z_APUICC_KEYID_GSM_SPDI;
    }

    if (zAti_UiccReadReq(bSpdiKeyId, 1, ptUiccReadCnf->bDesIndex, ptUiccReadCnf->bSrcIndex) != Z_APMMIA_NORESULT)
    {
        return Z_APMMIA_NVFAILURE_ERR;
    }

    zOss_Memcpy(&tSaveVal.tSpn, &tSpn, sizeof(T_z_UICC_SPN));
    zAti_SaveValWhenReadUicc(&tSaveVal);

    return Z_APMMIA_NORESULT;
}


/************************************************************************
: zAti_PlmnInSpdi
: жPlmnǷspdi 
    : 
    
    أZ_FAIL/Z_SUCC
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ                                                                           
************************************************************************/
BYTE zAti_PlmnInSpdi(T_z_PlmnId *ptPlmnId, T_z_UICC_Spdi *ptSpdi)
{
    BYTE i = 0;
    
    for (i = 0; i < ptSpdi->bNum; i ++)
    {
        if (!memcmp(ptPlmnId, &(ptSpdi->atPlmn[i]),3))
        {
            return Z_SUCC;
        }
    }

    return Z_FAIL;
}

VOID zAti_SpnReadFail (T_z_UICC_SPN *ptSpn, PBYTE pbDispRplmn)
{
    if (Z_ATI_REG_HPLMN == g_zAti_atDataEx[g_zAti_CurInstance].bInRoam)
    {
        *pbDispRplmn = (0 == ptSpn->bDcRPLMN) ? Z_APMMIA_NOT_DISPLY_RPLMN : Z_APMMIA_DISPLY_RPLMN;
    }
    else if (Z_ATI_REG_ROAM == g_zAti_atDataEx[g_zAti_CurInstance].bInRoam)
    {
        *pbDispRplmn = Z_APMMIA_DISPLY_RPLMN;  /* Ϊ617001375998޸ */
    }
    else
    {
        *pbDispRplmn = Z_APMMIA_DISPLY_RPLMN_INVALID;
    }
}

VOID zAti_SpnReadSucc (T_z_UICC_SPN *ptSpn, PBYTE pbDispRplmn)
{
    *pbDispRplmn = (0 == ptSpn->bDcRPLMN) ? Z_APMMIA_NOT_DISPLY_RPLMN : Z_APMMIA_DISPLY_RPLMN;
}

DWORD zAti_ReadSpdiCnf(T_zApUicc_Read_Cnf *ptUiccReadCnf)
{
    BYTE bDispRplmn = 0;
    T_zApMmia_SpnRead_Cnf *ptReadCnf = ZOSS_NULL;
    T_z_UICC_SPN tSpn = {0};
    T_z_UICC_Spdi tSpdi = {0};
    T_zAti_UiccInfo *ptUiccInf = &g_zAti_atDataEx[g_zAti_CurInstance].tUiccInfo;

    (VOID)zAti_CopyStrFromUiccVal((VOID *)&tSpdi, ptUiccReadCnf->wKeyId, ptUiccReadCnf);

    zOss_Memcpy(&tSpn, &ptUiccInf->tSpn, sizeof(T_z_UICC_SPN));

    if (ptUiccReadCnf->dwExecuteStatus != Z_APUICC_CMD_OK ||
        Z_FAIL == zAti_PlmnInSpdi(&g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.tPlmnId, &tSpdi))
    {
        zAti_SpnReadFail(&tSpn, &bDispRplmn);
    }
    else
    {
        zAti_SpnReadSucc(&tSpn, &bDispRplmn);
    }

    ptReadCnf = (T_zApMmia_SpnRead_Cnf*)zAti_GetUB(sizeof(T_zApMmia_SpnRead_Cnf));
    ptReadCnf->bSrcIndex  = ptUiccReadCnf->bSrcIndex;
    ptReadCnf->bDesIndex  = ptUiccReadCnf->bDesIndex;
    ptReadCnf->bDispRplmn = bDispRplmn;

    if (bDispRplmn != Z_APMMIA_DISPLY_RPLMN_INVALID)
    {
        zOss_Memcpy(ptReadCnf->abSpnName, tSpn.abProvName, Z_APMMIA_MAX_SPNLEN);
    }

    zAti_RecvServerHandlerSlaver(AP_MMIA_SPN_READ_CNF_EV, (UINT8 *)ptReadCnf, sizeof(T_zApMmia_SpnRead_Cnf));

    return Z_APMMIA_NORESULT;
}

VOID zAti_CsasUpdateCbmi(T_z_UICC_CBMI *ptCbmi, T_zDev_AtMem_CBS_MidSet *ptMidSet)
{
    BYTE bValidNum = (ptCbmi->bMaxLen>Z_UICC_LEN_CBMI) ? Z_UICC_LEN_CBMI : ptCbmi->bMaxLen;

    if(bValidNum > Z_DEV_AtMem_CBS_MAX_MID_NUM)
    {
        bValidNum = Z_DEV_AtMem_CBS_MAX_MID_NUM;
    }

    if (bValidNum > 0)
    {
        zOss_Memcpy(ptCbmi->awCBMessIden, ptMidSet->awSingleList, bValidNum * sizeof(WORD)); /*鲻һZ_DEV_AtMem_CBS_MAX_SINGEL_MID_NUM*/
    }
    
    ptCbmi->bNum = (ptMidSet->bSingleNum > bValidNum) ? bValidNum : ptMidSet->bSingleNum; 
}

DWORD zAti_ReadCbmiCnf (T_zApUicc_Read_Cnf *ptUiccReadCnf)
{
    DWORD dwRet = 0;
    T_z_UICC_CBMI tCbmi = {0};
    T_zAti_UiccInfo *ptSaveVal = ZOSS_NULL;
    T_zDev_AtMem_CBS_CscbCmd *ptAtData = (T_zDev_AtMem_CBS_CscbCmd*)zAti_GetUB(sizeof(T_zDev_AtMem_CBS_CscbCmd));
    T_zAti_UiccInfo *ptUiccInfo = &g_zAti_atDataEx[g_zAti_CurInstance].tUiccInfo;

    dwRet = zAti_CopyStrFromUiccVal((VOID *)&tCbmi, Z_APUICC_KEYID_CBMI, ptUiccReadCnf);
    if (dwRet != Z_APMMIA_NOERROR_ERR)
    {
        zAti_RetUB((VOID**)&ptAtData);
        return zAti_GETCMSERR(dwRet);
    }

    zDev_AtMemReadItem(Z_AtMem_ID_Cscb, 0, (PBYTE)ptAtData, g_zAti_CurInstance);

    if (ptUiccInfo->bReadKey == Z_ATI_READUICC_CSAS)
    {
        if (g_zAti_atDataEx[g_zAti_CurInstance].bActivatFlg == Z_INVALID)
        {
            zAti_RetUB((VOID**)&ptAtData);
            /* û+CSCBڴд洢Ч*/                   
            return Z_APMMIA_CMSOPTNOTALLOW_ERR;
        }

        /* ڴеת浽*/
        zAti_CsasUpdateCbmi(&tCbmi, &ptAtData->tCscbMid);
        zAti_RetUB((VOID**)&ptAtData);
        return zAti_UiccUpdateReq((VOID *)&tCbmi, Z_APUICC_KEYID_CBMI, ptUiccReadCnf->bDesIndex, ptUiccReadCnf->bSrcIndex);
    }
    else
    {
        /* еת浽ڴ*/
        ptAtData->tCscbMid.bSingleNum = tCbmi.bNum;
        if (tCbmi.bNum > 0)
        {
            zOss_Memset(ptAtData->tCscbMid.awSingleList, 0xff, sizeof(WORD) * Z_DEV_AtMem_CBS_MAX_MID_NUM);
            zOss_Memcpy(ptAtData->tCscbMid.awSingleList, tCbmi.awCBMessIden, 2 * tCbmi.bNum);     
        }   

        if (zAti_UiccReadReq(Z_APUICC_KEYID_CBMIR, 1, ptUiccReadCnf->bDesIndex, ptUiccReadCnf->bSrcIndex) != Z_APMMIA_NORESULT)
        {   
            zAti_RetUB((VOID**)&ptAtData);
            return Z_APMMIA_NVFAILURE_ERR;
        }
        zAti_RetUB((VOID**)&ptAtData);
        
        ptSaveVal = (T_zAti_UiccInfo*)zAti_GetUB(sizeof(T_zAti_UiccInfo));
        ptSaveVal->bReadKey = Z_ATI_READUICC_CRES;
        zAti_SaveValWhenReadUicc(ptSaveVal);

        zAti_RetUB((VOID**)&ptSaveVal);
        
        return Z_APMMIA_NORESULT;
    }    
}

DWORD zAti_ReadCbmirCnf (T_zApUicc_Read_Cnf *ptUiccReadCnf)
{
    BYTE i = 0;
    DWORD dwRet = 0;
    T_z_UICC_Cbmir *ptCbmir = (T_z_UICC_Cbmir*)zAti_GetUB(sizeof(T_z_UICC_Cbmir));
    T_zDev_AtMem_CBS_CscbCmd *ptAtData = (T_zDev_AtMem_CBS_CscbCmd*)zAti_GetUB(sizeof(T_zDev_AtMem_CBS_CscbCmd));
    T_zAti_UiccInfo *ptUiccInfo = &g_zAti_atDataEx[g_zAti_CurInstance].tUiccInfo;

    dwRet = zAti_CopyStrFromUiccVal((VOID *)ptCbmir, Z_APUICC_KEYID_CBMIR, ptUiccReadCnf);
    if (dwRet != Z_APMMIA_NOERROR_ERR)
    {
        zAti_RetUB((VOID**)&ptAtData);
        zAti_RetUB((VOID**)&ptCbmir);
        return zAti_GETCMSERR(dwRet);
    }

    zDev_AtMemReadItem(Z_AtMem_ID_Cscb, 0, (PBYTE)ptAtData, g_zAti_CurInstance);

    if (ptUiccInfo->bReadKey == Z_ATI_READUICC_CSAS)
    {
        if (g_zAti_atDataEx[g_zAti_CurInstance].bActivatFlg == Z_INVALID)
        {
            zAti_RetUB((VOID**)&ptCbmir);
            zAti_RetUB((VOID**)&ptAtData);
            return Z_APMMIA_CMSOPTNOTALLOW_ERR;
        }

        zAti_CsasUpdateCbmir(ptCbmir, &ptAtData->tCscbMid);
    
        dwRet = zAti_UiccUpdateReq((VOID *)ptCbmir, Z_APUICC_KEYID_CBMIR,ptUiccReadCnf->bDesIndex, ptUiccReadCnf->bSrcIndex);

        zAti_RetUB((VOID**)&ptCbmir);
        zAti_RetUB((VOID**)&ptAtData);
        return dwRet;
    }
    else
    {
        ptAtData->tCscbMid.bRangeNum = ptCbmir->bNum;
        zOss_Memset(ptAtData->tCscbMid.atRangeList, 0xff, sizeof(T_zDev_AtMem_CBS_Range) * Z_DEV_AtMem_CBS_MAX_MID_NUM);
        for (i = 0; i < ptCbmir->bNum; i ++)
        {
            ptAtData->tCscbMid.atRangeList[i].wMin = (WORD)(ptCbmir->adwCBMIR[i] & 0x0000ffff);    
            ptAtData->tCscbMid.atRangeList[i].wMax = (WORD)((ptCbmir->adwCBMIR[i] & 0xffff0000) >> 16);
            
        } 
        zAti_RetUB((VOID**)&ptCbmir);
        zAti_RetUB((VOID**)&ptAtData);
        return Z_APMMIA_NOERROR_ERR; 
    }
}

/***************************************************************************
: zAti_GetZimgFormUiccReadcnf
: ȡZIMG
: 
룺
                
  ֵ: 
    : 
ע    : 
***************************************************************************/
static DWORD zAti_GetZimgFormUiccReadcnf(T_zApUicc_Read_Cnf *ptUiccReadCnf)
{
    DWORD dwRet = 0;
    BYTE i = 0;
    T_zApMmia_ZImg_Cnf *ptZimgCnf = ZOSS_NULL;
    T_zApUicc_Img tImg = {0};    

    dwRet = zAti_CopyStrFromUiccVal((VOID *)&tImg, Z_APUICC_KEYID_IMG, ptUiccReadCnf);
    if (dwRet != Z_APMMIA_NOERROR_ERR)
    {    
        return dwRet;
    }

    if (tImg.bImgNum > Z_APUICC_MAX_IMG_DSCRP_NUM)
    {
        return Z_APMMIA_UNKNOWN_ERR; 
    }

    
    ptZimgCnf = (T_zApMmia_ZImg_Cnf*)zAti_GetUB(sizeof(T_zApMmia_ZImg_Cnf));
    ptZimgCnf->bSrcIndex = ptUiccReadCnf->bSrcIndex;
    ptZimgCnf->bDesIndex = ptUiccReadCnf->bDesIndex;
    ptZimgCnf->bImgNum   = tImg.bImgNum;
    
    for (i = 0; i < tImg.bImgNum; i ++)
    {
        ptZimgCnf->tImgDscrp[i].bWidth              = tImg.tImgDscrp[i].bWidth;           
        ptZimgCnf->tImgDscrp[i].bHeigh              = tImg.tImgDscrp[i].bHeigh;           
        ptZimgCnf->tImgDscrp[i].bCodeScheme         = tImg.tImgDscrp[i].bCodeScheme;     
        ptZimgCnf->tImgDscrp[i].wInstncFid          = tImg.tImgDscrp[i].wInstncKeyId ;      
        ptZimgCnf->tImgDscrp[i].wOffsetIntoInstnc   = tImg.tImgDscrp[i].wOffsetIntoInstnc;
        ptZimgCnf->tImgDscrp[i].wInstncDataLen      = tImg.tImgDscrp[i].wInstncDataLen  ; 
    }

    zAti_RecvServerHandlerSlaver(AP_MMIA_ZIMG_CNF_EV, (UINT8 *)ptZimgCnf, sizeof(T_zApMmia_ZImg_Cnf));
    
    return Z_APMMIA_NORESULT;
}

/***************************************************************************
: zAti_GetZgiidfFormUiccReadcnf
: ȡZGIIDF
: 
룺
                
  ֵ: 
    : 
ע    : 
***************************************************************************/
static DWORD zAti_GetZgiidfFormUiccReadcnf(T_zApUicc_Read_Cnf *ptUiccReadCnf)
{
    DWORD dwRet = 0;
    T_zApMmia_ZGiidf_Cnf *ptZgiidfCnf = ZOSS_NULL;
    T_z_UICC_ImgInst tImgInst = {0};
    T_zAti_UiccInfo *ptUiccInf = &g_zAti_atDataEx[g_zAti_CurInstance].tUiccInfo;
    BYTE bEffectLen = 0;

    dwRet = zAti_CopyStrFromUiccVal((VOID *)&tImgInst, ptUiccReadCnf->wKeyId, ptUiccReadCnf);
    if (dwRet != Z_APMMIA_NOERROR_ERR)
    {
        return dwRet;
    }

    bEffectLen = (tImgInst.bLen > Z_UICC_LEN_IMGINST) ? tImgInst.bLen : Z_UICC_LEN_IMGINST;

    if ((ptUiccInf->tZgiidRange.wOffsetBase + ptUiccInf->tZgiidRange.wDataLen) > bEffectLen)
    {
        return Z_APMMIA_INVALIDPARA_ERR;
    }

    ptZgiidfCnf = (T_zApMmia_ZGiidf_Cnf*)zAti_GetUB(sizeof(T_zApMmia_ZGiidf_Cnf));
    ptZgiidfCnf->bSrcIndex = ptUiccReadCnf->bSrcIndex;
    ptZgiidfCnf->bDesIndex = ptUiccReadCnf->bDesIndex;

    ptZgiidfCnf->bDataValLen = (BYTE)ptUiccInf->tZgiidRange.wDataLen;
    
    if (ptUiccInf->tZgiidRange.wDataLen)
    {
        zOss_Memcpy(ptZgiidfCnf->abImgInstncVal, tImgInst.abImgInst + ptUiccInf->tZgiidRange.wOffsetBase, 
                                  ptUiccInf->tZgiidRange.wDataLen);
    }
    zAti_RecvServerHandlerSlaver(AP_MMIA_ZGIIDF_CNF_EV, (UINT8 *)ptZgiidfCnf, sizeof(T_zApMmia_ZGiidf_Cnf));    
    
    return Z_APMMIA_NORESULT;
}

/***************************************************************************
:UsimManagerĶļظ
:
pbBuff      Ϣָ
wMsgLen     Ϣ
:
ǰ:
:
ע: null
 ***************************************************************************/
DWORD zAti_UiccReadCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{ 
    T_zApUicc_Read_Cnf *pReadCnf = (T_zApUicc_Read_Cnf*)pBuff;
    DWORD dwRet = Z_APMMIA_NORESULT;

    switch (pReadCnf->wKeyId)
    {
        case Z_APUICC_KEYID_SPN:
        case Z_APUICC_KEYID_GSM_SPN:
            dwRet = zAti_ReadSpnCnf(pReadCnf);
            break;

        case Z_APUICC_KEYID_SPDI:
        case Z_APUICC_KEYID_GSM_SPDI:
            dwRet = zAti_ReadSpdiCnf(pReadCnf);
            zAti_UiccInfoInit(g_zAti_CurInstance);
            break;

        case Z_APUICC_KEYID_CBMI:
            dwRet = zAti_ReadCbmiCnf(pReadCnf);
            break;

        case Z_APUICC_KEYID_CBMIR:
            dwRet = zAti_ReadCbmirCnf(pReadCnf);
            zAti_UiccInfoInit(g_zAti_CurInstance);
            break;
            
        case Z_APUICC_KEYID_IMG:            
            dwRet = zAti_GetZimgFormUiccReadcnf(pReadCnf);
            zAti_UiccInfoInit(g_zAti_CurInstance);
            break;

        case Z_APUICC_KEYID_IMGINST_1:
        case Z_APUICC_KEYID_IMGINST_2:
        case Z_APUICC_KEYID_IMGINST_3:
        case Z_APUICC_KEYID_IMGINST_4:
        case Z_APUICC_KEYID_IMGINST_5:
        case Z_APUICC_KEYID_IMGINST_6:
        case Z_APUICC_KEYID_IMGINST_7:
        case Z_APUICC_KEYID_IMGINST_8:
        case Z_APUICC_KEYID_IMGINST_9:
        case Z_APUICC_KEYID_IMGINST_10:
        case Z_APUICC_KEYID_IMGINST_11:
        case Z_APUICC_KEYID_IMGINST_12:
        case Z_APUICC_KEYID_IMGINST_13:
        case Z_APUICC_KEYID_IMGINST_14:
        case Z_APUICC_KEYID_IMGINST_15:
        case Z_APUICC_KEYID_IMGINST_16:
        case Z_APUICC_KEYID_IMGINST_17:
        case Z_APUICC_KEYID_IMGINST_18:
        case Z_APUICC_KEYID_IMGINST_19:
        case Z_APUICC_KEYID_IMGINST_20:
        case Z_APUICC_KEYID_IMGINST_21:
        case Z_APUICC_KEYID_IMGINST_22:
        case Z_APUICC_KEYID_IMGINST_23:
        case Z_APUICC_KEYID_IMGINST_24:
        case Z_APUICC_KEYID_IMGINST_25:
        case Z_APUICC_KEYID_IMGINST_26:
        case Z_APUICC_KEYID_IMGINST_27:
        case Z_APUICC_KEYID_IMGINST_28:
            dwRet = zAti_GetZgiidfFormUiccReadcnf(pReadCnf);
            zAti_UiccInfoInit(g_zAti_CurInstance);
            break;
#ifdef USE_VOICE_SUPPORT
        case Z_APUICC_KEYID_CFIS:
            dwRet = zAti_ZcfisSetCnf(pReadCnf);
            break;
#endif
        default:
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                       
            zAti_UiccInfoInit(g_zAti_CurInstance);
            break;
    }

    return dwRet;
}

DWORD zAti_UpdateCbmiCnf (T_zApUicc_Update_Cnf *ptUpdateCnf)
{
    T_zAti_UiccInfo tSaveVal = {0};

    if (ptUpdateCnf->dwExecuteStatus != Z_APUICC_CMD_OK)
    {        
        return Z_APMMIA_CMSUSIMFAIL_ERR;
    }

    if (zAti_UiccReadReq(Z_APUICC_KEYID_CBMIR, 1, ptUpdateCnf->bDesIndex, ptUpdateCnf->bSrcIndex) != Z_APMMIA_NORESULT)
    {    
        return Z_APMMIA_NVFAILURE_ERR;
    }

    tSaveVal.bReadKey = Z_ATI_READUICC_CSAS;
    zAti_SaveValWhenReadUicc(&tSaveVal);
    return Z_APMMIA_NORESULT;
}

DWORD zAti_UpdateCbmirCnf (T_zApUicc_Update_Cnf *ptUpdateCnf)
{
    if (ptUpdateCnf->dwExecuteStatus != Z_APUICC_CMD_OK)
    {        
        return Z_APMMIA_CMSUSIMFAIL_ERR;
    }
        
    return Z_APMMIA_NOERROR_ERR;
}

/***************************************************************************
:UsimManagerı༭ļظ
:
pbBuff      Ϣָ
wMsgLen     Ϣ
:
ǰ:
:
ע: ¿ļдӦȵupdateCnfٸATIظ
        1. SMSP +csca+csmpõ
***************************************************************************/
DWORD zAti_UiccUpdateCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zApUicc_Update_Cnf *ptUpdateCnf  = (T_zApUicc_Update_Cnf*)pBuff;   
    DWORD dwRet = 0;

    switch (ptUpdateCnf->wKeyId) 
    {            
        case Z_APUICC_KEYID_CBMI:
            dwRet = zAti_UpdateCbmiCnf(ptUpdateCnf);
            break;

        case Z_APUICC_KEYID_CBMIR:
            dwRet = zAti_UpdateCbmirCnf(ptUpdateCnf);
            break;
#ifdef USE_VOICE_SUPPORT
        case Z_APUICC_KEYID_CFIS:
            dwRet = zAti_UpdateCommonCnf(ptUpdateCnf);
            break;
#endif
        default:
            break;
    }

    zAti_UiccInfoInit(g_zAti_CurInstance);
    return dwRet;
}

DWORD zAti_UiccUpdateItemGeneralCnf (T_zApUicc_UpdateItem_Cnf *ptUpdateItemCnf)
{
    if (ptUpdateItemCnf->dwWriteResult[0] != Z_APUICC_CMD_OK)
    {                
        return ptUpdateItemCnf->dwWriteResult[0];
    }
    return Z_APMMIA_NOERROR_ERR;
}

DWORD zAti_SmsSmspUpdateCnf (T_zApUicc_UpdateItem_Cnf *ptUpdateItemCnf)
{
    if (ptUpdateItemCnf->dwWriteResult[0] != Z_APUICC_CMD_OK)
    {                 
        return zAti_GETCMSERR(ptUpdateItemCnf->dwWriteResult[0]);
    }

    return Z_APMMIA_NOERROR_ERR;
}

/***************************************************************************
:UsimManagerı༭ļظ
:
pbBuff      Ϣָ
wMsgLen     Ϣ
:
ǰ:
:
ע: ¿ļдӦȵupdateCnfٸATIظ
        1. SMSP +csca+csmpõ
***************************************************************************/
DWORD zAti_UiccUpdateItemCnf(VOID* pBuff , DWORD *pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zApUicc_UpdateItem_Cnf *ptUpdateItemCnf = (T_zApUicc_UpdateItem_Cnf*)pBuff;
    T_zAti_UiccInfo *ptUiccInfo = &g_zAti_atDataEx[g_zAti_CurInstance].tUiccInfo;
    DWORD dwRet = 0;

    switch (ptUiccInfo->bReadKey)
    {
        case Z_ATI_READUICC_PLMNLIST:
        case Z_ATI_READUICC_PUCT:
        case Z_ATI_READUICC_ACMMAX:
        case Z_ATI_READUICC_LANGUAGE:
        case Z_ATI_READUICC_IMSI:
        case Z_ATI_READUICC_ACL:
        case Z_ATI_READUICC_ACLAPN:
            dwRet = zAti_UiccUpdateItemGeneralCnf(ptUpdateItemCnf);
            break;

        case Z_ATI_READUICC_SMSP:
            dwRet = zAti_SmsSmspUpdateCnf(ptUpdateItemCnf);
            break;    

        case Z_ATI_READUICC_SMSS:
            dwRet = zAti_SmsUpdateMrCnf(ptUpdateItemCnf, pdwChangedMsgId);
            break;
        case Z_ATI_READUICC_SMSS_TPMR:
            dwRet = zAti_SmsUpdateTpMrCnf(ptUpdateItemCnf);
            break;
        default:
            break;
    }

    //zAti_UiccInfoInit(g_zAti_CurInstance);  //ÿθֵmemcpy,ûԭ
    return dwRet;
}

/************************************************************************
: zAti_PbPBMemStatusCnf
: յPBϢAP_MMIA_PbStorageStatusCnf_Ev
    : pBuff,ָϢAP_MMIA_PbStorageStatusCnf_EvϢ
    
    أZ_ATI_NOERROR_ERR    
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ     
08.07                                                                        
************************************************************************/
DWORD zAti_PbPBMemStatusCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zApMmia_PbStorageStatus_Cnf   *ptPbStoStatCnf = (T_zApMmia_PbStorageStatus_Cnf*)pBuff;
    
    /* PB operation failed */
    if (Z_APMMIA_OPERATION_FAILURE == ptPbStoStatCnf->bResult)
    {        
        return  ptPbStoStatCnf->dwReason;
    }      

    switch(ptPbStoStatCnf->bQueryFlag) 
    {
    case Z_APMMIA_PBQUERYFLAG_FORCPBS:        
        *pdwChangedMsgId = AP_MMIA_CPBS_QUERY_CNF_EV;
        break;
        
    case Z_APMMIA_PBQUERYFLAG_FORCPBR:        
        *pdwChangedMsgId = AP_MMIA_CPBR_TEST_CNF_EV;
        break;
        
    case Z_APMMIA_PBQUERYFLAG_FORCPBF:        
        *pdwChangedMsgId = AP_MMIA_CPBF_TEST_CNF_EV;
        break;
        
    case Z_APMMIA_PBQUERYFLAG_FORCPBW:        
        *pdwChangedMsgId = AP_MMIA_CPBW_TEST_CNF_EV;
        break;
        
    default:
        return Z_APMMIA_UNKNOWN_ERR;
        
    }
    
    return Z_APMMIA_NORESULT;
}

/************************************************************************
: zAti_EM_CellInfoReq
: ϱСϢ
    : pBuff,
    
    أZ_ATI_NOERROR_ERR    
ע    ͣATIյϱСϢGRRԼUMCRϱ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ     
09.03                                                                        
************************************************************************/
DWORD zAti_EM_CellInfoSetReq(VOID* pBuff)
{
    BYTE ret = Z_INVALID;
    BYTE bAsRet = Z_SUCC;
    T_zMmiaAs_EM_CellInfo_Req* ptApMmiaReq = (T_zMmiaAs_EM_CellInfo_Req*)pBuff;

    ret = zAti_EM_NeedNotifyCellInfSet (ptApMmiaReq->bAction, Z_ATI_CELLINFO_SET);
    if (ret == Z_VALID)
    {
        bAsRet = zAti_EM_NotifyAs(ptApMmiaReq->bAction, ptApMmiaReq->bSrcIndex, ptApMmiaReq->bDesIndex);
    }

    if (bAsRet != Z_SUCC)
    {
        /*617001559703 [V3.2.5B03]رTMTߣʼɺ󣬽ػ
            ȻAT+ZEMCI=1СϢϱATڶ*/
        return Z_APMMIA_OPTNOTALW_ERR;
    }
    else
    {
        g_zAti_atDataEx[g_zAti_CurInstance].bCellInfSet  = ptApMmiaReq->bAction;
        sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
        return Z_APMMIA_NOERROR_ERR;
    }
}

DWORD zAti_EM_CellInfoQryReq(VOID* pBuff)
{
    BYTE bRet = Z_FAIL;
    BYTE bCurAct = zAti_GetCurAct_ByIndex(g_zAti_CurInstance);

    T_zMmiaAs_CellInfo_Qry_Req* ptCellInfoQryReq = (T_zMmiaAs_CellInfo_Qry_Req*)pBuff;
    T_zMmiaAs_CellInfo_Qry_Req *ptQryReq = (T_zMmiaAs_CellInfo_Qry_Req*)zAti_GetUB(sizeof(T_zMmiaAs_CellInfo_Qry_Req));

    zOss_Memcpy(ptQryReq, ptCellInfoQryReq, sizeof(T_zMmiaAs_CellInfo_Qry_Req));

    switch (bCurAct)
    {
        #ifdef PS_RAT_TDD
        case Z_TD_ACT:
            bRet = zAti_MsgSend(MMIA_AS_QUERY_EM_CELL_INFO_REQ_EV, (PBYTE)ptQryReq, sizeof(T_zMmiaAs_CellInfo_Qry_Req), Z_ATI_TASKID_MCR);
            break;
        #endif
        #ifdef PS_RAT_FDD
        case Z_W_ACT:
            bRet = zAti_MsgSend(MMIA_AS_QUERY_EM_CELL_INFO_REQ_EV, (PBYTE)ptQryReq, sizeof(T_zMmiaAs_CellInfo_Qry_Req), Z_ATI_TASKID_WMCR);
            break;
        #endif

        #ifdef PS_RAT_GSM
        case Z_GSM_ACT:
            bRet = zAti_MsgSend(MMIA_AS_QUERY_EM_CELL_INFO_REQ_EV, (PBYTE)ptQryReq, sizeof(T_zMmiaAs_CellInfo_Qry_Req), Z_ATI_TASKID_GRR);
            break;
        #endif
        #ifdef PS_RAT_LTE
        case Z_LTE_ACT:
            bRet = zAti_MsgSend(MMIA_AS_QUERY_EM_CELL_INFO_REQ_EV, (PBYTE)ptQryReq, sizeof(T_zMmiaAs_CellInfo_Qry_Req), Z_ATI_TASKID_EUMCR);
            break;
        #endif
        default:
            zAti_RetUB((VOID**)&ptQryReq);
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");  
            return ZAT2_CMEE_GETNOINFO_ERR;
    }

    if(bRet != Z_SUCC)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                        
        return Z_APMMIA_OPTNOTALW_ERR;
    }

    return Z_APMMIA_NORESULT;
}

DWORD zAti_EM_CellInfoQryReqByIndex(VOID* pBuff)
{
    DWORD dwResult = zAti_EM_CellInfoQryReq(pBuff);

    if (dwResult != Z_APMMIA_NORESULT)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,""); 
        g_zAti_atDataEx[g_zAti_CurInstance].bZemsciqIndex = 0xff;
    }

    return dwResult;
}
BYTE zAti_AsHoInfo(BYTE bAction, BYTE bSrcIndex, BYTE bDesIndex, BYTE bDestMdl , DWORD dwEvent)
{
    T_zMmiaAs_EM_HoInfo_Req *ptAsHoInfoReq = (T_zMmiaAs_EM_HoInfo_Req*)zAti_GetUB(sizeof(T_zMmiaAs_EM_HoInfo_Req));
    ptAsHoInfoReq->bAction = bAction;
    ptAsHoInfoReq->bSrcIndex = bSrcIndex;
    ptAsHoInfoReq->bDesIndex = bDesIndex;
    return zAti_MsgSend(dwEvent, (PBYTE)(ptAsHoInfoReq), sizeof(T_zMmiaAs_EM_HoInfo_Req), bDestMdl);
}

BYTE zAti_EM_NotfyAsforHoInfo(BYTE bAction, BYTE bSrcIndex, BYTE bDesIndex)
{
    BYTE bRet = Z_FAIL;
#if defined PS_RAT_TDD
    if (Z_SUCC == zAti_AsHoInfo(bAction, bSrcIndex, bDesIndex, Z_ATI_TASKID_URBC , MMIA_AS_EM_HO_INFO_REQ))
    {
        bRet = Z_SUCC;
    }
#endif
#if defined PS_RAT_FDD
    if (Z_SUCC == zAti_AsHoInfo(bAction, bSrcIndex, bDesIndex, Z_ATI_TASKID_WRBC , MMIA_AS_EM_HO_INFO_REQ))
    {
        bRet = Z_SUCC;
    }
#endif
#if defined (PS_RAT_GSM)
    if (Z_SUCC == zAti_AsHoInfo(bAction, bSrcIndex, bDesIndex, Z_ATI_TASKID_GRRC, RR_EM_HO_INFO_REQ))
    {
        bRet = Z_SUCC;
    }

#endif

    return bRet;
}

/************************************************************************
: zAti_EM_HoInfoSetReq
: 򿪻߹رлϢϱ
    : pBuff,
    
    أZ_ATI_NOERROR_ERR    
ע    ֪ͣͨURBCGRRC뿪лϢϱģʽ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ     
09.03                                                                        
************************************************************************/
DWORD zAti_EM_HoInfoSetReq(VOID* pBuff)
{
    T_zMmiaAs_EM_HoInfo_Req* ptApHoInfoReq = (T_zMmiaAs_EM_HoInfo_Req*)pBuff;

    if (((ptApHoInfoReq->bAction == Z_APMMIA_EM_IND_ENABLE)  && (ZOSS_INVALID_TIMER_ID != g_zAti_atDataEx[g_zAti_CurInstance].pTimrIdHo)) ||
        ((ptApHoInfoReq->bAction == Z_APMMIA_EM_IND_DISABLE) && (ZOSS_INVALID_TIMER_ID == g_zAti_atDataEx[g_zAti_CurInstance].pTimrIdHo)))
    {
        sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
        return Z_APMMIA_NOERROR_ERR;
    }
    
    if ( Z_SUCC != zAti_EM_NotfyAsforHoInfo(ptApHoInfoReq->bAction, ptApHoInfoReq->bSrcIndex, ptApHoInfoReq->bDesIndex))
    {
        return Z_APMMIA_OPTNOTALW_ERR;
    }
    g_zAti_atDataEx[g_zAti_CurInstance].bHoInfoSet         = ptApHoInfoReq->bAction;

    /*ʱ*/
    if (ptApHoInfoReq->bAction == 1)    /*ϱ*/
    {
        if (ZOSS_NULL == g_zAti_atDataEx[g_zAti_CurInstance].ptGrrcHoInd)
        {
            g_zAti_atDataEx[g_zAti_CurInstance].ptGrrcHoInd = (T_zMmiaAs_EM_GHoInfo_Ind*)zAti_GetUB(sizeof(T_zMmiaAs_EM_GHoInfo_Ind));
        }
        
        if (ZOSS_NULL == g_zAti_atDataEx[g_zAti_CurInstance].ptUrrcHoInd)
        {
            g_zAti_atDataEx[g_zAti_CurInstance].ptUrrcHoInd = (T_zMmiaAs_EM_UHoInfo_Ind*)zAti_GetUB(sizeof(T_zMmiaAs_EM_UHoInfo_Ind));
        }      
        
        /*617001898408 EV_ZATI2_CPBR_CNFMMIA_EM_HO_INFO_EXPIRY_EVԼͳسʱϢĴûлȡϢһ*/
        g_zAti_atDataEx[g_zAti_CurInstance].pTimrIdHo   = zSetLoopTimer(5000, MMIA_EM_HO_INFO_EXPIRY_EV, g_zAti_CurInstance);
    }
    else
    {
        zAti_KillTimer(&g_zAti_atDataEx[g_zAti_CurInstance].pTimrIdHo);
        zAti_RetUB((VOID * * )&g_zAti_atDataEx[g_zAti_CurInstance].ptUrrcHoInd);
        zAti_RetUB((VOID * * )&g_zAti_atDataEx[g_zAti_CurInstance].ptGrrcHoInd);
    }

    sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
    return Z_APMMIA_NOERROR_ERR;
}

VOID __ps_static_func zAti_EM_NotfyAsforCco(BYTE bAction)
{
#if defined (PS_RAT_TDD) 
    zAti_CellresOrCcoCount(bAction, Z_ATI_TASKID_UCSR);
#endif
#if defined (PS_RAT_FDD)
    zAti_CellresOrCcoCount(bAction, Z_ATI_TASKID_WCSR);
#endif
#if defined (PS_RAT_GSM)
    zAti_CellresOrCcoCount(bAction, Z_ATI_TASKID_GRR);
#endif
}


/************************************************************************
: zAti_CellresOrCcoCountReq
: СѡCCOͳƹ
    : pBuff,
    
    أzAti_NOERROR_ERR    
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ     
09.03                                                                        
************************************************************************/
VOID __ps_static_func zAti_CellresOrCcoCountReq(VOID *pBuff)
{
#if defined (PS_RAT_FDD) || defined (PS_RAT_TDD) || defined (PS_RAT_GSM)
    T_z_MsgtracePs_CellresOrCcoCount_Req *ptCellresOrCcoCountReq = (T_z_MsgtracePs_CellresOrCcoCount_Req *)pBuff;

    zAti_EM_NotfyAsforCco(ptCellresOrCcoCountReq->bAction);
    g_zAti_atDataEx[g_zAti_CurInstance].bCcoCount = ptCellresOrCcoCountReq->bAction;
#endif
}

/************************************************************************
: zAti_CreateZRptRxlevIndMsg
:  ݲZRptRxlevInd Ϣ
    : 
                bRssi  :źǿ 
                bBler  :ŵ 
    
    أT_zApMmia_ZRptRxlev_Ind ṹָ

************************************************************************/
T_zApMmia_ZRptRxlev_Ind* __ps_2g_func zAti_CreateZRptRxlevIndMsg(BYTE bSourceIndex, BYTE bDestIndex, BYTE bRssi, BYTE bBler, BYTE bAct)
{
    T_zApMmia_ZRptRxlev_Ind * ptApInd = (T_zApMmia_ZRptRxlev_Ind*)zAti_GetUB(sizeof(T_zApMmia_ZRptRxlev_Ind));

    ptApInd->bSrcIndex   = bSourceIndex;
    ptApInd->bDesIndex  = bDestIndex;
    ptApInd->bRssi         = bRssi; 
    ptApInd->bBler         = bBler;
    ptApInd->bAct          = bAct;

    return ptApInd;
}

DWORD zAti_ZRptRxlevEnable (T_zApMmia_ZRptRxlev_Req *ptRxlevReq)
{
    BYTE bRegState = Z_APMMIA_REGSTATE_UNKNOWN;
    BYTE bInsNo = ((g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_1 : Z_ATI_INSNO_2);

#ifdef PS_RAT_LTE
    if (zAti_GetCurAct_ByIndex(bInsNo) == Z_LTE_ACT)
    {
        bRegState = g_zAti_atDataEx[bInsNo].bEpsState;
    }
    else
 #endif
    {
        if(g_zAti_atDataEx[bInsNo].bPsState == Z_APMMIA_REGSTATE_NOREGNOSEARCH
          ||g_zAti_atDataEx[bInsNo].bPsState == Z_APMMIA_REGSTATE_REGHPLMN 
          ||g_zAti_atDataEx[bInsNo].bPsState == Z_APMMIA_REGSTATE_REGROAMING)
        {
            bRegState  =  g_zAti_atDataEx[bInsNo].bPsState;
        }
        else
        {
            bRegState  =  g_zAti_atDataEx[bInsNo].bCsState;
        }
    }

    if (bRegState == Z_APMMIA_REGSTATE_REGDENIED || bRegState == Z_APMMIA_REGSTATE_UNKNOWN)
    {
        T_zApMmia_ZRptRxlev_Ind *ptApInd = zAti_CreateZRptRxlevIndMsg(ptRxlevReq->bDesIndex, ptRxlevReq->bSrcIndex, 0, 99, Z_APMMIA_NOSERVE);
        zAti_MsgSend(AP_MMIA_ZRPT_RXLEVIND_EV,  (PBYTE)ptApInd, sizeof(T_zApMmia_ZRptRxlev_Ind), Z_ATI_TASKID_ATI);
    }
    return zAti_ZRptRxlevProc (ptRxlevReq);
}

/************************************************************************
: zAti_ZsqrSet
: 
    : pBuff,
    
    أZ_ATI_NOERROR_ERR    
ע    ͣMMIAжǷǴϱ(n==1?),Ǵϱ,
            Rangeֵڣ򷵻AT
            򱣴Դ/Ŀò,MMIAϢUMCR.GRR
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ     
09.03                                                                        
************************************************************************/
DWORD zAti_ZRptRxlevReq(VOID* pBuff)
{
    T_zApMmia_ZRptRxlev_Req*     ptRxlevReq      = (T_zApMmia_ZRptRxlev_Req*)pBuff;

    /*====================================== ȱʡֵ ==================================== */
    /*  syntax:  +ZSQR=<n>[,<range>]                                                         */ 
    /*  action: <range> n=0ʱȱʡn=1ʱȱʡ                                         */
    /*====================================================================================== */

    if (ptRxlevReq->bSet == Z_ATI_RptRxlev_ENABLE)      /*ϱ*/
    {
        return zAti_ZRptRxlevEnable(ptRxlevReq);
    }
    else                /*رϱ*/
    {
        return zAti_ZRptRxlevDisable(ptRxlevReq);
    }
}

/**************************************************************************
* ƣ zAt_EncCSQCnf
*  ZPS_ApMmia_RxlevCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*           bRssi: źǿ , bBler źǿ 
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CSQִӦı뺯
**************************************************************************/
VOID zAt_EncCSQCnf(BYTE bRssi, BYTE bBler, BYTE bAct, BYTE bAtType)
{
    if(bAtType == Z_ATI_CSQ)
    {
        /* +CSQ: <rssi>,<ber> */
        sprintf((char *)g_zAt_EncBuf, "%s+CSQ: %d,%d,%d%s%s",  g_zAt_CRLF, bRssi,bBler,bAct,g_zAt_CRLF,g_zAt_OK);
    }
    else
    {
        /* +ZSQ: <rssi>,<ber> */
        sprintf((char *)g_zAt_EncBuf, "%s+ZSQ: %d,%d,%d%s%s",  g_zAt_CRLF, bRssi,bBler,bAct,g_zAt_CRLF,g_zAt_OK);
    }
}

/************************************************************************
: zAti_RxlevReq
: +CSQ
    : pBuff,
    
    أZ_ATI_NOERROR_ERR    
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ     
09.03                                                                        
************************************************************************/
DWORD __ps_static_func zAti_RxlevReq(VOID* pBuff)
{
    BYTE bInsNo = 0;
    BYTE bRegState = Z_APMMIA_REGSTATE_UNKNOWN;
    BYTE bCurAct = Z_NO_ACT;
    BYTE bRet = Z_FAIL;
    T_zMmiaAs_Csq_Qry_Req * ptCsqQry = NULL;
    T_zMmiaAs_Csq_Qry_Req *ptCsqQryReq = (T_zMmiaAs_Csq_Qry_Req*)pBuff;

    bInsNo = ((g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_1 : Z_ATI_INSNO_2);
    bCurAct = zAti_GetCurAct_ByIndex(bInsNo);

#ifdef PS_RAT_LTE
    if (bCurAct == Z_LTE_ACT)
    {
        bRegState = g_zAti_atDataEx[bInsNo].bEpsState;
    }
    else
 #endif
    {
        if(g_zAti_atDataEx[bInsNo].bPsState == Z_APMMIA_REGSTATE_NOREGNOSEARCH
          ||g_zAti_atDataEx[bInsNo].bPsState == Z_APMMIA_REGSTATE_REGHPLMN 
          ||g_zAti_atDataEx[bInsNo].bPsState == Z_APMMIA_REGSTATE_REGROAMING)
        {
            bRegState  =  g_zAti_atDataEx[bInsNo].bPsState;
        }
        else
        {
            bRegState  =  g_zAti_atDataEx[bInsNo].bCsState;
        }        
    }

    switch(bRegState)
    {
        case Z_APMMIA_REGSTATE_NOREGBUTSEARCH:    /**/
            zAt_EncCSQCnf(99, 99, Z_APMMIA_NOSERVE, ptCsqQryReq->bAtType);
            return Z_APMMIA_NOERROR_ERR;

        case Z_APMMIA_REGSTATE_NOREGNOSEARCH:     /*פ*/
        case Z_APMMIA_REGSTATE_REGHPLMN:
        case Z_APMMIA_REGSTATE_REGROAMING:

        ptCsqQry = (T_zMmiaAs_Csq_Qry_Req*)zAti_GetUB(sizeof(T_zMmiaAs_Csq_Qry_Req));
        zOss_Memcpy(ptCsqQry, ptCsqQryReq, sizeof(T_zMmiaAs_Csq_Qry_Req));

            switch (bCurAct)
            {
                
#ifdef PS_RAT_TDD
            case Z_TD_ACT:
                bRet = zAti_MsgSend(MMIA_AS_QUERY_RXLEV_REQ_EV,  (PBYTE)ptCsqQry, sizeof(T_zMmiaAs_Csq_Qry_Req), Z_ATI_TASKID_MCR);
                break;
#endif
#ifdef PS_RAT_FDD
            case Z_W_ACT:
                bRet = zAti_MsgSend(MMIA_AS_QUERY_RXLEV_REQ_EV,    (PBYTE)ptCsqQry, sizeof(T_zMmiaAs_Csq_Qry_Req), Z_ATI_TASKID_WMCR);
                break;
#endif

#ifdef PS_RAT_GSM
            case Z_GSM_ACT:
                bRet = zAti_MsgSend((DWORD)RRAT_RXSTAT_REQ,   (PBYTE)ptCsqQry, sizeof(T_zMmiaAs_Csq_Qry_Req), Z_ATI_TASKID_GRR);
                break;
#endif
#ifdef PS_RAT_LTE
            case Z_LTE_ACT:
                bRet = zAti_MsgSend((DWORD)MMIA_AS_QUERY_RXLEV_REQ_EV, (PBYTE)ptCsqQry, sizeof(T_zMmiaAs_Csq_Qry_Req), Z_ATI_TASKID_EUMCR);
                break;
#endif
            default:
                zAti_RetUB((VOID**)&ptCsqQry);
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
                break;
            }
            if (bRet != Z_SUCC)
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
                return Z_APMMIA_OPTNOTALW_ERR;
            }
            break;
        case Z_APMMIA_REGSTATE_REGDENIED:         /*no cell*/
        case Z_APMMIA_REGSTATE_UNKNOWN:  
        default:
            zAt_EncCSQCnf(0, 99, Z_APMMIA_NOSERVE, ptCsqQryReq->bAtType);
            return Z_APMMIA_NOERROR_ERR;
    }

    return Z_APMMIA_NORESULT;
}

VOID zAt_EncZCSQCnf(BYTE bRssi, BYTE bBler, BYTE bAct)
{ 
    /* +ZCSQ: <rssi>,<ber>,<act>*/
    sprintf((char *)g_zAt_EncBuf, "%s+ZCSQ: %d,%d,%d%s%s",  g_zAt_CRLF, bRssi,bBler,bAct,g_zAt_CRLF,g_zAt_OK);
}

BYTE zAti_GetCurActAndRegState(BYTE *pRegState)
{
    //BYTE bRegState = Z_APMMIA_REGSTATE_UNKNOWN;
    BYTE bInsNo = 0;
    BYTE bCurAct = Z_NO_ACT;

    bInsNo = ((g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_1 : Z_ATI_INSNO_2);
    bCurAct = zAti_GetCurAct_ByIndex(bInsNo);

#ifdef PS_RAT_LTE
    if (bCurAct == Z_LTE_ACT)
    {
        *pRegState = g_zAti_atDataEx[bInsNo].bEpsState;
    }
    else
 #endif
    {
        if(g_zAti_atDataEx[bInsNo].bPsState == Z_APMMIA_REGSTATE_NOREGNOSEARCH
          ||g_zAti_atDataEx[bInsNo].bPsState == Z_APMMIA_REGSTATE_REGHPLMN 
          ||g_zAti_atDataEx[bInsNo].bPsState == Z_APMMIA_REGSTATE_REGROAMING)
        {
            *pRegState  =  g_zAti_atDataEx[bInsNo].bPsState;
        }
        else
        {
            *pRegState  =  g_zAti_atDataEx[bInsNo].bCsState;
        }        
    }
    return bCurAct;
}
DWORD zAti_CsqCommonReq(VOID *pBuff, WORD wSendMsgLen)
{
    BYTE bRegState = Z_APMMIA_REGSTATE_UNKNOWN;
    BYTE bCurAct = Z_NO_ACT;
    BYTE bRet = Z_FAIL;
    BYTE *pReqMsg = NULL;

    bCurAct = zAti_GetCurActAndRegState(&bRegState);
    switch(bRegState)
    {
        case Z_APMMIA_REGSTATE_NOREGBUTSEARCH:    /**/
            zAt_EncZCSQCnf(99, 99, Z_APMMIA_NOSERVE);
            return Z_APMMIA_NOERROR_ERR;

        case Z_APMMIA_REGSTATE_NOREGNOSEARCH:     /*פ*/
        case Z_APMMIA_REGSTATE_REGHPLMN:
        case Z_APMMIA_REGSTATE_REGROAMING:

            pReqMsg = (BYTE *)zAti_GetUB(wSendMsgLen);
            zOss_Memcpy(pReqMsg, pBuff, wSendMsgLen);

            switch (bCurAct)
            {
                
#ifdef PS_RAT_TDD
            case Z_TD_ACT:
                bRet = zAti_MsgSend(MMIA_AS_QUERY_ZCSQ_REQ_EV,  (PBYTE)pReqMsg, wSendMsgLen, Z_ATI_TASKID_MCR);
                break;
#endif
#ifdef PS_RAT_FDD
            case Z_W_ACT:
                bRet = zAti_MsgSend(MMIA_AS_QUERY_ZCSQ_REQ_EV,    (PBYTE)pReqMsg, wSendMsgLen, Z_ATI_TASKID_WMCR);
                break;
#endif

#ifdef PS_RAT_GSM
            case Z_GSM_ACT:
                bRet = zAti_MsgSend(MMIA_AS_QUERY_ZCSQ_REQ_EV,   (PBYTE)pReqMsg, wSendMsgLen, Z_ATI_TASKID_GRR);
                break;
#endif
#ifdef PS_RAT_LTE
            case Z_LTE_ACT:
                bRet = zAti_MsgSend(MMIA_AS_QUERY_ZCSQ_REQ_EV, (PBYTE)pReqMsg, wSendMsgLen, Z_ATI_TASKID_EUMCR);
                break;
#endif
            default:
                zAti_RetUB((VOID**)&pReqMsg);
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
                break;
            }
            if (bRet != Z_SUCC)
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
                return Z_APMMIA_OPTNOTALW_ERR;
            }
            break;
        case Z_APMMIA_REGSTATE_REGDENIED:         /*no cell*/
        case Z_APMMIA_REGSTATE_UNKNOWN:  
        default:
            zAt_EncZCSQCnf(0, 99, Z_APMMIA_NOSERVE);
            return Z_APMMIA_NOERROR_ERR;
    }

    return Z_APMMIA_NORESULT;
}
/************************************************************************
: zAti_ZcsqReq
: +ZCSQ
    : pBuff,
    
    أZ_ATI_NOERROR_ERR    
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ     
                                                                     
************************************************************************/
DWORD zAti_ZcsqReq(VOID* pBuff)
{
    T_zMmiaAs_Csq_Qry_Req *ptCsqQryReq = (T_zMmiaAs_Csq_Qry_Req*)pBuff;

    return zAti_CsqCommonReq(ptCsqQryReq, sizeof(T_zMmiaAs_Zcsq_Qry_Req));
}
/************************************************************************
: zAti_AutoStartReq
: +AUTOSTARTϢ 
    : pBuff,
    
    أZ_ATI_NOERROR_ERR    
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ                                                                           
************************************************************************/
DWORD zAti_AutoStartReq (VOID* pBuff)
{
    T_zApMmia_AutoStart_Req  *ptAutoStartReq    = (T_zApMmia_AutoStart_Req *)pBuff;

    /* Ѿйʼ+AUTOSTARTٽпʼ*/
    if (g_zAti_atDataEx[g_zAti_CurInstance].bCardInitiatedFlag == Z_ATI_CARDINIT_FINISH)
    {
        zAti_SetAutoStartState (Z_ATI_AUTOSTART_WAITRFON);
        if(Z_FAIL == zAti_RfCtrlReq(ptAutoStartReq->bSrcIndex, ptAutoStartReq->bDesIndex, Z_APMMIA_CFUNFUN_FULLFUN))
        {
            zAti_SetAutoStartState (Z_ATI_AUTOSTART_CARDOK);
            return Z_APMMIA_OPTNOTALW_ERR;
        }
    }
    else
    {
        // ʱzAti_GetAutoStartState() һΪZ_ATI_AUTOSTART_INITδʼڳʼ 
        zAti_SetAutoStartState (Z_ATI_AUTOSTART_WAITUICCINIT);
        if(g_zAti_atDataEx[g_zAti_CurInstance].bCardInitiatedFlag != Z_ATI_CARDINIT_ING)
        {
#if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
            BYTE bSrcIndex    = (g_zAti_CurInstance == 0? ZATI2_CHANNEL_ID_NUM251 : ZATI2_CHANNEL_ID_NUM252);
#else
            BYTE bSrcIndex    = ZATI2_CHANNEL_ID_NUM251;
#endif
            zAti_InitCard(bSrcIndex, Z_ATI_INVALID_BYTE);
            zAti_CardInitFlgClr_SigCd(g_zAti_CurInstance, Z_ATI_CARDINIT_ING);
        }
    }

   return Z_APMMIA_NORESULT;
}

/****************************************************
:zAti_GetMtAutoAnsMsg
:ȡӦϢ
****************************************************/
BOOL zAti_GetMtAutoAnsMsg(BYTE bType, PBYTE pAtMemBuf, T_zApMmia_SmMtActAns_Req* ptApAnsReq)
{
    BYTE bCid= 0;

    T_zDev_AtMem_SM_AutoRsp *pAutoRsp = (T_zDev_AtMem_SM_AutoRsp*)pAtMemBuf;
    switch(pAutoRsp->bCgauto)
    {
        case Z_APMMIA_TURN_ON_NEGARSP_PSDOMAIN:
            ptApAnsReq->bAnsType = Z_APMMIA_SM_MT_ACT_REJ;
            break;

        case Z_APMMIA_TURN_ON_RSP_PSDOMAIN:
            ptApAnsReq->bAnsType = Z_APMMIA_SM_MT_ACT_ACC;
            break;

        case Z_APMMIA_MODEM_MODE_PSDOMAIN:
        case Z_APMMIA_MODEM_MODE_PSCSDOMAIN:
            ptApAnsReq->bAnsType = Z_APMMIA_SM_MT_ACT_ACC;
            ptApAnsReq->bS0Val = pAutoRsp->bS0;
            break;

        case Z_APMMIA_TURN_OFF_RSP_PSDOMAIN:
            g_zAti_atDataEx[g_zAti_CurInstance].bMtAdrrType = bType;
            return FALSE;

        default:
            break;
    }

    if(ptApAnsReq->bAnsType == Z_APMMIA_SM_MT_ACT_ACC
        &&!zAti_GetMtIdleCid(bType, &bCid))
    {
        ptApAnsReq->bAnsType = Z_APMMIA_SM_MT_ACT_REJ;
    }
    ptApAnsReq->abCid[0] = bCid;
    ptApAnsReq->bCidNum = 1;
    ptApAnsReq->bAtFg = Z_INVALID;
    ptApAnsReq->bSrcIndex = ZATI2_CHANNEL_ID_NUM_END + 1;
    ptApAnsReq->bDesIndex = 0xff;
    return TRUE;
}

/**************************************************
:zAti_GetMtSecPdnAnsMsg
:μӦ
**************************************************/
VOID zAti_GetMtSecPdnAnsMsg(T_zMmiaSm_Cgev_SecPdn* pSecPdn, T_zApMmia_SmMtActAns_Req* ptAnsReq)
{
    //BYTE bAtMemItem = 0;
    T_zDev_AtMem_SM_AutoRsp tAtData    = {0};

    /* //--
    bAtMemItem = (g_zAti_CurInstance ? Z_AtMem_ID_AutoRsp2 : Z_AtMem_ID_AutoRsp1);
    if (Z_FAIL == zDev_AtMemReadItem(bAtMemItem, 0, (PBYTE)&tAtData))
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");
        tAtData.bCgauto = Z_APMMIA_TURN_ON_RSP_PSDOMAIN;
    }
    */
    zDev_AtMemReadItem(Z_AtMem_ID_AutoRsp, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
    switch(tAtData.bCgauto)
    {
        case Z_APMMIA_TURN_ON_NEGARSP_PSDOMAIN:
            ptAnsReq->bAnsType = Z_APMMIA_SM_MT_ACT_REJ;
            break;

        case Z_APMMIA_TURN_ON_RSP_PSDOMAIN:
        case Z_APMMIA_TURN_OFF_RSP_PSDOMAIN:
            ptAnsReq->bAnsType = Z_APMMIA_SM_MT_ACT_ACC;
            break;

        case Z_APMMIA_MODEM_MODE_PSDOMAIN:
        case Z_APMMIA_MODEM_MODE_PSCSDOMAIN:
            ptAnsReq->bAnsType = Z_APMMIA_SM_MT_ACT_ACC;
            ptAnsReq->bS0Val = tAtData.bS0;
            break;

        default:
            break;
    }

    ptAnsReq->abCid[0] = pSecPdn->bCid;
    ptAnsReq->bCidNum = 1;
    ptAnsReq->bAtFg = Z_INVALID;
    ptAnsReq->bDesIndex = 0xff;
    ptAnsReq->bSrcIndex = ZATI2_CHANNEL_ID_NUM_END + 1;
}

/**************************************************************************
: zAti_MarkSmEsmIndex
: ¼SM ESM 
    : 
    
    أ
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
VOID __ps_4g_func zAti_MarkSmEsmIndex(VOID *ptBuff, BYTE bTaskId)
{
    if (bTaskId == Z_ATI_TASKID_SM)
    {
        zAti_MarkIndex(ptBuff, Z_PSMDL_SM);
    }
    else if (bTaskId == Z_ATI_TASKID_ESM)
    {
        zAti_MarkIndex(ptBuff, Z_PSMDL_ESM);
    }
}
/*********************************************************************
*:zAt_GetValidCid
*:2/3G¶Ǳ·Ĵ4CID
*,Ѱ2-4еĿCID,ǵCID
*********************************************************************/
BYTE __ps_4g_func zAt_GetValidCid(BYTE bCid, PBYTE pbNewCid)
{
    BYTE i = 0;
    T_zMmiaSm_PdpAddr      *ptPdpAddr = (T_zMmiaSm_PdpAddr*)zAti_GetUB(sizeof(T_zMmiaSm_PdpAddr));  
    T_zMmiaSm_PcoInfo      *ptPcoInfo = (T_zMmiaSm_PcoInfo*)zAti_GetUB(sizeof(T_zMmiaSm_PcoInfo));
    T_zDev_AtMem_SmCidData *ptSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));

    for (i = Z_ATI_SM_MAX_CID; i > Z_ATI_SM_MIN_CID; i--)
    {
        zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, i, (PBYTE)ptSmData, g_zAti_CurInstance);
        if(ptSmData->bPdpInfoFg==Z_ATI_PDP_NotDefine
            &&!zAti_IsCidUsed(i) && !zAti_GetPdpInfoByCid(i, ptPdpAddr, ptPcoInfo, g_zAti_CurInstance))
        {
            *pbNewCid = i;
            zAti_RetUB((VOID**)&ptPdpAddr);
            zAti_RetUB((VOID**)&ptPcoInfo);
            zAti_RetUB((VOID**)&ptSmData);
            return Z_SUCC;
        }
    }

    zAti_RetUB((VOID**)&ptPdpAddr);
    zAti_RetUB((VOID**)&ptPcoInfo);
    zAti_RetUB((VOID**)&ptSmData);
    return Z_FAIL;
}
/*******************************************************
*:zAt_DefCidParam
*:ԭCIDϢ䵽ĿCID
*******************************************************/
VOID __ps_4g_func zAt_DefCidParam(BYTE bCid, BYTE bNewCid)
{
    T_zDev_AtMem_SmCidData *ptSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));

    zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, bCid,(PBYTE)ptSmData, g_zAti_CurInstance);
    zDev_AtMemWriteItem(Z_AtMem_ID_SmCidData, bNewCid, (PBYTE)ptSmData, g_zAti_CurInstance);
    zAti_RetUB((VOID**)&ptSmData);
}
/**************************************************************************
: zAti_SmCgactReq
:  CGACTִϢ
    : 
    
    أZ_APMMIA_NORESULT       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD __ps_4g_func zAti_SmCgactReq(VOID* pBuff)
{
    BYTE bMdl = zAti_GetTaskIndex (g_zAti_CurInstance);
    T_zApMmia_SmActDeact_Req *ptApCgactReq = (T_zApMmia_SmActDeact_Req *)pBuff;
    
    if (bMdl == Z_ATI_TASKID_ATI)
    {
        return Z_APMMIA_OPTNOTALW_ERR;
    }
    zAti_MarkSmEsmIndex(pBuff, bMdl);

    /*  syntax: +CGACT=[<state> [,<cid>[,<cid>[,]]]]*/ 
    /*  action: û<state>, cidȱʡ*/
    if (ptApCgactReq->bTypeFlg == Z_APMMIA_INVALID)
    { 
        sprintf((char *)g_zAt_EncBuf, "%s", g_zAt_OK);
        return Z_APMMIA_NOERROR_ERR;
    }
    else
    {
        //zAti_SmPdpActDeactReq(Z_MMIASM_ATCMD_CGACT, pBuff, bMdl);
        //dwMsgId = (ptApCgactReq->bType == Z_APMMIA_SM_PDP_ACTIVE)? MMIA_SM_PDP_ACTIVATE_REQ_EV: MMIA_SM_PDP_DEACTIVATE_REQ_EV;

        if(ptApCgactReq->bType == Z_APMMIA_SM_PDP_ACTIVE )
        {
            T_zMmiaSm_PdpAct_Req *ptSmActReq = (T_zMmiaSm_PdpAct_Req*)zAti_GetUB(sizeof(T_zMmiaSm_PdpAct_Req));

            if(Z_VALID == zDev_IsMtNet() && Z_ATI_TASKID_SM == bMdl && 
                ptApCgactReq->bCidNum == 1 && ptApCgactReq->abCid[0] > Z_ATI_SM_MAX_CID)
            {
                BYTE bNewCid = 0;
                if(Z_SUCC == zAt_GetValidCid(ptApCgactReq->abCid[0], &bNewCid))/*ʧֱ·*/
                {
                    zAt_DefCidParam(ptApCgactReq->abCid[0], bNewCid);
                    ptApCgactReq->abCid[0] = bNewCid;
                }
            }

            ptSmActReq->bSrcIndex = ptApCgactReq->bSrcIndex;
            ptSmActReq->bDesIndex = ptApCgactReq->bDesIndex;
            ptSmActReq->bAtType   = Z_MMIASM_ATCMD_CGACT;

            ptSmActReq->bCidNum   = ptApCgactReq->bCidNum;
            zOss_Memcpy(ptSmActReq->abCid, ptApCgactReq->abCid, Z_APMMIA_SM_MAX_CID_NUM);
            zAti_MsgSend(MMIA_SM_PDP_ACTIVATE_REQ_EV, (PBYTE)ptSmActReq, sizeof(T_zMmiaSm_PdpAct_Req), bMdl);  
        }
        else // Z_APMMIA_SM_PDP_INACTIVE
        {
            T_zMmiaSm_PdpDeact_Req *ptSmDeactReq = (T_zMmiaSm_PdpDeact_Req*)zAti_GetUB(sizeof(T_zMmiaSm_PdpDeact_Req));    
            ptSmDeactReq->bSrcIndex = ptApCgactReq->bSrcIndex;
            ptSmDeactReq->bDesIndex = ptApCgactReq->bDesIndex;
            ptSmDeactReq->bAtType   = Z_MMIASM_ATCMD_CGACT;

            ptSmDeactReq->bCidNum   = ptApCgactReq->bCidNum;
            zOss_Memcpy(ptSmDeactReq->abCid, ptApCgactReq->abCid, Z_APMMIA_SM_MAX_CID_NUM);
            ptSmDeactReq->bIsDisconnect = ptApCgactReq->bIsDisconnect;
             
            zAti_MsgSend(MMIA_SM_PDP_DEACTIVATE_REQ_EV, (PBYTE)ptSmDeactReq, sizeof(T_zMmiaSm_PdpDeact_Req), bMdl);  
        }
        
        return Z_APMMIA_NORESULT;
    }    
}

// жϼϢǷbCid
BOOL zAti_HasCidInCgactMsg(T_zApMmia_SmActDeact_Req *ptApCgactReq, BYTE bCid)
{
    BYTE i = 0;
    for(i = 0; i < ptApCgactReq->bCidNum; i++)
    {
        if(ptApCgactReq->abCid[i] == bCid)
            return TRUE;
    }
    return FALSE;            
}

/**************************************************************************
: zAti_GetDeactMastExCid
: ȡCID·ȥʱȡCID
    : 
    
    أ
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
VOID __ps_4g_func zAti_GetDeactMastExCid(T_zApMmia_SmActDeact_Req *ptApCgactReq)
{
    BYTE i = 0;
    BYTE bMastCid = 0;
    BYTE bExCid   = 0;
    BYTE bCidNum  = ptApCgactReq->bCidNum;

    if((ptApCgactReq->bType != Z_APMMIA_SM_PDP_DEACTIVATE) || (bCidNum == Z_APMMIA_SM_MAX_CID_NUM))
    {
        return;        
    }

        //Ҫһ·
    for(i = 0; i < ptApCgactReq->bCidNum; i++)
    {
        if(zAti_IsMastCid(ptApCgactReq->abCid[i],&bExCid)  && bExCid != 0
            && !zAti_HasCidInCgactMsg(ptApCgactReq, bExCid) )
        {            
            ptApCgactReq->abCid[bCidNum++] = bExCid;
        }
        else if(zAti_IsExCid(ptApCgactReq->abCid[i],&bMastCid)
            && !zAti_HasCidInCgactMsg(ptApCgactReq, bMastCid) )
        {
            ptApCgactReq->abCid[bCidNum++] = bMastCid;
        }
        if (bCidNum == Z_APMMIA_SM_MAX_CID_NUM)
        {
            break;
        }
    }
    ptApCgactReq->bCidNum = bCidNum;
}
/**************************************************************************
: zAti_SmCgactExc
:  +CGACT=[<state> [,<cid>[,<cid>[,]]]], ִ
    : 
    
    أZ_APMMIA_NORESULT       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD __ps_4g_func zAti_SmCgactExc(VOID* pBuff)
{
    zAti_GetDeactMastExCid((T_zApMmia_SmActDeact_Req *)pBuff);//ȥ,ʱҪһ·
    
    return zAti_SmCgactReq(pBuff);  
}


/**************************************************************************
: zAti_SendSmZgactReq
:  Zgact request Ϣ

    : 
    
    Z_APMMIA_NORESULT       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD __ps_4g_func zAti_SendSmZgactReq(T_zApMmia_SmZgact_Req  *ptApZgactReq)
{
    BYTE bMdl = zAti_GetTaskIndex (g_zAti_CurInstance);
    BYTE bCid  = 0;
    
    if (bMdl == Z_ATI_TASKID_ATI)
    {
        return Z_APMMIA_OPTNOTALW_ERR;
    }

    zAti_MarkSmEsmIndex(ptApZgactReq, bMdl);
  
    if(zAti_IsMastCid(ptApZgactReq->bCid,&bCid))
    {
        ptApZgactReq->bCidEx = bCid;
    }
    else if(zAti_IsExCid(ptApZgactReq->bCid,&bCid))
    {
        ptApZgactReq->bCidEx = ptApZgactReq->bCid;
        ptApZgactReq->bCid = bCid;
    }
   

    if(Z_APMMIA_SM_PDP_ACTIVATE == ptApZgactReq->bState)
    {    
        T_zMmiaSm_PdpAct_Req *ptSmActReq =  (T_zMmiaSm_PdpAct_Req*)zAti_GetUB(sizeof(T_zMmiaSm_PdpAct_Req));    

        ptSmActReq->bSrcIndex = ptApZgactReq->bSrcIndex;
        ptSmActReq->bDesIndex = ptApZgactReq->bDstIndex;
        ptSmActReq->bAtType   = Z_MMIASM_ATCMD_ZGACT;

        // 
        ptSmActReq->abCid[0] = ptApZgactReq->bCid;
        ptSmActReq->bCidNum = 1;
        
        if(ptApZgactReq->bCidEx != 0)
        {
            ptSmActReq->bCidNum = 2;
            ptSmActReq->abCid[1] = ptApZgactReq->bCidEx;
        } 
        zAti_MsgSend(MMIA_SM_PDP_ACTIVATE_REQ_EV, (PBYTE)ptSmActReq, sizeof(T_zMmiaSm_PdpAct_Req), bMdl); 
    }
    else
    {
        T_zMmiaSm_PdpDeact_Req *ptSmDeactReq =  (T_zMmiaSm_PdpDeact_Req*)zAti_GetUB(sizeof(T_zMmiaSm_PdpDeact_Req));    

        ptSmDeactReq->bSrcIndex = ptApZgactReq->bSrcIndex;
        ptSmDeactReq->bDesIndex = ptApZgactReq->bDstIndex;
        ptSmDeactReq->bAtType   = Z_MMIASM_ATCMD_ZGACT;
        
        if(ptApZgactReq->bCidEx != 0)
        {
            ptSmDeactReq->bCidNum = 2;
            ptSmDeactReq->abCid[0] = ptApZgactReq->bCidEx;
            ptSmDeactReq->abCid[1] = ptApZgactReq->bCid;
        } 
        else
        {
            ptSmDeactReq->abCid[0] = ptApZgactReq->bCid;
            ptSmDeactReq->bCidNum = 1;
        }
        zAti_MsgSend(MMIA_SM_PDP_DEACTIVATE_REQ_EV, (PBYTE)ptSmDeactReq, sizeof(T_zMmiaSm_PdpDeact_Req), bMdl); 
    }

    //zAti_SmPdpActDeactReq(Z_MMIASM_ATCMD_ZGACT, pBuff, bMdl);
     
    return Z_APMMIA_NORESULT;
}


/**************************************************************************
: zPS_mmia_SmZgactReq
:  +ZGACT, ִ
    : 
    
    Z_APMMIA_NORESULT       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD __ps_4g_func zAti_SmZgactReq(VOID* pBuff)
{    
    T_zApMmia_SmZgact_Req  *ptApZgactReq = (T_zApMmia_SmZgact_Req *)pBuff;   

    if(Z_APMMIA_SM_PDP_ACTIVATE == ptApZgactReq->bState)
    {  
        if(zAti_IsDataStatus(ptApZgactReq->bCid))
        {
            return Z_APMMIA_OPTNOTALW_ERR;
        }
    }
         
    return zAti_SendSmZgactReq(ptApZgactReq);
}


/***********************************************************************************
:zAti_SaveContextInfoAndSendActReq
:άCIDͨϢ,ͼ
˵:ѾŵCIDٴνв
***********************************************************************************/
BOOL zAti_SaveContextInfoAndSendActReq(T_zApMmia_SmActDeact_Req* pAct, BYTE bPdpType)
{
    BYTE bInstance = 0;
    T_ZAti_ChannelInfo *pChnelNode = NULL;

    if(pAct == ZOSS_NULL || (pChnelNode = zAti_GetChannelNodePtr(pAct->bSrcIndex)) == ZOSS_NULL)
    {
        return FALSE;
    }

    bInstance = zAti_GetTaskInstantByChnlId(pAct->bSrcIndex);
    if (pChnelNode->cmd_id != ZAT2_SM_D || bPdpType != Z_MMIASM_IPV4)//ATDIPV4ֻŲ
    {
        /*ͼ*/
        if(zAti_SmCgactExc(pAct)!=Z_APMMIA_NORESULT)
        {
            return FALSE;
        }
        pChnelNode->IsPpp = TRUE;//ͨ
    }
    /*CIDͨ*/
    zAti_SaveLastCidTab(pAct->abCid[0],pAct->bSrcIndex);

    /*IP͵ĲϱCONNECTлͨ*/
    if(bPdpType == Z_MMIASM_IPV4)
    {
        zAti_HandleConnInd(pAct->bDesIndex,pAct->bSrcIndex);
        if (pChnelNode->cmd_id == ZAT2_SM_D)
        {
            g_zAti_SmContext[bInstance].lastCidTab[pAct->abCid[0]-1].isPppActCmplete = FALSE;
        }  
    }

    return TRUE;
}
/*************************************************************
:zAti_PppTransCidAndSendActReq
:תCIDϢͼ
*************************************************************/
DWORD zAti_PppTransCidAndSendActReq(VOID *pDataPtr)
{
    BYTE bPdpType = 0;
    T_zMmiaSm_DataState_Req *pDataStateReq = (T_zMmiaSm_DataState_Req *)pDataPtr;
    T_zApMmia_SmActDeact_Req tAct = {0};
    //T_ZAti_ChannelInfo *           pChnelNode = zAti_GetChannelNodePtr(pDataStateReq->bSrcIndex);

    if(NULL == pDataPtr)
    {
        return Z_APMMIA_OPTNOTALW_ERR;
    }
    if(!zAti_PppTransCid(&tAct, pDataStateReq, &bPdpType))//CIDϢת
    {
        return Z_APMMIA_OPTNOTALW_ERR;
    }
    if(!zAti_SaveContextInfoAndSendActReq(&tAct, bPdpType))
    {
        return Z_APMMIA_OPTNOTALW_ERR;
    }
    //pChnelNode->IsPpp = TRUE;//ͨ
    return Z_APMMIA_NORESULT;
}

// C# ʹõĹҶ
DWORD zAti_SmDisconnectReq(VOID* pBuff)
{
    T_zMmiaSm_Disconnect_Req* pDisCon = (T_zMmiaSm_Disconnect_Req*)pBuff;
    zAti_UsbSioDeactiveByAtiReq(pDisCon->bChnl);
    sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
    return Z_APMMIA_NOERROR_ERR;
}
/**********************************************************************
*:zAti_ZepcgReq
*:+ZEPCGĲͬѡͬĴʽ
*˵:ǰΪ25,1ȻظOK,ȡ
*ϱķʽ,ʽ
***********************************************************************/
DWORD zAti_ZepcgReq(VOID* pBuff)
{
    DWORD dwResult = 0;
    T_zMmiaL1E_Zepcg_Req *pZepcg = (T_zMmiaL1E_Zepcg_Req*)pBuff;
    T_zMmiaL1E_Zepcg_Req *pL1ezepcg = ZOSS_NULL;
    /*+ZEPCG=25,1,XʱֱӻظOK*/
    if(Z_ZEPCG_IND_CMD == pZepcg->bCmd && pZepcg->bMode == AP_MMIA_ZEPCG_QRY)
    {
        sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
        dwResult = Z_APMMIA_NOERROR_ERR;
    }
    else
    {
        dwResult = Z_APMMIA_NORESULT;
    }

    pL1ezepcg = (T_zMmiaL1E_Zepcg_Req*)zAti_GetUB(sizeof(T_zMmiaL1E_Zepcg_Req));
    zOss_Memcpy(pL1ezepcg, pZepcg, sizeof(T_zMmiaL1E_Zepcg_Req));
    if(Z_FAIL == zAti_MsgSend(MMIA_L1E_ZEPCG_REQ, (PBYTE)pL1ezepcg, sizeof(T_zMmiaL1E_Zepcg_Req), Z_ATI_TASKID_L1E))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");    
        dwResult = Z_APMMIA_OPTNOTALW_ERR;
    }

    return dwResult;
}

DWORD zAti_SendSmAnsReq(VOID* pBuff)
{
    BYTE bMdl = zAti_GetTaskIndex(g_zAti_CurInstance);
    T_zApMmia_SmMtActAns_Req *ptApAnsReq = (T_zApMmia_SmMtActAns_Req*)pBuff;
    T_zMmiaSm_MtActAns_Req   *ptSmReq    = ZOSS_NULL;

    if (bMdl == Z_ATI_TASKID_ATI)
    {
        return Z_APMMIA_OPTNOTALW_ERR;
    }
    zAti_MarkSmEsmIndex(pBuff, bMdl);
     /*====================================== ȱʡֵ ==================================== */
    ptSmReq = (T_zMmiaSm_MtActAns_Req*)zAti_GetUB(sizeof(T_zMmiaSm_MtActAns_Req));
    ptSmReq->bSrcIndex = ptApAnsReq->bSrcIndex;
    ptSmReq->bDesIndex = ptApAnsReq->bDesIndex;
    ptSmReq->bType     = ptApAnsReq->bAnsType;
    ptSmReq->bCidNum   = ptApAnsReq->bCidNum;
    ptSmReq->bS0Val = ptApAnsReq->bS0Val;
    ptSmReq->bAtFg = ptApAnsReq->bAtFg;

    zOss_Memcpy(ptSmReq->abCid, ptApAnsReq->abCid, Z_APMMIA_SM_MAX_CID_NUM);

    zAti_MsgSend(MMIA_SM_MT_ACT_ANS_REQ_EV, (PBYTE)ptSmReq, sizeof(T_zMmiaSm_MtActAns_Req), bMdl);

    return Z_APMMIA_NORESULT;
}



/**************************************************************************
: zAti_SmAnsReq
: ܻܾMT PDPļ
    : pBuff,ָϢAP_MMIA_SmAnsReq_EvϢ
    
    أZ_APMMIA_NORESULT       

ע    ͣMT־λ0
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_SmAnsReq(VOID* pBuff)
{
    if(!zAti_UsbSioSmMtActAnsReq(pBuff))
    {
        return Z_APMMIA_OPTNOTALW_ERR;
    }

    return zAti_SendSmAnsReq(pBuff);
}

BYTE zAti_SendPdpCauseQueryReq(T_zApMmia_CauseQuery_Req *ptApCauseReq)
{
    BYTE bMdl = 0;
    BYTE bSendSmRet = Z_SUCC;
    T_zMmiaSm_QueryPdpCause_Req *ptSmReq = (T_zMmiaSm_QueryPdpCause_Req*)zAti_GetUB(sizeof(T_zMmiaSm_QueryPdpCause_Req));
    
    bMdl = zAti_GetTaskIndex (g_zAti_CurInstance);

    if(bMdl == Z_ATI_TASKID_ATI)
    {
        g_zAti_atDataEx[g_zAti_CurInstance].tCeerInfo.bSmCauseRpted =Z_VALID;
        zAti_RetUB((VOID * * )&ptSmReq);
        return Z_FAIL;
    }
    else
    {
        ptSmReq->bSrcIndex = ptApCauseReq->bSrcIndex;
        ptSmReq->bDesIndex = ptApCauseReq->bDesIndex;
        bSendSmRet = zAti_MsgSend(MMIA_SM_PDP_CAUSE_QUERY_REQ_EV, (PBYTE)ptSmReq, sizeof(T_zMmiaSm_QueryPdpCause_Req), bMdl);
        if (bSendSmRet != Z_SUCC)
        {
            g_zAti_atDataEx[g_zAti_CurInstance].tCeerInfo.bSmCauseRpted =Z_VALID;
        }
        return bSendSmRet;
    }
}
/************************************************************************
: zAti_CeerReq
: ѯʧԭ      
    : pBuff,
    
    أZ_ATI_NOERROR_ERR    
ע    ͣ616000234133mm statusĲ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ                                                                           
************************************************************************/
DWORD zAti_CeerReq(VOID* pBuff)
{
    BYTE bSendCcRet = Z_SUCC;
    BYTE bSendSmRet = Z_SUCC;
    BYTE bSendUmmRet = Z_SUCC;
    T_zApMmia_CauseQuery_Req    *ptApCauseReq = (T_zApMmia_CauseQuery_Req*)pBuff;
    T_zMmiaCc_CauseQuery_Req    *ptCcReq      = (T_zMmiaCc_CauseQuery_Req*)zAti_GetUB(sizeof(T_zMmiaCc_CauseQuery_Req));
    T_zMmiaUmm_CauseQuery_Req *ptUmmReq    = (T_zMmiaUmm_CauseQuery_Req*)zAti_GetUB(sizeof(T_zMmiaUmm_CauseQuery_Req));

    zAti_InitCeerGlobalVarByInstNo(g_zAti_CurInstance);
    /*======================================  ѯCC  ==========================================*/
    ptCcReq->bSrcIndex = ptApCauseReq->bSrcIndex;
    ptCcReq->bDesIndex = ptApCauseReq->bDesIndex;

    bSendCcRet = zAti_MsgSend(MMIA_CC_CAUSE_QUERY_REQ_EV, (PBYTE)ptCcReq, sizeof(T_zMmiaCc_CauseQuery_Req), Z_ATI_TASKID_CC);

    if (bSendCcRet != Z_SUCC)
    {
        g_zAti_atDataEx[g_zAti_CurInstance].tCeerInfo.bCcCauseRpted=Z_VALID;
    }
    /*=======================================ѯUMM==========================================*/
    ptUmmReq->bSrcIndex = ptApCauseReq->bSrcIndex;
    ptUmmReq->bDesIndex = ptApCauseReq->bDesIndex;

    bSendUmmRet = zAti_MsgSend(MMIA_UMM_CAUSE_QUERY_REQ_EV, (PBYTE)ptUmmReq, sizeof(T_zMmiaUmm_CauseQuery_Req), Z_ATI_TASKID_UMM);

    if (bSendUmmRet != Z_SUCC)
    {
        g_zAti_atDataEx[g_zAti_CurInstance].tCeerInfo.bUmmCauseRpted =Z_VALID;
    }
    /*======================================  ѯGPRS/EPS  ==========================================*/
    bSendSmRet = zAti_SendPdpCauseQueryReq(ptApCauseReq);

    if (bSendCcRet != Z_SUCC && bSendSmRet != Z_SUCC && bSendUmmRet != Z_SUCC)
    {
        return Z_APMMIA_OPTNOTALW_ERR;
    }

    return Z_APMMIA_NORESULT;
}
/***************************************************************************
:zAti_SmMtCgevInd
:MTϱCGEV
˵             :
༤EventTypeΪ1ϱCGEV,ATI·ANSREQSM/ESM
EventTypeΪ0˵μɹͨ״̬ϱCONNECT
һμֱӸͨ״̬ϱCONNECT
***************************************************************************/
DWORD __ps_4g_func zAti_SmMtCgevInd(VOID* pBuff, DWORD *pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaSm_Cgev_Ind *pCgevInd = (T_zMmiaSm_Cgev_Ind*)pBuff;
    T_zApMmia_SmMtActAns_Req tAnsReq = {0};

    if(pCgevInd->bCgevType == Z_MMIASM_CGEV_TYPE_SEC_PDN_IND
    &&pCgevInd->u.tSecPdnInd.bType == Z_MMIASM_CGEV_NW_SEC_PDN_ACT)
    {
        if(pCgevInd->u.tSecPdnInd.bEventType == Z_MMIASM_CGEV_EVENT_TYPE_ACKREQ)
        {
            zAti_GetMtSecPdnAnsMsg(&pCgevInd->u.tSecPdnInd,&tAnsReq);
            zAti_SendSmAnsReq(&tAnsReq);
            return Z_APMMIA_NORESULT;
        }
        else//жǷҪϱCONNECT
        {
           // zAti_CgevMtConnect(pCgevInd->u.tSecPdnInd.bCid);
        }
    }
    /*MTһμɹ*/
    *pdwChangedMsgId = MMIA_SM_CGEV_IND_EV;
    
    return Z_APMMIA_NORESULT;
}
#ifdef Z_SELL_STAT_SUPPORT
VOID zAti_SellStat_SmDeactInd(BYTE bDeactCid, BYTE bInsNo)
{
    T_zAti_NV_SellStat   tNvSellStat = {0};
    BYTE bNvItemId = ((bInsNo == 0) ? Z_ATI_NV_SellStat1 : Z_ATI_NV_SellStat2);

    zDev_NV_AtiReadItem(bNvItemId, (PBYTE)&tNvSellStat);
    zAti_CleanCidinfo(bDeactCid, bInsNo);

    if (0xff != g_zAti_atDataEx[bInsNo].tSellStat.bPdiUsedCid)     /* PDIʹһCID */
    {
        if (Z_ATI_CIDINFO_PDPDEACT == g_zAti_atDataEx[bInsNo].tCIDInfo[g_zAti_atDataEx[bInsNo].tSellStat.bPdiUsedCid - Z_DEV_AtMem_MININUM_CID].bPdpActFg)
        {
            if (Z_SUCC == zAti_IsIpv4PdpActiveAndRetCid(ZOSS_NULL, bInsNo))
            {
                (VOID)zAti_SellStat_SendPackettoPdi(bInsNo);
                return;
            }
            else
            {
                zAti_SellStat_SendAborttoPdi(Z_MMIAPDI_ABORTCLEAN_INVALID, bInsNo);
            }
        }
    }
    else
    {
        if(Z_FAIL == zAti_IsIpv4PdpActiveAndRetCid(ZOSS_NULL, bInsNo))
        {
            zAti_StopTimerAndGetSumPdpEndTick(MMIA_SELL_STAT_ONE_PDP_EXPIRY_EV, bInsNo);
            zAti_StopTimerAndGetSumPdpEndTick(MMIA_SELL_STAT_SUM_PDP_EXPIRY_EV, bInsNo);

            tNvSellStat.dwSumPdpTime += zAti_SellStat_CalcPdpSumTime(bInsNo);
            zDev_NV_AtiWriteItem(bNvItemId, (PBYTE)&tNvSellStat);
        }
    }

}
#endif
/**************************************************************************
: zAti_SmDeactivateInd
: ȥָʾͳƴ
    : pBuff,
    
    أZ_ATI_NOERROR_ERR       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
VOID __ps_4g_func zAti_SmDeactivateInd(VOID* pBuff)
{
    T_zMmiaSm_CidDeact_Ind   *ptDeactInd  = (T_zMmiaSm_CidDeact_Ind*)pBuff;

    if (Z_FAIL == zAti_CheckCid(ptDeactInd->bCid))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");     
        return;
    }

    zAti_HandleSmDeActInd(ptDeactInd);
#ifdef Z_SELL_STAT_SUPPORT
    if(Z_VALID == zAti_IsDualPsDualUicc())
    {
        zAti_SellStat_SmDeactInd(ptDeactInd->bCid, g_zAti_CurInstance);
    }
    else
    {
        zAti_SellStat_SmDeactInd(ptDeactInd->bCid, Z_ATI_INSNO_1);
    }
#endif
}

/**************************************************************************
: zAti_SmContextCnf
: SM ظİǨϢ
    : pBuff,
    
    أZ_ATI_NOERROR_ERR       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
#ifdef CXT_MOV
DWORD zAti_SmContextCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaSm_Context_Cnf   *ptContextCnf = (T_zMmiaSm_Context_Cnf*)pBuff;
    DWORD dwResult = zAti_HandleSmContextCnf(ptContextCnf);
    if(Z_APMMIA_NORESULT != dwResult)
    {
        zAti_ClearPsMovStat();
        zAti_ProcError(pChnelNode, dwResult);
        zAti_HandStoredCmdInPsmov();
    }

    return Z_APMMIA_NORESULT;
}
#endif

/***************************************************************************
:ϲϢ,modeԶѡֶѡעᣬ
formatֶѡʧתԶȲͬ
:
pbBuff      Ϣָ
wMsgLen     Ϣ
:      Z_APATI_NOERROR_ERR
ǰ:
:
***************************************************************************/
DWORD __ps_static_func zAti_CopsSet(VOID* pBuff)
{
    T_zApMmia_CopsSet_Req *ptCopsSet = (T_zApMmia_CopsSet_Req*)pBuff;  /* յϢ */    
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};

     /*====================================== ȱʡֵ ==================================== */
    /*  syntax: +COPS=[<mode>[,<format>[,<oper>[,< AcT>]]]]                                  */ 
    /*  action: <mode>,<format>,< AcT> ȱʡֵΪ0; <oper>mode=1,4ʱ                   */
    /*====================================================================================== */
    /* òmode */  
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    switch(ptCopsSet->bMode)
    {
        case Z_APMMIA_COPSMODE_AUTO:        /* modeԶѡ */
            return zAti_CopsAutoSearchPlmnProc(ptCopsSet, &tAtData);

        case Z_APMMIA_COPSMODE_MANU:                /* ֶѡ */
        case Z_APMMIA_COPSMODE_NANUAUTO:            /* ֶѡֶתԶ */
            return zAti_CopsManuSearchPlmnProc (ptCopsSet, &tAtData);

        case Z_APMMIA_COPSMODE_DEREG:              /* CSע */
            return zAti_CopsDeregProc(ptCopsSet, &tAtData);

        case Z_APMMIA_COPSMODE_SETONLY:              /*  format */
            return zAti_CopsSetFormatProc(ptCopsSet, &tAtData);

        default:
            return Z_APMMIA_INVALIDPARA_ERR;/*  ߵʱѱ */
    }
}
/***********************************************************************
*:zAti_IsImsVopsChanged
*:жϵǰʽ״̬Ƿб仯
***********************************************************************/
static BOOL __ps_comm_func zAti_IsActChang(T_zMmiaUmm_PlmnInfo_Ind* ptPlmnInfo)
{
    BYTE bNewAct = 0xff;
    BYTE bOldAct = 0xff;

    if(zAti_IsLocState (ptPlmnInfo->bCsState) ||
        zAti_IsLocState (ptPlmnInfo->bPsState) ||
        zAti_IsLocState (ptPlmnInfo->bEpsState) ||
        ptPlmnInfo->bCsState == Z_MmiaUmm_AttempUpdate)
    {
        bNewAct = zAti_GetByteAct(&ptPlmnInfo->tPlmnAct.tAct);
        bOldAct = zAti_GetByteAct(&g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.tAct);
        if(bNewAct != bOldAct)
        {
            return TRUE;
        }
    }

    return FALSE;
}

static VOID __ps_static_func zAti_ZimsVopsIndicat(T_zMmiaUmm_PlmnInfo_Ind* ptPlmnInfo, BYTE bImsOverPsInd)
{
    T_zApMmia_Imsvops_Ind* ptImsvopsInd = ZOSS_NULL;
    ptImsvopsInd = (T_zApMmia_Imsvops_Ind*)zAti_GetUB(sizeof(T_zApMmia_Imsvops_Ind));
    ptImsvopsInd->bSrcIndex = ptPlmnInfo->bSrcIndex;
    ptImsvopsInd->bDesIndex = ptPlmnInfo->bDesIndex;
    ptImsvopsInd->bSupport = bImsOverPsInd;

    zAti_RecvServerHandlerSlaver(AP_MMIA_IMSVOPS_IND_EV, (PBYTE)ptImsvopsInd, sizeof(T_zApMmia_Imsvops_Ind));
}
/***************************************************************************
: zAti_ZimsVopsIndicat
: жǷϱ+CIREPI
UMMԼbImsOverPsIndΪ0xffʱʾplmninfoϱCSע״̬
ʱ
***************************************************************************/
static VOID __ps_static_func zAti_HandleImsVopsInd(T_zMmiaUmm_PlmnInfo_Ind* ptPlmnInfo,
                                  T_zDev_AtMem_Mmia_PrivateMem* ptAtData)
{
    if(ptPlmnInfo->bImsOverPsInd != 0xff && g_zAti_atDataEx[g_zAti_CurInstance].bImsvopsStat != ptPlmnInfo->bImsOverPsInd)
    {
        g_zAti_atDataEx[g_zAti_CurInstance].bImsvopsStat = ptPlmnInfo->bImsOverPsInd;

        if(ptAtData->bCirepSet == Z_ATI_SetType_Enable)
        {
            zAti_ZimsVopsIndicat(ptPlmnInfo, g_zAti_atDataEx[g_zAti_CurInstance].bImsvopsStat);
        }
    }
    else if(ptPlmnInfo->bImsOverPsInd != 0xff && zAti_IsActChang(ptPlmnInfo) && g_zAti_atDataEx[g_zAti_CurInstance].bImsvopsStat != 0xff)
    {
        if(ptAtData->bCirepSet == Z_ATI_SetType_Enable)
        {
            zAti_ZimsVopsIndicat(ptPlmnInfo, g_zAti_atDataEx[g_zAti_CurInstance].bImsvopsStat);
        }
    }
}
static VOID __ps_comm_func zAti_SendEmeberIndicat(T_zMmiaUmm_PlmnInfo_Ind* ptPlmnInfo, BYTE bSupport, BYTE bIndType)
{
    T_zApMmia_Emerber_Ind* ptEmerberInd = ZOSS_NULL;

    ptEmerberInd = (T_zApMmia_Emerber_Ind*)zAti_GetUB(sizeof(T_zApMmia_Emerber_Ind));
    ptEmerberInd->bSrcIndex = ptPlmnInfo->bSrcIndex;
    ptEmerberInd->bDesIndex = ptPlmnInfo->bDesIndex;
    ptEmerberInd->bSupport = bSupport;
    ptEmerberInd->bType = bIndType;

    zAti_RecvServerHandlerSlaver(AP_MMIA_EMERBER_IND_EV, (PBYTE)ptEmerberInd, sizeof(T_zApMmia_Emerber_Ind));
}

static VOID __ps_comm_func zAti_NetEmerBerServIndicat(T_zMmiaUmm_PlmnInfo_Ind* ptPlmnInfo, 
    T_zDev_AtMem_Mmia_PrivateMem* ptAtData, BYTE bIndType, PBYTE pbGloEmrbInd)
{
    if(ptPlmnInfo->bEmergencybearerInd != 0xff && 
        ptPlmnInfo->bEmergencybearerInd != *pbGloEmrbInd)
    {
        *pbGloEmrbInd = ptPlmnInfo->bEmergencybearerInd;
        if(ptAtData->bCnemSet == Z_ATI_SetType_Enable)
        {
            zAti_SendEmeberIndicat(ptPlmnInfo, *pbGloEmrbInd, bIndType);
        }
    }
    /*ӵǰΪЧʽжϣʽЧʱϱ*/
    else if(zAti_IsActChang(ptPlmnInfo) && *pbGloEmrbInd != 0xff)
    {
        if(ptAtData->bCnemSet == Z_ATI_SetType_Enable)
        {
            zAti_SendEmeberIndicat(ptPlmnInfo, *pbGloEmrbInd, bIndType);
        }
    }
}
/*******************************************************************
*:zAti_HandleNetEmerBerServ
*:жUMMĽǷϱ
*******************************************************************/
static VOID __ps_static_func zAti_HandleNetEmerBerServ(T_zMmiaUmm_PlmnInfo_Ind* ptPlmnInfo,
                                  T_zDev_AtMem_Mmia_PrivateMem* ptAtData)
{
    if(ptPlmnInfo == NULL || ptAtData == NULL)
    {
        return;
    }

    if(Z_TD_ACT == zAti_GetByteAct(&ptPlmnInfo->tPlmnAct.tAct)||
        Z_W_ACT == zAti_GetByteAct(&ptPlmnInfo->tPlmnAct.tAct))
    {
        zAti_NetEmerBerServIndicat(ptPlmnInfo, ptAtData, Z_ATI_IU_MODE, &g_zAti_atDataEx[g_zAti_CurInstance].bUtranEmerbearInd);
    }
    else if(Z_LTE_ACT == zAti_GetByteAct(&ptPlmnInfo->tPlmnAct.tAct))
    {
        zAti_NetEmerBerServIndicat(ptPlmnInfo, ptAtData, Z_ATI_S1_MODE, &g_zAti_atDataEx[g_zAti_CurInstance].bLteEmerbearInd);
    }
    else
    {
         /*ΪTDLTEʱϱҽURTENLTEʱֵ
             ѯʱõΪһεֵ,GSMʽʽ*/
    }
}
/***************************************************************************
: zAti_ModeIndicat
: ϵͳģʽ仯¼ָʾ 
:
                ptPlmnInfo
:
ǰ:
:616000237711ʶH+ʾ֧
***************************************************************************/
VOID __ps_static_func zAti_ModeIndicat(BYTE bCsState, BYTE bPsState, BYTE bEpsState, BYTE bSrcIndex, BYTE bDstIndex,
                                         T_z_Act *tAct, BYTE bSubMode)
{
    BYTE                        bNeedInd  = Z_VALID;
    BYTE                        bIsSubmodeChng = Z_VALID;
    T_zApMmia_Mode_Ind*      ptModeInd = ZOSS_NULL;

    if (bCsState == Z_APMMIA_REGSTATE_REGDENIED ||
        bPsState == Z_APMMIA_REGSTATE_REGDENIED ||
        bEpsState == Z_APMMIA_REGSTATE_REGDENIED)
    {
        return;
    }
    if (zAti_IsLocState (bCsState) ||
        zAti_IsLocState (bPsState) ||
        zAti_IsLocState (bEpsState) ||
        bCsState == Z_MmiaUmm_AttempUpdate)    /*ΪCQNJ00234752״̬,״̬ʽģʽЧ*/
    {       
        if ((tAct->bGsm == Z_VALID) &&
            (g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.bAct == Z_APMMIA_COPSACT_GSM))
        {
            bIsSubmodeChng = zAti_CheckSubmodeIsChng (bSubMode);

            if (!bIsSubmodeChng)
            {
                bNeedInd = Z_INVALID;
            }
        }
        
        if ((tAct->bGsmCompact == Z_VALID))      /* ݲϱgsmcompact */
        {
            bNeedInd = Z_INVALID;
        }
        
        if (tAct->bTD == Z_VALID &&
           (g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.bAct == Z_APMMIA_COPSACT_UTRAN &&
            g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.bUtranAct == Z_ATI_UTRAN_TD))
        {
            bIsSubmodeChng = zAti_CheckSubmodeIsChng (bSubMode);

            if (!bIsSubmodeChng)
            {
                bNeedInd = Z_INVALID;
            }
        }
        
        if ((tAct->bW == Z_VALID) &&
            (g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.bAct == Z_APMMIA_COPSACT_UTRAN &&
             g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.bUtranAct == Z_ATI_UTRAN_W))
        {
            bIsSubmodeChng = zAti_CheckSubmodeIsChng (bSubMode);

            if (!bIsSubmodeChng)
            {
                bNeedInd = Z_INVALID;
            }
        }

        if (tAct->bLte == Z_VALID &&
            g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.bAct == Z_APMMIA_COPSACT_E_UTRAN)
        {
            bIsSubmodeChng = zAti_CheckSubmodeIsChng (bSubMode);

            if (!bIsSubmodeChng)
            {
                bNeedInd = Z_INVALID;
            }
        }
        
        if ((tAct->bGsm == Z_INVALID) &&
            (tAct->bTD  == Z_INVALID) &&
            (tAct->bW   == Z_INVALID) &&
            (tAct->bGsmCompact   == Z_INVALID) &&
            (tAct->bLte == Z_INVALID) &&
            (g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.bAct == 0XFF))
        {
            bNeedInd = Z_INVALID;
        }
    }
    else
    {
        if (g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.bAct == 0XFF)
        {
            bNeedInd = Z_INVALID;
        }
#ifdef PS_RAT_LTE
        else if(bCsState == Z_APMMIA_REGSTATE_UNKNOWN 
            && zAti_GetCurAct_ByIndex(g_zAti_CurInstance) == Z_LTE_ACT)
        {
            bNeedInd = Z_INVALID;
        }
#endif
    }

    
    if (bNeedInd == Z_VALID)
    {
        ptModeInd = (T_zApMmia_Mode_Ind*)zAti_GetUB(sizeof(T_zApMmia_Mode_Ind));
        ptModeInd->bSrcIndex = bSrcIndex;
        ptModeInd->bDesIndex = bDstIndex;
        
        if (zAti_IsLocState (bCsState) ||
            zAti_IsLocState (bPsState) ||
            zAti_IsLocState (bEpsState) ||
            bCsState == Z_MmiaUmm_AttempUpdate)    /*ΪCQNJ00234752״̬,״̬ʽģʽЧ*/
        {
            if (tAct->bGsm == Z_VALID)
            {
                ptModeInd->bMode = Z_APMMIA_GSMGPRS;
                ptModeInd->bSubModeFg = Z_VALID;
                ptModeInd->bSubMode = bSubMode;
            }
            else if (tAct->bTD == Z_VALID)
            {
                ptModeInd->bMode = Z_APMMIA_TDSCDMA;
                ptModeInd->bSubModeFg = Z_VALID;
                ptModeInd->bSubMode = bSubMode;
            }
            else if (tAct->bW == Z_VALID)
            {
                ptModeInd->bMode = Z_APMMIA_WCDMA;
                ptModeInd->bSubModeFg = Z_VALID;
                ptModeInd->bSubMode = bSubMode;
            }
            else if (tAct->bLte == Z_VALID)
            {
                ptModeInd->bMode = Z_APMMIA_LTE;
                ptModeInd->bSubModeFg = Z_VALID;
                ptModeInd->bSubMode = bSubMode;
            }
            else
            {
                ptModeInd->bMode = Z_APMMIA_NOSERVE;
                ptModeInd->bSubModeFg = Z_INVALID;
            }
        }
        else
        {
            ptModeInd->bMode = Z_APMMIA_NOSERVE;
            ptModeInd->bSubModeFg = Z_INVALID;
        }

        if(Z_VALID == ptModeInd->bSubModeFg)
        {
            if(ptModeInd->bSubMode == Z_SUBMODE_LTE||ptModeInd->bSubMode == Z_SUBMODE_DPAORUPA)
            {
                ptModeInd->bSubModeFg = Z_INVALID;
            }
            else if(ptModeInd->bSubMode == Z_SUBMODE_HSPA_PLUS)
            {
                ptModeInd->bSubMode = Z_APMMIA_SUBMOD_HSPA_PLUS;
            }
        }
        zAti_RecvServerHandlerSlaver(AP_MMIA_MODE_IND_EV, (PBYTE)ptModeInd, sizeof(T_zApMmia_Mode_Ind));
    }
}

/***************************************************************************
:UMMϢѡظϢע״̬仯С仯
ϱϢ½б
:
pbBuff      Ϣָ
wMsgLen     Ϣ
:
ǰ:
:
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
09.7.8          ΪAT^MODE3GʽϢwtd
***************************************************************************/
DWORD __ps_static_func zAti_PlmnInfo(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    BYTE bSubMode = 0;
    T_zMmiaUmm_PlmnInfo_Ind* ptPlmnInfo = (T_zMmiaUmm_PlmnInfo_Ind*)pBuff;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};

    if (ptPlmnInfo->bCsState == Z_MmiaUmm_PlmnSearchNotAllowed)
    {
        /*
              * ֮ǰUMMϵPlmnInfoCS״̬Ϊ0
              * MMIACSʼ״̬4⵼һβɹȴı
              * ʼ״̬һ״̬6Ǹ״̬MMIAظû
              * Ĵ룬ΪCQNJ00186737޸
              */
        return Z_APMMIA_OPTNOTALW_ERR;
    }

    if((Z_FAIL == zAti_CheckParam(ptPlmnInfo->bCsState, Z_MmiaUmm_AttempUpdate, 0xff)) ||
       (Z_FAIL == zAti_CheckParam(ptPlmnInfo->bPsState, Z_MmiaUmm_RegRoaming, 0xff)) ||
#ifdef PS_RAT_LTE
       (Z_FAIL == zAti_CheckParam(ptPlmnInfo->bEpsState, Z_MmiaUmm_RegRoaming, 0xff)) ||
#endif
       (ptPlmnInfo->tEcNumList.bEmerNumLen > Z_ATIUMM_MAX_EMERNUM_NUM)) 
    {     
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                       
        return Z_APMMIA_NORESULT;
    }

    /* NVȡ */ 
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    /* eccбPB */
    zAti_SaveEccNum(ptPlmnInfo, &tAtData);

    /*жϱ+CREG  +CGREG  +CEREG*/
    zAti_CregCgregCeregIndicat(ptPlmnInfo, &tAtData);
    
    if (1 == tAtData.bSysMode)
    {
        bSubMode = zAti_SelectEffectiveSubact(ptPlmnInfo->tPlmnAct.bGsmSubAct, ptPlmnInfo->tPlmnAct.bTdSubAct,
            ptPlmnInfo->tPlmnAct.bWSubAct, ptPlmnInfo->tPlmnAct.bLteSubAct);
        zAti_ModeIndicat (ptPlmnInfo->bCsState,ptPlmnInfo->bPsState,ptPlmnInfo->bEpsState,ptPlmnInfo->bSrcIndex,ptPlmnInfo->bDesIndex, 
                              &ptPlmnInfo->tPlmnAct.tAct, bSubMode);
    }

     /*жϱ+ZIMSVOPS*/
    zAti_HandleImsVopsInd(ptPlmnInfo, &tAtData);

    zAti_HandleNetEmerBerServ(ptPlmnInfo, &tAtData);

     /* ϱµ״̬ */
     /* 617002489746   bCsSrv bPsSrvϱϢΪ 0xFFʱȫ֡--hyc */
    if(ptPlmnInfo->bCsSrv != 0xFF)
    {
        g_zAti_atDataEx[g_zAti_CurInstance].bCsSrv = ptPlmnInfo->bCsSrv;
    }

    if(ptPlmnInfo->bPsSrv != 0xFF)
    {
        g_zAti_atDataEx[g_zAti_CurInstance].bPsSrv = ptPlmnInfo->bPsSrv;
    }

    zAti_PlmnInfoSetCsState (ptPlmnInfo->bCsState);
    zAti_PlmnInfoSetPsState (ptPlmnInfo->bPsState);         

#ifdef PS_RAT_LTE
    zAti_PlmnInfoSetEpsState (ptPlmnInfo->bEpsState);
#endif

    zAti_PlmnInfoIndUpdateCsPara(ptPlmnInfo);
    zAti_PlmnInfoIndUpdatePsPara(ptPlmnInfo);


#ifdef PS_RAT_LTE
    zAti_PlmnInfoIndUpdateEPara(ptPlmnInfo);
#endif

    zAti_PlmnInfoIndUpdateCurrPara(ptPlmnInfo);

    zAti_MarkRoamStat(ptPlmnInfo);
#ifdef Z_SELL_STAT_SUPPORT
    if(Z_VALID == zAti_IsDualPsDualUicc())
    {
        if (Z_ATI_NET_REG == zAti_GetRegStatus(g_zAti_CurInstance))
        {
            if (Z_SUCC == zAti_SellStat_IsCreatRegTimerNeed(g_zAti_CurInstance))
            {
                zAti_SellStat_DeActiveLastNotRegFg(g_zAti_CurInstance);
                zAti_StartTimerAndGetSumPdpBeginTick(MMIA_SELL_STAT_REG_EXPIRY_EV, g_zAti_CurInstance);
            }
        }
        else
        {
            g_zAti_atDataEx[g_zAti_CurInstance].tSellStat.bLastNotRegFg = Z_ATI_LASTNOTREGFG_VALID;
            zAti_StopTimerAndGetSumPdpEndTick(MMIA_SELL_STAT_REG_EXPIRY_EV, g_zAti_CurInstance);
            zAti_StopTimerAndGetSumPdpEndTick(MMIA_SELL_STAT_SUM_PDP_EXPIRY_EV, g_zAti_CurInstance);
            zAti_StopTimerAndGetSumPdpEndTick(MMIA_SELL_STAT_ONE_PDP_EXPIRY_EV, g_zAti_CurInstance);
        }
    }
    else
    {
        if (Z_ATI_NET_REG == zAti_GetRegStatus(g_zAti_CurInstance))
        {
            if (Z_SUCC == zAti_SellStat_IsCreatRegTimerNeed(Z_ATI_INSNO_1))
            {
                zAti_SellStat_DeActiveLastNotRegFg(Z_ATI_INSNO_1);
                zAti_StartTimerAndGetSumPdpBeginTick(MMIA_SELL_STAT_REG_EXPIRY_EV, Z_ATI_INSNO_1);
            }
        }
        else
        {
            ZOSS_TASK_ID tDestTask = zDev_GetTaskId(Z_ATI_TASKID_UMM, (BYTE)((g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_2: Z_ATI_INSNO_1));
            g_zAti_atDataEx[Z_ATI_INSNO_1].tSellStat.bLastNotRegFg = Z_ATI_LASTNOTREGFG_VALID;
            if(tDestTask == ZOSS_INVALID_TASK_ID   || Z_ATI_NET_NOTREG == zAti_GetRegStatus((BYTE)((g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_2: Z_ATI_INSNO_1)))
            {
                zAti_StopTimerAndGetSumPdpEndTick(MMIA_SELL_STAT_REG_EXPIRY_EV, Z_ATI_INSNO_1);
                zAti_StopTimerAndGetSumPdpEndTick(MMIA_SELL_STAT_SUM_PDP_EXPIRY_EV, Z_ATI_INSNO_1);
                zAti_StopTimerAndGetSumPdpEndTick(MMIA_SELL_STAT_ONE_PDP_EXPIRY_EV, Z_ATI_INSNO_1);
            }
        }
    }
#endif
    return Z_APMMIA_NORESULT;   
}

/***************************************************************************
:UMMϢǰPLMNбתָĸʽϲ
:
pbBuff      Ϣָ
wMsgLen     Ϣ
:
ǰ:
:
***************************************************************************/
DWORD zAti_PlmnList(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaUmm_PlmnList_Cnf* ptPlmnList = (T_zMmiaUmm_PlmnList_Cnf*)pBuff;

    if (ptPlmnList->bNumPlmn > Z_MaxPossiblePlmnNum)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                       
        ptPlmnList->bNumPlmn = 0;
    }

    * pdwChangedMsgId = AP_MMIA_COPS_TEST_CNF_EV;
    if (pChnelNode != NULL && (pChnelNode->cmd_id == ZAT2_MM_ZCOPS))
    {
        *pdwChangedMsgId  = AP_MMIA_ZCOPS_TEST_CNF_EV;
        return Z_APMMIA_NORESULT;
    }
#ifdef PS_RAT_LTE
    if(g_zAti_atDataEx[g_zAti_CurInstance].bIsBgltePlmnTst == Z_VALID)
    {
         *pdwChangedMsgId  = AP_MMIA_LTEBGPLMN_TESTCNF_EV;
    }
#endif
    return Z_APMMIA_NORESULT;
}
VOID zAti_SaveRptTzInfo(T_zMmiaUmm_MmInfo_Ind *pMmInfo)
{
    BYTE beciVal = 0;
    BYTE bTmZone=0;
    BYTE bTempVal=0;
    T_zApMmia_TimeZone_Ind *pTzInd = ZOSS_NULL;

    if (pMmInfo->bLTZoneFg == 1)
    {
        bTmZone = (BYTE)(pMmInfo->bLocalTZone << 4 | pMmInfo->bLocalTZone >> 4);
    }
    else if (pMmInfo->bUTimeFg == 1)
    {
        bTmZone = (BYTE)(pMmInfo->tUTime.bTmZone << 4 | pMmInfo->tUTime.bTmZone >> 4);
    }
    else
    {
        return;
    }

    pTzInd = (T_zApMmia_TimeZone_Ind*)zAti_GetUB(sizeof(T_zApMmia_TimeZone_Ind));

    if (pMmInfo->bSTimeFg == 1&&pMmInfo->bSavTime<=2)
    {
        if (bTmZone & 0x80)
        {
            bTmZone &= 0x7f;
            beciVal = zAti_HexToDecimal(bTmZone);
            if(beciVal > (pMmInfo->bSavTime*4))
            {
                bTempVal = (BYTE)(beciVal - (pMmInfo->bSavTime*4));
                bTmZone = zAti_DcimalToHex(bTempVal);
                bTmZone |= 0x80;
            }
            else
            {
                bTempVal = (BYTE)((pMmInfo->bSavTime*4) - bTmZone);
                bTmZone = zAti_DcimalToHex(bTempVal);
            }
        }
        else
        {
            beciVal = (BYTE)(zAti_HexToDecimal(bTmZone) + (pMmInfo->bSavTime*4));
            bTmZone = zAti_DcimalToHex(beciVal);
        }
    }
    /*ʱΪ0ʱ̶ʾΪ*/
    if((bTmZone & 0x7f)==0)
    {
        bTmZone = 0;
    }

    pTzInd->bDestIndex = pMmInfo->bDesIndex;
    pTzInd->bSrcIndex = pMmInfo->bSrcIndex;
    pTzInd->bTimeZone = bTmZone;

    zAti_RecvServerHandlerSlaver(AP_MMIA_TIMEZONE_IND_EV, (PBYTE)pTzInd, sizeof(T_zApMmia_TimeZone_Ind));  
}
/******************************************************************************
:UMMϢȡǰĳϱ+ZMMI Ϣ
:
pbBuff      Ϣָ
******************************************************************************/
DWORD zAti_Mminfo(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    BYTE bNeedInd1 = Z_INVALID;
    BYTE bNeedInd2 = Z_INVALID;
    T_zMmiaUmm_MmInfo_Ind *pMmInfo = (T_zMmiaUmm_MmInfo_Ind*)pBuff;
    UINT16 iBcd2StrRet = 0;
    CHAR abLongTxtstr[Z_ATIUMM_MAX_TXTSTR_NUM * 8 / 7 + 1];
    CHAR abShortTxtstr[Z_ATIUMM_MAX_TXTSTR_NUM * 8 / 7 + 1];
    zOss_Memset(abLongTxtstr, 0, sizeof(abLongTxtstr));
    zOss_Memset(abShortTxtstr, 0, sizeof(abShortTxtstr));

    if(pMmInfo->bFNameFg)//
    {
        iBcd2StrRet = zAt_GetOperNameData(abLongTxtstr, pMmInfo->tFullName.abTxtStr, pMmInfo->tFullName.bTxtStrLen, pMmInfo->tFullName.bCodeSchm,
                      pMmInfo->tFullName.bNumSpare);

        if(iBcd2StrRet > 0)
        {
            zAti_SaveLongPlmnName(&pMmInfo->tCurPlmnId, abLongTxtstr, &bNeedInd1);//ڲĳ
        }
        /*GSM7BITתASCIIַʾ*/
        if(pMmInfo->tFullName.bCodeSchm == 0)
        {
            pMmInfo->tFullName.bTxtStrLen = (BYTE)iBcd2StrRet;
            if(iBcd2StrRet > 0)
            {
                zOss_Memcpy(pMmInfo->tFullName.abTxtStr,abLongTxtstr,pMmInfo->tFullName.bTxtStrLen);
            }
        }
    }

    if(pMmInfo->bSNameFg)//
    {
        iBcd2StrRet = zAt_GetOperNameData(abShortTxtstr, pMmInfo->tShortName.abTxtStr, pMmInfo->tShortName.bTxtStrLen, pMmInfo->tShortName.bCodeSchm,
             pMmInfo->tShortName.bNumSpare);

        //if(iBcd2StrRet > Z_ATI_SHORTNETNAME_MAX_LEN)//󳤶Ϊ8
        //{
        //    zOss_Memset(abShortTxtstr+Z_ATI_SHORTNETNAME_MAX_LEN,0,(BYTE)(iBcd2StrRet-Z_ATI_SHORTNETNAME_MAX_LEN));
        //}

        if(iBcd2StrRet > 0)
        {
            zAti_SaveShortPlmnName(&pMmInfo->tCurPlmnId, abShortTxtstr, &bNeedInd2);  
        }

        /*GSM7BITתASCIIַʾ*/
        if(pMmInfo->tShortName.bCodeSchm == 0)
        {
            pMmInfo->tShortName.bTxtStrLen = (BYTE)iBcd2StrRet;
            if(iBcd2StrRet > 0)
            {
                zOss_Memcpy(pMmInfo->tShortName.abTxtStr,abShortTxtstr,pMmInfo->tShortName.bTxtStrLen);
            }
        }
    }

    if(g_zAti_ptData->bIsWtNv == Z_VALID)
    {
        BYTE bInterTime = zOss_GetNvDelayWriteTime();
        if(255 == bInterTime)/*д*/
        {
            zDev_NV_AtiRefreshItem(Z_ATI_NV_NetOperPlmnID);
            g_zAti_ptData->bIsWtNv = Z_INVALID;
            g_zAti_ptData->dwLastNvWtTm = 0;
        }
        else if(bInterTime > 0 && bInterTime < 24)/*д*/
        {
            DWORD dwTick = zOss_GetTickCount();
            if(0 == g_zAti_ptData->dwLastNvWtTm)
            {
                zDev_NV_AtiRefreshItem(Z_ATI_NV_NetOperPlmnID);
                g_zAti_ptData->bIsWtNv = Z_INVALID;
                g_zAti_ptData->dwLastNvWtTm = dwTick;
            }
            else
            {
                if(((dwTick > g_zAti_ptData->dwLastNvWtTm)&&((dwTick-g_zAti_ptData->dwLastNvWtTm)>bInterTime*60*60*1000))
                   ||(dwTick <= g_zAti_ptData->dwLastNvWtTm))
                {
                    zDev_NV_AtiRefreshItem(Z_ATI_NV_NetOperPlmnID);
                    g_zAti_ptData->bIsWtNv = Z_INVALID;
                    g_zAti_ptData->dwLastNvWtTm = dwTick;
                }
            }
        }
    }
    /*TZϢĴ洢ϱ*/
    zAti_SaveRptTzInfo(pMmInfo);

    /*µPLMNIDʱ֪ͨUMMи*/
    if(bNeedInd1 == Z_VALID ||bNeedInd2 == Z_VALID)
    {
        zAti_MsgSend(MMIA_UMM_UPDATE_OPERPLMN_IND_EV, ZOSS_NULL, 0, Z_ATI_TASKID_UMM);
    }

    *pdwChangedMsgId = MMIA_UMM_MM_INFO_IND_EV;
    return Z_APMMIA_NORESULT;
}
#ifdef Z_DUALCARD_ADAPT
/**********************************************************************
*:zAti_SelfAdaptRfControl
*:ģʽӦ
**********************************************************************/
DWORD zAti_SelfAdaptFlymodeCnf(VOID)
{
    g_zAti_atDataEx[g_zAti_CurInstance].IsFlymode = TRUE;
    g_zAti_atDataEx[g_zAti_CurInstance].IsNeedOutFlymode = TRUE;

    return Z_APMMIA_NORESULT;
}

DWORD zAti_SelfAdaptOutFlymodeCnf(VOID)
{
    BYTE bAnothInsNo = (g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_2: Z_ATI_INSNO_1;

    /*Ҫȷģʽ(һ
        ģʽ)ϱ+ZPSCFGEND*/
    if(!g_zAti_atDataEx[bAnothInsNo].IsNeedOutFlymode ||
        Z_APMMIA_CFUNFUN_FULLFUN == g_zAti_atDataEx[bAnothInsNo].tFun.bFunVal)
    {
        zAti_IndicatCfgEnd(); /*ϱ+ZPSCFGEND*/
        g_zAti_ptData->IsOutFlymodeIng = FALSE;
        zAti_ClearSelfAdaptGlobVar(Z_ATI_INSNO_1);
        zAti_ClearSelfAdaptGlobVar(Z_ATI_INSNO_2);
        /*ģʽĹbNeedChgFgܻı,
            Ҫ*/
    }

    return Z_APMMIA_NORESULT;
}

/**********************************************************************************
*:zAti_NotifyAsInfoAfterAdpt
*:ɺ֪ͨASصϢ
**********************************************************************************/
VOID zAti_NotifyAsInfoAfterAdpt(VOID)
{
#if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
    BYTE bSrcIndex = (g_zAti_CurInstance == 0) ? ZATI2_CHANNEL_ID_NUM251 : ZATI2_CHANNEL_ID_NUM252;
#else
    BYTE bSrcIndex = ZATI2_CHANNEL_ID_NUM251;
#endif

    if(Z_APMMIA_EM_IND_DISABLE != g_zAti_atDataEx[g_zAti_CurInstance].bCellInfSet)
    {
        zAti_EM_NotifyAs(g_zAti_atDataEx[g_zAti_CurInstance].bCellInfSet, bSrcIndex, 255);
    }

    if(Z_APMMIA_EM_IND_ENABLE == g_zAti_atDataEx[g_zAti_CurInstance].bHoInfoSet)
    {
        zAti_EM_NotfyAsforHoInfo(g_zAti_atDataEx[g_zAti_CurInstance].bHoInfoSet, bSrcIndex, 255);

        if (ZOSS_NULL == g_zAti_atDataEx[g_zAti_CurInstance].ptGrrcHoInd)
        {
            g_zAti_atDataEx[g_zAti_CurInstance].ptGrrcHoInd = (T_zMmiaAs_EM_GHoInfo_Ind*)zAti_GetUB(sizeof(T_zMmiaAs_EM_GHoInfo_Ind));
        }
        if (ZOSS_NULL == g_zAti_atDataEx[g_zAti_CurInstance].ptUrrcHoInd)
        {
            g_zAti_atDataEx[g_zAti_CurInstance].ptUrrcHoInd = (T_zMmiaAs_EM_UHoInfo_Ind*)zAti_GetUB(sizeof(T_zMmiaAs_EM_UHoInfo_Ind));
        }      

        g_zAti_atDataEx[g_zAti_CurInstance].pTimrIdHo   = zSetLoopTimer(5000, MMIA_EM_HO_INFO_EXPIRY_EV, g_zAti_CurInstance);
    }

    if(Z_APMMIA_EM_IND_ENABLE == g_zAti_atDataEx[g_zAti_CurInstance].bZsqrSet)
    {
        T_zApMmia_ZRptRxlev_Req tRxlevReq = {0};
        tRxlevReq.bRange = g_zAti_atDataEx[g_zAti_CurInstance].bRange;
        tRxlevReq.bDesIndex = 255;
        tRxlevReq.bSrcIndex = bSrcIndex;
        zAti_ZRptRxlevProc (&tRxlevReq);
    }
}
#endif
VOID __ps_static_func zAti_EwalkSearchPlmn(T_zMmiaUmm_RFControl_Cnf* ptRfCtrl, T_zDev_AtMem_Mmia_PrivateMem *ptAtData)
{
    T_zAti_NV_CopsMode *ptNvCopsMode = ZOSS_NULL;
    T_zAti_NV_CopsMode tNvCopsMode = {0};
#if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
    BYTE bNvItemId = (g_zAti_CurInstance ? Z_ATI_NV_CopsMode2 : Z_ATI_NV_CopsMode1);
#else
    BYTE bNvItemId = Z_ATI_NV_CopsMode1;
#endif

    ptNvCopsMode = &tNvCopsMode;

    zDev_NV_AtiReadItem(bNvItemId, (PBYTE)ptNvCopsMode);

    if(zAti_IsNeedAutoSearchPlmn(ptNvCopsMode))
    {
        if ( Z_SUCC != zAti_AutoSearchPlmn(ptRfCtrl->bDesIndex, ptRfCtrl->bSrcIndex))
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara, TRACE_ERR_LEVEL_NORMAL, "");//search plmn error
            return;
        }
        
        ptAtData->bCopsMode = Z_APMMIA_COPSMODE_AUTO;

        if(ptNvCopsMode->bCopsMode != ptAtData->bCopsMode)
        {
            ptNvCopsMode->bCopsMode = 0;
            ptNvCopsMode->bOperFg = 0;
            ptNvCopsMode->bNameFg = 0;
            zOss_Memset(ptNvCopsMode->abOperate, 0, Z_MAX_LONGNAME_LEN);
            zOss_Memset(&ptNvCopsMode->tPlmnAct, 0xff, sizeof(T_z_PlmnAct));
            zOss_Memset(&ptNvCopsMode->tPlmnAct.tAct, 0, 1);
            ptNvCopsMode->bCopsMode = ptAtData->bCopsMode;
            zDev_NV_AtiWriteItem(bNvItemId, (PBYTE)ptNvCopsMode);
        }
        zDev_AtMemWriteItem(Z_AtMem_ID_MmiaPrvtMem, 0 ,(PBYTE)ptAtData, g_zAti_CurInstance);
    }
    else if(zAti_IsNeedAutoManuSearchPlmn(ptNvCopsMode))
    {
        if(Z_SUCC != zAti_AutoManuSearchPlmn(ptRfCtrl->bDesIndex, ptRfCtrl->bSrcIndex, ptNvCopsMode))
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara, TRACE_ERR_LEVEL_NORMAL, "");//search plmn error
            return;
        }
        ptAtData->bCopsMode = ptNvCopsMode->bCopsMode;
        zDev_AtMemWriteItem(Z_AtMem_ID_MmiaPrvtMem, 0 ,(PBYTE)ptAtData, g_zAti_CurInstance);
    }
    g_zAti_atDataEx[g_zAti_CurInstance].bSearchPlmnFg = Z_VALID;
    return;
}
#ifdef Z_DUALCARD_ADAPT
VOID zAti_CardSelfAdaptSearchPlmn(T_zMmiaUmm_RFControl_Cnf* ptRfCtrl)
{
    T_zAti_NV_CopsMode *ptNvCopsMode = ZOSS_NULL;
    T_zAti_NV_CopsMode tNvCopsMode = {0};
#if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
    BYTE bNvItemId = (g_zAti_CurInstance ? Z_ATI_NV_CopsMode2 : Z_ATI_NV_CopsMode1);
#else
    BYTE bNvItemId = Z_ATI_NV_CopsMode1;
#endif

    ptNvCopsMode = &tNvCopsMode;

    zDev_NV_AtiReadItem(bNvItemId, (PBYTE)ptNvCopsMode);

    if(Z_VALID == g_zAti_atDataEx[g_zAti_CurInstance].bSearchPlmnFg)
    {
        if(ptNvCopsMode->bCopsMode == Z_APMMIA_COPSMODE_AUTO)
        {
            if ( Z_SUCC != zAti_AutoSearchPlmn(ptRfCtrl->bDesIndex, ptRfCtrl->bSrcIndex))
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara, TRACE_ERR_LEVEL_NORMAL, "");//search plmn error
                return;
            }
        }
        else //ֶ
        {
            if(Z_SUCC != zAti_AutoManuSearchPlmn(ptRfCtrl->bDesIndex, ptRfCtrl->bSrcIndex, ptNvCopsMode))
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara, TRACE_ERR_LEVEL_NORMAL, "");//search plmn error
                return;
            }
        }
    }
}
#endif
VOID __ps_static_func zAti_InitPdpAtmem(T_zAti_NV_CidPdpContext* ptCont, T_zDev_AtMem_SmCidData * ptSmData)
{
    ptSmData->bPdpInfoFg = Z_DEV_AtMem_PDP_Define;
    ptSmData->bContFlag  = Z_DEV_AtMem_CONTXT_First;
    ptSmData->tPdpContext.bPdpType  = ptCont->bPdpType;            
    ptSmData->tPdpContext.bDComp    = ptCont->bDComp;            
    ptSmData->tPdpContext.bHComp    = ptCont->bHComp;
    ptSmData->tPdpContext.bIPv4AddrAlloc = ptCont->bIPv4AddrAlloc;
    ptSmData->tPdpContext.bEmergencyInd = ptCont->bEmergencyInd;
    ptSmData->tPdpContext.bPCscfDisc = ptCont->bPCscfDisc;
    ptSmData->tPdpContext.bImcnSignInd = ptCont->bImcnSignInd;
    zOss_Memset(ptSmData->tPdpContext.abApn, 0, Z_DEV_AtMem_MAX_APN_LEN);
    zOss_Memcpy(ptSmData->tPdpContext.abApn, ptCont->abApn, Z_DEV_AtMem_MAX_APN_LEN-1);/*abApnҪԿսβֵֻһ*/

    zOss_Memcpy(ptSmData->tPdpContext.abPdpAddr, ptCont->abPdpAddr, Z_DEV_AtMem_MAX_PDPADDR_LEN);

    ptSmData->bPcoAuthFg = ptCont->bPcoAuthFg;
    ptSmData->tPcoAuth.bAuthType = ptCont->bAuthType;

    ptSmData->tPcoAuth.tPapChapInfo.bUserNameLen = ptCont->bUserNameLen;
    if (ptCont->bUserNameLen > Z_DEV_AtMem_MAX_STR_LEN)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        ptSmData->tPcoAuth.tPapChapInfo.bUserNameLen = Z_DEV_AtMem_MAX_STR_LEN;
        ptCont->bUserNameLen = Z_DEV_AtMem_MAX_STR_LEN;
    }
    zOss_Memset(ptSmData->tPcoAuth.tPapChapInfo.abUserName, 0, Z_DEV_AtMem_MAX_STR_LEN+1);
    if(ptCont->bUserNameLen > 0)
    {
        zOss_Memcpy(ptSmData->tPcoAuth.tPapChapInfo.abUserName, (char*)ptCont->abUserName, ptCont->bUserNameLen);
    }

    ptSmData->tPcoAuth.tPapChapInfo.bPassWordLen = ptCont->bPassWordLen;
    if (ptCont->bPassWordLen > Z_DEV_AtMem_MAX_STR_LEN)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        ptSmData->tPcoAuth.tPapChapInfo.bPassWordLen = Z_DEV_AtMem_MAX_STR_LEN;
        ptCont->bPassWordLen = Z_DEV_AtMem_MAX_STR_LEN;
    }
    zOss_Memset(ptSmData->tPcoAuth.tPapChapInfo.abPassWord, 0, Z_DEV_AtMem_MAX_STR_LEN+1);
    if(ptCont->bPassWordLen > 0)
    {
        zOss_Memcpy(ptSmData->tPcoAuth.tPapChapInfo.abPassWord, (char*)ptCont->abPassWord, ptCont->bPassWordLen);
        zDev_PcoAuthCipher(ptSmData->tPcoAuth.tPapChapInfo.abPassWord, ptSmData->tPcoAuth.tPapChapInfo.bPassWordLen);
    }
}

VOID __ps_static_func zAti_AtMem_PdpContextInit(VOID)
{
    BYTE i = 0;
    T_zAti_NV_PdpCont *ptNvPdpCont = ZOSS_NULL;
    T_zDev_AtMem_SmCidData *ptSmData = ZOSS_NULL;
    BYTE bNvItemId = (g_zAti_CurInstance ? Z_ATI_NV_CidPdpContext2 : Z_ATI_NV_CidPdpContext1);

    ptNvPdpCont = (T_zAti_NV_PdpCont*)zAti_GetUB(sizeof(T_zAti_NV_PdpCont));
    ptSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));

    zDev_NV_AtiReadItem(bNvItemId, (PBYTE)ptNvPdpCont);

    /*ATMEMĳʼ*/
    
    for(i = 0; i < Z_DEV_AtMem_MAX_CID_NUM; i++)
    {
        zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, i+1 ,(PBYTE)ptSmData, g_zAti_CurInstance);

        /*NVж˾NVеĸֵNVûжCIDATMEMе
        CIDûбΪ2ʱPDPͼȨ*/
        if(ptNvPdpCont->tCidPdpCont[i].bCid == (i+1))
        {
            zAti_InitPdpAtmem(&ptNvPdpCont->tCidPdpCont[i], ptSmData);
        }
        else if ((ptSmData->bPdpInfoFg != Z_ATI_PDP_Define) || (ptSmData->bContFlag != Z_ATI_CONTXT_Secnd))
        {
            /*PDP*/
            ptSmData->bPdpInfoFg = Z_ATI_PDP_NotDefine;
            zOss_Memset(&ptSmData->tPdpContext, 0, sizeof(T_zDev_AtMem_SmPdpContext));
            /*APNȨ*/
            ptSmData->bPcoAuthFg = Z_ATI_PDP_NotDefine;
            zOss_Memset(&ptSmData->tPcoAuth, 0, sizeof(T_zDev_AtMem_SmPcoAuthContext));
        }

        zDev_AtMemWriteItem(Z_AtMem_ID_SmCidData, i+1, (PBYTE)ptSmData, g_zAti_CurInstance);
    }
    zAti_RetUB((VOID**)&ptNvPdpCont);
    zAti_RetUB((VOID**)&ptSmData);
}

VOID zAti_RemovePdpCont(BYTE bCid)
{
    T_zDev_AtMem_SmCidData *ptSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));
    zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, bCid, (PBYTE)ptSmData, g_zAti_CurInstance);
    zOss_Memset(ptSmData, 0, sizeof(T_zDev_AtMem_SmCidData));
    zDev_AtMemWriteItem(Z_AtMem_ID_SmCidData, bCid, (PBYTE)ptSmData, g_zAti_CurInstance);
    zAti_RetUB((VOID**)&ptSmData);
    
    //ͬʱNVжӦɾ
    zAt_SmUndefineNvPdpCont(bCid);
    return ;
}
/***************************************************************************
:UMMϢ/ƵĽϲ
:
pbBuff      Ϣָ
wMsgLen     Ϣ
:
ǰ:
:
lxh cregȲڿƵɹʱãatmemдʼ
ֱ֮·Eжϡ
ػģʽϱCREGCGREGCEREGMODE
***************************************************************************/
DWORD __ps_static_func zAti_RfControl(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zDev_AtMem_Mmia_PrivateMem tAtData  = {0};
    T_zMmiaUmm_RFControl_Cnf*     ptRfCtrl  = (T_zMmiaUmm_RFControl_Cnf*)pBuff;
    T_zMmiaUmm_PlmnInfo_Ind       tPlmnInfo = {0};
    BYTE bAutoStartState = Z_ATI_AUTOSTART_INIT;
    BYTE bOldFunVal = g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunVal;
    BYTE bCcoCount = g_zAti_atDataEx[g_zAti_CurInstance].bCcoCount;
    BYTE bTraceCellInfSet = g_zAti_atDataEx[g_zAti_CurInstance].bTraceCellInfSet;
    BYTE bCellInfSet = g_zAti_atDataEx[g_zAti_CurInstance].bCellInfSet;
    BYTE bHoInfoSet = g_zAti_atDataEx[g_zAti_CurInstance].bHoInfoSet;
    BYTE bZsqrSet = g_zAti_atDataEx[g_zAti_CurInstance].bZsqrSet;
    BYTE bRange = g_zAti_atDataEx[g_zAti_CurInstance].bRange;
    BYTE bDelCid = 0;
    PBYTE ptSmContent = ZOSS_NULL;

    bAutoStartState = zAti_GetAutoStartState ();
    if (bAutoStartState == Z_ATI_AUTOSTART_WAITRFON)
    {
        zAti_SetAutoStartState (Z_ATI_AUTOSTART_CARDOK);
    }

    if((g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunVal == Z_APMMIA_CFUNFUN_MINIFUN
        || g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunVal == Z_APMMIA_CFUNFUN_DISBOTHRF)
        &&g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunBak == Z_APMMIA_CFUNFUN_FULLFUN)
    {
        // ػٿSM  ȫϢ
        ptSmContent = (PBYTE)&g_zAti_SmContext[g_zAti_CurInstance];
        zOss_Memset(ptSmContent, 0, sizeof(T_ZAti_SmContext));/*zpr20100506*/      
    }
    if(g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunVal == Z_APMMIA_CFUNFUN_MINIFUN
        &&g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunBak == Z_APMMIA_CFUNFUN_FULLFUN)
    {
        // ػٿNVжPDP
        zAti_AtMem_PdpContextInit();
    }
    if (Z_FAIL == ptRfCtrl->bResult)                     /* ʧ */
    {
        g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunBak = Z_ATI_INVALID_BYTE;
        return Z_APMMIA_UNKNOWN_ERR;
    }
    else                                                   /* ɹ */
    {
        g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunVal = g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunBak;
        g_zAti_atDataEx[g_zAti_CurInstance].tFun.bRfVal = g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunBak;
        g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunBak = Z_ATI_INVALID_BYTE;

        zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

        if (Z_APMMIA_CFUNFUN_FULLFUN == g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunVal)
        {
            /*2016.4.27޸ļȺ󣬿Ƶɹⲿ*/
            //#ifdef BTRUNK_SUPPORT
            //zDrvGpio_SetGpio111High();
            //#endif
            //617001821725 lxh 12.11.01 CFUN617001883484ATIصģʽ
#ifdef Z_DUALCARD_ADAPT
            if(zAti_IsCardSelfAdaptCnf(ptRfCtrl->bDesIndex))
            {
                zAti_CardSelfAdaptSearchPlmn(ptRfCtrl);
            }
            else
#endif
            {
                if (bAutoStartState == Z_ATI_AUTOSTART_WAITRFON 
                    ||(Z_INVALID == zDev_GetCfunFlag()&& bOldFunVal != Z_APMMIA_CFUNFUN_FULLFUN))
                {
                    zAti_EwalkSearchPlmn(ptRfCtrl, &tAtData);
                }
            }
            if (bTraceCellInfSet != Z_APMMIA_EM_IND_DISABLE)
            {
                /*ˣõĶʱʱ*/
                bTraceCellInfSet = (bCellInfSet == Z_APMMIA_EM_IND_DISABLE)? bTraceCellInfSet : bCellInfSet;
                zAti_EM_NotifyAs(bTraceCellInfSet, ptRfCtrl->bDesIndex, ptRfCtrl->bSrcIndex);
            }
            if(bCcoCount == Z_APMMIA_EM_IND_ENABLE)
            {
                zAti_EM_NotfyAsforCco(bCcoCount);
            }
#ifdef Z_DUALCARD_ADAPT
            if(zAti_IsCardSelfAdaptCnf(ptRfCtrl->bDesIndex))
            {
                zAti_NotifyAsInfoAfterAdpt();
                return zAti_SelfAdaptOutFlymodeCnf();
            }
#endif
        }
        else  //if (Z_APMMIA_CFUNFUN_DISBOTHRF  || Z_APMMIA_CFUNFUN_MINIFUN )            
        {
            tPlmnInfo.bSrcIndex = ptRfCtrl->bSrcIndex;
            tPlmnInfo.bDesIndex = ptRfCtrl->bDesIndex;
            tPlmnInfo.bCsState  = Z_APMMIA_REGSTATE_NOREGNOSEARCH;
            tPlmnInfo.bPsState  = Z_APMMIA_REGSTATE_NOREGNOSEARCH;
            tPlmnInfo.bEpsState = Z_APMMIA_REGSTATE_NOREGNOSEARCH;

            zAti_CregCgregCeregIndicat(&tPlmnInfo, &tAtData);

            zAti_ModeIndicat (tPlmnInfo.bCsState,tPlmnInfo.bPsState,tPlmnInfo.bEpsState, tPlmnInfo.bSrcIndex,tPlmnInfo.bDesIndex, 
                                  &tPlmnInfo.tPlmnAct.tAct, Z_ATI_INVALID_BYTE);
    
            zAti_InitZgdatatestGlobalVar();

            zAti_InitCsGlobalVar();
#ifdef Z_SELL_STAT_SUPPORT
            zAti_InitSellStatGlobalVar();
#endif
            zAti_InitEmInfoByInstNo(g_zAti_CurInstance);
            if (Z_APMMIA_CFUNFUN_DISBOTHRF == g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunVal)
            {
                zAti_InFlyModeInitGlobalVarByInstNo(g_zAti_CurInstance);/*617001898360ģʽATIȻϱhiϢ*/
            }
            if (Z_APMMIA_CFUNFUN_MINIFUN == g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunVal)
            {
#if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
                if(Z_APMMIA_CFUNFUN_MINIFUN ==  g_zAti_atDataEx[(g_zAti_CurInstance)? 0:1].tFun.bFunVal)
                {
                     zAti_InitComGlobalVar();//ȫֱ
                }
#endif
                if((g_zAti_ptData->bIsWtNv == Z_VALID)&&(255 != zOss_GetNvDelayWriteTime()))
                {
                    zDev_NV_AtiRefreshItem(Z_ATI_NV_NetOperPlmnID);
                }
                zAti_RetUbCardPlmnInfo();
                zAti_MiniFunModeInitGlobalVarByInstNo(g_zAti_CurInstance);

                g_zAti_atDataEx[g_zAti_CurInstance].bCcoCount = bCcoCount;
                g_zAti_atDataEx[g_zAti_CurInstance].bTraceCellInfSet = bTraceCellInfSet;
                /*༤·أǰοcidNV´οMTʱѡcidʧܡ
                ǰͨػǰcgdelɾcidġ
                ޸ΪMTNET_TEST , CFUN=0ػ,CID2-CID8ĶȫɾCID1*/
                /*EC 616000531323 MTNET_TEST , CFUN=0ػ,CID2-CID8ĶȫɾCID1*/
                if (Z_VALID == zDev_IsMtNet())
                {
                    //CID2-CID8Ķȫɾ
                    for (bDelCid = 2;bDelCid <= Z_DEV_AtMem_MAX_CID_NUM; bDelCid++)
                    {
                        if(zOss_GetAttachCid() != bDelCid)//attach CIDɾ
                        {
                            zAti_RemovePdpCont(bDelCid);
                        }
                    }
                }
            }
            Nvram_Flush();/*6170018539725SдNVʱΪЧ*/
            
            /*2016.4.27޸ļȺ󣬽ģʽ͹ػرⲿ*/
            //#ifdef BTRUNK_SUPPORT
            //zDrvGpio_SetGpio111Low();
            //#endif
            #ifdef Z_DUALCARD_ADAPT
            if(zAti_IsCardSelfAdaptCnf(ptRfCtrl->bDesIndex))
            {
                g_zAti_atDataEx[g_zAti_CurInstance].bCellInfSet = bCellInfSet;
                g_zAti_atDataEx[g_zAti_CurInstance].bHoInfoSet = bHoInfoSet;
                g_zAti_atDataEx[g_zAti_CurInstance].bZsqrSet = bZsqrSet;
                g_zAti_atDataEx[g_zAti_CurInstance].bRange = bRange;
                return zAti_SelfAdaptFlymodeCnf();
            }
            #endif
        }

        return Z_APMMIA_NOERROR_ERR; // ظOK,޸
    }

}

VOID __ps_4g_func zAti_CregIndicatCurrRegStat(T_zMmiaUmm_SearchPlmn_Cnf *ptSearchPlmnCnf)
{
    T_zApMmia_Creg_Ind* ptCregInd = (T_zApMmia_Creg_Ind*)zAti_GetUB(sizeof(T_zApMmia_Creg_Ind));
    /* дϢ */
    ptCregInd->bSrcIndex = ptSearchPlmnCnf->bSrcIndex;
    ptCregInd->bDesIndex = ptSearchPlmnCnf->bDesIndex;
    ptCregInd->bStat     = g_zAti_atDataEx[g_zAti_CurInstance].bCsState;

    zAti_RecvServerHandlerSlaver(AP_MMIA_CREG_IND_EV, (UINT8 *)ptCregInd, sizeof(T_zApMmia_Creg_Ind));
}

VOID zAti_CregIndicatCurrCellIdRegStat(T_zMmiaUmm_SearchPlmn_Cnf *ptSearchPlmnCnf)
{
    BYTE bSubAct = 0;
    T_zApMmia_Creg_Ind* ptCregInd = (T_zApMmia_Creg_Ind*)zAti_GetUB(sizeof(T_zApMmia_Creg_Ind));
    /* дϢ */  
    ptCregInd->bSrcIndex = ptSearchPlmnCnf->bSrcIndex;
    ptCregInd->bDesIndex = ptSearchPlmnCnf->bDesIndex;
    ptCregInd->bStat     = g_zAti_atDataEx[g_zAti_CurInstance].bCsState;
    ptCregInd->bCiFg     = Z_APMMIA_VALID;
    ptCregInd->bLacFg    = Z_APMMIA_VALID;
    ptCregInd->bActFg    = Z_APMMIA_VALID;
    
    zOss_Memcpy(ptCregInd->abLac, g_zAti_atDataEx[g_zAti_CurInstance].tCsPlmnPara.abLac, sizeof(WORD));

    zOss_Memcpy(ptCregInd->abCi, g_zAti_atDataEx[g_zAti_CurInstance].tCsPlmnPara.abCi, sizeof(DWORD));/* дci */

    bSubAct = zAti_GetSubActAccord2SubMode(g_zAti_atDataEx[g_zAti_CurInstance].tCsPlmnPara.bSubMode);
    if (bSubAct == Z_ATI_INVALID_BYTE)
    {
        ptCregInd->bAct = g_zAti_atDataEx[g_zAti_CurInstance].tCsPlmnPara.bAct;
    }
    else
    {
        ptCregInd->bAct = bSubAct;
    }
    /**WTD**/
    if (g_zAti_atDataEx[g_zAti_CurInstance].tCsPlmnPara.tAct.bW == Z_VALID)
    {
        ptCregInd->bSubActFg = Z_VALID;
        ptCregInd->bSubAct = FDD_SUBACT;
    }

    if (g_zAti_atDataEx[g_zAti_CurInstance].tCsPlmnPara.tAct.bTD == Z_VALID)
    {
        ptCregInd->bSubActFg = Z_VALID;
        ptCregInd->bSubAct = TDD_SUBACT;
    }

    if(g_zAti_atDataEx[g_zAti_CurInstance].tCsPlmnPara.tAct.bLte == Z_VALID)
    {
        if(g_zAti_atDataEx[g_zAti_CurInstance].tCsPlmnPara.bSubMode == Z_SUBMODE_LTE_TDD)
        {
            ptCregInd->bSubActFg = Z_VALID;
            ptCregInd->bSubAct = TDD_SUBACT;
        }
        else if(g_zAti_atDataEx[g_zAti_CurInstance].tCsPlmnPara.bSubMode == Z_SUBMODE_LTE_FDD)
        {
            ptCregInd->bSubActFg = Z_VALID;
            ptCregInd->bSubAct = FDD_SUBACT;
        }
    }
    zAti_RecvServerHandlerSlaver(AP_MMIA_CREG_IND_EV, (UINT8 *)ptCregInd, sizeof(T_zApMmia_Creg_Ind));
}

VOID __ps_4g_func zAti_CregIndicatCurrStat(T_zMmiaUmm_SearchPlmn_Cnf *ptSearchPlmnCnf, T_zDev_AtMem_Mmia_PrivateMem* ptAtData )
{ 
    switch (ptAtData->bCregSet)
    {
    case Z_APMMIA_IND_DISABLE:                        /* رCREGϱ */
        break;
        
    case Z_APMMIA_REGSTAT_ENABLE:
        /* ע̬015ʱϱ*/
        if (Z_APMMIA_REGSTATE_REGHPLMN == g_zAti_atDataEx[g_zAti_CurInstance].bCsState ||
            Z_APMMIA_REGSTATE_REGROAMING == g_zAti_atDataEx[g_zAti_CurInstance].bCsState ||
            Z_APMMIA_REGSTATE_NOREGNOSEARCH == g_zAti_atDataEx[g_zAti_CurInstance].bCsState)
        {
            zAti_CregIndicatCurrRegStat(ptSearchPlmnCnf);
        }
        break;

    case Z_APMMIA_CELLID_ENABLE:
        /* ע̬015ʱϱ*/
        if (Z_APMMIA_REGSTATE_REGHPLMN == g_zAti_atDataEx[g_zAti_CurInstance].bCsState ||
            Z_APMMIA_REGSTATE_REGROAMING == g_zAti_atDataEx[g_zAti_CurInstance].bCsState)
        {
            zAti_CregIndicatCurrCellIdRegStat(ptSearchPlmnCnf);//ϱע״̬СϢ
        }
        else if (Z_APMMIA_REGSTATE_NOREGNOSEARCH == g_zAti_atDataEx[g_zAti_CurInstance].bCsState)
        {
            zAti_CregIndicatCurrRegStat(ptSearchPlmnCnf);//ֻϱע״̬
        }        
        break;
        
    default:
        zAti_SendExpt2TraceAgt(ERR_InvalidPara, TRACE_ERR_LEVEL_NORMAL,"");
        break;
    }
}

VOID zAti_CgregIndicatCurrRegStat(T_zMmiaUmm_SearchPlmn_Cnf *ptSearchPlmnCnf)
{
    T_zApMmia_Cgreg_Ind *ptCgregInd = (T_zApMmia_Cgreg_Ind*)zAti_GetUB(sizeof(T_zApMmia_Cgreg_Ind));
    /* дϢ */
    ptCgregInd->bSrcIndex = ptSearchPlmnCnf->bSrcIndex;
    ptCgregInd->bDesIndex = ptSearchPlmnCnf->bDesIndex;
    ptCgregInd->bStat     = g_zAti_atDataEx[g_zAti_CurInstance].bPsState;

    /* Ϣ */
    zAti_RecvServerHandlerSlaver(AP_MMIA_CGREG_IND_EV, (UINT8 *)ptCgregInd, sizeof(T_zApMmia_Cgreg_Ind));
}

VOID zAti_CgregIndicatCurrCellIdRegStat(T_zMmiaUmm_SearchPlmn_Cnf *ptSearchPlmnCnf)
{
    BYTE bSubAct = Z_ATI_INVALID_BYTE;
    T_zApMmia_Cgreg_Ind *ptCgregInd = (T_zApMmia_Cgreg_Ind*)zAti_GetUB(sizeof(T_zApMmia_Cgreg_Ind));

    /* дϢ */  
    ptCgregInd->bSrcIndex = ptSearchPlmnCnf->bSrcIndex;
    ptCgregInd->bDesIndex = ptSearchPlmnCnf->bDesIndex;
    ptCgregInd->bStat = g_zAti_atDataEx[g_zAti_CurInstance].bPsState;
    ptCgregInd->bCiFg     = Z_APMMIA_VALID;
    ptCgregInd->bLacFg    = Z_APMMIA_VALID;

    zOss_Memcpy(ptCgregInd->abLac, g_zAti_atDataEx[g_zAti_CurInstance].tPsPlmnPara.abLac, sizeof(WORD));

    zOss_Memcpy(ptCgregInd->abCi, g_zAti_atDataEx[g_zAti_CurInstance].tPsPlmnPara.abCi, sizeof(DWORD));/* дci */

    ptCgregInd->bActFg    = Z_APMMIA_VALID;
    ptCgregInd->bRacFg    = Z_APMMIA_VALID;
    ptCgregInd->bRac      = g_zAti_atDataEx[g_zAti_CurInstance].tPsPlmnPara.bRac;

    bSubAct = zAti_GetSubActAccord2SubMode(g_zAti_atDataEx[g_zAti_CurInstance].tPsPlmnPara.bSubMode);
    if (bSubAct == Z_ATI_INVALID_BYTE)
    {
        ptCgregInd->bAct = g_zAti_atDataEx[g_zAti_CurInstance].tPsPlmnPara.bAct;
    }
    else
    {
        ptCgregInd->bAct = bSubAct;
    }

    /**WTD**/
    if (g_zAti_atDataEx[g_zAti_CurInstance].tPsPlmnPara.tAct.bW == Z_VALID)
    {
        ptCgregInd->bSubActFg = Z_VALID;
        ptCgregInd->bSubAct = FDD_SUBACT;
    }
    if (g_zAti_atDataEx[g_zAti_CurInstance].tPsPlmnPara.tAct.bTD == Z_VALID)
    {
        ptCgregInd->bSubActFg = Z_VALID;
        ptCgregInd->bSubAct = TDD_SUBACT;
    }
    if(g_zAti_atDataEx[g_zAti_CurInstance].tPsPlmnPara.tAct.bLte == Z_VALID)
    {
        if(g_zAti_atDataEx[g_zAti_CurInstance].tPsPlmnPara.bSubMode == Z_SUBMODE_LTE_TDD)
        {
            ptCgregInd->bSubActFg = Z_VALID;
            ptCgregInd->bSubAct = TDD_SUBACT;
        }
        else if(g_zAti_atDataEx[g_zAti_CurInstance].tPsPlmnPara.bSubMode == Z_SUBMODE_LTE_FDD)
        {
            ptCgregInd->bSubActFg = Z_VALID;
            ptCgregInd->bSubAct = FDD_SUBACT;
        }
    }
    zAti_RecvServerHandlerSlaver(AP_MMIA_CGREG_IND_EV, (UINT8 *)ptCgregInd, sizeof(T_zApMmia_Cgreg_Ind)); 
}

VOID zAti_CgregIndicatCurrStat(T_zMmiaUmm_SearchPlmn_Cnf *ptSearchPlmnCnf, T_zDev_AtMem_Mmia_PrivateMem* ptAtData)
{    
      /* жǷԼ+CGREGϱ */
    switch (ptAtData->bCgregSet)
    {
    case Z_APMMIA_IND_DISABLE:                        /* رCREGϱ */
        break;
        
    case Z_APMMIA_REGSTAT_ENABLE:
        /* ע̬015ʱϱ*/
        if ((Z_APMMIA_REGSTATE_REGHPLMN == g_zAti_atDataEx[g_zAti_CurInstance].bPsState) || 
            (Z_APMMIA_REGSTATE_REGROAMING == g_zAti_atDataEx[g_zAti_CurInstance].bPsState) ||
            (Z_APMMIA_REGSTATE_NOREGNOSEARCH == g_zAti_atDataEx[g_zAti_CurInstance].bPsState))
        {
            zAti_CgregIndicatCurrRegStat(ptSearchPlmnCnf);
        }
        break;
        
    case Z_APMMIA_CELLID_ENABLE:                 /* ҪϱС仯 */                           
        /* ע̬015ʱϱ*/
        if ((Z_APMMIA_REGSTATE_REGHPLMN == g_zAti_atDataEx[g_zAti_CurInstance].bPsState) 
            || (Z_APMMIA_REGSTATE_REGROAMING == g_zAti_atDataEx[g_zAti_CurInstance].bPsState))
        {
            zAti_CgregIndicatCurrCellIdRegStat(ptSearchPlmnCnf);//ϱע״̬СϢ
        }
        else if (Z_APMMIA_REGSTATE_NOREGNOSEARCH == g_zAti_atDataEx[g_zAti_CurInstance].bPsState)
        {
            zAti_CgregIndicatCurrRegStat(ptSearchPlmnCnf);//ֻϱע״̬
        }        
        break;
        
    default:
        zAti_SendExpt2TraceAgt(ERR_InvalidPara, TRACE_ERR_LEVEL_NORMAL,"");
        break;
    }
}

#ifdef PS_RAT_LTE
VOID zAti_CeregIndicatCurrRegStat(T_zMmiaUmm_SearchPlmn_Cnf *ptSearchPlmnCnf)
{
    T_zApMmia_Cereg_Ind* ptCeregInd = (T_zApMmia_Cereg_Ind*)zAti_GetUB(sizeof(T_zApMmia_Cereg_Ind));
    
    ptCeregInd->bSrcIndex = ptSearchPlmnCnf->bSrcIndex;
    ptCeregInd->bDesIndex = ptSearchPlmnCnf->bDesIndex;
    ptCeregInd->bStat     = g_zAti_atDataEx[g_zAti_CurInstance].bEpsState;

    zAti_RecvServerHandlerSlaver(AP_MMIA_CEREG_IND_EV, (PBYTE)ptCeregInd, sizeof(T_zApMmia_Cereg_Ind));  
}

VOID zAti_CeregIndicatCurrCellIdRegStat(T_zMmiaUmm_SearchPlmn_Cnf *ptSearchPlmnCnf)
{
    BYTE bSubAct = 0;
    T_zApMmia_Cereg_Ind* ptCeregInd = (T_zApMmia_Cereg_Ind*)zAti_GetUB(sizeof(T_zApMmia_Cereg_Ind));
    
    ptCeregInd->bSrcIndex = ptSearchPlmnCnf->bSrcIndex;
    ptCeregInd->bDesIndex = ptSearchPlmnCnf->bDesIndex;
    ptCeregInd->bStat     = g_zAti_atDataEx[g_zAti_CurInstance].bEpsState;
    ptCeregInd->bCiFg     = Z_APMMIA_VALID;
    ptCeregInd->bLacFg    = Z_APMMIA_VALID;
    ptCeregInd->bActFg    = Z_APMMIA_VALID;
    ptCeregInd->bRacFg    = Z_APMMIA_VALID;
    ptCeregInd->bRac      = g_zAti_atDataEx[g_zAti_CurInstance].tEPlmnPara.bRac;

    zOss_Memcpy(ptCeregInd->abLac, g_zAti_atDataEx[g_zAti_CurInstance].tEPlmnPara.abTac, sizeof(WORD));/* ñĸдlac */
    
    zOss_Memcpy(ptCeregInd->abCi, g_zAti_atDataEx[g_zAti_CurInstance].tEPlmnPara.abCi, sizeof(DWORD));/* дci */    

    bSubAct = zAti_GetSubActAccord2SubMode(g_zAti_atDataEx[g_zAti_CurInstance].tEPlmnPara.bSubMode);
    if (bSubAct == Z_ATI_INVALID_BYTE)
    {
        ptCeregInd->bAct = g_zAti_atDataEx[g_zAti_CurInstance].tEPlmnPara.bAct;
    }
    else
    {
        ptCeregInd->bAct = bSubAct;
    }
    /**TDDFDD**/
    zAti_GetLteSubActAccord2SubMode(&ptCeregInd->bSubAct,&ptCeregInd->bSubActFg, bSubAct);

    zAti_RecvServerHandlerSlaver(AP_MMIA_CEREG_IND_EV, (PBYTE)ptCeregInd, sizeof(T_zApMmia_Cereg_Ind)); 
}

static VOID __ps_4g_func zAti_CeregIndicatCurrStat(T_zMmiaUmm_SearchPlmn_Cnf *ptSearchPlmnCnf,
                                  T_zDev_AtMem_Mmia_PrivateMem* ptAtData)
{
    switch (ptAtData->bCeregSet)
    {
        case Z_APMMIA_IND_DISABLE: 
            break;
        case Z_APMMIA_REGSTAT_ENABLE:

            if ((Z_APMMIA_REGSTATE_REGHPLMN == g_zAti_atDataEx[g_zAti_CurInstance].bEpsState) ||
                (Z_APMMIA_REGSTATE_REGROAMING == g_zAti_atDataEx[g_zAti_CurInstance].bEpsState) ||
                (Z_APMMIA_REGSTATE_NOREGNOSEARCH == g_zAti_atDataEx[g_zAti_CurInstance].bEpsState))
            {
                zAti_CeregIndicatCurrRegStat(ptSearchPlmnCnf);
            }

            break;
        case Z_APMMIA_CELLID_ENABLE:
            if ((Z_APMMIA_REGSTATE_REGHPLMN == g_zAti_atDataEx[g_zAti_CurInstance].bEpsState) ||
                (Z_APMMIA_REGSTATE_REGROAMING == g_zAti_atDataEx[g_zAti_CurInstance].bEpsState))
            {
                zAti_CeregIndicatCurrCellIdRegStat(ptSearchPlmnCnf);
            }
            else if (Z_APMMIA_REGSTATE_NOREGNOSEARCH == g_zAti_atDataEx[g_zAti_CurInstance].bEpsState)
            {
                zAti_CeregIndicatCurrRegStat(ptSearchPlmnCnf);//ֻϱע״̬
            }            
            break;
        default:
            break;
    }
}
#endif

/***************************************************************************
: zAti_UmmSearchPlmnCnf
:UMMϢյӦ+CREG
ϱ
:
pbBuff      Ϣָ
:
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
23м̬涼µ״̬ϱ4״̬Ƕʧǡ 
״̬ϱAPAPҲûа취ҵ
0,1,5״̬0ԷС 1,5Էҵϱ
APҵǺʵġ                                                              
***************************************************************************/
DWORD __ps_static_func zAti_UmmSearchPlmnCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaUmm_SearchPlmn_Cnf *ptSearchPlmnCnf = (T_zMmiaUmm_SearchPlmn_Cnf *)pBuff;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    if(Z_GSM_ACT == zAti_GetByteAct(&g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.tAct))
    {
        zAti_CregIndicatCurrStat(ptSearchPlmnCnf, &tAtData);
        zAti_CgregIndicatCurrStat(ptSearchPlmnCnf, &tAtData);
    }
    else if(Z_LTE_ACT == zAti_GetByteAct(&g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.tAct))
    {
        #ifdef PS_RAT_LTE
        zAti_CeregIndicatCurrStat(ptSearchPlmnCnf, &tAtData);
        #endif
        if(zAti_IsSingleCardForOneStandby() || Z_VALID == zAti_IsDualPsDualUicc()) //˫˫
        {
            zAti_CregIndicatCurrStat(ptSearchPlmnCnf, &tAtData);
        }
    }
    else if(Z_W_ACT == zAti_GetByteAct(&g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.tAct)||
               Z_TD_ACT == zAti_GetByteAct(&g_zAti_atDataEx[g_zAti_CurInstance].tCurrPlmnPara.tAct))
    {
        zAti_CgregIndicatCurrStat(ptSearchPlmnCnf, &tAtData);
        if(zAti_IsSingleCardForOneStandby() || Z_VALID == zAti_IsDualPsDualUicc()) //
        {
            zAti_CregIndicatCurrStat(ptSearchPlmnCnf, &tAtData);
        }
    }

    return Z_APMMIA_NORESULT;
}
/***************************************************************************
:zAti_SndUmmPsContextInd
:һUMMPSעϢ
***************************************************************************/
#ifdef CXT_MOV
VOID  zAti_SndUmmPsContextInd(T_zMmiaUmm_PsContext_Cnf *ptPsContextCnf, T_zMmiaUmm_PsContext_Ind *ptPsContextInd)
{
    BYTE bInsNo = (g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_2 : Z_ATI_INSNO_1;
    BYTE bTempInsNo = g_zAti_CurInstance;

    /*ҪUMMظʧܵ*/
    ptPsContextInd->bPsRegState = ptPsContextCnf->bPsRegState;
    
    if(g_zAti_CurInstance == Z_ATI_INSNO_1)
    {
        ptPsContextInd->bSrcIndex = ptPsContextCnf->bDesIndex + Z_ATI_INSTANCE_ONE_CHNL_MAX;
    }
    else
    {
        ptPsContextInd->bSrcIndex = ptPsContextCnf->bDesIndex - Z_ATI_INSTANCE_ONE_CHNL_MAX;
    }

    ptPsContextInd->bDesIndex = ptPsContextCnf->bSrcIndex;

    g_zAti_CurInstance = bInsNo;
    zAti_MsgSend(MMIA_UMM_PS_CONTEXT_IND_EV,(PBYTE)ptPsContextInd,
    sizeof(T_zMmiaUmm_PsContext_Ind),Z_ATI_TASKID_UMM);
    g_zAti_CurInstance = bTempInsNo;

    //zAti_CommonCnf(ptPsContextCnf->bSrcIndex, ptPsContextCnf->bDesIndex,
     //           Z_APMMIA_OPERATION_SUCCESS, Z_APMMIA_NOERROR_ERR);

}
/***************************************************************************
:zAti_MovSmAtMem
:һǨATMEM
***************************************************************************/
VOID zAti_MovSmAtMem(VOID)
{
    BYTE i = 0;
    BYTE bDstInsNo = 0;
    T_zDev_AtMem_SmCidData *ptSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));

    for(i = Z_DEV_AtMem_MININUM_CID; i <= Z_DEV_AtMem_MAXINUM_CID; i++)
    {
        zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, i,(PBYTE)ptSmData, g_zAti_CurInstance);
        /*дһ*/
        bDstInsNo = (g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_2: Z_ATI_INSNO_1;
        zDev_AtMemWriteItem(Z_AtMem_ID_SmCidData, i, (PBYTE)ptSmData, bDstInsNo);
    }
    zAti_RetUB((VOID**)&ptSmData);
}
/***************************************************************************
: Zati_MovDataChannl
:ͨİǨ
***************************************************************************/
VOID zAti_MovDataChannl()
{
    BYTE    iCidNum = 0;
    T_ZAti_ChannelInfo    *pChnelNodeOld = NULL;
    T_ZAti_ChannelInfo    *pChnelNodeNew = NULL;
    BYTE    bDestInsNo = (g_zAti_CurInstance ? Z_ATI_INSNO_1 : Z_ATI_INSNO_2);

    zOss_Memcpy(&g_zAti_SmContext[bDestInsNo], &g_zAti_SmContext[g_zAti_CurInstance], sizeof(T_ZAti_SmContext));
    zOss_Memset((UINT8 *)&g_zAti_SmContext[g_zAti_CurInstance], 0, sizeof(T_ZAti_SmContext));

    for(iCidNum = 0; iCidNum < ZATI2_SM_MAX_SMCID_NUM; iCidNum++)
    {
        if(g_zAti_SmContext[bDestInsNo].lastCidTab[iCidNum].isNdis
            ||g_zAti_SmContext[bDestInsNo].lastCidTab[iCidNum].isPpp)
        {
            pChnelNodeOld = zAti_GetChannelNodePtr((UINT8)g_zAti_SmContext[bDestInsNo].lastCidTab[iCidNum].chnelId);

            if(bDestInsNo == Z_ATI_INSNO_2)
            {
                g_zAti_SmContext[bDestInsNo].lastCidTab[iCidNum].chnelId += Z_ATI_INSTANCE_ONE_CHNL_MAX;
            }
            else
            {
                g_zAti_SmContext[bDestInsNo].lastCidTab[iCidNum].chnelId -= Z_ATI_INSTANCE_ONE_CHNL_MAX;
            }
            pChnelNodeNew = zAti_GetChannelNodePtr((UINT8)g_zAti_SmContext[bDestInsNo].lastCidTab[iCidNum].chnelId);
            if(pChnelNodeOld == NULL || pChnelNodeNew == NULL)
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara, TRACE_ERR_LEVEL_NORMAL,"");//chnel err
                return;
            }
            pChnelNodeNew->cmd_id = pChnelNodeOld->cmd_id;
            pChnelNodeNew->cmd_op = pChnelNodeOld->cmd_op;
            pChnelNodeNew->IsPpp = pChnelNodeOld->IsPpp;
            pChnelNodeNew->server_mode = ZATI2_CHANNEL_MODE_DATA;
            pChnelNodeNew->dataType = ZATI2_CHANNEL_DATA_TYPE_PS;
            pChnelNodeOld->server_mode = ZATI2_CHANNEL_MODE_CMD;
            pChnelNodeOld->dataType = ZATI2_CHANNEL_DATA_TYPE_INVAL;
            pChnelNodeOld->cmd_id = ZAT2_NO_COMMAND;
            pChnelNodeOld->cmd_op = ZAT2_CO_INVALID;
            pChnelNodeOld->IsPpp = FALSE;
            zAti_RemoveALLCmd(pChnelNodeOld);
        }
    }
}
/***************************************************************************
: zAti_UmmPsContextCnf
:UMMϢȡǰMMϢ
ϱ
:
pbBuff      Ϣָ
:
***************************************************************************/
DWORD zAti_UmmPsContextCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaUmm_PsContext_Ind *ptPsContextInd = ZOSS_NULL;
    T_zMmiaUmm_PsContext_Cnf *ptPsContextCnf = (T_zMmiaUmm_PsContext_Cnf*)pBuff;
    ptPsContextInd = (T_zMmiaUmm_PsContext_Ind*)zAti_GetUB(sizeof(T_zMmiaUmm_PsContext_Ind));

    /*һUMMPSעϢ*/
    zAti_SndUmmPsContextInd(ptPsContextCnf, ptPsContextInd);

    /*ATMEMǨ*/
    zAti_MovSmAtMem();

    /*ͨǨ*/
    zAti_MovDataChannl();

    zAti_ClearPsMovStat();
    if(pChnelNode != NULL)
    {
        zAti_SendFnc(pChnelNode->iChnelId, (BYTE *)g_zAt_OK, (WORD)strlen((const char *)g_zAt_OK), ZATI2_CHIND_AT);
        zAti_SendRspCmdStr2Trace(pChnelNode->iChnelId, (WORD)strlen((const char *)g_zAt_OK), (CHAR *)g_zAt_OK);
        zAti_RemoveALLCmd(pChnelNode);//·İǨ֧
    }
    zAti_HandStoredCmdInPsmov();

    return Z_APMMIA_NORESULT;
}
#endif
#ifdef DSDS_VSIM
DWORD zAti_CardSwitchCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    BYTE bIndex = g_zAti_CurInstance;
    T_zMmiaAs_CardSwitch_Ind *ptInd = ZOSS_NULL;
    T_zMmiaAs_CardSwitch_Cnf *ptCardSwitch = (T_zMmiaAs_CardSwitch_Cnf*)pBuff;

    /*任״̬*/
    zAti_GetDualCardStatMutex();
    g_zAti_ptData->tCardSwitch.bSim1Stat = (g_zAti_ptData->tCardSwitch.bSim1Stat == Z_ATI_CARD_ACT)? Z_ATI_CARD_DEACT : Z_ATI_CARD_ACT;
    g_zAti_ptData->tCardSwitch.bSim2Stat = (g_zAti_ptData->tCardSwitch.bSim2Stat == Z_ATI_CARD_ACT)? Z_ATI_CARD_DEACT : Z_ATI_CARD_ACT;
    g_zAti_ptData->tCardSwitch.bSwitchStat = Z_ATI_CARD_NOTSWITCH;
    zAti_PutDualCardStatMutex();

    zAti_MsgSend(MMIA_UMM_CARDSWITCH_CMP_IND_EV, ZOSS_NULL, 0, Z_ATI_TASKID_UMM);

    g_zAti_CurInstance = (g_zAti_CurInstance == Z_ATI_INSNO_1)? 1 : 0;
    zAti_MsgSend(MMIA_UMM_CARDSWITCH_CMP_IND_EV, ZOSS_NULL, 0, Z_ATI_TASKID_UMM);

    /*֪ͨһRRCָ*/
    ptInd = (T_zMmiaAs_CardSwitch_Ind*)zAti_GetUB(sizeof(T_zMmiaAs_CardSwitch_Ind));
    ptInd->bSrcIndex = ptCardSwitch->bDesIndex;
    ptInd->bDesIndex = ptCardSwitch->bSrcIndex;
    ptInd->bActStat = Z_ATI_CARD_ACT;

    if(g_zAti_ptData->tCardSwitch.bSim1Stat == Z_ATI_CARD_ACT)
    {
        g_zAti_CurInstance = Z_ATI_INSNO_1;
    }
    else
    {
        g_zAti_CurInstance = Z_ATI_INSNO_2;
    }
    /*ָп󼤻ҵ*/

    if(ptCardSwitch->bResult == Z_FAIL)
    {
        ptInd->bIsReEst = Z_ATI_AFTCRDSWH_EST;
        ptCardSwitch->bResult = Z_SUCC;
    }
    else
    {
        ptInd->bIsReEst = Z_ATI_AFTCRDSWH_NONEST;
    }

    zAti_MsgSend(MMIA_AS_CARD_SWITCH_IND_EV, (PBYTE)ptInd, sizeof(T_zMmiaAs_CardSwitch_Ind), Z_ATI_TASKID_EUCER);

    g_zAti_CurInstance = bIndex;

    *pdwChangedMsgId = MMIA_AS_CARD_SWITCH_CNF_EV;

    return Z_APMMIA_NORESULT;
}
#endif
DWORD zAti_SmsTcsmpReadCnf(T_z_UiccId_Smsp *ptSmsp, BYTE bAtType)
{
    T_zApMmia_TpFo tTpfo = {0};
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    T_zApMmia_SmsVP tpValidPeriod = {0};
    BYTE iFoTmp;
    CHAR *pStrWalk = g_zAt_EncBuf;
    
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0,(PBYTE)&tAtData, g_zAti_CurInstance);
    
    if (Z_APMMIA_INVALID == tAtData.bTpFoFg)
    {
        //zOss_Memset(&tTpfo, 17, 1);
        tTpfo.bMsgTypeId = 1;
        tTpfo.bTpvpFormat = 2;
    }
    else
    {
        zOss_Memcpy(&tTpfo, &tAtData.bTpFo, 1);
    }

    iFoTmp = tTpfo.bMsgTypeId |(tTpfo.bMsgFeature << 2) | (tTpfo.bTpvpFormat<< 3) |
           (tTpfo.bStatRptFeature<< 5) | (tTpfo.bTpudHeadInd<< 6) | (tTpfo.bReplyPathInd<< 7);

    if(bAtType == Z_ATI_CSMP)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%s+CSMP: %d,", g_zAt_CRLF, iFoTmp);
    }
    else
    {
        pStrWalk += sprintf((char *)pStrWalk, "%s+ZSMP: %d,", g_zAt_CRLF, iFoTmp);
    }

    if (tTpfo.bTpvpFormat == Z_MMIASMS_TPVP_RELATIVE) /* еVPΪ1ֽ */
    {
        tpValidPeriod.bRelTime = ptSmsp->bTPVp;
        /* ,<vp> */
        zAt_EncDate2StrByVpFormat(pStrWalk, tpValidPeriod, tTpfo.bTpvpFormat);//˴öԺķֵж
        pStrWalk += strlen((const char *)pStrWalk);
    }
    else if (tTpfo.bTpvpFormat == Z_MMIASMS_TPVP_ENHANCE 
            || tTpfo.bTpvpFormat == Z_MMIASMS_TPVP_ABSOLUTE)/* 7ֽ */
    {
        zOss_Memcpy(tpValidPeriod.abAbsTime, tAtData.abVp, 7);
        /* ,<vp> */
        zAt_EncDate2StrByVpFormat(pStrWalk, tpValidPeriod, tTpfo.bTpvpFormat);//˴öԺķֵж
        pStrWalk += strlen((const char *)pStrWalk);
    }

    /* ,<pid>,<dcs> */
    pStrWalk += sprintf((char *)pStrWalk, ",%d,%d", ptSmsp->bTPPid, ptSmsp->bTPDcs);

    if(bAtType == Z_ATI_ZSMP)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",%d", ptSmsp->bParamId);
    }

    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    return Z_APMMIA_NOERROR_ERR;
}


/**************************************************************************
: zAti_SmsTcsmpReq
: յSMϢAP_MMIA_SMS_CmgfReq
    : pBuff,ָϢAP_MMIA_SMS_CmgfReqϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣû߲ѯ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_SmsTcsmpReq(VOID* pBuff)
{
    T_zApMmia_SmsTcsmp_Req *ptTcsmpReq = (T_zApMmia_SmsTcsmp_Req *)pBuff;
    T_z_UiccId_Smsp tSmsp = {0};
    DWORD dwCmdRlt = 0;

    zAti_MarkIndex(ptTcsmpReq, Z_PSMDL_SMS);

    /*====================================== ȱʡֵ ==================================== */
    /*  syntax: +CSMP=[<fo>[,<vp>[,<pid>[,<dcs>]]]]                                          */ 
    /*  action:  <fo> ΪЧֵʹõʱѡȱʡֵ                                     */
    /*           <vp>,<pid>,<dcs> ȱʡֵATIд, <vp>ʱ<fo>ȱʡ                    */
    /*====================================================================================== */

    /*  */
    dwCmdRlt = zAti_ReadItem(Z_UiccId_SMSP_REC, 1, 1, (VOID *)&tSmsp);
    if (Z_APUICC_CMD_OK != dwCmdRlt)
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");                       
        return zAti_GETCMSERR(dwCmdRlt);
    }

    /* ѯ */
    if (ptTcsmpReq->bCommandInd == Z_APMMIA_SMSCMDTYPE_QUERY) /* ѯ */
    {
        /*+CSMP: <fo>,<vp>,<pid>,<dcs>*/
        return zAti_SmsTcsmpReadCnf(&tSmsp, ptTcsmpReq->bAtType);
    }
    else
    {
        return zAti_SmsTcsmpUpPara(ptTcsmpReq, &tSmsp);
    }
}

/**************************************************************************
: zAti_SsClckSet
: յATIϢMMIA_SS_SsClckSet_REQ_EV
    : pBuff,ָϢMMIA_SS_SsClck_REQ_EVϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_SsClckSet(VOID* pBuff)
{
    T_zApMmia_ClckSet_Req *ptClckSet = (T_zApMmia_ClckSet_Req*)pBuff;

    /*====================================== ȱʡֵ ==================================== */
    /*  syntax:  +CLCK=<fac>,<mode>[,<passwd>[,<class>]]                                     */ 
    if ((Z_FAIL == zAti_CheckFac(ptClckSet->bFac)) &&
        (Z_APMMIA_FACVALUE_FD != ptClckSet->bFac))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                        
        return Z_APMMIA_OPTNOTSPT_ERR;
    }

    switch(ptClckSet->bFac) 
    {
        case Z_APMMIA_FACVALUE_SC:
            return zAti_SsClckScFacProc(ptClckSet);
        
        case Z_APMMIA_FACVALUE_FD:
            return zAti_SsClckFdFacProc(ptClckSet);
                 
        default:
            return zAti_SsClckDefaultProc(ptClckSet);        
    }    
}

/**************************************************************************
: zAti_SsCpwdSet
: յATIϢZ_APMMIA_CpwdSet_REQ_EV
    : pBuff,ָϢZ_APMMIA_CpwdSet_REQ_EVϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_SsCpwdSet(VOID* pBuff)
{
    T_zApMmia_CpwdSet_Req   *ptCpwdSet   = (T_zApMmia_CpwdSet_Req*)pBuff;
    T_zMmiaSs_PwdChange_Req *ptSsCpwdSet = ZOSS_NULL;
    T_zApUicc_Change_Req    *ptChangeReq = ZOSS_NULL;
    
    if (Z_FAIL == zAti_CheckFac(ptCpwdSet->bFac))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                        
        return Z_APMMIA_OPTNOTSPT_ERR;
    }

    switch(ptCpwdSet->bFac) 
    {
        case Z_APMMIA_FACVALUE_SC:    /* pin  */
        case Z_APMMIA_FACVALUE_P2:
            if (ptCpwdSet->bNewPwdAgainLen > 0)
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                        
                return Z_APMMIA_INVALIDPARA_ERR;
            }            

            ptChangeReq = (T_zApUicc_Change_Req*)zAti_GetUB(sizeof(T_zApUicc_Change_Req));
            ptChangeReq->bSrcIndex     = ptCpwdSet->bSrcIndex;
            ptChangeReq->bDesIndex     = ptCpwdSet->bDesIndex;
            ptChangeReq->bChId           = ptCpwdSet->bChId;

            if (Z_APMMIA_FACVALUE_SC == ptCpwdSet->bFac)
            {
                ptChangeReq->bFac  = Z_APUICC_PIN1TYPE;
            }
            else
            {
                ptChangeReq->bFac  = Z_APUICC_PIN2TYPE;
            }

            zOss_Memset(ptChangeReq->abOldKey, 0xff, 8);
            zOss_Memset(ptChangeReq->abNewKey, 0xff, 8);

            if (ptCpwdSet->bOldPasswdLen > 0)
            {
                zOss_Memcpy(ptChangeReq->abOldKey, ptCpwdSet->abOldPassword, ptCpwdSet->bOldPasswdLen);
            }

            if (ptCpwdSet->bNewPasswdLen > 0)
            {
                zOss_Memcpy(ptChangeReq->abNewKey, ptCpwdSet->abNewPassword, ptCpwdSet->bNewPasswdLen);
            }
            
            zAti_MsgSend(AP_UICC_CHANGE_REQ_EV, (PBYTE)ptChangeReq, sizeof(T_zApUicc_Change_Req), Z_ATI_TASKID_UICC);

            return Z_APMMIA_NORESULT;

        default:                        /* SSҵ */
            zAti_MarkIndex(ptCpwdSet, Z_PSMDL_SS);

            /* SSģȷ: SSҵpwdȱʡ,SSҪ4byte  */

            if ((ptCpwdSet->bOldPasswdLen   != Z_ATISS_PW_LENGTH) ||
                (ptCpwdSet->bNewPasswdLen   != Z_ATISS_PW_LENGTH) ||
                (ptCpwdSet->bNewPwdAgainLen != Z_ATISS_PW_LENGTH && ptCpwdSet->bNewPwdAgainLen != 0))   
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                        
                return Z_APMMIA_INVALIDPARA_ERR;
            }
   
            ptSsCpwdSet = (T_zMmiaSs_PwdChange_Req*)zAti_GetUB(sizeof(T_zMmiaSs_PwdChange_Req));
            ptSsCpwdSet->bSrcIndex  = ptCpwdSet->bSrcIndex;
            ptSsCpwdSet->bDesIndex  = ptCpwdSet->bDesIndex;
            ptSsCpwdSet->bFac       = ptCpwdSet->bFac;

            ptSsCpwdSet->bNewPwdNum = Z_ATISS_PW_LENGTH;
            ptSsCpwdSet->bOldPwdNum = Z_ATISS_PW_LENGTH;
        
            zOss_Memcpy(ptSsCpwdSet->abOldPwd, ptCpwdSet->abOldPassword, ptCpwdSet->bOldPasswdLen);
            zOss_Memcpy(ptSsCpwdSet->abNewPwd, ptCpwdSet->abNewPassword, ptCpwdSet->bNewPasswdLen);

            ptSsCpwdSet->bNewPwdAgnNum = ptCpwdSet->bNewPwdAgainLen;

            if (ptCpwdSet->bNewPwdAgainLen > 0)
            {
                zOss_Memcpy(ptSsCpwdSet->abNewPwdAgn, ptCpwdSet->abNewPwdAgain, ptCpwdSet->bNewPwdAgainLen);
            }
            
            if (Z_SUCC != zAti_MsgSend(MMIA_SS_CPWD_SET_REQ_EV, (PBYTE)ptSsCpwdSet, sizeof(T_zMmiaSs_PwdChange_Req), Z_ATI_TASKID_SS))
            {
                return Z_APMMIA_OPTNOTALW_ERR;
            }
            return Z_APMMIA_NORESULT;
    }    

}

/**************************************************************************
: zAti_SsCusdSetReq
: cusdò
    : pBuff,
    
    أZ_ATI_NOERROR_ERR       
ע    
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_SsCusdSetReq(VOID* pBuff)
{
    T_zApMmia_CusdSet_Req        *ptApSetReq     =  (T_zApMmia_CusdSet_Req*)pBuff;
    T_zMmiaSs_CusdSet_Req        *ptSsCusdSetReq =  ZOSS_NULL;
    T_zMmiaSs_UssdCancel_Req     *ptSsCanclReq   =  ZOSS_NULL;
    T_zDev_AtMem_Mmia_PrivateMem tAtData         =  {0};

    zAti_MarkIndex(ptApSetReq, Z_PSMDL_SS);

    /*====================================== ȱʡֵ ==================================== */
    /*  syntax:  +CUSD=[<n>[,<str>[,<dcs>]]]                                                 */ 
    /*  action: <n>ATIд<str>,<dcs>ͬʱڣԱȱʡ账                      */
    /*====================================================================================== */

   /*====================================== ´Ϣ ================================== */
    switch (ptApSetReq->bNPara)
    {
        case Z_APMMIA_USSDOPT_DISABLE:
        case Z_APMMIA_USSDOPT_ENABLE:
            {
                zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
                tAtData.bCusdSet = ptApSetReq->bNPara;
                zDev_AtMemWriteItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

                /*====================================================================================== */
                /*  strʱãstrʱúҪҵ()                                   */
                /*====================================================================================== */

                if (0 == ptApSetReq->bStrLen)
                {
                    sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
                    return Z_APMMIA_NOERROR_ERR;
                }
                else
                {
                    ptSsCusdSetReq = (T_zMmiaSs_CusdSet_Req *)zAti_GetUB(sizeof(T_zMmiaSs_CusdSet_Req));
                    ptSsCusdSetReq->bSrcIndex = ptApSetReq->bSrcIndex;
                    ptSsCusdSetReq->bDesIndex = ptApSetReq->bDesIndex;
                    ptSsCusdSetReq->bDcs      = ptApSetReq->bDcs;
                    ptSsCusdSetReq->bStrLen   = ptApSetReq->bStrLen;

                    if (ptApSetReq->bStrLen > 0)
                    {
                        zOss_Memcpy(ptSsCusdSetReq->abUssdStr, ptApSetReq->abUssdString, ptApSetReq->bStrLen);
                    }

                    if (Z_SUCC != zAti_MsgForward(MMIA_SS_CUSD_SET_REQ_EV, (PBYTE)ptSsCusdSetReq, sizeof(T_zMmiaSs_CusdSet_Req), Z_ATI_TASKID_SS))
                    {
                        zAti_SendExpt2TraceAgt(ERR_InvalidMsg, TRACE_ERR_LEVEL_NORMAL,"");
                        zAti_RetUB((VOID * * )&ptSsCusdSetReq);
                        return Z_APMMIA_OPTNOTALW_ERR;
                    }
                    return Z_APMMIA_NORESULT;
                 }
            }

        case Z_APMMIA_USSDOPT_CANCEL:
            {
                ptSsCanclReq = (T_zMmiaSs_UssdCancel_Req *)zAti_GetUB(sizeof(T_zMmiaSs_UssdCancel_Req));
                ptSsCanclReq->bSrcIndex = ptApSetReq->bSrcIndex;
                ptSsCanclReq->bDesIndex = ptApSetReq->bDesIndex;

                if (Z_SUCC != zAti_MsgForward(MMIA_SS_USSD_CANCEL_REQ_EV, (PBYTE)ptSsCanclReq, sizeof(T_zMmiaSs_UssdCancel_Req), Z_ATI_TASKID_SS))
                {
                    zAti_SendExpt2TraceAgt(ERR_InvalidMsg, TRACE_ERR_LEVEL_NORMAL,"");
                    zAti_RetUB((VOID * * )&ptSsCanclReq);
                    return Z_APMMIA_OPTNOTALW_ERR;
                }
                return Z_APMMIA_NORESULT;
            }
        default:
            return Z_APMMIA_INVALIDPARA_ERR;
    }
}

/**************************************************************************
: zAti_SmsCscaReq
: յSMϢAP_MMIA_SMS_CscaReq
    : pBuff,ָϢAP_MMIA_SMS_CscaReqϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣû߲ѯ
//ȥEATIԼдTOSCAĴ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_SmsCscaReq(VOID* pBuff)
{
    T_zApMmia_SmsCsca_Req *ptCscaReq = (T_zApMmia_SmsCsca_Req*)pBuff;
    T_z_UiccId_Smsp tSmsp = {0};
    T_z_UiccId_Smsp tUpdateSmsp = {0};
    T_zApMmia_TpAddress tTpSCAddr = {0};
    BYTE bTosca = 0;
    DWORD dwCmdRlt = 0;
    CHAR * pStrWalk = g_zAt_EncBuf;

    zAti_MarkIndex(ptCscaReq, Z_PSMDL_SMS);

    dwCmdRlt = zAti_ReadItem(Z_UiccId_SMSP_REC, 1, 1, (VOID *)&tSmsp);
    if (Z_APUICC_CMD_OK != dwCmdRlt)
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");                       
        return zAti_GETCMSERR(dwCmdRlt);        
    }

    /* ѯ +CSCA: <sca>,<tosca>*/
    if (ptCscaReq->bCommandInd == Z_APMMIA_SMSCMDTYPE_QUERY) /* ѯ */
    {
        if (Z_FAIL == zAti_CheckSmspSca(&tSmsp))
        {
            zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");                       
            return Z_APMMIA_CMSUSIMFAIL_ERR;
        }

        zAti_SetToTpaddr(&(tTpSCAddr),tSmsp.abTSScAdd,Z_ATI_ADDRTYPE_SCA);

        pStrWalk += (Z_ATI_ZSCA == ptCscaReq->bAtTpye) ? 
                    sprintf((char *)pStrWalk, "%s+ZSCA: ", g_zAt_CRLF) : sprintf((char *)pStrWalk, "%s+CSCA: ", g_zAt_CRLF);

        /* <sca>,<tosca>*/
        pStrWalk += (Z_ATI_ZSCA == ptCscaReq->bAtTpye)? zAt_EncScAddr(0, pStrWalk, Z_ATI_ADDRTYPE_SCA, &tTpSCAddr) : 
                          zAt_EncTpAddr(0, pStrWalk, Z_ATI_ADDRTYPE_SCA, &tTpSCAddr); 

        sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF,g_zAt_OK);
        return Z_APMMIA_NOERROR_ERR;
    }

    /**/
    zOss_Memcpy(&tUpdateSmsp, &tSmsp, sizeof(T_z_UiccId_Smsp));
    bTosca = tUpdateSmsp.abTSScAdd[1];      /* ¼еĵַ */
    zAti_TpaddrToSet(tUpdateSmsp.abTSScAdd,&(ptCscaReq->tTpSCAddr),Z_ATI_ADDRTYPE_SCA);

    if (Z_APMMIA_INVALID == ptCscaReq->bScaFg)
    {
        tUpdateSmsp.abTSScAdd[1] = bTosca;
    }

    //õֵͿеֱͬӻOK¿
    if (0 == memcmp(&tUpdateSmsp, &tSmsp, sizeof(T_z_UiccId_Smsp)))
    {
        sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
        return Z_APMMIA_NOERROR_ERR;
    }

    zAti_UiccUpdateItemAndSaveInfo((VOID *)&tUpdateSmsp, sizeof(T_z_UiccId_Smsp),
        Z_UiccId_SMSP_REC, Z_ATI_READUICC_SMSP, ptCscaReq->bSrcIndex, ptCscaReq->bDestIndex);
    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_SmsMsgSendCnf
: յSMSϢZ_MmiaSms_MsgSend_CNF_EV
    : pBuff,ָϢZ_MmiaSms_MsgSend_CNF_EVϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣSMSͶϢĻظ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_SmsMsgSendCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaSms_MsgSend_Cnf *ptSmsMsgCnf = (T_zMmiaSms_MsgSend_Cnf*)pBuff;
    T_zAti_UiccInfo tSaveVal = {0};
    T_z_UICC_Smss tEFsmss = {0};
    DWORD dwCmdRlt = 0;

    if((Z_FAIL == zAti_CheckParam(ptSmsMsgCnf->bMsgCnfType,Z_MMIASMS_STORE_COMMAND_SEND,0)) ||
       (Z_FAIL == zAti_CheckParam(ptSmsMsgCnf->bTpduLength,Z_MMIASMS_MAX_TPDU_LEN,0)) ||
       ((Z_MMIASMS_RESULT_OK    != ptSmsMsgCnf->bResult) &&
        (Z_MMIASMS_RESULT_ERROR != ptSmsMsgCnf->bResult)))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                       
        return Z_APMMIA_CMSUNKNOWN_ERR;
    }
    
    if(Z_MMIASMS_RESULT_OK == ptSmsMsgCnf->bResult)
    {
        dwCmdRlt = zAti_ReadItem(Z_UiccId_SMSS_BIN, 1, 1, (VOID *)&tEFsmss);  /* CQNJ00244371 */
        if (Z_APUICC_CMD_OK != dwCmdRlt)
        {
            zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");                       
            return zAti_GETCMSERR(dwCmdRlt);
        }
        
        /*tpmr*/
        tEFsmss.bLastUsedTpmr = ptSmsMsgCnf->bTpMsgRef;

        zAti_UiccUpdateItemReq(&tEFsmss, sizeof(T_z_UICC_Smss), Z_UiccId_SMSS_BIN, ptSmsMsgCnf->bDestIndex, ptSmsMsgCnf->bSrcIndex);


        tSaveVal.bSrcIndex = ptSmsMsgCnf->bSrcIndex;
        tSaveVal.bDesIndex = ptSmsMsgCnf->bDestIndex;
        tSaveVal.bReadKey = Z_ATI_READUICC_SMSS;
        zOss_Memcpy(&tSaveVal.tMsgSendCnf, ptSmsMsgCnf, sizeof(T_zMmiaSms_MsgSend_Cnf));
        zAti_SaveValWhenReadUicc(&tSaveVal);
        return Z_APMMIA_NORESULT;
    }

    tSaveVal.bSrcIndex = ptSmsMsgCnf->bSrcIndex;
    tSaveVal.bDesIndex = ptSmsMsgCnf->bDestIndex;
    tSaveVal.bReadKey = Z_ATI_READUICC_SMSS;
    zOss_Memcpy(&tSaveVal.tMsgSendCnf, ptSmsMsgCnf, sizeof(T_zMmiaSms_MsgSend_Cnf));
    zAti_SaveValWhenReadUicc(&tSaveVal);
    return zAti_SmsMsgSend2Ati(ptSmsMsgCnf, pdwChangedMsgId);
}
VOID zAti_CreateSendRspReport(BYTE bAckMode, BYTE bSrcIndex, BYTE bDestIndex)    
{
    T_zMmiaSms_RecRsp_Req *ptSmsRecRspReq  = ZOSS_NULL;
    T_zApMmia_TpFo tTpfo = {0};
    ptSmsRecRspReq = (T_zMmiaSms_RecRsp_Req*)zAti_GetUB(sizeof(T_zMmiaSms_RecRsp_Req));
    ptSmsRecRspReq->bSrcIndex   = bSrcIndex;
    ptSmsRecRspReq->bDestIndex = bDestIndex;
    ptSmsRecRspReq->bAckMode    = Z_APMMIA_CNMA_OK;
    ptSmsRecRspReq->bTpduLength = 0;
    zOss_Memset(ptSmsRecRspReq->abTPduBuffer, 0xff, Z_MMIASMS_MAX_TPDU_LEN);

    if (bAckMode == Z_APMMIA_CNMA_ERR)
    {
        ptSmsRecRspReq->bAckMode = Z_APMMIA_CNMA_ERR;
        /* TPDU RP-ERRORϢ(23040,SMS-DELIVER-REPORT for RP-ERROR )Ϊ3ֽڣδ
        TPDUĵһֽTP-FOʧԭ(TP-FCS)TPDUĿѡָʾTP-PI*/
        ptSmsRecRspReq->bTpduLength = 3;
        tTpfo.bMsgTypeId = Z_MMIASMS_DELIVER_RPT;
        tTpfo.bTpudHeadInd = 0;
        zOss_Memset(ptSmsRecRspReq->abTPduBuffer, 0, Z_MMIASMS_MAX_TPDU_LEN);
        zOss_Memcpy(ptSmsRecRspReq->abTPduBuffer, &tTpfo, 1);
        ptSmsRecRspReq->abTPduBuffer[1] = Z_APMMIA_TPMEMCAPAEXCEED_ERR;    
    }

    zAti_MsgSend(MMIA_SMS_REC_RSP_REQ_EV,(PBYTE)ptSmsRecRspReq,sizeof(T_zMmiaSms_RecRsp_Req),Z_ATI_TASKID_SMS);
    return;   
}


/**************************************************************************
: zAti_SmsDeliverRecInd
: յSMSϢZ_MmiaSms_DeliverRecInd_Ev
    : pBuff,ָϢZ_MmiaSms_DeliverRecInd_EvϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣյϢʾ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/    
DWORD zAti_SmsDeliverRecInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    BYTE bNvItemId = 0;
    T_zMmiaSms_DeliverRec_Ind*   ptSmsDlvInd     = (T_zMmiaSms_DeliverRec_Ind*)pBuff;
    T_zDev_AtMem_Mmia_PrivateMem tAtData        = {0};
    T_zAti_PduMsg tPduMsg = {0};
    T_zAti_TxtDlvMsg tTxtDlvMsg = {0};
    T_z_UICC_UstSst tUst = {0};
    T_zAti_NV_ApMemCapa tApMemCapa = {0};

    /*NV*/
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    if((Z_FAIL == zAti_CheckParam(ptSmsDlvInd->bRouteInd,Z_MMIASMS_CNMIMT_CLASS3ROUTE,0)) ||
       (ptSmsDlvInd->bPduLength > Z_MMIASMS_MAX_PDU_LEN) ||
       (Z_FAIL == zAti_CheckPduDlv(ptSmsDlvInd->abPduBuffer, ptSmsDlvInd->bPduLength)))
    {     
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                       
        return Z_APMMIA_NORESULT;
    }

    tPduMsg.bTpmr = 0xff;
    tPduMsg.wPduLen = ptSmsDlvInd->bPduLength;
    tPduMsg.pbPduBuf = ptSmsDlvInd->abPduBuffer;
    zAti_ReadoutDlvPdu(&tPduMsg, &tTxtDlvMsg);/*ͷϢ*/
    zAti_RetUB((VOID**)&tTxtDlvMsg.pbTxtBuf);

    (VOID)zAti_ReadItem(Z_UiccId_USTSST, 1, 1, (VOID *)&tUst);

    if(tTxtDlvMsg.bPid == 0x7f&&zAt_IsClass2Sms(tTxtDlvMsg.bDcs))//PP-DOWNLOAD
    {
        if((tUst.bFlag == 1 && tUst.val.tUst.bDdvSmsPpFg ==1) ||
            (tUst.bFlag == 2 && tUst.val.tSst.bSMSPPFg == 3))
        {
            *pdwChangedMsgId = AP_MMIA_SMS_ZCMTIND_EV;
            return Z_APMMIA_NORESULT;
        }
    }

    switch (ptSmsDlvInd->bRouteInd)
    {
        case Z_MMIASMS_CNMIMT_DIRECTROUTE: /* ֱϱ */
        case Z_MMIASMS_CNMIMT_CLASS3ROUTE:

            /************************************************************************/
            /* Ҫ洢ʱSMSյ洢ظ󣬻ظ RecRsp;                    */
            /* Ҫ洢ʱbCsmsSvc==0PSظ RecRsp;                      */
            /*               bCsmsSvc==1ûظ+CNMA                       */
            /************************************************************************/
            bNvItemId = (g_zAti_CurInstance ? Z_ATI_NV_ApMemCapa2 : Z_ATI_NV_ApMemCapa1);
            zDev_NV_AtiReadItem(bNvItemId, (PBYTE)&tApMemCapa);
            if (tApMemCapa.bApMemCapa == 1)//AP洢
            {
                zAti_CreateSendRspReport(Z_APMMIA_CNMA_ERR, ptSmsDlvInd->bDestIndex, ptSmsDlvInd->bSrcIndex);
                zStmSms_MtStrgFullHandle((T_zStm_TaskIdx)g_zAti_CurInstance);//֪ͨʱҪSTMMCENF
                return Z_APMMIA_NORESULT;
            }
            else if(Z_APMMIA_CSMSSVC_STAND == tAtData.bCsmsSvc)
            {
                zAti_CreateSendRspReport(Z_APMMIA_CNMA_OK, ptSmsDlvInd->bDestIndex, ptSmsDlvInd->bSrcIndex);
            }

            if (tAtData.bCmgfMode == Z_APMMIA_CMGFMODE_PDU)     /* жıģʽpduģʽ */
            {
                *pdwChangedMsgId = AP_MMIA_SMS_PCMTIND_EV;                       
            }
            else
            {
                *pdwChangedMsgId = AP_MMIA_SMS_TCMT_IND_EV;   
            }
            return Z_APMMIA_NORESULT;

        default:
        case Z_MMIASMS_CNMIMT_NOROUTE:            /* 洢ϱ */
        case Z_MMIASMS_CNMIMT_STOREIND:           /* 洢ϱ */
            zAti_SmsDeliverRecStore (ptSmsDlvInd);        
            return Z_APMMIA_NORESULT;        
    }
}

/**************************************************************************
: zAti_SmsStatusRecInd
: յSMSϢZ_MmiaSms_StatusRecInd_Ev
    : pBuff,ָϢZ_MmiaSms_StatusRecInd_EvϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣյ״̬ʾ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/ 
DWORD zAti_SmsStatusRecInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaSms_StatusRec_Ind* ptSmsStatusInd = (T_zMmiaSms_StatusRec_Ind*)pBuff;
    T_zMmiaSms_RecRsp_Req* ptSmsRecRspReq = ZOSS_NULL;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    
    if(Z_FAIL == zAti_CheckParam(ptSmsStatusInd->bRouteInd,Z_MMIASMS_CNMIDS_STOREIND,0) ||
        ptSmsStatusInd->bPduLength > Z_APMMIA_MAX_SMSPDU_LEN)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                       
        return Z_APMMIA_NORESULT;
    }

    /*NV*/
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
   
    switch (ptSmsStatusInd->bRouteInd)
    {
        case Z_MMIASMS_CNMIDS_DIRECTROUTE: /* ֱϱ */
        {
            if(Z_APMMIA_CSMSSVC_STAND == tAtData.bCsmsSvc)
            {
                ptSmsRecRspReq = (T_zMmiaSms_RecRsp_Req*)zAti_GetUB(sizeof(T_zMmiaSms_RecRsp_Req));
                ptSmsRecRspReq->bSrcIndex = ptSmsStatusInd->bDestIndex;
                ptSmsRecRspReq->bDestIndex = ptSmsStatusInd->bSrcIndex;
                ptSmsRecRspReq->bAckMode = 0; 
                ptSmsRecRspReq->bTpduLength = 0;
                zOss_Memset(ptSmsRecRspReq->abTPduBuffer, 0xff, Z_MMIASMS_MAX_TPDU_LEN);

                zAti_MsgSend(MMIA_SMS_REC_RSP_REQ_EV,(PBYTE)ptSmsRecRspReq,sizeof(T_zMmiaSms_RecRsp_Req),Z_ATI_TASKID_SMS);
            }

            switch (tAtData.bCmgfMode)     /* жıģʽpduģʽ */
            {
                case Z_APMMIA_CMGFMODE_PDU: /* PDUģʽ */
                    *pdwChangedMsgId = AP_MMIA_SMS_PCDSIND_EV;                    
                    return Z_APMMIA_NORESULT;
                case Z_APMMIA_CMGFMODE_TEXT: /* ıģʽ */
                    *pdwChangedMsgId = AP_MMIA_SMS_TCDS_IND_EV;                   
                    return Z_APMMIA_NORESULT;
                default:
                    return Z_APMMIA_NORESULT;
            }
        }
        case Z_MMIASMS_CNMIDS_NOROUTE:            /* 洢ϱ */
        case Z_MMIASMS_CNMIDS_STOREIND:           /* 洢ϱ */
        {
            return zAti_SmsSrRecStore (ptSmsStatusInd);            
        }    
        default:
            return Z_APMMIA_NORESULT;
    }
}


/**************************************************************************
: zAti_PbSaveSmCnf
: յPB/SMSϢZ_ApMmia_SaveSm_CNF_EV
    : pBuff,ָϢZ_ApMmia_SaveSm_CNF_EVϢ
    
    أZ_ATI_NOERROR_ERR       
ע    ͣPB/SMS͵ĴϢظж϶ӦϢͬ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_PbSaveSmCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    DWORD dwReason = 0;
    T_zApMmia_SaveSm_Cnf* ptPbSaveSmCnf = (T_zApMmia_SaveSm_Cnf*)pBuff;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    
    if(ptPbSaveSmCnf->bResult > Z_APMMIA_OPERATION_SUCCESS
       || ptPbSaveSmCnf->bSaveFlag > Z_APMMIA_SMSAVEFLAG_CBMSREP
       || (ptPbSaveSmCnf->wIndex < 1 && ptPbSaveSmCnf->bResult == Z_APMMIA_OPERATION_SUCCESS))
    {
        if (Z_APMMIA_SMSAVEFLAG_UPREQUEST == ptPbSaveSmCnf->bSaveFlag)
        {
            return Z_APMMIA_CMSUNKNOWN_ERR;
        }
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                       
        return Z_APMMIA_NORESULT;
    }

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    switch (ptPbSaveSmCnf->bSaveFlag)
    {
    case Z_APMMIA_SMSAVEFLAG_UPREQUEST: /* ϲ洢 */
        *pdwChangedMsgId = AP_MMIA_SMS_CMGW_CNF_EV;
        return Z_APMMIA_NORESULT;
        
    case Z_APMMIA_SMSAVEFLAG_DELIVERREP:   
        if (ptPbSaveSmCnf->bResult ==  Z_APMMIA_OPERATION_SUCCESS)
        {
            *pdwChangedMsgId = AP_MMIA_SMS_STORE_REC_IND_EV;
            zAti_SmsPbSaveSmCnfStoreRpt (ptPbSaveSmCnf);
        }
        else
        {
            *pdwChangedMsgId = AP_MMIA_SMS_SAVE_FAILURE_IND_EV;
            /*APSM/MEδSTM,ϱZMGSFҪ֪ͨ*/
            dwReason = ptPbSaveSmCnf->dwReason;
            if(ptPbSaveSmCnf->dwReason == Z_APMMIA_CMSMEMFAIL_ERR)
            {
                ptPbSaveSmCnf->dwReason = Z_APMMIA_TPMEMCAPAEXCEED_ERR;
            }
            zAti_SmsPbSaveSmCnfStoreRpt (ptPbSaveSmCnf);
            ptPbSaveSmCnf->dwReason = dwReason;
        }

        return Z_APMMIA_NORESULT;
    case Z_APMMIA_SMSAVEFLAG_STATUSREP: 
        if (ptPbSaveSmCnf->bResult ==  Z_APMMIA_OPERATION_SUCCESS)
        {
            *pdwChangedMsgId = AP_MMIA_SMS_STORE_REC_IND_EV;
        }
        zAti_SmsPbSaveSmCnfStoreRpt (ptPbSaveSmCnf);
        return Z_APMMIA_NORESULT;

    case Z_APMMIA_SMSAVEFLAG_CBMSREP:  /* CBSϢ洢ϱ */
        if ((ptPbSaveSmCnf->bSaveFlag == Z_APMMIA_SMSAVEFLAG_CBMSREP) && 
            (ptPbSaveSmCnf->bMem != Z_APMMIA_CPMSMEM_BM))
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                       
            return Z_APMMIA_NORESULT;
        }

        if (ptPbSaveSmCnf->bResult ==  Z_APMMIA_OPERATION_SUCCESS)
        {
            *pdwChangedMsgId = AP_MMIA_SMS_STORE_REC_IND_EV;
        }

        return Z_APMMIA_NORESULT;
         
    case Z_APMMIA_SMSAVEFLAG_DELIVERNOTREP:
    case Z_APMMIA_SMSAVEFLAG_STATUSNOTREP:
        zAti_SmsPbSaveSmCnfStoreRpt (ptPbSaveSmCnf);
        return Z_APMMIA_NORESULT;

    case Z_APMMIA_SMSAVEFLAG_CBMSNOTREP: /* 洢ϱ */
    default:
        return Z_APMMIA_NORESULT;
    }
}



DWORD zAti_ReadDeliverFromMem (const T_zApMmia_ReadSm_Cnf *ptReadSmCnf, BYTE bCsdhShow)
{
    T_zAti_PduMsg tPduMsg = {0};
    T_zAti_TxtDlvMsg tTxtDlvMsg = {0};
    T_zApMmia_SmsTdeliRead_Cnf *ptTdeliReadCnf = ZOSS_NULL;
    T_z_CallNum tCallNum = {0};
    T_zApMmia_QryPhoneResult l_tQryPbResult = {0};

    tPduMsg.bTpmr = 0xff;
    tPduMsg.wPduLen = (WORD)ptReadSmCnf->dwLen;
    tPduMsg.pbPduBuf = ptReadSmCnf->pbMsg;
    zAti_ReadoutDlvPdu(&tPduMsg, &tTxtDlvMsg); /*ͷϢ*/
    
    ptTdeliReadCnf = (T_zApMmia_SmsTdeliRead_Cnf*)zAti_GetUB(sizeof(T_zApMmia_SmsTdeliRead_Cnf));
    ptTdeliReadCnf->bSrcIndex = ptReadSmCnf->bSrcIndex;
    ptTdeliReadCnf->bDestIndex = ptReadSmCnf->bDesIndex;
    ptTdeliReadCnf->bMsgStatVal = ptReadSmCnf->bStatus;
    
    ptTdeliReadCnf->tTpSCAddr = tTxtDlvMsg.tSca;
    ptTdeliReadCnf->tTpFirstOctet = tTxtDlvMsg.tTpFo;
    ptTdeliReadCnf->tTpSrcAddr = tTxtDlvMsg.tTpoa;
    zAti_ArrayToScts(&(ptTdeliReadCnf->tTpSCTS),tTxtDlvMsg.abScts);
    
    ptTdeliReadCnf->bTpProtocolId = tTxtDlvMsg.bPid;
    ptTdeliReadCnf->bTpDataCodeScheme = tTxtDlvMsg.bDcs;
    ptTdeliReadCnf->bMsgHeadInd = bCsdhShow;
    ptTdeliReadCnf->dwTextLength = tTxtDlvMsg.wTxtLen;
    ptTdeliReadCnf->pTextBuffer = tTxtDlvMsg.pbTxtBuf;
    ptTdeliReadCnf->bCharNum = tTxtDlvMsg.bCharNum;
    
    ptTdeliReadCnf->bStatChgFlg = ptReadSmCnf->bStatChgFlg;
    
    /*========================= кѯ(TXT) =================================*/
    zAti_ConvrtTpadr(&tCallNum, &(ptTdeliReadCnf->tTpSrcAddr));
    
    zStmPb_FindNameByNum(&tCallNum, &l_tQryPbResult, (T_zStm_TaskIdx)g_zAti_CurInstance);
    
    if (Z_ATI_QRYPB_SUCC == zAti_CheckQryPbResult(&l_tQryPbResult))
    {
        ptTdeliReadCnf->tName = l_tQryPbResult.tText;
        ptTdeliReadCnf->bNameFg = Z_APMMIA_VALID;
    }
    else
    {
        ptTdeliReadCnf->bNameFg = Z_APMMIA_INVALID;
    }
    
    /*================================================================================*/

    zAti_RecvServerHandlerSlaver(AP_MMIA_SMS_TDELI_READ_CNF_EV, (PBYTE)ptTdeliReadCnf, sizeof(T_zApMmia_SmsTdeliRead_Cnf));
    zAti_RetUB((VOID **)&ptReadSmCnf->pbMsg);
    return Z_APMMIA_NORESULT;
}



/**************************************************************************
: zAti_ReadSmFromMem
: PB/SMSϢĻظ
    : T_zApMmia_ReadSm_Cnf* ptReadSmCnf PB/SMSϢĻظ
       
    أ
ע    ͣȡɹϢȡʧܣϲظʧԭ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
static DWORD zAti_ReadSmFromMem(const T_zApMmia_ReadSm_Cnf* ptReadSmCnf, DWORD * pdwChangedMsgId)
{
    T_zApMmia_SmsTdeliRead_Cnf*  ptTdeliReadCnf  = ZOSS_NULL;
    T_zDev_AtMem_Mmia_PrivateMem tAtData        = {0};
    BYTE                            bScaLen         = 0;
    PBYTE                           pbPduPtr        = ZOSS_NULL;

    if (ptReadSmCnf->bResult == Z_APMMIA_OPERATION_FAILURE)
    {
        zAti_RetUB((VOID **)&ptReadSmCnf->pbMsg);
        return ptReadSmCnf->dwReason;
    }
    
    if ((ZOSS_NULL == ptReadSmCnf->pbMsg) || (0 == ptReadSmCnf->dwLen) ||
        (ptReadSmCnf->bMem != Z_APMMIA_CPMSMEM_BM && ptReadSmCnf->dwLen > Z_APMMIA_MAX_SMSPDU_LEN) ||
        (ptReadSmCnf->bMem == Z_APMMIA_CPMSMEM_BM && ptReadSmCnf->dwLen > Z_APMMIA_CBS_MAX_PDU_PAGE_LEN))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                       
        zAti_RetUB((VOID **)&ptReadSmCnf->pbMsg);
        return Z_APMMIA_CMSUNKNOWN_ERR;
    }
    
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
    
    if (tAtData.bCmgfMode == Z_APMMIA_CMGFMODE_PDU)     /* PDUģʽ */
    {
        *pdwChangedMsgId = (ptReadSmCnf->bMem == Z_APMMIA_CPMSMEM_BM) ? AP_MMIA_CBS_PCBM_READ_CNF_EV : AP_MMIA_SMS_PCMGR_CNF_EV;
        return Z_APMMIA_NORESULT;
    }

    /* ıģʽbmsrsubmitdelivercommand 5 */
    /* ݴ洢жϢͣbmsr */    
    if (ptReadSmCnf->bMem == Z_APMMIA_CPMSMEM_BM) 
    {
        *pdwChangedMsgId = AP_MMIA_CBS_TCBM_READ_CNF_EV;
        return Z_APMMIA_NORESULT;
    }

    /* ״̬,/ɾ 洢ΪSRϢΪ״̬ */
    if (ptReadSmCnf->bMem == Z_APMMIA_CPMSMEM_SR) 
    {
        *pdwChangedMsgId = AP_MMIA_SMS_TSTAT_READ_CNF_EV;
        return Z_APMMIA_NORESULT;
    }

    /* TPFOжϢͣsubmitdelivercommand */
    pbPduPtr = ptReadSmCnf->pbMsg;

    bScaLen = *pbPduPtr + 1;
    if (Z_FAIL == zAti_CheckScaLen(*pbPduPtr))
    {
        ptTdeliReadCnf = (T_zApMmia_SmsTdeliRead_Cnf*)zAti_GetUB(sizeof(T_zApMmia_SmsTdeliRead_Cnf));
        ptTdeliReadCnf->bSrcIndex = ptReadSmCnf->bSrcIndex;
        ptTdeliReadCnf->bDestIndex = ptReadSmCnf->bDesIndex;
        ptTdeliReadCnf->bMsgStatVal = ptReadSmCnf->bStatus;
        ptTdeliReadCnf->bStatChgFlg = ptReadSmCnf->bStatChgFlg;
        ptTdeliReadCnf->bMsgHeadInd = tAtData.bCsdhShow;

        zAti_RecvServerHandlerSlaver(AP_MMIA_SMS_TDELI_READ_CNF_EV, (PBYTE)ptTdeliReadCnf, sizeof(T_zApMmia_SmsTdeliRead_Cnf));
        zAti_RetUB((VOID **)&ptReadSmCnf->pbMsg);
        return Z_APMMIA_NORESULT;
    }

    pbPduPtr += bScaLen;

    /* ΪCQNJ00194504޸ */
    switch (zAti_SmsGetMsgType (((T_zApMmia_TpFo*)pbPduPtr)->bMsgTypeId, ptReadSmCnf->bStatus))
    {
        case Z_ATI_SMSTYPE_DLV:         /* deliver */
            return zAti_ReadDeliverFromMem (ptReadSmCnf, tAtData.bCsdhShow);

        case Z_ATI_SMSTYPE_SUB:        /* submit */  /* һPDUûпӶϢ */
            *pdwChangedMsgId = AP_MMIA_SMS_TSUB_READ_CNF_EV;
            return Z_APMMIA_NORESULT;

        case Z_ATI_SMSTYPE_CMD:        /* command , ΪCQNJ00194504޸*/
            *pdwChangedMsgId = AP_MMIA_SMS_TCOM_READ_CNF_EV;
            return Z_APMMIA_NORESULT;

        case Z_ATI_SMSTYPE_SR:
            /*  ״̬,/ɾ 洢ΪSRϢΪ״̬,ΪCQNJ00194504޸*/
            *pdwChangedMsgId = AP_MMIA_SMS_TSTAT_READ_CNF_EV;
            return Z_APMMIA_NORESULT;

        default:
            zAti_RetUB((VOID **)&ptReadSmCnf->pbMsg);
            return Z_APMMIA_CMSINVALIDPDUPARA_ERR;
    }
}

/**************************************************************************
: zAti_PbReadSmCnf
: յPB/SMSϢZ_ApMmia_ReadSm_CNF_EV
    : pBuff,ָϢZ_ApMmia_ReadSm_CNF_EVϢ
    
    أZ_ATI_NOERROR_ERR       
ע    ͣPB/SMS͵ĶϢظж϶ӦϢͬ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_PbReadSmCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zApMmia_ReadSm_Cnf* ptPbReadSmCnf = (T_zApMmia_ReadSm_Cnf*)pBuff;
    DWORD bResult = 0;

    if((Z_FAIL == zAti_CheckParam(ptPbReadSmCnf->bReadFlag,Z_APMMIA_SMREADFLAG_FORSEND,0)) ||
       (Z_FAIL == zAti_CheckParam(ptPbReadSmCnf->bMem,Z_APMMIA_CPMSMEM_SR,0)))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_RetUB((VOID **)&ptPbReadSmCnf->pbMsg);
        return Z_APMMIA_CMSUNKNOWN_ERR;
    }

    if ((Z_APMMIA_OPERATION_SUCCESS == ptPbReadSmCnf->bResult) && (0 == ptPbReadSmCnf->dwLen))
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_RetUB((VOID **)&ptPbReadSmCnf->pbMsg);
        return Z_APMMIA_CMSUNKNOWN_ERR;
    }

    if (ptPbReadSmCnf->bReadFlag == Z_APMMIA_SMREADFLAG_FORSEND)
    {  /*ģΪPB˵+CMSSѾյABORT
            ˴ҲжϢǷȷ,ֱӻظ501ʾж*/
        if(g_zAti_ptData->abChMdlTable[ptPbReadSmCnf->bDesIndex] == Z_PSMDL_PB)
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
            zAti_RetUB((VOID **)&ptPbReadSmCnf->pbMsg);
            return Z_APMMIA_CMSMOABORTOK_ERR;
        }
        else
        {
            g_zAti_ptData->abChMdlTable[ptPbReadSmCnf->bDesIndex] =  Z_PSMDL_SMS;
        }
        bResult = zAti_SendSmFromMem(ptPbReadSmCnf);
        zAti_RetUB((VOID **)&ptPbReadSmCnf->pbMsg);
    }
    else
    {
        bResult = zAti_ReadSmFromMem(ptPbReadSmCnf, pdwChangedMsgId);
    }

    return bResult;
}


VOID zAti_Cbs_SendDataInPduMode(T_zMmiaCbs_Data_Ind *pDataInd, BYTE bCurrPage)
{
    T_zAti_PduMsg tPduMsg = {0};
    T_zApMmia_Cbs_Pcbm_Ind *pPcbmInd = (T_zApMmia_Cbs_Pcbm_Ind*)zAti_GetUB(sizeof(T_zApMmia_Cbs_Pcbm_Ind));
    
    /*PDU*/
    zAti_Cbs_EncapPdu(&tPduMsg, pDataInd, bCurrPage);
    
    pPcbmInd->bSrcIndex = pDataInd->bSrcIndex;
    pPcbmInd->bDesIndex = pDataInd->bDesIndex;
    pPcbmInd->bMsgLen   = (BYTE)tPduMsg.wPduLen;
    
    if (tPduMsg.wPduLen > 0)
    {
        zOss_Memcpy(pPcbmInd->abBuf, tPduMsg.pbPduBuf, tPduMsg.wPduLen);
    }

    zAti_RecvServerHandlerSlaver(AP_MMIA_CBS_PCBM_IND_EV, (PBYTE)pPcbmInd, sizeof(T_zApMmia_Cbs_Pcbm_Ind));   
    zAti_RetUB((VOID * * )&tPduMsg.pbPduBuf);
    return;
}

VOID zAti_Cbs_SendDataInTxtMode(T_zMmiaCbs_Data_Ind *pDataInd, BYTE bCurrPage)
{
    T_zApMmia_Cbs_Tcbm_Ind *pTcbmInd = (T_zApMmia_Cbs_Tcbm_Ind*)zAti_GetUB(sizeof(T_zApMmia_Cbs_Tcbm_Ind));
    
    pTcbmInd->bSrcIndex  = pDataInd->bSrcIndex;
    pTcbmInd->bDesIndex  = pDataInd->bDesIndex;
    pTcbmInd->bCurPage   = pDataInd->atBuf[bCurrPage].bCurPage;
    pTcbmInd->bTotalPage = pDataInd->bTotalPage;
    pTcbmInd->bDcs       = pDataInd->bDcs;
    pTcbmInd->wSn        = pDataInd->wSn;
    pTcbmInd->wMid       = pDataInd->wMid;
    pTcbmInd->bMsgLen    = pDataInd->atBuf[bCurrPage].bMsgLen;
    
    if (pTcbmInd->bMsgLen > 0)
    {
        zOss_Memcpy(pTcbmInd->abBuf, pDataInd->atBuf[bCurrPage].abBuf, pTcbmInd->bMsgLen);
    }
    
    zAti_RecvServerHandlerSlaver(AP_MMIA_CBS_TCBM_IND_EV, (PBYTE)pTcbmInd, sizeof(T_zApMmia_Cbs_Tcbm_Ind));  
}

/**************************************************************************
: zAti_Cbs_DataInd
: CBSϱ
    : pBuff,ָϢAP_MMIA_SMS_Cmgr_REQ_EVϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣ1. ж·ɷʽ 2. 洢
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_Cbs_DataInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    BYTE                       i          = 0;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    T_zMmiaCbs_Data_Ind*    pDataInd   = (T_zMmiaCbs_Data_Ind*)pBuff;

#ifdef _USE_ETWS_REPORT
    if (pDataInd->bWarningMsgInd == Z_MMIACBS_PRI_ETWS_MSG)
    {
        *pdwChangedMsgId = AP_MMIA_ZETWS_PRIMARY_IND_EV;
        return Z_APMMIA_NORESULT;
    }
#endif

    /**/
    if ((pDataInd->bCbmInd > Z_MMIACBS_ONLY_TRANSFERS) ||
        (pDataInd->bTotalPage > Z_MMIACBS_MAX_PAGE_NUM) ||
        (pDataInd->bCurPageNum > Z_MMIACBS_MAX_PAGE_NUM))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                        
        return Z_APMMIA_NORESULT;
    }
    for (i = 0; i < pDataInd->bCurPageNum; i ++)
    {
        if ((pDataInd->atBuf[i].bCurPage > Z_MMIACBS_MAX_PAGE_NUM) ||
            (pDataInd->atBuf[i].bMsgLen > Z_MMIACBS_MAX_TEXT_PAGE_LEN) ||
            (pDataInd->atBuf[i].bMsgLen == 0))
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                        
            return Z_APMMIA_NORESULT;
        }
    }

    switch(pDataInd->bCbmInd) 
    {
        case Z_MMIACBS_ONLY_STORE:             /*洢*/
        case Z_MMIACBS_STORE_TRANSFERS:   /*洢ϱ*/
            for (i = 0; i < pDataInd->bCurPageNum; i ++)
            {
                zAti_Cbs_SaveDataToStm(pDataInd, i);
            }           
            break;

        case Z_MMIACBS_ONLY_TRANSFERS:         /*ϱ*/
            zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

            switch(tAtData.bCmgfMode)
            {
                case Z_APMMIA_CMGFMODE_PDU:
                    for (i = 0; i < pDataInd->bCurPageNum; i ++)
                    { 
                        zAti_Cbs_SendDataInPduMode(pDataInd, i);
                    }
                    break;

                case Z_APMMIA_CMGFMODE_TEXT:
                    for (i = 0; i < pDataInd->bCurPageNum; i ++)
                    {
                        zAti_Cbs_SendDataInTxtMode(pDataInd, i);
                    }
                    break;

                default:
                    break;
            }

            break;

        default:
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                        
            return Z_APMMIA_NORESULT;
    }

    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_PbDeleteSmCnf
: յPB/SMSϢZ_ApMmia_DeleteSm_CNF_EV
    : pBuff,ָϢZ_ApMmia_DeleteSm_CNF_EVϢ
    
    أZ_ATI_NOERROR_ERR       
ע    ͣPB/SMS͵ɾϢظж϶ӦϢͬ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
617001702163 [ATI]ܻ޸ģCCFCCLCCCGEVVTS 
617001738758 [ati]AT޸ĵ
***************************************************************************/
DWORD zAti_PbDeleteSmCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zApMmia_DeleteSm_Cnf   *ptPbDelSmCnf = (T_zApMmia_DeleteSm_Cnf*)pBuff;

    if (ptPbDelSmCnf->bResult == Z_APMMIA_OPERATION_SUCCESS)
    {
        return Z_APMMIA_NOERROR_ERR;
    }

    return ptPbDelSmCnf->dwReason;
}

VOID zAti_HandleMemAvailIndExtr(T_zApMmia_SmMemAvail_Ind *ptPbSmMemAvailInd, DWORD dwCause)
{
    T_zApMmia_MemAvail_Rsp   *ptPbRsp  = (T_zApMmia_MemAvail_Rsp*)zAti_GetUB(sizeof(T_zApMmia_MemAvail_Rsp));
    
    ptPbRsp->bSrcIndex = ptPbSmMemAvailInd->bDesIndex;  /* PB ϢٷPBҪ*/
    ptPbRsp->bDesIndex = ptPbSmMemAvailInd->bSrcIndex;
    ptPbRsp->bResult = Z_APMMIA_OPERATION_FAILURE;
    ptPbRsp->dwReason = dwCause;

    zAti_MsgSend(AP_MMIA_SM_MEM_AVAIL_RSP_EV, (PBYTE)ptPbRsp, sizeof(T_zApMmia_MemAvail_Rsp), Z_ATI_TASKID_PB);
    
}

/**************************************************************************
: zAti_PbSmMemAvail
: յPB/SMSϢZ_ApMmia_PbSmMemAvailInd_Ev
    : pBuff,ָϢZ_ApMmia_PbSmMemAvailInd_EvϢ
    
    أZ_ATI_NOERROR_ERR       
ע    ͣPB/SMS͵Ĵ洢ϱ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
617001738758 [ati]AT޸ĵ
***************************************************************************/
DWORD zAti_PbSmMemAvail(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zApMmia_SmMemAvail_Ind* ptPbSmMemAvailInd = (T_zApMmia_SmMemAvail_Ind*)pBuff;
    T_zMmiaSms_MemAvail_Req* ptSmsMemAvailReq = ZOSS_NULL;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};

    if ((ptPbSmMemAvailInd->bAvailable != Z_APMMIA_SMMEMORY_UNAVAILABLE) &&
        (ptPbSmMemAvailInd->bAvailable != Z_APMMIA_SMMEMORY_AVAILABLE))
    {
        zAti_HandleMemAvailIndExtr(ptPbSmMemAvailInd, (DWORD)Z_MMIASMS_CMS_OPER_NOT_SUP);//617001960161 [ATI]߲˫

        return Z_APMMIA_NORESULT;
    }
    
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
    
    ptSmsMemAvailReq = (T_zMmiaSms_MemAvail_Req*)zAti_GetUB(sizeof(T_zMmiaSms_MemAvail_Req));

    ptSmsMemAvailReq->bSrcIndex   = ptPbSmMemAvailInd->bDesIndex;
    ptSmsMemAvailReq->bDestIndex  = ptPbSmMemAvailInd->bSrcIndex;
    ptSmsMemAvailReq->bSmsService = tAtData.bCgsmsSvc;
    ptSmsMemAvailReq->bLinkStatus = tAtData.bCmmsSet;
    ptSmsMemAvailReq->bIsEwalk = (g_zAti_ptData->bEModeType == 0)? Z_VALID : Z_INVALID;

    /*=============================================================*/
    /* SMSȷϣ洢Ƿӳϵ:                          */
    /* Z_APMMIA_SMMEMORY_UNAVAILABLE  =>   ABORT                 */
    /* Z_APMMIA_SMMEMORY_AVAILABLE    =>   NOTIFY                */
    /*=============================================================*/

    ptSmsMemAvailReq->bNotifAbort = (ptPbSmMemAvailInd->bAvailable == Z_APMMIA_SMMEMORY_UNAVAILABLE) ? Z_MMIASMS_RPSMMA_ABORT : Z_MMIASMS_RPSMMA_REQ;
    
    if (Z_SUCC != zAti_MsgSend(MMIA_SMS_MEM_AVAIL_REQ_EV,(PBYTE)ptSmsMemAvailReq,sizeof(T_zMmiaSms_MemAvail_Req),Z_ATI_TASKID_SMS))
    {
        zAti_HandleMemAvailIndExtr(ptPbSmMemAvailInd, (DWORD)Z_APMMIA_CMSOPTNOTALLOW_ERR);//617001960161
    }
    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_PbInitCmpltInd
: PBʼϱ
    : 
    
    أZ_APMMIA_NORESULT       
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD __ps_2g_func zAti_PbInitCmpltInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zApMmia_PbInitCmplt_Ind    *ptPbInitInd = (T_zApMmia_PbInitCmplt_Ind*)pBuff; 
    T_zApMmia_PbMtPara_Ind       *ptMtParaPb = (T_zApMmia_PbMtPara_Ind*)zAti_GetUB(sizeof(T_zApMmia_PbMtPara_Ind));
    
    T_zDev_AtMem_SMS_CnmiCmd tAtData    = {0};

    *pdwChangedMsgId = AP_MMIA_ZPBIC_IND_EV;

    /* ======================================== <mt >================================================== */
    zDev_AtMemReadItem(Z_AtMem_ID_Cnmi, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
    ptMtParaPb->bSrcIndex = ptPbInitInd->bDesIndex;
    ptMtParaPb->bDesIndex = ptPbInitInd->bSrcIndex;
    ptMtParaPb->bMtPara   = tAtData.bCnmiMt;

    zAti_MsgSend(AP_MMIA_PB_MT_PARA_IND_EV, (PBYTE)ptMtParaPb, sizeof(T_zApMmia_PbMtPara_Ind), Z_ATI_TASKID_PB);
    return Z_APMMIA_NORESULT;
}


/**************************************************************************
: zAti_SmsTcmgsReq
: յSMϢAP_MMIA_SMS_Tcmgs_REQ_EV
    : pBuff,ָϢAP_MMIA_SMS_Tcmgs_REQ_EVϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣıģʽֱӷϢ,PDU
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
09.6.29         ӵַ0ж,ַȱʡ
09.6.29         NVbCmmsSetbCgsmsSrvϷж
09.7.1          ıȲΪ0ʱbufferյļ
617001738758 [ati]AT޸ĵ
***************************************************************************/
DWORD zAti_SmsTcmgsReq(VOID* pBuff)
{
    T_zApMmia_SmsTcmgs_Req*      ptTcmgsReq      = (T_zApMmia_SmsTcmgs_Req*)pBuff;
    T_zMmiaSms_SubmitSend_Req*   ptSmsSubmitReq  = ZOSS_NULL;
    T_zDev_AtMem_Mmia_PrivateMem tAtData        = {0};
    T_zAti_TxtSubMsg            tTxtSubMsg;
    T_zAti_PduMsg               tPduMsg;
    DWORD                           bResult         = Z_APMMIA_NOERROR_ERR; /* úķؽ */


    zAti_MarkIndex(ptTcmgsReq, Z_PSMDL_SMS);    

    if (zAti_TxtModeFindTpdaAndScaInStm(&ptTcmgsReq->tTpDestAddr) == Z_INVALID)
    {
        zAti_RetUB((VOID **)&ptTcmgsReq->pTextBuffer);
        return Z_APMMIA_CMSOPTNOTALLOW_ERR;
    }
   
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
    
    tTxtSubMsg.bCharNum  = ptTcmgsReq->bCharNum;
    tTxtSubMsg.wTextLen  = (WORD)ptTcmgsReq->dwTextLength;
    tTxtSubMsg.pbTextBuf = ptTcmgsReq->pTextBuffer;
    tTxtSubMsg.tTpda     = ptTcmgsReq->tTpDestAddr;
    
    bResult = zAti_EncapSubPdu(&tTxtSubMsg, &tPduMsg);
    
    /* ϲ㴫ָͷ */
    zAti_RetUB((VOID **)&ptTcmgsReq->pTextBuffer);
    
    switch (bResult)
    {
    case Z_APMMIA_NVFAILURE_ERR:
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");                       
        return Z_APMMIA_CMSMEMFAIL_ERR;
        
    case Z_APMMIA_CMSINVALIDTEXTPARA_ERR:
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_NORMAL,"");                       
        return Z_APMMIA_CMSINVALIDTEXTPARA_ERR;
        
    case Z_APMMIA_NOERROR_ERR:
        {
            ptSmsSubmitReq = (T_zMmiaSms_SubmitSend_Req*)zAti_GetUB(sizeof(T_zMmiaSms_SubmitSend_Req));            
            ptSmsSubmitReq->bSrcIndex    = ptTcmgsReq->bSrcIndex;
            ptSmsSubmitReq->bDestIndex   = ptTcmgsReq->bDestIndex;
            ptSmsSubmitReq->bMsgSendType = Z_MMIASMS_DIRECT_SUBMIT_SEND;/* ֱӷtodo */
            ptSmsSubmitReq->bTpMsgRef    = tPduMsg.bTpmr;
            ptSmsSubmitReq->bPduLength   = (BYTE)tPduMsg.wPduLen;  /* Ϣ */
            /* PDU */
            if (tPduMsg.pbPduBuf != ZOSS_NULL)
            {
                if (ptSmsSubmitReq->bPduLength != 0)
                {
                    zOss_Memcpy(ptSmsSubmitReq->abPduBuffer, tPduMsg.pbPduBuf, ptSmsSubmitReq->bPduLength);
                }
                zAti_RetUB((VOID **)&tPduMsg.pbPduBuf);
            }
            
            ptSmsSubmitReq->bLinkStatus = tAtData.bCmmsSet;
            ptSmsSubmitReq->bSmsService = tAtData.bCgsmsSvc;
            ptSmsSubmitReq->bIsEwalk = (g_zAti_ptData->bEModeType == 0)? Z_VALID : Z_INVALID;

            if (Z_SUCC!= zAti_MsgSend(MMIA_SMS_SUBMIT_SEND_REQ_EV,(PBYTE)ptSmsSubmitReq,sizeof(T_zMmiaSms_SubmitSend_Req),Z_ATI_TASKID_SMS))
            {
                return zAti_GETCMSERR(Z_APMMIA_OPTNOTALW_ERR);
            }
            break;
        }
    default:
        break;
    }

    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_SmsTcmgwReq
: յSMϢAP_MMIA_SMS_Tcmgw_REQ_EV
    : pBuff,ָϢAP_MMIA_SMS_Tcmgw_REQ_EVϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣıģʽдϢ洢,PDU
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_SmsTcmgwReq(VOID* pBuff)
{
    T_zApMmia_SmsTcmgw_Req*  ptTcmgwReq  = (T_zApMmia_SmsTcmgw_Req*)pBuff;
    T_zApMmia_SaveSm_Req*    ptPbSaveReq = ZOSS_NULL;
    T_zAti_TxtSubMsg        tTxtSubMsg  = {0};
    T_zAti_TxtDlvMsg        tTxtDlvMsg  = {0};
    T_zAti_PduMsg           tPduMsg     = {0};
    DWORD bResult = Z_APMMIA_NOERROR_ERR; /* úķؽ */

    zAti_MarkIndex(ptTcmgwReq, Z_PSMDL_SMS);
    
    switch(ptTcmgwReq->bMsgStatVal) 
    {
        case Z_APMMIA_MSGSTAT_RECUNREAD:
        case Z_APMMIA_MSGSTAT_RECREAD:
            {
                tTxtDlvMsg.bCharNum = ptTcmgwReq->bCharNum;
                tTxtDlvMsg.wTxtLen  = (WORD)ptTcmgwReq->dwTextLength;
                tTxtDlvMsg.pbTxtBuf = ptTcmgwReq->pTextBuffer;
                tTxtDlvMsg.tTpoa    = ptTcmgwReq->tTpAddr;

                bResult = zAti_EncapDlvPdu(&tTxtDlvMsg, &tPduMsg);
                break;
            }
            
        case Z_APMMIA_MSGSTAT_STOUNSENT:
        case Z_APMMIA_MSGSTAT_STOSENT_NOSTATRPT:
        case Z_APMMIA_MSGSTAT_STOSENT_STATRPTNOTRCV:
        case Z_APMMIA_MSGSTAT_STOSENT_STATRPTSTOOTHR:
        case Z_APMMIA_MSGSTAT_STOSENT_STATRPTSTOSMSR:
        {
            tTxtSubMsg.bCharNum  = ptTcmgwReq->bCharNum;
            tTxtSubMsg.wTextLen  = (WORD)ptTcmgwReq->dwTextLength;
            tTxtSubMsg.pbTextBuf = ptTcmgwReq->pTextBuffer;
            tTxtSubMsg.tTpda     = ptTcmgwReq->tTpAddr;

            bResult = zAti_EncapSubPdu(&tTxtSubMsg, &tPduMsg);/* װPUD */
            break;
        }
        default:
            break; /*봦Ӧ*/
    }
    
    /* ϲ㴫ָͷ */
    zAti_RetUB((VOID **)&ptTcmgwReq->pTextBuffer);
    
    switch (bResult)
    {
    case Z_APMMIA_NVFAILURE_ERR:
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");                       
        return Z_APMMIA_CMSMEMFAIL_ERR;

    case Z_APMMIA_CMSINVALIDTEXTPARA_ERR:
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_NORMAL,"");                       
        return Z_APMMIA_CMSINVALIDTEXTPARA_ERR;
        
    case Z_APMMIA_NOERROR_ERR:
        ptPbSaveReq = (T_zApMmia_SaveSm_Req*)zAti_GetUB(sizeof(T_zApMmia_SaveSm_Req));
        ptPbSaveReq->bSrcIndex  = ptTcmgwReq->bSrcIndex;
        ptPbSaveReq->bDesIndex  = ptTcmgwReq->bDestIndex;
        ptPbSaveReq->bSaveFlag  = Z_APMMIA_SMSAVEFLAG_UPREQUEST;  /* ϲ */
        ptPbSaveReq->bMsgStatus = ptTcmgwReq->bMsgStatVal;
        ptPbSaveReq->bTpMsgRef  = Z_ATI_INVALID_BYTE;            /* status reportЧ */
        ptPbSaveReq->bMemStyle  = Z_ATI_INVALID_BYTE;
        ptPbSaveReq->dwLen      = tPduMsg.wPduLen;
        ptPbSaveReq->pbMsg      = tPduMsg.pbPduBuf;
        
        zAti_MsgSend(AP_MMIA_SM_SAVE_REQ_EV,(PBYTE)ptPbSaveReq,sizeof(T_zApMmia_SaveSm_Req),Z_ATI_TASKID_PB);
        break;

    default:
        break;
    }
    
    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_SmsTcmgcReq
: յSMϢAP_MMIA_SMS_Tcmgc_REQ_EV
    : pBuff,ָϢAP_MMIA_SMS_Tcmgc_REQ_EVϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣıģʽֱӷϢ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
09.7.1          textBufferΪյļӦڳȲΪ0ʱ
09.7.1          pduֵӻظϢ
09.7.1          ӶNVļ
***************************************************************************/
DWORD zAti_SmsTcmgcReq(VOID* pBuff)
{
    DWORD   dwRet = Z_APMMIA_NOERROR_ERR;
    T_zApMmia_SmsTcmgc_Req*      ptTcmgcReq  = (T_zApMmia_SmsTcmgc_Req*)pBuff;
    T_z_UiccId_Smsp tEFsmsp    = {0};
    T_zAti_TxtCmdMsg            tTxtCmdMsg = {0};
    T_zAti_PduMsg               tPduMsg = {0};


    zAti_MarkIndex(ptTcmgcReq, Z_PSMDL_SMS);

    /*======================================  ====================================== */
    if (ptTcmgcReq->dwCommandTextLength > Z_ATI_MAX_TPCD_LEN)
    {
        zAti_RetUB((VOID **)&ptTcmgcReq->pCommandTextBuffer);
        return Z_APMMIA_CMSINVALIDTEXTPARA_ERR;
    }

    /*====================================== ´Ϣ ================================== */
    dwRet = zAti_ReadItem(Z_UiccId_SMSP_REC, 1, 1, (VOID *)&tEFsmsp);
    if (Z_APUICC_CMD_OK != dwRet)
    {
        zAti_RetUB((VOID **)&ptTcmgcReq->pCommandTextBuffer);
        return zAti_GETCMSERR(dwRet);
    }

    if (zAti_SmsTcmgcDefaultParaProc(ptTcmgcReq, &tTxtCmdMsg, &tEFsmsp) != Z_APMMIA_NOERROR_ERR)
    {
        zAti_RetUB((VOID **)&ptTcmgcReq->pCommandTextBuffer);
        return Z_APMMIA_CMSINVALIDTEXTPARA_ERR;
    }    

    if (zAti_TxtModeFindTpdaAndScaInStm(&tTxtCmdMsg.tTpda) == Z_INVALID)
    {
        zAti_RetUB((VOID **)&ptTcmgcReq->pCommandTextBuffer);
        return Z_APMMIA_CMSOPTNOTALLOW_ERR;
    }

    dwRet = zAti_EncapCmdPdu(&tTxtCmdMsg, &tPduMsg, &tEFsmsp);
    /* ϲ㴫ָͷ */
    zAti_RetUB((VOID **)&ptTcmgcReq->pCommandTextBuffer);

    if (dwRet == Z_APMMIA_NOERROR_ERR)
    {
        dwRet = zAti_SmsTcmgcSend (ptTcmgcReq, &tPduMsg);
    }
    zAti_RetUB((VOID **)&tPduMsg.pbPduBuf);

    return dwRet;    
}

/**************************************************************************
: zAti_SmsPcnmaReq
: յATI ϢAP_MMIA_SMS_PcnmaReq
    : pBuff,ָϢAP_MMIA_SMS_PcnmaReqϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣͶϢӦ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_SmsPcnmaReq(VOID* pBuff)
{
    T_zApMmia_SmsPcnma_Req* ptPcnmaReq = (T_zApMmia_SmsPcnma_Req*)pBuff;
    T_zMmiaSms_RecRsp_Req* ptSmsRecRspReq = ZOSS_NULL;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};

    zAti_MarkIndex(ptPcnmaReq, Z_PSMDL_SMS);
    
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
    
    /* bCsmsSvc=0 ʱϲ㲻Ӧ÷Ϣ */
    if(Z_APMMIA_CSMSSVC_STAND == tAtData.bCsmsSvc && Z_INVALID == ptPcnmaReq->bIsZnmaFg)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");                        
        return Z_APMMIA_CMSNOCNMAACK_ERR;
    }
    ptSmsRecRspReq = (T_zMmiaSms_RecRsp_Req*)zAti_GetUB(sizeof(T_zMmiaSms_RecRsp_Req));
    ptSmsRecRspReq->bSrcIndex   = ptPcnmaReq->bSrcIndex;
    ptSmsRecRspReq->bDestIndex  = ptPcnmaReq->bDestIndex;
    ptSmsRecRspReq->bAckMode    = ptPcnmaReq->bAckMode;
    ptSmsRecRspReq->bTpduLength = ptPcnmaReq->bTpduLength;

    if (ptPcnmaReq->bTpduLength != 0)
    {
        zOss_Memcpy(ptSmsRecRspReq->abTPduBuffer, ptPcnmaReq->abPduBuf, ptPcnmaReq->bTpduLength);
        if (ptSmsRecRspReq->bAckMode == Z_APMMIA_CNMA_ERR && ptSmsRecRspReq->abTPduBuffer[1] == Z_APMMIA_TPMEMCAPAEXCEED_ERR)
        {
            //֪ͨʱҪSTMMCENF
            zStmSms_MtStrgFullHandle((T_zStm_TaskIdx)g_zAti_CurInstance);
        }
    }

    if (Z_SUCC != zAti_MsgSend(MMIA_SMS_REC_RSP_REQ_EV,(PBYTE)ptSmsRecRspReq,sizeof(T_zMmiaSms_RecRsp_Req),Z_ATI_TASKID_SMS))
    {
        return zAti_GETCMSERR(Z_APMMIA_OPTNOTALW_ERR);
    }
    return Z_APMMIA_NORESULT;
}

BYTE zAti_CheckPduTpudl(PBYTE ptPdu, DWORD dwPduLen)
{
    BYTE    bScaLen     = 0;
    BYTE    bTpdaValLen = 0;
    BYTE    bTpudLen    = 0;
    BYTE    bVpLen      = 0;
    BYTE    bFlwTpdaLen = 0;    /* TPUDLֽ֮ */
    BYTE    bDcs = 0;
    PBYTE  pbPdutr = ptPdu; 
    
    T_zApMmia_TpFo tTpfo = {0};
    
    if (Z_FAIL == zAti_CheckScaLen(*pbPdutr))
    {
        return Z_FAIL;
    }
    /* SCA ռõһֽ*/
    bScaLen = *pbPdutr + 1;
  
    zOss_Memcpy(&tTpfo, (ptPdu + bScaLen), 1);/* tpfo */

    /*if (tTpfo.bTpudHeadInd == 0)
    {
        return Z_SUCC;
    }*/
    
    pbPdutr += (bScaLen + 2); /*SCA,tpfotpmr*/

    /* TPDA */
    if (Z_FAIL == zAti_CheckParam(*pbPdutr, 2 * Z_ATI_SMSADDRESS_MAXLEN, 0))
    {
        return Z_FAIL;
    }
    
    /* TPDA */
    bTpdaValLen = (*pbPdutr + 1) / 2; /*tpda ַĳ*/
    pbPdutr += 2 + bTpdaValLen;   /* TPDAռֽ, 23.040, tpda len, tpda type tpda val */

    pbPdutr += 1; /* pid*/
    bDcs = *pbPdutr;
    pbPdutr += 1; /* dcs*/
    
    /* tpvpĳ */
    bVpLen = zAti_SmsGetVpLen (tTpfo.bTpvpFormat);
    pbPdutr += bVpLen; /* tpvp */

    bTpudLen = *pbPdutr;/* TPUDLһTPUDֽ*/

    pbPdutr++;/* TpudLen */

    if ((bTpudLen > 0) && ((BYTE)(dwPduLen <= (DWORD)(pbPdutr - ptPdu))))
    {
        return Z_FAIL;
    }

    bFlwTpdaLen = (BYTE)(dwPduLen - (DWORD)(pbPdutr - ptPdu));//ݵĳ
 
    if (zAt_Is7BitCode(bDcs))
    {
        return Z_SUCC;
    }
    else
    {
        if (bTpudLen != bFlwTpdaLen)
        {
            return Z_FAIL;
        }
    }

    return Z_SUCC;    
}

/**************************************************************************
: zAti_SmsPcmgsReq
: յATI ϢAP_MMIA_SMS_PcmgsReq
    : pBuff,ָϢAP_MMIA_SMS_PcmgsReqϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣPDUģʽֱӷͶϢ,PDUTPMR
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
2009.7.18       ӶNVݵĲμ죬εsca
617001738758 [ati]AT޸ĵ
***************************************************************************/
DWORD zAti_SmsPcmgsReq(VOID* pBuff)
{
    T_zApMmia_SmsPcmgs_Req* ptPcmgsReq = (T_zApMmia_SmsPcmgs_Req*)pBuff;
    T_zMmiaSms_SubmitSend_Req* ptSmsSubmitReq = ZOSS_NULL;
    T_z_UICC_Smss tEFsmss = {0};
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    DWORD   dwCmdRlt    = 0;

    zAti_MarkIndex(ptPcmgsReq, Z_PSMDL_SMS);
    
    if(zAti_PduModeFindTpdaAndScaInStm(ptPcmgsReq->abPduBuf, Z_ATI_SMSTYPE_SUB) == Z_INVALID)
    {
        return Z_APMMIA_CMSOPTNOTALLOW_ERR;
    }

    dwCmdRlt = zAti_ReadItem(Z_UiccId_SMSS_BIN, 1, 1, (VOID *)&tEFsmss);
    if (Z_APUICC_CMD_OK != dwCmdRlt)
    {
        return zAti_GETCMSERR(dwCmdRlt);
    }
    
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
    
    ptSmsSubmitReq = (T_zMmiaSms_SubmitSend_Req*)zAti_GetUB(sizeof(T_zMmiaSms_SubmitSend_Req));   
    ptSmsSubmitReq->bPduLength = zAti_ConstructTransBuf(ptSmsSubmitReq->abPduBuffer, ptPcmgsReq->abPduBuf, ptPcmgsReq->bTpduLength);
    ptSmsSubmitReq->bSrcIndex       = ptPcmgsReq->bSrcIndex;
    ptSmsSubmitReq->bDestIndex      = ptPcmgsReq->bDestIndex;
    ptSmsSubmitReq->bMsgSendType    = Z_MMIASMS_DIRECT_SUBMIT_SEND;/* ֱӷ */
    ptSmsSubmitReq->bTpMsgRef       = tEFsmss.bLastUsedTpmr + 1;
    ptSmsSubmitReq->bLinkStatus     = tAtData.bCmmsSet;
    ptSmsSubmitReq->bSmsService     = tAtData.bCgsmsSvc;
    ptSmsSubmitReq->bIsEwalk        = (g_zAti_ptData->bEModeType == 0)? Z_VALID : Z_INVALID;

    if (Z_FAIL == zAti_CheckPduTpudl(ptSmsSubmitReq->abPduBuffer, ptSmsSubmitReq->bPduLength))
    {
        zAti_RetUB((VOID **)&ptSmsSubmitReq);
        zAti_SendExpt2TraceAgt(ERR_MMIA_InvalidPdu,  TRACE_ERR_LEVEL_NORMAL,"");
        return Z_APMMIA_CMSINVALIDPDUPARA_ERR;
    }
    
    if (Z_SUCC != zAti_MsgSend(MMIA_SMS_SUBMIT_SEND_REQ_EV,(PBYTE)ptSmsSubmitReq,sizeof(T_zMmiaSms_SubmitSend_Req),Z_ATI_TASKID_SMS))
    {
        return zAti_GETCMSERR(Z_APMMIA_OPTNOTALW_ERR);
    }
    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_SmsPcmgwReq
: յATI ϢAP_MMIA_SMS_PcmgwReq
    : pBuff,ָϢAP_MMIA_SMS_PcmgwReqϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ͣPDUģʽ洢дϢ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
***************************************************************************/
DWORD zAti_SmsPcmgwReq(VOID* pBuff)
{
    T_zApMmia_SmsPcmgw_Req*  ptPcmgwReq  = ZOSS_NULL;
    T_zApMmia_SaveSm_Req*    ptPbSaveReq = ZOSS_NULL;

    ptPcmgwReq = (T_zApMmia_SmsPcmgw_Req*)pBuff; 

    zAti_MarkIndex(ptPcmgwReq, Z_PSMDL_SMS);
    
    ptPbSaveReq = (T_zApMmia_SaveSm_Req*)zAti_GetUB(sizeof(T_zApMmia_SaveSm_Req));
    ptPbSaveReq->bSrcIndex = ptPcmgwReq->bSrcIndex;
    ptPbSaveReq->bDesIndex = ptPcmgwReq->bDestIndex;
    ptPbSaveReq->bSaveFlag = Z_APMMIA_SMSAVEFLAG_UPREQUEST;    
    ptPbSaveReq->bMsgStatus = ptPcmgwReq->bMsgStatVal;
    ptPbSaveReq->bTpMsgRef  = Z_ATI_INVALID_BYTE;
    ptPbSaveReq->bMemStyle  = Z_ATI_INVALID_BYTE;
    ptPbSaveReq->dwLen = ptPcmgwReq->bTpduLength + ptPcmgwReq->abPduBuf[0] + 1;
    
    /*ϢPDU*/
    if (ptPbSaveReq->dwLen > 0)
    {
        ptPbSaveReq->pbMsg = (PBYTE)zAti_GetUB(ptPbSaveReq->dwLen);
        zOss_Memcpy(ptPbSaveReq->pbMsg, ptPcmgwReq->abPduBuf, ptPbSaveReq->dwLen);
    }
    
    zAti_MsgSend(AP_MMIA_SM_SAVE_REQ_EV,
        (PBYTE)ptPbSaveReq,
        sizeof(T_zApMmia_SaveSm_Req),
        Z_ATI_TASKID_PB);

    return Z_APMMIA_NORESULT;
}

/**************************************************************************
: zAti_SmsPcmgcReq
: յATIϢAP_MMIA_SMS_PcmgcReq
    : pBuff,ָϢAP_MMIA_SMS_PcmgcReqϢ
    
    أZ_ATI_NOERROR_ERR       
Z_ATI_MALLOCFAILED_ERR  ڴʧ
Z_ATI_RECNULLMSG        յϢ(ӦΪ)
Z_ATI_NOERRORED_ERR Ϣʧ
ע    ֱͣӷϢ,TPMR
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ
617001738758 [ati]AT޸ĵ
***************************************************************************/
DWORD zAti_SmsPcmgcReq(VOID* pBuff)
{
    T_zApMmia_SmsPcmgc_Req* ptPcmgcReq = (T_zApMmia_SmsPcmgc_Req*)pBuff;
    T_zMmiaSms_CommandSend_Req* ptSmsCmdReq = ZOSS_NULL;
    T_z_UICC_Smss tEFsmss = {0};
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    DWORD   dwCmdRlt    = 0;

    zAti_MarkIndex(ptPcmgcReq, Z_PSMDL_SMS);
    
    if (zAti_PduModeFindTpdaAndScaInStm(ptPcmgcReq->abPduBuf, Z_ATI_SMSTYPE_CMD) == Z_INVALID)
    {
        return Z_APMMIA_CMSOPTNOTALLOW_ERR;
    }

    dwCmdRlt = zAti_ReadItem(Z_UiccId_SMSS_BIN, 1, 1, (VOID *)&tEFsmss);
    if (Z_APUICC_CMD_OK != dwCmdRlt)
    {
        return zAti_GETCMSERR(dwCmdRlt);
    }

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    ptSmsCmdReq = (T_zMmiaSms_CommandSend_Req*)zAti_GetUB(sizeof(T_zMmiaSms_CommandSend_Req));

    ptSmsCmdReq->bPduLength = zAti_ConstructTransBuf(ptSmsCmdReq->abPduBuffer, ptPcmgcReq->abPduBuf, ptPcmgcReq->bTpduLength);
    ptSmsCmdReq->bSrcIndex = ptPcmgcReq->bSrcIndex;
    ptSmsCmdReq->bDestIndex = ptPcmgcReq->bDestIndex;
    ptSmsCmdReq->bMsgSendType = Z_MMIASMS_DIRECT_COMMAND_SEND; /* ֱӷCMDϢ */
    ptSmsCmdReq->bTpMsgRef = tEFsmss.bLastUsedTpmr + 1; /* µtpmr */
    ptSmsCmdReq->bLinkStatus = tAtData.bCmmsSet;
    ptSmsCmdReq->bSmsService = tAtData.bCgsmsSvc;
    ptSmsCmdReq->bIsEwalk    = (g_zAti_ptData->bEModeType == 0)? Z_VALID : Z_INVALID;

    if (Z_SUCC != zAti_MsgSend(MMIA_SMS_COMMAND_SEND_REQ_EV,(PBYTE)ptSmsCmdReq,sizeof(T_zMmiaSms_CommandSend_Req),Z_ATI_TASKID_SMS))
    {
        return zAti_GETCMSERR(Z_APMMIA_OPTNOTALW_ERR);
    }
    return Z_APMMIA_NORESULT;
}

BYTE zAti_GetTdRssi(BYTE bRxlev)
{
    return (bRxlev + 100);
}

BYTE zAti_GetTdNewPowerLevel(BYTE bRxlev)
{
    BYTE i = 0;
    T_zAti_NV_TdSignalboxCfg tTdSigCfg = {0};
    T_zAti_NV_TdSignalboxCfg *ptTdSigCfg = ZOSS_NULL;
    ptTdSigCfg = &tTdSigCfg;

    zDev_NV_AtiReadItem(Z_ATI_NV_TdSignalboxCfg, (PBYTE)ptTdSigCfg);
    /*ֵ߽С-115dmb迼*/
    if(ptTdSigCfg->bEndpoint == 1)/*պϵźǿСһ*/
    {
        for(i = 0; i < ptTdSigCfg->bStepNum; i++)
        {
            if(bRxlev >= (116-ptTdSigCfg->abRssi[(ptTdSigCfg->bStepNum -1)-i]))
            {
                continue;
            }
            break;
        }
    }
    else/*պϵźǿȴһ*/
    {
        for(i = 0; i < ptTdSigCfg->bStepNum; i++)
        {
            if(bRxlev > (116-ptTdSigCfg->abRssi[(ptTdSigCfg->bStepNum -1)-i]))
            {
                continue;
            }
            break;
        }
    }

    return i;

}

BYTE zAti_GetWNewPowerLevel(BYTE bRxlev)
{
    BYTE i = 0;
    T_zAti_NV_WSignalboxCfg *ptWSigCfg = ZOSS_NULL;
    T_zAti_NV_WSignalboxCfg tWSigCfg = {0};
    ptWSigCfg = &tWSigCfg;

    zDev_NV_AtiReadItem(Z_ATI_NV_WSignalboxCfg, (PBYTE)ptWSigCfg);
    /*ֵ߽С-115dmb迼*/
    if(ptWSigCfg->bEndpoint == 1)/*պϵźǿСһ*/
    {
        for(i = 0; i < ptWSigCfg->bStepNum; i++)
        {
            if(bRxlev >= (116-ptWSigCfg->abRssi[(ptWSigCfg->bStepNum -1)-i]))
            {
                continue;
            }
            break;
        }
    }
    else/*պϵźǿȴһ*/
    {
        for(i = 0; i < ptWSigCfg->bStepNum; i++)
        {
            if(bRxlev > (116-ptWSigCfg->abRssi[(ptWSigCfg->bStepNum -1)-i]))
            {
                continue;
            }
            break;
        }
    }

    return i;

}

BYTE zAti_GetLteNewPowerLevel(BYTE bRxlev)
{
    BYTE i = 0;
    T_zAti_NV_LteSignalboxCfg *ptLteSigCfg = ZOSS_NULL;
    T_zAti_NV_LteSignalboxCfg tLteSigCfg = {0};
    ptLteSigCfg = &tLteSigCfg;

    zDev_NV_AtiReadItem(Z_ATI_NV_LteSignalboxCfg, (PBYTE)ptLteSigCfg);
    /*ֵ߽С-140dmb迼*/
    if(ptLteSigCfg->bEndpoint == 1)/*պϵźǿСһ*/
    {
        for(i = 0; i < ptLteSigCfg->bStepNum; i++)
        {
            if(bRxlev >= (141-ptLteSigCfg->abRssi[(ptLteSigCfg->bStepNum -1)-i]))
            {
                continue;
            }
            break;
        }
    }
    else/*պϵźǿȴһ*/
    {
        for(i = 0; i < ptLteSigCfg->bStepNum; i++)
        {
            if(bRxlev > (141-ptLteSigCfg->abRssi[(ptLteSigCfg->bStepNum -1)-i]))
            {
                continue;
            }
            break;
        }
    }

    return i;
}

BYTE zAti_IsTdPowerLevelChng(BYTE bRxlev)
{
    BYTE bCurIns = g_zAti_CurInstance;
    BYTE bNewPowerLevel = zAti_GetTdNewPowerLevel(bRxlev);
    BYTE bCurAct = zAti_GetCurAct_ByIndex(bCurIns);

    if (g_zAti_atDataEx[g_zAti_CurInstance].bPreAct != bCurAct || bNewPowerLevel != g_zAti_atDataEx[g_zAti_CurInstance].bPreLevel)
    {
        g_zAti_atDataEx[g_zAti_CurInstance].bPreAct = bCurAct;
        g_zAti_atDataEx[g_zAti_CurInstance].bPreLevel = bNewPowerLevel;
        return Z_VALID;
    }

    return Z_INVALID;
}

BYTE zAti_IsWPowerLevelChng(BYTE bRxlev)
{
    BYTE bCurIns = g_zAti_CurInstance;
    BYTE bNewPowerLevel = zAti_GetWNewPowerLevel(bRxlev);
    BYTE bCurAct = zAti_GetCurAct_ByIndex(bCurIns);

    if (g_zAti_atDataEx[g_zAti_CurInstance].bPreAct != bCurAct || bNewPowerLevel != g_zAti_atDataEx[g_zAti_CurInstance].bPreLevel)
    {
        g_zAti_atDataEx[g_zAti_CurInstance].bPreAct = bCurAct;
        g_zAti_atDataEx[g_zAti_CurInstance].bPreLevel = bNewPowerLevel;
        return Z_VALID;
    }

    return Z_INVALID;
}

BYTE zAti_IsLtePowerLevelChng(BYTE bRxlev)
{
    BYTE bCurIns = g_zAti_CurInstance;
    BYTE bNewPowerLevel = zAti_GetLteNewPowerLevel(bRxlev);
    BYTE bCurAct = zAti_GetCurAct_ByIndex(bCurIns);

    if (g_zAti_atDataEx[g_zAti_CurInstance].bPreAct != bCurAct || bNewPowerLevel != g_zAti_atDataEx[g_zAti_CurInstance].bPreLevel)
    {
        g_zAti_atDataEx[g_zAti_CurInstance].bPreAct = bCurAct;
        g_zAti_atDataEx[g_zAti_CurInstance].bPreLevel = bNewPowerLevel;
        return Z_VALID;
    }

    return Z_INVALID;
}

BYTE zAti_ZsqrInvalidRxlevProc(BYTE *pbRxlev, BYTE *pbAct)
{
    BYTE bRegState = zAti_GetRegState();

    switch(bRegState)
    {
        case Z_ATI_REGSTATE_SEARCH:    /**/
            return Z_VALID;

        case Z_ATI_REGSTATE_NORMAL:     /*פ*/
            return Z_INVALID;
            
        case Z_ATI_REGSTATE_NOSERVE:         /*no cell*/  
        default:
            *pbRxlev = 0;
            *pbAct = Z_APMMIA_NOSERVE;
            return Z_VALID;
    }
}
/************************************************************************
: zAti_McrRptRxlevInd
: 
    : pBuff,
    
    أZ_MMIA_NOERROR_ERR    
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ     
09.03                                                                        
************************************************************************/
VOID zAti_McrRptRxlevInd(VOID* pBuff)
{
    BYTE bRssi = 0;
    BYTE bBler  = 0;
    T_zMmiaAs_RptRxlev_Ind*  ptAsInd = ZOSS_NULL;
    T_zApMmia_ZRptRxlev_Ind*     ptApInd = ZOSS_NULL;
    ZOSS_TASK_ID tTaskId = zOss_Sender();
    BYTE flag = Z_INVALID;
    BYTE bAct = 0xff;

    if (Z_ATI_RptRxlev_DISABLE == g_zAti_atDataEx[g_zAti_CurInstance].bZsqrSet)
    {
        return;
    }

    ptAsInd = (T_zMmiaAs_RptRxlev_Ind*)pBuff;

    bRssi = zAti_GetTdRssi(ptAsInd->bRxlev);

    if(ptAsInd->bRxlev == 99)/*ATIЧֵ99ЧֵAS֤*/
    {
        /*źֵΪ99ʱǰפ
        ͵ǰפδʱű*/
        if (Z_VALID == zAti_ZsqrInvalidRxlevProc(&ptAsInd->bRxlev, &bAct))
        {
            g_zAti_atDataEx[g_zAti_CurInstance].bPreLevel = 0xff;
            bRssi = zAti_GetTdRssi(ptAsInd->bRxlev);
            bAct = Z_APMMIA_NOSERVE;
            flag = Z_VALID;
        }
    }
    else
    {
        if (tTaskId == zDev_GetTaskId(Z_ATI_TASKID_EUMCR, 0) ||tTaskId == zDev_GetTaskId(Z_ATI_TASKID_EUMCR, 1))
        {
            flag = zAti_IsLtePowerLevelChng(ptAsInd->bRxlev);
            bAct = Z_APMMIA_LTE;
        }
        else if(tTaskId == zDev_GetTaskId(Z_ATI_TASKID_WMCR, 0) ||tTaskId == zDev_GetTaskId(Z_ATI_TASKID_WMCR, 1))
        {
            flag = zAti_IsWPowerLevelChng(ptAsInd->bRxlev);
            bAct = Z_APMMIA_WCDMA;
        }
        else //MCR
        {
            flag = zAti_IsTdPowerLevelChng(ptAsInd->bRxlev);
            bAct = Z_APMMIA_TDSCDMA;
        }
    }

    if (flag == Z_VALID)
    {
        bBler = (ptAsInd->bBlerFlg == Z_VALID)? ptAsInd->bBler : 99;
        ptApInd = zAti_CreateZRptRxlevIndMsg(0xfe, 0xff, bRssi, bBler, bAct);
        zAti_RecvServerHandlerSlaver(AP_MMIA_ZRPT_RXLEVIND_EV, (UINT8 *)ptApInd, sizeof(T_zApMmia_ZRptRxlev_Ind));
    }
}
BOOL __ps_2g_func zAti_IsNeedAdjustBordeRssi(BYTE bRxlev, PBYTE pbNewbRxlev)
{
    BYTE i = 0;
    T_zAti_NV_GsmSignalboxCfg *ptGsmSigCfg = ZOSS_NULL;
    T_zAti_NV_GsmSignalboxCfg tGsmSigCfg = {0};
    ptGsmSigCfg = &tGsmSigCfg;
    zDev_NV_AtiReadItem(Z_ATI_NV_GsmSignalboxCfg, (PBYTE)ptGsmSigCfg);
    /*-110dmbΪźűֵֻ߽bEndpoint == 2ʱ
      ǰһٽΪ-109dmbRSSIֵΪ2ʱ򣬲Ҫֵ߽
      ˣСڵ-110dmb迼.Σ
      -51dmbΪֵ߽迼*/
    if(ptGsmSigCfg->bEndpoint == 1)
    {
        for(i = 0; i<ptGsmSigCfg->bStepNum; i++)
        {
            if(bRxlev == 110 - ptGsmSigCfg->abRssi[i])
            {
                if(((bRxlev + 1) / 2 + 1) == ((bRxlev) / 2 + 1))
                {
                    *pbNewbRxlev = (bRxlev + 1 + 1) / 2 + 1;
                    return TRUE;
                }
            }
        }
    }
    else if(ptGsmSigCfg->bEndpoint == 2) //պϵźǿȴһ
    {
        for(i = 0; i<ptGsmSigCfg->bStepNum; i++)
        {
            if(bRxlev == 110 - ptGsmSigCfg->abRssi[i])
            {
                if(bRxlev == 1) //-109dmb
                {
                    *pbNewbRxlev = 0;
                    return TRUE;
                }
                if(((bRxlev + 1) / 2 + 1) == ((bRxlev + 1+1) / 2 + 1))
                {
                    *pbNewbRxlev = (bRxlev) / 2 + 1;
                    return TRUE;
                }
            }
        }
    }
    return FALSE;
}
BYTE __ps_2g_func zAti_GetGsmRssi(BYTE bRxlev)
{
    BYTE bNewbRxlev = 0;
    if (bRxlev == 99)
    {
        return bRxlev;
    }
    else if (bRxlev >= 59)//617001820986   ATIϱźǿ㷨27007ܶӦ
    {
        return 31;
    }
    else if (bRxlev > 0)
    {
        if(zAti_IsNeedAdjustBordeRssi(bRxlev, &bNewbRxlev))
        {
            return bNewbRxlev;
        }
        return ((bRxlev + 1) / 2 + 1);
    }
    else  //0
    {
        return bRxlev;
    }
}

BYTE zAti_GetGsmNewPowerLevel(BYTE bRxlev)
{
    BYTE i = 0;
    T_zAti_NV_GsmSignalboxCfg *ptGsmSigCfg = ZOSS_NULL;
    T_zAti_NV_GsmSignalboxCfg tGsmSigCfg = {0};
    ptGsmSigCfg = &tGsmSigCfg;
    zDev_NV_AtiReadItem(Z_ATI_NV_GsmSignalboxCfg, (PBYTE)ptGsmSigCfg);

    if(ptGsmSigCfg->bEndpoint == 1)/*պϵźǿСһ*/
    {
        for(i = 0; i < ptGsmSigCfg->bStepNum; i++)
        {
            BYTE bRssi = 0;
            if(ptGsmSigCfg->abRssi[(ptGsmSigCfg->bStepNum -1)-i] < 110)
            {
                bRssi = 110 -ptGsmSigCfg->abRssi[(ptGsmSigCfg->bStepNum -1)-i];
            }
            if(bRxlev >= bRssi)
            {
                continue;
            }
            break;
        }
    }
    else/*պϵźǿȴһ*/
    {
        for(i = 0; i < ptGsmSigCfg->bStepNum; i++)
        {
            BYTE bRssi = 0;
            if(ptGsmSigCfg->abRssi[(ptGsmSigCfg->bStepNum -1)-i] < 110)
            {
                bRssi = 110 -ptGsmSigCfg->abRssi[(ptGsmSigCfg->bStepNum -1)-i];
            }
            if(bRxlev > bRssi)
            {
                continue;
            }
            break;
        }
    }

    return i;
}

BYTE zAti_IsGsmPowerLevelChng(BYTE bRxlev)
{
    BYTE bNewPowerLevel = 0xff;

    if(bRxlev == 99)/*ATIЧֵ99ЧֵAS֤*/
    {
        g_zAti_atDataEx[g_zAti_CurInstance].bPreLevel = 0xff;
        return Z_VALID;
    }
    bNewPowerLevel = zAti_GetGsmNewPowerLevel(bRxlev);

    if (g_zAti_atDataEx[g_zAti_CurInstance].bPreAct != Z_GSM_ACT || bNewPowerLevel != g_zAti_atDataEx[g_zAti_CurInstance].bPreLevel)
    {
        g_zAti_atDataEx[g_zAti_CurInstance].bPreAct = Z_GSM_ACT;
        g_zAti_atDataEx[g_zAti_CurInstance].bPreLevel = bNewPowerLevel;
        return Z_VALID;
    }

    return Z_INVALID;
}


/************************************************************************
: zAti_GrrRptRxlevInd
: 
    : pBuff,
    
    أZ_MMIA_NOERROR_ERR    
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ     
09.03                                                                        
************************************************************************/
VOID zAti_GrrRptRxlevInd(VOID* pBuff)
{
    BYTE bRssi = 0;
    BYTE bBler = 0;
    BYTE bAct = 0xff;
    T_zMmiaAs_RptRxlev_Ind*  ptAsInd = (T_zMmiaAs_RptRxlev_Ind*)pBuff;
    T_zApMmia_ZRptRxlev_Ind*     ptApInd = ZOSS_NULL;
    BYTE flag = Z_INVALID;

    if (Z_ATI_RptRxlev_DISABLE == g_zAti_atDataEx[g_zAti_CurInstance].bZsqrSet)
    {
        return ;
    }

    if ((ptAsInd->bRxlev > 99) ||
        ((ptAsInd->bRxlev < 99) && (ptAsInd->bRxlev > 63)))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                       
        return ;
    }
    /*Чֵ99ʱʽͳһNOSERVE*/
    if(ptAsInd->bRxlev == 99)
    {
        /*źֵΪ99ʱǰפ
        ͵ǰפδʱű*/
        if (Z_VALID == zAti_ZsqrInvalidRxlevProc(&ptAsInd->bRxlev, &bAct))
        {
            g_zAti_atDataEx[g_zAti_CurInstance].bPreLevel = 0xff;
            bAct = Z_APMMIA_NOSERVE;
            flag = Z_VALID;
        }
    }
    else
    {
        flag = zAti_IsGsmPowerLevelChng(ptAsInd->bRxlev);
        bAct = Z_APMMIA_GSMGPRS;
    }

    bRssi = zAti_GetGsmRssi(ptAsInd->bRxlev);
    if (flag == Z_VALID)
    {
        bBler = (ptAsInd->bBlerFlg == Z_VALID)? ptAsInd->bBler : 99;
        ptApInd = zAti_CreateZRptRxlevIndMsg(0xfe, 0xff, bRssi, bBler, bAct);
        zAti_RecvServerHandlerSlaver(AP_MMIA_ZRPT_RXLEVIND_EV, (UINT8 *)ptApInd, sizeof(T_zApMmia_ZRptRxlev_Ind));
    }
}

BYTE zAti_RxlevProc(BYTE *pbRxlev, BYTE *pbAct)
{
    BYTE bRegState = zAti_GetRegState();

    switch(bRegState)
    {
        case Z_ATI_REGSTATE_SEARCH:    /**/
            return Z_INVALID;

        case Z_ATI_REGSTATE_NORMAL:     /*פ*/
            *pbRxlev = g_zAti_atDataEx[g_zAti_CurInstance].bPreRxlev;
            *pbAct = g_zAti_atDataEx[g_zAti_CurInstance].bPreCsqAct;
            return Z_VALID;
            
        case Z_ATI_REGSTATE_NOSERVE:         /*no cell*/  
        default:
            *pbRxlev = 0;
            *pbAct = Z_APMMIA_NOSERVE;
            return Z_VALID;
    }
}
/************************************************************************
: zAti_McrRptRxlevCnf
: MCRѯʱϱźǿ (Z_MmiaAs_QueryRxlev_Cnf_Ev)
          
    : pBuff,
    
    أZ_MMIA_NOERROR_ERR    
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ     
09.03                                                                        
************************************************************************/
VOID __ps_comm_func zAti_McrRptRxlevCnf(VOID* pBuff)
{
    ZOSS_TASK_ID tTaskId = zOss_Sender();
    T_zMmiaAs_RptRxlev_Ind*  ptAsRptRxlevInd = (T_zMmiaAs_RptRxlev_Ind*)pBuff;
    T_zApMmia_Rxlev_Cnf*    ptApRxlevCnf = (T_zApMmia_Rxlev_Cnf*)zAti_GetUB(sizeof(T_zApMmia_Rxlev_Cnf));
    BYTE bRxlev = 0;
    BYTE bAct = Z_APMMIA_NOSERVE;

    ptApRxlevCnf->bSrcIndex = ptAsRptRxlevInd->bSrcIndex;
    ptApRxlevCnf->bDesIndex = ptAsRptRxlevInd->bDesIndex;
    ptApRxlevCnf->bRssi     = ptAsRptRxlevInd->bRxlev + 100;

    if (Z_VALID == ptAsRptRxlevInd->bBlerFlg)
    {
        ptApRxlevCnf->bBler = ptAsRptRxlevInd->bBler;
    }
    else
    {
        ptApRxlevCnf->bBler = 99;
    }
    /*źֵΪ99ʱǰפϱʷֵ+ʽ
    ǰפֱӱ
    ǰפδ0*/
    if(ptAsRptRxlevInd->bRxlev == 99)
    {
        ptApRxlevCnf->bAct = Z_APMMIA_NOSERVE;
        if (Z_VALID == zAti_RxlevProc(&bRxlev, &bAct))
        {
            ptApRxlevCnf->bRssi = bRxlev + 100;
            ptApRxlevCnf->bAct = bAct;
        }
    }
    else
    {
        if(tTaskId == zDev_GetTaskId(Z_ATI_TASKID_EUMCR, 0) || tTaskId == zDev_GetTaskId(Z_ATI_TASKID_EUMCR, 1))
        {
            ptApRxlevCnf->bAct = Z_APMMIA_LTE;
        }
        else if(tTaskId == zDev_GetTaskId(Z_ATI_TASKID_WMCR, 0) || tTaskId == zDev_GetTaskId(Z_ATI_TASKID_WMCR, 1))
        {
            ptApRxlevCnf->bAct = Z_APMMIA_WCDMA;
        }
        else //MCR
        {
            ptApRxlevCnf->bAct = Z_APMMIA_TDSCDMA;
        }
        g_zAti_atDataEx[g_zAti_CurInstance].bPreRxlev = ptAsRptRxlevInd->bRxlev;
        g_zAti_atDataEx[g_zAti_CurInstance].bPreCsqAct = ptApRxlevCnf->bAct;
    }
    zAti_RecvServerHandlerSlaver(AP_MMIA_RXLEV_CNF_EV, (UINT8 *)ptApRxlevCnf, sizeof(T_zApMmia_Rxlev_Cnf));
}

/************************************************************************
: zAti_GrrRptRxlevCnf
: 
          GRRѯʱϱźǿ (RRAT_RXSTAT_IND)
    : pBuff,
    
    أZ_MMIA_NOERROR_ERR    
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ     
09.03                                                                        
************************************************************************/
VOID __ps_2g_func zAti_GrrRptRxlevCnf(VOID* pBuff)
{
    T_zMmiaAs_RptRxlev_Ind* ptAsRptRxlevInd  = (T_zMmiaAs_RptRxlev_Ind*)pBuff;
    T_zApMmia_Rxlev_Cnf* ptApRxlevCnf     = ZOSS_NULL;
    BYTE bAct = 0xff;

    if ((ptAsRptRxlevInd->bRxlev > 99) ||((ptAsRptRxlevInd->bRxlev < 99) && (ptAsRptRxlevInd->bRxlev > 63)))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                       
        return ;
    }

    /*Чֵ99ʱʽͳһNOSERVE*/
    if(ptAsRptRxlevInd->bRxlev == 99)
    {
        bAct = Z_APMMIA_NOSERVE;
        zAti_RxlevProc(&ptAsRptRxlevInd->bRxlev, &bAct);   
    }
    else
    {
        bAct = Z_APMMIA_GSMGPRS;
        g_zAti_atDataEx[g_zAti_CurInstance].bPreRxlev = ptAsRptRxlevInd->bRxlev;
        g_zAti_atDataEx[g_zAti_CurInstance].bPreCsqAct = bAct;
    }

    ptApRxlevCnf = (T_zApMmia_Rxlev_Cnf*)zAti_CreateZRptRxlevIndMsg(
        ptAsRptRxlevInd->bSrcIndex,
        ptAsRptRxlevInd->bDesIndex,
        zAti_GetGsmRssi(ptAsRptRxlevInd->bRxlev), 
         (BYTE)((ptAsRptRxlevInd->bBlerFlg == Z_VALID)? ptAsRptRxlevInd->bBler : 99),bAct);

    zAti_RecvServerHandlerSlaver(AP_MMIA_RXLEV_CNF_EV, (UINT8 *)ptApRxlevCnf, sizeof(T_zApMmia_Rxlev_Cnf));
}
VOID zAti_HandleUlParaInd(VOID* pBuff)
{
    T_zAtiAs_UlParamInd *pUlPara = (T_zAtiAs_UlParamInd*)pBuff;

    if(g_zAti_atDataEx[g_zAti_CurInstance].dwUlRtTime > 0)
    {
        g_zAti_atDataEx[g_zAti_CurInstance].tUlParamInd.dwMCS = pUlPara->dwMCS;
        g_zAti_atDataEx[g_zAti_CurInstance].tUlParamInd.dwAckCnt += pUlPara->dwAckCnt;
        g_zAti_atDataEx[g_zAti_CurInstance].tUlParamInd.dwNackCnt += pUlPara->dwNackCnt;
        g_zAti_atDataEx[g_zAti_CurInstance].tUlParamInd.dwBSR = pUlPara->dwBSR;
        g_zAti_atDataEx[g_zAti_CurInstance].tUlParamInd.dwTBS += pUlPara->dwTBS;
    }
}
#ifdef USE_VOICE_SUPPORT
/***************************************************************************
:   zPS_mmia_ZcfisSetReq
:  pBuff
pbBuff      Ϣָ
:  CommonCnf
ǰ:
:
***************************************************************************/
DWORD zAti_ZcfisSetReq(VOID *pBuff)
{
    T_zApMmia_ZcfisSet_Req *ptZcfisSetReq = (T_zApMmia_ZcfisSet_Req *)pBuff;
    T_z_UICC_Cfis          tCfis          = {0};

   // if (ptZcfisSetReq->bIndex != 1 ||
   //     ptZcfisSetReq->bMode > Z_APMMIA_ZCFIS_QUERY_MODE)
   // {
   //     return Z_APMMIA_INVALIDPARA_ERR;
   // }

    if (ptZcfisSetReq->bMode == Z_APMMIA_ZCFIS_QUERY_MODE)
    {
        return zAti_UiccReadReq(Z_APUICC_KEYID_CFIS, ptZcfisSetReq->bIndex, ptZcfisSetReq->bSrcIndex, ptZcfisSetReq->bDesIndex);
    }
    else
    {
        tCfis.bMspNum = 1;    /* ¼ļԾڵһ¼м¼CFϢԶļĶдֻǵһ¼*/
        tCfis.bCfuIndStatus = ptZcfisSetReq->bCfuIndStatus;
        tCfis.bBcdSscLen = ptZcfisSetReq->bBcdSscLen;
        zOss_Memset(tCfis.abDiallNum, 0xff, Z_APMMIA_ZCFIS_DIALL_MAX_NUM);
        if (ptZcfisSetReq->bBcdSscLen)
        {
            tCfis.bTonNpi = ptZcfisSetReq->bTonNpi;
            zOss_Memcpy(tCfis.abDiallNum, ptZcfisSetReq->abDiallNum, ptZcfisSetReq->bBcdSscLen);
        }
        return zAti_UiccUpdateReq((VOID *)&tCfis, Z_APUICC_KEYID_CFIS, ptZcfisSetReq->bSrcIndex, ptZcfisSetReq->bDesIndex);
    }
}

/***************************************************************************
:   zPS_mmia_ZcfisSetCnf
:  pBuff
pbBuff      Ϣָ
:  CommonCnf
ǰ:
:
***************************************************************************/
DWORD zAti_ZcfisSetCnf(T_zApUicc_Read_Cnf *pReadCnf)
{
    DWORD dwRet = 0;
    T_z_UICC_Cfis tCfis = {0};
    T_zApMmia_ZcfisSet_Cnf *ptZcfisSetCnf = ZOSS_NULL;

    dwRet = zAti_CopyStrFromUiccVal((VOID *)&tCfis, Z_APUICC_KEYID_CFIS, pReadCnf);
    if (dwRet != Z_APMMIA_NOERROR_ERR)
    {
        return dwRet;
    }

    ptZcfisSetCnf= (T_zApMmia_ZcfisSet_Cnf *)zAti_GetUB(sizeof(T_zApMmia_ZcfisSet_Cnf));
    ptZcfisSetCnf->bSrcIndex = pReadCnf->bSrcIndex;
    ptZcfisSetCnf->bDesIndex = pReadCnf->bDesIndex;
    ptZcfisSetCnf->bCfuIndStatus = tCfis.bCfuIndStatus;
    ptZcfisSetCnf->bBcdSscLen = tCfis.bBcdSscLen;
    zOss_Memset(ptZcfisSetCnf->abDiallNum, 0xff, Z_APMMIA_ZCFIS_DIALL_MAX_NUM);
    if (tCfis.bBcdSscLen)
    {
        ptZcfisSetCnf->bTonNpi = tCfis.bTonNpi;
        zOss_Memcpy(ptZcfisSetCnf->abDiallNum, tCfis.abDiallNum, tCfis.bBcdSscLen);
    }
    zAti_RecvServerHandlerSlaver(AP_MMIA_ZCFIS_SET_CNF_EV, (UINT8 *)ptZcfisSetCnf, sizeof(T_zApMmia_ZcfisSet_Cnf));
    
    return Z_APMMIA_NORESULT;
}

DWORD zAti_UpdateCommonCnf (T_zApUicc_Update_Cnf *ptUpdateCnf)
{
    if (ptUpdateCnf->dwExecuteStatus != Z_APUICC_CMD_OK)
    {
        return ptUpdateCnf->dwExecuteStatus;
    }
    
    return Z_APMMIA_NOERROR_ERR;
}
#endif
/***************************************************************************
:   zMmia_UiccMbauReq
:  pBuff
pbBuff      Ϣָ
:  ptUiccAuthReq
ǰ:
:
***************************************************************************/
DWORD zAti_UiccMbauReq(VOID *pBuff)
{
    T_zApMmia_MbAuth_Req *ptApMbauReq = (T_zApMmia_MbAuth_Req *)pBuff;
    T_zApUicc_Auth_Req *ptUiccAuthReq = (T_zApUicc_Auth_Req *)zAti_GetUB(sizeof(T_zApUicc_Auth_Req));

    ptUiccAuthReq->bSrcIndex = ptApMbauReq->bSrcIndex;
    ptUiccAuthReq->bDesIndex = ptApMbauReq->bDesIndex;
    ptUiccAuthReq->bDomainId = Z_MbauDomain;
    zOss_Memcpy(ptUiccAuthReq->abRand, ptApMbauReq->abRand, Z_APUICC_MAX_LEN_RAND);
    if (ptApMbauReq->bAutnFg == Z_APMMIA_VALID)
    {
        ptUiccAuthReq->bAuthType = Z_APUICC_AUTH_UMTS;
        zOss_Memcpy(ptUiccAuthReq->abAutn, ptApMbauReq->abAutn, Z_APUICC_MAX_LEN_AUTN);
    }
    else
    {
        ptUiccAuthReq->bAuthType = Z_APUICC_AUTH_GSM;
    }
    
    zAti_MsgSend(AP_UICC_AUTH_REQ_EV, (PBYTE)ptUiccAuthReq, sizeof(T_zApUicc_Auth_Req), Z_ATI_TASKID_UICC);
    return Z_APMMIA_NORESULT;
}

VOID zAti_Uicc3GAuthRsp (T_zApMmia_MbAuth_Cnf *ptApMbauCnf, T_zApUicc_Auth_Cnf *ptUiccAuthCnf)
{
    ptApMbauCnf->bUnionId = Z_APMMIA_MBAUTH_UNIONID_3GSUCC;
    zOss_Memcpy(ptApMbauCnf->uAuthRslt.t3GSuccMbAuth.tIk, ptUiccAuthCnf->tIk, sizeof(T_z_IK));
    zOss_Memcpy(ptApMbauCnf->uAuthRslt.t3GSuccMbAuth.tCk, ptUiccAuthCnf->tCk, sizeof(T_z_CK));
    zOss_Memcpy(ptApMbauCnf->uAuthRslt.t3GSuccMbAuth.abRes, ptUiccAuthCnf->abRes, ptUiccAuthCnf->bResLen);
    ptApMbauCnf->uAuthRslt.t3GSuccMbAuth.bResLen = ptUiccAuthCnf->bResLen;
}

VOID zAti_Uicc2GAuthRsp (T_zApMmia_MbAuth_Cnf *ptApMbauCnf, T_zApUicc_Auth_Cnf *ptUiccAuthCnf)
{
    ptApMbauCnf->bUnionId = Z_APMMIA_MBAUTH_UNIONID_2GSUCC;
    zOss_Memcpy(ptApMbauCnf->uAuthRslt.t2GmbAuth.abKc, ptUiccAuthCnf->abKc, Z_APMMIA_MAX_LEN_KC);
    zOss_Memcpy(ptApMbauCnf->uAuthRslt.t2GmbAuth.abSres, ptUiccAuthCnf->abRes, ptUiccAuthCnf->bResLen);
}

/***************************************************************************
:   zMmia_UiccAuthRsp
:  pBuff
pbBuff      Ϣָ
:  ptApMbauCnf
ǰ:
:
***************************************************************************/
DWORD zAti_UiccAuthRsp(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zApUicc_Auth_Cnf *ptUiccAuthCnf = (T_zApUicc_Auth_Cnf *)pBuff;
    T_zApMmia_MbAuth_Cnf *ptApMbauCnf = ZOSS_NULL;

    if (ptUiccAuthCnf->bResLen == 0 
        || (ptUiccAuthCnf->bAuthType != Z_APUICC_AUTH_UMTS && ptUiccAuthCnf->bAuthType != Z_APUICC_AUTH_GSM)
        || (ptUiccAuthCnf->bAuthType == Z_APUICC_AUTH_UMTS && ptUiccAuthCnf->bResLen > Z_APMMIA_MAX_LEN_RES) 
        || (ptUiccAuthCnf->bAuthType == Z_APUICC_AUTH_GSM && ptUiccAuthCnf->bResLen > Z_APMMIA_MAX_LEN_SRES))
    {        
        return Z_APMMIA_UNKNOWN_ERR;
    }

    ptApMbauCnf = (T_zApMmia_MbAuth_Cnf *)zAti_GetUB(sizeof(T_zApMmia_MbAuth_Cnf));

    ptApMbauCnf->bSrcIndex = ptUiccAuthCnf->bSrcIndex;
    ptApMbauCnf->bDesIndex = ptUiccAuthCnf->bDesIndex;
    ptApMbauCnf->bStatus = Z_APMMIA_MBAUTH_STATUS_SUCC;
    
    switch(ptUiccAuthCnf->bAuthType)
    {
        case Z_APUICC_AUTH_UMTS:
            zAti_Uicc3GAuthRsp(ptApMbauCnf, ptUiccAuthCnf);
            break;

        default: // default߲pclint
        case Z_APUICC_AUTH_GSM:
            zAti_Uicc2GAuthRsp(ptApMbauCnf, ptUiccAuthCnf);
            break;
    }
    
    zAti_RecvServerHandlerSlaver(AP_MMIA_MB_AUTH_CNF_EV, (UINT8 *)ptApMbauCnf, sizeof(T_zApMmia_MbAuth_Cnf));

    return Z_APMMIA_NORESULT;
}

BYTE zAti_UiccAuthFailIndGetStatus(BYTE bFailCause)
{
    switch(bFailCause)
    {
        case Z_APUICC_AUTH_SYNCFAIL:
            return Z_APMMIA_MBAUTH_STATUS_SYNCFAIL;
            
        case Z_APUICC_AUTH_MACFAIL:
            return Z_APMMIA_MBAUTH_STATUS_MACFAIL;
            
        case Z_APUICC_AUTH_GSMAUTHUNACCPT:
            return Z_APMMIA_MBAUTH_STATUS_GSMAUTHUNACCPT;

        default:
            return Z_APMMIA_MBAUTH_STATUS_RESERVE;
    }
}

DWORD zAti_UiccAuthFailProc(T_zApMmia_MbAuth_Cnf *ptApMbauCnf, T_zApUicc_AuthFail_Cnf *ptUiccAuthFailCnf)
{
    switch(ptUiccAuthFailCnf->bFailCause)
    {
        case Z_APUICC_AUTH_SYNCFAIL:
            ptApMbauCnf->bUnionId = Z_APMMIA_MBAUTH_UNIONID_3GSYNCERR;
            ptApMbauCnf->bStatus = zAti_UiccAuthFailIndGetStatus(ptUiccAuthFailCnf->bFailCause);
            zOss_Memcpy(ptApMbauCnf->uAuthRslt.t3GsyncErrMbAuth.abAuts, ptUiccAuthFailCnf->abAuts, Z_APMMIA_MAX_LEN_AUTS);
            break;

        case Z_APUICC_AUTH_MACFAIL:
        case Z_APUICC_AUTH_GSMAUTHUNACCPT:
        case Z_APUICC_AUTH_OTHERFAIL:
            ptApMbauCnf->bUnionId = Z_APMMIA_MBAUTH_UNIONID_VACANT;
            ptApMbauCnf->bStatus = zAti_UiccAuthFailIndGetStatus(ptUiccAuthFailCnf->bFailCause);
            break;

        default:
            return Z_APMMIA_INVALIDPARA_ERR;
    }

    return Z_APMMIA_NOERROR_ERR;
}
/***************************************************************************
:   zMmia_UiccAuthFailInd
:  pBuff
pbBuff      Ϣָ
:  ptApMbauCnf
ǰ:
:
***************************************************************************/
DWORD zAti_UiccAuthFailInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zApUicc_AuthFail_Cnf *ptUiccAuthFailCnf = (T_zApUicc_AuthFail_Cnf *)pBuff;
    T_zApMmia_MbAuth_Cnf *ptApMbauCnf = (T_zApMmia_MbAuth_Cnf *)zAti_GetUB(sizeof(T_zApMmia_MbAuth_Cnf));

    ptApMbauCnf->bSrcIndex = ptUiccAuthFailCnf->bSrcIndex;
    ptApMbauCnf->bDesIndex = ptUiccAuthFailCnf->bDesIndex;
    if (Z_APMMIA_NOERROR_ERR != zAti_UiccAuthFailProc(ptApMbauCnf, ptUiccAuthFailCnf))
    {        
        zAti_RetUB((VOID **)&ptApMbauCnf);
        return Z_APMMIA_UNKNOWN_ERR;
    }    

    zAti_RecvServerHandlerSlaver(AP_MMIA_MB_AUTH_CNF_EV, (UINT8 *)ptApMbauCnf, sizeof(T_zApMmia_MbAuth_Cnf));
    return Z_APMMIA_NORESULT;
}
/***************************************************************************
: zAti_Zpin2Set
: յ^DPIN2
    : pBuff,ָϢAP_UICC_VERIFY_PIN2_REQ_EVϢ
    
    أZ_ATI_NOERROR_ERR       
ע    ͣ617002359777
***************************************************************************/
DWORD zAti_Zpin2Set(VOID* pBuff)
{
    T_zApUicc_VerifyPin2_Req* pZpin2Set = ZOSS_NULL;
    T_zApUicc_VerifyPin2_Req* pUiccZpin2Set = ZOSS_NULL;

    pZpin2Set = (T_zApUicc_VerifyPin2_Req*)pBuff;

    g_zAti_atDataEx[g_zAti_CurInstance].bAtCmd = Z_ATI_AT_CMD_ZPIN2;
    //zAti_SetMsgIndex(pZpin2Set->bSrcIndex, pZpin2Set->bDesIndex,
    //                          Z_ATI_MSGINDEX_ATCMD);

    pUiccZpin2Set = (T_zApUicc_VerifyPin2_Req *)zAti_GetUB(sizeof(T_zApUicc_VerifyPin2_Req));
    zOss_Memcpy(pUiccZpin2Set->abPin, pZpin2Set->abPin, Z_APMMIA_MAX_PIN_LEN);
    pUiccZpin2Set->bSrcIndex = pZpin2Set->bSrcIndex;
    pUiccZpin2Set->bDesIndex = pZpin2Set->bDesIndex;

    zAti_MsgSend(AP_UICC_VERIFY_PIN2_REQ_EV,
                     (PBYTE)pUiccZpin2Set, 
                     sizeof(T_zApUicc_VerifyPin2_Req),
                     Z_ATI_TASKID_UICC);

    return Z_APMMIA_NORESULT;
}
/**************************************************
*:zAt_ZtmgiActiveReq
*:TMGIȥϢַ
*˵:EMBMS
***************************************************/
DWORD zAt_ZtmgiActiveReq(VOID* pBuff)
{
    BYTE bRet = Z_FAIL;
    T_zApMmia_Tmgi_ActDeact_Req *ptTmgiReq = (T_zApMmia_Tmgi_ActDeact_Req*)pBuff;

    if(ptTmgiReq->bType == Z_ATI_TMGI_ACTIVE)
    {
        T_zAtiAs_Tmgi_Activate_Req *ptActiveReq = (T_zAtiAs_Tmgi_Activate_Req*)zAti_GetUB(sizeof(T_zAtiAs_Tmgi_Activate_Req));
        ptActiveReq->bDesIndex = ptTmgiReq->bDesIndex;
        ptActiveReq->bSrcIndex = ptTmgiReq->bSrcIndex;
        zOss_Memcpy(&ptActiveReq->tTmgiActInfo, &ptTmgiReq->tTmgiInfo, sizeof(T_zAtiAs_Mbms_Service_Info));

        bRet = zAti_MsgSend(MMIA_AS_TMGI_ACTIVATE_REQ_EV, (PBYTE)ptActiveReq, sizeof(T_zAtiAs_Tmgi_Activate_Req), Z_ATI_TASKID_EUCER);
    }
    else    //Z_ATI_TMGI_DEACTIVE
    {
        T_zAtiAs_Tmgi_Deactivate_Req *ptDeactReq = (T_zAtiAs_Tmgi_Deactivate_Req*)zAti_GetUB(sizeof(T_zAtiAs_Tmgi_Deactivate_Req));
        ptDeactReq->bDesIndex = ptTmgiReq->bDesIndex;
        ptDeactReq->bSrcIndex = ptTmgiReq->bSrcIndex;
        ptDeactReq->bDeactAll = ptTmgiReq->bDeactAll;
        zOss_Memcpy(&ptDeactReq->tTmgiDeactInfo, &ptTmgiReq->tTmgiInfo, sizeof(T_zAtiAs_Mbms_Service_Info));

        bRet = zAti_MsgSend(MMIA_AS_TMGI_DEACTIVATE_REQ_EV, (PBYTE)ptDeactReq, sizeof(T_zAtiAs_Tmgi_Deactivate_Req), Z_ATI_TASKID_EUCER);
    }

    if(bRet != Z_SUCC)
    {
        return Z_APMMIA_OPTNOTALW_ERR;
    }

    return Z_APMMIA_NORESULT;
}

DWORD zAt_CopnQryReq(VOID* pBuff)
{
    BYTE bInsNo = g_zAti_CurInstance;
    T_zAti_Copn_Query_Req *pQry = (T_zAti_Copn_Query_Req*)pBuff;

    T_zAti_CopnQry_Cnf *pQryCnf = (T_zAti_CopnQry_Cnf*)zAti_GetUB(sizeof(T_zAti_CopnQry_Cnf));

    pQryCnf->bSrcIndex = pQry->bDesIndex;
    pQryCnf->bDesIndex = pQry->bSrcIndex;
    zAti_GetReadCardMutex();
    pQryCnf->bOplPnnTotalNum = g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum;
    zAti_PutReadCardMutex();
    pQryCnf->bNetTotalNum = Z_MAX_NET_OPER_NUM;
    pQryCnf->bMeTotalNum = Z_MAX_ME_OPER_NUM;
    pQryCnf->wGloBalTotalNum = Z_ATI_GLOPLMN_NUM;
    pQryCnf->wMsgId = AP_MMIA_COPN_EXE_CNF;

    zOss_TaskSendData(EV_ZATI2_COPN_CNF, (VOID *)pQryCnf, sizeof(T_zAti_CopnQry_Cnf), g_zAti_Context.taskIdMy);
    return Z_APMMIA_NORESULT;
}
/***************************************************************************
:ϲϢÿ
:
pbBuff      Ϣָ
wMsgLen     Ϣ
: 617001738758 [ati]AT޸ĵ
ǰ:
:
***************************************************************************/
DWORD __ps_static_func zAti_CfunSet(VOID* pBuff)
{
    T_zApMmia_CfunSet_Req    *ptCfunSet     = (T_zApMmia_CfunSet_Req*)pBuff;
    zAti_MarkIndex(ptCfunSet, Z_PSMDL_UMM);

    if (ptCfunSet->bFun == Z_APMMIA_CFUNFUN_CARDPWROFF)
    {
        /* 617001591411 - ܻ*/
        T_zApUicc_ApPwrOff_Req   *ptApPwrOffReq = (T_zApUicc_ApPwrOff_Req *)zAti_GetUB(sizeof(T_zApUicc_ApPwrOff_Req));
        ptApPwrOffReq->bSrcIndex = ptCfunSet->bSrcIndex;
        ptApPwrOffReq->bDesIndex = ptCfunSet->bDesIndex;
        g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunVal = ptCfunSet->bFun;
        zAti_MsgSend(AP_UICC_AP_PWROFF_REQ_EV, (PBYTE)ptApPwrOffReq, sizeof(T_zApUicc_ApPwrOff_Req), Z_ATI_TASKID_UICC);
    }
    else
    {
        if (Z_SUCC != zAti_RfCtrlReq(ptCfunSet->bSrcIndex, ptCfunSet->bDesIndex, ptCfunSet->bFun))
        { 
            return Z_APMMIA_OPTNOTALW_ERR;
        }
    }
    return Z_APMMIA_NORESULT;
}

/***************************************************************************
: zAti_RfCtrlReq
: UMM ͿƵϢ
: 
룺bSrcIndex :ԴDesIndex: Ŀ bCfunMode : Cfun ȡֵ
                
  ֵ: Z_FAIL, Z_SUCC
    : 
ע    : 
***************************************************************************/
BYTE __ps_static_func zAti_RfCtrlReq(BYTE bSrcIndex, BYTE bDesIndex, BYTE bCfunMode)
{
    T_zMmiaUmm_RFControl_Req *ptRfCtrl = (T_zMmiaUmm_RFControl_Req*)zAti_GetUB(sizeof(T_zMmiaUmm_RFControl_Req));
    ptRfCtrl->bSrcIndex = bSrcIndex;
    ptRfCtrl->bDesIndex = bDesIndex;
    /*ʱһSysconfigmode*/
    zDev_NVInit_SysconfigInit();

    /* cfun */ 
    g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunBak = bCfunMode;
    switch (bCfunMode)
    {
    case Z_APMMIA_CFUNFUN_MINIFUN:        
        ptRfCtrl->bState = Z_MmiaUmm_PwrOff;
        break;

    case Z_APMMIA_CFUNFUN_FULLFUN:
        ptRfCtrl->bState = Z_RF_ON;
        zDev_SetSv(g_zAti_CurInstance);
        break;

    case Z_APMMIA_CFUNFUN_DISBOTHRF:
        ptRfCtrl->bState = Z_RF_OFF;
        break;

    default:
        zAti_RetUB((VOID * * )&ptRfCtrl);
        return Z_FAIL;
    }
    return zAti_MsgSend(MMIA_UMM_RF_CTRL_REQ_EV,  (PBYTE)ptRfCtrl, sizeof(T_zMmiaUmm_RFControl_Req),  Z_ATI_TASKID_UMM);
}

DWORD zAti_CesqQryReq(VOID* pBuff)
{
    BYTE bRet = Z_FAIL;
    BYTE bCurAct = zAti_GetCurAct_ByIndex(g_zAti_CurInstance);

    T_zMmiaAs_Cesq_Qry_Req* ptCesqQryReq = (T_zMmiaAs_Cesq_Qry_Req*)pBuff;
    T_zMmiaAs_Cesq_Qry_Req *ptQryReq = (T_zMmiaAs_Cesq_Qry_Req*)zAti_GetUB(sizeof(T_zMmiaAs_Cesq_Qry_Req));

    zOss_Memcpy(ptQryReq, ptCesqQryReq, sizeof(T_zMmiaAs_CellInfo_Qry_Req));

    switch (bCurAct)
    {
        #ifdef PS_RAT_TDD
        case Z_TD_ACT:
            bRet = zAti_MsgSend(MMIA_AS_QUERY_CESQ_REQ_EV, (PBYTE)ptQryReq, sizeof(T_zMmiaAs_Cesq_Qry_Req), Z_ATI_TASKID_MCR);
            break;
        #endif
        #ifdef PS_RAT_FDD
        case Z_W_ACT:
            bRet = zAti_MsgSend(MMIA_AS_QUERY_CESQ_REQ_EV, (PBYTE)ptQryReq, sizeof(T_zMmiaAs_Cesq_Qry_Req), Z_ATI_TASKID_WMCR);
            break;
        #endif

        #ifdef PS_RAT_GSM
        case Z_GSM_ACT:
            bRet = zAti_MsgSend(MMIA_AS_QUERY_CESQ_REQ_EV, (PBYTE)ptQryReq, sizeof(T_zMmiaAs_Cesq_Qry_Req), Z_ATI_TASKID_GRR);
            break;
        #endif
        #ifdef PS_RAT_LTE
        case Z_LTE_ACT:
            bRet = zAti_MsgSend(MMIA_AS_QUERY_CESQ_REQ_EV, (PBYTE)ptQryReq, sizeof(T_zMmiaAs_Cesq_Qry_Req), Z_ATI_TASKID_EUMCR);
            break;
        #endif
        default:
            zAti_RetUB((VOID**)&ptQryReq);
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");  
            return ZAT2_CMEE_GETNOINFO_ERR;
    }

    if(bRet != Z_SUCC)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                        
        return Z_APMMIA_OPTNOTALW_ERR;
    }

    return Z_APMMIA_NORESULT;
}

DWORD zAti_ZlbsReq(VOID* pBuff)
{
    BYTE bRet = Z_FAIL;
    BYTE bCurAct = zAti_GetCurAct_ByIndex(g_zAti_CurInstance);

    T_zMmiaAs_LBS_Req* ptZlbsSetReq = (T_zMmiaAs_LBS_Req*)pBuff;
    T_zMmiaAs_LBS_Req *ptZlbsReq = (T_zMmiaAs_LBS_Req*)zAti_GetUB(sizeof(T_zMmiaAs_LBS_Req));

    zOss_Memcpy(ptZlbsReq, ptZlbsSetReq, sizeof(T_zMmiaAs_LBS_Req));

    switch (bCurAct)
    {
        #ifdef PS_RAT_TDD
        case Z_TD_ACT:
            bRet = zAti_MsgSend(MMIA_AS_LBS_REQ_EV, (PBYTE)ptZlbsReq, sizeof(T_zMmiaAs_LBS_Req), Z_ATI_TASKID_UCSR);
            break;
        #endif
        #ifdef PS_RAT_FDD
        case Z_W_ACT:
            bRet = zAti_MsgSend(MMIA_AS_LBS_REQ_EV, (PBYTE)ptZlbsReq, sizeof(T_zMmiaAs_LBS_Req), Z_ATI_TASKID_WCSR);
            break;
        #endif

        #ifdef PS_RAT_GSM
        case Z_GSM_ACT:
            bRet = zAti_MsgSend(MMIA_AS_LBS_REQ_EV, (PBYTE)ptZlbsReq, sizeof(T_zMmiaAs_LBS_Req), Z_ATI_TASKID_GRR);
            break;
        #endif
        #ifdef PS_RAT_LTE
        case Z_LTE_ACT:
            bRet = zAti_MsgSend(MMIA_AS_LBS_REQ_EV, (PBYTE)ptZlbsReq, sizeof(T_zMmiaAs_LBS_Req), Z_ATI_TASKID_EUCSR);
            break;
        #endif
        default:
            zAti_RetUB((VOID**)&ptZlbsReq);
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");  
            return ZAT2_CMEE_GETNOINFO_ERR;
    }

    if(bRet != Z_SUCC)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                        
        return Z_APMMIA_OPTNOTALW_ERR;
    }
    sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
    return Z_APMMIA_NOERROR_ERR;
}
#ifdef _USE_LPP_ECID
DWORD zAti_SsMolrReq(VOID* pBuff)
{
    T_zMmiaSs_MoLr_Enable_Req *pMolrAtReq = (T_zMmiaSs_MoLr_Enable_Req*)pBuff;
    T_zMmiaSs_MoLr_Enable_Req *pMolrReq = (T_zMmiaSs_MoLr_Enable_Req*)zAti_GetUB(sizeof(T_zMmiaSs_MoLr_Enable_Req));

    zOss_Memcpy(pMolrReq, pMolrAtReq, sizeof(T_zMmiaSs_MoLr_Enable_Req));

    if(pMolrReq->bEnable == Z_ATI_MOLR_ENABLE)
    {
        if (Z_SUCC != zAti_MsgForward(MMIA_SS_MOLR_ENABLE_REQ_EV, (PBYTE)pMolrReq, sizeof(T_zMmiaSs_MoLr_Enable_Req), Z_ATI_TASKID_SS))
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
            zAti_RetUB((VOID * * )&pMolrReq);
            return Z_APMMIA_OPTNOTALW_ERR;
        }
    }
    else
    {
        if (Z_SUCC != zAti_MsgForward(MMIA_SS_MOLR_DISABLE_REQ_EV, (PBYTE)pMolrReq, sizeof(T_zMmiaSs_MoLr_Disable_Req), Z_ATI_TASKID_SS))
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
            zAti_RetUB((VOID * * )&pMolrReq);
            return Z_APMMIA_OPTNOTALW_ERR;
        }
    }
    sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
    return Z_APMMIA_NOERROR_ERR;
}
#endif
#ifdef PS_RAT_LTE
DWORD zAti_ImsDatadelReq(VOID* pBuff)
{
    T_zMmiaEpdcp_DataDel_Req *ptDataDelReq = (T_zMmiaEpdcp_DataDel_Req*)pBuff;
    T_zMmiaEpdcp_DataDel_Req *pSendMsg = ZOSS_NULL;

    pSendMsg = (T_zMmiaEpdcp_DataDel_Req *)zOss_ThreadGetMsgBuf(sizeof(T_zMmiaEpdcp_DataDel_Req));
    if(pSendMsg == NULL)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        return Z_APMMIA_OPTNOTALW_ERR;
    }

    zOss_Memcpy(pSendMsg, ptDataDelReq, sizeof(T_zMmiaEpdcp_DataDel_Req));

    zAti_SendMsgToEpdcp(MMIA_AS_IMS_DATA_DELETE_REQ_EV, (BYTE*)pSendMsg, sizeof(T_zMmiaEpdcp_DataDel_Req));

    sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
    return Z_APMMIA_NOERROR_ERR;
}
#endif
DWORD zAti_SmsTpmrReq(VOID* pBuff)
{
    T_zApMmia_TpmrSet_Req *ptTpmrReq = (T_zApMmia_TpmrSet_Req*)pBuff;
    DWORD dwCmdRlt = 0;
    T_z_UICC_Smss tEFsmss = {0};

    zAti_MarkIndex(ptTpmrReq, Z_PSMDL_SMS);

    dwCmdRlt = zAti_ReadItem(Z_UiccId_SMSS_BIN, 1, 1, (VOID *)&tEFsmss);
    if (Z_APUICC_CMD_OK != dwCmdRlt)
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");                       
        return zAti_GETCMSERR(dwCmdRlt);
    }

    //õֵͿеֱͬӻOK¿
    if (tEFsmss.bLastUsedTpmr == ptTpmrReq->bTpmr)
    {
        sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        return Z_APMMIA_NOERROR_ERR;
    }
    /*tpmr*/
    tEFsmss.bLastUsedTpmr = ptTpmrReq->bTpmr;

    zAti_UiccUpdateItemAndSaveInfo((VOID *)&tEFsmss, sizeof(T_z_UICC_Smss),
        Z_UiccId_SMSS_BIN, Z_ATI_READUICC_SMSS_TPMR, ptTpmrReq->bSrcIndex, ptTpmrReq->bDestIndex);
    return Z_APMMIA_NORESULT;
}
#ifdef DSDS_VSIM
DWORD zAti_CardSwitchReq(VOID* pBuff)
{
    BYTE bIndex = g_zAti_CurInstance;
    T_zMmiaAs_CardSwitch_Req *ptCardSwitch = ZOSS_NULL;
    T_zMmiaAs_CardSwitch_Req *pAtSwitchCard = (T_zMmiaAs_CardSwitch_Req*)pBuff;

    ptCardSwitch = (T_zMmiaAs_CardSwitch_Req*)zAti_GetUB(sizeof(T_zMmiaAs_CardSwitch_Req));

    zOss_Memcpy(ptCardSwitch, pAtSwitchCard, sizeof(T_zMmiaAs_CardSwitch_Req));

    if(ptCardSwitch->bSim1Act == Z_ATI_CARD_DEACT)
    {
        g_zAti_CurInstance = Z_ATI_INSNO_1;
    }
    else
    {
        g_zAti_CurInstance = Z_ATI_INSNO_2;
    }

    zAti_MsgSend(MMIA_AS_CARD_SWITCH_REQ_EV, (PBYTE)ptCardSwitch, sizeof(T_zMmiaAs_CardSwitch_Req), Z_ATI_TASKID_EUCER);

    g_zAti_CurInstance = bIndex;

    return Z_APMMIA_NORESULT;
}
#endif
