/**************************************************************************
*
*             Protocol Stack Adapter Layer Telephone Interface
*
*                  Copyright (c) 2007 ZTE Corporation.
*
***************************************************************************
*
*   汾 : ͨѶɷ޹˾ ֻҵ ƽ̨ܹ
*   ģ   : ATI2ģPDIʵļ
*      : zati2_pdi_fnc.c
*   ļʶ : 
*   ļ : 
*   ʵֹ :   
*        : ChenYun
*        : 2.0
*    : 2008/02/25
*   ˵ : 
*
*   ޸ļ¼ : 
*        : 
*     ޸ĺ : 
*     ޸ : 
*        : 
*
***************************************************************************
*
*   ļ
*   ----------------
*   ATI2ģPDIݴʵļ
*
***************************************************************************/

/**************************************************************************
*                        ͷļ                                      *
**************************************************************************/
#include "ps/src/nas/ati/inc/zati_pdi_fnc.h"
#include "ps/src/nas/ati/inc/zati_fnc.h"
#include "appdiint.h"
#include "ps/src/nas/ati/inc/zati_com.h"
#include "ps/src/nas/ati/inc/zat_fnc.h"

extern T_ZAti_Context  g_zAti_Context;
extern T_ZAti_SmContext g_zAti_SmContext[Z_ATI_INSTANCE_MAX_NUM];

OutputIpPacket_CB        g_zPsi_IpOutput = NULL;

extern SINT32 zAti_CsdUpDataRecv(UINT8 iChnelId, UINT16 iRecvLen, UINT8 *pData);
extern void psnet_parse_RA_pkt(unsigned char cid, unsigned char* pkt, int len);

int (*fastnat_fromps)(unsigned char *data, unsigned short len);

/**************************************************************************
*                           ֲԭ                                  *
**************************************************************************/
/************************************************************************
*:zPsi_GetCurrStackIndex
*:ȡPSIģ鵱ǰ
*˵:0ʾ1,1ʾ2
************************************************************************/
BYTE zPsi_GetCurrStackIndex(VOID)
{
    ZOSS_TASK_ID tSelfTask = zOss_GetSelfTaskID();

    return (tSelfTask == zDev_GetTaskId(Z_ATI_TASKID_PSI, 0))? 0:1;
}
/**************************************************************************
* ƣ zPsi_TaskEntry
*  Psiں
* ˵ (IN) 
*            state          ״̬
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            pPrivateData   
*            (OUT)
*   ֵ 
* ˵ ͨ/ݣ͸
*            շ㷢Ϣ/ݣ͸ͨ
*            ̬ATI2ջռҪΪ1024*50    
*            {1,"task_zpsi",zPsi_TaskEntry,13,1024*50,0,0,0}
**************************************************************************/
VOID __ps_comm_func zPsi_TaskEntry(UINT8 iState, UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen, UINT8 *pPrivateData)
{
    switch(iState)
    {
        case ZOSS_STATUS_INIT:
        {
            zPsi_TaskInit(iEvId, pDataPtr, iDataLen, pPrivateData);
        }
        break;

        case ZOSS_STATUS_WORK:
        {
            zPsi_TaskWork(iEvId, pDataPtr, iDataLen, pPrivateData);
        }
        break;

        default:
        {
        }
        break;
    }   
}


/**************************************************************************
* ƣ zPsi_TaskInit
*  ڳʼ״̬Ĵ
* ˵ (IN) 
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            pPrivateData   
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID __ps_comm_func zPsi_TaskInit(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen, UINT8 *pPrivateData)
{
    switch(iEvId)
    {
    case EV_INIT:
        break;
        
    case EV_POWERON:
        zOss_SetState(ZOSS_STATUS_WORK);
        break;
        
    default:
        break;      
    }
}

/**************************************************************************
* ƣ zPsi_TaskWork
*  ڹ״̬Ĵ
* ˵ (IN) 
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            pPrivateData   
*            (OUT)
*   ֵ 
* ˵ 
*            Ϣ
*            һϢһ
**************************************************************************/
VOID zPsi_TaskWork(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen, UINT8 *pPrivateData)
{
#if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
    BYTE bInstance = zPsi_GetCurrStackIndex();
#else
    BYTE bInstance = 0;
#endif

    switch(iEvId)
    {
    case EV_POWEROFF:
        break;

    case PSI_PDI_DATA_IND_EV:
            zAti_PsiDataIndProcMsg(pDataPtr, iDataLen, bInstance);
        break;

    default:
        break;
    }
}

/**************************************************************************
* ƣ zPsi_RegOutputIpPacketCb
*  
* ˵ 
*   ֵ ɹZATI2_SUCCESS
* ˵ ΰ岻ɱ޸ģ뿽                            
**************************************************************************/ 
SINT32 __ps_comm_func zPsi_RegOutputIpPacketCb(OutputIpPacket_CB recvFunc)
{
    if(recvFunc != NULL)
    {
        g_zPsi_IpOutput = recvFunc;
        return ZATI2_SUCCESS;
    }
    return ZATI2_FALSE;
}

/**************************************************************************
*  : zAti_PsiCheckUpLinkSdu
*  : УпռǷΪATI
* ˵ (IN) 
*            upLinkSdu     пռ
*   ֵ ɹȫֱָ
* ˵ 
**************************************************************************/
static BOOL __ps_static_func zAti_PsiCheckULSdu(UINT8 iChnelId, UINT8 * upLinkSdu)
{
    T_z_UpLink_Sdu  *pULSdu = (T_z_UpLink_Sdu  *)upLinkSdu;
    if(pULSdu->wIpPacketOffSet)/*޷ȷϣPDIṩ*/
    {
        return TRUE;
    }
    return FALSE;
}

/**************************************************************************
*  : zAti_PsiInitULSdu
*  : ChnelIdпռ
* ˵ (IN) 
*            iChnelId     ͨ
*            pDataPtr     ָ
*            iDataLen     ݳ
*            (OUT)
*   ֵ ɹȫֱָ
* ˵ 
**************************************************************************/
static T_z_UpLink_Sdu* __ps_static_func zAti_PsiInitULSdu(UINT8 iChnelId, UINT8 *pDataPtr, UINT16 iDataLen)
{
    if(iDataLen < sizeof(T_z_UpLink_Sdu) && ((NULL != pDataPtr))) 
    {
        T_z_UpLink_Sdu  *pULSdu = zAllocUpLinkSdu();
        if(pULSdu != NULL)
        {
            pULSdu->wIpPacketLen = iDataLen;
            zOss_Memcpy((UINT8*)(pULSdu->Data)+pULSdu->wIpPacketOffSet, pDataPtr, iDataLen);
        }
        return pULSdu;
    }
    if((NULL == pDataPtr) ||(iDataLen > sizeof(T_z_UpLink_Sdu))|| !zAti_PsiCheckULSdu(iChnelId, pDataPtr)) /* α */
    {
        return NULL;
    }
    return (T_z_UpLink_Sdu*)pDataPtr;
}

/**************************************************************************
*  : zAti_PsiGetChnelId
*  : CIDͨ
* ˵ (IN) 
*            iCid     CID
*   ֵ ɹͨIDţʧܷ0
* ˵ 
**************************************************************************/

static UINT8 zAti_PsiGetChnelId(UINT8 iCid, BYTE bInstance)
{
    UINT8                   iAtiCidNum = 0;

  //  if (iCid == 0 || iCid > ZATI2_SM_MAX_SMCID_NUM)
 //   {
//        return 0;
  //  }
		
    for(iAtiCidNum = 0; iAtiCidNum < ZATI2_SM_MAX_SMCID_NUM; iAtiCidNum++)
    {
        if(g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid == iCid
        ||g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].extActCid == iCid) /*ȡֵΪ1~4*/
        {
            return g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].chnelId;
        }
    }
    return 0;
}

static BOOL __ps_4g_func zAti_PsiIsDataStat(BYTE bCid, BYTE bInstance)
{
    BYTE bNum = 0;

    /*жϵǰCIDǷ̬*/
    for(bNum = 0; bNum<ZATI2_SM_MAX_SMCID_NUM; bNum++)
    {
        if((g_zAti_SmContext[bInstance].lastCidTab[bNum].iCid == bCid
        ||g_zAti_SmContext[bInstance].lastCidTab[bNum].extActCid == bCid)
        &&(g_zAti_SmContext[bInstance].lastCidTab[bNum].isNdis
        ||g_zAti_SmContext[bInstance].lastCidTab[bNum].isPpp))
        {
            return TRUE;
        }
    }
    return FALSE;
}
/**************************************************************************
*  : zAti_PsiGetCid
*  : ͨŷCID
* ˵ (IN) 
*            iChnelId     ͨID
*   ֵ ɹCIDʧܷ0
* ˵ 
**************************************************************************/
static UINT8 __ps_static_func zAti_PsiGetCid(UINT8  iChnelId, BOOL isIpv6)
{
    BYTE bInstance = zAti_GetTaskInstantByChnlId(iChnelId);
    UINT8                   iAtiCidNum = 0;
    BYTE bPdpType = 0;
    
    (isIpv6 == TRUE)? (bPdpType = Z_MMIASM_IPV6) : (bPdpType = Z_MMIASM_IPV4);

    for(iAtiCidNum = 0; iAtiCidNum < ZATI2_SM_MAX_SMCID_NUM; iAtiCidNum++)
    {
        if((g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].chnelId == iChnelId)
        && (g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid >= 1) /* ȡֵ1~4 */
        && (g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid <= ZATI2_SM_MAX_SMCID_NUM)) 
        {
            if(!g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].extActCid)
            {
                return g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid;
            }
            else 
            {
                if (g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].extPdpType == bPdpType)
                {
                    return g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].extActCid;
                }
                else
                {
                    return g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid;
                }
            }
        }
    }
    return 0;
}
/**************************************************************************
*  : zAti_PsiDataReqProc
*  : ݣƽ̨ATIûݵPDI
* ˵ (IN) 
*            iChnelId     ͨID
*            pDataPtr     ָ
*            iDataLen     ݳ
*            (OUT)
*   ֵ ɹZATI2_SUCCESSʧܷش
* ˵ ͨյݣø
**************************************************************************/
SINT32 __ps_static_func zAti_PsiDataReqProc(UINT8 iChnnelId, UINT8 *pDataPtr, UINT16 iDataLen, BOOL isIpv6)
{
    T_ZAti_ChannelInfo     *pChnelNode = NULL;
    T_z_UpLink_Sdu        *pULSdu = zAti_PsiInitULSdu(iChnnelId, pDataPtr, iDataLen);
    BYTE bInstance = Z_ATI_INSNO_1;

    if(pULSdu == NULL)
    {
        return ZATI2_FALSE;
    }
    pChnelNode = zAti_GetChannelNodePtr(iChnnelId);
    if((pChnelNode == NULL)
        ||(pULSdu->bCid = zAti_PsiGetCid(pChnelNode->iChnelId, isIpv6)) == 0)
    {
        zFreeUpLinkSdu(pULSdu);
        return ZATI2_FALSE;
    }
    bInstance = zAti_GetTaskInstantByChnlId(pChnelNode->iChnelId);
    pULSdu->bPid = (zAti_IsTcpAckPacket(pULSdu->Data+pULSdu->wIpPacketOffSet,pULSdu->wIpPacketLen) && (zEsm_IsImsBearer(pULSdu->bCid,bInstance) == Z_INVALID))?1:0;
    if(g_zPsi_IpOutput != NULL)
    {
        (VOID)g_zPsi_IpOutput(iChnnelId, pULSdu->Data+pULSdu->wIpPacketOffSet, pULSdu->wIpPacketLen, 0);
    }
    zPdi_UpLinkSend(pULSdu, zAti_GetTaskInstantByChnlId(pChnelNode->iChnelId));
    zOss_SetTransDataFlag();

    return ZATI2_SUCCESS;
}


/**************************************************************************
*  : zAti_PdiDataIndProc
*  : ݣЭջյݵϢ͵ͨȥ
* ˵ (IN) 
*            pDataPtr     ָ
*            iDataLen     ݳ
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/

VOID __ps_4g_func zAti_PsiDataIndProc(T_ZOss_List *pDataPtr, BYTE bInstance)
{
    T_z_DownLink_Sdu     *pTempData;
    T_z_DownLink_Sdu     *pNext;
    SINT32                ret;
    UINT8                 cid;
    UINT8                 chnl_id;
    pTempData = (T_z_DownLink_Sdu *)pDataPtr->HEAD;
    
    while(pTempData !=NULL)
    {
        pNext = (T_z_DownLink_Sdu*)(pTempData->tNode.next);
        pTempData->tNode.next = NULL;
        pTempData->tNode.previous = NULL;
        cid = pTempData->bCid;

        psnet_parse_RA_pkt(cid, (unsigned char *)(pTempData->Data + pTempData->wDataOffSet), (pTempData->wDataLen));

        //pChnelNode = zAti_GetChannelNodePtr(zAti_PsiGetChnelId(cid, bInstance));
        //chnl_id = zAti_PsiGetChnelId(cid, bInstance);
        chnl_id = g_zAti_SmContext[bInstance].lastCidTab[cid-1].chnelId;
	    if (chnl_id == 0)
	 	    chnl_id = zAti_PsiGetChnelId(cid, bInstance);
        if(( chnl_id != 0) && (pTempData->wDataLen != 0))
        {
            //616000541565 :psbufͳһΪbyteȡֱʹòת
            //pTempData->wDataLen = (pTempData->wDataLen + 7)>>3;//ƥЭջ
            if(g_zPsi_IpOutput != NULL)
            {
                (VOID)g_zPsi_IpOutput(chnl_id, (pTempData->Data + pTempData->wDataOffSet), (pTempData->wDataLen), 1);
            }

            if(zOss_GetTransDataFlag() == FALSE && zAti_PsiIsDataStat(cid, bInstance))
            {
                zOss_SetTransDataFlag();
            }

            if (fastnat_fromps == NULL || fastnat_fromps(pTempData->Data + pTempData->wDataOffSet, pTempData->wDataLen) != 1)
            {
                /*Ϊ⽵Чʣ˴ٷװ*/
                ret = g_zAti_Context.sendFnc(chnl_id, (UINT8 *)(pTempData->Data + pTempData->wDataOffSet), (UINT16)(pTempData->wDataLen), ZATI2_CHIND_PSD); /* ͵ͨ */
                if(ret != ZATI2_SUCCESS)// fail
                {
                    zFreeDownLinkSdu(pTempData);
                }
            }
        }
        else
        {
            zOss_Printf(SUBMDL_Z_ESM, PRINT_LEVEL_SEVERE,"dldata discard:cid=%d",cid);
            zFreeDownLinkSdu(pTempData);
            zAti_SendExpt2TraceAgt(ERR_ATI_DesertSduData,  TRACE_ERR_LEVEL_NORMAL,"");//617001960161 쳣ӡ
        }
        pTempData = pNext;
    }
}

VOID zAti_PsiDataIndProcMsg(UINT8 *pDataPtr, UINT16 iDataLen, BYTE bInstance)
{
    T_ZOss_List     *pApPdiDataInd = (T_ZOss_List *)pDataPtr;
    //T_ZAti_ChannelInfo     *pChnelNode = NULL;
    T_z_DownLink_Sdu     *pTempData = NULL;
    T_z_DownLink_Sdu     *pNext = NULL;
    UINT8                 cid = 0;
    UINT8                 bChenId = 0;
    if((NULL == pDataPtr) || (sizeof(T_ZOss_List) != iDataLen))
    {
        return;
    }

    pTempData = (T_z_DownLink_Sdu *)pApPdiDataInd->HEAD;

    while(pTempData !=NULL)
    {
        pNext = (T_z_DownLink_Sdu*)(pTempData->tNode.next);
        pTempData->tNode.next = NULL;
        pTempData->tNode.previous = NULL;
        cid = pTempData->bCid;
        bChenId = zAti_PsiGetChnelId(cid, bInstance);
        //pChnelNode = zAti_GetChannelNodePtr(zAti_PsiGetChnelId(cid, bInstance));
		
        if((0 != bChenId) && (pTempData->wDataLen != 0))
        {
            //616000541565 :psbufͳһΪbyteȡֱʹòת
            //pTempData->wDataLen = (pTempData->wDataLen + 7)>>3;//ƥЭջ
            if(g_zPsi_IpOutput != NULL)
            {
                (VOID)g_zPsi_IpOutput(bChenId, (pTempData->Data + pTempData->wDataOffSet), (pTempData->wDataLen), 1);
            }
            /*Ϊ⽵Чʣ˴ٷװ*/
            (VOID)g_zAti_Context.sendFnc(bChenId, (UINT8 *)(pTempData->Data + pTempData->wDataOffSet), (UINT16)(pTempData->wDataLen), ZATI2_CHIND_PSD); /* ͵ͨ */

            if(zOss_GetTransDataFlag() == FALSE && zAti_PsiIsDataStat(cid, bInstance))
            {
                zOss_SetTransDataFlag();
            }
        }
        //if(pChnelNode->chType != ZATI2_CH_TYPE_RNDIS)
        {
            zFreeDownLinkSdu(pTempData);
        }
        pTempData = pNext;
    }

    zAti_RetUB((VOID **)&pDataPtr);
}

/**************************************************************************
* ƣ zAti_PdiZgdataTestReqProc
*  ûAT+ZGDATATEST
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
*            עĸʽ֮ģT_ZAti_ZgdataTestSetReq
*EC 617002770352 ݾڼʱɺз
*CSݲԵļʱ0ҲԲ
*ܴھ׼ȷȷڿɽܷΧ
**************************************************************************/  
DWORD zAti_PdiZgdataTestReqProc(VOID *pDataPtr)
{
    T_ZAti_ZgdataTestSetReq    *ptzgdataTestSetReq = (T_ZAti_ZgdataTestSetReq*)pDataPtr;
    T_zMmiaSm_PdpAddr  tPdpAddr = {0};  
    T_zMmiaSm_PcoInfo      *ptPcoInfo = (T_zMmiaSm_PcoInfo*)zAti_GetUB(sizeof(T_zMmiaSm_PcoInfo));

    if((1 == ptzgdataTestSetReq->iDataType) || (2 == ptzgdataTestSetReq->iDataType))
    {
        zAti_RetUB((VOID **)&ptPcoInfo);
        #ifndef CONFIG_SINGLECORE
        return zAti_PdiZgdataTestCsDataReq(*ptzgdataTestSetReq);
        #else
        sprintf((char *)g_zAt_EncBuf, "%sERROR%s", g_zAt_CRLF, g_zAt_CRLF);
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg, TRACE_ERR_LEVEL_NORMAL,"");
        return Z_APMMIA_NOERROR_ERR;
        #endif
    }

    if((0 == ptzgdataTestSetReq->iSendPacketLength) || (ptzgdataTestSetReq->iSendPacketLength > Z_APMMIA_SM_MAXSDUSIZE_1500)
       || (0 == ptzgdataTestSetReq->iSendPacketTimes) || (!zAti_GetPdpInfoByCid(ptzgdataTestSetReq->iCid, &tPdpAddr,ptPcoInfo, g_zAti_CurInstance))
       || (0 == ptzgdataTestSetReq->iCid) || (ptzgdataTestSetReq->iCid > Z_DEV_AtMem_MAXINUM_CID))//XC617001911530߶˫汾뷢
    {
        sprintf((char *)g_zAt_EncBuf, "%sERROR%s", g_zAt_CRLF, g_zAt_CRLF);
        zAti_RetUB((VOID **)&ptPcoInfo);
        return Z_APMMIA_NOERROR_ERR;
    }
    else
    {
        zAti_RetUB((VOID **)&ptPcoInfo);
        return zAti_PdiZgdataTestPsDataReq(ptzgdataTestSetReq);
    }
}
#ifndef CONFIG_SINGLECORE
BOOL zAti_IsCsdChanelExist()
{
    BYTE bMaxChnlId = (g_zAti_CurInstance == 1)?  Z_ATI_INSTANCE_TWO_CHNL_MAX : Z_ATI_INSTANCE_ONE_CHNL_MAX;
    T_ZAti_ChannelInfo *pChnelNode = zAti_GetFirstChannelNodePtrByInstance(g_zAti_CurInstance);  
    
    while(ZOSS_NULL != pChnelNode && pChnelNode->iChnelId <= bMaxChnlId)
    {
        if(ZATI2_CHANNEL_MODE_DATA == pChnelNode->server_mode &&
                ZATI2_CHANNEL_DATA_TYPE_CSD == pChnelNode->dataType) /* ѡͨ */
        {
            return TRUE;
        }
        pChnelNode = pChnelNode->pNextCnNode;
    }
    return FALSE;
}

/**************************************************************************
* ƣ zAti_PdiZgdataTestCsDataReq
*  ûAT+ZGDATATESTݣCSݴ
* ˵ (IN) 
*            zgdataTestSetReq       ṹ
*            (OUT)
*   ֵ 
* ˵ +ZGDATATEST: <bResult> (including two reasons) 
*            עĸʽ֮ģT_ZAti_ZgdataTestSetReq
**************************************************************************/  
DWORD zAti_PdiZgdataTestCsDataReq(T_ZAti_ZgdataTestSetReq zgdataTestSetReq)
{
    T_zAti_CsDataTest_Info *pVtDT = ZOSS_NULL;

    pVtDT = &g_zAti_atDataEx[g_zAti_CurInstance].tDataTestInfo.tCsDataTestInfo;

    /*˫ʱͬʱCSDͨж*/
    if(pVtDT->timerSendCsData != ZOSS_INVALID_TIMER_ID || !zAti_IsCsdChanelExist())
    {
        sprintf((char *)g_zAt_EncBuf, "%sERROR%s", g_zAt_CRLF, g_zAt_CRLF);
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg, TRACE_ERR_LEVEL_NORMAL,"");
        return Z_APMMIA_NOERROR_ERR;
    }

    if((0 == zgdataTestSetReq.iSendPacketLength) || (zgdataTestSetReq.iSendPacketLength > Z_APMMIA_SM_MAXSDUSIZE_1500)
       || (0 == zgdataTestSetReq.iSendPacketTimes) || (0 == zgdataTestSetReq.iSleepTimeLen))
    {
        sprintf((char *)g_zAt_EncBuf, "%sERROR%s", g_zAt_CRLF, g_zAt_CRLF);
        return Z_APMMIA_NOERROR_ERR;
    }

    zOss_Memcpy(&pVtDT->zTest, &zgdataTestSetReq, sizeof(T_ZAti_ZgdataTestSetReq));
    pVtDT->timerSendCsData = 
        zSetRelativeTimer(zgdataTestSetReq.iSleepTimeLen, EV_ZATI2_TEST_SEND_CS_DATA, g_zAti_CurInstance);

    if(pVtDT->timerSendCsData == ZOSS_INVALID_TIMER_ID)
    {
        zAti_HnadleZgdatatestCnf(pVtDT->zTest.iSrcIndex, pVtDT->zTest.iDestIndex, FALSE);
        zOss_Memset((UINT8 *)pVtDT, 0, sizeof(T_zAti_CsDataTest_Info));
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg, TRACE_ERR_LEVEL_NORMAL,"");
    }
    return Z_APMMIA_NORESULT;
}
#endif
/**************************************************************************
* ƣ zAti_PdiZgdataTestPsDataReq
*  ûAT+ZGDATATESTݣPSݴ
* ˵ (IN) 
*            zgdataTestSetReq       ṹ
*            (OUT)
*   ֵ 
**************************************************************************/  
DWORD zAti_PdiZgdataTestPsDataReq(T_ZAti_ZgdataTestSetReq *ptzgdataTestSetReq)
{
    T_zAti_PsDataTest_Info *pDataTstInfo = ZOSS_NULL;
    T_zAti_PsDataTest_Info *pAnthDtTstInfo = ZOSS_NULL;
#if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
    BYTE bAnthInsNo = (g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_2 : Z_ATI_INSNO_1;
#else
    BYTE bAnthInsNo = Z_ATI_INSNO_2;
#endif

    pDataTstInfo = &g_zAti_atDataEx[g_zAti_CurInstance].tDataTestInfo.tPsDataTestInfo;
    pAnthDtTstInfo = &g_zAti_atDataEx[bAnthInsNo].tDataTestInfo.tPsDataTestInfo;

    if(pDataTstInfo->pTimrIdZgdt != ZOSS_INVALID_TIMER_ID ||
      (zAti_IsSingleCardForTwoStandby() && pAnthDtTstInfo->pTimrIdZgdt != ZOSS_INVALID_TIMER_ID))
    {
         sprintf((char *)g_zAt_EncBuf, "%sERROR%s", g_zAt_CRLF, g_zAt_CRLF);
         zAti_SendExpt2TraceAgt(ERR_InvalidMsg, TRACE_ERR_LEVEL_NORMAL,"");
         return Z_APMMIA_NOERROR_ERR;
    }

    if(ptzgdataTestSetReq->iSleepTimeLen == 0)
    {
        UINT8                   iSendTimes = 0;
        T_z_UpLink_Sdu  *pULSdu = NULL;
      
        /*617001860913AT+ZGDATATESTΪ255ᵼѭ*/
        for(iSendTimes = 0; iSendTimes < ptzgdataTestSetReq->iSendPacketTimes; iSendTimes++)
        {
            pULSdu = zAllocUpLinkSdu();
            if(pULSdu == NULL)
            {
                sprintf((char *)g_zAt_EncBuf, "%sERROR%s", g_zAt_CRLF, g_zAt_CRLF);
                return Z_APMMIA_NOERROR_ERR;
            }
            zOss_Memset(pULSdu->Data+pULSdu->wIpPacketOffSet, 0xff, ptzgdataTestSetReq->iSendPacketLength);
            /*  */
            pULSdu->bCid = ptzgdataTestSetReq->iCid;
            pULSdu->wIpPacketLen = ptzgdataTestSetReq->iSendPacketLength ;

            zPdi_UpLinkSend(pULSdu, g_zAti_CurInstance);
        }
        sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
        return Z_APMMIA_NOERROR_ERR;
    }
    else
    {
        zOss_Memcpy(&pDataTstInfo->tPsZgdtInfo, ptzgdataTestSetReq, sizeof(T_ZAti_ZgdataTestSetReq));

        pDataTstInfo->pTimrIdZgdt = zSetRelativeTimer(
                                            ptzgdataTestSetReq->iSleepTimeLen, 
                                            MMIA_ZGDT_EXPIRY_EV, 
                                            g_zAti_CurInstance);

        if(pDataTstInfo->pTimrIdZgdt == ZOSS_INVALID_TIMER_ID)
        {
            zAti_HnadleZgdatatestCnf(pDataTstInfo->tPsZgdtInfo.iSrcIndex, pDataTstInfo->tPsZgdtInfo.iDestIndex, FALSE);
            zOss_Memset(pDataTstInfo, 0, sizeof(T_zAti_PsDataTest_Info));
            zAti_SendExpt2TraceAgt(ERR_InvalidMsg, TRACE_ERR_LEVEL_NORMAL,"");
        }
    }
    return Z_APMMIA_NORESULT;
}

VOID zAti_HnadleZgdatatestCnf(BYTE bDestIndex , BYTE bSourceIndex, BOOL bResult)
{
    T_ZAti_ZgdataTestSetCnf *pZgdataTestSetCnf = (T_ZAti_ZgdataTestSetCnf *)zAti_GetUB(sizeof(T_ZAti_ZgdataTestSetCnf));
    pZgdataTestSetCnf->iDestIndex = bDestIndex;
    pZgdataTestSetCnf->iSrcIndex = bSourceIndex;
    pZgdataTestSetCnf->bResult = bResult;

    zAti_RecvServerHandlerSlaver(EV_ZATI2_ZGDATATEST_SET_CNF, (UINT8 *) pZgdataTestSetCnf, sizeof(T_ZAti_ZgdataTestSetCnf));
}
/******************************************************************
:zAti_ZgdataTestSendPsData
:ZGDTATATESTPSݲԳʱϢ
******************************************************************/
VOID zAti_ZgdataTestSendPsData(VOID)
{
    T_z_UpLink_Sdu  *pULSdu = NULL;
    T_zAti_PsDataTest_Info *pDataTstInfo = ZOSS_NULL;
#if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
    BYTE bAnthInsNo = (g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_2: Z_ATI_INSNO_1;
#else
    BYTE bAnthInsNo = Z_ATI_INSNO_2;
#endif
    pDataTstInfo = &(g_zAti_atDataEx[g_zAti_CurInstance].tDataTestInfo.tPsDataTestInfo);
    pDataTstInfo->pTimrIdZgdt = ZOSS_INVALID_TIMER_ID;

#ifdef CXT_MOV
    if(Z_ATI_PS_MOVE_ORIGIN == zAti_GetPsMovStat()) //Ǩݲͣ
    {
#endif
        pULSdu = zAllocUpLinkSdu();
        if(pULSdu == NULL)
        {
            zAti_HnadleZgdatatestCnf(pDataTstInfo->tPsZgdtInfo.iSrcIndex, pDataTstInfo->tPsZgdtInfo.iDestIndex, FALSE);
            zOss_Memset(pDataTstInfo, 0, sizeof(T_zAti_PsDataTest_Info));
            return;
        }
        zOss_Memset(pULSdu->Data+pULSdu->wIpPacketOffSet, 0xff, pDataTstInfo->tPsZgdtInfo.iSendPacketLength);
        /*  */
        pULSdu->bCid =pDataTstInfo->tPsZgdtInfo.iCid;
        pULSdu->wIpPacketLen = pDataTstInfo->tPsZgdtInfo.iSendPacketLength ;

        if(zAti_IsTheCidActived(g_zAti_CurInstance, pDataTstInfo->tPsZgdtInfo.iCid))
        {
            zPdi_UpLinkSend(pULSdu, g_zAti_CurInstance);
        }
        else if(zAti_IsSingleCardForTwoStandby() &&
            zAti_IsTheCidActived(bAnthInsNo, pDataTstInfo->tPsZgdtInfo.iCid))
        {
            zPdi_UpLinkSend(pULSdu, bAnthInsNo);
        }
        else
        {  /*CIDٴڼ̬ʱ*/
            zAti_HnadleZgdatatestCnf(pDataTstInfo->tPsZgdtInfo.iSrcIndex, pDataTstInfo->tPsZgdtInfo.iDestIndex, FALSE);
            zOss_Memset(pDataTstInfo, 0, sizeof(T_zAti_PsDataTest_Info));
            zFreeUpLinkSdu(pULSdu);
            zAti_SendExpt2TraceAgt(ERR_InvalidMsg, TRACE_ERR_LEVEL_NORMAL,"");
            return;
        }

        pDataTstInfo->bCurrTime++;
#ifdef CXT_MOV
    }
#endif

    if(pDataTstInfo->bCurrTime >= pDataTstInfo->tPsZgdtInfo.iSendPacketTimes)
    {
        zAti_HnadleZgdatatestCnf(pDataTstInfo->tPsZgdtInfo.iSrcIndex, pDataTstInfo->tPsZgdtInfo.iDestIndex, TRUE);
        zOss_Memset(pDataTstInfo, 0, sizeof(T_zAti_PsDataTest_Info));
    }
    else
    {
        pDataTstInfo->pTimrIdZgdt = zSetRelativeTimer(
                                        pDataTstInfo->tPsZgdtInfo.iSleepTimeLen, 
                                        MMIA_ZGDT_EXPIRY_EV, 
                                        g_zAti_CurInstance);

        if(pDataTstInfo->pTimrIdZgdt == ZOSS_INVALID_TIMER_ID)
        {
            zAti_HnadleZgdatatestCnf(pDataTstInfo->tPsZgdtInfo.iSrcIndex, pDataTstInfo->tPsZgdtInfo.iDestIndex, FALSE);
            zOss_Memset(pDataTstInfo, 0, sizeof(T_zAti_PsDataTest_Info));
            zAti_SendExpt2TraceAgt(ERR_InvalidMsg, TRACE_ERR_LEVEL_NORMAL,"");
        }
    }
}
#ifndef CONFIG_SINGLECORE
/**************************************************************************
* ƣ zAti_ZgdataTestSendCsData
*  ԷͷCSݴ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
*            עĸʽȫΪ0xffİ
**************************************************************************/  
VOID zAti_ZgdataTestSendCsData(VOID)
{
    T_ZAti_ChannelInfo *pChnelNode = zAti_GetFirstChannelNodePtrByInstance(g_zAti_CurInstance); 
    T_zAti_CsDataTest_Info *pVtDT = ZOSS_NULL;

    pVtDT = &g_zAti_atDataEx[g_zAti_CurInstance].tDataTestInfo.tCsDataTestInfo;
    
    if(g_zAti_Context.taskStatus != ZATI2_TASK_STATUS_READY) 
    {
        return;
    }

    pVtDT->timerSendCsData = ZOSS_INVALID_TIMER_ID;

    while(NULL != pChnelNode)
    {
        if(ZATI2_CHANNEL_MODE_DATA != pChnelNode->server_mode 
            || ZATI2_CHANNEL_DATA_TYPE_CSD != pChnelNode->dataType )
        {
            pChnelNode = pChnelNode->pNextCnNode;
            continue;
        }

        if(pVtDT->zTest.iSendPacketLength > 0) //  ͵CSD 
        {
            UINT8* iData = (UINT8 *)zOss_Malloc(pVtDT->zTest.iSendPacketLength);

            if(NULL != iData)
            {
                zOss_Memset(iData, 0xaa, pVtDT->zTest.iSendPacketLength);
                zAti_CsdUpDataRecv(pChnelNode->iChnelId, pVtDT->zTest.iSendPacketLength, iData);
                zOss_Free(iData);//߲ 2010.03.08
                iData = NULL;
            }
            break;
        }
        else
        {
            zAti_HnadleZgdatatestCnf(pVtDT->zTest.iSrcIndex, pVtDT->zTest.iDestIndex, FALSE);
            zOss_Memset(pVtDT, 0, sizeof(T_zAti_CsDataTest_Info));
            return;
        }
    }

    pVtDT->iCurrTimes++;

    if(pVtDT->iCurrTimes >= pVtDT->zTest.iSendPacketTimes)
    {
        zAti_HnadleZgdatatestCnf(pVtDT->zTest.iSrcIndex, pVtDT->zTest.iDestIndex, TRUE);
        zOss_Memset((UINT8 *)pVtDT, 0, sizeof(T_zAti_CsDataTest_Info));
    }
    else
    {
        pVtDT->timerSendCsData = 
            zOss_SetRelativeTimer(pVtDT->zTest.iSleepTimeLen, EV_ZATI2_TEST_SEND_CS_DATA, g_zAti_CurInstance);

        if(pVtDT->timerSendCsData == ZOSS_INVALID_TIMER_ID)
        {
            zAti_HnadleZgdatatestCnf(pVtDT->zTest.iSrcIndex, pVtDT->zTest.iDestIndex, FALSE);
            zOss_Memset((UINT8 *)pVtDT, 0, sizeof(T_zAti_CsDataTest_Info));
            zAti_SendExpt2TraceAgt(ERR_InvalidMsg, TRACE_ERR_LEVEL_NORMAL,"");
        }
    }
}
#endif
/**************************************************************************
* ƣ zAti_IsTcpAckPacket
*  УIPǷΪTCPACK
* ˵ (IN) 
*            pDataPtr       IPָ
*            (OUT)
*   ֵ TCP ACKTRUE, FALSE
* ˵ 616000239848TCP/L2:TCP£
* жһ°ȣС400ΪǸȼ
* ҪEL2ȷ͡
**************************************************************************/  
CODE_BEGIN(.PS_TCM_CODE)
BOOL __ps_static_func zAti_IsTcpAckPacket(VOID *pDataPtr, UINT16 length)
{
    UINT8 *p = (UINT8 *)pDataPtr;
    UINT16 len = 0;    
    
    if ((p == NULL) || (length == 0))
    {   
        return FALSE;   
    }
    if (((*p) & 0xf0) == 0x40) // IPv4 packet
    {
        if (*(p + 9) == 0x06)//TCP packet
        {
            p = p + ((*p & 0xf) << 2);// It contains a TCP packet, so move p to the beginning of TCP header
            if ((*(p + 13) & 0xff) == 0x10)// Only ACK flag is set, so move p to the beginning of TCP payload data part.
            {
                p = p + ((*(p + 12) >> 4) << 2);
                len = (*( (UINT8 *)pDataPtr + 2) << 8) + *( (UINT8 *)pDataPtr + 3);//Total length
                return (p -  (UINT8 *)pDataPtr == len);
            }
        }
    }
    else if (((*p) & 0xf0) == 0x60) // IPv6 packet
    {
       if (*(p + 6) == 0x06)//TCP packet ???
        {
            p = p +40;// It contains a TCP packet, so move p to the beginning of TCP header
            if ((*(p + 13) & 0xff) == 0x10) // Only ACK flag is set, so move p to the beginning of TCP payload data part.
            {
                p = p + ((*(p + 12) >> 4) << 2);
                len = (*( (UINT8 *)pDataPtr + 4) << 8) + *( (UINT8 *)pDataPtr + 5);// Payload Length
                return (p -  (UINT8 *)pDataPtr == (len+40));
            }
        }
    }
    return FALSE;   
}

CODE_END

