/*************************************************************************
* Ȩ(C)2007,ͨѶɷ޹˾
* ģ   ¼ģ
* ļƣ zte_dv.c    
* ļʶ 
* ժҪ ¼ģȫֲֺʵ
*
* ޸      汾     ޸ı       ޸       ޸      
* ----------------------------------------------------------------------
* 2009/3/25     1.0                                               
************************************************************************/
   
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "zte_dv.h"
#include "oss_api.h"
#include "ZMF_API.h"
#include "ZMF_OutDef.h"
#include "amr_alg.h"
#include "zMsp_Com.h"

#include "zte_osd.h"
/**************************************************************************
 *                                                                    *
 **************************************************************************/
#define DV_VIDEO_READ_THREAD "dv_video_read_thread"       /* Ƶݲɼ߳ */
#define DV_AUDIO_READ_THREAD "dv_audio_read_thread"       /* Ƶݲɼ߳ */
#define DV_FILE_SAVE_THREAD "dv_file_save_thread"         /* ¼ļ߳ */

#define DV_THREAD_STACK (UINT32)(60*1024)                  /* ߳ջС       */
#define DV_FILE_SAVE_THREAD_STACK (UINT32)(40*1024)

/* 2009-07-24  ޸߳ȼ */
#define DV_AREAD_THREAD_PRIORITY 20      /* Ƶɼ߳ȼ */ 
#define DV_VREAD_THREAD_PRIORITY 20      /* Ƶɼ߳ȼ */
#define DV_FSAVE_THREAD_PRIORITY 21      /* ļ߳ȼ */

#define DV_AUDIO_SAMPLE_RATE 8000
#define DV_VIDEO_FRAME_RATE 11

#define DV_VIDEO_BIT_RATE_LOW      48
#define DV_VIDEO_BIT_RATE_NORMAL   64
#define DV_VIDEO_BIT_RATE_HIGH     128

#define DV_AUDIO_CHANNEL_NUM 1
#define DV_DECODE_TIME_SCALE 1000
#define DV_ENCODE_IMAGE_WIDTH 176
#define DV_ENCODE_IMAGE_HEIGHT 144

#define DV_FILE_TRACK_NUM                2
#define DV_VIDEO_TRACK_ID                1
#define DV_AUDIO_TRACK_ID                2
#define DV_AUDIO_DECODE_TIME             20
#define DV_VIDEO_FIRST_TYPE_DECODE_TIME  66
#define DV_VIDEO_SECOND_TYPE_DECODE_TIME 67
#define DV_RECD_AUDIO_BUFFER_SIZE        320

#define ONE_CHANNEL       1    /* ¼ΪͨPCM      */
#define MP3_ENC_BITRATE   32   /* ¼ΪMP3ļ(32kbps)            */
#define PCM_SAMPLE_RATE   8000 /* PCMݵĲ                */

#define DV_FILE_STOP_MUTEX    "dv_file_stop_mutex"     /* ļֹͣ   */
#define DV_VIDEO_DATALIST_MUTEX "dv_video_datalist_mutex" /* Ƶ */
#define DV_AUDIO_DATALIST_MUTEX "dv_audio_datalist_mutex" /* Ƶ */

#define DV_OPEN_SEMP          "dv_open_semp"           /* 򿪽ӿź     */
#define DV_START_SEMP         "dv_start_semp"          /* ʼӿź     */
#define DV_STOP_SEMP          "dv_stop_semp"           /* ֹͣӿź     */
#define DV_PAUSE_SEMP         "dv_pause_semp"          /* ͣӿź     */
#define DV_RESUME_SEMP        "dv_resume_semp"         /* ָӿź     */
#define DV_CLOSE_SEMP         "dv_close_semp"          /* رսӿź     */

typedef enum
{
    EV_DV_START = 0,
    EV_DV_PAUSE,
    EV_DV_RESUME,
    EV_DV_STOP,
    EV_DV_CLOSE,
    EV_DV_VIDEO_OPEN_ENCODER,
    EV_DV_VIDEO_START_INTER,
    EV_DV_AUDIO_START_INTER,
    EV_DV_PAUSE_INTER,
    EV_DV_AUDIO_INIT_INTER,
    EV_DV_FILE_INIT_INTER,
    EV_DV_FILE_SAVEVIDEO_INTER,
    EV_DV_FILE_SAVEAUDIO_INTER,
    EV_DV_FILESTOP_INTER,
    EV_DV_FILECLOSE_INTER,
} T_Dv_MsgId;

typedef struct
{
    UINT32        msg_id;                          /* ϢID */   
}T_DvThreadMsg;

/* 2009-8-5 chenyouxin޸ */
typedef enum
{
    DV_IDLE_RECORD = 0,
    DV_OPEN_RECORD,
    DV_START_RECORD,        
    DV_PAUSE_RECORD,
} T_Dv_STATE;
/* 2009-8-5 chenyouxin޸ */

typedef enum
{
    DV_ERROR = -1,
    DV_SUCCESS,
    DV_INIT_FILE_PARSE_ERROR,
    DV_FILETYPE_ERROR,
    DV_BUFFER_FULL,
    DV_BUFFER_EMPTY
}T_DV_RETURN_VALUE;


typedef struct _T_DV_CAM_PARAM
{   
    MIRROR_PARAM_T             mirror;
    DROTATION_MODE_E           rotate;
    QUALITY_MODE_E             quality; 
    EFFECT_TYPE_E              effect;
}T_DV_CAM_PARAM;

/**************************************************************************
 *                                                                      *
 **************************************************************************/

/**************************************************************************
 *                                                                 *
 **************************************************************************/
typedef struct _DV_PARA
{ 
    DCAMERA_SENSOR_E g_DVsensor;       /* ͷѡ  */

    SINT32 g_Video_Dev_Fd;             /* Ƶ豸      */
    SINT32 g_Audio_Dev_Fd;             /* Ƶ豸      */
    SINT32 g_Camra_Dev_Fd;             /* sensor豸    */    
    SINT32 g_LCD_Dev_Fd;               /* LCD豸         */
    
    ZOSS_THREAD_ID  pVideoReadThread;  /* Ƶݲɼ߳ID  */
    ZOSS_THREAD_ID  pAudioReadThread;  /* Ƶ̲߳ɼID  */    
    ZOSS_THREAD_ID  pFileSaveThread;   /* ¼ļ߳ID  */

    BOOL   bAlreadyEncode;             /* Ƿʼ־    */
    UINT32 g_DvState;                  /* ¼ģ״̬־    */

    T_MediaAudioEncHandle      *pAudioEncHandle; /* Ƶ */
    T_VideoEncInstParam        *pVideoEncHandle; /* Ƶ */
    EMediaAudioType             eMediaAType;     /* Ƶ */
    T_ZDrvAudio_SampleRate      tSampleRate;     /*  */
    UINT32                      uiFrameLen;      /* PCM  */
    
}T_Dv_ControlParam;

struct _T_DATALIST_NODE
{
    T_ZOss_Node tNode;
    VOID * data;
    UINT32 uLen;
    UINT32 uTime;
    Bool8  bIsKeyFrame;
};

typedef struct _T_DATALIST_NODE T_VIDEODATA_NODE;
typedef struct _T_DATALIST_NODE T_AUDIODATA_NODE;

/**************************************************************************
 *                           ֲԭ                                  *
 **************************************************************************/
static VOID dv_video_read_entry(SINT32 iArg);

static VOID dv_audio_read_entry(SINT32 iArg);

static VOID dv_file_save_entry(SINT32 iArg);

extern DCAMERA_RETURN_VALUE_E DC_Stoppreview(void);
static T_DV_RETURN_VALUE dv_init(VOID);
static T_DV_RETURN_VALUE dv_uninit(VOID);
static T_DV_RETURN_VALUE dv_open_ex(DCAMERA_SENSOR_E param);
static T_DV_RETURN_VALUE dv_close_ex(VOID);
static T_DV_RETURN_VALUE dv_openpreview(T_DV_CAM_PARAM *param);
static T_DV_RETURN_VALUE dv_set_camera_para(T_DV_CAM_PARAM *param);
static T_DV_RETURN_VALUE dv_set_audio_record_para(VOID);

static VOID dv_open_video_encoder(VOID);
static VOID dv_get_video_data(VOID);
static VOID dv_video_proc_pause_msg(VOID);
static VOID dv_video_proc_stop_msg(VOID);
static T_DV_RETURN_VALUE dv_ppu_for_refresh_screen(T_ZDrv_CamDataInfo *pCamData);

static T_DV_RETURN_VALUE dv_audio_init(VOID);
static VOID dv_get_audio_data(VOID);
static VOID dv_audio_proc_pause_msg(VOID);
static VOID dv_audio_proc_stop_msg(VOID);
static VOID dv_audio_proc_resume_msg(VOID);
static T_DV_RETURN_VALUE dv_audio_record_start(VOID);
static T_DV_RETURN_VALUE dv_init_audio_encoder(EMediaAudioType         eMediaAType, T_MediaAudioEncHandle **pHandle,  
                                               T_ZDrvAudio_SampleRate  tSampleRate, UINT32    *pFrameLen);
static VOID dv_uninit_audio_encoder(T_MediaAudioEncHandle *pEncHandle);
static BOOL dv_is_send_save_audio_msg(VOID);

static T_DV_RETURN_VALUE dv_save_audio_data_from_datalist(UINT32 uAudioTime, UINT32 uBoundTime);
static T_DV_RETURN_VALUE dv_save_video_data_from_datalist(UINT32 uVideoTime, UINT32 uBoundTime);
static VOID dv_save_left_audio_and_video_datalist(VOID);

static T_DV_RETURN_VALUE dv_write_to_video_datalist(VOID *pData, UINT32 uDataLen, UINT32 uTime,Bool8 IsKeyFrame);
static T_DV_RETURN_VALUE dv_write_to_audio_datalist(VOID *pData, UINT32 uDataLen, UINT32 uTime);


static T_DV_RETURN_VALUE dv_read_one_frame_from_video_datalist(VOID);
static void dv_release_video_datalist(VOID);
static T_DV_RETURN_VALUE dv_read_one_frame_from_audio_datalist(VOID);


static T_DV_RETURN_VALUE dv_encode_one_frame_audio_data(T_ZDrvAudio_BufInfo *tAudioBuf);

static UINT8 dv_AmrIF1GetFrameType(UINT32 uiDataLen);
static SINT32 dv_get_video_frame_time_from_datalist(VOID);
static SINT32 dv_get_audio_frame_time_from_datalist(VOID);

static T_DV_RETURN_VALUE dv_filesave_init(VOID);
static T_DV_RETURN_VALUE dv_create_file(const CHAR *pFileName, BOOL bAudioFlag);
static T_DV_RETURN_VALUE dv_close_file(VOID);

static VOID dv_file_proc_stop_msg(VOID);
static T_DV_RETURN_VALUE dv_proc_save_file_msg_from_datalist(VOID);

/* ־صӿ */
void mfile_logout_callback( const char *s8LoggerName,
             SInt32 s32DebugLevel,
             const char *s8File,
             SInt32 s32Line,
             const char *s8Format,
             va_list vaList);


/**************************************************************************
 *                           ȫֱ                                      *
 **************************************************************************/
T_Dv_ControlParam g_Dv_Contrl_Para   = {0};               /* DVģʹõĿȫֱ */
DV_RECORD_START_PARAM_T g_Start_Para = {0};             /* Ϣ         */
static T_ZMF_Callbacks   g_zMf_CallBack;                 /* ļģص   */
ZOSS_MUTEX_ID     g_FileStopMutex        = NULL;  /* ļֹͣ       */
ZOSS_MUTEX_ID     g_VideoDataListMutex   = NULL;
ZOSS_MUTEX_ID     g_AudioDataListMutex   = NULL;

T_AMREncParam     g_EncPara;                      /* AMR              */
UINT32            g_uFileSavedId         = 0;     /* ļID             */
T_ZMFFileInfo     g_tFileInfo;                    /* ļͷļϢ   */
T_ZDrvVideo_BufInfo     g_tPostBuf;               /* buffer             */
UINT32            g_uiRecStartTime       = 0;     /* ʼ¼ʱ */
UINT32            g_uiPauseStartTime     = 0;     /* ͣʼʱ */
UINT32            g_uiPauseLastTime      = 0;     /* ͣʱ */
UINT32            g_uiTotalTime          = 0;
UINT32            g_uiCurListDataLen     = 0;     /* ǰеݳ */
UINT32            g_uAudioFrameNum       = 0;     /* Ƶ֡           */
UINT32            g_uVideoFrameNum       = 0;     /* Ƶ֡           */
ZOSS_SEMAPHORE_ID g_OpenSemp             = NULL;  /* 򿪽ӿź           */
ZOSS_SEMAPHORE_ID g_CloseSemp            = NULL;  /* رսӿź           */
ZOSS_SEMAPHORE_ID g_PauseSemp            = NULL;  /* ͣӿź           */
ZOSS_SEMAPHORE_ID g_ResumeSemp           = NULL;  /* ָӿź           */
ZOSS_SEMAPHORE_ID g_StartSemp            = NULL;  /* ʼӿź           */
ZOSS_SEMAPHORE_ID g_StopSemp             = NULL;  /* ֹͣӿź           */

/* 2009-8-5 chenyouxin  쳣Ǳ */
static DCAMERA_RETURN_VALUE_E g_ErrorCode;  /* ¼ģǱ */

static T_ZOss_List       *g_pVideoDataList        = NULL; //Ƶ
static T_ZOss_List       *g_pAudioDataList        = NULL; //Ƶ


/**************************************************************************
 ************************* Դ룬YUV********************
 **************************************************************************/
static void SaveYUVData(T_ZDrv_ImageDataBuf imageData, UINT32 iWidth, UINT32 iHeight, UINT32 uiIndex)
{
    FILE   *fp           = NULL;    
    SINT32  iRet         = -1;
    CHAR    filename[50] = {0};

    sprintf(filename, "%s%d%s", "C:\\yuvimg",uiIndex,".yuv");
    fp = zOss_FOpen((const CHAR *)filename, "wb");
    if (NULL == fp)
    {
        return;
    }
    
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Y,  (SSIZE_T)1, (SSIZE_T)iWidth * iHeight,   fp);
    iRet = (SINT32)zOss_FFlush(fp);
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Cb, (SSIZE_T)1, (SSIZE_T)iWidth * iHeight/4, fp);
    iRet = (SINT32)zOss_FFlush(fp);
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Cr, (SSIZE_T)1, (SSIZE_T)iWidth * iHeight/4, fp);
    iRet = (SINT32)zOss_FFlush(fp);
    
    zOss_FClose(fp);
}

static void SaveYUVData422(T_ZDrv_ImageDataBuf imageData, UINT32 iWidth, UINT32 iHeight, UINT32 uiIndex)
{
    FILE   *fp           = NULL;    
    SINT32  iRet         = -1;
    CHAR    filename[50] = {0};

    sprintf(filename, "%s%d%s", "C:\\yuvimg",uiIndex,".yuv");
    fp = zOss_FOpen((const CHAR *)filename, "wb");
    if (NULL == fp)
    {
        return;
    }
    
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Y,  (SSIZE_T)1, (SSIZE_T)iWidth * iHeight,   fp);
    iRet = (SINT32)zOss_FFlush(fp);
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Cb, (SSIZE_T)1, (SSIZE_T)iWidth * iHeight/2, fp);
    iRet = (SINT32)zOss_FFlush(fp);
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Cr, (SSIZE_T)1, (SSIZE_T)iWidth * iHeight/2, fp);
    iRet = (SINT32)zOss_FFlush(fp);
    
    zOss_FClose(fp);
}

/**************************************************************************
 *                     ȫֺʵ                                      *
 **************************************************************************/
/**
 * ƣ DV_Open
 *  豸
 * ˵ (IN)paramDCAMERA_SENSOR_MAIN,DCAMERA_SENSOR_SUBͷѡ
 *            (OUT)
 *   ֵ 豸ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ ֧ûжʧܲͷ豸ԺҪ
 */
DCAMERA_RETURN_VALUE_E DV_Open(DCAMERA_SENSOR_E param)
{
    T_DV_RETURN_VALUE      eDVRet       = DV_ERROR;
    DCAMERA_RETURN_VALUE_E eRet         = DCAMERA_OP_ERROR;
    SINT32                 iRet         = FALSE;
    APP_PREVIEW_E          ePreviewType = APP_PREVIEW_CAM;

    if (DV_IDLE_RECORD != g_Dv_Contrl_Para.g_DvState)
    {
        return DCAMERA_OP_ERROR;    
    }

    /* ¼豸ʱرԤʱҪжϵǰԤԤ
     * ¼ԤԤеһ״̬ǰ¼Ԥʱйرա
     * DC_GetPreviewTypeAndStateֵ˵:
     * ֵ     ֵ            ˵
     *  2           *               DCģ豸򿪣ûбʹã
     *  1         APP_PREVIEW_CAM   豸򿪣ģʹã
     *  1         APP_PREVIEW_VID   豸򿪣¼ģʹã
     *  0           *               豸ûд򿪣
     * -1           *               δ״̬
     */
     
     iRet = DC_GetPreviewTypeAndState(&ePreviewType);

     /* 豸ûд */
     if(0 == iRet)
     {
         return DCAMERA_OP_ERROR;
     }
     

     /* 豸ڱģʹãܿʼ¼ */
     if(1 == iRet && APP_PREVIEW_CAM == ePreviewType)
     {
         return DCAMERA_OP_ERROR;
     }
       
     /* ¼Ԥ״̬رԤ */
     if(1 == iRet && APP_PREVIEW_VID == ePreviewType)
     {
         eRet = DC_Stoppreview();
         if(eRet != DCAMERA_OP_SUCCESS)
         {
             return DCAMERA_OP_ERROR;
         }
     }


    /* ʼȫֱ */
    eDVRet = dv_init();
    if (DV_SUCCESS != eDVRet)
    {
        return DCAMERA_OP_ERROR;
    }
    
    /* 2009-07-22 ޸*/
    /* ¼豸*/
    eDVRet= dv_open_ex(param);
    if(DV_SUCCESS != eDVRet)
    {
        dv_uninit();
        
        return DCAMERA_OP_ERROR;
    }   
    
    /* Ƶݲɼ߳ */
    g_Dv_Contrl_Para.pVideoReadThread = zOss_CreateThread(DV_VIDEO_READ_THREAD,
                                                          dv_video_read_entry,
                                                          0,
                                                          DV_THREAD_STACK,
                                                          DV_VREAD_THREAD_PRIORITY,
                                                          0,
                                                          1);
    if(NULL == g_Dv_Contrl_Para.pVideoReadThread)
    {
        dv_close_ex();
        dv_uninit();
        
        return DCAMERA_OP_ERROR;
    }   

    /* Ƶݲɼ߳ */
    g_Dv_Contrl_Para.pAudioReadThread = zOss_CreateThread(DV_AUDIO_READ_THREAD,
                                                          dv_audio_read_entry,
                                                          0,
                                                          DV_THREAD_STACK,
                                                          DV_AREAD_THREAD_PRIORITY,
                                                          0,
                                                          1);
    if(NULL == g_Dv_Contrl_Para.pAudioReadThread)
    {
        zOss_DeleteThread(g_Dv_Contrl_Para.pVideoReadThread);
        g_Dv_Contrl_Para.pVideoReadThread = NULL;
        
        dv_close_ex();
        dv_uninit();
    
        return DCAMERA_OP_ERROR;
    }
    
    /* ļ߳ */
    g_Dv_Contrl_Para.pFileSaveThread = zOss_CreateThread(DV_FILE_SAVE_THREAD,
                                                         dv_file_save_entry,
                                                         0,
                                                         DV_FILE_SAVE_THREAD_STACK,
                                                         DV_FSAVE_THREAD_PRIORITY,
                                                         0,
                                                         1);
    if(NULL == g_Dv_Contrl_Para.pFileSaveThread)
    {
        zOss_DeleteThread(g_Dv_Contrl_Para.pAudioReadThread);
        g_Dv_Contrl_Para.pAudioReadThread = NULL;
        
        zOss_DeleteThread(g_Dv_Contrl_Para.pVideoReadThread);
        g_Dv_Contrl_Para.pVideoReadThread = NULL;
        
        dv_close_ex();
        dv_uninit();

    
        return DCAMERA_OP_ERROR;
    }
    /* 2009-07-22 ޸*/

    g_Dv_Contrl_Para.g_DvState = DV_OPEN_RECORD;

    /* ͬ */
    zOss_GetSemaphore(g_OpenSemp, ZOSS_WAIT_FOREVER);
    zOss_GetSemaphore(g_OpenSemp, ZOSS_WAIT_FOREVER);
    zOss_GetSemaphore(g_OpenSemp, ZOSS_WAIT_FOREVER);
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DV_Close
 *  ͷ豸
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ ͷ豸ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
/*T_DV_AUDIO_DATA *DV_Close(void)*/
DCAMERA_RETURN_VALUE_E DV_Close(void)
{
    SINT32        iRet = -1;
    T_DvThreadMsg msg;

        
    if (DV_OPEN_RECORD != g_Dv_Contrl_Para.g_DvState) 
    {
        return DCAMERA_OP_ERROR;    
    }

    g_Dv_Contrl_Para.g_DvState = DV_IDLE_RECORD;
    
    msg.msg_id = EV_DV_CLOSE;

    /* Ƶݲɼ̷߳͹رϢ */
    iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pVideoReadThread, msg.msg_id);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    /* Ƶݲɼ̷߳͹رϢ */
    iRet= zMspCom_PostMsg(g_Dv_Contrl_Para.pAudioReadThread, msg.msg_id);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    zOss_GetSemaphore(g_CloseSemp, ZOSS_WAIT_FOREVER);
    zOss_GetSemaphore(g_CloseSemp, ZOSS_WAIT_FOREVER);
    zOss_GetSemaphore(g_CloseSemp, ZOSS_WAIT_FOREVER);
 
    /* ͷ¼ģ򿪵豸 */
    dv_close_ex();

    dv_uninit();

    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DV_IsStateIdle
 *  ʼ¼
 * ˵ (IN)
 *            (OUT) 
 *   ֵ ǰIDLE״̬TRUE,򷵻FALSE
 * ˵ (1) DCģر豸ʱжϵǰ¼ģǷIDLE״̬,
 *                ǰIDLE״̬ر豸
 *            (2) ýӿڽŸԤģʹá
 */
BOOL DV_IsStateIdle(void)
{
    if(DV_IDLE_RECORD == g_Dv_Contrl_Para.g_DvState)
    {
        return TRUE;
    }

    return FALSE;
}

/**
 * ƣ DV_StartRecord
 *  ʼ¼
 * ˵ (IN)  param¼
 *            (OUT) 
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DV_StartRecord(DV_RECORD_START_PARAM_T *param)
{
    SINT32            iRet = -1;
    T_DvThreadMsg     msg;
//    T_ZDrv_CamOutputSize t_CamOutputSize = OUTPUT_IMG_VGA;//OUTPUT_IMG_QVGA;
    T_ZDrv_CamOutputSize t_CamOutputSize = OUTPUT_IMG_QVGA;

    /* 2009-8-5 chenyouxin */
    if(DV_OPEN_RECORD != g_Dv_Contrl_Para.g_DvState)
    {
        return DCAMERA_OP_ERROR;
    }
    /* 2009-8-5 chenyouxin */
    
    /* һЩ */
    if ((NULL == param->savefile_path) || ((FILE_3GP != param->filetype) && (FILE_MP4 != param->filetype)))
    {
        return DCAMERA_OP_ERROR;
    }
   
    g_Start_Para = *param;

    /* Ƶ⣬¼ʱᵼƵ豸
     * رʧܣ˰Ƶ豸ڴ˴򿪡
     * 2009-7-28 
     */
    if(param->audioenable)
    {
        g_Dv_Contrl_Para.g_Audio_Dev_Fd = zMspCom_AudioOpen();
        if (g_Dv_Contrl_Para.g_Audio_Dev_Fd <= 0)
        {            
            return DCAMERA_OP_ERROR; 
        }
    }

    /* Ƶ */
    msg.msg_id = EV_DV_VIDEO_OPEN_ENCODER;
    iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pVideoReadThread, msg.msg_id);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }
    zOss_GetSemaphore(g_StartSemp, ZOSS_WAIT_FOREVER);
    if(DCAMERA_OP_SUCCESS != g_ErrorCode)
    {
        g_ErrorCode = DCAMERA_OP_SUCCESS;
        return DCAMERA_OP_ERROR;
    }

    /* ˴ƵʱΪamrļͶ̬ı */
    g_Dv_Contrl_Para.eMediaAType = ZM_CODEC_ID_AMR_NB;
    g_Dv_Contrl_Para.tSampleRate = AUDIO_RATE_8_KHZ;

    /* Ϊʹ״̴̬߳ͬ״̬ĸıڽӿڵĿʼ */
    g_Dv_Contrl_Para.g_DvState = DV_START_RECORD;
    
    /* ͼС */
    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd, IOCTL_CAM_SENSOR_OUTSIZE, &t_CamOutputSize);
    if (DRV_SUCCESS != iRet)
    {
        g_Dv_Contrl_Para.g_DvState = DV_OPEN_RECORD;
        zMspCom_AudioClose();
        if(g_Dv_Contrl_Para.bAlreadyEncode)
        {
            zMspCom_CloseVideoEncoder(g_Dv_Contrl_Para.pVideoEncHandle);
            g_Dv_Contrl_Para.bAlreadyEncode = FALSE;
        
        }
        return DCAMERA_OP_ERROR;
    }
    
    /* ʼ */
    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd,IOCTL_CAM_START, NULL);
    if (iRet != DRV_SUCCESS)
    {
        g_Dv_Contrl_Para.g_DvState = DV_OPEN_RECORD;
        zMspCom_AudioClose();
        if(g_Dv_Contrl_Para.bAlreadyEncode)
        {
            zMspCom_CloseVideoEncoder(g_Dv_Contrl_Para.pVideoEncHandle);
            g_Dv_Contrl_Para.bAlreadyEncode = FALSE;
        
        }
        return DCAMERA_OP_ERROR;
    }
       

    /* ļ̷߳ͳʼϢ */
    msg.msg_id = EV_DV_FILE_INIT_INTER;
    iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pFileSaveThread, msg.msg_id);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd,IOCTL_CAM_STOP, NULL);
        g_Dv_Contrl_Para.g_DvState = DV_OPEN_RECORD;
        zMspCom_AudioClose();
        if(g_Dv_Contrl_Para.bAlreadyEncode)
        {
            zMspCom_CloseVideoEncoder(g_Dv_Contrl_Para.pVideoEncHandle);
            g_Dv_Contrl_Para.bAlreadyEncode = FALSE;
        
        }
        return DCAMERA_OP_ERROR;
    } 
    zOss_GetSemaphore(g_StartSemp, ZOSS_WAIT_FOREVER);
    if(DCAMERA_OP_SUCCESS != g_ErrorCode)
    {
        zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd,IOCTL_CAM_STOP, NULL);
        g_ErrorCode = DCAMERA_OP_SUCCESS; /* Ǹλ */
        g_Dv_Contrl_Para.g_DvState = DV_OPEN_RECORD;
        zMspCom_AudioClose();
        if(g_Dv_Contrl_Para.bAlreadyEncode)
        {
            zMspCom_CloseVideoEncoder(g_Dv_Contrl_Para.pVideoEncHandle);
            g_Dv_Contrl_Para.bAlreadyEncode = FALSE;
        
        }
        return DCAMERA_OP_ERROR;
    }

     g_uiRecStartTime       = zOss_GetTickCount();
     g_uiPauseStartTime     = 0;
     g_uiPauseLastTime      = 0;
     g_uiTotalTime          = 0;
     g_uiCurListDataLen     = 0;

     /* Ƶݲɼ̳߳ʼϢ */
    if(param->audioenable)
    {
        /* Ƶɼ̷߳ͳʼϢ */
        msg.msg_id = EV_DV_AUDIO_INIT_INTER;
        iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pAudioReadThread, msg.msg_id);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd,IOCTL_CAM_STOP, NULL);
            g_Dv_Contrl_Para.g_DvState = DV_OPEN_RECORD;
            zMspCom_AudioClose();
            if(g_Dv_Contrl_Para.bAlreadyEncode)
            {
                zMspCom_CloseVideoEncoder(g_Dv_Contrl_Para.pVideoEncHandle);
                g_Dv_Contrl_Para.bAlreadyEncode = FALSE;
            
            }
            return DCAMERA_OP_ERROR;
        }

        zOss_GetSemaphore(g_StartSemp, ZOSS_WAIT_FOREVER);
        if(g_ErrorCode != DCAMERA_OP_SUCCESS)
        {
            zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd,IOCTL_CAM_STOP, NULL);
            g_ErrorCode = DCAMERA_OP_SUCCESS;
            g_Dv_Contrl_Para.g_DvState = DV_OPEN_RECORD;
            zMspCom_AudioClose();
            if(g_Dv_Contrl_Para.bAlreadyEncode)
            {
                zMspCom_CloseVideoEncoder(g_Dv_Contrl_Para.pVideoEncHandle);
                g_Dv_Contrl_Para.bAlreadyEncode = FALSE;
            
            }
            return DCAMERA_OP_ERROR;
        }
    }
 
    /* Ƶݲɼ߳̿ʼɼ*/
    msg.msg_id = EV_DV_START;

    iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pVideoReadThread, msg.msg_id);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd,IOCTL_CAM_STOP, NULL);
        g_Dv_Contrl_Para.g_DvState = DV_OPEN_RECORD;
        zMspCom_AudioClose();
        if(g_Dv_Contrl_Para.bAlreadyEncode)
        {
            zMspCom_CloseVideoEncoder(g_Dv_Contrl_Para.pVideoEncHandle);
            g_Dv_Contrl_Para.bAlreadyEncode = FALSE;
        
        }
        return DCAMERA_OP_ERROR;
    }


    /* Ƶݲɼ߳̿ʼɼƵ*/
    if(param->audioenable)
    {
        /* Ƶɼ̷߳ƵɼϢ */
        msg.msg_id = EV_DV_START;
        iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pAudioReadThread, msg.msg_id);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd,IOCTL_CAM_STOP, NULL);     
            g_Dv_Contrl_Para.g_DvState = DV_OPEN_RECORD;
            zMspCom_AudioClose();
            if(g_Dv_Contrl_Para.bAlreadyEncode)
            {
                zMspCom_CloseVideoEncoder(g_Dv_Contrl_Para.pVideoEncHandle);
                g_Dv_Contrl_Para.bAlreadyEncode = FALSE;
            
            }
            return DCAMERA_OP_ERROR;
        }
    }   

    zOss_GetSemaphore(g_StartSemp, ZOSS_WAIT_FOREVER);

    if (param->audioenable)
    {
        zOss_GetSemaphore(g_StartSemp, ZOSS_WAIT_FOREVER);
    }

    return DCAMERA_OP_SUCCESS;
    
}

/**
 * ƣ DV_StopRecord
 *  ֹͣ¼
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DV_StopRecord(void)
{
    SINT32        iRet = -1;
    T_DvThreadMsg msg;
    
    if ((DV_START_RECORD != g_Dv_Contrl_Para.g_DvState) && (DV_PAUSE_RECORD != g_Dv_Contrl_Para.g_DvState))
    {
        return DCAMERA_OP_ERROR;    
    }

    g_Dv_Contrl_Para.g_DvState = DV_OPEN_RECORD;
    
    msg.msg_id = EV_DV_STOP;

    /* Ƶݲɼֹ߳ͣɼ*/
    iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pVideoReadThread, msg.msg_id);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    if (g_Start_Para.audioenable)
    {
        /* Ƶݲɼֹ߳ͣɼ*/
        iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pAudioReadThread, msg.msg_id);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            return DCAMERA_OP_ERROR;
        }
    }

    /* ȴƵ̺߳ļ߳stop */
    zOss_GetSemaphore(g_StopSemp, ZOSS_WAIT_FOREVER);
    zOss_GetSemaphore(g_StopSemp, ZOSS_WAIT_FOREVER);

    if (g_Start_Para.audioenable)
    {
        zOss_GetSemaphore(g_StopSemp, ZOSS_WAIT_FOREVER);   
    }

    g_uAudioFrameNum     = 0;     /* Ƶ֡           */
    g_uVideoFrameNum     = 0;
    g_uiRecStartTime     = 0;
    g_uiPauseStartTime   = 0;
    g_uiPauseLastTime    = 0;
    g_uiTotalTime        = 0;
    g_uiCurListDataLen   = 0;

    
    /*  DV_StartRecord д򿪵Ƶ豸ر */
    if (g_Dv_Contrl_Para.g_Audio_Dev_Fd > 0)
    {
        zMspCom_AudioClose();
        g_Dv_Contrl_Para.g_Audio_Dev_Fd = 0;
    }
        
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DV_PauseRecord
 *  ͣ¼
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DV_PauseRecord(void)
{
    SINT32        iRet = -1;
    T_DvThreadMsg msg;

    
    if (DV_START_RECORD != g_Dv_Contrl_Para.g_DvState) 
    {
        return DCAMERA_OP_ERROR;    
    }
    
    g_Dv_Contrl_Para.g_DvState = DV_PAUSE_RECORD;   
    
    /* Ƶɼ̷߳ͣϢ */
    /* Ƶɼ̲߳ͣϢǸ״̬ͣ */
    msg.msg_id = EV_DV_PAUSE;
    
    iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pVideoReadThread, msg.msg_id);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    if (g_Start_Para.audioenable)
    {
        /* Ƶɼ̷߳ͣϢ */
        iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pAudioReadThread, msg.msg_id);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            return DCAMERA_OP_ERROR;
        }
    }
  
    zOss_GetSemaphore(g_PauseSemp, ZOSS_WAIT_FOREVER);
    if (g_Start_Para.audioenable)
    {
        zOss_GetSemaphore(g_PauseSemp, ZOSS_WAIT_FOREVER);  
    }
    g_uiPauseStartTime = zOss_GetTickCount();
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DV_ResumeRecord
 *  ָ¼
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DV_ResumeRecord(void)
{
    SINT32        iRet = -1;
    T_DvThreadMsg msg;

    if (DV_PAUSE_RECORD != g_Dv_Contrl_Para.g_DvState) 
    {
        return DCAMERA_OP_ERROR;    
    }
    
    g_Dv_Contrl_Para.g_DvState = DV_START_RECORD; 

    /* Ƶɼ̷߳ͻָϢ */
    msg.msg_id = EV_DV_RESUME;
    
    if (!g_Start_Para.audioenable)
    {
        g_uiPauseLastTime += zOss_GetTickCount() - g_uiPauseStartTime;
    }

    if (g_Start_Para.audioenable)
    {
        /* Ƶɼ̷߳ͻָϢ */
        iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pAudioReadThread, msg.msg_id);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            return DCAMERA_OP_ERROR;
        }
    }

    iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pVideoReadThread, msg.msg_id);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    zOss_GetSemaphore(g_ResumeSemp, ZOSS_WAIT_FOREVER);

    if (g_Start_Para.audioenable)
    {
        zOss_GetSemaphore(g_ResumeSemp, ZOSS_WAIT_FOREVER);
    }  
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DV_SetRotate
 *  ûתȡ
 * ˵ (IN)  paramת
 *            (OUT) 
 *   ֵ óɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DV_SetRotate(DROTATION_MODE_E param)
{
    /* Ϊ2960sensorûṩתùܣֻڱʱ
     * ҪȱٽԲʵָùܣҲʵָù
     * ǷҪʵ
     */
     
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DV_SetZoom
 *  ûŶȡ
 * ˵ (IN)  paramŴС
 *            (OUT) 
 *   ֵ óɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DV_SetZoom(ZOOM_LEVEL_E param)
{
    SINT32         iRet     = -1;
    T_MSP_ZOOM_LEVEL tZoomLevel = (T_MSP_ZOOM_LEVEL)param;
    
    iRet = zMspCom_SetZoom(tZoomLevel);
    if (0 != iRet)
    {
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DV_SetBright
 *  ûȡ
 * ˵ (IN)  param
 *            (OUT) 
 *   ֵ óɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DV_SetBright(BRITENESS_E level)
{
    SINT32               iRet           = -1;
    T_MSP_BRIGHTNESS_LEVEL tBriLevel = (T_MSP_BRIGHTNESS_LEVEL)level;


    iRet = zMspCom_SetBrightness(tBriLevel);
    if (0 != iRet)
    {
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DV_SetContrast
 *  ûԱȶȡ
 * ˵ (IN)  paramԱȶ
 *            (OUT) 
 *   ֵ óɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DV_SetContrast(CONTRAST_E level)
{
    SINT32             iRet         = -1;
    T_MSP_CONTRAST_LEVEL  tConLevel = (T_MSP_CONTRAST_LEVEL)level;


    iRet = zMspCom_SetContrast(tConLevel);
    if (0 != iRet)
    {
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DV_SetEffect
 *  ûЧ
 * ˵ (IN)  paramЧ
 *            (OUT) 
 *   ֵ óɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DV_SetEffect(EFFECT_TYPE_E effect)
{
    SINT32           iRet       = -1;
    T_MSP_EFFECT_LEVEL tEffectLevel = (T_MSP_EFFECT_LEVEL)effect;


    iRet = zMspCom_SetEffect(tEffectLevel);
    if (0 != iRet)
    {
        return DCAMERA_OP_ERROR;
    }

    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DV_GetFileSize
 *  ȡ¼ļȡ
 * ˵ (IN)  
 *            (OUT) lengthȡļ
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DV_GetFileSize(UINT32 *length)
{
    UINT32 uLen = 0;
    EZMFResultCode  tRet = ZMF_RS_ERROR;

    if(DV_IDLE_RECORD == g_Dv_Contrl_Para.g_DvState
      || NULL == length)
    {
        return DCAMERA_OP_ERROR;
    }

    /* g_uFileSavedId Ҫжϣ˴жϣ */
    /* ΪöýĽӿʱ 0        */
    tRet = GetCurFileLen(g_uFileSavedId, &uLen);
    if (ZMF_RS_OK != tRet)
    {
        return DCAMERA_OP_ERROR;
    }

    *length = uLen + g_uiCurListDataLen;

    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ DV_GetCurTime
 *  ȡ¼ʱ
 * ˵ (IN)  
 *            (OUT)uiTime¼ʱ
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E DV_GetCurTime(UINT32 *uiTime)
{
    if(DV_IDLE_RECORD == g_Dv_Contrl_Para.g_DvState
       || NULL == uiTime)
    {
        return DCAMERA_OP_ERROR;
    }
    
    //2009-8-24 ޸ģϲҪĵλΪ
    *uiTime = g_uiTotalTime;
    
    return DCAMERA_OP_SUCCESS;
}



/**************************************************************************
 *                      ֲʵ                                      *
 **************************************************************************/
/**
 * ƣ dv_video_read_entry
 *  Ƶݻȡ߳ں
 * ˵ (IN)  iArg: ߳ں32Ϊ
 *            (OUT) 
 *   ֵ 
 * ˵ 
 **/
static VOID dv_video_read_entry(SINT32 iArg)
{
    UINT32             uiMsg;
    BOOL               quit_flag = FALSE;

    zOss_PutSemaphore(g_OpenSemp);
    
    /* Ϣѭ */
    while( (!quit_flag) && (MSP_COM_OP_SUCCESS == zMspCom_RecvMsg(&uiMsg, ZOSS_WAIT_FOREVER)))
    {        
        switch(uiMsg)
        {
            case EV_DV_START:
            {
                /* ¼Ϣд */
                dv_get_video_data();  
                zOss_PutSemaphore(g_StartSemp);

                break;               
            }
            case EV_DV_VIDEO_OPEN_ENCODER:
            {
                dv_open_video_encoder();
                
                zOss_PutSemaphore(g_StartSemp);
                break;
            }

            case EV_DV_VIDEO_START_INTER:
            {
                dv_get_video_data();

                break;
            }

            case EV_DV_PAUSE:
            {
                dv_video_proc_pause_msg();
                zOss_PutSemaphore(g_PauseSemp);   

                break;
            }

            case EV_DV_PAUSE_INTER:
            {
                dv_video_proc_pause_msg();

                break;
            }

            case EV_DV_RESUME:
            {
                dv_get_video_data();
                zOss_PutSemaphore(g_ResumeSemp);
                
                break;
            }
                      
            case EV_DV_STOP:
            {
                dv_video_proc_stop_msg();
                zOss_PutSemaphore(g_StopSemp);

                break;               
            }

            case EV_DV_CLOSE:
            {
                T_DvThreadMsg     msg;

                quit_flag = TRUE;

                /* ļ̷ֹ߳ͣϢ */
                msg.msg_id = EV_DV_FILECLOSE_INTER;
                zMspCom_PostMsg(g_Dv_Contrl_Para.pFileSaveThread, msg.msg_id);
                
                zOss_PutSemaphore(g_CloseSemp);

                break;
            }
           
            default:
            {
                break;
            }
        }                               
    }

    return;
}

/**
 * ƣ dv_audio_read_entry
 *  Ƶݻȡ߳ں
 * ˵ (IN)  iArg: ߳ں32Ϊ
 *            (OUT) 
 *   ֵ 
 * ˵ 
 **/
static VOID dv_audio_read_entry(SINT32 iArg)
{
    UINT32            uiMsg;
    BOOL              quit_flag = FALSE;
    T_DV_RETURN_VALUE eDVRet    = DV_ERROR;

    zOss_PutSemaphore(g_OpenSemp);
    
    /* Ϣѭ */
    while ((!quit_flag) && (MSP_COM_OP_SUCCESS == zMspCom_RecvMsg(&uiMsg, ZOSS_WAIT_FOREVER)))
    {        
        switch(uiMsg)
        {
            case EV_DV_AUDIO_INIT_INTER:
            {
                eDVRet = dv_audio_init();
                if(eDVRet != DV_SUCCESS)
                {
                     g_ErrorCode = DCAMERA_OP_ERROR;
                }
                zOss_PutSemaphore(g_StartSemp);
                
                break;               
            }
            case EV_DV_START:
            {
                /* ¼Ϣд */   
                dv_get_audio_data();
                zOss_PutSemaphore(g_StartSemp);
                
                break;               
            }
            case EV_DV_AUDIO_START_INTER:
            {
                dv_get_audio_data();

                break;
            }
            
            case EV_DV_PAUSE:
            {
                dv_audio_proc_pause_msg();
                zOss_PutSemaphore(g_PauseSemp);
                
                break;               
            }            
            case EV_DV_RESUME:
            {
                dv_audio_proc_resume_msg();
                zOss_PutSemaphore(g_ResumeSemp);

                break;               
            }
            case EV_DV_STOP:
            {
                dv_audio_proc_stop_msg();
                zOss_PutSemaphore(g_StopSemp);

                break;               
            } 

            case EV_DV_CLOSE:
            {
                quit_flag = TRUE;

                zOss_PutSemaphore(g_CloseSemp);
                
                break;
            }
                   
            default:
                break;
        }                               
    }

    return;    
}

/**
 * ƣ dv_file_save_entry
 *  ¼ļ߳ں
 * ˵ (IN)  iArg: ߳ں32Ϊ
 *            (OUT) 
 *   ֵ 
 * ˵ 
 **/

static VOID dv_file_save_entry(SINT32 iArg)
{
    UINT32                 uiMsg;
    BOOL                   quit_flag  = FALSE;
    T_DV_RETURN_VALUE      tDVRet;
   
    zOss_PutSemaphore(g_OpenSemp);
    
    /* Ϣѭ */
    while ((!quit_flag) && (MSP_COM_OP_SUCCESS == zMspCom_RecvMsg(&uiMsg, ZOSS_WAIT_FOREVER)))
    {        
        switch(uiMsg)
        {
            case EV_DV_FILE_INIT_INTER:
            {
                tDVRet = dv_filesave_init();
                if(tDVRet != DV_SUCCESS)
                {
                    g_ErrorCode = DCAMERA_OP_ERROR;
                }
                zOss_PutSemaphore(g_StartSemp);
                
                break;
            }

            case EV_DV_FILE_SAVEAUDIO_INTER:
            case EV_DV_FILE_SAVEVIDEO_INTER:
            {
                dv_proc_save_file_msg_from_datalist();
                
                break;
            }
                            
            case EV_DV_FILESTOP_INTER:
            {
                dv_file_proc_stop_msg();
                zOss_PutSemaphore(g_StopSemp);

                break;               
            } 

            case EV_DV_FILECLOSE_INTER:
            {
                /* ƵƵͬʱcloseϢ˴ǷҪ */
                quit_flag = TRUE;

                zOss_PutSemaphore(g_CloseSemp);

                break;
            }
           
            default:
                break;
        }                               
    }

    return;    
}

/**
 * ƣ dv_openprevew
 *  ¼Ԥ
 * ˵ (IN)  Ԥṹ DV_RECORD_START_PARAM_T
 *            (OUT) 
 *   ֵ ɹDV_SUCCESS; ʧܷDV_ERROR
 * ˵ 
 **/
static T_DV_RETURN_VALUE dv_openpreview(T_DV_CAM_PARAM *param)
{
    /* sensoròȣʱ豸ģ
     * ԤʱҪٴ豸˴豸ɾ
     * ʹ
     */
    SINT32 iRet = -1;
    
    if (g_Dv_Contrl_Para.g_Camra_Dev_Fd < 0)
    {
        return DV_ERROR;
    }

    /* ͷ */
    dv_set_camera_para(param);

    /* ʼ */
    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd,IOCTL_CAM_START, NULL);
    if (iRet != DRV_SUCCESS)
    {
        return DV_ERROR;
    }
    
    return DV_SUCCESS;
}

/**
 * ƣ dv_open_ex
 *  豸
 * ˵ (IN)  paramDCAMERA_SENSOR_MAIN,DCAMERA_SENSOR_SUBͷѡ
 *            (OUT) 
 *   ֵ 豸ɹDV_SUCCESS;򷵻DV_ERROR
 * ˵ 
 */
static T_DV_RETURN_VALUE dv_open_ex(DCAMERA_SENSOR_E param)
{   
    /* camera豸 */
    g_Dv_Contrl_Para.g_Camra_Dev_Fd = zMspCom_GetCamFd();
    if (g_Dv_Contrl_Para.g_Camra_Dev_Fd <= 0)
    {
        return DV_ERROR;
    }

    /*  2009-07-23 ޸ */
    g_Dv_Contrl_Para.g_Video_Dev_Fd = zMspCom_GetVideoFd();
    if (g_Dv_Contrl_Para.g_Video_Dev_Fd <= 0)
    {
        g_Dv_Contrl_Para.g_Camra_Dev_Fd = 0;
        return DV_ERROR; 
    }

    /* ¼ͷѡҪԺɾҪʹõĿΪ̲߳ */
    g_Dv_Contrl_Para.g_DVsensor = param;
    
    return DV_SUCCESS;
}

/**
 * ƣ dv_close_ex
 *  ر¼õ豸
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ ɹDV_SUCCESS; ʧܷDV_ERROR
 * ˵   
 **/
static T_DV_RETURN_VALUE dv_close_ex(VOID)
{
    if (g_Dv_Contrl_Para.g_Video_Dev_Fd > 0)
    {
        g_Dv_Contrl_Para.g_Video_Dev_Fd = 0;
    }

    /* رcamera豸camera豸򿪵 */
    if (g_Dv_Contrl_Para.g_Camra_Dev_Fd> 0)
    {
        g_Dv_Contrl_Para.g_Camra_Dev_Fd= 0;
    }

    return DV_SUCCESS;
   
}

/**
 * ƣ dv_open_video_encoder
 *  Ƶ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ 
 * ˵ 
 **/
static VOID dv_open_video_encoder(VOID)
{
    T_VideoEncInitParam    tEncInitParam   = {0};   
    T_VideoEncInstParam   *pVideoEncHandle = NULL;
    
    /* ʼ */
    if(!g_Dv_Contrl_Para.bAlreadyEncode)
    {
        UINT32             uiFrameRate = DV_VIDEO_FRAME_RATE;
        UINT32             uiBitrate   = DV_VIDEO_BIT_RATE_NORMAL;
        T_ZDrv_RotateType  tRotate     = ROT_0;
        T_ZDrv_MirrorType  tMirror     = MIR_NONE;

        /* û¼ñ */
        if(QUALITY_LOW == g_Start_Para.quality)
        {
            uiBitrate = DV_VIDEO_BIT_RATE_LOW;
        }
        else if(QUALITY_HIGHT == g_Start_Para.quality)
        {
            uiBitrate = DV_VIDEO_BIT_RATE_HIGH;
        }
        else if(QUALITY_NORMAL == g_Start_Para.quality)
        {
            uiBitrate = DV_VIDEO_BIT_RATE_NORMAL;
        }
        else
        {
            uiBitrate = DV_VIDEO_BIT_RATE_HIGH;
        }
               
        /* ñ뿪ʼ */
        tEncInitParam.tCodecStd    = VIDEO_CODEC_STD_AVC;
        tEncInitParam.tMirror      = tMirror;
        tEncInitParam.tPixelFmt    = PIXEL_YCbCr420;
        tEncInitParam.tRotate      = tRotate;
        tEncInitParam.uiBitrate    = uiBitrate;
        tEncInitParam.uiFrameRate  = uiFrameRate;
        tEncInitParam.uiHeight     = 144;
        tEncInitParam.uiStride     = 176;
        tEncInitParam.uiVideoFd    = (UINT32)g_Dv_Contrl_Para.g_Video_Dev_Fd;
        tEncInitParam.uiWidth      = 176;
                    
        /* 򿪱 */
        pVideoEncHandle = zMspCom_OpenVideoEncoder(&tEncInitParam);
        if (NULL == pVideoEncHandle)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;
            return;
        }
        
        g_Dv_Contrl_Para.bAlreadyEncode = TRUE;
        g_Dv_Contrl_Para.pVideoEncHandle = pVideoEncHandle;
    }
}

/**
 * ƣ dv_get_video_data
 *  ɼƵ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ 
 * ˵ 
 **/
static VOID dv_get_video_data(VOID)
{
    SINT32                  iRet = -1;
    T_DV_RETURN_VALUE       tDVRet = DV_ERROR;
    T_DvThreadMsg           msg;
    T_ZDrv_CamDataInfo      t_CamData;
    T_ZDrvVideo_PpuOSDInfo  t_OsdInfo;
 
    /* bufferڱ */
    T_ZDrvVideo_BufInfo     t_EncodePpuBuf;
    T_ZDrvVideo_PpuInfo     t_EncodePpuInfo;
    T_ZDrvVideo_PpuOutPut   t_EncodePpuOutPut;
    T_ZDrvVideo_PpuInPut    t_EncodePpuInPut;
    
    if (DV_START_RECORD != g_Dv_Contrl_Para.g_DvState)
    { 
        return ;
    }

    if (g_Dv_Contrl_Para.g_Camra_Dev_Fd < 0)
    {
        return;
    }
    

    /* ȡƵ */
    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd, IOCTL_CAM_GET_DATAINFO, &t_CamData);
    if (DRV_SUCCESS != iRet)
    {
        return;
    }
#if 1
    /* Cameraɼͼݽеһκˢ */
    tDVRet = dv_ppu_for_refresh_screen(&t_CamData);
    if (DV_ERROR == tDVRet)
    {
        /* ͷsensorbuffer */
        iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd, IOCTL_CAM_FREE_DATABUFFER, &t_CamData);
        return;    
    }

    /* ˢ */
    {
        RECT_T rect;

        rect.sx = 0;
        rect.sy = 0;
        rect.width = g_uiScreenWidth;
        rect.height = g_uiScreenHeight;

        Zte_OsdUpdateVideoInput(&(g_tPostBuf.pDataBuf), FALSE, &rect); 
    }
#endif

    /* ͷͼתΪ176*144ڱ */
    {
        t_EncodePpuInPut.uiStartX     = 0;
        t_EncodePpuInPut.uiStartY     = 0;
        t_EncodePpuInPut.uiWidth      = t_CamData.Width;
        t_EncodePpuInPut.uiHeight     = t_CamData.Height;
        t_EncodePpuInPut.uiStride     = t_CamData.Width;  
        t_EncodePpuInPut.tPixelFmt    = t_CamData.pixeFmt;
        t_EncodePpuInPut.pInPutbuffer = t_CamData.dataBuf;

        t_EncodePpuOutPut.uiWidth     = 176;
        t_EncodePpuOutPut.uiHeight    = 144;
        t_EncodePpuOutPut.uiStride    = 176;  
        t_EncodePpuOutPut.tPixelFmt   = PIXEL_YCbCr420;

        t_EncodePpuBuf.bufSize.YuvBufSize.ySize  = 176 * 144;
        t_EncodePpuBuf.bufSize.YuvBufSize.uSize  = 176 * 144 / 4;
        t_EncodePpuBuf.bufSize.YuvBufSize.vSize  = 176 * 144 / 4;
        t_EncodePpuBuf.bufType = YUV_TYPE;
    
        {
            /* Ԥݱ浽ļУԴ */
            BOOL    bNeedSave = FALSE;
            UINT32  uiWidth   = 320;
            UINT32  uiHeight  = 240;
            
            if(bNeedSave)
            {
                bNeedSave = FALSE;
                SaveYUVData(t_EncodePpuInPut.pInPutbuffer, uiWidth, uiHeight,320240);
            }
        }

    
        /* buffer */
        iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Video_Dev_Fd, IOCTL_VIDEO_GET_BUFINFO, &t_EncodePpuBuf);
        if (DRV_SUCCESS != iRet)
        {
            /* ͷsensorbuffer */
            iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd, IOCTL_CAM_FREE_DATABUFFER, &t_CamData);
                
            return;
        }
 
        t_EncodePpuOutPut.pOutPutbuffer = t_EncodePpuBuf.pDataBuf;  

        t_OsdInfo.bEnable = FALSE;

        t_EncodePpuInfo.inputInfo = t_EncodePpuInPut;
        t_EncodePpuInfo.outputInfo = t_EncodePpuOutPut;
        t_EncodePpuInfo.osdInfo = t_OsdInfo;
    
        /* Ƶ */
        iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Video_Dev_Fd, IOCTL_VIDEO_POSTPROCESS, &t_EncodePpuInfo);
        if (DRV_SUCCESS != iRet)
        {        
            /* ͷsensorbuffer */ 
            iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd, IOCTL_CAM_FREE_DATABUFFER, &t_CamData);
            return;
        }

        /* ͷsensorbuffer */
        iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd, IOCTL_CAM_FREE_DATABUFFER, &t_CamData);
               

    }
        msg.msg_id = EV_DV_VIDEO_START_INTER;
        
        /* Ƶݲɼ߳̿ʼɼ*/   
        iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pVideoReadThread, msg.msg_id);
        if(iRet != MSP_COM_OP_SUCCESS)
        {        
            return ;
        }    

    
#if 1    
    /* ֻ¼״̬²ű룬ͣ״̬£ֻˢб뱣 */
    if (DV_START_RECORD == g_Dv_Contrl_Para.g_DvState) 
    {
        UINT32           uTime = 0;
        UINT32           uiVideoInst = 0;
        Bool8            IsKeyFrame  = FALSE;

        /* пƵ */
        VOID                  *pVideoEncData = NULL;
        UINT32                 uiVideoEncDataLen = 0;
        T_VideoEncInstParam   *pVideoEncHandle = NULL;
        T_VideoEncParam        tVideoEncParam  = {0};

        /* ñһ֡Ƶ */
        tVideoEncParam.bIsBufferValid = FALSE;
        tVideoEncParam.pDataIn        = t_EncodePpuOutPut.pOutPutbuffer;
        tVideoEncParam.pDataOut       = NULL;
        tVideoEncParam.uiLenOut       = 0;
 
        {
            /* Ԥݱ浽ļУԴ */
            BOOL    bNeedSave = FALSE;
            UINT32  uiWidth   = 176;
            UINT32  uiHeight  = 144;
            
            if(bNeedSave)
            {
                SaveYUVData(t_EncodePpuOutPut.pOutPutbuffer, uiWidth, uiHeight,176144);
            }
        }
 
        pVideoEncHandle = g_Dv_Contrl_Para.pVideoEncHandle;
        
        /* ʼһ֡Ƶ */
        iRet = zMspCom_VideoEncode(pVideoEncHandle, &tVideoEncParam);
        if (MSP_COM_OP_SUCCESS != iRet)
        {             
            /* ͷĺbuffer */ 
            iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Video_Dev_Fd, IOCTL_VIDEO_FREE_BUFFER, &t_EncodePpuBuf);
            
            return;  
        }

        uiVideoEncDataLen = tVideoEncParam.uiLenOut;
        pVideoEncData     = tVideoEncParam.pDataOut;
                
        if(I_FRAME == tVideoEncParam.frameType)
        {
            IsKeyFrame = TRUE;
        }
        else
        {
            IsKeyFrame = FALSE;
        }
                    
        if (g_Start_Para.audioenable)
        {
            //¼ƵΪ׼ΪƵʱ
            uTime = g_uAudioFrameNum * DV_AUDIO_DECODE_TIME;
        }
        else
        {
            uTime = zOss_GetTickCount() - g_uiRecStartTime - g_uiPauseLastTime;
        }
        g_uiTotalTime = uTime;
        tDVRet = dv_write_to_video_datalist(pVideoEncData, uiVideoEncDataLen, uTime,IsKeyFrame);
        if (DV_SUCCESS != tDVRet)  /* ˴Ҫbuffer */
        {   
            zOss_Free(pVideoEncData);
            uiVideoEncDataLen = 0;
            
            /* ͷĺbuffer */ 
            iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Video_Dev_Fd, IOCTL_VIDEO_FREE_BUFFER, &t_EncodePpuBuf);
            return;
        }
        g_uVideoFrameNum++;
        g_uiCurListDataLen += uiVideoEncDataLen;
        /* ļ̷߳ͱϢ */
        msg.msg_id = EV_DV_FILE_SAVEVIDEO_INTER;
        iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pFileSaveThread, msg.msg_id);
        if (iRet != MSP_COM_OP_SUCCESS)
        {           
            /* ͷĺbuffer */ 
            iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Video_Dev_Fd, IOCTL_VIDEO_FREE_BUFFER, &t_EncodePpuBuf);
                
            return ;
        }                   
    }
    
#endif
       
    /* ͷĺbuffer */ 
    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Video_Dev_Fd, IOCTL_VIDEO_FREE_BUFFER, &t_EncodePpuBuf);

    return;
}



/**
 * ƣ mfile_logout_callback
 *  ־صӿ
 * ˵ (In)  
 *            (Out)  
 *   ֵ 
 * ˵ ˺ΪļģصһԱΪգʼ
 *            ļģ鲻ɹ˴˺һʵ    
 **/
void mfile_logout_callback(const char *s8LoggerName,
                           SInt32 s32DebugLevel,
                           const char *s8File,
                           SInt32 s32Line,
                           const char *s8Format,
                           va_list vaList)
{
    return;
}

/**
 * ƣ dv_get_audio_data
 *  ɼƵ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ 
 * ˵ 
 **/
static VOID dv_get_audio_data(VOID)
{
    SINT32              iRet = -1;
    BOOL                bSaveAudio = FALSE;
    T_DvThreadMsg       msg;
    T_ZDrvAudio_BufInfo tAudioBuf;
    T_DV_RETURN_VALUE   tDVRet = DV_ERROR;
    
    if (DV_START_RECORD != g_Dv_Contrl_Para.g_DvState)
    {
        return ;
    }
  
    /* ¼ʱȥbuffer */
    iRet = zDrv_Read((UINT32)g_Dv_Contrl_Para.g_Audio_Dev_Fd, (VOID *)&tAudioBuf, 320); /*uiLenҪдȻжԣ96Ľӿĵ */
    if (DRV_SUCCESS != iRet)
    {
        return;
    }

    tDVRet = dv_encode_one_frame_audio_data(&tAudioBuf); 
    if (DV_SUCCESS != tDVRet)
    {
        /* ͷƵbuffer */
        zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Audio_Dev_Fd, IOCTL_AUDIO_RCD_FREE_BUFF, (VOID *)(tAudioBuf.buf));

        /* Ƶɼ̷߳ͼɼƵϢ */
        msg.msg_id = EV_DV_AUDIO_START_INTER;
        iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pAudioReadThread, msg.msg_id);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            return ;
        }
        return;
    }   

    /* ͷƵbuffer */
    /* Ľӿڶڸ÷ֵ⣬96ĽӿĵҪ޸ */
    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Audio_Dev_Fd, IOCTL_AUDIO_RCD_FREE_BUFF, (VOID *)(tAudioBuf.buf));
    if (DV_SUCCESS != iRet)
    {
        return;
    }

    /* Ƶɼ̷߳ͼɼƵϢ */
    msg.msg_id = EV_DV_AUDIO_START_INTER;
    iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pAudioReadThread, msg.msg_id);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return ;
    }

    g_uAudioFrameNum++;
    bSaveAudio = dv_is_send_save_audio_msg();
    if (TRUE == bSaveAudio)
    {        
        /* ļ̷߳Ϣļ */
        msg.msg_id = EV_DV_FILE_SAVEAUDIO_INTER;    
        iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pFileSaveThread, msg.msg_id);
        if (MSP_COM_OP_SUCCESS != iRet)
        {
            return;
        }
    }
}



/**
 * ƣ dv_init_audio_encoder
 *  ʼamr
 * ˵ (IN)  t_pEncPara: amrʼ
 *            (OUT) 
 *   ֵ DV_SUCCESS: ɹ
 *            DV_ERROR  : ʧ
 * ˵ 
 **/
static T_DV_RETURN_VALUE dv_init_audio_encoder(EMediaAudioType         eMediaAType, T_MediaAudioEncHandle **pHandle,  
                                               T_ZDrvAudio_SampleRate  tSampleRate, UINT32    *pFrameLen)
{
    SINT32                    iRet = -1;
    UINT32                    uiFrameLen  = 0;
    T_MediaAudioEncHandle    *pEncHandle  = NULL;

    if(NULL == pHandle || NULL == pFrameLen)
    {
        zMspCom_Print();

        return DV_ERROR;
    }

    /* ر */
    iRet = zMspCom_LoadAudioEnCodeLib(eMediaAType);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return DV_ERROR;
    }

    /* 򿪱 */
    if(ZM_CODEC_ID_AMR_NB == eMediaAType)
    {
        pEncHandle = zMspCom_OpenAudioEncoder(eMediaAType, NULL, &uiFrameLen);
    }
    else if(ZM_CODEC_ID_MP3 == eMediaAType)
    {
        T_MP3AddEnCoderData tAddData;

        /* MP3 */
        tAddData.iBitrate    = MP3_ENC_BITRATE;
        tAddData.iChannelIn  = ONE_CHANNEL;
        tAddData.iChannelOut = ONE_CHANNEL;
        tAddData.iSampleRate = PCM_SAMPLE_RATE;
        
        pEncHandle = zMspCom_OpenAudioEncoder(eMediaAType, &tAddData, &uiFrameLen);
    }

    if(NULL == pEncHandle)
    {
        zMspCom_Print();
        zMspCom_UnLoadAudioEnCodeLib(eMediaAType);
        
        return DV_ERROR;
    }

    *pHandle   = pEncHandle;
    *pFrameLen = uiFrameLen;
    
    return DV_SUCCESS;
}

/**
 * ƣ dv_audio_proc_pause_msg
 *  ¼ͣϢ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ 
 * ˵ 
 **/ 
static VOID dv_audio_proc_pause_msg(VOID)
{
    SINT32 iRet = -1;
    
    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Audio_Dev_Fd, IOCTL_AUDIO_RECORD_STOP, NULL);   
    if(iRet != DRV_SUCCESS)
    {
        zMspCom_Print();
        return;
    }
    return;
}

/**
 * ƣ dv_audio_proc_stop_msg
 *  ¼ֹͣϢ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ 
 * ˵ 
 **/ 
static VOID dv_audio_proc_stop_msg(VOID)
{
    SINT32        iRet = -1;

    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Audio_Dev_Fd, IOCTL_AUDIO_RECORD_STOP, NULL); 

    /* ͷŽ */
    dv_uninit_audio_encoder(g_Dv_Contrl_Para.pAudioEncHandle);
    zOss_Memset(&g_EncPara, 0, sizeof(T_AMREncParam));

    if(iRet != DRV_SUCCESS)
    {
        zMspCom_Print();
        return;
    }

    return;
}

/**
 * ƣ dv_audio_proc_resume_msg
 *  ¼ָ¼Ϣ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ 
 * ˵ 
 **/ 
static VOID dv_audio_proc_resume_msg(VOID)
{
    SINT32            iRet = -1;
    T_DvThreadMsg     msg;
    T_DV_RETURN_VALUE tDVRet = DV_ERROR;

    tDVRet = dv_set_audio_record_para();
    if (DV_SUCCESS != tDVRet)
    {
        /* ˴¼ʧʱǷûһЩĬϵĲ */
        return;
    }
    
    tDVRet = dv_audio_record_start();
    if (DV_SUCCESS != tDVRet)
    {
        return;
    }

    g_uiPauseLastTime += zOss_GetTickCount() - g_uiPauseStartTime;
 
    /* Ƶɼ̷߳ͼɼƵϢ */
    msg.msg_id = EV_DV_AUDIO_START_INTER;
    iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pAudioReadThread, msg.msg_id);
    return;
}

/**
 * ƣ dv_audio_record_start
 *  ¼ʼϢ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ DV_SUCCESS: ɹ
 *            DV_ERROR  : ʧ
 * ˵ 
 **/ 
static T_DV_RETURN_VALUE dv_audio_record_start(VOID)
{
    SINT32              iRet = -1;
    T_ZDrvRcd_InfoParam t_RcdPara;

    t_RcdPara.bufsize = DV_RECD_AUDIO_BUFFER_SIZE;  /*160 * sizeof(SINT16);*/ 
    t_RcdPara.dataformat = RECORD_DATA_FORMAT_AMR;

    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Audio_Dev_Fd, IOCTL_AUDIO_RECORD_START, &t_RcdPara);  
    if (DRV_SUCCESS != iRet)
    {
        return DV_ERROR;
    }
    
    return DV_SUCCESS;
}

/**
 * ƣ dv_create_file
 *  ļ
 * ˵ (IN)  pFileName: ļ
 *            (OUT) 
 *   ֵ DV_SUCCESS: ɹ
 *            DV_ERROR  : ʧ
 *            DV_FILETYPE_ERROR: ļʹ
 * ˵ 
 **/ 
static T_DV_RETURN_VALUE dv_create_file(const CHAR *pFileName, BOOL bAudioFlag)
{
    UINT8 cValue[] = "zte0345";
    EZMFResultCode     eRet = ZMF_RS_ERROR;
    UINT32             uiBitrate = DV_VIDEO_BIT_RATE_NORMAL;
    
    if (NULL == pFileName)
    {
        return DV_ERROR;
    }

    /* ԱamrʽƵļ */
    eRet = OpenMediaFileHandler((const char *)pFileName, ZMF_FILE_WRITE, &g_uFileSavedId);
    if (eRet != ZMF_RS_OK)
    {
        return DV_ERROR;
    }

    zOss_Memset(&g_tFileInfo, 0, sizeof(T_ZMFFileInfo));

    if (g_Start_Para.filetype == FILE_3GP)
    {
        g_tFileInfo.eFileType = ZM_FileID_3GP;
    }
    else if (g_Start_Para.filetype == FILE_MP4)
    {
        g_tFileInfo.eFileType = ZM_FileID_MP4;
    }
    else
    {
        CloseMediaFileHandler(g_uFileSavedId);
        return DV_FILETYPE_ERROR;
    }
    
    /* û¼ñ */
    if(QUALITY_LOW == g_Start_Para.quality)
    {
        uiBitrate = DV_VIDEO_BIT_RATE_LOW;
    }
    else if(QUALITY_HIGHT == g_Start_Para.quality)
    {
        uiBitrate = DV_VIDEO_BIT_RATE_HIGH;
    }
    else if(QUALITY_NORMAL == g_Start_Para.quality)
    {
        uiBitrate = DV_VIDEO_BIT_RATE_NORMAL;
    }
    else
    {
        uiBitrate = DV_VIDEO_BIT_RATE_HIGH;
    }
  
    /* 챣ļһЩͷϢ */
    /* ¼¼ */
    if (bAudioFlag)
    {
        g_tFileInfo.tFileInfo.t_isoInfo.eFileID = g_tFileInfo.eFileType;
        g_tFileInfo.tFileInfo.t_isoInfo.u32TrackNum = DV_FILE_TRACK_NUM;
        g_tFileInfo.tFileInfo.t_isoInfo.eBrand = ZMF_Brand_3gp4;

        /* Ӧ÷װһ dv_release_file ӿڣڴ */    
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray = zOss_Malloc(2 * sizeof(ZMF_TTrackInfo));
        zOss_Memset(g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray, 0, 2 * sizeof(ZMF_TTrackInfo));

        /* һ챣ƵϢ */
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].u32TrackID   = DV_VIDEO_TRACK_ID;
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].bIsHintTrack = FALSE;
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].f64TimeScale = DV_DECODE_TIME_SCALE; 
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].u32Duration  = 224733;   /* òΪֵ */
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].eMediaType   = ZM_CODEC_TYPE_VIDEO;
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.eVideoType = ZM_CODEC_ID_H264;  
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.u32Width = DV_ENCODE_IMAGE_WIDTH;  
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.u32Height = DV_ENCODE_IMAGE_HEIGHT;  
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.u32FPS = DV_VIDEO_FRAME_RATE;  
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.s32Bitrate= uiBitrate; /*  */
        
        if(g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.eVideoType == ZM_CODEC_ID_H264) 
        {
            g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.u32PrivateParaLen = g_Dv_Contrl_Para.pVideoEncHandle->uiHeaderLen; /* ޸ */  

            g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara = (UInt8 *)zOss_Malloc(g_Dv_Contrl_Para.pVideoEncHandle->uiHeaderLen);   /* ޸ */
            zOss_Memcpy(g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara, g_Dv_Contrl_Para.pVideoEncHandle->pHeaderData, g_Dv_Contrl_Para.pVideoEncHandle->uiHeaderLen);
        }
        else
        {
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.u32PrivateParaLen = 7; /* ޸ */  
        //g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara = "zte0345";   /* ޸ */

        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara = (UInt8 *)zOss_Malloc(8);   /* ޸ */
        zOss_Memcpy(g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara, cValue, 7);
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara[6]/*[7]*/ = '\0';   /* ޸ */
        }

      
        /* ڶ챣ƵϢ */
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].u32TrackID   = DV_AUDIO_TRACK_ID;
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].f64TimeScale = 1000; 
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].u32Duration  = 10;   /* òΪֵ */
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].eMediaType   = ZM_CODEC_TYPE_AUDIO;
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].tTrackInfo.tAudioParam.eAudioType = ZM_CODEC_ID_AMR_NB; 
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].tTrackInfo.tAudioParam.s32SampleRate = DV_AUDIO_SAMPLE_RATE; 
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].tTrackInfo.tAudioParam.u8Channel = DV_AUDIO_CHANNEL_NUM; 
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].tTrackInfo.tAudioParam.uRev[0] = 0; 
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].tTrackInfo.tAudioParam.uRev[1] = 0; 
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].tTrackInfo.tAudioParam.uRev[2] = 0; 
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].tTrackInfo.tAudioParam.s32Bitrate = 0; 
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].tTrackInfo.tAudioParam.u16PacketMode = 33279; 
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].tTrackInfo.tAudioParam.u32PrivateParaLen = 0; 
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[1].tTrackInfo.tAudioParam.pPrivatePara = NULL; 

    }
    else  /* ֻ¼ */ 
    {
        g_tFileInfo.tFileInfo.t_isoInfo.eFileID = g_tFileInfo.eFileType;
        g_tFileInfo.tFileInfo.t_isoInfo.u32TrackNum = 1;
        g_tFileInfo.tFileInfo.t_isoInfo.eBrand = ZMF_Brand_3gp4;

        /* Ӧ÷װһ dv_release_file ӿڣڴ */    
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray = (ZMF_TTrackInfo *)zOss_Malloc(sizeof(ZMF_TTrackInfo));
        zOss_Memset(g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray, 0, sizeof(ZMF_TTrackInfo));

        /* һ챣ƵϢ */
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray->u32TrackID   = DV_VIDEO_TRACK_ID;
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray->bIsHintTrack = FALSE;
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray->f64TimeScale = DV_DECODE_TIME_SCALE; 
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray->u32Duration  = 224733;   /* òΪֵ */
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray->eMediaType   = ZM_CODEC_TYPE_VIDEO;
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray->tTrackInfo.tVideoParam.eVideoType = ZM_CODEC_ID_H264;  
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray->tTrackInfo.tVideoParam.u32Width = DV_ENCODE_IMAGE_WIDTH;  
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray->tTrackInfo.tVideoParam.u32Height = DV_ENCODE_IMAGE_HEIGHT;  
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray->tTrackInfo.tVideoParam.u32FPS = DV_VIDEO_FRAME_RATE;  
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.s32Bitrate= uiBitrate; /*  */
        if(g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.eVideoType == ZM_CODEC_ID_H264) 
        {
            g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.u32PrivateParaLen = g_Dv_Contrl_Para.pVideoEncHandle->uiHeaderLen; /* ޸ */  

            g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara = (UInt8 *)zOss_Malloc(g_Dv_Contrl_Para.pVideoEncHandle->uiHeaderLen);   /* ޸ */
            zOss_Memcpy(g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara, g_Dv_Contrl_Para.pVideoEncHandle->pHeaderData, g_Dv_Contrl_Para.pVideoEncHandle->uiHeaderLen);
        }
        else
        {
            g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.u32PrivateParaLen = 7; /* ޸ */  
            //g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara = "zte0345";   /* ޸ */
    
            g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara = (UInt8 *)zOss_Malloc(8);   /* ޸ */
            zOss_Memcpy(g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara, cValue, 7);
            g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara[6]/*[7]*/ = '\0';   /* ޸ */
        }

    }

    eRet = Create(g_uFileSavedId, &g_tFileInfo);
    if (eRet != ZMF_RS_OK)
    {
        zOss_Free(g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray->tTrackInfo.tVideoParam.pPrivatePara);
        zOss_Free(g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray);
        CloseMediaFileHandler(g_uFileSavedId);
        
        return DV_ERROR;
    }
    
    return DV_SUCCESS;
    
}

/**
 * ƣ dv_video_proc_pause_msg
 *  ͣ¼Ϣ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ 
 * ˵ 
 **/ 
static VOID dv_video_proc_pause_msg(VOID)
{
    SINT32                  iRet = -1;
    T_DV_RETURN_VALUE       tDVRet = DV_ERROR;
    T_DvThreadMsg           msg;
    T_ZDrv_CamDataInfo      t_CamData;

    /* 2009-8-6  ͣ״̬ѭ */
    if(g_Dv_Contrl_Para.g_DvState != DV_PAUSE_RECORD)
    {
        return;
    }
    
    /* ȡƵ */
    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd, IOCTL_CAM_GET_DATAINFO, &t_CamData);
    if (DRV_SUCCESS != iRet)
    {
        return;
    }

    /* Cameraɼͼݽеһκˢ */
    tDVRet = dv_ppu_for_refresh_screen(&t_CamData);
    if (DV_ERROR == tDVRet)
    {
        /* ͷsensorbuffer */
        iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd, IOCTL_CAM_FREE_DATABUFFER, &t_CamData);
        return;    
    }

   
    /* ͷsensorbuffer */
    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd, IOCTL_CAM_FREE_DATABUFFER, &t_CamData);

    /* ͶȡϢȡһ֡ */
    msg.msg_id = EV_DV_PAUSE_INTER;
    
    /* Ƶݲɼ߳̿ʼɼ*/   
    iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pVideoReadThread, msg.msg_id);
    if(iRet != MSP_COM_OP_SUCCESS)
    {        
        return ;
    }  

     /* ˢ */
    {
        RECT_T rect;

        rect.sx = 0;
        rect.sy = 0;
        rect.width = g_uiScreenWidth;
        rect.height = g_uiScreenHeight;

        Zte_OsdUpdateVideoInput(&(g_tPostBuf.pDataBuf), FALSE, &rect); 
    }
}

/**
 * ƣ dv_video_proc_stop_msg
 *  ֹͣ¼Ϣ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ 
 * ˵ 
 **/ 
static VOID dv_video_proc_stop_msg(VOID)
{
    SINT32 iRet = -1;
    T_DvThreadMsg msg;

    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd, IOCTL_CAM_STOP, NULL);    

    /*2009-9-1 cyx*/
    if(g_Dv_Contrl_Para.bAlreadyEncode)
    {
        zMspCom_CloseVideoEncoder(g_Dv_Contrl_Para.pVideoEncHandle);
        g_Dv_Contrl_Para.bAlreadyEncode = FALSE;

    }
    
    /* ļ̷ֹ߳ͣƵϢ */
    msg.msg_id = EV_DV_FILESTOP_INTER;  
    iRet = zMspCom_PostMsg(g_Dv_Contrl_Para.pFileSaveThread, msg.msg_id);
    
    return;    
}

/**
 * ƣ dv_file_proc_stop_msg
 *  ֹͣļϢ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ 
 * ˵ 
 **/ 
static VOID dv_file_proc_stop_msg(VOID)
{
    if (0 == g_uFileSavedId)
    {
        return;
    }

    /* бǷֹƵ߳ͬʱstopϢ */
    /* Ϣ˳ģԿıǷǶ   */
    zOss_GetMutex(g_FileStopMutex, ZOSS_WAIT_FOREVER);
    dv_save_left_audio_and_video_datalist();
    dv_close_file(); 
    zOss_PutMutex(g_FileStopMutex);

}

/**
 * ƣ dv_audio_init
 *  ƵʼϢ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ DV_SUCCESS: ɹ
 *            DV_ERROR  : ʧ
 * ˵ 
 **/ 
static T_DV_RETURN_VALUE dv_audio_init(VOID)
{
    T_DV_RETURN_VALUE tDVRet = DV_ERROR;

    /* ȽһЩʼ */
    zOss_Memset(&g_EncPara, 0, sizeof(T_AMREncParam));
    tDVRet = dv_init_audio_encoder(g_Dv_Contrl_Para.eMediaAType,
                                 &(g_Dv_Contrl_Para.pAudioEncHandle),
                                   g_Dv_Contrl_Para.tSampleRate,
                                 &(g_Dv_Contrl_Para.uiFrameLen));

    if (DV_SUCCESS != tDVRet)
    {
        return DV_ERROR;
    }
    
    tDVRet = dv_set_audio_record_para();
    if (DV_SUCCESS != tDVRet)
    {
        /* ˴¼ʧʱǷûһЩĬϵĲ */
        return DV_ERROR;
    }
    
    tDVRet = dv_audio_record_start();
    if (DV_SUCCESS != tDVRet)
    {
        return DV_ERROR;
    }
    
    return DV_SUCCESS;
}

/**
 * ƣ dv_filesave_init
 *  ļʼϢ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ DV_SUCCESS: ɹ
 *            DV_ERROR  : ʧ
 * ˵ 
 **/ 
static T_DV_RETURN_VALUE dv_filesave_init(VOID)
{
    SINT32             iRet = -1;
    T_DV_RETURN_VALUE tDVRet = DV_ERROR;
    
    if (g_Start_Para.savefile_path == NULL)
    {
        return DV_ERROR;
    }

    iRet = zMspCom_InitFileParseModule();
    if (MSP_COM_OP_SUCCESS != iRet)
    {
        return DV_ERROR;
    }
    
    tDVRet= dv_create_file(g_Start_Para.savefile_path, g_Start_Para.audioenable);
    if (DV_SUCCESS != tDVRet)
    {
        return DV_ERROR;
    }

    return DV_SUCCESS;
}

/**
 * ƣ dv_init
 *  dvģʼ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ DV_SUCCESS: ɹ
 *            DV_ERROR  : ʧ
 * ˵ 
 **/ 
static T_DV_RETURN_VALUE dv_init(VOID)
{ 
    /* ʼȫֱ */
    zOss_Memset(&g_Dv_Contrl_Para, 0, sizeof(T_Dv_ControlParam));
    zOss_Memset(&g_Start_Para, 0, sizeof(DV_RECORD_START_PARAM_T)); 
    zOss_Memset(&g_zMf_CallBack, 0, sizeof(T_ZMF_Callbacks)); 
    zOss_Memset(&g_EncPara, 0, sizeof(T_AMREncParam));          
    zOss_Memset(&g_tFileInfo, 0, sizeof(T_ZMFFileInfo)); 
    zOss_Memset(&g_tPostBuf, 0, sizeof(T_ZDrvVideo_BufInfo));

    g_ErrorCode = DCAMERA_OP_SUCCESS;
   
    /* 2009-07-22  ޸ */
    
    g_FileStopMutex  = zOss_CreateMutex(DV_FILE_STOP_MUTEX, ZOSS_NO_INHERIT);
    /* 2009-07-22  ޸ */
    if(NULL == g_FileStopMutex)
    {
        return DV_ERROR;
    }
    /* 2009-07-22  ޸ */
    
    g_VideoDataListMutex = zOss_CreateMutex(DV_VIDEO_DATALIST_MUTEX, ZOSS_NO_INHERIT);
    /* 2009-07-22  ޸ */
    if(NULL == g_VideoDataListMutex)
    {
        zOss_DeleteMutex(g_FileStopMutex);

        return DV_ERROR;
    }
    /* 2009-07-22  ޸ */

    g_AudioDataListMutex = zOss_CreateMutex(DV_AUDIO_DATALIST_MUTEX, ZOSS_NO_INHERIT);
    /* 2009-07-22  ޸ */
    if(NULL == g_AudioDataListMutex)
    {
        zOss_DeleteMutex(g_VideoDataListMutex);
        zOss_DeleteMutex(g_FileStopMutex);

        return DV_ERROR;
    }
    /* 2009-07-22  ޸ */

    g_OpenSemp       = zOss_CreateSemaphore(DV_OPEN_SEMP, 0);
    /* 2009-07-22  ޸ */
    if(NULL == g_OpenSemp)
    {
        zOss_DeleteMutex(g_AudioDataListMutex);
        zOss_DeleteMutex(g_VideoDataListMutex);
        zOss_DeleteMutex(g_FileStopMutex);

        return DV_ERROR;
    }
    /* 2009-07-22  ޸ */

    g_StartSemp      = zOss_CreateSemaphore(DV_START_SEMP, 0);
    /* 2009-07-22  ޸ */
    if(NULL == g_StartSemp)
    {
        zOss_DeleteSemaphore(g_OpenSemp);
        zOss_DeleteMutex(g_AudioDataListMutex);
        zOss_DeleteMutex(g_VideoDataListMutex);
        zOss_DeleteMutex(g_FileStopMutex);

        return DV_ERROR;
    }
    /* 2009-07-22  ޸ */

    g_StopSemp       = zOss_CreateSemaphore(DV_STOP_SEMP, 0);
    /* 2009-07-22  ޸ */
    if(NULL == g_StopSemp)
    {
        zOss_DeleteSemaphore(g_StartSemp);
        zOss_DeleteSemaphore(g_OpenSemp);
        zOss_DeleteMutex(g_AudioDataListMutex);
        zOss_DeleteMutex(g_VideoDataListMutex);
        zOss_DeleteMutex(g_FileStopMutex);

        return DV_ERROR;
    }
    /* 2009-07-22  ޸ */

    g_PauseSemp      = zOss_CreateSemaphore(DV_PAUSE_SEMP, 0);
    /* 2009-07-22  ޸ */
    if(NULL == g_PauseSemp)
    {
        zOss_DeleteSemaphore(g_StopSemp);
        zOss_DeleteSemaphore(g_StartSemp);
        zOss_DeleteSemaphore(g_OpenSemp);
        zOss_DeleteMutex(g_AudioDataListMutex);
        zOss_DeleteMutex(g_VideoDataListMutex);
        zOss_DeleteMutex(g_FileStopMutex);

        return DV_ERROR;
    }
    /* 2009-07-22  ޸ */

    g_ResumeSemp     = zOss_CreateSemaphore(DV_RESUME_SEMP, 0);
    /* 2009-07-22  ޸ */
    if(NULL == g_ResumeSemp)
    {
        zOss_DeleteSemaphore(g_PauseSemp);
        zOss_DeleteSemaphore(g_StopSemp);
        zOss_DeleteSemaphore(g_StartSemp);
        zOss_DeleteSemaphore(g_OpenSemp);
        zOss_DeleteMutex(g_AudioDataListMutex);
        zOss_DeleteMutex(g_VideoDataListMutex);
        zOss_DeleteMutex(g_FileStopMutex);

        return DV_ERROR;
    }
    /* 2009-07-22  ޸ */

    g_CloseSemp      = zOss_CreateSemaphore(DV_CLOSE_SEMP, 0);
    /* 2009-07-22  ޸ */
    if(NULL == g_CloseSemp)
    {
        zOss_DeleteSemaphore(g_ResumeSemp);
        zOss_DeleteSemaphore(g_PauseSemp);
        zOss_DeleteSemaphore(g_StopSemp);
        zOss_DeleteSemaphore(g_StartSemp);
        zOss_DeleteSemaphore(g_OpenSemp);
        zOss_DeleteMutex(g_AudioDataListMutex);
        zOss_DeleteMutex(g_VideoDataListMutex);
        zOss_DeleteMutex(g_FileStopMutex);

        return DV_ERROR;
    }
    /* 2009-07-22  ޸ */

    g_pVideoDataList = zOss_Malloc(sizeof(T_ZOss_List));
    if(NULL == g_pVideoDataList)
    {
        zOss_DeleteSemaphore(g_ResumeSemp);
        zOss_DeleteSemaphore(g_PauseSemp);
        zOss_DeleteSemaphore(g_StopSemp);
        zOss_DeleteSemaphore(g_StartSemp);
        zOss_DeleteSemaphore(g_OpenSemp);
        zOss_DeleteMutex(g_AudioDataListMutex);
        zOss_DeleteMutex(g_VideoDataListMutex);
        zOss_DeleteMutex(g_FileStopMutex);

        return DV_ERROR;
    }
    zOss_Memset(g_pVideoDataList, 0, sizeof(T_ZOss_List));
    zOss_ListInit(g_pVideoDataList);

    g_pAudioDataList = zOss_Malloc(sizeof(T_ZOss_List));
    if(NULL == g_pAudioDataList)
    {
        zOss_Free(g_pVideoDataList);
        zOss_DeleteSemaphore(g_ResumeSemp);
        zOss_DeleteSemaphore(g_PauseSemp);
        zOss_DeleteSemaphore(g_StopSemp);
        zOss_DeleteSemaphore(g_StartSemp);
        zOss_DeleteSemaphore(g_OpenSemp);
        zOss_DeleteMutex(g_AudioDataListMutex);
        zOss_DeleteMutex(g_VideoDataListMutex);
        zOss_DeleteMutex(g_FileStopMutex);

        return DV_ERROR;
    }
    zOss_Memset(g_pAudioDataList, 0, sizeof(T_ZOss_List));
    zOss_ListInit(g_pAudioDataList);
     
    return DV_SUCCESS;
}

/**
 * ƣ dv_uninit
 *  ͷdvģԴ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ DV_SUCCESS: ɹ
 *            DV_ERROR  : ʧ
 * ˵ 
 **/ 
static T_DV_RETURN_VALUE dv_uninit(VOID)
{
    /*  2009-07-30 OSD豸Ѿֹͣ¼йر */
    //Zte_OsdUnInit();

    /* -07-23 ޸ */
    if(g_FileStopMutex != NULL)
    {
        zOss_DeleteMutex(g_FileStopMutex);
        g_FileStopMutex = NULL;
    }


    if(g_VideoDataListMutex != NULL)
    {
        zOss_DeleteMutex(g_VideoDataListMutex);
        g_VideoDataListMutex = NULL;
    }

    if(g_AudioDataListMutex != NULL)
    {
        zOss_DeleteMutex(g_AudioDataListMutex);
        g_AudioDataListMutex = NULL;
    }

    if(g_OpenSemp != NULL)
    {
        zOss_DeleteSemaphore(g_OpenSemp);
        g_OpenSemp = NULL;
    }

    if(g_StartSemp != NULL)
    {
        zOss_DeleteSemaphore(g_StartSemp);
        g_StartSemp = NULL;
    }

    if(g_StopSemp != NULL)
    {
        zOss_DeleteSemaphore(g_StopSemp);
        g_StopSemp = NULL;
    }
    
    if(g_PauseSemp != NULL)
    {
        zOss_DeleteSemaphore(g_PauseSemp);
        g_PauseSemp = NULL;
    }
    
    if(g_ResumeSemp != NULL)
    {
        zOss_DeleteSemaphore(g_ResumeSemp);
        g_ResumeSemp = NULL;
    }
    
    if(g_CloseSemp != NULL)
    {
        zOss_DeleteSemaphore(g_CloseSemp);
        g_CloseSemp = NULL;
    }
    /* -07-23 ޸ */
    
    if (NULL != g_pVideoDataList)
    {
        zOss_Free(g_pVideoDataList);
        g_pVideoDataList = NULL;
    }

    if (NULL != g_pAudioDataList)
    {
        zOss_Free(g_pAudioDataList);
        g_pAudioDataList = NULL;
    }
    
    return DV_SUCCESS;
}

/**
 * ƣ dv_encode_one_frame_audio_data
 *  һ֡Ƶ
 * ˵ (IN)  tAudioBuf: Ƶԭʼݻ
 *            (OUT) 
 *   ֵ DV_SUCCESS: ɹ
 *            DV_ERROR  : ʧ
 * ˵ 
 **/ 
static T_DV_RETURN_VALUE dv_encode_one_frame_audio_data(T_ZDrvAudio_BufInfo *pAudioBuf)
{
    SINT32 iRet              = -1;
    UINT32 uTime             = 0;
    UINT8  *pOutAudData      = NULL;
    UINT32  uOutAudDataLen    = 31;
    T_DV_RETURN_VALUE tDVRet = DV_ERROR;

    pOutAudData = zMspCom_AudioEncode(g_Dv_Contrl_Para.pAudioEncHandle, 
                                       pAudioBuf->buf, 
                                       pAudioBuf->buffersize, 
                                       &uOutAudDataLen);
    
 
    if (pOutAudData == NULL)
    {
        return DV_ERROR;
    }

    /* ￼Ǳ벻ɹɹʱǷҲҪдļ    */
    /* ɹʱ,Ϊ˱֤ʱһ,Ҳдļ  */
    /* 벻ɹ,ԿǽpOutAudData0дļ */
    
    //uTime = zOss_GetTickCount() - g_uiRecStartTime - g_uiPauseLastTime;
    uTime = g_uAudioFrameNum * DV_AUDIO_DECODE_TIME;
    tDVRet = dv_write_to_audio_datalist(pOutAudData, uOutAudDataLen, uTime);
    if (DV_BUFFER_FULL == tDVRet)
    {
        /* bufferݶ */
        //zOss_Free(pOutAudData);
        return DV_BUFFER_FULL;
    }

    g_uiCurListDataLen += uOutAudDataLen;
    return DV_SUCCESS;
}


/**
 * ƣ dv_is_send_save_audio_msg
 *  ǷͱƵϢ,ÿ3֡һ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ TRUE : 
 *            FALSE: 
 * ˵ 
 **/ 
static BOOL dv_is_send_save_audio_msg(VOID)
{
    if (0 == (g_uAudioFrameNum % 3))
    {
        return TRUE;
    }

    return FALSE;
}

/**
 * ƣ dv_proc_save_file_msg
 *  ļϢ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ DV_SUCCESS: ɹ
 *            DV_ERROR  : ʧ
 * ˵ 
 **/ 

static T_DV_RETURN_VALUE dv_proc_save_file_msg_from_datalist(VOID)
{
    SINT32            iVideoTime = 0;
    SINT32            iAudioTime = 0;


    /* ֻ¼¼ */
    if (!g_Start_Para.audioenable)
    {
        /* ֻ¼ʱ¼Ϣһ֡һ֡ģ */
        /* Դ˴ÿֻһ֡ƵͿ         */
        dv_read_one_frame_from_video_datalist();              
    }
    else    /* ¼¼ */
    {   
        iVideoTime = dv_get_video_frame_time_from_datalist();
        iAudioTime = dv_get_audio_frame_time_from_datalist();
        
        /* ûƵƵݣ˳ */
        if ((iVideoTime < 0) || (iAudioTime < 0))
        {
            return DV_ERROR;
        }

        /* ʱȺ󱣴Ƶ */
        if (iVideoTime <= iAudioTime)
        {
            //dv_read_one_frame_from_video_datalist();
            dv_save_video_data_from_datalist(iVideoTime, iAudioTime);    
        }
        else
        {
            dv_save_audio_data_from_datalist(iAudioTime, iVideoTime);
        }
    }
 
    return DV_SUCCESS;

}


/**
 * ƣ dv_get_video_frame_time
 *  õһ֡Ƶݵʱ,жǷƵ
 * ˵ (IN)  
 *            (OUT) 
 *   ֵ 0ʾһ֡Ƶʱ,-1ʾûƵ
 * ˵ 
 **/

static SINT32 dv_get_video_frame_time_from_datalist(VOID)
{
    UINT32           uTime           = 0;
    SINT32           iNodeCount      = 0;
    T_VIDEODATA_NODE *pVideoDataNode = NULL;

    zOss_GetMutex(g_VideoDataListMutex, ZOSS_WAIT_FOREVER);
    if (NULL == g_pVideoDataList)
    {
        zOss_PutMutex(g_VideoDataListMutex);
        return -1;
    }

    iNodeCount = zOss_ListCount(g_pVideoDataList);
    if (iNodeCount < 1)
    {
        zOss_PutMutex(g_VideoDataListMutex);
        return -1;
    }

    pVideoDataNode = (T_VIDEODATA_NODE *)zOss_ListFirst(g_pVideoDataList);

    if ((NULL == pVideoDataNode) || (NULL == pVideoDataNode->data))
    {
        zOss_PutMutex(g_VideoDataListMutex);
        return -1;
    }

    uTime = pVideoDataNode->uTime;

    zOss_PutMutex(g_VideoDataListMutex);

    return uTime;
}

static SINT32 dv_get_audio_frame_time_from_datalist(VOID)
{
    UINT32           uTime           = 0;
    SINT32           iNodeCount      = 0;
    T_AUDIODATA_NODE *pAudioDataNode = NULL;

    zOss_GetMutex(g_AudioDataListMutex, ZOSS_WAIT_FOREVER);
    if (NULL == g_pAudioDataList)
    {
        zOss_PutMutex(g_AudioDataListMutex);
        return -1;
    }

    iNodeCount = zOss_ListCount(g_pAudioDataList);
    if (iNodeCount < 1)
    {
        zOss_PutMutex(g_AudioDataListMutex);
        return -1;
    }

    pAudioDataNode = (T_AUDIODATA_NODE *)zOss_ListFirst(g_pAudioDataList);

    if ((NULL == pAudioDataNode) || (NULL == pAudioDataNode->data))
    {
        zOss_PutMutex(g_AudioDataListMutex);
        return -1;
    }

    uTime = pAudioDataNode->uTime;

    zOss_PutMutex(g_AudioDataListMutex);

    return uTime;

}



/**
 * ƣ dv_save_one_frame_video_datalist
 *  ļдһ֡Ƶ
 * ˵ (IN)  pDVBufData: Ƶbufferָ
 *            (OUT) 
 *   ֵ DV_SUCCESS: ɹ
 *            DV_ERROR  : ʧ
 * ˵ 
 **/
static T_DV_RETURN_VALUE dv_save_video_data_from_datalist(UINT32 uVideoTime, UINT32 uBoundTime)
{
    SINT32 iTime = -1;
    T_DV_RETURN_VALUE tDVRet = DV_ERROR;

    iTime = uVideoTime;

    while ((iTime <= uBoundTime) && (iTime >= 0))
    {
        tDVRet = dv_read_one_frame_from_video_datalist();
        if (DV_ERROR == tDVRet)
        {
            return DV_ERROR;
        }
        
        iTime = dv_get_video_frame_time_from_datalist();
    }

    return DV_SUCCESS;
}


static VOID dv_save_left_audio_and_video_datalist(VOID)
{
    SINT32 iVideoTime = -1;
    SINT32 iAudioTime = -1;
    T_DV_RETURN_VALUE tDVRet = DV_ERROR;
    
    iVideoTime = dv_get_video_frame_time_from_datalist();
    iAudioTime = dv_get_audio_frame_time_from_datalist();

    while ((iVideoTime >= 0) && (iAudioTime >= 0))
    {
        if (iVideoTime <= iAudioTime)
        {
            tDVRet = dv_read_one_frame_from_video_datalist();
            if (DV_ERROR == tDVRet)
            {
                break;
            }
        
            iVideoTime = dv_get_video_frame_time_from_datalist();           
        }
        else
        {
            tDVRet = dv_read_one_frame_from_audio_datalist();
            if (DV_ERROR == tDVRet)
            {
                break;
            }

            iAudioTime = dv_get_audio_frame_time_from_datalist();
        }
    }

    /* ʣµһ·ݱ */
    if (iVideoTime >= 0)
    {
        while (iVideoTime >= 0)
        {
            tDVRet = dv_read_one_frame_from_video_datalist();
            if (DV_ERROR == tDVRet)
            {
                break;
            }
        
            iVideoTime = dv_get_video_frame_time_from_datalist();           
        
        }
    }

    if (iAudioTime >= 0)
    {
        while (iAudioTime >= 0)
        {
            tDVRet = dv_read_one_frame_from_audio_datalist();
            if (DV_ERROR == tDVRet)
            {
                break;
            }

            iAudioTime = dv_get_audio_frame_time_from_datalist();       
        }
    }
}


/**
 * ƣ dv_save_audio_data
 *  ļƵ
 * ˵ (IN)  uAudioTime: Ƶʱ
 *                  uBoundTime: Ƶݵʱ
 *            (OUT) 
 *   ֵ DV_SUCCESS: ɹ
 *            DV_ERROR  : ʧ
 * ˵ 
 **/ 

static T_DV_RETURN_VALUE dv_save_audio_data_from_datalist(UINT32 uAudioTime, UINT32 uBoundTime)
{
    SINT32 iTime = -1;
    T_DV_RETURN_VALUE tDVRet = DV_ERROR;

    iTime = uAudioTime;

    while ((iTime < uBoundTime) && (iTime >= 0))
    {
        tDVRet = dv_read_one_frame_from_audio_datalist();
        if (DV_ERROR == tDVRet)
        {
            return DV_ERROR;
        }
        
        iTime = dv_get_audio_frame_time_from_datalist();
    }

    return DV_SUCCESS;
}


/**
 * ƣ dv_set_camera_para
 *  ļƵ
 * ˵ (IN)  param: ¼
 *            (OUT) 
 *   ֵ DV_SUCCESS: ɹ
 *            DV_ERROR  : ʧ
 * ˵ 
 **/ 
static T_DV_RETURN_VALUE dv_set_camera_para(T_DV_CAM_PARAM *param)
{
    SINT32            iRet     = -1;
    EFFECT_TYPE_E     eEffect  = param->effect;

    /* Ŀǰֻ֧Ч */
    /* Ч */
    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Camra_Dev_Fd, IOCTL_CAM_SENSOR_EFFECT, &eEffect);
    if (DRV_SUCCESS != iRet)
    {
        return DV_ERROR;
    }

    return DV_SUCCESS;
}

/**
 * ƣ dv_set_audio_para
 *  ļƵ
 * ˵ (IN)  param: ¼
 *            (OUT) 
 *   ֵ DV_SUCCESS: ɹ
 *            DV_ERROR  : ʧ
 * ˵ 
 **/ 
static T_DV_RETURN_VALUE dv_set_audio_record_para(VOID)
{
    SINT32                    iRet        = -1;
    T_MSP_CHANNEL_INPUT       tInputChannel = MSP_CHANNEL_INPUT_MICPHONE;
    T_MSP_INPUT_VOLUME_LEVEL  tInputVol     = MSP_INPUT_VOLUME_LEVEL_3;
    T_ZDrvAudio_SampleRate    tSampleRate = AUDIO_RATE_8_KHZ;

    /* Ĳõ˳йأ· */
    /* Ҫϲת */
    iRet = zMspCom_SetInputChannel(tInputChannel);
    if (0 != iRet)
    {
        return DV_ERROR;
    }

    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Audio_Dev_Fd, IOCTL_AUDIO_SET_RECORD_SAMPLE, &tSampleRate);
    if (0 != iRet)
    {
        return DV_ERROR;
    }

    iRet = zMspCom_SetInputVol(tInputVol);
    if (0 != iRet)
    {
        return DV_ERROR;
    }
 
    return DV_SUCCESS;

}


/**
 * ƣ dv_close_file 
 *  رļ,ͷԴ
 * ˵ IN : 
 *            OUT: 
 *   ֵ ɹDV_SUCCESS;ʧܷDV_ERROR
 * ˵ 
 */
static T_DV_RETURN_VALUE dv_close_file(VOID)
{
    EZMFResultCode rtCode = ZMF_RS_ERROR;

    rtCode         = WriteOver(g_uFileSavedId);
    rtCode         = CloseMediaFileHandler(g_uFileSavedId);
    g_uFileSavedId = 0;

    /* g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivateParaɵڴռ */
    /* g_tFileInfo.tFileInfo.t_isoInfo.pTrackArrayɵڴռ*/
    
    if (NULL != g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara)
    {
        zOss_Free(g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara);
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray[0].tTrackInfo.tVideoParam.pPrivatePara = NULL;
    }
    
    if(NULL != g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray)
    {
        zOss_Free(g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray);
        g_tFileInfo.tFileInfo.t_isoInfo.pTrackArray = NULL;
    }

    if(rtCode != ZMF_RS_OK)
    {
        return DV_ERROR;
    }

    return DV_SUCCESS;
}

/**
 * ƣ dv_uninit_audio_encoder 
 *  жر,ͷԴ
 * ˵ IN : t_pEncPara:
 *   ֵ 
 * ˵ 
 */
static VOID dv_uninit_audio_encoder(T_MediaAudioEncHandle *pEncHandle)
{
    if(NULL == pEncHandle)
    {
        zMspCom_Print();

        return;
    }
    
    zMspCom_CloseAudioEncoder(pEncHandle);
    zMspCom_UnLoadAudioEnCodeLib(g_Dv_Contrl_Para.eMediaAType);

    return;
}

/**
 * ƣ dv_write_to_video_datalist 
 *  ƵݷУڱļ
 * ˵ IN : pData    : 
 *                 uDataLen : ݳ
 *                 uTime    : Ƶʱ  
 *   ֵ DV_SUCCESS: ɹ  DV_ERROR: ʧ
 * ˵ 
 */
static T_DV_RETURN_VALUE dv_write_to_video_datalist(VOID *pData, UINT32 uDataLen, UINT32 uTime,Bool8 IsKeyFrame)
{
    T_VIDEODATA_NODE *pVideoDataNode = NULL;

    if (NULL == pData)
    {
        return DV_ERROR;
    }
    pVideoDataNode = zOss_Malloc(sizeof(T_VIDEODATA_NODE));
    if (NULL == pVideoDataNode)
    {
        return DV_ERROR;
    }
    zOss_Memset(pVideoDataNode, 0, sizeof(T_VIDEODATA_NODE));
    pVideoDataNode->data = pData;
    pVideoDataNode->uLen = uDataLen;
    pVideoDataNode->uTime = uTime;
    pVideoDataNode->bIsKeyFrame = IsKeyFrame;

    zOss_GetMutex(g_VideoDataListMutex, ZOSS_WAIT_FOREVER);
    zOss_ListAdd(g_pVideoDataList, (T_ZOss_Node *)pVideoDataNode);
    zOss_PutMutex(g_VideoDataListMutex);
    
    return DV_SUCCESS;
}

/**
 * ƣ dv_write_to_audio_datalist 
 *  ƵݷУڱļ
 * ˵ IN : pData    : 
 *                 uDataLen : ݳ
 *                 uTime    : Ƶʱ  
 *   ֵ DV_SUCCESS: ɹ  DV_ERROR: ʧ
 * ˵ 
 */
static T_DV_RETURN_VALUE dv_write_to_audio_datalist(VOID *pData, UINT32 uDataLen, UINT32 uTime)
{
    T_AUDIODATA_NODE *pAudioDataNode   = NULL;

    if (NULL == pData)
    {
        //zOss_PutMutex(g_AudioDataListMutex);
        return DV_ERROR;
    }
       
    pAudioDataNode = zOss_Malloc(sizeof(T_AUDIODATA_NODE));
    if (NULL == pAudioDataNode)
    {
        //zOss_PutMutex(g_AudioDataListMutex);
        return DV_ERROR;
    }
    zOss_Memset(pAudioDataNode, 0, sizeof(T_AUDIODATA_NODE));
    
    pAudioDataNode->data = pData;
    pAudioDataNode->uLen = uDataLen;
    pAudioDataNode->uTime = uTime;

    zOss_GetMutex(g_AudioDataListMutex, ZOSS_WAIT_FOREVER);
    zOss_ListAdd(g_pAudioDataList, (T_ZOss_Node *)pAudioDataNode);
    zOss_PutMutex(g_AudioDataListMutex);

    return DV_SUCCESS;
}


/**
 * ƣ dv_read_one_frame_from_video_datalist 
 *  жһ֡Ƶ
 * ˵ IN : 
 *   ֵ DV_SUCCESS: ɹ  DV_ERROR: ʧ
 * ˵ 
 */
static T_DV_RETURN_VALUE dv_read_one_frame_from_video_datalist(VOID)
{
    EZMFResultCode        rtCode     = ZMF_RS_ERROR;
    T_ZMFOutPutUnit       tVideoUnit = {0};
    T_VIDEODATA_NODE *pVideoDataNode = NULL;
    SINT32 iNodeCount = 0;

    zOss_GetMutex(g_VideoDataListMutex, ZOSS_WAIT_FOREVER);
    /* begin ˴ʽ */
    iNodeCount = zOss_ListCount(g_pVideoDataList);
    if (iNodeCount < 1)
    {
        zOss_PutMutex(g_VideoDataListMutex);
        return DV_ERROR;
    }
    pVideoDataNode = (T_VIDEODATA_NODE *)zOss_ListFirst(g_pVideoDataList);

    if ((NULL == pVideoDataNode) || (NULL == pVideoDataNode->data))
    {
        zOss_PutMutex(g_VideoDataListMutex);
        return DV_ERROR;
    }
    
    zOss_Memset(&tVideoUnit, 0, sizeof(T_ZMFOutPutUnit));
    tVideoUnit.u32TrackID              = DV_VIDEO_TRACK_ID;
    tVideoUnit.eCodeID                 = ZM_CODEC_ID_H263;
    tVideoUnit.u32Len = pVideoDataNode->uLen;
    tVideoUnit.pPacket = pVideoDataNode->data;
    tVideoUnit.u32DecodeTime = pVideoDataNode->uTime;               
    tVideoUnit.t_FrameInfo.bIsKeyFrame = pVideoDataNode->bIsKeyFrame;

    zOss_ListDelete(g_pVideoDataList, (T_ZOss_Node *)pVideoDataNode);
    zOss_PutMutex(g_VideoDataListMutex);

#if 1
    if(g_uiTotalTime <= 1800000)
    {
        if (g_uFileSavedId > 0)
        {
        rtCode = WriteNextFrame(g_uFileSavedId, /*DV_VIDEO_TRACK_ID,*/ &tVideoUnit);
            if (ZMF_RS_OK != rtCode)
            {
                //return DV_ERROR;
            }
        }
    }
#endif

    g_uiCurListDataLen -= pVideoDataNode->uLen;
    if (NULL != pVideoDataNode->data)
    {
        zOss_Free(pVideoDataNode->data);
        pVideoDataNode->data = NULL;
    }

    if (NULL != pVideoDataNode)
    {
        zOss_Free(pVideoDataNode);
        pVideoDataNode = NULL;
    }

    return DV_SUCCESS;
}

/**
 * ƣdv_AmrIF1GetFrameType
 * AMR֡ȡAMR IF1ʽ֡
 * ˵(IN)uiDataLen: AMR IF1ʽ֡
 *   ֵ AMR IF1ʽ֡͡
 * ˵ 
 */
static UINT8 dv_AmrIF1GetFrameType(UINT32 uiDataLen)
{
    UINT8  uiFrameType = 8;

    switch(uiDataLen)
    {
        case 12:
        {
            uiFrameType = 0;  /* 4.75k */
            break;
        }
        case 13:
        {
            uiFrameType = 1;  /* 5.15k */
            break;
        }
        case 15:
        {
            uiFrameType = 2;  /* 5.9k */
            break;
        }
        case 17:
        {
            uiFrameType = 3;  /* 6.7k */
            break;
        }
        case 19:
        {
            uiFrameType = 4;  /* 7.4k */
            break;
        }
        case 20:
        {
            uiFrameType = 5;  /* 7.95k */
            break;
        }
        case 26:
        {
            uiFrameType = 6;  /* 10.2k */
            break;
        }
        case 31:
        {
            uiFrameType = 7;  /* 12.2k */
            break;
        }
        case 5:
        {
            uiFrameType = 8;  /* SID */
            break;
        }
        case 0:
        {
            uiFrameType = 15; /* no transmission */
            break;
        }
        default:
        {
            uiFrameType = 8;  /* SID */
            break;
        }
    }
    
    return uiFrameType;
}

static T_DV_RETURN_VALUE dv_read_one_frame_from_audio_datalist(VOID)
{
    SINT32                iNodeCount      = 0;
    EZMFResultCode        rtCode          = ZMF_RS_ERROR;
    T_ZMFOutPutUnit       tAudioUnit      = {0};
    T_AUDIODATA_NODE      *pAudioDataNode = NULL;
    UInt8                 uFrameType      = 0; //֡ͣAMR볤Ȼ

    zOss_GetMutex(g_AudioDataListMutex, ZOSS_WAIT_FOREVER);
    /* begin ˴ʽ */
    iNodeCount = zOss_ListCount(g_pAudioDataList);
    if (iNodeCount < 1)
    {
        zOss_PutMutex(g_AudioDataListMutex);
        return DV_ERROR;
    }
    pAudioDataNode = (T_AUDIODATA_NODE *)zOss_ListFirst(g_pAudioDataList);

    if ((NULL == pAudioDataNode) || (NULL == pAudioDataNode->data))
    {
        zOss_PutMutex(g_AudioDataListMutex);
        return DV_ERROR;
    }
    
    zOss_Memset(&tAudioUnit, 0, sizeof(T_ZMFOutPutUnit));

    tAudioUnit.u32TrackID    = DV_AUDIO_TRACK_ID;
    tAudioUnit.eCodeID       = ZM_CODEC_ID_AMR_NB;
    tAudioUnit.u32Len        = pAudioDataNode->uLen;
    tAudioUnit.pPacket       = pAudioDataNode->data;
    tAudioUnit.u32DecodeTime = pAudioDataNode->uTime;
    uFrameType               = dv_AmrIF1GetFrameType(tAudioUnit.u32Len);
    
    tAudioUnit.uFrameUnit.t_AMRFrameUnit.u8FrameType   = uFrameType; 
    //tAudioUnit.uFrameUnit.t_AMRFrameUnit.u16PacketMode = uFrameType;/* ȥ˴ */ 
    tAudioUnit.uFrameUnit.t_AMRFrameUnit.cFrameQuality = 1; 
        
    zOss_ListDelete(g_pAudioDataList, (T_ZOss_Node *)pAudioDataNode);
    zOss_PutMutex(g_AudioDataListMutex);

#if 1   
    /* ļģڴ
       ļϵͳ֮ǰʱ¼ʱ3ӣ
       3ʱɼ룬ٱļ
    */
    if(g_uiTotalTime <= 1800000)
    {
        if (g_uFileSavedId > 0)
        {
        rtCode = WriteNextFrame(g_uFileSavedId, /*DV_AUDIO_TRACK_ID,*/ &tAudioUnit);
            if (ZMF_RS_OK != rtCode)
            {
                //return DV_ERROR;
            }
        }
    }
#endif

    g_uiCurListDataLen -= pAudioDataNode->uLen;
    if (NULL != pAudioDataNode->data)
    {
        zOss_Free(pAudioDataNode->data);
        pAudioDataNode->data = NULL;
    }

    if (NULL != pAudioDataNode)
    {
        zOss_Free(pAudioDataNode);
        pAudioDataNode = NULL;
    }

    return DV_SUCCESS;
}


static void dv_release_video_datalist(VOID)
{
    SINT32 iNodeCount = 0;
    T_VIDEODATA_NODE *pVideoDataNode = NULL;

    zOss_GetMutex(g_VideoDataListMutex, ZOSS_WAIT_FOREVER);
    if (NULL == g_pVideoDataList)
    {
        zOss_PutMutex(g_VideoDataListMutex);
        return;
    }
               
    iNodeCount = zOss_ListCount(g_pVideoDataList);
          
    while (iNodeCount >= 1)
    {
        pVideoDataNode = (T_VIDEODATA_NODE *)zOss_ListFirst(g_pVideoDataList);
        if ((NULL == pVideoDataNode) || (NULL == pVideoDataNode->data))
        {
            zOss_PutMutex(g_VideoDataListMutex);

            return;
        }

        zOss_ListDelete(g_pVideoDataList, (T_ZOss_Node *)pVideoDataNode);

        if (NULL != pVideoDataNode->data)
        {
            zOss_Free(pVideoDataNode->data);
            pVideoDataNode->data = NULL;
        }

        if (NULL != pVideoDataNode)
        {
            zOss_Free(pVideoDataNode);
            pVideoDataNode = NULL;
        }
        
        iNodeCount = zOss_ListCount(g_pVideoDataList);
    
    }

    zOss_PutMutex(g_VideoDataListMutex);

}


static T_DV_RETURN_VALUE dv_ppu_for_refresh_screen(T_ZDrv_CamDataInfo *pCamData)
{
    SINT32                  iRet = -1;
    T_ZDrvVideo_PpuInfo     t_AllDataInfo;    /* ҪĲ롢ԼOSD */
    T_ZDrvVideo_PpuInPut    t_InputInfo;
    T_ZDrvVideo_PpuOutPut   t_OutputInfo;
    T_ZDrvVideo_PpuOSDInfo  t_OsdInfo;
    T_ZDrvVideo_BufInfo     t_PostBuf;         /* buffer     */


    /* ɼͼݽкˢ */
    t_InputInfo.uiStartX     = 0;//(pCamData->Width - DV_SCREEN_WIDTH)/2;//0;//cyx 2009-9-8 ȡͼмһ
    t_InputInfo.uiStartY     = 0;//(pCamData->Height - DV_SCREEN_HEIGHT)/2;//0;//cyx 2009-9-8 ȡͼмһ
    t_InputInfo.uiWidth      = pCamData->Width;
    t_InputInfo.uiHeight     = pCamData->Height;
    t_InputInfo.uiStride     = pCamData->Width; /* ˴Ϊ640 */ 
    t_InputInfo.tPixelFmt    = pCamData->pixeFmt;
    t_InputInfo.pInPutbuffer = pCamData->dataBuf;

    t_OutputInfo.uiWidth   = g_uiScreenHeight;
    t_OutputInfo.uiHeight  = g_uiScreenWidth;
    t_OutputInfo.uiStride  = g_uiScreenWidth;
    t_OutputInfo.tPixelFmt = PIXEL_YCbCr420;

    t_PostBuf.bufSize.YuvBufSize.ySize  = g_uiScreenWidth * g_uiScreenHeight;
    t_PostBuf.bufSize.YuvBufSize.uSize  = g_uiScreenWidth * g_uiScreenHeight / 4;
    t_PostBuf.bufSize.YuvBufSize.vSize  = g_uiScreenWidth * g_uiScreenHeight / 4;
    t_PostBuf.bufType = YUV_TYPE;
    
    /* buffer,ڱˢ */
    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Video_Dev_Fd, IOCTL_VIDEO_GET_BUFINFO, &t_PostBuf);
    if (DRV_SUCCESS != iRet)
    {
        return DV_ERROR;
    }
 
    t_OutputInfo.pOutPutbuffer = t_PostBuf.pDataBuf;  

    t_OsdInfo.bEnable = FALSE;

    t_AllDataInfo.inputInfo = t_InputInfo;
    t_AllDataInfo.outputInfo = t_OutputInfo;
    t_AllDataInfo.osdInfo = t_OsdInfo;
    t_AllDataInfo.tRotate = ROT_270;
    t_AllDataInfo.tMirror = MIR_NONE;
    
    /* Ƶ */
    iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Video_Dev_Fd, IOCTL_VIDEO_POSTPROCESS, &t_AllDataInfo);
    if (DRV_SUCCESS != iRet)
    {
        /* ͷĺbuffer */ 
        iRet = zDrv_Ioctl((UINT32)g_Dv_Contrl_Para.g_Video_Dev_Fd, IOCTL_VIDEO_FREE_BUFFER, &t_PostBuf);
                
        return DV_ERROR;
    }

    /* Ƶݱ棬ˢ */
    g_tPostBuf.bufSize = t_PostBuf.bufSize;
    g_tPostBuf.bufType = t_PostBuf.bufType;
    g_tPostBuf.pDataBuf = t_PostBuf.pDataBuf;

    return DV_SUCCESS;
}



