/*******************************************************************************
* Ȩ (C)2016, ͨѶɷ޹˾
* 
* ļ:     ramdump_collect_server.c
* ļʶ:     ramdump_collect_server.c
* ժҪ:     ramdump collectռʵ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2016/6/10      V1.0        Create           Ծ          
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "ramdump_pub.h"
#include "ramdump_oss.h"

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/

#ifdef _OS_TOS
extern VOID zOss_Ramdump_ProcessMsgFromZsp(const T_HalIcp_Msg *pMsg);
#endif

/*******************************************************************************
*                                                                      *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/

#define RAMDUMP_ARRAY_BEG(arr) &(arr[0])
#define RAMDUMP_ARRAY_END(arr) &(arr[RAMDUMP_ARRAY_NR(arr)])

#define RAMDUMP_WAIT_CLIENT_TIMELEN (200) /* like before,just a value roughly */
#define RAMDUMP_SLEEP_TIME (5) /* 5 ms */

#define RAMDUMP_CLIENT_INIT_RSP_DONE    (0x68797869) /* 68:D 79:O 78:N 69:E */
#define RAMDUMP_CALLBACK_INIT_DONE      1

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
typedef int (*ramdump_initcall_t)(void);
/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/

static int ramdump_cpu1_icp_init(void);
static int ramdump_cpu2_icp_init(void);

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/

/* store collect ram config */
static ramdump_ram_config_msg_t ramdump_collected_ram_conf_tables[RAMDUMP_CPU_MAX];

/* store client icp init fun, expandable */
static ramdump_initcall_t ramdump_client_icp_initcalls[RAMDUMP_CPU_MAX] = 
{NULL, ramdump_cpu1_icp_init,ramdump_cpu2_icp_init};

/* first except cpu id */
static unsigned long ramdump_except_cpu_id;

/* init rsp done flag for all clients */
static volatile unsigned long ramdump_client_init_rsp[RAMDUMP_CPU_MAX];

static volatile long ramdump_callback_init_rsp[RAMDUMP_CPU_MAX];

static volatile int ramdumpCfgFinished;

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ramdump_icp_to_collect_server_handle
* ˵:     
*   ()  buf: icp msg point
*               len: icp msg length
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump client icp msg handle, common entry
*******************************************************************************/
static void ramdump_icp_to_collect_server_handle(
                void *buf, 
                unsigned int len)
{
    ramdump_msg_t *icp_msg;

	icp_msg = buf;

    switch(icp_msg->msg_id)
    {
        case RAMDUMP_MSG_INIT_RSP:
        {
            ramdump_ram_config_msg_t *table_entry = &(ramdump_collected_ram_conf_tables[icp_msg->cpu_id]);

            /* invalid cpu id */
            if ((icp_msg->cpu_id < RAMDUMP_CPU_0) || 
                (icp_msg->cpu_id >= RAMDUMP_CPU_MAX))
                while (RAMDUMP_TRUE);

            /* client ram conf collect */
            table_entry->array     = icp_msg->msg_data_t.ram_config.array;
            table_entry->nr        = icp_msg->msg_data_t.ram_config.nr;
            table_entry->done_flag = icp_msg->msg_data_t.ram_config.done_flag;

            ramdump_client_init_rsp[icp_msg->cpu_id] = RAMDUMP_CLIENT_INIT_RSP_DONE;

            break;
        }

        case RAMDUMP_MSG_EXCEPT:
        {
#ifndef __USE_TRANS_WITH_COLLECT__

            if (ramdump_except_cpu_id == 0)
                ramdump_except_cpu_id = icp_msg->cpu_id;

#endif

            OSS_PANIC("collect server received forced dump request from client!\n");
            break;
        }

        default:
            break;
    }
}

/*******************************************************************************
* :     ramdump_cpu1_icp_init
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     SUCCESS or FAILED
* ˵:     This function is used for ramdump client1 icp init (now is cp)
*******************************************************************************/
static int ramdump_cpu1_icp_init(void)
{
    int ret = 0;

    ret = ramdump_oss_icp_create_channel(
            ramdump_cpu_id[RAMDUMP_CPU_1], 
            ramdump_cpu_ch[RAMDUMP_CPU_1], 
            RAMDUMP_CHANNEL_SIZE);
    if (ret != RAMDUMP_SUCCESS) 
        return ret;

    ret = ramdump_oss_icp_regcallback(
            ramdump_cpu_id[RAMDUMP_CPU_1], 
            ramdump_cpu_ch[RAMDUMP_CPU_1], 
            (ramdump_oss_icp_callback)ramdump_icp_to_collect_server_handle);
    if (ret != RAMDUMP_SUCCESS) 
        return ret;

    return RAMDUMP_SUCCESS;
}

/*******************************************************************************
* :     ramdump_cpu2_icp_init
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     SUCCESS or FAILED
* ˵:     This function is used for ramdump client2 icp init (now is zsp)
*******************************************************************************/
static int ramdump_cpu2_icp_init(void)
{
    int ret = 0;

    ret = ramdump_oss_icp_create_channel(
            ramdump_cpu_id[RAMDUMP_CPU_2], 
            ramdump_cpu_ch[RAMDUMP_CPU_2], 
            0x40);
    if (ret != RAMDUMP_SUCCESS) 
        return ret;

#ifdef _OS_TOS

    ret = ramdump_oss_icp_regcallback(
            ramdump_cpu_id[RAMDUMP_CPU_2],
            ramdump_cpu_ch[RAMDUMP_CPU_2], 
            (ramdump_oss_icp_callback)zOss_Ramdump_ProcessMsgFromZsp);

#else

    ret = ramdump_oss_icp_regcallback(
            ramdump_cpu_id[RAMDUMP_CPU_2], 
            ramdump_cpu_ch[RAMDUMP_CPU_2], 
            (ramdump_oss_icp_callback)ramdump_icp_to_collect_server_handle);

#endif

    if (ret != RAMDUMP_SUCCESS) 
        return ret;

    return RAMDUMP_SUCCESS;
}

/*******************************************************************************
* :     ramdump_cpu_id_init
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for collect server to init cpu_id
*******************************************************************************/
static void ramdump_cpu_id_init(void)
{
    /* init interactive cpu id */
#ifdef __USE_CLIENT_WITH_COLLECT__
    ramdump_cpu_id[RAMDUMP_CPU_1] = ICP_MSG_ACTOR_A9;
    ramdump_cpu_id[RAMDUMP_CPU_2] = ICP_MSG_ACTOR_ZSP;
	ramdump_cpu_ch[RAMDUMP_CPU_1] = RAMDUMP;
	ramdump_cpu_ch[RAMDUMP_CPU_2] = RP_MSG_PS_PHY_RAMDUMP;
#endif
}

/*******************************************************************************
* :     ramdump_icp_callback_init
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for collect server to init callback
*******************************************************************************/
static void ramdump_icp_callback_init(void)
{
    int index;
    for (index = 0; index < RAMDUMP_CPU_MAX; index++)
    {
        if (ramdump_client_icp_initcalls[index] != NULL)
        {
            if (ramdump_client_icp_initcalls[index]() == RAMDUMP_ICP_SUCCESS)
                ramdump_callback_init_rsp[index] = RAMDUMP_CALLBACK_INIT_DONE;        
        }
    }
}

/*******************************************************************************
* :     ramdump_collect_server_thread_entry
* ˵:     
*   ()  arg: thread entry arguments
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump collect server icp init entry
*******************************************************************************/
static void ramdump_collect_server_thread_entry(int arg)
{
    int index = 0;
    ramdump_msg_t icp_msg = {0};
    ramdump_msg_t icp_msg_sync = {0};

    for (index = 0; index < RAMDUMP_CPU_MAX; index++)
    {
        if (ramdump_callback_init_rsp[index] == RAMDUMP_CALLBACK_INIT_DONE)
        {
            /* init request */
            icp_msg.msg_id = RAMDUMP_MSG_INIT_REQ;
            icp_msg.cpu_id = ramdump_cpu_id[RAMDUMP_CPU_0]; /* collect server cpu_id */
            /* send init req until success */
            while (ramdump_oss_icp_send(&icp_msg, ramdump_cpu_id[index], ramdump_cpu_ch[index]) != RAMDUMP_ICP_SUCCESS)
                OSS_SLEEP(RAMDUMP_SLEEP_TIME);//sleep 1 ms
                /* wait init rsp until done */
            while (ramdump_client_init_rsp[index] != RAMDUMP_CLIENT_INIT_RSP_DONE) 
                OSS_SLEEP(RAMDUMP_SLEEP_TIME);//sleep 1 ms
        }
    }

#ifndef __USE_TRANS_WITH_COLLECT__

    /* sync with trans server */
    icp_msg_sync.msg_id = RAMDUMP_MSG_SYNC;
    icp_msg_sync.cpu_id = ramdump_cpu_id[RAMDUMP_CPU_0]; /* collect server cpu_id */

    icp_msg_sync.msg_data_t.ram_config_sync.array = ramdump_collected_ram_conf_tables;
    icp_msg_sync.msg_data_t.ram_config_sync.nr    = RAMDUMP_CPU_MAX;

    while (!ramdumpCfgFinished || ramdump_oss_icp_send(&icp_msg_sync, ramdump_cpu_id[RAMDUMP_CPU_1], ramdump_cpu_ch[RAMDUMP_CPU_1]) != RAMDUMP_ICP_SUCCESS)
        OSS_SLEEP(RAMDUMP_SLEEP_TIME);//sleep 1 ms

    /* resolve trans server modify will be covered by caches */
    ramdump_arch_clean_and_invalid_caches();
#endif
}

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ramdump_config_finished
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is called for ramdump config finished
*******************************************************************************/
void ramdump_config_finished(void)
{
    ramdumpCfgFinished = 1;
}

/*******************************************************************************
* :     ramdump_collect_server_icp_init
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     SUCCESS
* ˵:     This function is used for ramdump client icp init
*******************************************************************************/
int ramdump_collect_server_icp_init(void)
{
    ramdump_cpu_id_init();
    
    ramdump_icp_callback_init();

    /* create thread sync cpu init */
    OSS_CREATE_THREAD("collect_server_sync_thread",(ramdump_oss_thread_entry_t)ramdump_collect_server_thread_entry);
 
    return RAMDUMP_ICP_SUCCESS;
}

/*******************************************************************************
* :     ramdump_collect_server_notify_clients_dump
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump client icp init
*******************************************************************************/
void ramdump_collect_server_notify_clients_dump(void)
{
    int cpu_id = 1;
    ramdump_msg_t icp_msg = {0};
    
    while (cpu_id < RAMDUMP_CPU_MAX)
    {
        /* init request */
        icp_msg.msg_id = RAMDUMP_MSG_EXCEPT;
        icp_msg.cpu_id = ramdump_cpu_id[RAMDUMP_CPU_0]; /* collect server cpu_id */
        ramdump_oss_icp_send(&icp_msg, ramdump_cpu_id[cpu_id], ramdump_cpu_ch[cpu_id]);
        cpu_id++;
    }
}

/*******************************************************************************
* :     ramdump_get_collect_server_ram_conf
* ˵:     
*   ()  msg: ram_conf
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump client icp init
*******************************************************************************/
void ramdump_get_collect_server_ram_conf(ramdump_ram_config_sync_msg_t *msg)
{
    msg->array = ramdump_collected_ram_conf_tables;
    msg->nr = RAMDUMP_CPU_MAX;
}

/*******************************************************************************
* :     ramdump_get_first_dump_cpu_id
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long*: cpu id address
* ˵:     This function is used for ramdump client icp init
*******************************************************************************/
unsigned long * ramdump_get_first_dump_cpu_id(void)
{
    return &ramdump_except_cpu_id;
}

/*******************************************************************************
* :     ramdump_get_client_init_rsp
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long*: cpu id address
* ˵:     
*******************************************************************************/
volatile unsigned long * ramdump_get_client_init_rsp(void)
{
    return ramdump_client_init_rsp;
}

#ifdef __cplusplus
}
#endif

