/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:  		zx234500_charger.c
 * File Mark:
 * Description:
 * Others:
 * Version:       V1.0
 * Author:
 * Date:          2013-8-25
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "lcd.h"
#include "boot_mode.h"
#include "usb/dwc_otg_driver.h"

#include "charge.h"



#pragma GCC optimize("O0")
/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
//#define ZX234500_TEST


//оƬŵGPIO
#if 0
#define GPIO_CHARGER_EN     199    			//GPIO199
#define GPIO_CHARGER_INT     11     		//EXT_INIT1/GPIO11
#define GPIO_CHARGER_STA     189     	//GPIO189
#define GPIO_CHARGER_CHGIN     191     	//GPIO191
#define GPIO_CHARGER_CHGTYPE     210     //GPIO190
#define GPIO_CHARGER_BATTIN      0    	//no support on plat_zx7510
#define GPIO_CHARGER_M0     208     			//GPIO208
#define GPIO_CHARGER_M1      209    			//GPIO209
#define GPIO_CHARGER_INT_irq      49    //irq no
#endif
/*

	.EN =55,//GPIO55
	.INT =11 ,//EXT_INIT1/GPIO11
	.CHGIN =52 ,//GPIO52
	.CHGTYPE =53 ,//GPIO53
	.BATTIN = 0,//no support on plat_zx7510
	.M0 =49 ,//GPIO49
	.M1 = 48,//GPIO48
	.INT_irq = 49,//irq no

*/

/*ʼоƬGPIO*/
static void charger_gpio_init()
{
	gpio_set_reuse(GPIO_CHARGER_EN,0);
	gpio_direction_output(GPIO_CHARGER_EN,0);

	gpio_set_reuse(GPIO_CHARGER_INT, 1);
	gpio_direction_input(GPIO_CHARGER_INT);

	gpio_set_reuse(GPIO_CHARGER_CHGIN, 0);
	gpio_direction_input(GPIO_CHARGER_CHGIN);

	gpio_set_reuse(GPIO_CHARGER_CHGTYPE, 0);
	gpio_direction_input(GPIO_CHARGER_CHGTYPE);

	//gpio_set_reuse(GPIO_CHARGER_BATTIN, 0);
	//gpio_direction_input(GPIO_CHARGER_BATTIN);

	gpio_set_reuse(GPIO_CHARGER_STA, 0);
	gpio_direction_input(GPIO_CHARGER_STA);

	gpio_set_reuse(GPIO_CHARGER_M0, 0);
	gpio_direction_output(GPIO_CHARGER_M0,1);

	gpio_set_reuse(GPIO_CHARGER_M1, 0);
	gpio_direction_output(GPIO_CHARGER_M1,1);

	return;
}


//óģʽ
int32_t	set_charger_mod(enum charger_mode mode)
{
    return 0;
}


//óС
int32_t	charger_set_usb_current(enum charger_current cur)
{
	uint8_t tmp = 0;

	switch(cur)
	{

		case 	CHG_CURRENT_500 ://	= 1, 	 //normal
		{
			gpio_set_value(GPIO_CHARGER_M0,1);
			gpio_set_value(GPIO_CHARGER_M1,1);
			break;
		}

		case 	CHG_CURRENT_1500://,		     // zx234500_2000ma
		{
			gpio_set_value(GPIO_CHARGER_M0,0);
			gpio_set_value(GPIO_CHARGER_M1,1);
			break;
		}

		case 	CHG_CURRENT_900://,		     // 101
		{
			gpio_set_value(GPIO_CHARGER_M0,0);
			gpio_set_value(GPIO_CHARGER_M1,0);
			break;
		}


		case 	CHG_CURRENT_800://,		     // 110
		case 	CHG_CURRENT_USB_SUSPEND://,     // 011
		case 	CHG_CURRENT_100 ://	= 0,	 // 000  IUSB3 IUSB2 IUSB1
		case 	CHG_CURRENT_150://,		     // 100
		case 	CHG_CURRENT_HIGH_IMPEDANCE://,  // 111
		case 	MAX_CURRENT_SET://              /* 12 */
		default:
			return -1;
	}
    return 0;
}



//жϵǰǷPC USB   Ƿ
int detect_usb_online(void)
{
    uint8_t status;

	status = gpio_get_value(GPIO_CHARGER_CHGIN);
	return ((status)? 0 : 1);  // statusͣڣ򷵻1
}



//жϵǰǷڳ
int charger_is_sustained(void)
{
    uint8_t status;

	status = gpio_get_value(GPIO_CHARGER_STA);
	return ((status)? 0 : 1);  // statusͣУ򷵻1
}



//ݵǰUSBͣ趨С
void init_charger_current(void)
{
    enum plug_in value = DEFAULT;

	//value = tsp_usb_usb_charger();

	if(CHARGER == value){
		charger_set_usb_current(CHG_CURRENT_1500);
	}
	else{
		charger_set_usb_current(CHG_CURRENT_500);
	}
}



//ʼоƬ趨С
void usb_charger_init(void)
{
    //оƬGPIOʼ
	charger_gpio_init();

	//ΪģʽΪģʽ
	set_charger_mod(CHG_MODE_NORMAL);

    //ó
	init_charger_current();
#ifdef ZX234500_TEST


	{
		int i=0;
		i=detect_usb_online();
		i=charger_is_sustained();

	}
#endif
    return;
}


//ͣ
void usb_charger_suspend(void)
{
	//ΪģʽΪģʽ
	set_charger_mod(CHG_MODE_SUSPENDED);
}

