#!/bin/bash

echo "fix_rootfs_dts"
if [ x"$LINUX_DTS_NAME" = x"" ] ; then
  LINUX_DTS_NAME=zx297520v3
fi

LINUX_DTS_NAME=$1

# some projects do not need fix initrd. we will only quit. 
if [ $LINUX_DTS_NAME = "zx279132s-evb" ] ; then
  exit 0
fi

echo "try to fix $LINUX_DTS_DIR/$LINUX_DTS_NAME"
LINUX_DTS_DIR=$2/arch/arm64/boot/dts/zte/zx297520v3
echo "try to fix $LINUX_DTS_DIR/$LINUX_DTS_NAME.dtc"
INITRD_START_ADDR=$(cat $LINUX_DTS_DIR/$LINUX_DTS_NAME.dts  | grep  "linux,initrd-start" | grep -Eo '0x[0-9a-fA-F]+')
INITRD_START_ADDR_DEC=$(awk "BEGIN { print $INITRD_START_ADDR }")
echo "initrd start addr $INITRD_START_ADDR -> $INITRD_START_ADDR_DEC"
IMAGE_DIR=$3

INITRD_OLD_STR=$(cat $LINUX_DTS_DIR/$LINUX_DTS_NAME.dts | grep initrd-end)
ROOTFS_IMG_SIZE=$(ls -l $IMAGE_DIR/ap_caprootfs.img | awk '{ print $5 }')
ROOTFS_IMG_SIZE_HEX=$(printf %X $ROOTFS_IMG_SIZE)
let INITRD_END_ADDR=INITRD_START_ADDR_DEC+ROOTFS_IMG_SIZE
INITRD_END_ADDR_HEX=$(printf %X $INITRD_END_ADDR)
INITRD_NEW_STR="\	\	linux,initrd-end = <0x"${INITRD_END_ADDR_HEX}">;"

echo $INITRD_OLD_STR $INITRD_NEW_STR $ROOTFS_IMG_SIZE_HEX $INITRD_END_ADDR_HEX

sed -i "s/$INITRD_OLD_STR/$INITRD_NEW_STR/"  $LINUX_DTS_DIR/$LINUX_DTS_NAME.dts
