/*******************************************************
* 
* @brief:
* @details:  add fota A/B backup service 
* @author:   l.yang
* @date:     2023.8.29
* @version:  V1.0
* @copyright：Copyright (c) MobileTek 
*
*********************************************/


#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <dlfcn.h>
#include <string.h>
#include <pthread.h>
#include <stdint.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <liblog/lynq_deflog.h>


#ifdef __cplusplus
extern "C" {
#endif

#define FOTA_FLAG_FILE "/mnt/userdata/.back_up_flag"
#define FOTA_SYNC_FLAG    1

extern int lynq_sync_system();
extern int lynq_fota_get_addr_value(char *tmp_value);
extern int lynq_fota_set_addr_value(char        *value,int size);
extern int lynq_fota_nrestart(void);
int main()
{
    int ret = 0 ;
    int sync_flag = 0;
    char tmp_addr[128] = {0};
    FILE *fp = NULL;

    fp = fopen(FOTA_FLAG_FILE,"r");
    if(fp == NULL)
    {
        printf("No need fota sync\n");
        return -1;

    }
    
    fread(&sync_flag,sizeof(int),1,fp);
    
    if(sync_flag == FOTA_SYNC_FLAG)
    {
        ret = lynq_sync_system();
        if(ret != 0)
        {
            printf("sync faild\n");
            fclose(fp);
        }
       system("rm -rf /mnt/userdata/.back_up_flag");
        
    }
    else if(sync_flag != FOTA_SYNC_FLAG)
    {
        ret = lynq_fota_get_addr_value(tmp_addr);
        if(ret != 0)
        {
            printf("Get addr failed\n");
            return -1;
        }
        printf("tmp_addr is %s\n",tmp_addr);
        ret = lynq_fota_set_addr_value(tmp_addr,10);
        if(ret != 0)
        {
            printf("Set addr failed\n");
            return -1;

        }
        ret = lynq_fota_nrestart();
        if(ret != 0)
        {
            printf("Upgrade failed\n");
            return -1;
        }
        
    }
   
    return 0;

}

#ifdef __cplusplus
}
#endif

