require platform-libs.inc

inherit autotools systemd

DEPENDS +=  "openssl libnl platform-libs-header libuciwrapper platform-libs-common"

S = "${WORKDIR}/platform"

SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "netd.service"
FILES_${PN} += "${systemd_unitdir}/system/netd.service ${bindir}"

CPPFLAGS += "-I${STAGING_INCDIR}/libnl3"
LDFLAGS += "-lnl-3 -lcrypto -luciwrapper -luci -lpthread -llog -lbase"

FLAGS = "${@bb.utils.contains("KERNEL_ARCH","arm","-Wall -Wextra -Wunused -Werror=pointer-to-int-cast -Werror=int-to-pointer-cast -Werror=type-limits","-D__ARCH_WANT_SYSCALL_DEPRECATED -D__WORDSIZE='64' -Wall -Wextra -Wunused",d)}"
ARCH = "${@bb.utils.contains("KERNEL_ARCH","arm", "arch-arm","arch-arm64",d)}"

SRC_URI += " \
	file://networkfiles/netd.service \
	file://networkfiles/netd.rc \
	file://networkfiles/netd_setup.sh \
	file://networkfiles/dns.script \
	file://wordsize.h \
	file://disable-nat-chain.patch \
    "



EXTRA_OEMAKE = "\
			'ARCH=${ARCH}' \
			'DNS_FLAGS=${FLAGS}' \
			"
do_configure_prepend() {
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek-ivt/recipes-platform/platform-libs/files/makefiles/Makefile.am ${WORKDIR}/platform/
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek-ivt/recipes-platform/platform-libs/files/makefiles/configure.ac ${WORKDIR}/platform/
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek-ivt/recipes-platform/platform-libs/files/makefiles/libbase/Makefile.am ${WORKDIR}/platform/system/core/base/
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek-ivt/recipes-platform/platform-libs/files/makefiles/libsysutils/Makefile.am ${WORKDIR}/platform/system/core/libsysutils/
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek-ivt/recipes-platform/platform-libs/files/makefiles/logwrapper/Makefile.am ${WORKDIR}/platform/system/core/logwrapper/
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek-ivt/recipes-platform/platform-libs/files/makefiles/libhardware_legacy/Makefile.am ${WORKDIR}/platform/hardware/libhardware_legacy/
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek-ivt/recipes-platform/platform-libs/files/makefiles/netd_server/Makefile.am ${WORKDIR}/platform/system/netd/server/
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek-ivt/recipes-platform/platform-libs/files/makefiles/netd_client/Makefile.am ${WORKDIR}/platform/system/netd/client/
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek-ivt/recipes-platform/platform-libs/files/makefiles/libdns/Makefile.am ${WORKDIR}/platform/bionic/libc/
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek-ivt/recipes-platform/platform-libs/files/makefiles/libdl/Makefile.am ${WORKDIR}/platform/bionic/libdl/
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek-ivt/recipes-platform/platform-libs/files/makefiles/libcutils/Makefile.am ${WORKDIR}/platform/system/core/libcutils/
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek-ivt/recipes-platform/platform-libs/files/makefiles/libutils/Makefile.am ${WORKDIR}/platform/system/core/libutils/
	install -m 0755 ${TOPDIR}/../meta/meta-mediatek-ivt/recipes-platform/platform-libs/files/makefiles/libbinder/Makefile.am ${WORKDIR}/platform/frameworks/native/libs/binder/
}

do_install_append() {
	install -m 0644 ${WORKDIR}/networkfiles/netd.rc ${D}${bindir}
	install -m 0755 ${WORKDIR}/networkfiles/netd_setup.sh ${D}${bindir}
	install -m 0755 ${WORKDIR}/networkfiles/dns.script ${D}${bindir}

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system/
		install -m 0644 ${WORKDIR}/networkfiles/netd.service ${D}${systemd_unitdir}/system
	fi
}

do_configure_append() {
    if [ "${KERNEL_ARCH}" = "arm64" ]; then
		rm -rf ${WORKDIR}/platform/bionic/libc/include/gnu/stubs.h
		cp ${WORKDIR}/wordsize.h ${WORKDIR}/platform/bionic/libc/include/bits/wordsize.h
	fi
}
