DESCRIPTION = "Unified Configuration Interface (UCI)"
SECTION = "libs"
LICENSE = "LGPL-2.1"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/LGPL-2.1;md5=1a6d268fd218675ffea8be556788b780"

SRC_URI = " \
    git://git.openwrt.org/project/uci.git \
    file://uci.patch \
"

SRCREV = "415f9e48436d29f612348f58f546b3ad8d74ac38"
PV = "1.0.0+git${SRCPV}"

S = "${WORKDIR}/git"

#SRC_URI += "file://uci.sh"

DEPENDS += "libubox"

INSANE_SKIP_${PN} += "dev-deps"
FILES_SOLIBSDEV = ""

FILES_${PN}-dev = "${includedir}/*"
FILES_${PN} = "${bindir}/uci ${libdir}/libuci.so"

inherit cmake

EXTRA_OECMAKE = " -DBUILD_LUA=OFF -DCMAKE_SKIP_RPATH=TRUE"

do_install() {
    install -d ${D}${libdir}
    install -d ${D}${bindir}
    install -d ${D}${includedir}
    install -m 0755 ${B}/uci ${D}${bindir}
    install -m 0755 ${B}/libuci.so ${D}${libdir}/
    install -m 0644 ${S}/uci*.h ${D}${includedir}
}
