DESCRIPTION = "dhcp6"
#ccapp依赖库
DEPENDS     = "bison-native  libxcrypt"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
    file://dhcp6 \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://dhcp6s.init","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://dhcp6s.service","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://dhcp6c.init","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://dhcp6c.service","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://dhcp6s.sysvinit","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://dhcp6c.sysvinit","", d)} \
    "

LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

#引用公用头文件和编译选项
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
SECURITY_STRINGFORMAT_remove = " -Werror=format-security "
#编译
do_compile() {
	make -C dhcp6
}

#库文件的安装
do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/dhcp6/dhcp6s ${D}${bindir}/
	install -m 0755 ${S}/dhcp6/dhcp6c ${D}${bindir}/

	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/dhcp6s.init ${D}${sysconfdir}/init.d/dhcp6s
		install -Dm 0755 ${WORKDIR}/dhcp6c.init ${D}${sysconfdir}/init.d/dhcp6c
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/dhcp6s.service ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/dhcp6c.service ${D}${systemd_unitdir}/system
	fi
	
	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/dhcp6s.sysvinit ${D}${sysconfdir}/init.d/dhcp6s
		install -Dm 0755 ${WORKDIR}/dhcp6c.sysvinit ${D}${sysconfdir}/init.d/dhcp6c
		install -d ${D}${sysconfdir}/rcS.d
	fi

	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/dhcp6/dhcp6s ${ELFS-PATH}/
	install -m 0755 ${S}/dhcp6/dhcp6c ${ELFS-PATH}/
}
#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/dhcp6s
	rm -fr ${ELFS-PATH}/dhcp6c
}

addtask  cleanlibs after do_clean  before do_cleansstate

#rootfs包含的文件
FILES_${PN} = "\
    ${sysconfdir} \
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/dhcp6","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "dhcp6s.service dhcp6c.service"
SYSTEMD_AUTO_ENABLE_${PN} = "disable"