DESCRIPTION = "libtinyalsa"
SECTION     = "lib"
LICENSE     = "zte"
PV          = "1.0.0"
PR          = "r0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
          file://libtinyalsa \
          "

DEPENDS = ""
S = "${WORKDIR}"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#编译
do_compile () {
	make -C libtinyalsa
}

#库和头文件的安装
do_install () {
	install -d ${D}${libdir}/
	install -d ${D}/usr/include/tinyalsa
	install -m 0755 ${S}/libtinyalsa/libtinyalsa.so  ${D}${libdir}/
	install -m 0755 ${S}/libtinyalsa/libtinyalsa.a   ${D}${libdir}/
	
	install -m 0644 ${S}/libtinyalsa/include/tinyalsa/*.h ${D}/usr/include/tinyalsa
	
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/libtinyalsa/libtinyalsa.so ${ELFS-PATH}/
	
    install -d ${D}${bindir}/
	install -m 0755 ${S}/libtinyalsa/tinyplay ${D}${bindir}/
	install -m 0755 ${S}/libtinyalsa/tinycap ${D}${bindir}/
	install -m 0755 ${S}/libtinyalsa/tinymix ${D}${bindir}/
	install -m 0755 ${S}/libtinyalsa/tinyinfo ${D}${bindir}/
}
#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/libtinyalsa.so
}

#rootfs包含的文件
FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"
