#!/bin/bash


#UBI_ARGS="-m 0x1000 -p 0x40000 -s 0x1000 -Q 1024"
if [ $# -lt 4 ]; then
  echo "[error] $0 parameter to less"
  echo "$0 out_name dir_name vol_name ubi_args"
  exit -1
fi
OUT_NAME=$1
DIR_NAME=$2
VOL_NAME=$3
UBI_ARGS=$4
MKSQUASHFS_ARGS="-nopad -noappend -root-owned -comp xz -Xpreset 9 -Xe -Xlc 0 -Xlp 2 -Xpb 2  -b 256k -processors 1"

echo "out_name: $OUT_NAME"
echo "dir_name: $DIR_NAME"
echo "vol_name: $VOL_NAME"
echo "ubi_args: $UBI_ARGS"

mkdir -p $DIR_NAME
mksquashfs4 $DIR_NAME  ${VOL_NAME}.out ${MKSQUASHFS_ARGS} -p '/dev d 755 0 0' -p '/dev/console c 600 0 0 5 1'
if [ $? -ne 0 ]; then
    echo "mksquashfs error"
    exit -1
fi

./ubinize-static.sh  $VOL_NAME $OUT_NAME ${VOL_NAME}.out  "$UBI_ARGS"
