#inherit externalsrc package
#inherit externalsrc package systemd
DESCRIPTION = "lynq atcid"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=b1e07e8d88e26263e71d3a9e2aa9a2ff"
DEPENDS += "libxml2 libatreg libsoftap libatutils libnvram libsclog libsofttimer libbinder liblynq-log"
#inherit workonsrc
WORKONSRC = "${TOPDIR}/../src/lynq/framework/lynq-atcid"
FILESEXTRAPATHS_prepend :="${TOPDIR}/../src/lynq/framework/:"
SRC_URI = " \
          file://lynq-atcid \
          "

SRC-DIR = "${S}/../lynq-atcid"
TARGET_CC_ARCH += "${LDFLAGS}"
SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "lynq_atcid.service"
FILES_${PN} += "${systemd_unitdir}/system/lynq_atcid.service"
FILES_${PN} += "${bindir} /data/atsvc"
#Parameters passed to do_compile()

EXTRA_OEMAKE = "'TARGET_PLATFORM = ${TARGET_PLATFORM}'"

#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	if test "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" || test "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4"; then
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -mhard-float"
	else
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST}"
	fi
}

do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${SRC-DIR}/lynq-atcid ${D}${bindir}/
	if test "${LYNQ_ATSVC_SUPPORT}" = "yes"; then
		install -d ${D}/data/atsvc
		install -m 644 ${WORKONSRC}/lynq_atsvc_plugin.xml ${D}/data/atsvc
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system/
		install -m 0644 ${B}/lynq_atcid.service ${D}${systemd_unitdir}/system
	else
		install -d ${D}${sysconfdir}/init.d
		install -m 0755  ${SRC-DIR}/lynq-atcid.sh ${D}${sysconfdir}/init.d/lynq-atcid.sh
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/lynq-atcid.sh ${D}${sysconfdir}/rcS.d/S83lynq-atcid
	fi
}
