#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dlfcn.h>
#include <errno.h>
#include <fcntl.h>
#include <include/lynq-qser-autosuspend.h>

#define FILE_LOCK_TABLE "/tmp/.lock_table"

#define MAX_LOCK_NUM 128


int check_lock(void)
{
    int err;
    int file_fd;
    int i;
    int ret;
    LOCK_TABLE lock_status;
    file_fd = open(FILE_LOCK_TABLE,O_RDWR);
    if(file_fd < 0)
    {
        err = errno;
        printf("Error open lock_table file:%s\n", strerror(errno));
        return -2;
    }

    memset(&lock_status, 0, sizeof(lock_status));
    lseek(file_fd,0,SEEK_SET);
    ret = read(file_fd,(unsigned char *)&lock_status,sizeof(lock_status));
    if(ret <= 0)
    {
        close(file_fd);
        return -2;
    }
    for(i=0;i<MAX_LOCK_NUM;i++)
    {
        if(strlen(lock_status.lock_name[i]) != 0)
        {
            printf("fd: %d lock_name:%s strlen:%d\n", i, lock_status.lock_name[i], strlen(lock_status.lock_name[i]));
        }
    }

    close(file_fd);
    return 0;

}

int main(int argc,char** argv)
{

    int num;
    int ret;
    int len;

    if(argc < 2)
    {
        printf("wrong input format, please -h \n");
        return -1;
    }
    if(strcmp(argv[1],"-h") == 0)
    {
        printf("        -h                  --help\n");
        printf("        -i                  --qseq_lpm_init\n");
        printf("        -d                  --qser_lpm_deinit\n");
        printf("        -e                  --qser_autosuspend_enable\n");
        printf("        -cl [wakelock name] --qser_wakelock_create \n");
        printf("        -al [wakelock num]  --qser_wakelock_lock \n");
        printf("        -rl [wakelock num]  --qser_wakelock_unlock \n");
        printf("        -dl [wakelock num]  --qser_wakelock_destroy\n");
        printf("        -ccl                --check created locks\n");
        printf("        -cll                --check lockup locks\n");
        printf("        -wla [id]           --qser_whitelist_add\n");
        printf("        -wld [id]           --qser_whitelist_del\n");
        printf("        -wlg                --qser_whitelist_get\n");
        printf("        -wlc                --qser_whitelist_clear\n");
    }
    else if(strcmp(argv[1],"-d") == 0)
    {
        ret = qser_lpm_deinit();
        if(ret != 0)
        {
            printf("lpm deinit fail\n");
        }
        else
        {
            printf("lpm deinit success\n");
        }
    }
    else if(strcmp(argv[1],"-e") == 0)
    {
        char num='1';
        ret = qser_autosuspend_enable(num);
        if(ret != 0)
        {
            printf("qser_autosuspend_enable fail\n");
        }
        else
        {
            printf("qser_autosuspend_enable success\n");
        }
    }
    else if(strcmp(argv[1],"-cl") == 0)
    {
        if(argv[2] == NULL)
        {
            printf("name is null\n");
            return -1;
        }
        len = strlen(argv[2]);
        printf("len =%d\n", len);
        ret = qser_wakelock_create(argv[2], len);
        if(ret < 0)
        {
            printf("wakelock create fail\n");
            printf("ret=%d\n", ret);
        }
        else
        {
            printf("wakelock create success\n");
            printf("fd=%d\n", ret);
        }
    }
    else if (strcmp(argv[1],"-al") == 0)
    {
        if(argv[2] == NULL)
        {
            printf("fd is null\n");
            return -1;
        }
        num = atoi(argv[2]);
        ret = qser_wakelock_lock(num);
        if(ret != 0)
        {
            printf("wakelock lock fail\n");
            printf("ret=%d\n", ret);
        }
        else
        {
            printf("wakelock lock success\n");
        }
    }

    else if (strcmp(argv[1],"-rl") == 0)
    {
        if(argv[2] == NULL)
        {
            printf("fd is null\n");
            return -1;
        }
        num = atoi(argv[2]);
        ret = qser_wakelock_unlock(num);
        if(ret != 0)
        {
            printf("wakelock unlock fail\n");
            printf("ret=%d\n", ret);
        }
        else
        {
            printf("wakelock unlock success\n");
        }
    }
    else if(strcmp(argv[1],"-dl") == 0)
    {
        if(argv[2] == NULL)
        {
            printf("fd is null\n");
            return -1;
        }
        num = atoi(argv[2]);
        ret = qser_wakelock_destroy(num);
        if(ret != 0)
        {
            printf("wakelock destroy fail\n");
            printf("ret=%d\n", ret);
        }
        else
        {
            printf("wakelock destroy success\n");
        }
    }
    else if(strcmp(argv[1],"-ccl") == 0)
    {
        int ret;
        ret = check_lock();
        if(ret != 0)
        {
            printf("check lock fail\n");
            printf("ret=%d\n", ret);
        }
        else
        {
            printf("check lock success\n");
        }
    }
    else if(strcmp(argv[1],"-cll") == 0)
    {
        int ret;
        ret = system("cat /sys/power/wake_lock");
        if(ret != 0)
        {
            printf("check created lock fail\n");
        }
    }
    else if(strcmp(argv[1],"-wla") == 0)
    {
        num = atoi(argv[2]);
        ret = qser_whitelist_add(num);
        if(ret != 0)
        {
            printf("mnet_whitelist_add ret %d.\n", ret);
        }

    }
    else if(strcmp(argv[1],"-wld") == 0)
    {
        num = atoi(argv[2]);
        ret = qser_whitelist_del(num);
        if(ret != 0)
        {
            printf("mnet_whitelist_del ret %d.\n", ret);
        }
    }
    else if(strcmp(argv[1],"-wlg") == 0)
    {
        char* whitelist;
        qser_whitelist_get(whitelist);
        printf("mnet_whitelist_get :%s\n",whitelist);
    }
    else if(strcmp(argv[1],"-wlc") == 0)
    {
        ret = qser_whitelist_clear();
        if(ret != 0)
        {
            printf("mnet_whitelist_clear ret %d.\n", ret);
        }
    }
    else
    {
        printf("wrong input format, please -h \n");
        return -1;
    }
    return 0;

}
