require ../platform-libs/platform-libs.inc

FILES_${PN} += "${includedir}/cutils ${includedir}/private ${includedir}/sys ${includedir}/log ${includedir}/android"

S = "${WORKDIR}/platform"


do_compile[noexec] = "1"
do_configure[noexec] = "1"

ALLOW_EMPTY_${PN} = "1"

do_install_append() {
	install -d ${D}${includedir}/system
	install -d ${D}${includedir}/cutils
	install -d ${D}${includedir}/private
	install -d ${D}${includedir}/sys
	install -d ${D}${includedir}/logger/utils
	install -d ${D}${includedir}/sysutils
	install -d ${D}${includedir}/netd

	install -m 0644 ${S}/system/core/include/system/* ${D}${includedir}/system
	install -m 0644 ${S}/system/core/include/cutils/* ${D}${includedir}/cutils
	install -m 0644 ${S}/system/core/include/private/android_filesystem_config.h ${D}${includedir}/private
	install -m 0644 ${S}/bionic/libc/include/sys/system_properties.h ${D}${includedir}/sys
	install -m 0644 ${S}/bionic/libc/dns/include/resolv_netid.h ${D}${includedir}/private
	install -m 0644 ${S}/system/netd/include/NetdClient.h ${D}${includedir}/netd

	install -m 0644 ${S}/system/core/include/utils/Log.h ${D}${includedir}/logger/utils
	install -m 0644 ${S}/system/core/include/sysutils/* ${D}${includedir}/sysutils
}

do_configure_append() {
	if [ "${KERNEL_ARCH}" = "arm64" ]; then
        rm -rf ${WORKDIR}/platform/bionic/libc/include/gnu/stubs.h
	fi
}
