#$1：源文件路径
#$2：mkfs.ubifs 配置参数MKUBIFS_ARGS
#$2：ubinize的配置参数
#$4：输入ubi镜像的路径和名字
fakeroot mkfs_ubifs() {
	cfg_file_name=userdata.cfg
	img_file_name=userdata.imgbak

	rm -fv $img_file_name $cfg_file_name

	echo "[ubifs]"                >  $cfg_file_name
	echo "mode=ubi"               >> $cfg_file_name
	echo "image=${img_file_name}" >> $cfg_file_name
	echo "vol_id=0"               >> $cfg_file_name
	echo "vol_size=$5"            >> $cfg_file_name
	echo "vol_type=dynamic"       >> $cfg_file_name
	echo "vol_name=userdata"      >> $cfg_file_name
	echo "vol_flags=autoresize"   >> $cfg_file_name

	mkfs.ubifs -r $1  $2 -o $img_file_name
	if [ $? -ne 0 ]; then
		echo "mkfs.ubifs error"
		exit -1
	else
		echo "mkfs.ubifs ok"
	fi

	ubinize -o $4 $3  $cfg_file_name
	if [ $? -ne 0 ]; then
		echo "ubinize error"
		exit -2
	else
		echo "ubinize ok"
	fi
	
	rm -fv $img_file_name $cfg_file_name
	exit 0
}

#$1:输出生成文件
#$2:文件系统源文件
#$3:文件系统大小
#$4:mkfs.ext4 参数
fakeroot mkfs_ext4fs() {

}
