SUMMARY = "Tools for managing memory technology devices"
HOMEPAGE = "http://www.linux-mtd.infradead.org/"
DESCRIPTION = "mtd-utils tool is a generic Linux subsystem for memory devices, especially Flash devices."
SECTION = "base"
LICENSE = "GPLv2+"
LIC_FILES_CHKSUM = "file://COPYING;md5=0636e73ff0215e8d672dc4c32c317bb3 \
"

PV = "2.1.2"

# DEPENDS_append_class-target = " libexecinfo "
DEPENDS_append_libc-musl = " libexecinfo "

FILESEXTRAPATHS_prepend := "${THISDIR}/mtd-utils:"

#           file://add-exclusion-to-mkfs-jffs2-git-2.patch
SRC_URI = "http://sources.cdn.openwrt.org/mtd-utils-${PV}.tar.bz2 \
           file://110-portability.patch \
           file://134-freebsd_loff_t.patch \
           file://200-libubigen-add-ubigen_write_terminator-function.patch \
           file://201-ubinize-add-terminator-support.patch \
           file://ubifs-selinux-file-contexts-mem-zero.patch \
           file://500-ubifs-add-xttr-args.patch  \
           "

SRC_URI[md5sum] = "19191bc0195a779c0bd1284c886084ab"
SRC_URI[sha256sum] = "8ad4c5f34716d40646aa28724a2f5616d325a6f119254f914e26976f1f76e9d6"

S = "${WORKDIR}/mtd-utils-${PV}/"

EXTRA_OECONF += "--disable-tests --without-crypto"

PACKAGECONFIG += "${@bb.utils.filter('DISTRO_FEATURES', 'xattr', d)}  \
                  ${@bb.utils.filter('DISTRO_FEATURES', 'selinux', d)}\
                  lzo zstd ubifs"

DEPENDS += "${@bb.utils.contains("DISTRO_FEATURES", "selinux", "libselinux", "", d)}"
PACKAGECONFIG[selinux] = "--with-selinux,--without-selinux,libselinux libselinux-native,"

FILES_${PN} += " \
    ${sbindir}/* \
"

