#ifndef _DDRNET_H_
#define _DDRNET_H_

#include <linux/interrupt.h>

#include <linux/netdevice.h>

#include <linux/kthread.h>

#include <linux/skbuff.h>
#include <linux/spinlock.h>
#include <linux/semaphore.h>

#include <linux/soc/zte/rpm/rpmsg.h>


#define USE_DDRNET_PACKET
#include "ddrnet_queue.h"
#ifdef USE_DDRNET_PACKET
#define PACKET_SIZE_LIMIT         1000
#define WRAP_PACKET_THRESHHOLD  10
#define WRAP_FREE_PACKET_THRESHHOLD 10
#define DDRNET_PACKET_QUEUE_COUNT   5000//1024
#define DDRNET_WRAP_TIMER_OUT_MS    10
#define DDRNET_TRANS_THREDHOLD	   50

#define WRAP_CONTENT_SIZE     1024
#define DDRNET_PSB_PACKET_UNIT_SIZE            sizeof(struct T_FromExt_mem)
#define DDRNET_SKB_PACKET_UNIT_SIZE            sizeof(struct  T_ToExt_info)
#endif
struct ddrnet {
    struct net_device  *net;

    /*lan0 or wan0*/
    unsigned char lan;

    T_ZDrvRpMsg_ActorID actor_id;
    T_ZDrvRpMsg_ChID channel_id;
    unsigned int channel_size;

    //struct sk_buff_head txq;
    struct sk_buff_head rxq;
    //struct sk_buff_head done;

    struct task_struct *rcv_thread;     /* the receive thread   */
    struct task_struct *rel_thread;   
#ifdef USE_DDRNET_PACKET
    struct task_struct *skb_wrap_thread;
#endif
    struct tasklet_struct bh;
#ifdef USE_DDRNET_PACKET
    struct ddrnet_queue skb_que;
    struct ddrnet_queue skb_que_free;
    struct timer_list       wrap_timer;
    struct semaphore  skb_que_sem;
#endif

};
#ifdef USE_DDRNET_PACKET
struct  ddrnet_package{
        u32               pkg_length;                                        // package length
        u8               contents[WRAP_CONTENT_SIZE];           // package contents
};
s32 ddrnet_skb_pkg_xmit(struct ddrnet * dev, struct ddrnet_package* pkg);
s32 ddrnet_freepsb_pkg_xmit(struct ddrnet_package* pkg);
void ddrnet_skb_Wrap_TimerCallBack(u32 hnd);
void ddrnet_freepsb_Wrap_TimerCallBack(u32 hnd);
s32 ddrnet_skb_wrap_thread(void * __dev);
s32 ddrnet_freepsb_wrap_thread(void);
s32 ddrnet_skb_packet_enqueue(struct ddrnet* dev, struct T_ToExt_info* buf);
s32 ddrnet_freepsb_packet_enqueue(void *addr);
#endif
#endif  /*  _DDRNET_H_  */

