#include <linux/spinlock_types.h>
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/udp.h>
#include <linux/tcp.h>
#include <linux/icmp.h>
#include <net/ip.h>

#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netfilter_arp.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter/nf_conntrack_tcp.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_core.h>
#include <net/netfilter/nf_nat_rule.h>
#include <net/netfilter/nf_conntrack_helper.h>


int pkt_lost_track = 0;  /*ٿ*/

//spinlock_t plt_spinlock; // packet_lost_track spinlock
DEFINE_SPINLOCK(plt_spinlock);

int packet_track_tuple_get(struct sk_buff *skb, struct nf_conntrack_tuple *tuple)
{
    struct iphdr  *iph  = NULL;
    struct udphdr *udph = NULL;
    struct tcphdr *tcph = NULL;

    if (!skb || !tuple)
    {
        return -1;
    }

    /* only IP packets */    
    if (htons(ETH_P_IP) != skb->protocol)
    {
        return -1;
    }

    iph = (struct iphdr *)skb->data;

    /* not deal with fragment packets now */    
    if (ntohs(iph->frag_off) & (IP_MF | IP_OFFSET))
    {
        return -1;
    }

    if (iph->ttl <= 1)
    {
        return -1;
    }

    memset(tuple, 0, sizeof(struct nf_conntrack_tuple));

    /* only tcp/udp */
    if (IPPROTO_UDP == iph->protocol)
    {
        udph = (struct udphdr *)(skb->data + iph->ihl * 4);
        tuple->src.u.udp.port = udph->source;
        tuple->dst.u.udp.port = udph->dest;
    }
    else if (IPPROTO_TCP == iph->protocol)
    {
        tcph = (struct tcphdr *)(skb->data + iph->ihl * 4);
        tuple->src.u.tcp.port = tcph->source;
        tuple->dst.u.tcp.port = tcph->dest;
    }
    else
    {
        return -1;
    }

    tuple->src.l3num = AF_INET;
    tuple->src.u3.ip = iph->saddr;
    tuple->dst.u3.ip = iph->daddr;
    tuple->dst.protonum = iph->protocol;
    tuple->dst.dir = IP_CT_DIR_ORIGINAL;

    return 0;
}

void pkt_lost_init(struct nf_conn *ct)
{
    int i = 0; 

    for(i = 0; i < IP_CT_DIR_MAX; i++)
    {
        ct->conn_pktloss[i].cur_send_seq    = 0;
        ct->conn_pktloss[i].send_drops      = 0;
        ct->conn_pktloss[i].send_drop_bytes = 0;
        ct->conn_pktloss[i].recv_drops      = 0;
        ct->conn_pktloss[i].recv_drop_bytes = 0;
        ct->conn_pktloss[i].send_drop_frag  = NULL;
    }
}

void free_drop_frag(void *pct)
{
    struct send_drop_frag_t *current_frag, *temp;
    struct nf_conn *ct = (struct nf_conn *)pct;
    int i;
    
    if(ct == NULL)
        return;

    spin_lock_bh(&plt_spinlock);

    for(i = 0; i < IP_CT_DIR_MAX; i++)
    {
        current_frag = ct->conn_pktloss[i].send_drop_frag;
        while(current_frag != NULL)
        {
            temp = current_frag->next;
            kfree(current_frag);
            current_frag = temp;
        }
    }
    spin_unlock_bh(&plt_spinlock);
    return;
}


/*ݲ*/
void packet_lost_track(struct sk_buff *skb, struct nf_conn *ct)
{
    int is_sender_lost;
    struct nf_conntrack_tuple tuple;
    uint32_t tcph_seq, tcph_ack, tcp_data_len;
    struct iphdr *iph = NULL;
    //struct udphdr *udph = NULL;
    struct tcphdr *tcph = NULL;
    enum ip_conntrack_dir dir;
    enum ip_conntrack_dir dir_other;
    struct send_drop_frag_t* new_send_drop_frag, *current_frag, *prev;

    if(0 == pkt_lost_track)
        return;

    if(skb == NULL || ct == NULL)
        return;

    iph = (struct iphdr *)skb->data;
    
    if(IPPROTO_TCP != iph->protocol) // only tcp
        return;

    tcph = (struct tcphdr *)(skb->data + iph->ihl * 4);

    if (packet_track_tuple_get(skb, &tuple) < 0)
    {
        return;
    }
    
    spin_lock_bh(&plt_spinlock);
    if(nf_ct_tuple_equal(&tuple, &ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple))
	{
		dir = IP_CT_DIR_ORIGINAL;
		dir_other = IP_CT_DIR_REPLY;
	}
    else if(nf_ct_tuple_equal(&tuple, &ct->tuplehash[IP_CT_DIR_REPLY].tuple))
	{
        dir = IP_CT_DIR_REPLY;
		dir_other = IP_CT_DIR_ORIGINAL;
	}
    else 
        goto out;

    tcph_seq = ntohl(tcph->seq);
    tcph_ack = ntohl(tcph->ack_seq);
    //tcp_data_len = skb->len - iph->ihl * 4 - tcph->doff * 4;
    tcp_data_len = ntohs(iph->tot_len) - iph->ihl * 4 - tcph->doff * 4;

    if(ct->conn_pktloss[dir].cur_send_seq == 0)
    {
        ct->conn_pktloss[dir].cur_send_seq = tcph_seq + tcp_data_len;
        goto out;
    }

	if(ct->conn_pktloss[dir_other].cur_ack_seq == 0)
	{
		ct->conn_pktloss[dir_other].cur_ack_seq = tcph_ack;
		goto out;
	}
	else
	{
		//ڿackششݰackǵģtcph_ackСڵǰ¼ack
		//˵򣬺ԵֱӸack
		if(ct->conn_pktloss[dir_other].cur_ack_seq < tcph_ack)
		{
			ct->conn_pktloss[dir_other].cur_ack_seq = tcph_ack;
		}
	}
		
    if(tcp_data_len == 0)
    {
        goto out;
    }

    if(tcph_seq > ct->conn_pktloss[dir].cur_send_seq) // packet lost
    {
        new_send_drop_frag = kmalloc(sizeof(struct send_drop_frag_t), GFP_ATOMIC);
        if(NULL == new_send_drop_frag)
        {
            goto out;
        }

        memset(new_send_drop_frag, 0, sizeof(struct send_drop_frag_t));
        new_send_drop_frag->lower_seq = ct->conn_pktloss[dir].cur_send_seq;
        new_send_drop_frag->upper_seq = tcph_seq;
        
        current_frag = ct->conn_pktloss[dir].send_drop_frag;
        prev = NULL;
        while(current_frag)
        {
            prev = current_frag;
            current_frag = current_frag->next;
        }
        if(prev == NULL)
        {
            ct->conn_pktloss[dir].send_drop_frag = new_send_drop_frag;
        }
        else
        {
            prev->next = new_send_drop_frag;
            new_send_drop_frag->prev = prev;
        }
        ct->conn_pktloss[dir].cur_send_seq = tcph_seq + tcp_data_len;
    }
    else if(tcph_seq < ct->conn_pktloss[dir].cur_send_seq)
    {
        is_sender_lost = 0;
        current_frag = ct->conn_pktloss[dir].send_drop_frag;
        prev = NULL;
        while(current_frag)
        {
            if(current_frag->lower_seq <= tcph_seq && current_frag->upper_seq > tcph_seq)
            {
                is_sender_lost = 1;
                ct->conn_pktloss[dir].send_drops++;
                ct->conn_pktloss[dir].send_drop_bytes += tcp_data_len;

                if(tcph_seq == current_frag->lower_seq)
                {                    
                    if(tcph_seq + tcp_data_len < current_frag->upper_seq)
                    {
                        current_frag->lower_seq = tcph_seq + tcp_data_len;
                    }
                    else
                    {
                        if(prev == NULL)
                        {
                            if(current_frag->next)
                                current_frag->next->prev = NULL;
                            
                            ct->conn_pktloss[dir].send_drop_frag = current_frag->next;
                        }
                        else
                        {
                            prev->next = current_frag->next;
                            if(current_frag->next)
                                current_frag->next->prev = prev;
                        }
                        kfree(current_frag);
                        current_frag = NULL;                      
                    }
                }
                else /*tcph_seq > current_frag->lower_seq*/
                {                    
                    if(tcph_seq + tcp_data_len < current_frag->upper_seq)
                    {
                        new_send_drop_frag = kmalloc(sizeof(struct send_drop_frag_t), GFP_ATOMIC);
                        if(!new_send_drop_frag)
                            goto out;
                        
                        memset(new_send_drop_frag, 0, sizeof(struct send_drop_frag_t));

                        new_send_drop_frag->lower_seq = tcph_seq + tcp_data_len;
                        new_send_drop_frag->upper_seq = current_frag->upper_seq;

                        current_frag->upper_seq = tcph_seq;

                        new_send_drop_frag->next = current_frag->next;
                        if(current_frag->next != NULL)
                            current_frag->next->prev = new_send_drop_frag;
                        new_send_drop_frag->prev = current_frag;
                        current_frag->next = new_send_drop_frag;
                    }
                    else
                    {
                        current_frag->upper_seq = tcph_seq;
                    }
                }
                break;
#if 0
                if(tcph_seq + tcp_data_len < current_frag->upper_seq) // split it to two
                {
                    new_send_drop_frag = kmalloc(sizeof(struct send_drop_frag_t), GFP_ATOMIC);
                    memset(new_send_drop_frag, 0, sizeof(struct send_drop_frag_t));

                    new_send_drop_frag->lower_seq = tcph_seq + tcp_data_len;
                    new_send_drop_frag->upper_seq = current_frag->upper_seq;

                    current_frag->upper_seq = tcph_seq;

                    new_send_drop_frag->next = current_frag->next;
                    if(current_frag->next != NULL)
                        current_frag->next->prev = new_send_drop_frag;
                    new_send_drop_frag->prev = current_frag;
                    current_frag->next = new_send_drop_frag;
                }
                else // free
                {
                    if(prev == NULL)
                    {
                        ct->conn_pktloss[dir].send_drop_frag = current_frag->next;
                    }
                    else
                    {
                        prev->next = current_frag->next;
                        current_frag->next->prev = prev;
                    }
                    kfree(current_frag);
                    current_frag = NULL;
                }
                break;
#endif
            }
            prev = current_frag;
            current_frag = current_frag->next;
        }

        if(is_sender_lost == 0)
        {
            /*շûлACK߷ͷûյACKش*/
			if(tcph_seq < ct->conn_pktloss[dir].cur_ack_seq)
			{
				ct->conn_pktloss[dir_other].recv_drops++;
				ct->conn_pktloss[dir_other].recv_drop_bytes += tcp_data_len;
			}
			else
			{
            	ct->conn_pktloss[dir].recv_drops++;
            	ct->conn_pktloss[dir].recv_drop_bytes += tcp_data_len;
			}
        }
    }
    else
    {
        ct->conn_pktloss[dir].cur_send_seq = tcph_seq + tcp_data_len;
    }
out:
    spin_unlock_bh(&plt_spinlock);
    return;
}
