/*  
 * (C) Copyright 2016, ZIXC Corporation.
 *
 */

#include <common.h>
#include <asm/io.h>    
#include <asm/arch/hardware.h>
#include <board.h>
#include <jtag.h>

void jtag_init(void)
{
    int32_t tmp = 0x0;  
    
#if defined (CONFIG_BOARD_7520_UFI) || defined (CONFIG_BOARD_7520_DC)
     /*
	 *Jtag0
	 *0:M0Jtag, 1:function, 2:gpio, 3:psJtag, 4:phyJtag, 5:dspJtag, 6:ufiJtag, 7:gpio
	 */

 #ifdef CONFIG_BOARD_7520_JTAG0_M0
    #define JTAG0_CONNECT   0
 #endif

 #ifdef CONFIG_BOARD_7520_JTAG0_PS
    #define JTAG0_CONNECT   3
 #endif

 #ifdef CONFIG_BOARD_7520_JTAG0_PHY
    #define JTAG0_CONNECT   4
 #endif

 #ifdef CONFIG_BOARD_7520_JTAG0_AP
    #define JTAG0_CONNECT   6
 #endif
 
    tmp = __REG(0x0010d468);
    tmp = (tmp&0xf0ffffff)|(JTAG0_CONNECT)<<24;
    __REG(0x0010d468) = tmp;

    tmp = __REG(0x0010d46c);
    tmp = (tmp&0xf0ffffff)|(JTAG0_CONNECT)<<24;
    __REG(0x0010d46c) = tmp;
	
    tmp = __REG(0x0010d470);
    tmp = (tmp&0xf0ffffff)|(JTAG0_CONNECT)<<24;
    __REG(0x0010d470) = tmp;

    tmp = __REG(0x0010d474);
    tmp = (tmp&0xf0ffffff)|(JTAG0_CONNECT)<<24;
    __REG(0x0010d474) = tmp;

    tmp = __REG(0x0010d478);
    tmp = (tmp&0xf0ffffff)|(JTAG0_CONNECT)<<24;
    __REG(0x0010d478) = tmp;
	
    tmp = __REG(0x0010d47c);
    tmp = (tmp&0xf0ffffff)|(JTAG0_CONNECT)<<24;
    __REG(0x0010d47c) = tmp;
#endif	


     /*
	 *Jtag1/sd0 
	 *0:gpio, 1:sd0, 2:M0Jtag, 3:psJtag, 4:phyJtag, 5:dspJtag, 6:ufiJtag, 7:testpin
	 */
#ifdef CONFIG_BOARD_7520V2_EVB

    #define JTAG1_CONNECT   4
    tmp = __REG(0x0010e07c);
    tmp = (tmp&0xf0ffffff)|(JTAG1_CONNECT)<<24;
    __REG(0x0010e07c) = tmp;

    tmp = __REG(0x0010e080);
    tmp = (tmp&0xf0ffffff)|(JTAG1_CONNECT)<<24;
    __REG(0x0010e080) = tmp;

    tmp = __REG(0x0010e084);
    tmp = (tmp&0xf0ffffff)|(JTAG1_CONNECT)<<24;
    __REG(0x0010e084) = tmp;

    tmp = __REG(0x0010e088);
    tmp = (tmp&0xf0ffffff)|(JTAG1_CONNECT)<<24;
    __REG(0x0010e088) = tmp;
	
    tmp = __REG(0x0010e08c);
    tmp = (tmp&0xf0ffffff)|(JTAG1_CONNECT)<<24;
    __REG(0x0010e08c) = tmp;
	
    tmp = __REG(0x0010e090);
    tmp = (tmp&0xf0ffffff)|(JTAG1_CONNECT)<<24;
    __REG(0x0010e090) = tmp;
	

    /* 
     *Jtag2/SD1
	 *0:gpio, 1:sd1, 2:m0Jtag, 3:psJtag, 4:phyJtag, 5:dspJtag,6:gpio
	 */

    #define JTAG2_CONNECT   3
    tmp = __REG(0x0010e094);
    tmp = (tmp&0xf0ffffff)|(JTAG2_CONNECT)<<24;
    __REG(0x0010e094) = tmp;

    tmp = __REG(0x0010e098);
    tmp = (tmp&0xf0ffffff)|(JTAG2_CONNECT)<<24;
    __REG(0x0010e098) = tmp;

    tmp = __REG(0x0010e09c);
    tmp = (tmp&0xf0ffffff)|(JTAG2_CONNECT)<<24;
    __REG(0x0010e09c) = tmp;

    tmp = __REG(0x0010e0a0);
    tmp = (tmp&0xf0ffffff)|(JTAG2_CONNECT)<<24;
    __REG(0x0010e0a0) = tmp;

    tmp = __REG(0x0010e0a4);
    tmp = (tmp&0xf0ffffff)|(JTAG2_CONNECT)<<24;
    __REG(0x0010e0a4) = tmp;

    tmp = __REG(0x0010e0a8);
    tmp = (tmp&0xf0ffffff)|(JTAG2_CONNECT)<<24;
    __REG(0x0010e0a8) = tmp;
#endif

}
