#include "zte_web_interface.h"
#include "zte_web_net_wan.h"
#include "zte_web_get_fw_para.h"
#include "message.h"

#define IP_VERSION_V4 "ipv4"
#define IP_VERSION_V6 "ipv6"

//======================Global Constants=============================//
static char wan_if_name[20] = {0};   /* default is ppp0 */

//==============================Util================================//
static int isMacValid(char *str)
{
	int i, len = strlen(str);
	if (len != 17)
		return 0;

	for (i = 0; i < 5; i++) {
		if ((!isxdigit(str[i * 3])) || (!isxdigit(str[i * 3 + 1])) || (str[i * 3 + 2] != ':'))
			return 0;
	}
	return (isxdigit(str[15]) && isxdigit(str[16])) ? 1 : 0;
}

int isIpValid(char *str)
{
	struct in_addr addr;    // for examination/*lint !e1080 !565 */
	if ((! strcmp(T("any"), str)) || (! strcmp(T("any/0"), str)))
		return 1;
#ifdef WEBS_SECURITY
	int len = strlen(str);
	len--;
	while(len > 0)
	{
		len--;
		if(str[len] == '0' && str[len+1] >= '0')
		{
			if(len == 0 || (len > 1 && str[len-1] == '.'))
				return 0;
		}
	}
#endif	
	if (!(inet_aton(str, &addr))) {
		slog(MISC_PRINT, SLOG_ERR, "isIpValid(): %s is not a valid IP address.\n", str); /*lint !e26*/
		return 0;
	}
	return 1;
}

int isIpv6Valid(char *str)
{
	int ret = 0;
	struct in6_addr ipv6_addr;

	if ((! strcmp(T("any"), str)) || (! strcmp(T("any/0"), str)))
		return 1;

	ret = inet_pton(AF_INET6, str, &ipv6_addr);
	if (ret < 1) {
		slog(MISC_PRINT, SLOG_ERR,"isIpv6Valid: str inet_pton failed: %d \n", ret);
		return 0;
	}
	return 1;
}

static int isNumOnly(char *str)
{
	int i, len = strlen(str);
	for (i = 0; i < len; i++) {
		if ((str[i] >= '0' && str[i] <= '9'))
			continue;
		return 0;
	}
	return 1;
}

static int isAllNumAndSlash(char *str)
{
	int i, len = strlen(str);
	for (i = 0; i < len; i++) {
		if ((str[i] >= '0' && str[i] <= '9') || str[i] == '.' || str[i] == '/')
			continue;
		return 0;
	}
	return 1;
}

static int isOnlyOneSlash(char *str)
{
	int i, count = 0;
	int len = strlen(str);
	for (i = 0; i < len; i++)
		if (str[i] == '/')
			count++;
	return count <= 1 ? 1 : 0;
}

static int isIpNetmaskValid(char *s)
{
	char str[32]={0};
	char *slash;
	struct in_addr addr;    // for examination/*lint !e1080*/

	if (!s || !strlen(s)) {
		return 0;
	}

	strncpy(str, s, sizeof(str)-1);

	if ((!strcmp("any", str)) || (!strcmp("any/0", str)))
		return 1;

	if (!isAllNumAndSlash(str)) {
		return 0;
	}

	if (!isOnlyOneSlash(str)) {
		return 0;
	}

	slash = strchr(str, '/');
	if (slash) {
		int mask;

		*slash = '\0';
		slash++;
		if (!strlen(slash)) {
			return 0;
		}

		if (!isNumOnly(slash)) {
			return 0;
		}

		mask = atoi(slash);
		if (mask < 0 || mask > 32) {
			return 0;
		}
	}

	if (!(inet_aton(str, &addr))) {
		slog(MISC_PRINT, SLOG_ERR, "isIpNetmaskValid(): %s is not a valid IP address.\n", str); /*lint !e26*/
		return 0;
	}
	return 1;
}

static int getNums(char *value, char delimit)
{

	char *pos = value;

	int count = 1;
	if (!pos)
		return 0;
	while ((pos = strchr(pos, delimit))) {

		pos = pos + 1;

		count++;

	}

	return count;
}

static int getRuleNums(char *rules)
{

	return getNums(rules, ';');
}



/*
 *  argument:  [IN]     index -- the index array of deleted items(begin from 0)
 *             [IN]     count -- deleted itmes count.
 *             [IN/OUT] value -- original string/return string
 *             [IN]     delimit -- delimitor
 */
static int static_deleteNthValueMulti(int index[], int count, char *value, char delimit)
{
	char *begin, *end;
	int i = 0, j = 0;
	int need_check_flag = 0;
	char *buf = strdup(value);

	if(buf == NULL)
		return 0;
	*(buf+strlen(value)) = 0;
	begin = buf;

	end = strchr(begin, delimit);
	while (end) {
		if (i == index[j]) {
			memset(begin, 0, end - begin);
			if (index[j] == 0)
				need_check_flag = 1;
			j++;
			if (j >= count)
				break;
		}
		begin = end;

		end = strchr(begin + 1, delimit);
		i++;
	}

	if (!end && index[j] == i)
		memset(begin, 0, strlen(begin));

	if (need_check_flag) {
		for (i = 0; i < strlen(value); i++) {
			if (buf[i] == '\0')
				continue;
			if (buf[i] == ';')
				buf[i] = '\0';
			break;
		}
	}

	for (i = 0, j = 0; i < strlen(value) && j < 1023; i++) {
		if (buf[i] != '\0') {
			value[j++] = buf[i];
		}
	}
	value[j] = '\0';

	free(buf);
	return 0;
}

/*
 * substitution of getNthValue which dosen't destroy the original value
 */
static int static_getNthValueSafe(int index, char *value, char delimit, char *result, int len)
{
	int i = 0, result_len = 0;
	char *begin, *end;

	if (!value || !result || !len)
		return -1;

	begin = value;
	end = strchr(begin, delimit);

	while (i < index && end) {
		begin = end + 1;
		end = strchr(begin, delimit);
		i++;
	}

	//no delimit
	if (!end) {
		if (i == index) {
			end = begin + strlen(begin);
			result_len = (len - 1) < (end - begin) ? (len - 1) : (end - begin);
		} else
			return -1;
	} else
		result_len = (len - 1) < (end - begin) ? (len - 1) : (end - begin);

	memcpy(result, begin, result_len);
	*(result + result_len) = '\0';

	return 0;
}

/*************************** firewall ***************************/

/*IPPORTȷǽwebҳ*/
void zte_fw_basic_setting(webs_t wp)
{
	char *firewall_enable = NULL;    /* 0: Disabled  1: Enabled */
	char *default_policy = NULL;      /* 0: Accepted  1: Dropped */

	firewall_enable = websGetVar(wp, T("portFilterEnabled"), T("0"));
	default_policy  = websGetVar(wp, T("defaultFirewallPolicy"), T("0"));

	switch (atoi(firewall_enable)) {
	case 0:
		(void)zte_web_write("IPPortFilterEnable", "0");    /* Disable */
		slog(MISC_PRINT, SLOG_DEBUG, T("UFIx User disable port filtering!\n"));
		break;
	case 1:
		(void)zte_web_write("IPPortFilterEnable", "1");    /* Enable */
		slog(MISC_PRINT, SLOG_DEBUG, T("UFIx User enable port filtering!\n"));
		break;
	default:
		(void)zte_web_write("IPPortFilterEnable", "0");    /* Accepted */
		break;
	}

	switch (atoi(default_policy)) {
	case 1:
		(void)zte_web_write("DefaultFirewallPolicy", "1");    /* Dropped */
		break;
	case 0:
	default:
		(void)zte_web_write("DefaultFirewallPolicy", "0");    /* Accepted */
		break;
	}

	//zte_iptables_basic_setting();
	slog(MISC_PRINT, SLOG_NORMAL, "fw_basic_setting SEND MESSAGE TO MC START"); /*lint !e26*/
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_IPPORT_FILTER, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_DEBUG, "fw_basic_setting SEND MESSAGE TO MC END"); /*lint !e26*/

	//sc_cfg_save();
	zte_write_result_to_web(wp, SUCCESS);
}

/*˿תweb*/
void zte_fw_forward_setting(webs_t wp)
{
	char *firewall_enable = NULL;    /* 0: Disabled  1: Enabled */

	firewall_enable = websGetVar(wp, T("PortForwardEnable"), T("0"));

	switch (atoi(firewall_enable)) {
	case 0:
		(void)zte_web_write("PortForwardEnable", "0");    /* Disable */
		slog(MISC_PRINT, SLOG_DEBUG, T("UFIx User disable port forward!\n"));
		break;
	case 1:
		(void)zte_web_write("PortForwardEnable", "1");    /* Enable */
		slog(MISC_PRINT, SLOG_DEBUG, T("UFIx User enable port forward!\n"));
		break;
	default:
		(void)zte_web_write("PortForwardEnable", "0");    /* Accepted */
		break;
	}

	//zte_iptables_basic_setting();
	slog(MISC_PRINT, SLOG_NORMAL, "fw_forward_setting SEND MESSAGE TO MC START"); /*lint !e26*/
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_IPPORT_FORWARD, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_DEBUG, "fw_forward_setting SEND MESSAGE TO MC END"); /*lint !e26*/

	//sc_cfg_save();
	zte_write_result_to_web(wp, SUCCESS);
}

/*ǽڶƹڷǽ*/
void zte_fw_sys_security_setting(webs_t wp)
{
	char *rmE = NULL;    /* 0: Disabled  1: Enabled */
	char *wpfE = NULL;    /* 0: Disabled  1: Enabled */

	rmE = websGetVar(wp, T("RemoteManagement"), T("0"));
	wpfE = websGetVar(wp, T("WANPingFilter"), T("0"));

	switch (atoi(rmE)) {
	case 0:
		(void)zte_web_write("RemoteManagement", "0");    /* Disable */
		break;
	case 1:
		(void)zte_web_write("RemoteManagement", "1");    /* Enable */
		break;
	default:
		(void)zte_web_write("RemoteManagement", "0");    /* Accepted */
		break;
	}

	switch (atoi(wpfE)) {
	case 0:
		(void)zte_web_write("WANPingFilter", "0");    /* Disable */
		break;
	case 1:
		(void)zte_web_write("WANPingFilter", "1");    /* Enable */
		break;
	default:
		(void)zte_web_write("WANPingFilter", "0");    /* Accepted */
		break;
	}

	//zte_iptables_basic_setting();
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_IPPORT_FORWARD, 0, NULL, 0);

	//sc_cfg_save();
	zte_write_result_to_web(wp, SUCCESS);
}

/*ɾһǽ*/
void zte_fw_ipport_filter_del(webs_t wp)
{
	/* value from web page */
	int i = 0, j = 0;
	char_t *delete_id = NULL;
	int id = 0;
	char_t *start = NULL;
	char IPPortFilterRules_x[NV_ITEM_STRING_LEN_50] = {0};
	char IPPortFilterRules[NV_ITEM_STRING_LEN_200] = {0};
	int flag = 0;

	delete_id = websGetVar(wp, "delete_id", "");

	if (*delete_id == '\0') {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	//to delete the rules
	for (start = delete_id; *delete_id != '\0';) {
		if (*delete_id == ';') {
			*delete_id = '\0';
			id = atoi(start);
			memset(IPPortFilterRules_x, 0, sizeof(IPPortFilterRules_x));
			(void)snprintf(IPPortFilterRules_x, NV_ITEM_STRING_LEN_50, "IPPortFilterRules_%d", id);
			(void)sc_cfg_set(IPPortFilterRules_x, "");

			delete_id ++;/*lint !e52*/
			start = delete_id;
		} else {
			delete_id ++;/*lint !e52*/
		}
	}

	//organize the rule
	for (i = 0; i <= 9; i++) {
		flag = 0;
		memset(IPPortFilterRules_x, 0, sizeof(IPPortFilterRules_x));
		memset(IPPortFilterRules, 0, sizeof(IPPortFilterRules));

		(void)snprintf(IPPortFilterRules_x, NV_ITEM_STRING_LEN_50, "IPPortFilterRules_%d", i);
		sc_cfg_get(IPPortFilterRules_x, IPPortFilterRules, sizeof(IPPortFilterRules));
		if (0 == strcmp(IPPortFilterRules, "")) {
			for (j = (i + 1); j <= 9; j++) {
				//reset
				memset(IPPortFilterRules_x, 0, sizeof(IPPortFilterRules_x));
				memset(IPPortFilterRules, 0, sizeof(IPPortFilterRules));

				(void)snprintf(IPPortFilterRules_x, NV_ITEM_STRING_LEN_50, "IPPortFilterRules_%d", j);
				sc_cfg_get(IPPortFilterRules_x, IPPortFilterRules, sizeof(IPPortFilterRules));
				if (0 != strcmp(IPPortFilterRules, "")) {
					sc_cfg_set(IPPortFilterRules_x, "");
					memset(IPPortFilterRules_x, 0, sizeof(IPPortFilterRules_x));
					(void)snprintf(IPPortFilterRules_x, NV_ITEM_STRING_LEN_50, "IPPortFilterRules_%d", i);
					sc_cfg_set(IPPortFilterRules_x, IPPortFilterRules);
					flag = 1;
					break;
				}
			}

			if (0 == flag) {
				break;
			}
		}
	}

	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_IPPORT_FILTER, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_NORMAL, "fw_ipport_filter_del SEND MESSAGE TO MC END");/*lint !e26*/ /*lint !e26*/

	//sc_cfg_save();
	//zte_response_json_for_test(wp,"zte_fw_ipport_filter_del","send message to mc");

	zte_write_result_to_web(wp, SUCCESS);
	return;
}

/*ɾһ˿ת*/
void zte_fw_port_forward_del(webs_t wp)
{
	int i = 0, j = 0;
	char_t *delete_id = NULL;
	int id = 0;
	char_t *start = NULL;
	char PortForwardRules_x[NV_ITEM_STRING_LEN_50] = {0};
	char PortForwardRules[NV_ITEM_STRING_LEN_200] = {0};
	int flag = 0;

	delete_id = websGetVar(wp, "delete_id", "");

	if (*delete_id == '\0') {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	//to delete the rules
	for (start = delete_id; *delete_id != '\0';) {
		if (*delete_id == ';') {
			*delete_id = '\0';
			id = atoi(start);
			memset(PortForwardRules_x, 0, sizeof(PortForwardRules_x));
			(void)snprintf(PortForwardRules_x, NV_ITEM_STRING_LEN_50, "PortForwardRules_%d", id);
			slog(MISC_PRINT, SLOG_DEBUG, "port_forward delete NV:[%s]", PortForwardRules_x);
			(void)sc_cfg_set(PortForwardRules_x, "");

			delete_id ++;/*lint !e52*/
			start = delete_id;
		} else {
			delete_id ++;/*lint !e52*/
		}
	}

	//organize the rule
	for (i = 0; i <= 9; i++) {
		flag = 0;
		memset(PortForwardRules_x, 0, sizeof(PortForwardRules_x));
		memset(PortForwardRules, 0, sizeof(PortForwardRules));

		(void)snprintf(PortForwardRules_x, NV_ITEM_STRING_LEN_50, "PortForwardRules_%d", i);
		sc_cfg_get(PortForwardRules_x, PortForwardRules, sizeof(PortForwardRules));

		if (0 == strcmp(PortForwardRules, "")) {
			for (j = (i + 1); j <= 9; j++) {
				//reset
				memset(PortForwardRules_x, 0, sizeof(PortForwardRules_x));
				memset(PortForwardRules, 0, sizeof(PortForwardRules));

				(void)snprintf(PortForwardRules_x, NV_ITEM_STRING_LEN_50, "PortForwardRules_%d", j);
				sc_cfg_get(PortForwardRules_x, PortForwardRules, sizeof(PortForwardRules));
				if (0 != strcmp(PortForwardRules, "")) {
					(void)sc_cfg_set(PortForwardRules_x, "");

					memset(PortForwardRules_x, 0, sizeof(PortForwardRules_x));
					(void)snprintf(PortForwardRules_x, NV_ITEM_STRING_LEN_50, "PortForwardRules_%d", i);
					(void)sc_cfg_set(PortForwardRules_x, PortForwardRules);

					flag = 1;
					break;
				}
			}

			if (0 == flag) {
				break;
			}
		}
	}

	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_IPPORT_FORWARD, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_NORMAL, "fw_port_forward_del SEND MESSAGE TO MC END"); /*lint !e26*/
	//zte_response_json_for_test(wp,"zte_fw_port_forward_del","send message to mc");

	//sc_cfg_save();
	zte_write_result_to_web(wp, SUCCESS);
	return;
}

/******************************************************
* Function: zte_fw_port_map_check()
* Description:  check the add port map data
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 2014/08/18      V1.0    gebin        create
*******************************************************/
static int zte_fw_port_map_check(webs_t wp, fw_port_map_type *fw_port_map)
{
	// we dont trust user input.....
	if (!fw_port_map->spr) {//klocwork
		return -1;
	}
	if (!fw_port_map->dpr) {
		return -1;
	}
	/* user choose nothing but press "apply" only */
	if (0 == strlen(fw_port_map->ip_address)
	    || 0 == strlen(fw_port_map->spr)
	    || 0 == strlen(fw_port_map->dpr)
	    || 0 == strlen(fw_port_map->comment)) {
		zte_web_write("PortMapEnable", "1");
		slog(MISC_PRINT, SLOG_DEBUG,  "port_map some parameter null");
		return -1;
	}
#ifdef WEBS_SECURITY
	int i = 0;
	int len = strlen(fw_port_map->comment);
	for (i = 0; i < len; i++) {
		if (strchr("`$&*\\[];:\'\"<>,",fw_port_map->comment[i]) || !isprint(fw_port_map->comment[i])) {
			return -1;
		}
	}
#endif	
#if 0 // kw 3  fw_port_map->ip_address has already checked
	if (!strlen(fw_port_map->ip_address)) {
		return -1;
	}
#endif	
	if (!isIpValid(fw_port_map->ip_address)) {
		return -1;
	}

	if (!(fw_port_map->spr_int = atoi(fw_port_map->spr))) {
		return -1;
	}
	if (fw_port_map->spr_int > 65000) {
		return -1;
	}

	if (!(fw_port_map->dpr_int = atoi(fw_port_map->dpr))) {
		return -1;
	}
	if (fw_port_map->dpr_int > 65000) {
		return -1;
	}

	if (!strcmp(fw_port_map->protocol, "TCP"))
		fw_port_map->proto = PROTO_TCP;
	else if (!strcmp(fw_port_map->protocol, "UDP"))
		fw_port_map->proto = PROTO_UDP;
	else if (!strcmp(fw_port_map->protocol, "TCP&UDP"))
		fw_port_map->proto = PROTO_TCP_UDP;
	else {
		return -1;
	}
	if (strlen(fw_port_map->comment) > 32) {
		return -1;
	}
	/* i know you will try to break our box... ;) */
	if (strchr(fw_port_map->comment, ';') || strchr(fw_port_map->comment, ',')) {
		return -1;
	}

	return 1;
}

/*һ˿ӳ*/
void zte_fw_port_map_add(webs_t wp)
{
	slog(MISC_PRINT, SLOG_ERR, T("UFIx User added port map!\n"));
	fw_port_map_type fw_port_map;
	int check_result = 0;
	int count = 0;
	int flag = 0;
	char PortMapRules[NV_FW_RULE_MAX_LEN] = {0};
	char PortMapRules_x[NV_ITEM_STRING_LEN_50] = {0};
	char *portmap_enable = NULL;    /* 0: Disabled  1: Enabled */
	char portmap_original[2] = {0};    /* 0: Disabled  1: Enabled */

	slog(MISC_PRINT, SLOG_DEBUG, "enter fw_port_map_add.\n");

	//port_map setting
	portmap_enable = websGetVar(wp, T("portMapEnabled"), T("0"));

	//read original port_map setting
	zte_web_read("PortMapEnable", portmap_original);
	slog(MISC_PRINT, SLOG_DEBUG, "portmap_original: %s, portmap_enable: %s\n", portmap_original, portmap_enable);

	switch (atoi(portmap_enable)) {
	case 0:
		(void)zte_web_write("PortMapEnable", "0");    /* Disable */
		break;
	case 1:
		(void)zte_web_write("PortMapEnable", "1");    /* Enable */
		break;
	default:
		(void)zte_web_write("PortMapEnable", "0");    /* Accepted */
		break;
	}

	//portmap switch open/close, or keep close
	if ((0 != strcmp(portmap_original, portmap_enable)) || (0 == strcmp(portmap_enable, "0"))) {
		/* EC: 616000297057, ԭ: 粻ֶ֧˿ӳ */
		ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_IPPORT_MAPPING, 0, NULL, 0);

		//sc_cfg_save();
		zte_write_result_to_web(wp, SUCCESS);
		slog(MISC_PRINT, SLOG_NORMAL, "portmap switch open/close, or keep close\n");
		return;
	}

	memset(&fw_port_map, 0, sizeof(fw_port_map_type));
	fw_port_map.ip_address = websGetVar(wp, T("ip_address"), T(""));
	fw_port_map.spr        = websGetVar(wp, T("fromPort"), T(""));
	fw_port_map.dpr        = websGetVar(wp, T("toPort"), T(""));
	fw_port_map.protocol   = websGetVar(wp, T("protocol"), T(""));
	fw_port_map.comment    = websGetVar(wp, T("comment"), T(""));

	/* user re-press port_map open apply button, should return SUCCESS*/
	/* while user choose nothing but press "apply" only will be checked by js code*/
	if (0 == strlen(fw_port_map.ip_address)
	    && 0 == strlen(fw_port_map.spr)
	    && 0 == strlen(fw_port_map.dpr)
	    && 0 == strlen(fw_port_map.comment)) {
		zte_write_result_to_web(wp, SUCCESS);
		slog(MISC_PRINT, SLOG_DEBUG, "portmap re-press open apply button\n");
		return;
	}

	//add rules
	check_result = zte_fw_port_map_check(wp, &fw_port_map);
	if (check_result < 0) {
		slog(MISC_PRINT, SLOG_ERR, "portmap add rule failure\n");
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	for (count = 0; count <= 9; count++) {
		(void)snprintf(PortMapRules_x, NV_ITEM_STRING_LEN_50, "PortMapRules_%d", count);
		memset(PortMapRules, 0, sizeof(PortMapRules));
		zte_web_read(PortMapRules_x, PortMapRules);
		if (0 == strcmp(PortMapRules, "")) {
			memset(PortMapRules, 0, sizeof(PortMapRules));
			(void)snprintf(PortMapRules, NV_ITEM_STRING_LEN_200, "%s,%d,%d,%d,%s",
			               fw_port_map.ip_address, fw_port_map.spr_int,
			               fw_port_map.dpr_int, fw_port_map.proto,
			               fw_port_map.comment);
			(void)zte_web_write(PortMapRules_x, PortMapRules);
			flag = 1;
			slog(MISC_PRINT, SLOG_DEBUG, "fw_port_map_add %s: %s\n", PortMapRules_x, PortMapRules);
			break;
		}
	}

	if (0 == flag) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_IPPORT_MAPPING, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_NORMAL, "fw_port_map_add MESSAGE TO MC END\n"); /*lint !e26*/

	//sc_cfg_save();
	zte_write_result_to_web(wp, SUCCESS);
}

/*ɾһ˿ӳ*/
void zte_fw_port_map_del(webs_t wp)
{
	int i = 0, j = 0;
	char_t *delete_id = NULL;
	int id = 0;
	char_t *start = NULL;
	char PortMapRules_x[NV_ITEM_STRING_LEN_50] = {0};
	char PortMapRules[NV_ITEM_STRING_LEN_200] = {0};
	int flag = 0;

	delete_id = websGetVar(wp, "delete_id", "");
	slog(MISC_PRINT, SLOG_DEBUG, "fw_port_map_del delete_id: %s\n", delete_id);
	if (*delete_id == '\0') {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	//to delete the rules
	for (start = delete_id; *delete_id != '\0';) {
		if (*delete_id == ';') {
			*delete_id = '\0';
			id = atoi(start);
			memset(PortMapRules_x, 0, sizeof(PortMapRules_x));
			(void)snprintf(PortMapRules_x, NV_ITEM_STRING_LEN_50, "PortMapRules_%d", id);
			slog(MISC_PRINT, SLOG_DEBUG,  "port_map delete NV: %s\n", PortMapRules_x);
			(void)sc_cfg_set(PortMapRules_x, "");

			delete_id++; /*lint !e52*/
			start = delete_id;
		} else {
			delete_id ++;/*lint !e52*/
		}
	}

	//organize the rule
	for (i = 0; i <= 9; i++) {
		flag = 0;
		memset(PortMapRules_x, 0, sizeof(PortMapRules_x));
		memset(PortMapRules, 0, sizeof(PortMapRules));

		(void)snprintf(PortMapRules_x, NV_ITEM_STRING_LEN_50, "PortMapRules_%d", i);
		sc_cfg_get(PortMapRules_x, PortMapRules, sizeof(PortMapRules));

		if (0 == strcmp(PortMapRules, "")) {
			for (j = (i + 1); j <= 9; j++) {
				//reset
				memset(PortMapRules_x, 0, sizeof(PortMapRules_x));
				memset(PortMapRules, 0, sizeof(PortMapRules));

				(void)snprintf(PortMapRules_x, NV_ITEM_STRING_LEN_50, "PortMapRules_%d", j);
				sc_cfg_get(PortMapRules_x, PortMapRules, sizeof(PortMapRules));
				if (0 != strcmp(PortMapRules, "")) {
					(void)sc_cfg_set(PortMapRules_x, "");

					memset(PortMapRules_x, 0, sizeof(PortMapRules_x));
					(void)snprintf(PortMapRules_x, NV_ITEM_STRING_LEN_50, "PortMapRules_%d", i);
					(void)sc_cfg_set(PortMapRules_x, PortMapRules);

					flag = 1;
					break;
				}
			}

			if (0 == flag) {
				break;
			}
		}
	}

	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_IPPORT_MAPPING, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_NORMAL, "fw_port_map_del SEND MESSAGE TO MC END\n"); /*lint !e26*/

	//sc_cfg_save();
	zte_write_result_to_web(wp, SUCCESS);
}

//webȡ
/*int zte_get_fw_rules_num(webs_t wp, char* ruleName)
{
    char rules[NV_FW_RULE_MAX_LEN]={0};

	sc_cfg_get(ruleName, rules, sizeof(rules));
    if(0 == strlen(rules))
    {
        websWrite(wp, T("0"));
        return 0;
    }

    websWrite(wp, T("%d"), getRuleNums(rules));
    return 0;
}*/

void zte_goform_url_filter_add_process(webs_t wp)
{
	slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User added url filter!\n"));
	char urlfilters[1023] = {0};
	char new_urlfilters[1024] = {0};
	char *rule = websGetVar(wp, T("addURLFilter"), T(""));

	memset(urlfilters, 0, 1023);
	memset(new_urlfilters, 0, 1024);

	if (!rule)
		return;
	if (strchr(rule, ';'))
		return;

	sc_cfg_get("websURLFilters", urlfilters, sizeof(urlfilters));
	if (0 == strcmp(urlfilters, "")) {
		sc_cfg_set("websURLFilters", rule);
	} else {
		snprintf(new_urlfilters,sizeof(new_urlfilters),"%s%s%s",urlfilters,";",rule);
/*		strcat(new_urlfilters, urlfilters);
		strcat(new_urlfilters, ";");
		if(strlen(new_urlfilters) + strlen(rule) < 1024)
		strcat(new_urlfilters, rule);*/
		sc_cfg_set("websURLFilters", new_urlfilters);
	}

	//zte_iptables_Webs_Filter_Run();
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_URL_FILTER, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_NORMAL, "goform_url_filter_add_process MESSAGE TO MC END"); /*lint !e26*/

	//sc_cfg_save();

	zte_write_result_to_web(wp, SUCCESS);
}
//URL˹ɾ
void zte_goform_url_filter_delete_process(webs_t wp)
{
	int  j = 0, rule_count = 0;
	char_t name_buf[16] = {0};
	char_t *value = NULL;
	char_t *delete_id = NULL;
	int *deleArray = NULL;
	char rules[1024] = {0};
	char_t *start = NULL;
	int id = 0;

	delete_id = websGetVar(wp, "url_filter_delete_id", NULL);

	if (delete_id == NULL || *delete_id == '\0') {
		slog(MISC_PRINT, SLOG_DEBUG, "delete_id is NULL."); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE); /*lint !e26*/
		return;
	}
	slog(MISC_PRINT, SLOG_DEBUG, "delete_id is [%s].", delete_id); /*lint !e26*/

	//to delete the rules

	sc_cfg_get("websURLFilters", rules, sizeof(rules));
	if (0 == strlen(rules)) {
		slog(MISC_PRINT, SLOG_ERR, "rules is NULL."); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	rule_count = getRuleNums(rules);
#if 0 // kw 3 INVARIANT_CONDITION.UNREACH	
	if (!rule_count) {
		slog(MISC_PRINT, SLOG_ERR, "rule_count is NULL."); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
#endif
	deleArray = (int *)malloc(rule_count * sizeof(int));
	if (NULL == deleArray) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	for (start = delete_id; *delete_id != '\0';) {
		if (*delete_id == ';') {
			*delete_id = '\0';
			id = atoi(start);
			slog(MISC_PRINT, SLOG_DEBUG, "delete_id single is [%d].", id); /*lint !e26*/
			deleArray[j++] = id; /*lint !e52*/
			delete_id ++;
			start = delete_id;
		} else {
			delete_id ++;/*lint !e52*/
		}
	}
#if 0
	for (i = 0, j = 0; i < rule_count; i++) {
		snprintf(name_buf, 16, "DR%d", i);
		value = websGetVar(wp, name_buf, NULL);
		if (value) {
			deleArray[j++] = i;
		}
	}
#endif
	if (!j) {
		free(deleArray);

		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	static_deleteNthValueMulti(deleArray, rule_count, rules, ';');
	free(deleArray);
	deleArray = NULL;

	sc_cfg_set("websURLFilters", rules);

	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_URL_FILTER, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_NORMAL, "goform_url_filter_delete_process MESSAGE TO MC END"); /*lint !e26*/

	//sc_cfg_save();

	zte_write_result_to_web(wp, SUCCESS);
	return;
}

//DMZ
void zte_fw_dmz(webs_t wp)
{
	char *dmzE, *ip_address;

	dmzE = websGetVar(wp, T("DMZEnabled"), T(""));
	ip_address = websGetVar(wp, T("DMZIPAddress"), T(""));

	// someone use malform page.....
	if (!dmzE || !strlen(dmzE)) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	if (atoi(dmzE) && !isIpValid(ip_address)) {	// enable && invalid mac address
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	//zte_iptables_DMZ_Run();
	if (atoi(dmzE) == 0) {
		zte_web_write("DMZEnable", "0");// disable
		slog(MISC_PRINT, SLOG_DEBUG, T("UFIx User disable port forward!\n"));
	} else {
		zte_web_write("DMZEnable", "1");// enable
		slog(MISC_PRINT, SLOG_DEBUG, T("UFIx User enable port forward!\n"));
		if (strlen(ip_address)) {
			zte_web_write("DMZIPAddress", ip_address);
		}
	}

	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_DMZ, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_NORMAL, "fw_dmz SEND MESSAGE TO MC END"); /*lint !e26*/

	//sc_cfg_save();
	zte_write_result_to_web(wp, SUCCESS);
}

static int zte_fw_ipport_filter_check(webs_t wp, fw_ipport_filter_type *fw_ipport_filter)
{
	char *ip_version = NULL;
	ip_version = websGetVar(wp, T("ip_version"), T(""));

	if (0 == strlen(fw_ipport_filter->mac_address)
	    && 0 == strlen(fw_ipport_filter->sip_1)
	    && 0 == strlen(fw_ipport_filter->dip_1)
	    && 0 == strlen(fw_ipport_filter->sprf)
	    && 0 == strlen(fw_ipport_filter->dprf)) {
		slog(MISC_PRINT, SLOG_ERR, "fw_ipport_filter_add -> No MAC/IP/Port input!"); /*lint !e26*/
		return -1;
	}

	if (strlen(fw_ipport_filter->mac_address) > 0
	    && !isMacValid(fw_ipport_filter->mac_address)) {
		slog(MISC_PRINT, SLOG_ERR, "Mac address is error.");   /*lint !e26*/
		return -1;
	}

	if (strlen(fw_ipport_filter->sip_1)) {
		if (0 == strcmp(ip_version, IP_VERSION_V4)) {
			if (!isIpNetmaskValid(fw_ipport_filter->sip_1)) {
				slog(MISC_PRINT, SLOG_ERR, "fw_ipport_filter_add -> src ip is invalid:[%s]", fw_ipport_filter->sip_1); /*lint !e26*/
				return -1;
			}
		}
	} else {
		fw_ipport_filter->sip_1 = T("any/0");
		slog(MISC_PRINT, SLOG_DEBUG, "liuyingnan check:[%s]", fw_ipport_filter->sip_1); /*lint !e26*/
	}

	if (strlen(fw_ipport_filter->dip_1)) {
		if (0 == strcmp(ip_version, IP_VERSION_V4)) {
			if (!isIpNetmaskValid(fw_ipport_filter->dip_1)) {
				slog(MISC_PRINT, SLOG_ERR, "fw_ipport_filter_add -> dest ip is invalid:[%s]", fw_ipport_filter->dip_1); /*lint !e26*/
				return -1;
			}
		}
	} else {
		fw_ipport_filter->dip_1 = T("any/0");
		slog(MISC_PRINT, SLOG_DEBUG, "liuyingnan check:[%s]", fw_ipport_filter->dip_1); /*lint !e26*/
	}

	fw_ipport_filter->sip_2 = fw_ipport_filter->dip_2 = "0";

	if (!strcmp(fw_ipport_filter->protocol, T("TCP")))
		fw_ipport_filter->proto = PROTO_TCP;
	else if (!strcmp(fw_ipport_filter->protocol, T("UDP")))
		fw_ipport_filter->proto = PROTO_UDP;
	else if (!strcmp(fw_ipport_filter->protocol, T("None")))
		fw_ipport_filter->proto = PROTO_NONE;
	else if (!strcmp(fw_ipport_filter->protocol, T("ICMP")))
		fw_ipport_filter->proto = PROTO_ICMP;
	else if (!strcmp(fw_ipport_filter->protocol, T("TCP&UDP")))
		fw_ipport_filter->proto = PROTO_TCP_UDP;
	else {
		slog(MISC_PRINT, SLOG_ERR, "protocol is invalid:[%s]", fw_ipport_filter->protocol); /*lint !e26*/
		return -1;
	}

	/* port(1~65535) is valid only when the protocol is TCP or UDP */
	if (!strlen(fw_ipport_filter->sprf)
	    || fw_ipport_filter->proto == PROTO_NONE
	    || fw_ipport_filter->proto == PROTO_ICMP) {
		fw_ipport_filter->sprf_int = 0;
	} else {
		fw_ipport_filter->sprf_int = atoi(fw_ipport_filter->sprf);
		if (fw_ipport_filter->sprf_int == 0 || fw_ipport_filter->sprf_int > 65535) {
			slog(MISC_PRINT, SLOG_ERR, "sprf is invalid:[%s]", fw_ipport_filter->sprf); /*lint !e26*/
			return -1;
		}
	}

	if (!strlen(fw_ipport_filter->sprt)
	    || fw_ipport_filter->proto == PROTO_NONE
	    || fw_ipport_filter->proto == PROTO_ICMP) {
		fw_ipport_filter->sprt_int = 0;
	} else {
		fw_ipport_filter->sprt_int = atoi(fw_ipport_filter->sprt);
		if (fw_ipport_filter->sprt_int == 0 || fw_ipport_filter->sprt_int > 65535) {
			slog(MISC_PRINT, SLOG_ERR, "sprt is invalid:[%s]", fw_ipport_filter->sprt); /*lint !e26*/
			return -1;
		}
	}

	if (!strlen(fw_ipport_filter->dprf)
	    || fw_ipport_filter->proto == PROTO_NONE
	    || fw_ipport_filter->proto == PROTO_ICMP) {
		fw_ipport_filter->dprf_int = 0;
	} else {
		fw_ipport_filter->dprf_int = atoi(fw_ipport_filter->dprf);
		if (fw_ipport_filter->dprf_int == 0 || fw_ipport_filter->dprf_int > 65535) {
			slog(MISC_PRINT, SLOG_ERR, "dprf is invalid:[%s]", fw_ipport_filter->dprf); /*lint !e26*/
			return -1;
		}
	}

	if (!strlen(fw_ipport_filter->dprt)
	    || fw_ipport_filter->proto == PROTO_NONE
	    || fw_ipport_filter->proto == PROTO_ICMP) {
		fw_ipport_filter->dprt_int = 0;
	} else {
		fw_ipport_filter->dprt_int = atoi(fw_ipport_filter->dprt);
		if (fw_ipport_filter->dprt_int == 0 || fw_ipport_filter->dprt_int > 65535) {
			slog(MISC_PRINT, SLOG_ERR, "dprt is invalid:[%s]", fw_ipport_filter->dprt); /*lint !e26*/
			return -1;
		}
	}

	if (0 == (strcmp(fw_ipport_filter->action_str, T("Accept")))) {
		fw_ipport_filter->action = ACTION_ACCEPT;
	} else if (0 == (strcmp(fw_ipport_filter->action_str, T("Drop")))) {
		fw_ipport_filter->action = ACTION_DROP;
	} else {
		slog(MISC_PRINT, SLOG_ERR, "action is invalid:[%s]", fw_ipport_filter->action_str); /*lint !e26*/
		return -1;
	}

	if (strlen(fw_ipport_filter->comment) > 32) {
		slog(MISC_PRINT, SLOG_ERR, "comment is too long."); /*lint !e26*/
		return -1;
	}
	// i know you will try to break our box... ;)
	if (strchr(fw_ipport_filter->comment, ';') || strchr(fw_ipport_filter->comment, ',')) {
		slog(MISC_PRINT, SLOG_ERR, "comment is invalid."); /*lint !e26*/
		return -1;
	}

	return 1;
}

/*IPV4˿ڹ*/
static void zte_fw_ipport_filter_add_v4(webs_t wp)
{
	fw_ipport_filter_type fw_ipport_filter_v4;
	char IPPortFilterRules[NV_FW_RULE_MAX_LEN] = {0};
	char IPPortFilterRules_x[NV_ITEM_STRING_LEN_50] = {0};
	int check_result = 0;
	int count = 0;
	int flag = 0;

	memset(&fw_ipport_filter_v4, 0, sizeof(fw_ipport_filter_type));
	fw_ipport_filter_v4.sip_1 = websGetVar(wp, T("sip_address"), T("any"));
	fw_ipport_filter_v4.sip_2 = websGetVar(wp, T("sip_address2"), T(""));        // TODO: not support now
	fw_ipport_filter_v4.sprf   = websGetVar(wp, T("sFromPort"), T("0"));
	fw_ipport_filter_v4.sprt   = websGetVar(wp, T("sToPort"), T(""));
	fw_ipport_filter_v4.dip_1 = websGetVar(wp, T("dip_address"), T("any"));
	fw_ipport_filter_v4.dip_2 = websGetVar(wp, T("dip_address2"), T(""));        // TODO: not support now
	fw_ipport_filter_v4.dprf   = websGetVar(wp, T("dFromPort"), T("0"));
	fw_ipport_filter_v4.dprt   = websGetVar(wp, T("dToPort"), T(""));
	fw_ipport_filter_v4.mac_address = websGetVar(wp, T("mac_address"), T(""));
	fw_ipport_filter_v4.protocol        = websGetVar(wp, T("protocol"), T(""));                   // None | TCP | UDP | ICMP | TCP&UDP
	fw_ipport_filter_v4.action_str     = websGetVar(wp, T("action"), T(""));                    // Drop | Accept
	fw_ipport_filter_v4.comment      = websGetVar(wp, T("comment"), T(""));

	check_result = zte_fw_ipport_filter_check(wp, &fw_ipport_filter_v4);
	if (check_result < 0) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	for (count = 0; count <= 9; count ++) {
		(void)snprintf(IPPortFilterRules_x, NV_ITEM_STRING_LEN_50, "IPPortFilterRules_%d", count);
		memset(IPPortFilterRules, 0, sizeof(IPPortFilterRules));
		zte_web_read(IPPortFilterRules_x, IPPortFilterRules);
		if (0 == strcmp(IPPortFilterRules, "")) {
			memset(IPPortFilterRules, 0, sizeof(IPPortFilterRules));
			(void)snprintf(IPPortFilterRules, NV_FW_RULE_MAX_LEN, "%s,%s,%d,%d,%s,%s,%d,%d,%d,%d,%s,%s",
			               fw_ipport_filter_v4.sip_1, fw_ipport_filter_v4.sip_2,
			               fw_ipport_filter_v4.sprf_int, fw_ipport_filter_v4.sprt_int,
			               fw_ipport_filter_v4.dip_1, fw_ipport_filter_v4.dip_2,
			               fw_ipport_filter_v4.dprf_int, fw_ipport_filter_v4.dprt_int,
			               fw_ipport_filter_v4.proto, fw_ipport_filter_v4.action,
			               fw_ipport_filter_v4.comment, fw_ipport_filter_v4.mac_address);
			(void)zte_web_write(IPPortFilterRules_x, IPPortFilterRules);
			flag = 1;
			break;
		}
	}

	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_IPPORT_FILTER, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_NORMAL, "fw_ipport_filter_add_v4 SEND MESSAGE TO MC END"); /*lint !e26*/
	//zte_response_json_for_test(wp,"zte_fw_ipport_filter_add","send message to mc");
	//sc_cfg_save();

	zte_write_result_to_web(wp, SUCCESS);
}

/*IPV6˿ڹ*/
static void zte_fw_ipport_filter_add_v6(webs_t wp)
{
	fw_ipport_filter_type fw_ipport_filter_v6;
	char IPPortFilterRulesV6[NV_FW_RULE_MAX_LEN] = {0};
	char IPPortFilterRulesV6_x[NV_ITEM_STRING_LEN_50] = {0};
	int check_result = 0;
	int count = 0;
	int flag = 0;

	memset(&fw_ipport_filter_v6, 0, sizeof(fw_ipport_filter_type));
	fw_ipport_filter_v6.sip_1          = websGetVar(wp, T("sip_address"), T("any"));
	fw_ipport_filter_v6.sip_2          = websGetVar(wp, T("sip_address2"), T(""));        // TODO: not support now
	fw_ipport_filter_v6.sprf           = websGetVar(wp, T("sFromPort"), T("0"));
	fw_ipport_filter_v6.sprt           = websGetVar(wp, T("sToPort"), T(""));
	fw_ipport_filter_v6.dip_1          = websGetVar(wp, T("dip_address"), T("any"));
	fw_ipport_filter_v6.dip_2          = websGetVar(wp, T("dip_address2"), T(""));        // TODO: not support now
	fw_ipport_filter_v6.dprf           = websGetVar(wp, T("dFromPort"), T("0"));
	fw_ipport_filter_v6.dprt           = websGetVar(wp, T("dToPort"), T(""));
	fw_ipport_filter_v6.mac_address    = websGetVar(wp, T("mac_address"), T(""));
	fw_ipport_filter_v6.protocol       = websGetVar(wp, T("protocol"), T(""));                   // None | TCP | UDP | ICMP | TCP&UDP
	fw_ipport_filter_v6.action_str     = websGetVar(wp, T("action"), T(""));                    // Drop | Accept
	fw_ipport_filter_v6.comment        = websGetVar(wp, T("comment"), T(""));

	check_result = zte_fw_ipport_filter_check(wp, &fw_ipport_filter_v6);
	if (check_result < 0) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	for (count = 0; count <= 9; count ++) {
		(void)snprintf(IPPortFilterRulesV6_x, NV_ITEM_STRING_LEN_50, "IPPortFilterRulesv6_%d", count);
		memset(IPPortFilterRulesV6, 0, sizeof(IPPortFilterRulesV6));
		zte_web_read(IPPortFilterRulesV6_x, IPPortFilterRulesV6);
		if (0 == strcmp(IPPortFilterRulesV6, "")) {
			memset(IPPortFilterRulesV6, 0, sizeof(IPPortFilterRulesV6));
			(void)snprintf(IPPortFilterRulesV6, NV_FW_RULE_MAX_LEN, "%s,%s,%d,%d,%s,%s,%d,%d,%d,%d,%s,%s",
			               fw_ipport_filter_v6.sip_1, fw_ipport_filter_v6.sip_2,
			               fw_ipport_filter_v6.sprf_int, fw_ipport_filter_v6.sprt_int,
			               fw_ipport_filter_v6.dip_1, fw_ipport_filter_v6.dip_2,
			               fw_ipport_filter_v6.dprf_int, fw_ipport_filter_v6.dprt_int,
			               fw_ipport_filter_v6.proto, fw_ipport_filter_v6.action,
			               fw_ipport_filter_v6.comment, fw_ipport_filter_v6.mac_address);
			(void)zte_web_write(IPPortFilterRulesV6_x, IPPortFilterRulesV6);
			flag = 1;
			break;
		}
	}

	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_IPPORT_FILTER, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_NORMAL, "fw_ipport_filter_add_v6 MESSAGE TO MC END"); /*lint !e26*/

	//zte_response_json_for_test(wp,"zte_fw_ipport_filter_add","send message to mc");

	//sc_cfg_save();
	zte_write_result_to_web(wp, SUCCESS);
}

/*˿ڹЧԼ*/
static int zte_fw_port_forward_check(webs_t wp, fw_port_forward_type *fw_port_forward)
{
	/* user choose nothing but press "apply" only */
	if (0 == strlen(fw_port_forward->ip_address)
	    && 0 == strlen(fw_port_forward->prf)
	    && 0 == strlen(fw_port_forward->prt)
	    && 0 == strlen(fw_port_forward->comment)) {
		zte_web_write("PortForwardEnable", "1");
		ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_IPPORT_FORWARD, 0, NULL, 0);
		return -1;
	}

	if (!strlen(fw_port_forward->ip_address)) {
		return -1;
	}
	if (!isIpValid(fw_port_forward->ip_address)) {
		return -1;
	}

	// we dont trust user input.....
	if (!fw_port_forward->prf || !strlen(fw_port_forward->prf)) {
		return -1;
	}
	if (!(fw_port_forward->prf_int = atoi(fw_port_forward->prf))) {
		return -1;
	}
	if (fw_port_forward->prf_int > 65535) {
		return -1;
	}

	if (!fw_port_forward->prt) {
		return -1;
	}
	if (strlen(fw_port_forward->prt)) {
		if (!(fw_port_forward->prt_int = atoi(fw_port_forward->prt))) {
			return -1;
		}
		if (fw_port_forward->prt_int < fw_port_forward->prf_int) {
			return -1;
		}
		if (fw_port_forward->prt_int > 65535)
			return -1;
	} else {
		fw_port_forward->prt_int = 0;
	}

	if (! strcmp(fw_port_forward->protocol, "TCP"))
		fw_port_forward->proto = PROTO_TCP;
	else if (!strcmp(fw_port_forward->protocol, "UDP"))
		fw_port_forward->proto = PROTO_UDP;
	else if (!strcmp(fw_port_forward->protocol, "TCP&UDP"))
		fw_port_forward->proto = PROTO_TCP_UDP;
	else {
		return -1;
	}
	if (strlen(fw_port_forward->comment) > 32) {
		return -1;
	}
	/* i know you will try to break our box... ;) */
	if (strchr(fw_port_forward->comment, ';') || strchr(fw_port_forward->comment, ',')) {
		return -1;
	}

	return 1;
}

/*һǽ*/
void zte_fw_ipport_filter_add(webs_t wp)
{
	slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User added port filter!\n"));

	char *ip_version = NULL;

	ip_version = websGetVar(wp, T("ip_version"), T(""));

	if (0 == strcmp(ip_version, IP_VERSION_V4)) {
		zte_fw_ipport_filter_add_v4(wp);
	} else if (0 == strcmp(ip_version, IP_VERSION_V6)) {
		zte_fw_ipport_filter_add_v6(wp);
	} else {
		slog(MISC_PRINT, SLOG_ERR, "unknown ip_version:[%s]", ip_version); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
	}
}

/*һ˿ת򣬽zte_routerͳһ*/
void zte_fw_port_forward_add(webs_t wp)
{
	slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User added port forward!\n"));
	fw_port_forward_type fw_port_forward;
	int check_result = 0;
	int count = 0;
	int flag = 0;
	char PortForwardRules[NV_FW_RULE_MAX_LEN] = {0};
	char PortForwardRules_x[NV_ITEM_STRING_LEN_50] = {0};
	memset(&fw_port_forward, 0, sizeof(fw_port_forward_type));
	fw_port_forward.ip_address = websGetVar(wp, T("ipAddress"), T(""));
	fw_port_forward.prf        = websGetVar(wp, T("portStart"), T(""));
	fw_port_forward.prt        = websGetVar(wp, T("portEnd"), T(""));
	fw_port_forward.protocol   = websGetVar(wp, T("protocol"), T(""));
	fw_port_forward.comment    = websGetVar(wp, T("comment"), T(""));
	//slog(MISC_PRINT,SLOG_DEBUG, "fw_port_forward.protocol:[%s]", fw_port_forward.protocol);

	check_result = zte_fw_port_forward_check(wp, &fw_port_forward);
	if (check_result < 0) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	//zte_web_write("PortForwardEnable", "1");
	for (count = 0; count <= 9; count ++) {
		(void)snprintf(PortForwardRules_x, NV_ITEM_STRING_LEN_50, "PortForwardRules_%d", count);
		memset(PortForwardRules, 0, sizeof(PortForwardRules));
		zte_web_read(PortForwardRules_x, PortForwardRules);
		if (0 == strcmp(PortForwardRules, "")) {
			memset(PortForwardRules, 0, sizeof(PortForwardRules));
			(void)snprintf(PortForwardRules, NV_ITEM_STRING_LEN_200, "%s,%d,%d,%d,%s",
			               fw_port_forward.ip_address, fw_port_forward.prf_int,
			               fw_port_forward.prt_int, fw_port_forward.proto,
			               fw_port_forward.comment);
			(void)zte_web_write(PortForwardRules_x, PortForwardRules);
			flag = 1;
			break;
		}
	}

	if (0 == flag) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_IPPORT_FORWARD, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_NORMAL, "fw_port_forward_add MESSAGE TO MC END"); /*lint !e26*/
	//sc_cfg_save();
	zte_write_result_to_web(wp, SUCCESS);
}

/*ɾV4Ķ˿б*/
static void zte_fw_ipport_filter_del_v4(webs_t wp)
{
	int i = 0, j = 0;
	char_t *delete_id = NULL;
	int id = 0;
	char_t *start = NULL;
	char IPPortFilterRules_x[NV_ITEM_STRING_LEN_50] = {0};
	char IPPortFilterRules[NV_FW_RULE_MAX_LEN] = {0};
	int flag = 0;

	delete_id = websGetVar(wp, "delete_id", "");
	slog(MISC_PRINT, SLOG_DEBUG, "delete_id is [%s].", delete_id); /*lint !e26*/

	if (*delete_id == '\0') {
		return; // no delete the v4 rule
	}

	//to delete the rules
	for (start = delete_id; *delete_id != '\0';) {
		if (*delete_id == ';') {
			*delete_id = '\0';
			id = atoi(start);
			memset(IPPortFilterRules_x, 0, sizeof(IPPortFilterRules_x));
			(void)snprintf(IPPortFilterRules_x, sizeof(IPPortFilterRules_x) - 1, "IPPortFilterRules_%d", id);
			(void)zte_web_write(IPPortFilterRules_x, "");

			delete_id ++;/*lint !e52*/
			start = delete_id;
		} else {
			delete_id ++;/*lint !e52*/
		}
	}

	//organize the rule
	for (i = 0; i <= 9; i++) {
		flag = 0;
		memset(IPPortFilterRules_x, 0, sizeof(IPPortFilterRules_x));
		memset(IPPortFilterRules, 0, sizeof(IPPortFilterRules));

		(void)snprintf(IPPortFilterRules_x, sizeof(IPPortFilterRules_x) - 1, "IPPortFilterRules_%d", i);
		(void)zte_web_read(IPPortFilterRules_x, IPPortFilterRules);

		if (0 == strcmp(IPPortFilterRules, "")) {
			for (j = (i + 1); j <= 9; j++) {
				//reset
				memset(IPPortFilterRules_x, 0, sizeof(IPPortFilterRules_x));
				memset(IPPortFilterRules, 0, sizeof(IPPortFilterRules));

				(void)snprintf(IPPortFilterRules_x, sizeof(IPPortFilterRules_x) - 1, "IPPortFilterRules_%d", j);
				(void)zte_web_read(IPPortFilterRules_x, IPPortFilterRules);
				if (0 != strcmp(IPPortFilterRules, "")) {
					(void)zte_web_write(IPPortFilterRules_x, "");

					memset(IPPortFilterRules_x, 0, sizeof(IPPortFilterRules_x));
					(void)snprintf(IPPortFilterRules_x, sizeof(IPPortFilterRules_x) - 1, "IPPortFilterRules_%d", i);
					(void)zte_web_write(IPPortFilterRules_x, IPPortFilterRules);

					flag = 1;
					break;
				}
			}

			if (0 == flag) {
				break;
			}
		}
	}
}

/*ɾV6Ķ˿б*/
static void zte_fw_ipport_filter_del_v6(webs_t wp)
{
	int i = 0, j = 0;
	char_t *delete_id = NULL;
	int id = 0;
	char_t *start = NULL;
	char IPPortFilterRules_x[NV_ITEM_STRING_LEN_50] = {0};
	char IPPortFilterRules[NV_FW_RULE_MAX_LEN_V6] = {0};
	int flag = 0;

	delete_id = websGetVar(wp, "delete_id_v6", "");
	slog(MISC_PRINT, SLOG_DEBUG, "delete_id is [%s].", delete_id); /*lint !e26*/

	if (*delete_id == '\0') {
		return; // no delete the v6 rule
	}

	//to delete the rules
	for (start = delete_id; *delete_id != '\0';) {
		if (*delete_id == ';') {
			*delete_id = '\0';
			id = atoi(start);
			memset(IPPortFilterRules_x, 0, sizeof(IPPortFilterRules_x));
			(void)snprintf(IPPortFilterRules_x, sizeof(IPPortFilterRules_x) - 1, "IPPortFilterRulesv6_%d", id);
			(void)zte_web_write(IPPortFilterRules_x, "");

			delete_id ++;/*lint !e52*/
			start = delete_id;
		} else {
			delete_id ++;/*lint !e52*/
		}
	}

	//organize the rule
	for (i = 0; i <= 9; i++) {
		flag = 0;
		memset(IPPortFilterRules_x, 0, sizeof(IPPortFilterRules_x));
		memset(IPPortFilterRules, 0, sizeof(IPPortFilterRules));

		(void)snprintf(IPPortFilterRules_x, sizeof(IPPortFilterRules_x) - 1, "IPPortFilterRulesv6_%d", i);
		(void)zte_web_read(IPPortFilterRules_x, IPPortFilterRules);

		if (0 == strcmp(IPPortFilterRules, "")) {
			for (j = (i + 1); j <= 9; j++) {
				//reset
				memset(IPPortFilterRules_x, 0, sizeof(IPPortFilterRules_x));
				memset(IPPortFilterRules, 0, sizeof(IPPortFilterRules));

				(void)snprintf(IPPortFilterRules_x, sizeof(IPPortFilterRules_x) - 1, "IPPortFilterRulesv6_%d", j);
				(void)zte_web_read(IPPortFilterRules_x, IPPortFilterRules);
				if (0 != strcmp(IPPortFilterRules, "")) {
					(void)zte_web_write(IPPortFilterRules_x, "");

					memset(IPPortFilterRules_x, 0, sizeof(IPPortFilterRules_x));
					(void)snprintf(IPPortFilterRules_x, sizeof(IPPortFilterRules_x) - 1, "IPPortFilterRulesv6_%d", i);
					(void)zte_web_write(IPPortFilterRules_x, IPPortFilterRules);

					flag = 1;
					break;
				}
			}

			if (0 == flag) {
				break;
			}
		}
	}

}

/*ɾĳ˿б*/
void zte_fw_ipport_filter_del_v4_v6(webs_t wp)
{
	//delete the v4 rule and v6 rule
	zte_fw_ipport_filter_del_v4(wp);
	zte_fw_ipport_filter_del_v6(wp);

	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_IPPORT_FILTER, 0, NULL, 0);

	//response
	zte_write_result_to_web(wp, SUCCESS);
}

/**********************************************************************
upnpҵ
**********************************************************************/
void zte_fw_upnp_set(webs_t wp, char_t *path, char_t *query)
{
	char *upnp_set = NULL;
#if 0
	//wanghan start ȱʧ̬ͷļdlfcn.hminiupnpdʱ޷ȴ׮֤webuiῨס
	zte_write_result_to_web(wp, SUCCESS);
	return;
	//wanghan end
#endif
	//zte_topsw_state_e_type status = ZTE_NVIO_DONE;

	upnp_set = websGetVar(wp, T("upnp_setting_option"), T("0"));

	if (atoi(upnp_set) == 0) {
		// disable
		(void)zte_web_write("upnpEnabled", "0");
		slog(MISC_PRINT, SLOG_DEBUG, T("UFIx User disable port forward!\n"));
	} else {
		// enable
		(void)zte_web_write("upnpEnabled", "1");
		slog(MISC_PRINT, SLOG_DEBUG, T("UFIx User enable port forward!\n"));
	}

	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_UPNP, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_NORMAL, "fw_upnp_set MESSAGE TO MC END"); /*lint !e26*/
	//sc_cfg_save();
	zte_write_result_to_web(wp, SUCCESS);
}

/*************************** wan pppoe ***************************/
void zte_goform_set_wan_gatewaymode_PPPOE(webs_t wp)
{
	char work_state[20] = {0};
	char *actionLink = NULL;
	char_t *pppoe_username = NULL;
	char_t *pppoe_cc = NULL;
	char_t *eth_dial_mode = NULL;

	pppoe_username = websGetVar(wp, T("pppoe_username"), T(""));
	pppoe_cc = websGetVar(wp, T("pppoe_cc"), T(""));
	eth_dial_mode = websGetVar(wp, T("dial_mode"), T(""));
	actionLink =  websGetVar(wp, T("action_link"), T(""));
	sc_cfg_set(NV_OPMS_WAN_MODE, "PPPOE");
	sc_cfg_set("ethwan_mode", "pppoe");
	zte_write_result_to_web(wp, SUCCESS);
	sc_cfg_get("rj45_state", work_state, sizeof(work_state));

	if (IFSTREQUAL(eth_dial_mode, "auto_dial")) {
		sc_cfg_set("ethwan_dialmode", "auto");
		if (0 == strcmp(work_state, "idle")) { //rj45Ѳ Զ ʲô
			sc_cfg_set("pppoe_username", pppoe_username);
			sc_cfg_set("pppoe_cc", pppoe_cc);
			netdev_connect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		}
	} else if (IFSTREQUAL(eth_dial_mode, "on_demand_dial")) {
		sc_cfg_set("ethwan_dialmode", "ondemand");
		if (0 == strcmp(work_state, "idle")) { //rj45Ѳ Զ ʲô
			sc_cfg_set("pppoe_username", pppoe_username);
			sc_cfg_set("pppoe_cc", pppoe_cc);
			netdev_connect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		}
	} else if (IFSTREQUAL(eth_dial_mode, "manual_dial")) { //ֻrj45Ѿ²ֶܹģʽ
		sc_cfg_set("ethwan_dialmode", "manual");
		if (!strcmp(actionLink, "connect")) {
			sc_cfg_set("pppoe_username", pppoe_username);
			sc_cfg_set("pppoe_cc", pppoe_cc);
			netdev_connect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		} else {
			netdev_disconnect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		}
	}
	//sc_cfg_save();
}

void zte_goform_set_wan_gatewaymode_DHCP(webs_t wp)
{
	char work_state[20] = {0};
	char *actionLink = NULL;
	char_t *eth_dial_mode = NULL;

	actionLink = websGetVar(wp, T("action_link"), T(""));
	eth_dial_mode = websGetVar(wp, T("dial_mode"), T(""));

	sc_cfg_set(NV_OPMS_WAN_MODE, "DHCP");
	sc_cfg_set("ethwan_mode", "dhcp");

	zte_write_result_to_web(wp, SUCCESS);

	sc_cfg_set("ethwan_dialmode", "auto");//dhcp ҳûֶ ʱĬΪԶ
	sc_cfg_get("rj45_state", work_state, sizeof(work_state));

	if (IFSTREQUAL(eth_dial_mode, "auto_dial")) {
		sc_cfg_set("ethwan_dialmode", "auto");
		if (0 == strcmp(work_state, "idle"))//rj45Ѳ Զ ʲô
			netdev_connect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
	} else if (IFSTREQUAL(eth_dial_mode, "on_demand_dial")) {
		sc_cfg_set("ethwan_dialmode", "ondemand");
		if (0 == strcmp(work_state, "idle"))//rj45Ѳ Զ ʲô
			netdev_connect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
	} else if (IFSTREQUAL(eth_dial_mode, "manual_dial")) { //ֻrj45Ѿ²ֶܹģʽ
		sc_cfg_set("ethwan_dialmode", "manual");
		if (!strcmp(actionLink, "connect")) {
			netdev_connect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		} else {
			netdev_disconnect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		}
	}
	//sc_cfg_save();
}

void zte_goform_set_wan_gatewaymode_STATIC(webs_t wp)
{
	char work_state[20] = {0};
	char *actionLink = NULL;
	char_t *eth_dial_mode = NULL;
	char_t  *static_wan_ipaddr = NULL;
	char_t  *static_wan_netmask = NULL;
	char_t  *static_wan_gateway = NULL;
	char_t  *static_wan_primary_dns = NULL;
	char_t  *static_wan_secondary_dns = NULL;

	static_wan_ipaddr = websGetVar(wp, T("static_wan_ipaddr"), T(""));
	static_wan_netmask = websGetVar(wp, T("static_wan_netmask"), T("0"));
	static_wan_gateway = websGetVar(wp, T("static_wan_gateway"), T(""));
	static_wan_primary_dns = websGetVar(wp, T("static_wan_primary_dns"), T(""));
	static_wan_secondary_dns = websGetVar(wp, T("static_wan_secondary_dns"), T(""));
	actionLink = websGetVar(wp, T("action_link"), T(""));
	eth_dial_mode = websGetVar(wp, T("dial_mode"), T(""));

	sc_cfg_set("ethwan_mode", "static");
	sc_cfg_set(NV_OPMS_WAN_MODE, "STATIC");
	zte_write_result_to_web(wp, SUCCESS);
	sc_cfg_get("rj45_state", work_state, sizeof(work_state));

	if (IFSTREQUAL(eth_dial_mode, "auto_dial")) {
		sc_cfg_set("ethwan_dialmode", "auto");
		if (0 == strcmp(work_state, "idle")) { //rj45Ѳ Զ ʲô
			sc_cfg_set("static_wan_ipaddr", static_wan_ipaddr);
			sc_cfg_set("static_wan_netmask", static_wan_netmask);
			sc_cfg_set("static_wan_gateway", static_wan_gateway);
			sc_cfg_set("static_wan_primary_dns", static_wan_primary_dns);
			sc_cfg_set("static_wan_secondary_dns", static_wan_secondary_dns);
			sc_cfg_set("static_ethwan_ip", static_wan_ipaddr);
			sc_cfg_set("static_ethwan_nw", static_wan_netmask);
			sc_cfg_set("static_ethwan_gw", static_wan_gateway);
			sc_cfg_set("static_ethwan_pridns", static_wan_primary_dns);
			sc_cfg_set("static_ethwan_secdns", static_wan_secondary_dns);
			netdev_connect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		}
	} else if (IFSTREQUAL(eth_dial_mode, "on_demand_dial")) {
		sc_cfg_set("ethwan_dialmode", "ondemand");
		if (0 == strcmp(work_state, "idle")) { //rj45Ѳ Զ ʲô
			sc_cfg_set("static_wan_ipaddr", static_wan_ipaddr);
			sc_cfg_set("static_wan_netmask", static_wan_netmask);
			sc_cfg_set("static_wan_gateway", static_wan_gateway);
			sc_cfg_set("static_wan_primary_dns", static_wan_primary_dns);
			sc_cfg_set("static_wan_secondary_dns", static_wan_secondary_dns);
			sc_cfg_set("static_ethwan_ip", static_wan_ipaddr);
			sc_cfg_set("static_ethwan_nw", static_wan_netmask);
			sc_cfg_set("static_ethwan_gw", static_wan_gateway);
			sc_cfg_set("static_ethwan_pridns", static_wan_primary_dns);
			sc_cfg_set("static_ethwan_secdns", static_wan_secondary_dns);
			netdev_connect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		}
	} else if (IFSTREQUAL(eth_dial_mode, "manual_dial")) { //ֻrj45Ѿ²ֶܹģʽ
		sc_cfg_set("ethwan_dialmode", "manual");
		if (!strcmp(actionLink, "connect")) {
			sc_cfg_set("static_wan_ipaddr", static_wan_ipaddr);
			sc_cfg_set("static_wan_netmask", static_wan_netmask);
			sc_cfg_set("static_wan_gateway", static_wan_gateway);
			sc_cfg_set("static_wan_primary_dns", static_wan_primary_dns);
			sc_cfg_set("static_wan_secondary_dns", static_wan_secondary_dns);
			sc_cfg_set("static_ethwan_ip", static_wan_ipaddr);
			sc_cfg_set("static_ethwan_nw", static_wan_netmask);
			sc_cfg_set("static_ethwan_gw", static_wan_gateway);
			sc_cfg_set("static_ethwan_pridns", static_wan_primary_dns);
			sc_cfg_set("static_ethwan_secdns", static_wan_secondary_dns);
			netdev_connect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		} else {
			netdev_disconnect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		}
	}
	//sc_cfg_save();
}

void zte_goform_set_wan_gatewaymode_AUTO(webs_t wp)
{
	char work_state[20] = {0};
	char_t *pppoe_username = NULL;
	char_t *pppoe_cc = NULL;
	char_t *actionLink = NULL;
	char_t *eth_dial_mode = NULL;

	pppoe_username = websGetVar(wp, T("pppoe_username"), T(""));
	pppoe_cc = websGetVar(wp, T("pppoe_cc"), T(""));
	actionLink =  websGetVar(wp, T("action_link"), T(""));
	eth_dial_mode = websGetVar(wp, T("dial_mode"), T(""));

	sc_cfg_set("ethwan_mode", "auto");
	sc_cfg_set("ethwan_dialmode", "auto");
	sc_cfg_set(NV_OPMS_WAN_MODE, "AUTO");

	zte_write_result_to_web(wp, SUCCESS);

	sc_cfg_get("rj45_state", work_state, sizeof(work_state));

	if (IFSTREQUAL(eth_dial_mode, "auto_dial")) {
		sc_cfg_set("ethwan_dialmode", "auto");
		if (0 == strcmp(work_state, "idle")) { //rj45Ѳ Զ ʲô
			sc_cfg_set("pppoe_username", pppoe_username);
			sc_cfg_set("pppoe_cc", pppoe_cc);
			netdev_connect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		}
	} else if (IFSTREQUAL(eth_dial_mode, "on_demand_dial")) {
		sc_cfg_set("ethwan_dialmode", "ondemand");
		if (0 == strcmp(work_state, "idle")) { //rj45Ѳ Զ ʲô
			sc_cfg_set("pppoe_username", pppoe_username);
			sc_cfg_set("pppoe_cc", pppoe_cc);
			netdev_connect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		}
	} else if (IFSTREQUAL(eth_dial_mode, "manual_dial")) { //ֻrj45Ѿ²ֶܹģʽ
		sc_cfg_set("ethwan_dialmode", "manual");
		if (!strcmp(actionLink, "connect")) {
			sc_cfg_set("pppoe_username", pppoe_username);
			sc_cfg_set("pppoe_cc", pppoe_cc);
			netdev_connect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		} else {
			netdev_disconnect_internet(RJ45_WAN_DEV, MODULE_ID_WEB_CGI);
		}
	}
	//sc_cfg_save();
}

void zte_goform_set_operation_mode(webs_t wp)
{
	char_t	*mode = NULL;
	char	oldMode[128] = {0};
	char buf[NV_ITEM_STRING_LEN_20] = {0};

	sc_cfg_get(NV_BLC_WAN_MODE, oldMode, sizeof(oldMode));
	mode = websGetVar(wp, T("opMode"), T("PPP"));
	sc_cfg_set(NV_BLC_WAN_MODE, mode);

	if (!strcmp(mode, oldMode)) {
		zte_write_result_to_web(wp, FAILURE);
	} else {
		zte_write_result_to_web(wp, SUCCESS);
		slog(MISC_PRINT, SLOG_NORMAL,"goform_set_operation_mode: send MSG_CMD_RESTART_REQUEST\n");
		ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_RESTART_REQUEST, 0, NULL, 0);
	}
}


//ping
void zte_ping_diagnostics_start(webs_t wp)
{
	char_t *diag_addr = NULL;
	char_t *repetition_count = NULL;
	char_t *time_out = NULL;
	char_t *data_size = NULL;
	char_t *diag_interface = NULL;

	diag_addr        = websGetVar(wp, T("ping_diag_addr"), T(""));
	repetition_count = websGetVar(wp, T("ping_repetition_count"), T(""));
	time_out         = websGetVar(wp, T("ping_time_out"), T(""));
	data_size        = websGetVar(wp, T("ping_data_size"), T(""));
	diag_interface   = websGetVar(wp, T("ping_diag_interface"), T(""));

	if ('\0' == (*diag_addr) || !isIpValid(diag_addr)) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	(void)zte_web_write("ping_diag_addr", diag_addr);

	if ('\0' != (*repetition_count))
		(void)zte_web_write("ping_repetition_count", repetition_count);

	if ('\0' != (*time_out))
		(void)zte_web_write("ping_time_out", time_out);

	if ('\0' != (*data_size))
		(void)zte_web_write("ping_data_size", data_size);

	if ('\0' != (*diag_interface))
		(void)zte_web_write("ping_diag_interface", diag_interface);

	//sc_cfg_save();
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_PING_DIAGNOSTICS, 0, NULL, 0);

	zte_write_result_to_web(wp, SUCCESS);
}

//رping
void zte_ping_diagnostics_stop(webs_t wp)
{
	system("killall ping");

	zte_write_result_to_web(wp, SUCCESS);
}


