
/************************************************************************
* Ȩ (C)2015, ͨѶɷ޹˾
*
* ļƣ zte_web_wlan_station.c
* ļʶ
* ժҪ
* ˵
* ǰ汾 V0.1
*     ߣ XUJIAN
* ڣ 2015-03-09
*
* ޸ļ¼1
* ޸ݣʼ汾
************************************************************************/
#include    "zte_web_interface.h"


#define WEB_WLAN_STATION_MODE_WIFI_PREF "wifi_pref"
#define WEB_WLAN_STATION_MODE_DIAL_PREF "dial_pref"
#define WEB_WLAN_STATION_CONNECTION_LEN   1
#define WEB_WLAN_STATION_MODE_LEN   10

#define WEB_WLAN_STATION_IP_STATUS_CONNECT "connect"
#define WEB_WLAN_STATION_IP_STATUS_DISCONNECT "disconnect"
#define WEB_WLAN_STATION_IP_STATUS_CONNECTING "connecting"
#define WIFI_STATION_IP_STATUS_DHCPING  "dhcping"
#define WEB_WLAN_STATION_IP_STATUS_LEN   15

#define WEB_WLAN_STATION_SPOT_ADD "add"
#define WEB_WLAN_STATION_SPOT_MODIFY "modify"
#define WEB_WLAN_STATION_SPOT_DEL "delete"
#define WEB_WLAN_STATION_SPOT_NUM_LEN   8
#define WEB_WLAN_STATION_SPOT_LIST_MAX  10
#define WEB_WLAN_STATION_PROFILE_NV_NAME_LEN 20
#define WEB_WLAN_STATION_SPOT_LEN  256
#define WEB_WLAN_STATION_SPOT_PROFILE_NAME_LEN  30
#define WEB_WLAN_STATION_SPOT_KEY_ID_LEN  10
#define WEB_WLAN_STATION_SPOT_PASSWORD_LEN  128

#define WEB_WLAN_STATION_SSID_LEN               128
#define WEB_WLAN_STATION_ACTION_LEN             32

#define WIFI_STATION_SPOT_LEN  256
#define WIFI_STATION_SPOT_LIST_NUM  10
#define WIFI_STATION_SPOT_PROFILE_NAME_LEN  30
#define WIFI_STATION_SPOT_PASSWORD_LEN  128
#define WIFI_STATION_SPOT_KEY_ID_LEN  10
#define WIFI_STATION_PROFILE_NV_NAME_LEN  20
#define WIFI_STATION_MAC_LEN                20
#define WIFI_STATION_SSID_LEN               128
#define WIFI_STATION_AUTH_MODE_LEN  20
#define WIFI_STATION_ENCRYPT_TYPE_LEN  20
#define WIFI_STATION_AP_MAC_LEN  18

#define WEB_WLAN_STATION_AUTH_MODE_SHARED "SHARED"
#define WEB_WLAN_STATION_AUTH_MODE_WPAPSK_WPA2PSK "WPAPSKWPA2PSK"
#define WEB_WLAN_STATION_AUTH_MODE_WPAPSK "WPAPSK"
#define WEB_WLAN_STATION_AUTH_MODE_WPA2PSK "WPA2PSK"
#define WEB_WLAN_STATION_AUTH_MODE_WPAEAP_WPA2EAP "WPAEAPWPA2EAP"
#define WEB_WLAN_STATION_AUTH_MODE_WPAEAP "WPAEAP"
#define WEB_WLAN_STATION_AUTH_MODE_WPA2EAP "WPA2EAP"
#define WEB_WLAN_STATION_AUTH_MODE_EAP_SIM_AKA "EAP-SIM/AKA"
#define WEB_WLAN_STATION_AUTH_MODE_WPA2_WPA3 "WPA2WPA3"
#define WEB_WLAN_STATION_AUTH_MODE_WPA3 "WPA3Personal"

#define WEB_WLAN_STATION_ENCRYPT_TYPE_TKIP_CCMP "TKIPCCMP"
#define WEB_WLAN_STATION_ENCRYPT_TYPE_CCMP "CCMP"
#define WEB_WLAN_STATION_ENCRYPT_TYPE_TKIP "TKIP"
#define WEB_WLAN_STATION_ENCRYPT_TYPE_NONE "NONE"
#define WEB_WLAN_STATION_ENCRYPT_TYPE_WEP "WEP"

#define safe_free(x) do { if(x) {free(x); x=NULL;} } while(0)
#define  wf_log(fmt, args...)	\
	do {slog(WIFI_PRINT,SLOG_ERR,   "[wlan][%s-%d]: " fmt"\n", __FUNCTION__, __LINE__, ## args);} while (0)

extern void zte_write_result_to_web(webs_t wp, char_t *result);
//extern LONG zte_send_message(USHORT target_id,USHORT Msg_cmd,USHORT us_DataLen,UCHAR *pData);
typedef enum web_wifi_profile_content {
	WEB_WLAN_STATION_CONTENT_UNDEFINED,
	WEB_WLAN_STATION_PROFILE_NAME,
	WEB_WLAN_STATION_FROM_PROVIDER,
	WEB_WLAN_STATION_CONNECT_STATUS,
	WEB_WLAN_STATION_SIGNAL,
	WEB_WLAN_STATION_SSID,
	WEB_WLAN_STATION_AUTH_MODE,
	WEB_WLAN_STATION_ENCRYPT_TYPE,
	WEB_WLAN_STATION_PASSWORD,
	WEB_WLAN_STATION_KEY_ID,
	WEB_WLAN_STATION_MAC
} web_wifi_profile_content_t;

typedef struct  update_spot_info {
	char  spot[WEB_WLAN_STATION_SPOT_LEN];
	char  action[WEB_WLAN_STATION_ACTION_LEN];
} updateinfo_t;

typedef struct web_spot {
	char      profile_name[WIFI_STATION_SPOT_PROFILE_NAME_LEN];
	short     from_provider;//0:Ӫ̣1:Ӫ
	short     connect_status;
	short     signal;
	char      ssid[WIFI_STATION_SSID_LEN];
	char      auth_mode[WIFI_STATION_AUTH_MODE_LEN];
	char      encrypt_type[WIFI_STATION_ENCRYPT_TYPE_LEN];
	char      password[WIFI_STATION_SPOT_PASSWORD_LEN];
	short     keyID;
	char     mac[WIFI_STATION_MAC_LEN];
} web_spot_t;

static web_spot_t * g_spot_list[WEB_WLAN_STATION_SPOT_LIST_MAX] = {NULL};

static int get_spot_num(char_t* spot_num)
{
	int num = -1;

	if (spot_num == NULL) {
		return num;
	}

	if (strcmp(spot_num, "0") == 0) {
		num = 0;
	} else if (strcmp(spot_num, "1") == 0) {
		num = 1;
	} else if (strcmp(spot_num, "2") == 0) {
		num = 2;
	} else if (strcmp(spot_num, "3") == 0) {
		num = 3;
	} else if (strcmp(spot_num, "4") == 0) {
		num = 4;
	} else if (strcmp(spot_num, "5") == 0) {
		num = 5;
	} else if (strcmp(spot_num, "6") == 0) {
		num = 6;
	} else if (strcmp(spot_num, "7") == 0) {
		num = 7;
	} else if (strcmp(spot_num, "8") == 0) {
		num = 8;
	} else if (strcmp(spot_num, "9") == 0) {
		num = 9;
	} else if (strcmp(spot_num, "10") == 0) {
		num = 10;
	} else {
	}

	return num;
}

static BOOL check_profile_name(char_t* profile_name)
{
	int profile_name_len = 0;

	if (profile_name == NULL) {
		return FALSE;
	}

	profile_name_len = strlen(profile_name);

	if (profile_name_len > 0 && profile_name_len < WEB_WLAN_STATION_SPOT_PROFILE_NAME_LEN) {
		return TRUE;
	} else {
		return FALSE;
	}

}

static BOOL check_keyID(char_t* keyID)
{
	int keyID_len = 0;

	if (keyID == NULL) {
		return FALSE;
	}

	keyID_len = strlen(keyID);

	if (keyID_len > 0 && keyID_len < WEB_WLAN_STATION_SPOT_KEY_ID_LEN) {
		return TRUE;
	} else {
		return FALSE;
	}

}

static BOOL check_password(char_t* password)
{
	int password_len = 0;

	if (password == NULL) {
		return FALSE;
	}

	password_len = strlen(password);

	if (password_len >= 0 && password_len < WEB_WLAN_STATION_SPOT_PASSWORD_LEN) {
		return TRUE;
	} else {
		return FALSE;
	}

}

static BOOL check_encrypt_type(char_t* encrypt_type)
{
	if (encrypt_type == NULL) {
		return FALSE;
	}

	if (strcmp(encrypt_type, WEB_WLAN_STATION_ENCRYPT_TYPE_TKIP_CCMP) == 0
	    || strcmp(encrypt_type, WEB_WLAN_STATION_ENCRYPT_TYPE_CCMP) == 0
	    || strcmp(encrypt_type, WEB_WLAN_STATION_ENCRYPT_TYPE_TKIP) == 0
	    || strcmp(encrypt_type, WEB_WLAN_STATION_ENCRYPT_TYPE_WEP) == 0
	    || strcmp(encrypt_type, WEB_WLAN_STATION_ENCRYPT_TYPE_NONE) == 0) {
		return TRUE;
	} else {
		return FALSE;
	}

}

static BOOL check_auth_mode(char_t* auth_mode)
{
	if (auth_mode == NULL) {
		return FALSE;
	}

	if (strcmp(auth_mode, WF_AU_OPEN) == 0
	    || strcmp(auth_mode, WEB_WLAN_STATION_AUTH_MODE_SHARED) == 0
	    || strcmp(auth_mode, WEB_WLAN_STATION_AUTH_MODE_WPAPSK_WPA2PSK) == 0
	    || strcmp(auth_mode, WEB_WLAN_STATION_AUTH_MODE_WPAPSK) == 0
	    || strcmp(auth_mode, WEB_WLAN_STATION_AUTH_MODE_WPA2PSK) == 0
	    || strcmp(auth_mode, WEB_WLAN_STATION_AUTH_MODE_WPAEAP_WPA2EAP) == 0
	    || strcmp(auth_mode, WEB_WLAN_STATION_AUTH_MODE_WPAEAP) == 0
	    || strcmp(auth_mode, WEB_WLAN_STATION_AUTH_MODE_WPA2EAP) == 0
	    || strcmp(auth_mode, WEB_WLAN_STATION_AUTH_MODE_EAP_SIM_AKA) == 0
	    || strcmp(auth_mode, WEB_WLAN_STATION_AUTH_MODE_WPA2_WPA3) == 0
	    || strcmp(auth_mode, WEB_WLAN_STATION_AUTH_MODE_WPA3) == 0) {
		return TRUE;
	} else {
		return FALSE;
	}

}

static BOOL check_signal(char_t* signal)
{
	if (signal == NULL) {
		return FALSE;
	}

	if (strcmp(signal, "0") == 0
	    || strcmp(signal, "1") == 0
	    || strcmp(signal, "2") == 0
	    || strcmp(signal, "3") == 0
	    || strcmp(signal, "4") == 0) {
		return TRUE;
	} else {
		return FALSE;
	}

}

static BOOL check_mac(char_t * mac)
{
	int mac_len = 0;
	if (mac == NULL) {
		return FALSE;
	}
	mac_len = strlen(mac) + 1;
	slog(WIFI_PRINT, SLOG_DEBUG,"[%s] mac=%s,mac_len=%d\n", __FILE__, mac, mac_len);
	if (mac_len ==  WIFI_STATION_AP_MAC_LEN) {
		return TRUE;
	} else {
		return FALSE;
	}
}
static BOOL check_ssid(char_t* ssid)
{
	int ssid_len = 0;

	if (ssid == NULL) {
		return FALSE;
	}

	ssid_len = strlen(ssid);

	if (ssid_len > 0 && ssid_len < WEB_WLAN_STATION_SSID_LEN) {
		return TRUE;
	} else {
		return FALSE;
	}
}

static BOOL check_zero_one_str(char_t* str)
{
	if (str == NULL) {
		return FALSE;
	}

	if (strcmp(str, "0") == 0
	    || strcmp(str, "1") == 0) {
		return TRUE;
	} else {
		return FALSE;
	}
}
static web_spot_t* parse_spot_string(char *spot_string)
{
	web_spot_t *spot = NULL;
	char *splited_string = NULL;
	char *save = NULL;
	const char *delimiter = ",";
	web_wifi_profile_content_t wifi_profile_content = WEB_WLAN_STATION_CONTENT_UNDEFINED;
	char spot_string_tmp[256] = {0};

	if (spot_string == NULL) {
		return NULL;
	}

	strncpy(spot_string_tmp, spot_string, sizeof(spot_string_tmp)-1);

	spot = safe_malloc(sizeof(web_spot_t), FALSE);
	if (spot == NULL) {
		return NULL;
	}

	//ַָ洢ṹ
	splited_string = strtok_r(spot_string_tmp, delimiter, &save);
	while (splited_string) {
		wifi_profile_content++;
		switch (wifi_profile_content) {
		case WEB_WLAN_STATION_PROFILE_NAME:
			strncpy(spot->profile_name, splited_string, sizeof(spot->profile_name)-1);
			break;
		case WEB_WLAN_STATION_FROM_PROVIDER:
			spot->from_provider = atoi(splited_string);
			break;
		case WEB_WLAN_STATION_CONNECT_STATUS:
			spot->connect_status = atoi(splited_string);
			break;
		case WEB_WLAN_STATION_SIGNAL:
			spot->signal = atoi(splited_string);
			break;
		case WEB_WLAN_STATION_SSID:
			strncpy(spot->ssid, splited_string, sizeof(spot->ssid)-1);
			break;
		case WEB_WLAN_STATION_AUTH_MODE:
			strncpy(spot->auth_mode, splited_string, sizeof(spot->auth_mode)-1);
			break;
		case WEB_WLAN_STATION_ENCRYPT_TYPE:
			strncpy(spot->encrypt_type, splited_string, sizeof(spot->encrypt_type)-1);
			break;
		case WEB_WLAN_STATION_PASSWORD:
			strncpy(spot->password, splited_string, sizeof(spot->password)-1);
			break;
		case WEB_WLAN_STATION_KEY_ID:
			spot->keyID = atoi(splited_string);
			break;
		case WEB_WLAN_STATION_MAC:
			strncpy(spot->mac, splited_string, sizeof(spot->mac)-1);
			break;
		default:
			break;
		}

		splited_string = strtok_r(NULL, delimiter, &save);
	}

	if (wifi_profile_content != WEB_WLAN_STATION_MAC) {
		safe_free(spot);
		return NULL;
	}

	return spot;

}



static BOOL check_wifi_profile(char_t* wifi_profile)
{
	web_wifi_profile_content_t wifi_profile_content = WEB_WLAN_STATION_CONTENT_UNDEFINED;
	char_t *splited_string = NULL;
	char_t *save = NULL;
	char_t *delimiter = ",";
	char_t wifi_profile_temp[WEB_WLAN_STATION_SPOT_LEN] = {0};

	if (wifi_profile == NULL) {
		return FALSE;
	}

	strncpy(wifi_profile_temp, wifi_profile, sizeof(wifi_profile_temp)-1);

	//ַָ
	splited_string = strtok_r(wifi_profile_temp, delimiter, &save);
	while (splited_string) {
		slog(WIFI_PRINT, SLOG_DEBUG,"[%s]profile split=%s\n", __FILE__, splited_string);
		wifi_profile_content++;
		switch (wifi_profile_content) {
		case WEB_WLAN_STATION_PROFILE_NAME://profile_name
			if (check_profile_name(splited_string) == FALSE) {
				return FALSE;
			}
			break;
		case WEB_WLAN_STATION_FROM_PROVIDER://from_provider
			if (check_zero_one_str(splited_string) == FALSE) {
				return FALSE;
			}
			break;
		case WEB_WLAN_STATION_CONNECT_STATUS://connect_status
			if (check_zero_one_str(splited_string) == FALSE) {
				return FALSE;
			}
			break;
		case WEB_WLAN_STATION_SIGNAL://signal
			if (check_signal(splited_string) == FALSE) {
				return FALSE;
			}
			break;
		case WEB_WLAN_STATION_SSID://ssid
			if (check_ssid(splited_string) == FALSE) {
				return FALSE;
			}
			break;
		case WEB_WLAN_STATION_AUTH_MODE://auth_mode
			if (check_auth_mode(splited_string) == FALSE) {
				return FALSE;
			}
			break;
		case WEB_WLAN_STATION_ENCRYPT_TYPE://encrypt_type
			if (check_encrypt_type(splited_string) == FALSE) {
				return FALSE;
			}
			break;
		case WEB_WLAN_STATION_PASSWORD://password
			if (check_password(splited_string) == FALSE) {
				return FALSE;
			}
			break;
		case WEB_WLAN_STATION_KEY_ID://keyID
			if (check_keyID(splited_string) == FALSE) {
				return FALSE;
			}
			break;
		case WEB_WLAN_STATION_MAC://mac
			if (check_mac(splited_string) == FALSE) {
				return FALSE;
			}
			break;
		default:
			return FALSE;
		}

		splited_string = strtok_r(NULL, delimiter, &save);
	}

	if (wifi_profile_content == WEB_WLAN_STATION_MAC) {
		return TRUE;
	} else {
		return FALSE;
	}

}

static BOOL check_set_value(char_t* wifi_sta_connection)
{
	if (wifi_sta_connection == NULL) {
		return FALSE;
	}

	if (check_zero_one_str(wifi_sta_connection) == FALSE) {
		return FALSE;
	}
	/***
	    if(strcmp(ap_station_mode, WEB_WLAN_STATION_MODE_WIFI_PREF) == 0
	        || strcmp(ap_station_mode, WEB_WLAN_STATION_MODE_DIAL_PREF) == 0)
	    {
	    }
	    else
	    {
	        return FALSE;
	    }
	*****/
	return TRUE;

}

static BOOL check_spot_value(char_t* action, char_t* wifi_profile_num, char_t* old_wifi_profile_num, char_t* wifi_update_profile, char_t** wifi_profile)
{
	int spot_num_new = -1;
	int spot_num_old = -1;
	int temp = -5;
	int i = 0;
	int j = 0;
	char_t profile_name_tmp1[WEB_WLAN_STATION_SPOT_PROFILE_NAME_LEN] = {0};
	char_t profile_name_tmp2[WEB_WLAN_STATION_SPOT_PROFILE_NAME_LEN] = {0};

	if (action == NULL || wifi_profile_num == NULL || old_wifi_profile_num == NULL
	    || wifi_update_profile == NULL || wifi_profile == NULL) {
		slog(WIFI_PRINT, SLOG_ERR,"[%s]para is null\n", __FILE__);
		return FALSE;
	}

	spot_num_new = get_spot_num(wifi_profile_num);
	spot_num_old = get_spot_num(old_wifi_profile_num);
	temp = spot_num_new - spot_num_old;

	slog(WIFI_PRINT, SLOG_DEBUG,"[%s]spot_num_new=%d\n", __FILE__, spot_num_new);
	slog(WIFI_PRINT, SLOG_DEBUG,"[%s]spot_num_old=%d\n", __FILE__, spot_num_old);
	slog(WIFI_PRINT, SLOG_DEBUG,"[%s]temp=%d\n", __FILE__, temp);

	//wifi_profile
	for (i = 0; i < spot_num_new; i++) {
		//鵥wifi_profileĺϷ
		if (check_wifi_profile(wifi_profile[i]) == FALSE) {
			slog(WIFI_PRINT, SLOG_ERR,"[%s]wifi_profile[%d]=%s wrong\n", __FILE__, i, wifi_profile[i]);

			return FALSE;
		}

	}
#if 0
	//wifi_update_profileĺϷ
	if (check_wifi_profile(wifi_update_profile) == FALSE) {
		wf_log("[%s]wifi_update_profile wrong\n", __FILE__);
		return FALSE;
	}
#endif
	//action

	if (strcmp(action, WEB_WLAN_STATION_SPOT_ADD) == 0) {
		//wifi_profile_num
		if (spot_num_new > 0 && temp == 1) { //kw 3
		} else {
			slog(WIFI_PRINT, SLOG_ERR,"[%s]wifi_profile_num add wrong\n", __FILE__);
			return FALSE;
		}
	} else if (strcmp(action, WEB_WLAN_STATION_SPOT_MODIFY) == 0) {
		//wifi_profile_num
		if (spot_num_new > 0 && temp == 0) { //kw 3
		} else {
			slog(WIFI_PRINT, SLOG_ERR,"[%s]wifi_profile_num modify wrong\n", __FILE__);

			return FALSE;
		}
	} else if (strcmp(action, WEB_WLAN_STATION_SPOT_DEL) == 0) {
		//wifi_profile_num
		if (spot_num_new >= 0 && temp == -1) { //kw 3
		} else {
			slog(WIFI_PRINT, SLOG_ERR,"[%s]wifi_profile_num del wrong\n", __FILE__);

			return FALSE;
		}
	} else {
		slog(WIFI_PRINT, SLOG_ERR,"[%s]wifi_profile_num action wrong\n", __FILE__);

		return FALSE;
	}

	//ȷµȵбеprofile nameΨһ
	for (i = 0; i < spot_num_new - 1; i++) {
		for (j = i + 1; j < spot_num_new; j++) {
			sscanf(wifi_profile[i], "%29[^,]", profile_name_tmp1);
			sscanf(wifi_profile[j], "%29[^,]", profile_name_tmp2);
			if (strcmp(profile_name_tmp1, profile_name_tmp2) == 0) {
				slog(WIFI_PRINT, SLOG_ERR,"[%s]wifi_profile_num profile name wrong\n", __FILE__);

				return FALSE;
			}
		}
	}


	//TODO ݲǼɵµwifi_profileıȽϵĺϷ

	return TRUE;

}

static BOOL check_connect_value(char_t* ssid, char_t* auth_mode, char_t* encrypt_type, char_t* keyID, char_t* profile, char_t* wep_key, char_t* wpa_psk1)
{
	if (ssid == NULL || auth_mode == NULL || wep_key == NULL || wpa_psk1 == NULL
	    || encrypt_type == NULL || keyID == NULL || profile == NULL) {
		return FALSE;
	}

	if (check_ssid(ssid) == FALSE) {
		return FALSE;
	}

	if (check_auth_mode(auth_mode) == FALSE) {
		return FALSE;
	}

	if (check_encrypt_type(encrypt_type) == FALSE) {
		return FALSE;
	}

	if (check_keyID(keyID) == FALSE) {
		return FALSE;
	}

	if (check_profile_name(profile) == FALSE) {
		return FALSE;
	}

	if (check_password(wep_key) == FALSE) {
		return FALSE;
	}

	if (check_password(wpa_psk1) == FALSE) {
		return FALSE;
	}

	return TRUE;

}

/**********************************************************************
* Function:        sort_spot
* Description:     sort spot by requirement
* Input:           g_spot_list
* Output:          sort the spot, save in g_spot_list
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2015/03/09    V1.0        xujian          first version
**********************************************************************/
void insert_to_spot_list(int priority, web_spot_t * spot)
{
	int i = 0, j = 0;



	//1. provider ap place the first
	//2. last connected ap place the second
	if (1 == priority || 2 == priority) {

		for (i = 0; i < WEB_WLAN_STATION_SPOT_LIST_MAX; i++) {
			if (g_spot_list[i] == NULL) {
				g_spot_list[i] = spot;
				return;
			} else {
				if (1 == g_spot_list[i]->from_provider) {
					continue;
				} else {

					//ȵȫһλãճǰiλ
					for (j = WEB_WLAN_STATION_SPOT_LIST_MAX - 2; j >= i; j--) { // ٶһ϶ǿյģ10ˣȵ㣬֮ǰѾжϴ󷵻
						if (g_spot_list[j] == NULL)continue;
						else {
							g_spot_list[j + 1] = g_spot_list[j];
						}
					}

					g_spot_list[i] = spot;
					return;
				}
			}
		}
	}


	//3. other ap stay
	if (3 == priority) {

		for (i = 0; i < WEB_WLAN_STATION_SPOT_LIST_MAX; i++) {

			if (g_spot_list[i] != NULL)continue;

			g_spot_list[i] = spot;
			return;

		}
	}

}

void resort_spot_list(int priority, char * profile_name)
{

	int i = 0, j = 0;
	char_t wifi_profile_nv_name[WEB_WLAN_STATION_PROFILE_NV_NAME_LEN] = {0};
	char spot_string[256] = {0};

	int index = 0;
	web_spot_t *  spot = NULL;


	for (i = 0; i < WEB_WLAN_STATION_SPOT_LIST_MAX; i++) {
		if (g_spot_list[i] != NULL) {
			if (strcmp(g_spot_list[i]->profile_name, profile_name) == 0) {
				index = i;
				spot = g_spot_list[i];
				break;
			}
		}

	}

	if (index == 0) return;

	for (i = 0; i < WEB_WLAN_STATION_SPOT_LIST_MAX; i++) {
		if (1 == g_spot_list[i]->from_provider) {
			continue;
		} else {
			//move other spot
			for (j = index; j > i; j--) { // ٶһ϶ǿյģ10ˣȵ㣬֮ǰѾжϴ󷵻
				if (g_spot_list[j] == NULL)continue;
				else {
					g_spot_list[j] = g_spot_list[j - 1]; //j must greater than 0
				}
			}

			g_spot_list[i] = spot;
			break;
		}
	}

	for (i = 0; i < WEB_WLAN_STATION_SPOT_LIST_MAX; i++) {
		if (i == 0) {
			safe_strcpy(wifi_profile_nv_name, "wifi_profile", WEB_WLAN_STATION_PROFILE_NV_NAME_LEN);
		} else {
			memset(wifi_profile_nv_name, 0, WEB_WLAN_STATION_PROFILE_NV_NAME_LEN);
			snprintf(wifi_profile_nv_name, WEB_WLAN_STATION_PROFILE_NV_NAME_LEN, "wifi_profile%d", i);
		}


		memset(spot_string, 0, sizeof(spot_string));
		if (g_spot_list[i] != NULL) {
			snprintf(spot_string, WIFI_STATION_SPOT_LEN, "%s,%d,%d,%d,%s,%s,%s,%s,%d", g_spot_list[i]->profile_name,
			         g_spot_list[i]->from_provider, g_spot_list[i]->connect_status, g_spot_list[i]->signal,
			         g_spot_list[i]->ssid, g_spot_list[i]->auth_mode, g_spot_list[i]->encrypt_type,
			         g_spot_list[i]->password, g_spot_list[i]->keyID);
		}

		slog(WIFI_PRINT, SLOG_DEBUG,"[%s]wifi_profile_nv_name=%s, spot_string=%s\n", __FILE__, wifi_profile_nv_name, spot_string);

		zte_web_write(wifi_profile_nv_name, spot_string);
	}




}


/**********************************************************************
* Function:        zte_wlan_station_set
* Description:     to set the wifi station func
* Input:           http info
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2015/03/09    V1.0        xujian          first version
**********************************************************************/
void zte_wlan_station_set(webs_t wp)
{
	char_t *wifi_sta_connection = NULL;
	//char_t *ap_station_mode = NULL;
	char_t old_wifi_sta_connection[WEB_WLAN_STATION_CONNECTION_LEN + 1] = {0};
	long lRet = 0;

	char MAX_Access_num_bak[16] = {0};
	char m_ssid_enable[16] = {0};
	wifi_sta_connection = websGetVar(wp, T("wifi_sta_connection"), T(""));
	//ap_station_mode = websGetVar(wp, T("ap_station_mode"), T(""));


	//ϷԼ
	slog(WIFI_PRINT, SLOG_DEBUG,"[%s]wlan_station_set !\n", __FILE__);
	if (check_set_value(wifi_sta_connection) == FALSE) {
		zte_write_result_to_web(wp, FAILURE);

		slog(WIFI_PRINT, SLOG_ERR,"[%s]parameter wrong!\n", __FILE__);
		return;
	}

	//ֵ
	(void)zte_web_read("wifi_sta_connection", old_wifi_sta_connection);


	//дNV
	(void)zte_web_write("wifi_sta_connection", wifi_sta_connection);
	if (strcmp(wifi_sta_connection, "1") == 0) { // Ᵽ
		(void)zte_web_read("m_ssid_enable", m_ssid_enable);

		if (!strcmp(m_ssid_enable, "1")) { //if multi ssid is open, recovery the max access nv
			zte_web_read("MAX_Access_num_bak", MAX_Access_num_bak);
			zte_web_write("MAX_Access_num", MAX_Access_num_bak);
			zte_web_write("m_ssid_enable", "0");
			wlan_set_change_ssid_key_status();//added by dujiajiao, for the switch between apsta and mssid
		}
	}
	//(void)zte_web_write("ap_station_mode", ap_station_mode);

	if (strcmp(wifi_sta_connection, "0") == 0) { //ܹر

		//õֵԭȵһ£ֱӻظɹ
		if (strcmp(wifi_sta_connection, old_wifi_sta_connection) == 0) {
			zte_write_result_to_web(wp, SUCCESS);
			return;
		}
		//else{
		//zte_web_write("RadioOff", "0"); // set ap radio off
		//}


		//TODO ܿģ--WIFIȵ״̬Ͽȵ,MODEMԶ
		zte_web_write("user_initiate_disconnect", "0"); //û״̬˳Ԥģʽ
		zte_web_write("manual_d_wifi", "0");


		//lRet=zte_send_message(MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_CLOSE, 0, NULL);
		lRet = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_CLOSE, 0, NULL, 0);
		if (lRet != 0) {
			//zte_web_write("RadioOff", "1");
			slog(WIFI_PRINT, SLOG_ERR,"[%s]wlan_station_set MSG_CMD_WIFI_STATION_CLOSE failed\n", __FILE__);
		} else {

			slog(WIFI_PRINT, SLOG_NORMAL,"[%s]wlan_station_set MSG_CMD_WIFI_STATION_CLOSE!\n", __FILE__);
		}

	} else if (strcmp(wifi_sta_connection, "1") == 0) { //ܿ

		if (strcmp(wifi_sta_connection, old_wifi_sta_connection) == 0) {
			// apsta ûпҪRadioOff

			zte_web_write("user_initiate_disconnect", "0"); //û״̬˳Ԥģʽ
			zte_web_write("manual_d_wifi", "0");
			/************
			  if(strcmp(ap_station_mode, WEB_WLAN_STATION_MODE_WIFI_PREF) == 0)
			  {
			     // zte_send_message(MODULE_ID_BLC_RCV, MSG_CMD_BLC_SET_WIFISTATION_PRE, 0, NULL);
			      wf_log("[%s]wlan_station_set WIFISTATION_PRE!\n",__FILE__);
			  }
			  else if(strcmp(ap_station_mode, WEB_WLAN_STATION_MODE_DIAL_PREF) == 0)
			  {
			      //zte_send_message(MODULE_ID_BLC_RCV, MSG_CMD_BLC_SET_MODEM_PRE, 0, NULL);
			      wf_log("[%s]wlan_station_set MODEM_PRE!\n",__FILE__);
			  }
			  **********/

		} else {
			//zte_web_write("RadioOff", "0"); // set ap radio off

			zte_web_write("user_initiate_disconnect", "0"); //û״̬˳Ԥģʽ
			zte_web_write("manual_d_wifi", "0");

			//lRet=zte_send_message(MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_OPEN, 0, NULL);
			lRet = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_OPEN, 0, NULL, 0);
			if (lRet != 0) {
				//zte_web_write("RadioOff", "1");
				slog(WIFI_PRINT, SLOG_ERR,"[%s]wlan_station_set MSG_CMD_WIFI_STATION_OPEN failed\n", __FILE__);
			} else {

				slog(WIFI_PRINT, SLOG_NORMAL,"[%s]wlan_station_set MSG_CMD_WIFI_STATION_OPEN!\n", __FILE__);
			}

		}
	}
	slog(WIFI_PRINT, SLOG_DEBUG,"wlan_station_set SUCCESS!\n");//cov m
	zte_write_result_to_web(wp, SUCCESS);
}

/*
    ɾȵ  ӹȵ ͬһȵʱҪ

    EX_SSID1 ΪգȻ´λȥڵȵ㣬

    1ɾӣprofile nameͬȻϵ޷wifi_profile ״̬λΪ 1ΪprofileѾ

    2ɾ󣬸ȵʵȻڣwlanstation profile_numΪ0ıǻϣ״̬

    ЩnvֵбҪ

*/
void zte_wlan_reset_EX_ap(void)
{

	zte_web_write("EX_SSID1", "");
	zte_web_write("EX_AuthMode", "");
	zte_web_write("EX_EncrypType", "");
	zte_web_write("EX_DefaultKeyID", "");
	zte_web_write("EX_WEPKEY", "");
	zte_web_write("EX_WPAPSK1", "");
	zte_web_write("EX_wifi_profile", "");
	zte_web_write("EX_mac", "");
}

/**********************************************************************
* Function:        zte_wlan_station_spot_profile_update
* Description:     to update the wifi spot profile
* Input:           http info
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2015/03/09    V1.0        xujian          first version
**********************************************************************/
void zte_wlan_station_spot_profile_update(webs_t wp)
{
	char_t *action = NULL;
	char_t *wifi_profile_num = NULL;
	char_t old_wifi_profile_num[WEB_WLAN_STATION_SPOT_NUM_LEN + 1] = {0};
	char_t *wifi_update_profile = NULL;
	char_t *wifi_profile[WEB_WLAN_STATION_SPOT_LIST_MAX] = {NULL};
	char_t sta_ip_status[WEB_WLAN_STATION_IP_STATUS_LEN + 1] = {0};
	char_t wifi_sta_connection[WEB_WLAN_STATION_CONNECTION_LEN + 1] = {0};
	char_t wifi_profile_nv_name[WEB_WLAN_STATION_PROFILE_NV_NAME_LEN] = {0};
	updateinfo_t  info = {0};

	char_t current_profile[WEB_WLAN_STATION_SPOT_PROFILE_NAME_LEN] = {0};
	char spot_string[WEB_WLAN_STATION_SPOT_LEN] = {0};

	char wifi_profile_string[WEB_WLAN_STATION_SPOT_LEN] = {0};
	web_spot_t * web_wifi_profile = NULL;
	web_spot_t * nv_wifi_profile = NULL;

	web_spot_t * tmp_wifi_profile = NULL;

	web_spot_t * web_spot = NULL;
	web_spot_t * update_spot = NULL;
	int i = 0;

	int current_profile_flag = -1; //sorted num of wifi_profile(nv)  in web ui

	slog(WIFI_PRINT, SLOG_NORMAL,"[%s]update spot profile\n", __FILE__);

	//WIFIȵ״̬޸ȵϢ
	(void)zte_web_read("sta_ip_status", sta_ip_status);
	if (strcmp(sta_ip_status, WEB_WLAN_STATION_IP_STATUS_CONNECTING) == 0 ||
	    strcmp(sta_ip_status, WIFI_STATION_IP_STATUS_DHCPING) == 0) {
		//zte_write_result_to_web(wp,FAILURE);
		zte_write_result_to_web(wp, PROCESSING);
		slog(WIFI_PRINT, SLOG_ERR,"[%s]update spot profile,connecting so failed\n", __FILE__);

		return;
	}

	//ܹرգ򷵻ش
	(void)zte_web_read("wifi_sta_connection", wifi_sta_connection);
	if (strcmp(wifi_sta_connection, "1") != 0) {
		zte_write_result_to_web(wp, FAILURE);
		slog(WIFI_PRINT, SLOG_ERR,"[%s]update spot profile,wifi sta no open so failed\n", __FILE__);

		return;
	}

	action = websGetVar(wp, T("action"), T(""));
	wifi_profile_num = websGetVar(wp, T("wifi_profile_num"), T(""));
	wifi_update_profile = websGetVar(wp, T("wifi_update_profile"), T(""));

	slog(WIFI_PRINT, SLOG_DEBUG,"[%s]update spot profile,wifi_profile_num=%s\n", __FILE__, wifi_profile_num);
	slog(WIFI_PRINT, SLOG_DEBUG,"[%s]update spot profile,wifi_update_profile=%s\n", __FILE__, wifi_update_profile);

	zte_web_read("EX_wifi_profile", current_profile);

	if (strcmp(action, WEB_WLAN_STATION_SPOT_DEL) == 0) {

		if (strncmp(current_profile, wifi_update_profile, 20) == 0) {

//webuiˢ⣬м϶ ԱɾҪӴ˱״̬ȵ㣬ɾ
			if (strcmp(sta_ip_status, WEB_WLAN_STATION_IP_STATUS_CONNECT) == 0) {
				slog(WIFI_PRINT, SLOG_ERR,"[%s]do not allow del connected profile=%s,[%s]\n", __FILE__, wifi_update_profile, current_profile);
				zte_write_result_to_web(wp, FAILURE);
				return;
			} else {
//ɾ֮ǰӹȵ㣬ҪEX_SSID1nvֵ
				slog(WIFI_PRINT, SLOG_DEBUG,"[%s]reset EX_SSID1 EX_wifi_profile=[%s]\n", __FILE__, current_profile);
				zte_wlan_reset_EX_ap();
			}
		}
	}
	if (strcmp(action, WEB_WLAN_STATION_SPOT_MODIFY) == 0) {
		sc_cfg_get("wifi_profile", wifi_profile_string, sizeof(wifi_profile_string));
		if (strcmp(wifi_profile_string, "") == 0) {
			slog(WIFI_PRINT, SLOG_ERR,"[%s]error!nv:wifi_profile=%s\n", __FILE__, wifi_profile_string);
			zte_write_result_to_web(wp, FAILURE);
			return;
		}

		nv_wifi_profile = parse_spot_string(wifi_profile_string);
		if (NULL == nv_wifi_profile) {
			slog(WIFI_PRINT, SLOG_ERR,"[%s]error!nv_wifi_profile=null\n", __FILE__);
			zte_write_result_to_web(wp, FAILURE);
			return;
		}
	}

	for (i = 0; i < WEB_WLAN_STATION_SPOT_LIST_MAX; i++) {
		if (i == 0) {
			safe_strcpy(wifi_profile_nv_name, "wifi_profile", WEB_WLAN_STATION_PROFILE_NV_NAME_LEN);
		} else {
			memset(wifi_profile_nv_name, 0, WEB_WLAN_STATION_PROFILE_NV_NAME_LEN);
			snprintf(wifi_profile_nv_name, WEB_WLAN_STATION_PROFILE_NV_NAME_LEN, "wifi_profile%d", i);
		}

		//ȡWEBֵ
		wifi_profile[i] = websGetVar(wp, wifi_profile_nv_name, T(""));

		slog(WIFI_PRINT, SLOG_DEBUG,"[%s]update spot profile,wifi_profile[%d]=%s\n", __FILE__, i, wifi_profile[i]);
#if 0
		if (strcmp(action, WEB_WLAN_STATION_SPOT_MODIFY) == 0) {
			tmp_wifi_profile = parse_spot_string(wifi_profile[i]);
			//kw 3
			if ((NULL != tmp_wifi_profile) && (NULL != nv_wifi_profile) && (strcmp(nv_wifi_profile->profile_name, tmp_wifi_profile->profile_name) == 0)) {
				current_profile_flag = i;
				web_wifi_profile = tmp_wifi_profile;
				slog(WIFI_PRINT, SLOG_DEBUG,"[%s]current_profile_flag=%d\n", __FILE__, i);
			} else {
				safe_free(tmp_wifi_profile);//cov
			}
		}
#endif
	}
	//kw 3
	for (i = 0; i < WEB_WLAN_STATION_SPOT_LIST_MAX; i++) {
		if (strcmp(action, WEB_WLAN_STATION_SPOT_MODIFY) == 0) {
			tmp_wifi_profile = parse_spot_string(wifi_profile[i]);
			if ((NULL != tmp_wifi_profile) && (NULL != nv_wifi_profile) && (strcmp(nv_wifi_profile->profile_name, tmp_wifi_profile->profile_name) == 0)) {
				current_profile_flag = i;
				web_wifi_profile = tmp_wifi_profile;
				slog(WIFI_PRINT, SLOG_DEBUG,"[%s]current_profile_flag=%d\n", __FILE__, i);
				break;
			} else {
				safe_free(tmp_wifi_profile);//cov
			}
		}
	}

	if (strcmp(action, WEB_WLAN_STATION_SPOT_MODIFY) == 0) {
		if (current_profile_flag <= -1) { //kw 3
			slog(WIFI_PRINT, SLOG_DEBUG,"[%s]error!current_profile_flag=%d\n", __FILE__, current_profile_flag);
			zte_write_result_to_web(wp, FAILURE);
			goto end;
		}
		if (web_wifi_profile->connect_status != nv_wifi_profile->connect_status) {
			slog(WIFI_PRINT, SLOG_DEBUG,"[%s]error!web_wifi_profile->connect_status=%d,nv_wifi_profile->connect_status=%d\n", __FILE__,
			       web_wifi_profile->connect_status, nv_wifi_profile->connect_status);
			zte_write_result_to_web(wp, PROCESSING);
			goto end;
		}
	}
	//ֵ
	(void)zte_web_read("wifi_profile_num", old_wifi_profile_num);
	slog(WIFI_PRINT, SLOG_DEBUG,"[%s]update spot profile, old_wifi_profile_num=%s\n", __FILE__, old_wifi_profile_num);

	//ϷԼ
	if (check_spot_value(action, wifi_profile_num, old_wifi_profile_num, wifi_update_profile, wifi_profile) == FALSE) {
		zte_write_result_to_web(wp, FAILURE);
		slog(WIFI_PRINT, SLOG_ERR,"[%s]update spot profile,para wrong so failed\n", __FILE__);
		goto end;
	}
	slog(WIFI_PRINT, SLOG_DEBUG,"[%s]update spot profile, action=%s\n", __FILE__, action);



	//ͷ֮ǰ洢ȵбڴ
	for (i = 0; i < WEB_WLAN_STATION_SPOT_LIST_MAX; i++) {
		safe_free(g_spot_list[i]);
	}

//ȵ ṹ棬ʹ
	for (i = 0; i < WEB_WLAN_STATION_SPOT_LIST_MAX; i++) {

		web_spot = parse_spot_string(wifi_profile[i]);

		if (NULL == web_spot)break;

		slog(WIFI_PRINT, SLOG_DEBUG,"[%s]web_spot->ssid=%s\n", __FILE__, web_spot->ssid);

		if (web_spot->from_provider == 1) // Ӫȵڵһλ
			insert_to_spot_list(1, web_spot);
		else if (strcmp(current_profile, web_spot->profile_name) == 0) // ǵǰӵȵ㣬ҪӪ̺
			insert_to_spot_list(2, web_spot);
		else
			insert_to_spot_list(3, web_spot); //ͨȵ㣬˳

	}

//ȵзֽ⣬浽Ӧṹ
	update_spot = parse_spot_string(wifi_update_profile);
	if (update_spot != NULL) {
		char *ptr = NULL;
		size_t  key_len = 0;
	
        slog(WIFI_PRINT, SLOG_DEBUG,"[%s]update_spot->ssid=%s\n", __FILE__, update_spot->ssid);
		//жwepǷΪ51316
		ptr = strstr (update_spot->encrypt_type, "WEP");
		if (ptr) {
			key_len = strnlen(update_spot->password,WIFI_STATION_SPOT_PASSWORD_LEN);
			if (key_len != 5 && key_len != 13 && key_len != 16) { //ascii
				slog(WIFI_PRINT, SLOG_ERR,"[%s]error!wep key len invalid\n", __FILE__);
				zte_write_result_to_web(wp, FAILURE);
				safe_free(update_spot);
				goto end;
			}
		}

	}

//༭ʱҪ鿴ǷҪEX AP 
	if (update_spot != NULL && strcmp(action, WEB_WLAN_STATION_SPOT_MODIFY) == 0) {
		if (strcmp(current_profile, update_spot->profile_name) == 0) {
			char keyid[8] = {0};
			sprintf(keyid, "%d", update_spot->keyID);
			zte_web_write("EX_SSID1", update_spot->ssid);
			zte_web_write("EX_AuthMode", update_spot->auth_mode);
			zte_web_write("EX_EncrypType", update_spot->encrypt_type);
			zte_web_write("EX_DefaultKeyID", keyid);
			zte_web_write("EX_WPAPSK1", update_spot->password);
			zte_web_write("EX_WEPKEY", update_spot->password);
			zte_web_write("EX_mac", update_spot->mac);
			slog(WIFI_PRINT, SLOG_DEBUG,"[%s]reset EX_SSID1=%s ,EX_AuthMode=%s ,EX_EncrypType=%s ,EX_DefaultKeyID =%d ,EX_WPAPSK1=EX_WEPKEY=[%s]=\n",
			       __FILE__, update_spot->ssid, update_spot->auth_mode, update_spot->encrypt_type, update_spot->keyID, update_spot->password);
		}
	}
//鿴ǷظͬSSID
	for (i = 0; i < WEB_WLAN_STATION_SPOT_LIST_MAX; i++) {
		if (g_spot_list[i] != NULL && update_spot != NULL) {
			if (strcmp(g_spot_list[i]->profile_name, update_spot->profile_name) != 0 &&
			    strcmp(g_spot_list[i]->ssid, update_spot->ssid) == 0 &&
			    strcmp(action, WEB_WLAN_STATION_SPOT_ADD) == 0) {
				safe_free(update_spot);
				slog(WIFI_PRINT, SLOG_DEBUG,"[%s]not allow add the same SSIDspot\n", __FUNCTION__);
				zte_write_result_to_web(wp, EXIST);
				goto end;

			} else if (
			    strcmp(g_spot_list[i]->profile_name, update_spot->profile_name) != 0 &&
			    strcmp(g_spot_list[i]->ssid, update_spot->ssid) == 0 &&
			    strcmp(action, WEB_WLAN_STATION_SPOT_MODIFY) == 0) {
				safe_free(update_spot);
				slog(WIFI_PRINT, SLOG_DEBUG,"[%s]not allow modify to the existed SSID from spot list!\n", __FUNCTION__);
				zte_write_result_to_web(wp, EXIST);
				goto end;
			}
		}
	}
	safe_free(update_spot);




	//󽫸µnvֵ  д
	(void)zte_web_write("wifi_profile_num", wifi_profile_num);

	for (i = 0; i < WEB_WLAN_STATION_SPOT_LIST_MAX; i++) {

		if (i == 0) {
			safe_strcpy(wifi_profile_nv_name, "wifi_profile", WEB_WLAN_STATION_PROFILE_NV_NAME_LEN);
		} else {
			memset(wifi_profile_nv_name, 0, WEB_WLAN_STATION_PROFILE_NV_NAME_LEN);
			snprintf(wifi_profile_nv_name, WEB_WLAN_STATION_PROFILE_NV_NAME_LEN, "wifi_profile%d", i);
		}
		memset(spot_string, 0, sizeof(spot_string));
		if (g_spot_list[i] != NULL) {
			snprintf(spot_string, WIFI_STATION_SPOT_LEN, "%s,%d,%d,%d,%s,%s,%s,%s,%d,%s", g_spot_list[i]->profile_name,
			         g_spot_list[i]->from_provider, g_spot_list[i]->connect_status, g_spot_list[i]->signal,
			         g_spot_list[i]->ssid, g_spot_list[i]->auth_mode, g_spot_list[i]->encrypt_type,
			         g_spot_list[i]->password, g_spot_list[i]->keyID, g_spot_list[i]->mac);
		}

		slog(WIFI_PRINT, SLOG_DEBUG,"[%s]wifi_profile_nv_name=%s, spot_string=%s\n", __FILE__, wifi_profile_nv_name, spot_string);
		(void)zte_web_write(wifi_profile_nv_name, spot_string);
	}

	strncpy(info.action, action,sizeof(info.action)-1);
	strncpy(info.spot, wifi_update_profile, sizeof(info.spot)-1);
	slog(WIFI_PRINT, SLOG_NORMAL,"[%s]xujian send MSG_CMD_WIFI_STATION_SPOT_UPDATE start  action =%s   \n", __FILE__, info.action);
	//zte_send_message(MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_SPOT_UPDATE, sizeof(info),(UCHAR*)info);
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_SPOT_UPDATE, sizeof(updateinfo_t), (UCHAR*)&info, 0);
	slog(WIFI_PRINT, SLOG_DEBUG,"[%s]xujian send MSG_CMD_WIFI_STATION_SPOT_UPDATE end\n", __FILE__);

	zte_write_result_to_web(wp, SUCCESS);

end:
	safe_free(nv_wifi_profile);
	safe_free(tmp_wifi_profile);
}

/**********************************************************************
* Function:        zte_wlan_station_connect
* Description:     to connect the wifi spot
* Input:           http info
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2015/03/09    V1.0        xujian          first version
**********************************************************************/
void zte_wlan_station_connect(webs_t wp)
{
	char_t *EX_SSID1 = NULL;
	char_t *EX_AuthMode = NULL;
	char_t *EX_EncrypType = NULL;
	char_t *EX_DefaultKeyID = NULL;
	char_t *EX_WEPKEY = NULL;
	char_t *EX_WPAPSK1 = NULL;
	char_t *EX_wifi_profile = NULL;
	char_t *EX_mac = NULL;
	char_t sta_ip_status[WEB_WLAN_STATION_IP_STATUS_LEN + 1] = {0};
	char_t wifi_sta_connection[WEB_WLAN_STATION_CONNECTION_LEN + 1] = {0};
	char wifi_cur_state[8] = {0};

	long ret = 0;

	EX_SSID1 = websGetVar(wp, T("EX_SSID1"), T(""));
	EX_AuthMode = websGetVar(wp, T("EX_AuthMode"), T(""));
	EX_EncrypType = websGetVar(wp, T("EX_EncrypType"), T(""));
	EX_DefaultKeyID = websGetVar(wp, T("EX_DefaultKeyID"), T(""));
	EX_WEPKEY = websGetVar(wp, T("EX_WEPKEY"), T(""));
	EX_WPAPSK1 = websGetVar(wp, T("EX_WPAPSK1"), T(""));
	EX_wifi_profile = websGetVar(wp, T("EX_wifi_profile"), T(""));
	EX_mac = websGetVar(wp, T("EX_mac"), T(""));
	slog(WIFI_PRINT, SLOG_NORMAL,"-----wlan_station_connect-----EX_AuthMode is %s\n", EX_AuthMode);
	//ϷԼ
	if (check_connect_value(EX_SSID1, EX_AuthMode, EX_EncrypType, EX_DefaultKeyID, EX_wifi_profile, EX_WEPKEY, EX_WPAPSK1) == FALSE) {
		zte_write_result_to_web(wp, FAILURE);
		slog(WIFI_PRINT, SLOG_ERR,"[%s]connect para check failed\n", __FILE__);

		return;
	}

	//WIFIȵ״̬,򷵻ش
	(void)zte_web_read("sta_ip_status", sta_ip_status);
	(void)zte_web_read("wifi_cur_state", wifi_cur_state);
	if (strcmp(sta_ip_status, WEB_WLAN_STATION_IP_STATUS_CONNECTING) == 0 ||
	    strcmp(sta_ip_status, WIFI_STATION_IP_STATUS_DHCPING) == 0) {
		//zte_write_result_to_web(wp,FAILURE);
		zte_write_result_to_web(wp, PROCESSING);
		slog(WIFI_PRINT, SLOG_ERR,"[%s]sta_ip_status connecting so failed\n", __FILE__);

		return;
	}

	//ܹرգ򷵻ش
	(void)zte_web_read("wifi_sta_connection", wifi_sta_connection);
	if (strcmp(wifi_cur_state, WIFI_CLOSED) == 0 || strcmp(wifi_sta_connection, "1") != 0) {
		zte_write_result_to_web(wp, FAILURE);
		slog(WIFI_PRINT, SLOG_ERR,"[%s]apsta closed , so failed\n", __FILE__);
		return;
	}

	//дNV
	(void)zte_web_write("EX_SSID1", EX_SSID1);
	(void)zte_web_write("EX_AuthMode", EX_AuthMode);
	(void)zte_web_write("EX_EncrypType", EX_EncrypType);
	(void)zte_web_write("EX_DefaultKeyID", EX_DefaultKeyID);
	(void)zte_web_write("EX_WEPKEY", EX_WEPKEY);
	(void)zte_web_write("EX_WPAPSK1", EX_WPAPSK1);
	(void)zte_web_write("EX_wifi_profile", EX_wifi_profile);
	(void)zte_web_write("EX_mac", EX_mac);


	//   resort_spot_list(2,EX_wifi_profile);

	//д״̬
//   (void)zte_web_write("sta_ip_status", WEB_WLAN_STATION_IP_STATUS_CONNECTING);

	zte_web_write("manual_d_wifi", "0");

	//ret=zte_send_message(MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_CONNECT, 0, NULL);
	ret = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_CONNECT, 0, NULL, 0);
	if (ret != 0) {
		slog(WIFI_PRINT, SLOG_ERR,"[%s]send MSG_CMD_WIFI_STATION_CONNECT failed\n", __FILE__);
	} else {
		slog(WIFI_PRINT, SLOG_NORMAL,"[%s]send MSG_CMD_WIFI_STATION_CONNECT success\n", __FILE__);
	}
	zte_write_result_to_web(wp, SUCCESS);
}

/**********************************************************************
* Function:        zte_wlan_station_disconnect
* Description:     to disconnect the wifi spot
* Input:           http info
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2015/03/09    V1.0        xujian          first version
**********************************************************************/
void zte_wlan_station_disconnect(webs_t wp)
{
	char_t wifi_sta_connection[WEB_WLAN_STATION_CONNECTION_LEN + 1] = {0};
	char_t sta_ip_status[WEB_WLAN_STATION_IP_STATUS_LEN + 1] = {0};
	long ret = 0;
	//ܹرգ򷵻ش
	(void)zte_web_read("wifi_sta_connection", wifi_sta_connection);
	if (strcmp(wifi_sta_connection, "1") != 0) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}


	//WIFIȵ״̬,򷵻ش
	(void)zte_web_read("sta_ip_status", sta_ip_status);
	if (strcmp(sta_ip_status, WEB_WLAN_STATION_IP_STATUS_CONNECTING) == 0 ||
	    strcmp(sta_ip_status, WIFI_STATION_IP_STATUS_DHCPING) == 0) {
		//zte_write_result_to_web(wp,FAILURE);
		zte_write_result_to_web(wp, PROCESSING);
		return;
	}

	zte_web_write("manual_d_wifi", "1");
	//zte_send_message(MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_DISCONNECT, 0, NULL);
	ret = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_DISCONNECT, 0, NULL, 0); //kw 3
	if (ret != 0) {
		slog(WIFI_PRINT, SLOG_ERR,"[%s]send MSG_CMD_WIFI_STATION_DISCONNECT failed\n", __FILE__);
	} else {
		slog(WIFI_PRINT, SLOG_NORMAL,"[%s]send MSG_CMD_WIFI_STATION_DISCONNECT success\n", __FILE__);
	}
	zte_write_result_to_web(wp, SUCCESS);
}

/**********************************************************************
* Function:        zte_wlan_station_refresh
* Description:     to scan the wifi spot
* Input:           http info
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2015/03/09    V1.0        xujian          first version
**********************************************************************/
void zte_wlan_station_refresh(webs_t wp)
{
	char_t wifi_sta_connection[WEB_WLAN_STATION_CONNECTION_LEN + 1] = {0};
	char_t sta_ip_status[WEB_WLAN_STATION_IP_STATUS_LEN + 1] = {0};
	long ret = 0;
	//ܹرգ򷵻ش
	(void)zte_web_read("wifi_sta_connection", wifi_sta_connection);
	if (strcmp(wifi_sta_connection, "1") != 0) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	//WIFIȵ״̬,򷵻ش
	(void)zte_web_read("sta_ip_status", sta_ip_status);
	if (strcmp(sta_ip_status, WEB_WLAN_STATION_IP_STATUS_CONNECTING) == 0 ||
	    strcmp(sta_ip_status, WIFI_STATION_IP_STATUS_DHCPING) == 0) {
		//zte_write_result_to_web(wp,FAILURE);
		zte_write_result_to_web(wp, PROCESSING);
		return;
	}

	(void)zte_web_write(NV_WIFI_SCAN_FINISH, "0");

	//zte_send_message(MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_SCAN, 0, NULL);
	ret = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_SCAN, 0, NULL, 0);
	if (ret != 0) {
		slog(WIFI_PRINT, SLOG_ERR,"[%s]send MSG_CMD_WIFI_STATION_SCAN failed\n", __FILE__);
	} else {
		slog(WIFI_PRINT, SLOG_NORMAL,"[%s]send MSG_CMD_WIFI_STATION_SCAN success\n", __FILE__);
	}

	zte_write_result_to_web(wp, SUCCESS);

}
