#ifndef ZTE_WEB_HTTPSHARE_H
#define ZTE_WEB_HTTPSHARE_H


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <string.h>
#include <dirent.h>
#include <sys/statvfs.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <utime.h>

#include <linux/stat.h>

#include "zte_web_interface.h"


#ifndef uint16
#define uint16 unsigned short
#endif

#ifndef uint32
#define uint32 unsigned long
#endif

#ifndef boolean
#define boolean unsigned char
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef WEBS_SOCKET_BUFSIZ
#define WEBS_SOCKET_BUFSIZ		4096			/* Bytes read from socket */
#endif

#define ZTE_HTTPSHARE_PATH_NAME_MAX_LEN  4096
#define ZTE_HTTPSHARE_FILE_NAME_MAX_LEN  1024
#define ZTE_HTTPSHARE_DEFAULT_LEN  100
#define ZTE_HTTPSHARE_MAX_NUM_SHOW_RECORD  10
#define ZTE_IP_ADDRESS_LENGTH                   40
#define FILE_BUFFER_LEN 65536

#define ZTE_HTTPSHARE_LEN_50  50
#define ZTE_HTTPSHARE_LEN_64  64
#define ZTE_HTTPSHARE_LEN_100 100
#define ZTE_HTTPSHARE_LEN_12  12
#define ZTE_HTTPSHARE_MAC_ADDR_MAX_LEN 18

//#define ZTE_HTTPSHARE_TIMEOUT  600
#define ZTE_PARSE_CGI_TAIL_LEN 100
#define MAX_LEN_FOR_SQL 1024

#define HTTPSHARE_BUF_NORMAL_LEN_MAX 255
#define  DECCHK( c ) ((c) >= '0' && (c) <= '9')


#define ZTE_FOLDER_STR "document"
#define ZTE_FILE_STR "file"
#define SD_CARD_USB_MOUNT_PATH    "/tmp/sd"
#define ZTE_CREATE_TABLE_DOWNLOAD_SQL   "CREATE TABLE IF NOT EXISTS download(id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,path TEXT)"

#define SD_CARD_PATH    "/etc_rw/config/mmc2"          // "/mmc2"
#define SD_CARD_PATH_PR    "/etc_rw/config"
#define ZTE_HTTPSHARE_DB_DIR   "/etc_rw/config/httpshare_db"      			//usr/httpshare_db 
#define ZTE_HTTPSHARE_DB_PATH  "/etc_rw/config/httpshare_db/httpshare.db"   //"/usr/httpshare_db/httpshare.db"  
#define TCARD_UPLOAD_FILE "/etc_rw/config/upload.data"

#define SD_CARD_PATH_NAN "/mmc2/mmc2/mmc2"
#define SD_CARD_SOFT_LINK "/usr/zte_web/web/mmc2"
#define USB_DEV_SDCARD_PATH  "/dev/mmcblk0p1"
#define USB_DEV_SDCARD_PATH_BACK  "/dev/mmcblk0"
#define SDCARD_EXIST_FLAGE_FILE  "/sys/class/android_usb/android0/tcard"
#define NO_SDCARD "no_sdcad"
#define ZTE_HTTPSHARE_TIME "path_SD_CARD_time_unix"

#define SET_MODE_SHELL "./etc/init.d/mmchost"
#define SET_MODE_USB "usb"
#define SET_MODE_HTTP_SHARE "httpshare"

#define USB_MODE "usb_mode"
#define HTTP_SHARE_MODE "http_share_mode"
#define ZTE_HTTPSHARE_DB_NAME "httpshare"

#define TCARD_SIZE_FILE "/proc/proc_sd/size"

//httpshare password
#define HTTPSHARE_LOGIN_SUCCESS   "0"                         // "share_login_ok"
#define HTTPSHARE_LOGIN_FAIL          "1"                        //"share_login_failure"
#define HTTPSHARE_LOGIN_CHECK_FAIL    "2"                 //"share_login_check_fail"
#define HTTPSHARE_LOGIN_BAD_PASSWORD   "3"          // "share_login_bad_password"
#define HTTPSHARE_LOGIN_ALREADY_LOGIN     "4"         //"share_login_already"
#define HTTPSHARE_LOGIN_LOGIN_BEFORE  "5"             //"share_login_before"


#define HTTPSHARE_LOGIN_TIMEOK           "6"              // "share_timeok"
#define HTTPSHARE_LOGIN_TIMEOUT               "7"          //"share_timeout"
#define HTTPSHARE_LOGIN_TIMEFAIL  "8"                   //"share_timefail"


#define ZTE_CREATE_TABLE_HTTPSHARE_SQL   "CREATE TABLE IF NOT EXISTS httpshare(id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,ip TEXT,path TEXT)"

#define HTTPSHARE_PATH_INLEGAL "/mmc2/.."    // user document path

typedef enum {
	ZTE_HTTPSHARE_DB_OK = 0,
	ZTE_HTTPSHARE_DB_ERROR_INVAILD_PTR = 100,
	ZTE_HTTPSHARE_DB_ERROR_NOT_OPEN_DB,
	ZTE_HTTPSHARE_DB_ERROR_FULL,
	ZTE_HTTPSHARE_DB_ERROR = -1
} zte_httpshare_db_result_e_type;


typedef enum {
	ZTE_HTTPSHARE_FAILURE = -1,
	ZTE_HTTPSHARE_SUCCESS = 0,
	ZTE_HTTPSHARE_NOT_SUPPORT = 1,
	ZTE_HTTPSHARE_MAX
} zte_httpshare_return_e_type;


typedef enum {
	ZTE_CGI_PARSE_FILE_HEAD_BEGIN = 0,
	ZTE_CGI_PARSE_FINDE_HEAD_FIRST = 1, //13
	ZTE_CGI_PARSE_FINDE_HEAD_SEC = 2,       //10
	ZTE_CGI_PARSE_FINDE_HEAD_THIRD = 3,     //13
	ZTE_CGI_PARSE_FINDE_HEAD_FOUTH = 4,     //10
	ZTE_CGI_PARSE_FINDE_FILE_HEAD = 5,     //10
} zte_cgi_parse_file_head_type_e;


typedef enum {
	ZTE_CGI_PARSE_FILE_TAIL_ADD_BEGIN = 0,
	ZTE_CGI_PARSE_FINDE_TAIL_ADD_FIRST = 1, //13
	ZTE_CGI_PARSE_FINDE_TAIL_ADD_SEC = 2,       //10
	ZTE_CGI_PARSE_FINDE_TAIL_ADD_THIRD = 3,     //13
	ZTE_CGI_PARSE_FINDE_TAIL_ADD_FOUTH = 4,     //10
	ZTE_CGI_PARSE_FINDE_FILE_TAIL_ADD = 5,     //10
} zte_cgi_parse_file_tail_addres_type_e;




typedef enum {
	ZTE_CGI_PARSE_FILE_TAIL_BEGIN = 0,
	ZTE_CGI_PARSE_FINDE_TAIL_IN_FILE = 1,
	ZTE_CGI_PARSE_FINDE_TAIL_IN_POOL = 2,
	ZTE_CGI_PARSE_FINDE_TAIL_PROCESS = 3,


} zte_cgi_parse_file_tail_type_e;


typedef enum {
	ZTE_CGI_WRITE_THE_FIRST_DATA = 0,
	ZTE_CGI_WRITE_THE_SEC_DATA = 1,
} zte_cgi_write_e;


struct user_upload_infor {
	char file_tail_pool[ZTE_PARSE_CGI_TAIL_LEN];
	int file_tail_pool_len;
	int file_tail_len;
	int file_head_len;
	uint32 file_raw_size;
	zte_cgi_parse_file_head_type_e    file_head;
	zte_cgi_parse_file_tail_type_e	file_tail;
	zte_cgi_parse_file_tail_addres_type_e   file_tail_addres;
	zte_cgi_write_e    data_no;
};

typedef struct user_upload_infor  USER_UPLOAD_INFOR;

typedef struct user_common_infor_type {
	char address[ZTE_IP_ADDRESS_LENGTH];				/* current user ip address of user */
	char file_name[ZTE_HTTPSHARE_FILE_NAME_MAX_LEN];				/* curretn user user name for specific if it is the same user else reset infor. */
	char path[ZTE_HTTPSHARE_FILE_NAME_MAX_LEN];
	USER_UPLOAD_INFOR infor;
	int requst_sid;
	int card_full;
	int cnt;
	//int unixTime;
	char UnixYMDTime[ZTE_IP_ADDRESS_LENGTH];
	//struct user_common_infor_type *next;
} USER_COMMON_INFOR;


typedef struct {
	int id;
	char fileName[ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1];
	char attribute[ZTE_HTTPSHARE_DEFAULT_LEN];
	uint32 size;
	char lastUpdateTime[ZTE_HTTPSHARE_DEFAULT_LEN];

} zte_file_record_s_type;


typedef enum {
	ZTE_ERROR_MODE = -1,
	ZTE_HTTPSHARE_USB = 0,
	ZTE_HTTPSHARE_HTTPSHARE = 1,
	ZTE_RESERVE_MODE
} zte_httpshare_current_mode_type;

typedef   struct {
	char *dev_path;
} httpshare_usb_mmc_dev;

typedef enum {
	ZTE_CHANGE_MODE_ERROR = 0,
	ZTE_CHANGE_MODE_OK
} zte_httpshare_change_mode_type;


/*ûģʽ³USB   start*/

#define ZTE_GET_USB_INFO_DEV 	"/dev/usbNVDev"
#define ZTE_AT_PROXY4_DEV 	"/dev/ctrm_atproxy4"

static int g_get_usb_info_fd = -1;
static int g_at_proxy4_fd = -1;

#define USBNV_IOCTL_W_CFGCDROMCHARGER	0x16

typedef struct _T_REF_NV_USB_CFG {
	UINT16 pid;
	UINT16 vid;
	UINT8 f_Tcard;
	UINT8 f_Cdrom;
	UINT8 f_AtExt;
	UINT8 f_AtExt2;
	CHAR Sn[64];
} T_REF_NV_USB_CFG;

/*ûģʽ³USB   end*/

USER_COMMON_INFOR* zte_process_user_auth(webs_t wp);

//record a defined count file record to show user
extern zte_file_record_s_type httpshare_file_record[ZTE_HTTPSHARE_MAX_NUM_SHOW_RECORD];
extern int zte_httpshare_change_current_mode(zte_httpshare_current_mode_type curr_mode);
//extern void zte_httpshare_call_system(char * cmd);

int save_upload_info_to_file(const char *file, char *name);
int read_upload_info_from_file(const char *file, char *name);
#endif
