/**
 * @file at_register.h 
 * @brief at_ctlڲע¼Ľӿڣ漰ͻˡת¼עӿ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */
#ifndef __AT_REGISTER_H__
#define __AT_REGISTER_H__

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "at_com.h"
#include "at_context.h"

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
//תATOKӦжƴһΪNULL
typedef int (*fwd_ok_func)(char *at_paras, struct at_context *context);

//תATOKӦжƴһΪNULLΪļ
typedef int (*fwd_err_func)(char *at_paras, struct at_context *context);

//req_actڲв飬װATӦַظڲװӦATдATͨAT_END 
typedef int(*fwd_req_func)( char *at_paras,int at_fd,struct at_context *context);


//APPϢATװڲʧܻظҪںڲsend_rsp_msgӿڽӦϢͣNULL
typedef char * (*clt_req_func)(void *msg, void *context);

//ͻյOKӦĴص 
typedef int (*clt_ok_func)(char *at_paras, void *context, void **next_req, int *next_len);


//ͻյERRӦĴص
typedef int (*clt_err_func)(char *at_paras, void *context, void **next_req, int *next_len);


//ATͻ˴AT¼ṹ壬յӦʱĴ
struct clt_ops_t
{
    struct list_head list;
	char at_cmd_prefix[AT_CMD_PREFIX];//ATǰ׺ַڱƥ䣬funcָ븳ֵ
	clt_ok_func  ok_act;//յOKĽһжϷ֧յĽֵһATķ
	clt_err_func  err_act;//յerrĽһһΪͷŵǰat_context
};

//DEMOûοĿͻ˽ṹ壬һһʽ
struct app_clt_ops_t
{
    struct list_head list;
    int  position;           //ָʾͻ˴ĸλõͨ
    int  req_msg_id;  //ͻAPP͵Ϣ
    int  rsp_msg_id;  //ϱͻAPPϢID
    clt_req_func    req_act;//APPϢATװڲϢ쳣ظӦϢҪںڲظӦϢAT룬NULL
};

//תATĴṹ壬Уfwd_req_funcתʱݽкϷԼ飬ֲϷʱظerr֪ͨԷ̡ 
struct fwd_ops_t
{
    struct list_head list;
	char at_cmd_prefix[AT_CMD_PREFIX];//ATǰ׺ַڱƥ䣬funcָ븳ֵ
	fwd_req_func 	req_act;//תĶƴPDPأƽӿڲֱӻظӦת
    fwd_ok_func  ok_act;//յOKĶƴһPSϢĸ£׼ʹ
	fwd_err_func  err_act;//յerrĶƴ,һPSϢĸ£׼ʹ
};

//ϱȱʡȫ飬µps_at_infoȫֽṹУѯĽ 
struct inform_ops_t
{
    struct list_head list;
    char at_cmd_prefix[AT_CMD_PREFIX];//ϱǰ׺
    inform_act_func  inform_act;//ԸýյATĴԱشAT_END,ҪϢעģid򷵻AT_CONTINUE
};


//мҪat_ctl¸ʽ 
struct formatinform_ops_t
{
    struct list_head list;
    char at_cmd_prefix[AT_CMD_PREFIX];
    format_inform_func  inform_act;
};


struct ser_ops_t2
{
    struct list_head list;
    struct at_context  *context;		//˴ڻģԱӦʱҵӦfuncдͨ
    char at_cmd_prefix[AT_CMD_PREFIX];  //ƥATؼ
    int  module_id;						//APPӦģIDϢϱͻοעķΪⲿģID
    int  req_msg_id;					//req_rcv_actصϱϢԸϢID͸ӦAPP˽
    int  rsp_msg_id;					//ӦAPP͵ӦϢat_ctlϢװӦAT͸Զ˿ͻ
	ser_req_func2 req_rcv_act;      		//ԽյԶĴӿڣԱشװӦģظñĵڴָⲿú봴ģ򣬴ĺռͨ뵽ȴӦУϢsocketӦý̴ȴӦϢװӦAT͸ԶˣͷĺATͨ
    app_rsp_proc   rsp_act;				//ڽյⲿģĻظϢ󣬸ϢװatӦмϱatмϱatok atװһ𣬲ظװĵڴָⲿú
};


struct ser_ops_t
{
    struct list_head list;
    char at_cmd_prefix[AT_CMD_PREFIX];  //ƥATؼ
    int  module_id;						//APPӦģIDϢϱͻοעķΪⲿģID
	ser_req_func req_rcv_act;      	//ԽյԶĴӿڣԱشװӦģظñĵڴָⲿú봴ģ򣬴ĺռͨ,תӦãɿͻӦý첽ʽͨŴɿͻʵ
};

//ATַݵres_msgУδAT﷨˫Լ򷵻AT_ENDɿܽERR,򷵻AT_CONTINUE
typedef int (*parse_at2msg_func)(char *at_paras,void * res_msg, unsigned short *res_msglen);

//ⲿչATӦATװεϢṹݽװΪ룬мúΪNULL
typedef int (*parse_msg2at_func)(void *rspmsg, void **ret);

struct extat_ser_ops_t
{
    struct list_head list;
    int  req_msg_id;  					//ͻAPP͵Ϣ
    char at_cmd_prefix[AT_CMD_PREFIX];  //ƥչATؼ
    parse_at2msg_func    parse_act;		//ⲿչATΪƽ̨Ϣṹ
    parse_msg2at_func 	 rsp_proc;      //ƽ̨ ӦϢṹװΪӦAT͸ⲿMCU
};

struct inform_ops_t0
{
    struct list_head list;
    char at_cmd_prefix[AT_CMD_PREFIX];//ϱǰ׺
    int  module_id;						//APPӦģIDϱϢϱ
    int  req_msg_id;					//ϱķصϱϢԸϢID͸ӦAPP˽
};

struct ser_ops_t0
{
    struct list_head list;
    struct at_context  *context;		//˴ڻģԱӦʱҵӦfuncдͨ
    char at_cmd_prefix[AT_CMD_PREFIX];  //ƥATؼ
    int  module_id;						//APPӦģIDϢϱͻοעķΪⲿģID
    int  req_msg_id;					//req_rcv_actصϱϢԸϢID͸ӦAPP˽
    int  rsp_msg_id;					//ӦAPP͵ӦϢat_ctlϢװӦAT͸Զ˿ͻ
};

/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
/* ڿעеAT¼*/
extern struct list_head g_clt_list;
/* ڿעеתAT¼ҪPDP*/
extern struct list_head g_fwd_list;
/* עеϱ/мϱAT¼*/
extern struct list_head g_inform_list;

/* עҪʽмϱAT¼ */
extern struct list_head g_formatinform_list;

/* ڿעеķ˾AT¼ϲ㼰ͻƣ׼PSЭջ*/
extern struct list_head g_ser_list2;

extern struct list_head g_ser_list;

/* ͻע*/
extern struct list_head g_appclt_list;
/* ˼ͨѶϢ*/
extern struct list_head g_socmsg_list;
/* չAT*/
extern struct list_head g_modem_extat_list;

extern struct list_head g_inform_list0;
extern struct list_head g_ser_list0;
struct ser_ops_t0 *find_ser_by_msg_modid0(int  rsp_msg_id, int module_id);
int  register_inform_func0(char *at_cmd_prefix,int  module_id, int  req_msg_id);
int  unregister_inform_func0(char *at_cmd_prefix, int  req_msg_id);
int  register_serv_func0(char *at_cmd_prefix,int  module_id,int  req_msg_id,int  rsp_msg_id);
int  unregister_serv_func0(char *at_cmd_prefix, int  req_msg_id);
/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/

/*APPIDҶӦĲڵ*/
struct app_clt_ops_t *find_extclt_by_msg(int msg_id);



/*ݷעatǰ׺ҶӦڵ*/
struct ser_ops_t2 *find_ser_by_msg(int  rsp_msg_id);

/* ݿͻatǰ׺ҶӦڵ*/
struct clt_ops_t* find_req_by_prefix(void *at_cmd_prefix, int prefix_len);

/*תatǰ׺ҶӦڵ*/
struct fwd_ops_t* find_fwd_by_prefix(void *at_cmd_prefix, int prefix_len);

/*ϱ/мatǰ׺ҶӦڵ*/
struct inform_ops_t* find_inform_by_prefix(void *at_cmd_prefix, int prefix_len);


/*ͨOKרͨýϱ׼ڲѯදOK
          װϢresult
 
 * @note  Ӧʹregister_psclt_funcregister_serv_funcregister_extclt_funcעʱ
          Ľ룬ӦҪעܴýrsp_msg_idģrsp_msg_idNULL
 * @note  result 0:OK;1:ERROR
 */
int rsp_common_ok(char *at_paras,struct at_context *context,void **next_req,int *next_len);


/**ͨERRרͨýϱ׼ڲѯදERROR */
int rsp_common_err(char *at_paras,struct at_context *context,void **next_req,int *next_len);


/*ѯදOK     
ش룬أעʱΪNULL
 */
int query_common_ok(char *at_paras,struct at_context *context,void **next_req,int *next_len);


/* ѯදERROR */
int query_common_err(char *at_paras,struct at_context *context,void **next_req,int *next_len);

/**
 * @brief PSصϲͻAPPעops, ⲿģͨչATPS
          ڶAṬڼһֱ 
 * @param at_cmd_prefix չATǰ׺
 * @param parse_proc    չATreq_msg_idӦϢṹ,ûвúΪNULL
 * @param req_msg_id    ͻAPP͵Ϣ
 * @param rsp_msg_id    ҪظͻAPPӦϢ
 * @param req_proc      ϢתӦAT
 * @return 
 * @note  ڵӵg_appclt_listչatǰ׺Ϊգӵg_modem_extat_list
 * @note  req_msg_idûжӦչATǰ
 * @warning 
 */
int  register_psclt_func(int  req_msg_id,int rsp_msg_id,clt_req_func req_proc);

/**
 * @brief PSصϲͻAPPעops, ⲿģͨչATPS
          ڶAṬڼһֱ 
 * @param at_cmd_prefix չATǰ׺
 * @param parse_proc    չATreq_msg_idӦϢṹ,ûвúΪNULL
 * @param req_msg_id    ͻAPP͵Ϣ
 * @param rsp_msg_id    ҪظͻAPPӦϢ
 * @param req_proc      ϢתӦAT
 * @return 
 * @note  ڵӵg_appclt_listչatǰ׺Ϊգӵg_modem_extat_list
 * @note  req_msg_idûжӦչATǰ
 * @warning 
 */
int  reg_modem_opencpu_extat(char *at_cmd_prefix, int  req_msg_id,parse_at2msg_func parse_proc, parse_msg2at_func rsp_proc);

/**
 * @brief ڿͻעᣬpsصatͷpsصչatڲ
 * @param at_cmd_prefix ATǰ׺
 * @param ok_act  ӦOK
 * @param err_act ӦERROR
 * @return 
 * @note  ڵӵg_clt_list
 * @warning 
 */
int  register_clt_func(char *at_cmd_prefix,clt_ok_func  ok_act,clt_err_func  err_act);
/**
 * @brief ڿעеתAT¼ҪPDPء
 * @param at_cmd_prefix ATǰ׺
 * @param req_act ת¼
 * @param ok_act  ӦOK
 * @param err_act ӦERROR
 * @return 
 * @note  ڵӵg_fwd_list
 * @warning 
 */
int  register_fwd_func(char *at_cmd_prefix,fwd_req_func req_act,fwd_ok_func  ok_act,fwd_err_func  err_act);


/**
 * @brief ⲿͷǵչATעᣬϲ㼰ͻƣ׼PSЭջ
 * @param position	    ATķNEAR_PS
 * @param at_cmd_prefix	ATǰ׺ָ
 * @param req_msg_id     Ϣid
 * @param rsp_msg_id     ӦϢid
 * @param req_proc       װͷAT
 * @param ok_act         յATӦOKĴ
 * @param err_act        յATӦERRORĴ
 * @param inform_act     յATмϱĴ
 * @return intͽ
 * @retval ɹ 0, ʧ -1
 */
int  register_extclt_func(int position, char *at_cmd_prefix, int  req_msg_id, int rsp_msg_id, clt_req_func req_proc, clt_ok_func  ok_act, clt_err_func  err_act, inform_act_func inform_act);


#endif
