#ifndef _HOTPLUG_H_
#define _HOTPLUG_H_

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <pthread.h>
#include <errno.h>
#include <signal.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <syslog.h>
#include <sys/klog.h>
#include <assert.h>
#include <linux/netlink.h>
#include <rtc_timer.h>
#include "message.h"
#include "softap_api.h"

#define UEVENT_BUFFER_SIZE  2048*3//zte_drv_usb_ctrl.h6KҪŻջ

//#define MSG_ID_HOTPLUG    1024


/*UEVENT¼*/
enum kobject_action {
	KOBJ_ADD,
	KOBJ_REMOVE,
	KOBJ_CHANGE,
	KOBJ_MOVE,
	KOBJ_ONLINE,
	KOBJ_OFFLINE,
	KOBJ_MAX
};


/*豸ֽͣʹ*/
enum device_type {
	DEVICE_TYPE_APP_RTC,		   /*ӦRTC*/
	DEVICE_TYPE_APP_WIFI,		   /*ӦWIFI*/
	DEVICE_TYPE_APP_SDCARD, 	   /*ӦSD*/
	DEVICE_TYPE_APP_MMI_BATTERY,   /*ӦMMI BATTERY*/
	DEVICE_TYPE_APP_MMI_OFFCHG,   /*ӦMMIػ*/

	DEVICE_TYPE_USB,     /*USB*/
	DEVICE_TYPE_RJ45,    /*rj45*/
	DEV_TYPE_USB,              /*USB*/
    DEV_TYPE_SDCARD,           /*sdcard*/
    DEV_TYPE_VIRTUAL_SDCARD,   /*T*/
    DEV_TYPE_SERIAL,           /*SERIAL*/
    DEV_TYPE_MBIM,
	DEVICE_TYPE_MAX,
};

/*usbϢ¼*/
enum usb_event
{
    USB_EVENT_CHARGE = 0,
    USB_EVENT_DEVICE,
    USB_EVENT_CDROMOBJ,
    USB_EVENT_USER,
    USB_EVENT_DEBUG,
    USB_EVENT_FACTORY,
    USB_EVENT_AMT,
    USB_EVENT_EYE_DIAGRAM,
    USB_EVENT_RESET,
    USB_EVENT_MAX,
};

/*CMUXϢ¼*/
enum serial_event
{
    SERIAL_EVENT_GSMTTY1 = 0,
    SERIAL_EVENT_GSMTTY2,
    SERIAL_EVENT_GSMTTY3,
    SERIAL_EVENT_TTYGS0,
    SERIAL_EVENT_TTYGS1,
    SERIAL_EVENT_MAX,
};


/*ȰβϢ*/
struct hotplug_event {
	int type;        /*豸*/
	int action;      /*ͣӦkobject_action*/

	union {
		struct net_dev {
			char dev_name[NETIF_NAME_LEN];
			int dev_id;
		} netdev;
		struct usb_dev
        {
            int event_type;
        } usb;
		struct serial_dev
        {
            int event_type;
			char dev_name[20];
        } serial;
	} u;
};

extern char usbdev_name[1024];

typedef int (*hotplug_parse_func)(const char *msg, int msglen, struct hotplug_event *event);
typedef int (*hotplug_proc_func)(struct hotplug_event *event);

int hotplug_parse_register(int device_type, hotplug_parse_func func);

int hotplug_proc_register(int device_type, hotplug_proc_func func);

void char_replace(char*buf, int count, char orig_char, char replace_char);

void netdev_hotplug_init();

void drv_hotplug_init(void);

#endif

