/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_timer.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMI ʱ
*        
*  汾      V1.0
*    2014-6-20
*  ˵  
*
*******************************************************************************/
#include "mmi_common.h"
#include "mmi_lcd.h"

#define MMI_LCD_SMS_TIME      							91
#define MMI_LCD_BATTERY_TIME      						92
#define MMI_LCD_POWER_ON_OFF_TIME      					93
#define MMI_LCD_POWER_ON_LAST_FRAME_TIME      			94
#define MMI_LCD_SCROLL_TIME     						95
#define MMI_LED_TRAFFIC_WARN_TIME_1000					96
#define MMI_LED_TRAFFIC_WARN_TIME_100					97
#define MMI_LED_TRAFFIC_WARN_TIME_4000					98

#define MMI_LCD_SMS_TIMER_PERIOD      					500
#define MMI_LCD_BATTERY_TIMER_PERIOD      				500
#define MMI_LCD_POWER_ON_OFF_TIMER_PERIOD      			100
#define MMI_LCD_POWER_ON_LAST_FRAME_TIMER_PERIOD      	300
#define MMI_LCD_SCROLL_TIMER_PERIOD      				600
#define MMI_LED_TRAFFIC_WARN_TIMER_1000 				1000
#define MMI_LED_TRAFFIC_WARN_TIMER_100 					100
#define MMI_LED_TRAFFIC_WARN_TIMER_4000 				4000


/*****************************************************************************
 ȫֱ
******************************************************************************/

/*****************************************************************************
 ñ
******************************************************************************/
extern UINT32 g_mmi_poweroff_turnon_flag;

/*****************************************************************************
 
******************************************************************************/
/*charger or null battery timer*/
static BOOL g_mmi_lcd_battery_timer_state = FALSE;
/*scroll ssid   timer*/
static BOOL g_mmi_lcd_scrollssid_timer_state = FALSE;

extern sem_t g_mmi_traffic_warn_sem_id;

/**********************************************************************************
:澯˫ƶʱ
***********************************************************************************/
VOID * mmi_ledon_trafficwarn_timer_callback(VOID *flag)
{
	slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_ledon_trafficwarn_timer_callback flag:%d\n", (SINT32)flag);
	if (flag == 1) {
		mmi_set_traffic_warn_flag(FALSE);
		mmi_set_update_flag(MMI_TASK_TRAFFIC);
	} else {
		sem_post(&g_mmi_traffic_warn_sem_id);
	}
	return NULL;
}

VOID mmi_startLedTrafficWarnTimer(SINT32 time, SINT32 flag)
{
	slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_startLedTrafficWarnTimer time:%d flag:%d\n", time, flag);
	if (time == 4000 && flag == 1) {
		int ret1 = -1;
		ret1 = sc_timer_create(MMI_LED_TRAFFIC_WARN_TIME_4000, TIMER_FLAG_ONCE, MMI_LED_TRAFFIC_WARN_TIMER_4000, &mmi_ledon_trafficwarn_timer_callback, (void *)1);
		if (ret1 != 0) {
			slog(MMI_PRINT, SLOG_ERR, "MMI DBB1 FAILED,cause=%d\n", ret1);
		}
	} else {
		if (time == 100) {
			int ret2 = -1;
			ret2 = sc_timer_create(MMI_LED_TRAFFIC_WARN_TIME_100, TIMER_FLAG_ONCE, MMI_LED_TRAFFIC_WARN_TIMER_100, &mmi_ledon_trafficwarn_timer_callback, (void *)0);
			if (ret2 != 0) {
				slog(MMI_PRINT, SLOG_ERR, "MMI DBB2 FAILED,cause=%d\n", ret2);
			}
		} else {
			int ret3 = -1;
			ret3 = sc_timer_create(MMI_LED_TRAFFIC_WARN_TIME_1000, TIMER_FLAG_ONCE, MMI_LED_TRAFFIC_WARN_TIMER_1000, &mmi_ledon_trafficwarn_timer_callback, (void *)0);
			if (ret3 != 0) {
				slog(MMI_PRINT, SLOG_ERR, "MMI DBB3 FAILED,cause=%d\n", ret3);
			}
		}
	}
}

VOID mmi_stopLedTrafficWarnTimer()
{
	sc_timer_delete(MMI_LED_TRAFFIC_WARN_TIME_100);
	sc_timer_delete(MMI_LED_TRAFFIC_WARN_TIME_1000);
	sc_timer_delete(MMI_LED_TRAFFIC_WARN_TIME_4000);
}

#ifndef DISABLE_LCD
/**********************************************************************************
:ȡϢʱص
***********************************************************************************/
static VOID * mmi_lcd_sms_timer_callback(VOID *arg)
{
	slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_lcd_sms_timer_callback!!!\n");
	mmi_set_update_flag(MMI_TASK_SMS);
	return NULL;
}
VOID mmi_startLcdSmsTimer()
{
	int ret = -1;
	ret = sc_timer_create(MMI_LCD_SMS_TIME, TIMER_FLAG_ONCE, MMI_LCD_SMS_TIMER_PERIOD, &mmi_lcd_sms_timer_callback, NULL);
	if (ret != 0) {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_startLcdSmsTimer FAILED,cause=%d\n", ret);
	}

}
VOID mmi_stopLcdSmsTimer()
{
	sc_timer_delete(MMI_LCD_SMS_TIME);
}

extern pthread_mutex_t g_mmi_poweron_mutex;
static VOID * mmi_lcd_battery_timer_callback(SINT32 task)
{
	//slog(MMI_PRINT,SLOG_DEBUG,"MMI mmi_lcd_battery_timer_callback!!!\n");
	mmi_getMutex(&g_mmi_poweron_mutex);
	if (!g_mmi_poweroff_turnon_flag) {
		mmi_putMutex(&g_mmi_poweron_mutex);
		mmi_set_update_flag((E_zMmi_Task)task);
	}else
		mmi_putMutex(&g_mmi_poweron_mutex);
	g_mmi_lcd_battery_timer_state = FALSE;
	return NULL;
}
VOID mmi_startLcdBatteryTimer(SINT32 task)
{
	if (g_mmi_lcd_battery_timer_state == FALSE) {
		int ret = -1;
		ret = sc_timer_create(MMI_LCD_BATTERY_TIME, TIMER_FLAG_ONCE, MMI_LCD_BATTERY_TIMER_PERIOD, &mmi_lcd_battery_timer_callback, (void *)task);
		if (ret != 0) {
			slog(MMI_PRINT, SLOG_ERR, "MMI mmi_startLcdBatteryTimer FAILED,cause=%d\n", ret);
		}
		g_mmi_lcd_battery_timer_state = TRUE;
	}


}
VOID mmi_stopLcdBatteryTimer()
{
	if (g_mmi_lcd_battery_timer_state) {
		sc_timer_delete(MMI_LCD_BATTERY_TIME);
		g_mmi_lcd_battery_timer_state = FALSE;
	}
}

static VOID * mmi_lcd_poweronoff_timer_callback(VOID *arg)
{
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_lcd_poweronoff_timer_callback CB!!!\n");
	mmi_changePowerOnOffFrame();
	InvalidateRect(mmi_getMainWnd(), NULL, FALSE);
	return NULL;
}
VOID mmi_startLcdPowerOnOffTimer()
{
	int ret = -1;
	ret = sc_timer_create(MMI_LCD_POWER_ON_OFF_TIME, TIMER_FLAG_ONCE, MMI_LCD_POWER_ON_OFF_TIMER_PERIOD, &mmi_lcd_poweronoff_timer_callback, NULL);
	if (ret != 0) {
		slog(MMI_PRINT, SLOG_ERR, " MMI mmi_startLcdPowerOnOffTimer FAILED,cause=%d!!\n", ret);
	}
}
VOID mmi_startLcdPowerOnOffTextFrameTimer()
{

	int ret = -1;
	ret = sc_timer_create(MMI_LCD_POWER_ON_LAST_FRAME_TIME, TIMER_FLAG_ONCE, MMI_LCD_POWER_ON_LAST_FRAME_TIMER_PERIOD, &mmi_lcd_poweronoff_timer_callback, NULL);
	if (ret != 0) {
		slog(MMI_PRINT, SLOG_ERR, " MMI mmi_startLcdPowerOnOffTextFrameTimer FAILED,cause=%d!!\n", ret);
	}
}
VOID mmi_stopLcdPowerOnOffTimer()
{

	sc_timer_delete(MMI_LCD_POWER_ON_OFF_TIME);

}


/*ʾSSID WifiKeyʱ*/
static VOID * mmi_lcd_scrollssid_timer_callback(VOID *func)
{
	slog(MMI_PRINT, SLOG_NORMAL, "MMI =========mmi_lcd_scrollssid_timer_callback===========!!!\n");
	if (func != 0) {
		((SCROLLED_TIMER_CALLBACK)func)();
	}
	g_mmi_lcd_scrollssid_timer_state = FALSE;
	return NULL;
}

VOID mmi_stopLcdShowScrollSSIDTimer()
{
	if (g_mmi_lcd_scrollssid_timer_state) {
		sc_timer_delete(MMI_LCD_SCROLL_TIME);
		g_mmi_lcd_scrollssid_timer_state = FALSE;
	}
}
VOID mmi_startLcdShowScrollSSIDTimer(SINT32 func)
{
	if (!g_mmi_lcd_scrollssid_timer_state) {
		int ret = -1;
		ret = sc_timer_create(MMI_LCD_SCROLL_TIME, TIMER_FLAG_ONCE, MMI_LCD_SCROLL_TIMER_PERIOD, &mmi_lcd_scrollssid_timer_callback, (void *)func);
		if (ret != 0) {
			slog(MMI_PRINT, SLOG_ERR, " MMI mmi_startLcdShowScrollSSIDTimer FAILED,cause=%d!!\n", ret);
		}
		g_mmi_lcd_scrollssid_timer_state = TRUE;
	}
}
#endif

