/**
 * @file mnet_whitelist.c
 * @brief at_ctlCAPAPʡڰӿ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#ifdef MULTI_CPU

#include "at_context.h"
#include "at_register.h"
#include "recv_thread.h"
#include "ps_normal.h"
#include "softap_api.h"
#include "ref_nv_def.h"
#include "mnet_whitelist.h"

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/
/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/

extern char PsmIndAtCmdPrefix[AT_CMD_MAX];
#define DEFAULT_VALUE ('a'-'A')

/*******************************************************************************
 *                      Local function implementations                         *
 ******************************************************************************/

typedef struct{
	int result;
}mnet_whitelist_common_res_t;

int cmdtolower(char* str)
{
	if(NULL == str || 0 == strlen(str))
		return 1;
	int i=0, ch1=0, len = strlen(str);
	char* p = str;
	while(i<len){
		if((ch1 = *(unsigned char *)p) >= 'A' && (ch1 <= 'Z'))
		{
			str[i] += DEFAULT_VALUE;
		}
		p++;
		i++;
	}
	return 0;
}

int mnet_whitelist_add(char* cmd)
{	
	char* ptr=NULL;
	int pos_start=0;
	int len = 0;
	
	if(0 == strlen(PsmIndAtCmdPrefix)){
		if(strlen(cmd) > sizeof(PsmIndAtCmdPrefix)){
			at_print(AT_ERR,"mnet_whitelist_add cmd too long\n");
			return MNET_WHITELIST_OPER_CMD_TOO_LONG;
		}
		sprintf(PsmIndAtCmdPrefix, "%s", cmd);
		return MNET_WHITELIST_OPER_SUCC;
	}else if(NULL != at_strstr(PsmIndAtCmdPrefix, cmd)){
		ptr = at_strstr(PsmIndAtCmdPrefix, cmd);
		while(NULL !=at_strstr(ptr, cmd)){
			ptr=at_strstr(ptr, cmd);
			pos_start = ptr-PsmIndAtCmdPrefix;
			if(0 == pos_start || (0 < pos_start && !isdigit(PsmIndAtCmdPrefix[pos_start-1]) && !isalpha(PsmIndAtCmdPrefix[pos_start-1]))){
				at_print(AT_ERR,"mnet_whitelist_add cmd already in\n");
				return MNET_WHITELIST_OPER_ALREADY_IN;
			}
			ptr+=strlen(cmd);
		}
	}
	
	if((strlen(PsmIndAtCmdPrefix) + strlen(cmd)) < sizeof(PsmIndAtCmdPrefix)){
		len = strlen(PsmIndAtCmdPrefix);
		snprintf(PsmIndAtCmdPrefix+len, AT_CMD_MAX-len, "%s", cmd);
		return MNET_WHITELIST_OPER_SUCC;
	}else{			
		at_print(AT_ERR,"no space left\n");
		return MNET_WHITELIST_OPER_NOMORESPACE;
	}
}

int mnet_whitelist_del(char* cmd)
{
	char* ptr=NULL;
	int pos_start=0;
	int i=0, j=0, len=strlen(PsmIndAtCmdPrefix);
	
	if(0 == strlen(PsmIndAtCmdPrefix)){
		return MNET_WHITELIST_DEL_TARGET_EMPTY;
	}else{
		char* pos = NULL;
		char str[AT_CMD_MAX] = {0};
		ptr = PsmIndAtCmdPrefix;
		if(NULL != at_strstr(PsmIndAtCmdPrefix, cmd)){
			while(NULL != at_strstr(ptr, cmd)){
				ptr=at_strstr(ptr, cmd);
				pos_start = (int)(ptr-PsmIndAtCmdPrefix);
				if(0 == pos_start || (pos_start>0 && ';' == PsmIndAtCmdPrefix[pos_start-1])){
					while(i<strlen(cmd)){
						ptr[i++]='\0';
					}
					i=0;
					strcpy(str, "");
					while(i<len){
						if(PsmIndAtCmdPrefix[i] != '\0') {
							str[j++] = PsmIndAtCmdPrefix[i];
						}
						i++;
					}
					strcpy(PsmIndAtCmdPrefix, "");
					strcpy(PsmIndAtCmdPrefix, str);
					break;
				}else{
					ptr+=strlen(cmd);
				}
			}
		}
	}
	
	if(strlen(PsmIndAtCmdPrefix) <2){		
		strcpy(PsmIndAtCmdPrefix, "");
	}
	return MNET_WHITELIST_OPER_SUCC;
}


void mnet_whitelist_insert(char* cmd)
{
	char* ptr=NULL;
	char * tmp=NULL;
		
	if(cmdtolower(cmd) == 1){
		at_print(AT_ERR,"cmd tolower failed\n");
		return;
	}
	ptr=cmd;
	at_print(AT_ERR,"mnet_whitelist_insert lower cmd : %s\n", cmd);
	while(NULL != (tmp = strchr(ptr, ';'))){
		char single_cmd[200]={0};
		int len = (int)(tmp-ptr)+1;
		if(len >= sizeof(single_cmd)){
			at_print(AT_ERR,"cmd too long , skip the cmd\n");
			ptr+=len;
			continue;
		}
		strncpy(single_cmd, ptr, len); 
	    ptr+=len;
		mnet_whitelist_add(single_cmd);
		memset(single_cmd, 0, sizeof(single_cmd));
	}
	at_print(AT_ERR,"mnet_whitelist_insert end PsmIndAtCmdPrefix : %s\n", PsmIndAtCmdPrefix);
	sc_cfg_set("customIndCmdList", PsmIndAtCmdPrefix);
	sc_cfg_save();
	return;
}

void mnet_whitelist_delete(char* cmd)
{
	at_print(AT_ERR,"mnet_whitelist_delete %s\n", cmd);
	char* ptr=NULL;
	char * tmp=NULL;
		
	if(cmdtolower(cmd) == 1){
		at_print(AT_ERR,"cmd tolower failed\n");
		return;
	}
	ptr=cmd;
	at_print(AT_ERR,"mnet_whitelist_delete lower cmd : %s\n", cmd);
	while(NULL != (tmp = strchr(ptr, ';'))){
		char single_cmd[200]={0};
		int len = (int)(tmp-ptr)+1;
		if(len >= sizeof(single_cmd)){
			at_print(AT_ERR,"single_cmd too long , skip the cmd\n");
			ptr+=len;
			continue;
		}
		strncpy(single_cmd, ptr, len); 
	    ptr+=len;
		mnet_whitelist_del(single_cmd);
		memset(single_cmd, 0, sizeof(single_cmd));
	}
	sc_cfg_set("customIndCmdList", PsmIndAtCmdPrefix);
	sc_cfg_save();
	return;
}


void mnet_whitelist_fetch()
{
	sc_cfg_get("customIndCmdList", PsmIndAtCmdPrefix, sizeof(PsmIndAtCmdPrefix));
	int ret = send_soc_msg(FAR_PS, MODULE_ID_MNET_WHITELIST, MSG_CMD_GET_MNET_WHITELIST_RSP, strlen(PsmIndAtCmdPrefix), (void*)PsmIndAtCmdPrefix);
	if (ret != 0) {
		at_print(AT_ERR, "send_soc_msg fail, ret:%d\n", ret);
	}
}


#endif
