/*
 *  wlan-station.c -- wifi station mode Deal module
 *
 *  Copyright (c) ZTE Corporation All Rights Reserved.
 *
 *  $Id: wlan-station.c, v 0.1 2015-03-09 $
 *   Authors :  XUJIAN - xu.jian5@zte.com.cn>
 */
#include "wifi_util.h"
#include "wlan-station.h"
#include "Vector.h"
#include "wifi_sta_ctrl.h"
#include "soft_timer.h"
#include "rtk_arch.h"
#include <semaphore.h>
#include <limits.h>
//#include <sys/socket.h>
//#include <netinet/in.h>
#include <arpa/inet.h>

#define  SUCCESS  "1"
#define  FAILED   "0"
#define REPLY_BUF_SIZE 4096 // wpa_supplicant's maximum size.

#define UEVENT_BUFFER_SIZE   1024*2

#define WIFI_STATION_CMD_LEN    256

//ʱ
#define WIFI_STATION_TIMER_CONNECT                     109
#define WIFI_STATION_TIMER_GET_STATUS               110
#define WIFI_STATION_TIMER_SCAN                            111
//add sim card init status query timer
#define WIFI_STATION_TIMER_SIM_CARD_STATUS                 112
#define WIFI_STATION_TIMER_GET_SCAN_RESULTS                113

#define WIFI_STATION_TIMER_CONNECT_INTERVAL  1000
#define WIFI_STATION_TIMER_GET_STATUS_INTERVAL  2000
#define WIFI_STATION_TIMER_SCAN_INTERVAL  60000  /// 10 ----> 15s nxl

#define WIFI_STATION_TIMER_GET_SCAN_RESULTS_INTERVAL  8000  /// 10 ----> 15s nxl


#define WIFI_STATION_TIMER_SIM_CARD_STATUS_INTERVAL  2000

#define WIFI_STATION_TIMER_WAIT_CONNECT_COUNT         20
#define WIFI_STATION_TIMER_CONNECT_TIME_OUT  116

//ɨ
#define WIFI_STATION_SCAN_DURATION                8
#define WIFI_STATION_SCRIPT_RSP_LINE_LEN     1024
#define WIFI_STATION_SCAN_RESULT_STR_LEN    1024
#define WIFI_STATION_SCAN_ONE_RESULT_STR_LEN    256
#define WIFI_STATION_SCAN_RESULT_LIST_NUM    60//һʵʹ̼ɨ30ϵͳܴ洢ɨ಻2048ֽ





#define WIFI_STATION_SIGNAL_LEVEL1  -80
#define WIFI_STATION_SIGNAL_LEVEL2  -78
#define WIFI_STATION_SIGNAL_LEVEL3  -75
#define WIFI_STATION_SIGNAL_LEVEL4  -72

#define WIFI_STATION_CHANNEL1  2412
#define WIFI_STATION_CHANNEL2  2417
#define WIFI_STATION_CHANNEL3  2422
#define WIFI_STATION_CHANNEL4  2427
#define WIFI_STATION_CHANNEL5  2432
#define WIFI_STATION_CHANNEL6  2437
#define WIFI_STATION_CHANNEL7  2442
#define WIFI_STATION_CHANNEL8  2447
#define WIFI_STATION_CHANNEL9  2452
#define WIFI_STATION_CHANNEL10  2457
#define WIFI_STATION_CHANNEL11  2462
#define WIFI_STATION_CHANNEL12  2467
#define WIFI_STATION_CHANNEL13  2472

#define WIFI_STATION_CHANNEL14  2484
//5G
#define WIFI_STATION_CHANNEL36  5180
#define WIFI_STATION_CHANNEL40  5200
#define WIFI_STATION_CHANNEL44  5220
#define WIFI_STATION_CHANNEL48  5240
#define WIFI_STATION_CHANNEL52  5260
#define WIFI_STATION_CHANNEL56  5280
#define WIFI_STATION_CHANNEL60  5300
#define WIFI_STATION_CHANNEL64  5320
#define WIFI_STATION_CHANNEL100  5500
#define WIFI_STATION_CHANNEL104  5520
#define WIFI_STATION_CHANNEL108  5540
#define WIFI_STATION_CHANNEL112  5560
#define WIFI_STATION_CHANNEL116  5580
#define WIFI_STATION_CHANNEL120  5600
#define WIFI_STATION_CHANNEL124  5620
#define WIFI_STATION_CHANNEL128  5640
#define WIFI_STATION_CHANNEL132  5660
#define WIFI_STATION_CHANNEL136  5680
#define WIFI_STATION_CHANNEL140  5700
#define WIFI_STATION_CHANNEL144  5720
#define WIFI_STATION_CHANNEL149  5745
#define WIFI_STATION_CHANNEL153  5765
#define WIFI_STATION_CHANNEL157  5785
#define WIFI_STATION_CHANNEL161  5805
#define WIFI_STATION_CHANNEL165  5825

#define WIFI_STATION_FREQ_LEN 16

#define WIFI_STATION_MSG_SOURCE_STR_LEN  15
#define WIFI_STATION_IP_STATUS_LEN 16
#define WIFI_CONNECTION_LEN 4
#define WIFI_ZPBIC_STATUS_LEN 16
#define WIFI_STATION_WPA_SUPPLICANT_STATUS_LEN 16

#define WIFI_STATION_SCAN_RESULT_PARSE_IGNORE  "bssid / frequency /"

#define WIFI_STATION_AUTH_WPA_PSK  "WPA-PSK"
#define WIFI_STATION_AUTH_WPA2_PSK  "WPA2-PSK"
#define WIFI_STATION_AUTH_WPA_EAP  "WPA-EAP"
#define WIFI_STATION_AUTH_WPA2_EAP "WPA2-EAP"
#define WIFI_STATION_AUTH_SHARED  "SHARED"
#define WIFI_STATION_AUTH_WPA3  "SAE"

#define WIFI_STATION_ENCRYPT_CCMP  "CCMP"
#define WIFI_STATION_ENCRYPT_TKIP  "TKIP"
#define WIFI_STATION_ENCRYPT_WEP  "WEP"

#define WIFI_STATION_PROFILE_AUTH_WPA_PSK  "WPAPSK"
#define WIFI_STATION_PROFILE_AUTH_WPA2_PSK  "WPA2PSK"
//#define WIFI_STATION_PROFILE_AUTH_WPA_EAP  "WPAEAP"
//#define WIFI_STATION_PROFILE_AUTH_WPA2_EAP  "WPA2EAP"
#define WIFI_STATION_PROFILE_AUTH_WPA_EAP "EAP-SIM/AKA"
#define WIFI_STATION_PROFILE_AUTH_SHARED  "SHARED"
#define WIFI_STATION_PROFILE_AUTH_WPA3 "WPA3Personal"
#define WIFI_STATION_PROFILE_AUTH_WPA2_WPA3  "WPA2WPA3"

#define WIFI_STATION_PROFILE_ENCRYPT_WEP  "WEP"
#define WIFI_STATION_PROFILE_ENCRYPT_CCMP  "CCMP"
#define WIFI_STATION_PROFILE_ENCRYPT_TKIP  "TKIP"



#define WIFI_STATION_STATUS_RESULT_PARSE_BSSID  "bssid"
#define WIFI_STATION_STATUS_RESULT_PARSE_SSID  "ssid"
#define WIFI_STATION_STATUS_RESULT_PARSE_WPA_STATUS  "wpa_state"
#define WIFI_STATION_STATUS_RESULT_PARSE_SUPPLICANT_PAE_STATUS  "Supplicant PAE state"
#define WIFI_STATION_STATUS_RESULT_PARSE_SUPPPORT_STATUS  "suppPortStatus"
#define WIFI_STATION_STATUS_RESULT_PARSE_EAP_STATUS  "EAP state"




#define WIFI_STATION_STATUS_RESULT_WPA_STATUS_OK  "COMPLETED"

#define WIFI_STATION_STATUS_RESULT_WPA_STATUS_INACTIVE  "INACTIVE"
#define WIFI_STATION_STATUS_RESULT_WPA_STATUS_SCANNING  "SCANNING"
#define WIFI_STATION_TIMER_SCANNING_STATE_COUNT         10

#define WIFI_STATION_STATUS_RESULT_WPA_STATUS_AUTHENTICATING  "AUTHENTICATING"
#define WIFI_STATION_STATUS_RESULT_WPA_STATUS_ASSOCIATING  "ASSOCIATING"
#define WIFI_STATION_STATUS_RESULT_WPA_STATUS_ASSOCIATED   "ASSOCIATED"
#define WIFI_STATION_STATUS_RESULT_WPA_STATUS_4WAY_HANDSHAKE   "4WAY_HANDSHAKE"
#define WIFI_STATION_STATUS_RESULT_WPA_STATUS_4WAY_GROUP_HANDSHAKE   "GROUP_HANDSHAKE"
#define WIFI_STATION_STATUS_RESULT_WPA_STATUS_4WAY_GROUP_UNKNOWN   "UNKNOWN"
#define WIFI_STATION_STATUS_RESULT_WPA_STATUS_4WAY_GROUP_DISCONNECTED   "DISCONNECTED"
#define WIFI_STATION_STATUS_RESULT_WPA_STATUS_4WAY_GROUP_INTERFACE_DISABLED   "INTERFACE_DISABLED"


#define WIFI_STATION_STATUS_RESULT_EAP_STATUS_FAIL  "FAILURE"
#define WIFI_STATION_STATUS_RESULT_EAP_STATUS_SUCCESS  "SUCCESS"



#define WIFI_STATION_IP_STATUS_CONNECT  "connect"
#define WIFI_STATION_IP_STATUS_DISCONNECT  "disconnect"
#define WIFI_STATION_IP_STATUS_CONNECTING  "connecting"
#define WIFI_STATION_IP_STATUS_DHCPING  "dhcping"

#define INVALID_NETWORK_ID  -1

#define safe_free(x) do { if(x) {free(x); x=NULL;} } while(0)

#define WPA_CLI "wpa_cli -p"ROOT_DIR"/wifi/wpa_supplicant -iwlan0-vxd"

#define WIFI_CARD_MODE_LEN 3

#define WIFI_PIN_STATUS_LEN 3

#define SIMCARD_INIT_SUCCESS "success"
#define SIMCARD_INIT_UNDEFINED "undefined"
#define SIMCARD_INIT_NO_CARD "no_card"
//#define SIMCARD_INIT_LOCKED "locked"
//#define SIMCARD_INIT_FAIL "fail"
//#define SIMCARD_INIT_PARTIAL_SUCCESS "partial_success"
#if 0
static const wlan_sta_freq_ch_t g_sta_freq_ch[] =
{
    {WIFI_STATION_CHANNEL1, 	1},
    {WIFI_STATION_CHANNEL2, 	2},
    {WIFI_STATION_CHANNEL3, 	3},
    {WIFI_STATION_CHANNEL4, 	4},
    {WIFI_STATION_CHANNEL5, 	5},
    {WIFI_STATION_CHANNEL6, 	6},
    {WIFI_STATION_CHANNEL7, 	7},
    {WIFI_STATION_CHANNEL8, 	8},
    {WIFI_STATION_CHANNEL9, 	9},
    {WIFI_STATION_CHANNEL10, 	10},
    {WIFI_STATION_CHANNEL11, 	11},
    {WIFI_STATION_CHANNEL12, 	12},
    {WIFI_STATION_CHANNEL13, 	13},
    {WIFI_STATION_CHANNEL14, 	14},

	{WIFI_STATION_CHANNEL36, 	36},
    {WIFI_STATION_CHANNEL40, 	40},
    {WIFI_STATION_CHANNEL44, 	44},
    {WIFI_STATION_CHANNEL48, 	48},
    {WIFI_STATION_CHANNEL52, 	52},
    {WIFI_STATION_CHANNEL56, 	56},
    {WIFI_STATION_CHANNEL60, 	60},
    {WIFI_STATION_CHANNEL64, 	64},
    {WIFI_STATION_CHANNEL100, 	100},
    {WIFI_STATION_CHANNEL104, 	104},
    {WIFI_STATION_CHANNEL108, 	108},
    {WIFI_STATION_CHANNEL112, 	112},
    {WIFI_STATION_CHANNEL116, 	116},
    {WIFI_STATION_CHANNEL120, 	120},
    {WIFI_STATION_CHANNEL124, 	124},
    {WIFI_STATION_CHANNEL128, 	128},
    {WIFI_STATION_CHANNEL132, 	132},
    {WIFI_STATION_CHANNEL136, 	136},
    {WIFI_STATION_CHANNEL140, 	140},
    {WIFI_STATION_CHANNEL144, 	144},
    {WIFI_STATION_CHANNEL149, 	149},
    {WIFI_STATION_CHANNEL153, 	153},
    {WIFI_STATION_CHANNEL157, 	157},
    {WIFI_STATION_CHANNEL161, 	161},
    {WIFI_STATION_CHANNEL165, 	165}
};
#endif

extern struct  wlan_sta_manager  *sta_manager;
extern int need_channel_follow;


//static int g_timer_sim_init_undefined_status_count = 0;
//add by zhouti eap ֤ǰ͵첽ϢڵȴʱûdisconnectôҪжϻrespϢǷΪεĻӦǾҪ
static int g_send_count = 0;
static int g_pre_send_count = 0;

//gebin: ⼸ĿľΪ̼߳䴫ݲ???  ͲҪȫֱˣipcԴ
char g_linked_ap_mac[WIFI_STATION_MAC_LEN] = {0};
int g_linked_network_id = -1;
int g_linked_network_id_last = -1;
/*浱ǰʷбAP*/
static spot_t *g_spot_list_p[WIFI_STATION_SPOT_LIST_NUM] = {NULL};//ȵбָ

static scan_result_t *g_scan_result_list_p[WIFI_STATION_SCAN_RESULT_LIST_NUM] = {NULL};//ɨȵбָ
static int g_cardmode = 0; //ȫּ¼sim

static int g_blc_send_close_apsta = 0; // ȫּ¼BLC͹رϢwifi,ֱBLCʹ
int g_wpa_supplicant;
extern sem_t g_wpa_supplicant_id;

int has_exec_disconnect = 0;     //ǷִйϿ
int has_exec_select_network = 0; //Ƿִйѡĳһȵ
int webui_select_network = 0;    //¼webui·ѡĳȵ
int g_disable_other_network = 0; //Ƿȵ

int g_connecting_time_out_timer = 0;//ȫּ¼ǷѴӳʱʱ

#ifdef USE_CAP_SUPPORT
extern int g_work_mode;
extern int g_cap_sta_enable;

int g_cap_scan = 0; //capscanʱ,ϱ,ִ̨н
int send_sta_status_to_cap(int status, int reason);
#endif

static int wifi_station_connect (int from_where);
static void wifi_station_scan (void);
static void *wifi_station_query_sim_card_status(void *arg);
static void sta_connect (int network_id);
extern void basic_deal_all (int cmd);
static int  find_linked_ap_index(void);
static void delete_quote (char * str);
static void wlan_station_deinit(void);
static void process_tmp_disabled (char *buf);

extern int check_alive(struct wlan_socket *skt);


inline char * sta_docmd(const char *cmd)
{
	return docmd (&sta_manager->sock, cmd);
}


/*
	0 : not exist
	1: alive
*/
int 	check_supplicant_alive()
{
	return check_alive(&sta_manager->sock);

}


void *send_message_to_handle_connect_timeout(void *arg)
{
	ipc_send_message (MODULE_ID_WLAN_SERVER, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_CONNECT_TIMEOUT, 0, NULL, 0);
	return NULL;
}
void Create_connect_timeout_timer()
{
	wf_log ("[111]g_connecting_time_out_timer=%d", g_connecting_time_out_timer);
	if (g_connecting_time_out_timer) {
		wf_log ("[xxx]station connecting timeout softtimer already exists");
		return;
	}
	wf_log ("[222]create station connecting timeout softtimer");
	sc_timer_create (WIFI_STATION_TIMER_CONNECT_TIME_OUT, TIMER_FLAG_ONCE, 60 * 1000, send_message_to_handle_connect_timeout, NULL);
	g_connecting_time_out_timer = 1;
	wf_log ("[333]g_connecting_time_out_timer=%d", g_connecting_time_out_timer);
	return;
}
void Delete_connect_timeout_timer (void)
{
	wf_log ("[555]g_connecting_time_out_timer=%d", g_connecting_time_out_timer);
	if (g_connecting_time_out_timer == 0) {
		wf_log ("[xxx]station connecting timeout softtimer was already deleted");
		return;
	}
	wf_log ("[666]delete station connecting timeout softtimer");
	sc_timer_delete (WIFI_STATION_TIMER_CONNECT_TIME_OUT);
	g_connecting_time_out_timer = 0;
	wf_log ("[777]g_connecting_time_out_timer=%d", g_connecting_time_out_timer);
	return;
}

//ִһshellд洢resvecУ
static int32_t  convert2vector (const char *str, vector_t* resvec)
{
	char *tmp = NULL; //һʵĳȣԴ洢ÿһ
	char *ret = NULL;
	FILE  *fp = NULL;
	int tmp_len = 0;

	if (str == NULL || resvec == NULL) {
		return -1;
	}

	fp = fopen ("/tmp/scan_results", "w+"); //ܵ
	if (!fp) {
		wf_log ("fopen errno: %d\n", errno); 
		return -1;
	}
	fprintf (fp, "%s", str);
	fseek (fp, 0, SEEK_SET);
	tmp = safe_malloc (WIFI_STATION_SCRIPT_RSP_LINE_LEN, TRUE);

again:
	errno = 0;
	while ((ret=fgets (tmp, WIFI_STATION_SCRIPT_RSP_LINE_LEN, fp)) != NULL) {
		tmp_len = strlen (tmp);
		if (tmp_len > 0) {
			if (tmp[tmp_len - 1] == '\n') {
				tmp[tmp_len - 1] = '\0'; //ȥз
			}
			vector_push_back (resvec, var_string (tmp));
		}
	}

	if (EINTR ==errno) { //kw 3
		wf_log("fgets recv EINTR!");
		goto again;
	}

	fclose (fp); 
	safe_free (tmp);

	return vector_size (resvec);
}


//TODO DOWN UPװ
static void network_down_up (BOOL is_up)
{
	if (is_up == TRUE) {
		sc_cfg_set ("WAN_MODE", "WIFI"); //usb,ppp,wifi
		/*printf("[wlan-station]calling ipv4.sh linkup\n");
		system("zte_ipv4.sh \"linkup\"");
		printf("[wlan-station]calling internet.sh\n");
		system("internet.sh");
		printf("[wlan-station]calling nat.sh\n");
		system("nat.sh");*/
		netdev_connect_internet (WIFI_WAN_DEV, MODULE_ID_WIFI);

		wf_log ("[wlan-station]netdev_connect_internet");
	} else {
		netdev_disconnect_internet (WIFI_WAN_DEV, MODULE_ID_WIFI);
		wf_log ("[wlan-station]netdev_disconnect_internet");
		//system("zte_ipv4.sh \"linkdown\"");
		sc_cfg_set ("WAN_MODE", "PPP"); //usb,ppp,wifi
	}
}


static void update_EX_APLIST_connect_status (BOOL is_connected)
{
	char *scan_result_str = NULL;
	char *scan_result_str_tmp = NULL;
	int i = 0;
	int found_ap_index = -1;
	char *splited_string = NULL;
	char *splited_string1 = NULL;
	char *save = NULL;
	char *save1 = NULL;
	char *delimiter = ";";
	int found_str_index = 0;
	BOOL is_found = FALSE;
	BOOL is_find_EX_APLIST1 = FALSE;

	int  index = 0;
// ӳɹǶϿҵӦȵ㣬ΪЧֵ
	index =  find_linked_ap_index();

	for (i = 0; i < WIFI_STATION_SCAN_RESULT_LIST_NUM; i++) {
		if (g_scan_result_list_p[i] != NULL &&  index != -1) {
			if (strcmp (g_scan_result_list_p[i]->mac, g_spot_list_p[index]->mac) == 0) {
				found_ap_index = i;

				if (is_connected == TRUE) {
					g_scan_result_list_p[i]->connect_status = 1;
				} else {
					g_scan_result_list_p[i]->connect_status = 0;
				}

				break;
			}
		}

	}

	//ûҵAPֱ˳
	if (found_ap_index == -1) {
		return;
	}

	scan_result_str = safe_malloc (WIFI_STATION_SCAN_RESULT_STR_LEN, FALSE);
	scan_result_str_tmp = safe_malloc (WIFI_STATION_SCAN_RESULT_STR_LEN, FALSE);
	if (scan_result_str == NULL || scan_result_str_tmp == NULL) {
		safe_free (scan_result_str);
		safe_free (scan_result_str_tmp);
		return;
	}

	//EX_APLIST
	sc_cfg_get ("EX_APLIST", scan_result_str, WIFI_STATION_SCAN_RESULT_STR_LEN);

	safe_strcpy (scan_result_str_tmp, scan_result_str, WIFI_STATION_SCAN_RESULT_STR_LEN);
	//Էֺŷַָ
	i = 0;
	splited_string = strtok_r (scan_result_str_tmp, delimiter, &save);
	while (splited_string) {
		if (i == found_ap_index) {
			//ҵconnect_statusַе
			found_str_index += 2;

			is_found = TRUE;
			break;
		}
		found_str_index += strlen (splited_string) + 1; //ҪټϷֺŵ1ַ

		i++;
		splited_string = strtok_r (NULL, delimiter, &save);
	}

	//EX_APLIST1
	if (is_found == FALSE) {
		is_find_EX_APLIST1 = TRUE;
		found_str_index = 0;
		memset (scan_result_str, 0, WIFI_STATION_SCAN_RESULT_STR_LEN);
		memset (scan_result_str_tmp, 0, WIFI_STATION_SCAN_RESULT_STR_LEN);
		sc_cfg_get ("EX_APLIST1", scan_result_str, WIFI_STATION_SCAN_RESULT_STR_LEN);

		safe_strcpy (scan_result_str_tmp, scan_result_str, WIFI_STATION_SCAN_RESULT_STR_LEN);

		splited_string1 = strtok_r (scan_result_str_tmp, delimiter, &save1);
		while (splited_string1) {
			if (i == found_ap_index) {
				//ҵconnect_statusַе
				found_str_index += 2;

				is_found = TRUE;
				break;
			}
			found_str_index += strlen (splited_string1) + 1; //ҪټϷֺŵ1ַ

			i++;
			splited_string1 = strtok_r (NULL, delimiter, &save1);
		}
	}

	if (is_found == TRUE
	    && found_str_index > 0 && found_str_index < strlen (scan_result_str)) {
		if (is_connected == TRUE) {
			scan_result_str[found_str_index] = '1';
		} else {
			scan_result_str[found_str_index] = '0';
		}

		if (is_find_EX_APLIST1 == TRUE) {
			sc_cfg_set ("EX_APLIST1", scan_result_str);
		} else {
			sc_cfg_set ("EX_APLIST", scan_result_str);
		}
	}

	safe_free (scan_result_str);
	safe_free (scan_result_str_tmp);
}

static spot_t* parse_spot_string (char *spot_string)
{
	spot_t *spot = NULL;
	char *splited_string = NULL;
	char *save = NULL;
	const char *delimiter = ",";
	wifi_profile_content_t wifi_profile_content = WIFI_STATION_CONTENT_UNDEFINED;
	char spot_string_tmp[WIFI_STATION_SPOT_LEN] = {0};

	if (spot_string == NULL) {
		return NULL;
	}
	//klocwork
	strncpy(spot_string_tmp, spot_string, sizeof(spot_string_tmp)-1);

	spot = safe_malloc (sizeof (spot_t), FALSE);
	if (spot == NULL) {
		return NULL;
	}

	spot->is_tried_connect = FALSE;

	//ַָ洢ṹ
	splited_string = strtok_r (spot_string_tmp, delimiter, &save);
	while (splited_string) {
		wifi_profile_content++;
		switch (wifi_profile_content) {
		case WIFI_STATION_PROFILE_NAME:
			//safe_strcpy (spot->profile_name, splited_string, WIFI_STATION_SPOT_PROFILE_NAME_LEN);
			strncpy (spot->profile_name, splited_string, sizeof(spot->profile_name)-1);
			break;
		case WIFI_STATION_FROM_PROVIDER:
			spot->from_provider = atoi (splited_string);
			break;
		case WIFI_STATION_CONNECT_STATUS:
			spot->connect_status = atoi (splited_string);
			break;
		case WIFI_STATION_SIGNAL:
			spot->signal = atoi (splited_string);
			break;
		case WIFI_STATION_SSID:
			//safe_strcpy (spot->ssid, splited_string, WIFI_STATION_SSID_LEN);
			strncpy (spot->ssid, splited_string, sizeof(spot->ssid)-1);
			break;
		case WIFI_STATION_AUTH_MODE:
			//safe_strcpy (spot->auth_mode, splited_string, WIFI_STATION_AUTH_MODE_LEN);
			strncpy (spot->auth_mode, splited_string, sizeof(spot->auth_mode)-1);
			break;
		case WIFI_STATION_ENCRYPT_TYPE:
			//safe_strcpy (spot->encrypt_type, splited_string, WIFI_STATION_ENCRYPT_TYPE_LEN);
			strncpy (spot->encrypt_type, splited_string, sizeof(spot->encrypt_type)-1);
			break;
		case WIFI_STATION_PASSWORD:
			//safe_strcpy (spot->password, splited_string, WIFI_STATION_SPOT_PASSWORD_LEN);
			strncpy (spot->password, splited_string, sizeof(spot->password)-1);
			break;
		case WIFI_STATION_KEY_ID:
			spot->keyID = atoi (splited_string);
			break;
		case WIFI_STATION_AP_MAC:
			//safe_strcpy (spot->mac, splited_string, WIFI_STATION_MAC_LEN);
			strncpy (spot->mac, splited_string, sizeof(spot->mac)-1);
			break;
		default:
			break;
		}

		splited_string = strtok_r (NULL, delimiter, &save);
	}

	spot->network_id = -1; // from nv profile , there is no network id property, so ,default set it -1

	if (wifi_profile_content != WIFI_STATION_AP_MAC) {
		safe_free (spot);
		return NULL;
	}


	return spot;

}


static void  save_config (spot_t *spot)
{

	char cmd[WIFI_STATION_CMD_LEN] = {0};
	char *ptr = NULL;
	char *ptr2 = NULL;
	char *ptr3 = NULL;
	char *ptr_w3 = NULL;
	char *ptr_w23 = NULL;
	char *ptr5 = NULL;
	char *ptr6 = NULL;
	int  key_len = 0;
	int id;

	if (spot == NULL)    {
		return;
	}

	if (spot->network_id   == -1) {
		
		//id = atoi (sta_docmd ("ADD_NETWORK"));
		//klocwork
		char *reply = NULL;
		reply = sta_docmd("ADD_NETWORK");
		if (reply == NULL) {
			return;
		}
		id = atoi(reply);
	
		spot->network_id = id;
		wf_log ("[sav_config] new spot  get new networkid=%d", id);

	} else {
		id = spot->network_id ;
		wf_log ("[sav_config] old spot  have networkid=%d", id);

	}


	sprintf (cmd,  "SET_NETWORK %d ssid \"%s\"", id , spot->ssid);
	sta_docmd (cmd);

	memset (cmd, 0, WIFI_STATION_CMD_LEN);
	ptr = strstr (spot->auth_mode, WIFI_STATION_PROFILE_AUTH_WPA_PSK);
	ptr2 = strstr (spot->auth_mode, WIFI_STATION_PROFILE_AUTH_WPA2_PSK);
	ptr3 = strstr (spot->auth_mode, WIFI_STATION_PROFILE_AUTH_WPA_EAP);
	ptr_w3 = strstr(spot->auth_mode, WIFI_STATION_PROFILE_AUTH_WPA3);
	ptr_w23 = strstr(spot->auth_mode, WIFI_STATION_PROFILE_AUTH_WPA2_WPA3);

	ptr5 = strstr (spot->encrypt_type, WIFI_STATION_PROFILE_ENCRYPT_CCMP);
	ptr6 = strstr (spot->encrypt_type, WIFI_STATION_PROFILE_ENCRYPT_TKIP);

	sprintf (cmd, "SET_NETWORK %d priority 1", id);
	sta_docmd (cmd);


	if (ptr || ptr2) {
		sprintf (cmd, "SET_NETWORK %d key_mgmt WPA-PSK", id);
		sta_docmd (cmd);

		if (ptr && !ptr2) {
			sprintf (cmd, "SET_NETWORK %d proto WPA", id);
			sta_docmd (cmd);
		} else if (!ptr && ptr2) {
			sprintf (cmd, "SET_NETWORK %d proto WPA2", id);
			sta_docmd (cmd);
		} else{
			sprintf (cmd, "SET_NETWORK %d proto WPA RSN", id);
			sta_docmd (cmd);
		}

		if (ptr5 && !ptr6) {
			sprintf (cmd, "SET_NETWORK %d pairwise CCMP", id);
			sta_docmd (cmd);
		} else if (!ptr5 && ptr6) {
			sprintf (cmd, "SET_NETWORK %d pairwise TKIP", id);
			sta_docmd (cmd);
		} else {
			wf_log ("[save_config]can support both of CCMP TKIP", ptr5, ptr6);
			sprintf (cmd, "SET_NETWORK %d pairwise CCMP TKIP", id);
			sta_docmd (cmd);		
		}

		sprintf (cmd, "SET_NETWORK %d psk \"%s\" ", id , spot->password);
		sta_docmd (cmd);
	} else if (ptr3) { //|| ptr4)
		sprintf (cmd, "SET_NETWORK %d key_mgmt WPA-EAP", id);
		sta_docmd (cmd);

		if (g_cardmode == CARD_MODE_USIM) {
			sprintf (cmd, "SET_NETWORK %d eap AKA", id);
			sta_docmd (cmd);
		} else {
			sprintf (cmd, "SET_NETWORK %d eap SIM", id);
			sta_docmd (cmd);
		}
		sprintf (cmd, "SET_NETWORK %d pcsc '\" \"'", id);
		sta_docmd (cmd);

//¸ȼΪ
		sprintf (cmd, "SET_NETWORK %d priority 4", id);
		sta_docmd (cmd);

	} else if (ptr_w3) {
		sprintf (cmd, "SET_NETWORK %d key_mgmt SAE", id);
		sta_docmd (cmd);

		//if set ,other need ieee80211w 0?
		//sprintf (cmd, "SET_NETWORK %d proto RSN", id);
		//sta_docmd (cmd);

		//sprintf (cmd, "SET_NETWORK %d pairwise CCMP", id);
		//sta_docmd (cmd);

		//sprintf (cmd, "SET_NETWORK %d ieee80211w 2", id);
		//sta_docmd (cmd);


		sprintf (cmd, "SET_NETWORK %d psk \"%s\"", id , spot->password);
		sta_docmd (cmd);
	} else if (ptr_w23) {
		sprintf (cmd, "SET_NETWORK %d key_mgmt SAE WPA-PSK", id);
		sta_docmd (cmd);

		//sprintf (cmd, "SET_NETWORK %d proto RSN", id);
		//sta_docmd (cmd);

		//sprintf (cmd, "SET_NETWORK %d pairwise CCMP", id);
		//sta_docmd (cmd);

		//sprintf (cmd, "SET_NETWORK %d ieee80211w 1", id);
		//sta_docmd (cmd);


		sprintf (cmd, "SET_NETWORK %d psk \"%s\"", id , spot->password);
		sta_docmd (cmd);
	} else {
		sprintf (cmd, "SET_NETWORK %d key_mgmt NONE", id);
		sta_docmd (cmd);
	}

	ptr = NULL;
	ptr = strstr (spot->encrypt_type, WIFI_STATION_PROFILE_ENCRYPT_WEP);
	if (ptr) {
		sprintf (cmd, "SET_NETWORK %d wep_tx_keyidx %d", id , spot->keyID);
		sta_docmd (cmd);

		key_len = strlen (spot->password);
		wf_log ("key_len=%d,password_wep=%s",  key_len, spot->password);
		memset (cmd, 0, WIFI_STATION_CMD_LEN);
		if (key_len == 5 || key_len == 13) { //ascii
			sprintf (cmd, "SET_NETWORK %d wep_key%d \"%s\"", id , spot->keyID, spot->password);
		} else if (key_len == 10 || key_len == 26) { //hex
			sprintf (cmd, "SET_NETWORK %d wep_key%d %s", id,  spot->keyID, spot->password);
		} else {
			sprintf (cmd, "SET_NETWORK %d wep_key%d \"%s\"", id, spot->keyID, spot->password);
		}
		sta_docmd (cmd);
	}

	ptr = NULL;
	ptr = strstr (spot->auth_mode, WIFI_STATION_PROFILE_AUTH_SHARED);
	if (ptr) {
		sprintf (cmd, "SET_NETWORK %d auth_alg SHARED", id);
		sta_docmd (cmd);
	}

	sprintf (cmd, "SET_NETWORK %d scan_ssid 1", id);
	sta_docmd (cmd);


	sta_docmd ("SAVE_CONFIG");
	sta_docmd ("LIST_NETWORKS");
}



static void dump_spot(void)
{
	int i = 0;
	int spot_num = 0;
	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));
	spot_num = atoi (wifi_profile_num);
	if (spot_num > WIFI_STATION_SPOT_LIST_NUM || spot_num < 0)
		return;

//ʱĸѾǼˣԸҪ1
	for (i = 0; i < spot_num; i++) {
		if (NULL != g_spot_list_p[i]) {
			wf_log ("spot[%d]%s,%d,%d,%d,%s,%s,%s,%s,%d,%s,%d", i , g_spot_list_p[i]->profile_name,
			        g_spot_list_p[i]->from_provider, g_spot_list_p[i]->connect_status, g_spot_list_p[i]->signal,
			        g_spot_list_p[i]->ssid, g_spot_list_p[i]->auth_mode, g_spot_list_p[i]->encrypt_type,
			        g_spot_list_p[i]->password, g_spot_list_p[i]->keyID, g_spot_list_p[i]->mac, g_spot_list_p[i]->network_id);
		} else {
			wf_log ("ERROR, g_spot_list_p[%d] should not be NULL spot_num = %d\n ", i, spot_num);
		}
	}
}

static void del_spot (int id)
{
	int i = 0;
	int spot_num = 0;
	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));
	spot_num = atoi (wifi_profile_num);
	if (spot_num >= WIFI_STATION_SPOT_LIST_NUM || spot_num < 0)//klocwork
		return;

	safe_free (g_spot_list_p[id]);

//ʱĸѾǼˣԸҪ1
	for (i = id + 1; i <= spot_num; i++) {

		if (g_spot_list_p[i] != NULL) {
			g_spot_list_p[i - 1] = g_spot_list_p[i];
			g_spot_list_p[i] = NULL;
		}
	}


	//dump_spot();
}

/*webui Ѿȵnv
   ˺Ҫnvȵ µӦõȫֱ
   ȵļȡnetworkid ȫֱ

*/
static void  webui_update_spot_list (updateinfo_t *info)
{
	int i = 0;
	spot_t *spot = NULL;
	int spot_num = 0;
	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};
	int flag = 0;

	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));
	spot_num = atoi (wifi_profile_num);

	wf_log ("action=%s  profile=%s", info->action, info->spot);

//ӵȵ㲻Ӫȵ㣬ӵȵ㣬Զͨȵ㣬ֱӰ˳ں
	if (strcmp (info->action, "add") == 0) {

		wf_log ("%s  processing", info->action);
		if (spot_num < 1 || spot_num > WIFI_STATION_SPOT_LIST_NUM) {//klocwork
			return;
		}

		spot = parse_spot_string (info->spot);
		if (spot == NULL) {//klocwork
			return;
		}
		spot->network_id = -1;
		save_config (spot);
		g_spot_list_p[spot_num - 1] = spot;

//ǶϿ״ֱ̬ӣ״ֻ̬ҪenableͿ
		sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));

		if (strcmp (sta_ip_status, "disconnect") == 0) {
			sta_connect (spot->network_id);
		}

	} else  if (strcmp (info->action, "modify") == 0) {
		wf_log ("%s  processing", info->action);
		spot = parse_spot_string (info->spot);
		if (spot == NULL) {//klocwork
			return;
		}
		for (i = 0; i < WIFI_STATION_SPOT_LIST_NUM; i++) {
			if (g_spot_list_p[i] != NULL &&  !strcmp (g_spot_list_p[i]->profile_name, spot->profile_name)) {
				spot->network_id = g_spot_list_p[i]->network_id;
				safe_free (g_spot_list_p[i]);
				g_spot_list_p[i] = spot;
				save_config (spot);
				flag = 1;
				break;
			}
		}
		sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));

		if (strcmp (sta_ip_status, "disconnect") == 0) {
			sta_connect (spot->network_id);
		}
		if (flag == 0) {//for klocwork,¼ȫֵĲɾ
			safe_free (spot);
		}
	} else if (strcmp (info->action, "delete") == 0) {
		int  network_id = -1;;
		int  del_id = -1;
		char cmd[WIFI_STATION_CMD_LEN] = {0};
		wf_log ("%s  processing", info->action);

		dump_spot();
		for (i = 0; i < WIFI_STATION_SPOT_LIST_NUM; i++) {
			if (g_spot_list_p[i] != NULL &&  !strncmp (g_spot_list_p[i]->profile_name, info->spot,  strlen(g_spot_list_p[i]->profile_name))) {
				network_id = g_spot_list_p[i]->network_id;
				del_id = i;
				break;
			}
		}

		if (network_id != -1) {
			sprintf (cmd, "REMOVE_NETWORK %d", network_id);
			sta_docmd (cmd);
			sta_docmd ("SAVE_CONFIG");

			if (del_id != -1)
				del_spot (del_id);
		} else {
			wf_log ("spot:%s not found", info->spot);
		}

	}
	dump_spot();
}



/*
	ɾȵͻȻϵ磬޷浽conf ļҪͬһ

*/

static int  get_spot_info_from_conf (spot_ssid_id_t  *info, int num)
{

	int i = 0;
	char cmd[WIFI_STATION_CMD_LEN] = {0};
	char * reply = NULL;

	for (i = 0; i < WIFI_STATION_SPOT_LIST_NUM; i++) {

		info->id = -1;
		memset (info->ssid, 0 , sizeof (info->ssid));

		sprintf (cmd, "GET_NETWORK %d ssid", i);
		reply = sta_docmd (cmd);
		if (reply != NULL) {
			wf_log ("[update networkid from conf]reply SSID=%s", reply);
			strncpy (info->ssid, reply, sizeof (info->ssid)-1);
		} else {
			wf_log ("[update networkid from conf]conf read over!");
			break;
		}

		if (strlen (info->ssid) > 0) {
			wf_log ("[update networkid from conf] delete quote");

			delete_quote (info->ssid);
		}

		info->id = i;
		wf_log ("[update networkid from conf]SSID=%s, network_id=%d", info->ssid, i);
		info += 1;
	}

	return i;
}


/**/
static void  delete_quote (char * str)
{
	int len = 0;
	printf("str=%s\n", str);
	if (*str == '\"') {
		//strcpy (str, str + 1); //cov m
		len = strlen(str + 1);
		memmove(str, str + 1, len + 1); 
		*(str + len) = '\0';
	}
	printf("str=%s\n", str);

	if (*(str + strlen(str) - 1) == '\"')
		*(str + strlen(str) - 1) = '\0';

	printf("str=%s\n", str);
}


//1.  رapsta
/*

     : conf file±wpa_supplicantȡnetwork idҪͬspot list


     ر: conf file Ϊ˺͹ػһ£ҲҪspot 
*/


//2.  ػ
/*

       ػ: ػ쳣ϵ磬κβ̣confļ޸
       : ֱ·spot ڴ棬nvͬspotݣȻconfļͬnetworkidûжӦnetworid

       ҪӸȵ㵽confļУֱԤõӪȵ

*/
void  sync_nv_spot_list_conf_file()
{
	spot_ssid_id_t   g_spot_ssid_id_p[WIFI_STATION_SPOT_LIST_NUM] = {{0}};

	int i = 0, j = 0;
	int spot_num = 0;
	int  conf_spot_num = 0;

	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));
	spot_num = atoi (wifi_profile_num);
	if (spot_num > WIFI_STATION_SPOT_LIST_NUM || spot_num < 0)
		return;

	memset (g_spot_ssid_id_p, 0,  WIFI_STATION_SPOT_LIST_NUM * sizeof (struct  spot_ssid_id));
	conf_spot_num = get_spot_info_from_conf (g_spot_ssid_id_p, spot_num);
	wf_log ("spot_num=%d,conf_spot_num=%d", spot_num, conf_spot_num);

	for (i = 0; i < spot_num; i++) {
		wf_log ("[sync spot before]SSID:%s, networkid=%d", g_spot_list_p[i]->ssid,  g_spot_list_p[i]->network_id);
		for (j = 0; j < WIFI_STATION_SPOT_LIST_NUM; j ++) {
//[sync before]spot SSID:CPE_E3DE4E, conf ssid="CPE_E3DE4E",   dubble quote !!!!!!
			wf_log ("[compare to conf]spot SSID:%s, conf ssid=%s", g_spot_list_p[i]->ssid,  g_spot_ssid_id_p[j].ssid);
			if (strcmp (g_spot_ssid_id_p[j].ssid,  g_spot_list_p[i]->ssid)  == 0) {
				g_spot_list_p[i]->network_id = g_spot_ssid_id_p[j].id;
				break;
			}
		}

		if (-1 == g_spot_list_p[i]->network_id) {
			save_config (g_spot_list_p[i]); //confûУҪ룬update spot  networkid
		}
		wf_log ("[sync spot after]SSID:%s, networkid=%d", g_spot_list_p[i]->ssid,  g_spot_list_p[i]->network_id);
	}

/*޳ confļûɾspot*/
	for (i = 0; i < conf_spot_num; i++) {
		int  conf_spot_in_nv = 0;

		wf_log ("[sync conf  before]SSID:%s, networkid=%d", g_spot_ssid_id_p[i].ssid, g_spot_ssid_id_p[i].id);
		if (strlen (g_spot_ssid_id_p[i].ssid) > 0) {
			for (j = 0; j < spot_num; j ++) {
				wf_log ("[compare to spot]g_spot_list_p[j]->ssid=%s", g_spot_list_p[j]->ssid);
				if (strcmp (g_spot_ssid_id_p[i].ssid,  g_spot_list_p[j]->ssid) == 0) {
					conf_spot_in_nv = 1;
					break;
				}
			}

			//   nvУҪɾ
			if (0  == conf_spot_in_nv) {
				char cmd[WIFI_STATION_CMD_LEN] = {0};
				sprintf (cmd, "REMOVE_NETWORK %d", g_spot_ssid_id_p[i].id);
				sta_docmd (cmd);
			}
		}

		wf_log ("[sync conf after]SSID:%s, networkid=%d", g_spot_ssid_id_p[i].ssid, g_spot_ssid_id_p[i].id);
	}



}

//ȡȵбһָ飬ȫ
static void get_spot_list (void)
{
	int i = 0;
	int j = 0;
	char spot_string[WIFI_STATION_SPOT_LEN] = {0};
	char wifi_profile_nv_name[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	spot_t *spot = NULL;
	int spot_num = 0;
	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));
	spot_num = atoi (wifi_profile_num);

	wf_log ("free [g_spot_list_p] all spot");

	//ͷ֮ǰ洢ȵбڴ
	for (i = 0; i < WIFI_STATION_SPOT_LIST_NUM; i++) {
		safe_free (g_spot_list_p[i]);
		//g_spot_list_p[i] = NULL;
	}

	if (spot_num > 0 && spot_num <= WIFI_STATION_SPOT_LIST_NUM) {
		for (i = 0; i < spot_num; i++) {
			if (i == 0) {
				sc_cfg_get ("wifi_profile", spot_string, WIFI_STATION_SPOT_LEN);
			} else {
				memset (wifi_profile_nv_name, 0, WIFI_STATION_PROFILE_NV_NAME_LEN);
				snprintf (wifi_profile_nv_name, WIFI_STATION_PROFILE_NV_NAME_LEN, "wifi_profile%d", i);
				sc_cfg_get (wifi_profile_nv_name, spot_string, WIFI_STATION_SPOT_LEN);
			}

			wf_log ("get_spot_list spot_string[%d]= %s", i, spot_string);
			spot = parse_spot_string (spot_string);
			if (spot != NULL) {
				g_spot_list_p[j] = spot;
				j++;
			}
		}
	}

}

static void save_spot_list (void)
{
	int i = 0;
	char spot_string[WIFI_STATION_SPOT_LEN] = {0};
	char wifi_profile_nv_name[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};

	for (i = 0; i < WIFI_STATION_SPOT_LIST_NUM; i++) {
		if (g_spot_list_p[i] != NULL) {
			snprintf (spot_string, WIFI_STATION_SPOT_LEN, "%s,%d,%d,%d,%s,%s,%s,%s,%d,%s", g_spot_list_p[i]->profile_name,
			          g_spot_list_p[i]->from_provider, g_spot_list_p[i]->connect_status, g_spot_list_p[i]->signal,
			          g_spot_list_p[i]->ssid, g_spot_list_p[i]->auth_mode, g_spot_list_p[i]->encrypt_type,
			          g_spot_list_p[i]->password, g_spot_list_p[i]->keyID, g_spot_list_p[i]->mac);

			wf_log (" g_spot_list_p[%d]=%s, [%d]", i, spot_string, g_spot_list_p[i]->network_id);

			if (i == 0) {
				sc_cfg_set ("wifi_profile", spot_string);
			} else {
				snprintf (wifi_profile_nv_name, WIFI_STATION_PROFILE_NV_NAME_LEN, "wifi_profile%d", i);
				sc_cfg_set (wifi_profile_nv_name, spot_string);
			}
		}
	}
}


/*
ӳɹȵ㣬ŵһλ
*/
static void resort_spot_list (void)
{

	int i = 0, j = 0;
	int index = 0;
	spot_t *  spot = NULL;
	//  char      profile[WIFI_STATION_SPOT_PROFILE_NAME_LEN] = {0};

//    sc_cfg_get("EX_wifi_profile", profile, WIFI_STATION_SPOT_PROFILE_NAME_LEN);


	for (i = 0; i < WIFI_STATION_SPOT_LIST_NUM; i++) {
		if (g_spot_list_p[i] != NULL) {
			if (g_spot_list_p[i]->connect_status == 1) {
				index = i;
				spot = g_spot_list_p[i];
				break;
			}
		}

	}

	if (index == 0) return;

	for (i = 0; i < WIFI_STATION_SPOT_LIST_NUM; i++) {
		if (1 == g_spot_list_p[i]->from_provider) {
			continue;
		} else {
			//move other spot
			for (j = index; j > i; j--) { // ٶһ϶ǿյģ10ˣȵ㣬֮ǰѾжϴ󷵻
				if (g_spot_list_p[j] == NULL) continue;
				else {
					g_spot_list_p[j] = g_spot_list_p[j - 1]; //j must greater than 0
				}
			}
			if (i != index) {
				g_spot_list_p[i] = spot;
				wf_log ("[%s]SSID=[%s] from %d move to %d", __FILE__, spot->ssid, index, i);
			} else {
				wf_log ("[%s]SSID=[%s] do not move", __FILE__, spot->ssid);
			}
			break;
		}
	}

	//˳Ҫ± signal
	//reback_up_signal();

	save_spot_list();

}


static void update_spot_list_signal_connect_status (short signal, short connect_status)
{
	int i = 0;

	for (i = 0; i < WIFI_STATION_SPOT_LIST_NUM; i++) {
		if (g_spot_list_p[i] != NULL) {
			if (signal >= 0) {
				g_spot_list_p[i]->signal = signal;
			}

			if (connect_status >= 0) {
				g_spot_list_p[i]->connect_status = connect_status;
			}
		}
	}

}

static void update_spot_connect_status_by_status_result (BOOL is_connected)
{
	int i = 0;
	char spot_string[WIFI_STATION_SPOT_LEN] = {0};
	char wifi_profile_nv_name[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};

	wf_log ("is_connected=%d, g_linked_network_id= %d", is_connected, g_linked_network_id);

	for (i = 0; i < WIFI_STATION_SPOT_LIST_NUM; i++) {
		if (g_spot_list_p[i] != NULL &&  g_spot_list_p[i] ->network_id == g_linked_network_id) {
			if (is_connected == TRUE) {
				g_spot_list_p[i]->connect_status = 1;
			} else {
				g_spot_list_p[i]->connect_status = 0;
			}

			if (strcmp (g_spot_list_p[i]->mac, "0F:00:00:00:00:00") == 0) {
				strcpy (g_spot_list_p[i]->mac, g_linked_ap_mac);
			}
			wf_log ("g_spot_list_p[%d]->mac=%s", i, g_spot_list_p[i]->mac);
			wf_log ("profile[%d]=%d", i, g_spot_list_p[i]->connect_status);

			snprintf (spot_string, WIFI_STATION_SPOT_LEN, "%s,%d,%d,%d,%s,%s,%s,%s,%d,%s", g_spot_list_p[i]->profile_name,
			          g_spot_list_p[i]->from_provider, g_spot_list_p[i]->connect_status, g_spot_list_p[i]->signal,
			          g_spot_list_p[i]->ssid, g_spot_list_p[i]->auth_mode, g_spot_list_p[i]->encrypt_type,
			          g_spot_list_p[i]->password, g_spot_list_p[i]->keyID, g_spot_list_p[i]->mac);

			if (i == 0) {
				sc_cfg_set ("wifi_profile", spot_string);
			} else {
				snprintf (wifi_profile_nv_name, WIFI_STATION_PROFILE_NV_NAME_LEN, "wifi_profile%d", i);
				sc_cfg_set (wifi_profile_nv_name, spot_string);
			}

			break;
		}
	}
}

static void update_spot_signal_by_scan_result (scan_result_t *scan_result)
{
	int i = 0;

	if (scan_result == NULL) {
		return;
	}

	for (i = 0; i < WIFI_STATION_SPOT_LIST_NUM; i++) {
		if (g_spot_list_p[i] != NULL) {
			if (strcmp (g_spot_list_p[i]->mac, scan_result->mac) == 0  &&

			    strcmp (g_spot_list_p[i]->ssid, scan_result->ssid) == 0
			    //     && (strcmp(g_spot_list_p[i]->auth_mode, scan_result->auth_mode) == 0 ||
			    //          (strcmp(g_spot_list_p[i]->auth_mode,WIFI_STATION_PROFILE_AUTH_WPA_EAP)==0 && strcmp(scan_result->auth_mode,"802.1X")==0))
			    /*&& strstr(g_spot_list_p[i]->encrypt_type, scan_result->encrypt_type) != NULL*/)
// ȵ㣬ֶӵcipherΪauto޷ʶȵź
//Ҫʹmacƥ䣬ϣֻȡķ취
//webuiԶʶtkip aesΪautonv profileΪTKIPCCMP,´˴޷ƥ䣬޷ȵź
//EAP-SIM/AKA, ԭд802.1xҲƥ䣬޷ȵź
//޸ΪɨȵļΪTKIP CCMP,ֻҪڱȵҵַΪͬһȵ㣬޷ͬȵ㣬޷ʶ
			{
#ifdef USE_CAP_SUPPORT
				g_spot_list_p[i]->signal = scan_result->signal_db;
#else
				g_spot_list_p[i]->signal = scan_result->signal;
#endif
				break;
			}
		}
	}
}


static void sort_scan_result_by_signal (scan_result_t **scan_result, int size)
{
	int i, j = 0;
	scan_result_t *insertnode = NULL;

	if (scan_result == NULL) {
		return;
	}

	for (i = 0; i < size; i++) {
		if (scan_result[i] == NULL) {
			return;
		}
	}

	//ֱӲ㷨
	for (i = 1; i < size; i++) { //βֵ
		insertnode = scan_result[i];  //ֵ,ڱ
		j = i - 1;                                             //Ŀʼλ
		while (j >= 0 && insertnode->signal > scan_result[j]->signal) { //ʵĲλ
			scan_result[j + 1] = scan_result[j];
			j--;
		}
		scan_result[j + 1] = insertnode;
	}

}

/*
    inputStr: if there is a  \, then
    outputStr: add \\ before, to be \\\


*/

static char* process_backlash (char* inputStr, char* outputStr)
{
	int len = 0;
	int i, j = 0;
	if ( (NULL == inputStr) || (NULL == outputStr)) {
		return NULL;
	}

	len = strlen (inputStr);
	for (i = 0; i < len; i++) { //linux ת
		if ( (inputStr[i] == 0x5c && inputStr[i + 1] == 'x')) {
			outputStr[j++]  = 0x5c;
		}
		outputStr[j++] = inputStr[i];
	}
	outputStr[j] = '\0';
	//printf("[process_backlash]inputStr=%s,outputStr=%s",inputStr,outputStr);

	return outputStr;
}

static void save_scan_result (scan_result_t*  scan_result, char *scan_result_str, char *scan_result_str1)
{
	char *scan_result_str_temp = NULL;
	char one_scan_result_str[WIFI_STATION_SCAN_ONE_RESULT_STR_LEN] = {0};
	int one_scan_result_str_len = 0;

	char ssid[128] = {0};
	if (scan_result == NULL
	    || scan_result_str == NULL
	    || scan_result_str1 == NULL) {
		return;
	}

	if (strlen (scan_result->ssid) <= 0) {
		return;
	}

	scan_result_str_temp = safe_malloc (WIFI_STATION_SCAN_RESULT_STR_LEN, TRUE);


	process_backlash (scan_result->ssid, ssid);

	snprintf (one_scan_result_str, WIFI_STATION_SCAN_ONE_RESULT_STR_LEN, "%d,%d,%s,%d,%d,%s,%s,%s", scan_result->from_provider, scan_result->connect_status, ssid,
	          scan_result->signal, scan_result->channel, scan_result->auth_mode, scan_result->encrypt_type, scan_result->mac);

	one_scan_result_str_len = strlen (one_scan_result_str);

	//cfgӿ"nv name=nv value\0"ʽ洢һΪ1024+2
	if (one_scan_result_str_len + strlen (scan_result_str) + strlen ("EX_APLIST") + 2 > WIFI_STATION_SCAN_RESULT_STR_LEN) {
		if (one_scan_result_str_len + strlen (scan_result_str1) + strlen ("EX_APLIST1") + 2 > WIFI_STATION_SCAN_RESULT_STR_LEN) {
			//2048ֽˣ˳
			safe_free (scan_result_str_temp);
			return;
		} else {
			safe_strcpy (scan_result_str_temp, scan_result_str1, strlen(scan_result_str1) + 1);

			strncat (scan_result_str_temp, one_scan_result_str, one_scan_result_str_len);
			strncat (scan_result_str_temp, ";", 1);

			//ֵ
			safe_strcpy (scan_result_str1, scan_result_str_temp, WIFI_STATION_SCAN_RESULT_STR_LEN);
		}
	} else {
		safe_strcpy (scan_result_str_temp, scan_result_str, strlen(scan_result_str) + 1);//wlocwork

		strncat (scan_result_str_temp, one_scan_result_str, one_scan_result_str_len);
		strncat (scan_result_str_temp, ";", 1);

		//ֵ
		safe_strcpy (scan_result_str, scan_result_str_temp, WIFI_STATION_SCAN_RESULT_STR_LEN);
	}

	safe_free (scan_result_str_temp);

}

static int frequency_to_channel(int freq)
{
	int channel = 0;
	//channel
	switch(freq) {
		case WIFI_STATION_CHANNEL1:
			channel = 1;
			break;
		case WIFI_STATION_CHANNEL2:
			channel = 2;
			break;
		case WIFI_STATION_CHANNEL3:
			channel = 3;
			break;
		case WIFI_STATION_CHANNEL4:
			channel = 4;
			break;
		case WIFI_STATION_CHANNEL5:
			channel = 5;
			break;
		case WIFI_STATION_CHANNEL6:
			channel = 6;
			break;
		case WIFI_STATION_CHANNEL7:
			channel = 7;
			break;
		case WIFI_STATION_CHANNEL8:
			channel = 8;
			break;
		case WIFI_STATION_CHANNEL9:
			channel = 9;
			break;
		case WIFI_STATION_CHANNEL10:
			channel = 10;
			break;
		case WIFI_STATION_CHANNEL11:
			channel = 11;
			break;
		case WIFI_STATION_CHANNEL12:
			channel = 12;
			break;
		case WIFI_STATION_CHANNEL13:
			channel = 13;
			break;
		case WIFI_STATION_CHANNEL14:
			channel = 14;
			break;
		case WIFI_STATION_CHANNEL36:
			channel = 36;
			break;
		case WIFI_STATION_CHANNEL40:
			channel = 40;
			break;
		case WIFI_STATION_CHANNEL44:
			channel = 44;
			break;
		case WIFI_STATION_CHANNEL48:
			channel = 48;
			break;
		case WIFI_STATION_CHANNEL52:
			channel = 52;
			break;
		case WIFI_STATION_CHANNEL56:
			channel = 56;
			break;
		case WIFI_STATION_CHANNEL60:
			channel = 60;
			break;
		case WIFI_STATION_CHANNEL64:
			channel = 64;
			break;
		case WIFI_STATION_CHANNEL100:
			channel = 100;
			break;
		case WIFI_STATION_CHANNEL104:
			channel = 104;
			break;
		case WIFI_STATION_CHANNEL108:
			channel = 108;
			break;
		case WIFI_STATION_CHANNEL112:
			channel = 112;
			break;
		case WIFI_STATION_CHANNEL116:
			channel = 116;
			break;
		case WIFI_STATION_CHANNEL120:
			channel = 120;
			break;
		case WIFI_STATION_CHANNEL124:
			channel = 124;
			break;
		case WIFI_STATION_CHANNEL128:
			channel = 128;
			break;
		case WIFI_STATION_CHANNEL132:
			channel = 132;
			break;
		case WIFI_STATION_CHANNEL136:
			channel = 136;
			break;
		case WIFI_STATION_CHANNEL140:
			channel = 140;
			break;
		case WIFI_STATION_CHANNEL144:
			channel = 144;
			break;
		case WIFI_STATION_CHANNEL149:
			channel = 149;
			break;
		case WIFI_STATION_CHANNEL153:
			channel = 153;
			break;
		case WIFI_STATION_CHANNEL157:
			channel = 157;
			break;
		case WIFI_STATION_CHANNEL161:
			channel = 161;
			break;
		case WIFI_STATION_CHANNEL165:
			channel = 165;
			break;
		default:
			channel = 0;
			wf_log("unknow freq[%d]MHz!!!", freq);	
			break;
	}
	
	return channel;
}

static scan_result_t* parse_scan_result (Var *var)
{
	char *ptr = NULL;
	char *ptr1 = NULL;
	char *ptr2 = NULL;
	char *ptr3 = NULL;
	char *ptr4 = NULL;
	char *ptr5 = NULL;
	scan_result_t *scan_result = NULL;
	int frequency = 0;
	int signal = 0;
	char flags[WIFI_STATION_FLAGS_LEN] = {0};
	char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};

	char operater_ap[32] = {0};

	if (var == NULL) {
		return NULL;
	}

	//ǷǿɺԵһ
	ptr = strstr (var->val.str.sval, WIFI_STATION_SCAN_RESULT_PARSE_IGNORE);
	if (ptr) {
		return NULL;
	} else {
		//ɨڴ
		scan_result = safe_malloc (sizeof (scan_result_t), FALSE);
		if (scan_result == NULL) {
			return NULL;
		}

		//ƥɨϢ
		sscanf (var->val.str.sval, "%19[0-9,a-f,A-F,:]       %d    %d     %127s    %127[^\n]", scan_result->mac, &frequency, &signal, flags, scan_result->ssid);

		if (strncmp (scan_result->ssid, "\\x00", 4) == 0) {
			wf_log ("scan_result->mac=[%s] scan_result->ssid=[%s]is a hidden AP",
			        scan_result->mac, scan_result->ssid);
			safe_free (scan_result);
			return NULL;
		}


		sc_cfg_get ("operater_ap", operater_ap, sizeof (operater_ap));
		if (strcmp (scan_result->ssid, operater_ap) == 0) {
			scan_result->from_provider = 1;//fromProvider ǷӪ
		} else {
			scan_result->from_provider = 0;//fromProvider ǷӪ
		}

		sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));
		//connectStatus ״̬
		if (g_linked_network_id != -1 &&  strcmp (sta_ip_status, "connect") == 0) {
			int i = 0;
			i = find_linked_ap_index();
			if (i !=  -1) {
				wf_log ("g_spot_list_p[i]->ssid=[%s],scan_result->ssid=[%s]",
				        g_spot_list_p[i]->ssid, scan_result->ssid);

				if (strcmp (g_spot_list_p[i]->mac, scan_result->mac) == 0
				    && strcmp (g_spot_list_p[i]->ssid, scan_result->ssid) == 0) {
					scan_result->connect_status = 1;
				} else {
					scan_result->connect_status = 0;

				}
				wf_log ("connect_status = [%d]",  scan_result->connect_status);
			} else {
				scan_result->connect_status = 0;
			}

		} else {
			scan_result->connect_status = 0;
		}

		//signalźǿ
		if (signal > WIFI_STATION_SIGNAL_LEVEL4) {
			scan_result->signal = 4;
		} else if (signal > WIFI_STATION_SIGNAL_LEVEL3) {//kw 3
			scan_result->signal = 3;
		} else if (signal > WIFI_STATION_SIGNAL_LEVEL2) {
			scan_result->signal = 2;
		} else if (signal > WIFI_STATION_SIGNAL_LEVEL1) {
			scan_result->signal = 1;
		} else {
			scan_result->signal = 0;
		}

		//channel
#ifdef USE_CAP_SUPPORT
		if (signal <= 0 && signal > -128) {
			scan_result->signal_db = (signed char)signal;
		}
		else {
			scan_result->signal_db = (signed char)(-128);
		}
		//scan_result->ch_freq = frequency;
		
		scan_result->channel = frequency_to_channel(frequency);
#else
		switch (frequency) {
		case WIFI_STATION_CHANNEL1:
			scan_result->channel = 1;
			break;
		case WIFI_STATION_CHANNEL2:
			scan_result->channel = 2;
			break;
		case WIFI_STATION_CHANNEL3:
			scan_result->channel = 3;
			break;
		case WIFI_STATION_CHANNEL4:
			scan_result->channel = 4;
			break;
		case WIFI_STATION_CHANNEL5:
			scan_result->channel = 5;
			break;
		case WIFI_STATION_CHANNEL6:
			scan_result->channel = 6;
			break;
		case WIFI_STATION_CHANNEL7:
			scan_result->channel = 7;
			break;
		case WIFI_STATION_CHANNEL8:
			scan_result->channel = 8;
			break;
		case WIFI_STATION_CHANNEL9:
			scan_result->channel = 9;
			break;
		case WIFI_STATION_CHANNEL10:
			scan_result->channel = 10;
			break;
		case WIFI_STATION_CHANNEL11:
			scan_result->channel = 11;
			break;
		case WIFI_STATION_CHANNEL12:
			scan_result->channel = 12;
			break;
		case WIFI_STATION_CHANNEL13:
			scan_result->channel = 13;
			break;
		default:
			scan_result->channel = 0;
			break;
		}
#endif
		//authModeȨģʽ
		ptr = NULL;
		ptr2 = NULL;
		ptr3 = NULL;
		ptr = strstr (flags, WIFI_STATION_AUTH_WPA_PSK);
		ptr1 = strstr (flags, WIFI_STATION_AUTH_WPA3); //wpa2/wpa3: [WPA2-PSK+SAE-CCMP] wpa3: [WPA2-SAE-CCMP][ESS]
		ptr2 = strstr (flags, WIFI_STATION_AUTH_WPA2_PSK);
		ptr3 = strstr (flags, WIFI_STATION_AUTH_SHARED);
		ptr4 = strstr (flags, WIFI_STATION_AUTH_WPA_EAP);
		ptr5 = strstr (flags, WIFI_STATION_AUTH_WPA2_EAP);
		if (ptr && ptr2) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "WPAPSKWPA2PSK");
		} else if (ptr1 && ptr2) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "WPA2WPA3");
		} else if (ptr) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "WPAPSK");
		} else if (ptr2) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "WPA2PSK");
		} else if (ptr1) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "WPA3Personal");
		} else if (ptr3) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "SHARED");
		} else if (ptr4 && ptr5) {

			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "802.1X");
			//TODO  scan_result->from_provider = 1;//fromProvider ǷӪ
		} else if (ptr4) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "802.1X");

			//TODO scan_result->from_provider = 1;//fromProvider ǷӪ
		} else if (ptr5) {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "802.1X");

			//TODO scan_result->from_provider = 1;//fromProvider ǷӪ
		} else {
			snprintf (scan_result->auth_mode, WIFI_STATION_AUTH_MODE_LEN, "OPEN");
		}

		//encryptType
		ptr = NULL;
		ptr2 = NULL;
		ptr3 = NULL;
		ptr = strstr (flags, WIFI_STATION_ENCRYPT_CCMP);
		ptr2 = strstr (flags, WIFI_STATION_ENCRYPT_TKIP);
		ptr3 = strstr (flags, WIFI_STATION_ENCRYPT_WEP);
		if (ptr && ptr2) {
			snprintf (scan_result->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "TKIPCCMP");
		} else if (ptr) {
			snprintf (scan_result->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "CCMP");
		} else if (ptr2) {
			snprintf (scan_result->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "TKIP");
		} else if (ptr3) {
			snprintf (scan_result->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "WEP");
		} else {
			snprintf (scan_result->encrypt_type, WIFI_STATION_ENCRYPT_TYPE_LEN, "NONE");
		}
	}

	return scan_result;

}


static void handle_scan_result (vector_t* v)
{
	int i = 0;
	int j = 0;
	Var *var = NULL;
	char *scan_result_str = NULL;
	char *scan_result_str1 = NULL;
	int scan_result_str_len = 0;
	int scan_result_str_len1 = 0;
	scan_result_t *scan_result = NULL;

	if (v == NULL) {
		return;
	}

	scan_result_str = safe_malloc (WIFI_STATION_SCAN_RESULT_STR_LEN, FALSE);
	scan_result_str1 = safe_malloc (WIFI_STATION_SCAN_RESULT_STR_LEN, FALSE);

	if (scan_result_str == NULL || scan_result_str1 == NULL) {
		safe_free (scan_result_str);
		safe_free (scan_result_str1);
		return;
	}

	//ͷ֮ǰ洢ɨȵбڴ
	for (i = 0; i < WIFI_STATION_SCAN_RESULT_LIST_NUM; i++) {
		safe_free (g_scan_result_list_p[i]);
		//g_scan_result_list_p[i] = NULL;
		//printf("xujian safe_free g_scan_result_list_p[%d] = %d \n", i, g_scan_result_list_p[i]);
	}

// ֻwebuiбŻȥȡбҪ
//    get_spot_list();
	//ȳʼȵбźΪ0
	update_spot_list_signal_connect_status (0, -1);

	for (i = 0; i < vector_size (v); i++) {
		if (j >= WIFI_STATION_SCAN_RESULT_LIST_NUM) {
			break;
		}

		var = vector_get (v, i);
		if (var->type == IS_STRING) {
			scan_result = parse_scan_result (var); //   ɨб ȵmacַƥ
			if (scan_result != NULL) {
				g_scan_result_list_p[j] = scan_result;

				//Ҹ¶Ӧȵźǿ
				update_spot_signal_by_scan_result (g_scan_result_list_p[j]);

				j++;
			}
		}
	}

	save_spot_list();

	sort_scan_result_by_signal (g_scan_result_list_p, j);

	for (i = 0; i < j; i++) {
		save_scan_result (g_scan_result_list_p[i], scan_result_str, scan_result_str1);
	}

	scan_result_str_len = strlen (scan_result_str);
	scan_result_str_len1 = strlen (scan_result_str1);

	wf_log ("scan_result_str_len = %d scan_result_str_len1 = %d j = %d", scan_result_str_len, scan_result_str_len1, j);

	//ɨбNVд
	sc_cfg_set ("EX_APLIST", "");
	sc_cfg_set ("EX_APLIST1", "");

	if (scan_result_str_len > 0 && scan_result_str_len < WIFI_STATION_SCAN_RESULT_STR_LEN) {
		scan_result_str[scan_result_str_len - 1] = '\0'; //ȥһֺ
		sc_cfg_set ("EX_APLIST", scan_result_str);
	}//klocwork
	if (scan_result_str_len1 > 0 && scan_result_str_len1 < WIFI_STATION_SCAN_RESULT_STR_LEN) {
		scan_result_str1[scan_result_str_len1 - 1] = '\0'; //ȥһֺ
		sc_cfg_set ("EX_APLIST1", scan_result_str1);
	}

	safe_free (scan_result_str);
	safe_free (scan_result_str1);
}


static  void  ipfail_disconnect_ap()
{
	char cmd[WIFI_STATION_CMD_LEN] = {0};
	int spot_num = 0;
	int i = 0;

	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));
	spot_num = atoi (wifi_profile_num);

	for (i = 0; i < spot_num; i++) {
		if (g_spot_list_p[i]->network_id ==  g_linked_network_id) {
			wf_log ("[SSID= %s] ip dhcp failed ,will be disabled, and set priority 0", g_spot_list_p[i]->ssid);
			sprintf (cmd, "DISABLE_NETWORK %d", g_linked_network_id);
			sta_docmd (cmd);

			sprintf (cmd, "SET_NETWORK %d  priority 0", g_linked_network_id);
			sta_docmd (cmd);
			break;
		}
	}
	wifi_station_connect (MODULE_ID_WIFI);
// disable cmd will disconnect the ap , and  sta_disconnected will deal the process
	// i guess wpa_supplicant will  connect other enabled  spot

}


static void handle_sim_init_status_timer()
{
	char sim_zpbic_status[WIFI_ZPBIC_STATUS_LEN] = {0};

	if (g_send_count != g_pre_send_count) {
		wf_log ("g_send_count is %d -----g_pre_send_count is %d", g_send_count, g_pre_send_count);
		return;
	}
	sc_cfg_get ("sim_zpbic_status", sim_zpbic_status, sizeof (sim_zpbic_status));
	if (strcmp (sim_zpbic_status,  SIMCARD_INIT_NO_CARD) == 0) {
		//ɾsim init ״̬ʱ
		wf_log ("sim_zpbic_status is fail");
		// g_timer_sim_init_undefined_status_count = 0;
		//sc_timer_delete(WIFI_STATION_TIMER_SIM_CARD_STATUS);
		wifi_station_connect (MODULE_ID_WIFI);

		return;
	} else if (strcmp (sim_zpbic_status,  SIMCARD_INIT_UNDEFINED) == 0) {
//      printf(" handle_sim_init_status_timer in g_timer_sim_init_undefined_status_count is %d", //g_timer_sim_init_undefined_status_count);
#if 0
		if (g_timer_sim_init_undefined_status_count >= 4) {
			//ɾsim init ״̬ʱ
			//printf(" handle_sim_init_status_timer g_timer_sim_init_undefined_status_count is %d", //g_timer_sim_init_undefined_status_count);
			//g_timer_sim_init_undefined_status_count = 0;
			sc_timer_delete (WIFI_STATION_TIMER_SIM_CARD_STATUS);
			wlan_station_msg_handle_ex();
			return;
		}
		//g_timer_sim_init_undefined_status_count++;
#endif
		sc_timer_create (WIFI_STATION_TIMER_SIM_CARD_STATUS,
		                 TIMER_FLAG_ONCE, WIFI_STATION_TIMER_SIM_CARD_STATUS_INTERVAL,
		                 wifi_station_query_sim_card_status, NULL);
	} else if (strcmp (sim_zpbic_status,  SIMCARD_INIT_SUCCESS) == 0) {
		wf_log (" success");

		//wlan_station_msg_handle_connect();
		wifi_station_connect (MODULE_ID_WIFI);
	} else {
		wf_log ("unknow");

		wifi_station_connect (MODULE_ID_WIFI);

	}
}


static void wpa_supplicant_scan (void)
{
	sta_docmd ("SCAN");
}

static void wpa_supplicant_get_scan_result (vector_t* v)
{
	char *reply = NULL;

	if (v == NULL) {
		return;
	}

	//ȡɨ
	wf_log ("wlan-station get_scan_result");
//    exec_script(WPA_CLI" scan_results", v);
	reply = sta_docmd ("SCAN_RESULTS");

//   wf_log("[scan] scan results:\n %s" , reply);
	convert2vector (reply, v);
}


static void *wifi_station_query_sim_card_status(void* arg)
{
	//wlan_station_send_message(MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_SIM_INIT_TIMER_PROCESS, 0, NULL);
	ipc_send_message (MODULE_ID_WIFI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_SIM_INIT_TIMER_PROCESS, 0, NULL, 0);
	return NULL;
}

static void wifi_station_scan (void)
{
	char wifi_sta_connection[WIFI_CONNECTION_LEN] = {0};
	char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};

	sc_cfg_get ("wifi_sta_connection", wifi_sta_connection, sizeof (wifi_sta_connection));


	wf_log ("wifi_station_scan");
	//ܹرֱ˳
	if (strcmp (wifi_sta_connection, "1") != 0) {
		return;
	}

	//״̬˳
	sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));
	if (strcmp (sta_ip_status, WIFI_STATION_IP_STATUS_CONNECTING) == 0 ||
		strcmp (sta_ip_status, WIFI_STATION_IP_STATUS_DHCPING) == 0) {
		wf_log ("sta_ip_status=connecting,set scan_finish=2========");
		sc_cfg_set ("scan_finish", "2"); //ĿǸwebuiʱײconnecting
		return;
	}

	//wpa_supplicantû쳣
	if (check_supplicant_alive() ==0) {
		wf_log ("wpa supplicant is not running!xx");
		sc_cfg_set ("scan_finish", "2"); //ĿǸwebuiʱײ

		return;
	}
//   sc_cfg_set("scan_finish", "0");

	//ɨ
	wpa_supplicant_scan();

}

static void wifi_station_get_scan_results (void)
{
	vector_t *v = NULL;
	char wifi_sta_connection[WIFI_CONNECTION_LEN] = {0};
	char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};
	sc_cfg_get ("wifi_sta_connection", wifi_sta_connection, sizeof (wifi_sta_connection));

	wf_log ("wifi_station_get_scan_results");

	//ܹرֱ˳
	if (strcmp (wifi_sta_connection, "1") != 0) {
		wf_log ("wifi_sta_connection isn't 1,abormal!!!========");
		return;
	}
#ifndef USE_CAP_SUPPORT
	//״̬˳
	sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));
	if (strcmp (sta_ip_status, WIFI_STATION_IP_STATUS_CONNECTING) == 0 ||
		strcmp (sta_ip_status, WIFI_STATION_IP_STATUS_DHCPING) == 0) {
		wf_log ("sta_ip_status=connecting,set scan_finish=2========");
		sc_cfg_set ("scan_finish", "2"); //ĿǸwebuiʱײconnecting
		return;
	}
#endif
	//wpa_supplicantû쳣
	if (check_supplicant_alive() ==0) {
		wf_log ("detect wpa_supplicant isnot running========");
		sc_cfg_set ("scan_finish", "2"); //ĿǸwebuiʱײ
		return;
	}

	v = vector_init();
	wf_log ("starting scan result");

	//ȡɨ
	wpa_supplicant_get_scan_result (v);

	//ɨ
	handle_scan_result (v);

	sc_cfg_set ("scan_finish", "1");

	wf_log ("set scan finish 1");

	vector_free (v);
}

static void wifi_station_open_apsta(void)
{
	wf_log ("restart apsta");
	basic_deal_all (WIFI_CFG_RESTART_APSTATION); //ҪAPģʽлΪapsta ģʽ
}

static void sta_enable_all_networks (void)
{
	wf_log (" webui_select_network= %d, g_disable_other_network=%d ",
	        webui_select_network, g_disable_other_network);

#if 0
	//  webui ״̬ѡȵ
	if (webui_select_network == 1) {
		webui_select_network = 0;   // Ϊ˱selectϸȵĶϿ¼
		return;
	}
#endif

	if (g_disable_other_network == 1) {
		sc_cfg_set ("sta_ip_status", WIFI_STATION_IP_STATUS_CONNECTING);
		sta_docmd ("ENABLE_NETWORK all");
		// reconnect ,  willl connect last one ???
		sta_docmd ("RECONNECT");
		//has_exec_select_network =0;
		g_disable_other_network = 0;  // select  will disable others networks, so enable all , then reset it
	}
}

static void sta_disconnected (void)
{
	char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};

	sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));

	if (strcmp (sta_ip_status, "disconnect") != 0) { // пǹرapstaѾdeinit̾ͲҪ
		write_status (STASTATUS, "F");     //F ʾ Ͽ״̬0~4 ʾźǿ 5
		//EX_APLISTе״̬Ϊ0
		update_EX_APLIST_connect_status (FALSE);
		//ȵбжӦȵ״̬Ϊfalse
		update_spot_connect_status_by_status_result (FALSE);

		network_down_up (FALSE);

		g_linked_network_id_last = g_linked_network_id;

		if (0 ==webui_select_network) {
			sc_cfg_set ("sta_ip_status", WIFI_STATION_IP_STATUS_DISCONNECT);
		}else if(1 == webui_select_network){	
			sc_cfg_set ("sta_ip_status", WIFI_STATION_IP_STATUS_CONNECTING);
			webui_select_network =0;
		}

	}
}

static void sta_disconnect (void)
{
	int i = 0;
	int network_id = -1;
	char cmd[WIFI_STATION_CMD_LEN] = {0};
	int spot_num = 0;
	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};

	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));
	spot_num = atoi (wifi_profile_num);

	dump_spot();
	for (i = 0; i < spot_num; i++) {
		if (NULL != g_spot_list_p[i] && g_spot_list_p[i]->connect_status == 1) {
			network_id = g_spot_list_p[i]->network_id;
			break;
		}
	}

	if (network_id != -1) {
		sprintf (cmd, "DISCONNECT");
		sta_docmd (cmd);
		has_exec_disconnect = 1;
		//	sprintf(cmd, "DISABLE_NETWORK %d", network_id);
		//	sta_docmd(cmd);
	} else {
		wf_log ("All SSID AP already  disconnect, do not disconnect again");
	}
}

static void sta_connect (int network_id)
{
	int i = 0;
//	int network_id = -1;
	char cmd[WIFI_STATION_CMD_LEN] = {0};
	int spot_num = 0;
	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	char ssid[WIFI_STATION_SSID_LEN] = {0};
	char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};
	char manual_d_wifi[8]    = {0};
	char blc_wan_mode[32]    = {0};

	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));
	spot_num = atoi (wifi_profile_num);

	sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));
	sc_cfg_get ("manual_d_wifi", manual_d_wifi, sizeof (manual_d_wifi));
	sc_cfg_get ("blc_wan_mode", blc_wan_mode, sizeof (blc_wan_mode));

	if ((strcmp (manual_d_wifi, "1") == 0) || (strcmp ("PPPOE", blc_wan_mode) == 0)) {
		wf_log ("connect failed manual_d_wifi=%s,blc_wan_mode=%s",
		        manual_d_wifi, blc_wan_mode);
		return;
	}

	if (network_id == INVALID_NETWORK_ID) {
		// set  sta_ip_status, for webui
		sc_cfg_get ("EX_SSID1", ssid, WIFI_STATION_SSID_LEN);
		// sc_cfg_get("EX_mac", mac, WIFI_STATION_MAC_LEN);

		for (i = 0; i < spot_num; i++) {
			wf_log ("g_spot_list_p[%d] = 0x%p", i , g_spot_list_p[i]);//cov m
			if (g_spot_list_p[i] != NULL && !strcmp (g_spot_list_p[i]->ssid, ssid)) {

//protect not to connect twice
				if(1 == g_spot_list_p[i]->connect_status ){
					wf_log ("[%s] is connect ,do not need connect again,[sta_ip_status=%s]", ssid, sta_ip_status);
					return;
				}
				network_id = g_spot_list_p[i]->network_id;
//selectŵȵϿϿʱҪ¼˶Ҫȥenable all
				if (strcmp (sta_ip_status, WIFI_STATION_IP_STATUS_CONNECT) == 0 )
					webui_select_network = 1;
				break;
			}
		}
	}

	if (network_id == -1) {
		wf_log ("got the wrong network id");
		sc_cfg_set ("sta_ip_status", WIFI_STATION_IP_STATUS_DISCONNECT);
		return;
	} else {
//		if(strcmp(sta_ip_status, WIFI_STATION_IP_STATUS_DISCONNECT) != 0)
		{
			sprintf (cmd, "SELECT_NETWORK %d", network_id);
			sta_docmd (cmd);
			g_disable_other_network = 1;
		}
		sprintf (cmd, "ENABLE_NETWORK %d", network_id);
		sta_docmd (cmd);

		sta_docmd ("SAVE_CONFIG");

#if 0
		if (has_exec_disconnect == 1) {
			sta_docmd ("RECONNECT");
			has_exec_disconnect = 0; //  reconnect will  reset  has_exec_disconnect
		}
#endif
	}

//	Create_connect_timeout_timer(); //ӳʱʱ
}

static void do_dhcp (void)
{
	//ӳɹӿڽDHCP̷IPַ
	network_down_up (TRUE);
}

/*

Ͽʱ򣬸ȵ״̬g_linked_network_id Ǽ¼ӵȵ

sta_ip_status ¼״̬connect ״̬
*/
static int  find_linked_ap_index(void)
{
	int spot_num = 0;
	int i = 0;

	char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};

	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));
	sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));

	spot_num = atoi (wifi_profile_num);

	if (-1 == g_linked_network_id)  return -1;

	for (i = 0; i < spot_num; i++) {
		if (g_spot_list_p[i]->network_id == g_linked_network_id) {
			wf_log ("find_linked_ap_index = %d", i); //  һ 0Ӫȵʱܲ0
			return i;
		}
	}

	return  -1;

}

static void disable_network (char * ssid)
{
	char cmd[WIFI_STATION_CMD_LEN] = {0};
	int spot_num = 0;
	int i = 0;

	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));

	spot_num = atoi (wifi_profile_num);

	for (i = 0; i < spot_num; i++) {
		if (strcmp (g_spot_list_p[i]->ssid, ssid) == 0) {
			if (-1 != g_spot_list_p[i]->network_id) {
				sprintf (cmd, "DISABLE_NETWORK %d", g_spot_list_p[i]->network_id);
				sta_docmd (cmd);
				sta_docmd ("SAVE_CONFIG");
				break;
			} else {
				wf_log ("Error !! ssid =%s, networkid = %d\n ", g_spot_list_p[i]->ssid, g_spot_list_p[i]->network_id);
			}
		}
	}
}

static void  update_current_EX (char * ssid, char * mac)
{
	char buf[WIFI_STATION_SPOT_KEY_ID_LEN] = {0};
	int spot_num = 0;
	int i = 0;

	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));

	spot_num = atoi (wifi_profile_num);

	for (i = 0; i < spot_num; i++) {
		if (strcmp (g_spot_list_p[i]->ssid, ssid) == 0) {
			sc_cfg_set ("EX_wifi_profile", g_spot_list_p[i]->profile_name);
			sc_cfg_set ("EX_SSID1", ssid);
			sc_cfg_set ("EX_AuthMode", g_spot_list_p[i]->auth_mode);
			sc_cfg_set ("EX_EncrypType", g_spot_list_p[i]->encrypt_type);

			sprintf (buf, "%d", g_spot_list_p[i]->keyID);
			sc_cfg_set ("EX_DefaultKeyID", buf);

			sc_cfg_set ("EX_WPAPSK1", g_spot_list_p[i]->password);
			sc_cfg_set ("EX_WEPKEY", g_spot_list_p[i]->password);
			sc_cfg_set ("EX_mac", mac);
#ifdef USE_CAP_SUPPORT
			memset(buf, 0, sizeof(buf));
			snprintf(buf, sizeof(buf), "%d", g_spot_list_p[i]->signal);
			sc_cfg_set ("EX_signal", buf);
#endif
			break;
		}
	}
}

static void disable_other_network (int  network_id)
{

	char cmd[WIFI_STATION_CMD_LEN] = {0};
	int spot_num = 0;
	int i = 0;

	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));

	spot_num = atoi (wifi_profile_num);
	if (spot_num > WIFI_STATION_SPOT_LIST_NUM || spot_num < 0)
		return;

	for (i = 0; i < spot_num; i++) {
		if (g_spot_list_p[i]->network_id == network_id) {
			continue;
		}

		sprintf (cmd, "DISABLE_NETWORK %d", g_spot_list_p[i]->network_id);
		sta_docmd (cmd);
	}

	g_disable_other_network =  1;

}

static void sta_connected()
{
	char cmd[WIFI_STATION_CMD_LEN] = {0};

	write_status (STASTATUS, "4"); //F ʾ Ͽ״̬0~4 ʾźǿ 5 ʱźд

	//ȵбжӦȵ״̬Ϊtrue
	update_spot_connect_status_by_status_result (TRUE);

	//ȵбеis_tried_connectΪfalse
	//update_spot_list_is_tried_connect(FALSE);

	resort_spot_list();

	//EX_APLISTе״̬Ϊ1
	update_EX_APLIST_connect_status (TRUE);

	// set the success AP to EX_SSID1
	// update_current_EX();

	sc_cfg_set ("sta_ip_status", WIFI_STATION_IP_STATUS_CONNECT);
//	Delete_connect_timeout_timer();

	wf_log ("g_linked_network_id_last = %d, g_linked_network_id= %d", g_linked_network_id_last, g_linked_network_id);

// ЧidһӵĺӵĲͬһȵ
	if (g_linked_network_id_last  !=  -1   &&  g_linked_network_id_last  != g_linked_network_id) { // thr first time,  there's no the last id
		sprintf (cmd, "SET_NETWORK %d priority 2", g_linked_network_id_last);
		sta_docmd (cmd);
	}
	sprintf (cmd, "SET_NETWORK %d priority 3", g_linked_network_id);
	sta_docmd (cmd);

	wf_log ("g_disable_other_network= %d", g_disable_other_network);

//select ֮ɵӣͲdisableȵ㣬Ӧwpa_supplicant enable allѡȵ
	if (g_disable_other_network == 0) {
		disable_other_network (g_linked_network_id);
		//	g_disable_other_network =1;
	}

	sta_docmd ("SAVE_CONFIG");

}

static void update_eapsim_spot(void)
{
	int i = 0;
	int spot_num = 0;
	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	char cmd[WIFI_STATION_CMD_LEN] = {0};

	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));
	spot_num = atoi (wifi_profile_num);
	if (spot_num > WIFI_STATION_SPOT_LIST_NUM || spot_num < 0)
		return;

	for (i = 0; i < spot_num; i++) {
		if (strstr (g_spot_list_p[i]->auth_mode, WIFI_STATION_PROFILE_AUTH_WPA_EAP)) { //|| strstr(auth_mode, WIFI_STATION_PROFILE_AUTH_WPA2_EAP))
			if (g_cardmode == CARD_MODE_USIM) {
				sprintf (cmd, "SET_NETWORK %d eap AKA", g_spot_list_p[i]->network_id);
				sta_docmd (cmd);
			} else {
				sprintf (cmd, " SET_NETWORK %d eap SIM", g_spot_list_p[i]->network_id);
				sta_docmd (cmd);
			}
		}
	}
}

/*
  * just enable all networks let supplicant to connect automaticly
  */
static int wifi_station_connect (int from_where)
{
	char wifi_profile_num[8] = {0};
	char manual_d_wifi[8]    = {0};
	char wifi_cur_state[8]   = {0};
	char blc_wan_mode[16]    = {0};

	wf_log ("enter from %d blc_close_apsta= %d", from_where, g_blc_send_close_apsta);

	if (g_blc_send_close_apsta == 1) {
		wf_log ("blc send close wifi,so only blc can open wifi again.");
		return -1;
	}

	//ûпõȵ㣬ֱӷʧ
	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));
	sc_cfg_get ("manual_d_wifi", manual_d_wifi, sizeof (manual_d_wifi));
	sc_cfg_get ("blc_wan_mode", blc_wan_mode, sizeof (blc_wan_mode));
	sc_cfg_get ("wifi_cur_state", wifi_cur_state, sizeof (wifi_cur_state));

	//ֶϿwifiʹӣҲ
	if ( (strcmp (wifi_cur_state, WIFI_CLOSED) == 0) || (strcmp (wifi_profile_num, "0") == 0)
	     || (strcmp (manual_d_wifi, "1") == 0) || (strcmp ("PPPOE", blc_wan_mode) == 0)) {
		wf_log ("connect failed wifi_cur_state=%s, wifi_profile_num=%s,manual_d_wifi=%s,blc_wan_mode=%s",
		        wifi_cur_state, wifi_profile_num, manual_d_wifi, blc_wan_mode);
		return -1;
	}

	sta_enable_all_networks();
//	Create_connect_timeout_timer(); //ӳʱʱ
	return 0;
}

static void wifi_station_nv_init (void)
{
	sc_cfg_set ("sta_ip_status", WIFI_STATION_IP_STATUS_DISCONNECT);
	sc_cfg_set ("scan_finish", "0");
	//sc_cfg_set("EX_APLIST", "");
	//sc_cfg_set("EX_APLIST1", "");
	sc_cfg_set ("manual_d_wifi", "0");

	memset (g_linked_ap_mac, 0, WIFI_STATION_MAC_LEN);
	g_linked_network_id = -1;
	g_linked_network_id_last = -1;

	has_exec_disconnect = 0;
	webui_select_network = 0;
	g_disable_other_network = 1;

	get_spot_list();
	sync_nv_spot_list_conf_file();
	update_spot_list_signal_connect_status (0, 0);
	save_spot_list();
}

static int exist_eap_simaka_spot()
{
	int i = 0;
	int spot_num = 0;
	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};

	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));
	spot_num = atoi (wifi_profile_num);

	for (i = 0; i < spot_num; i++) {
		if (strstr (g_spot_list_p[i]->auth_mode, WIFI_STATION_PROFILE_AUTH_WPA_EAP)) //|| strstr(auth_mode, WIFI_STATION_PROFILE_AUTH_WPA2_EAP))
			return  g_spot_list_p[i]->network_id;
	}
	return -1;
}


void wlan_station_init (void)
{
	if(1 == g_wpa_supplicant)return ;

	wf_log ("time=%d", time(NULL));
	if (sta_manager->start_supplicant(sta_manager) == 0) {
		wf_log ("time=%d", time(NULL));
		wf_log (" wpa_supplicant run success");
		
		if (0 == wifi_connect_to_supplicant(&sta_manager->sock)) {
			wf_log (" socket connect success");
			sem_post (&g_wpa_supplicant_id);
			g_wpa_supplicant = 1;	
		} else {
			wlan_station_deinit();
		#ifdef USE_CAP_SUPPORT
			send_sta_status_to_cap(IN_WIFI_STA_STATUS_ERROR, IN_WIFI_REASON_CODE_NONE);
		#endif
			return;
		}
	}else {
		wf_log ("wpa_supplicant start failed");
		wlan_station_deinit();
	#ifdef USE_CAP_SUPPORT
		send_sta_status_to_cap(IN_WIFI_STA_STATUS_ERROR, IN_WIFI_REASON_CODE_NONE);
	#endif
		return;
	}

	
	wifi_station_nv_init();
	sta_docmd ("SCAN_INTERVAL 15");
	
#ifdef USE_CAP_SUPPORT
	send_sta_status_to_cap(IN_WIFI_STA_STATUS_IDLE, IN_WIFI_REASON_CODE_NONE);
#endif

	//EAP-SIMȵ㣬Ҫ߸òѯSIMϢ

	if (-1 != exist_eap_simaka_spot()) { // -1 simaka spot
		//eap send msg for card type
		/*if((0 == strcmp(ssid, "CMCC-SIM-test1")) || (0 == strcmp(ssid, "CMCC-SIM-test2")))
			{
			strcpy(auth_mode, WIFI_STATION_PROFILE_AUTH_WPA_EAP);
			}*/

		//if(0 == wlan_station_send_message(ZUFI_MODULE_ID_AT_MAIN, MODULE_ID_CARD_MODE_REQ, 0, NULL))
		if (0 == ipc_send_message (MODULE_ID_WIFI, MODULE_ID_AT_CTL, MSG_CMD_CARD_MODE_REQ, 0, NULL, 0)) {
			// ѯģʽϢȴ첽
			g_pre_send_count = g_send_count;
			return;
		} else {
			wifi_station_connect (MODULE_ID_WIFI);
		}
	} else {
		wifi_station_connect (MODULE_ID_WIFI);
	}
}

static void clear_conf_file(void)
{
	sta_docmd ("REMOVE_NETWORK all");
	sta_docmd ("SAVE_CONFIG");
}

static void clear_spot_list(void)
{
	int i = 0;
	wf_log ("[clear_spot_list]");

	for (i = 0; i < WIFI_STATION_SPOT_LIST_NUM; i++) {
		if (g_spot_list_p[i] != NULL) {
			safe_free (g_spot_list_p[i]);
		}

	}

}
static void wlan_station_deinit(void)
{
	int count = 50;

	wf_log ("enter");

	sta_docmd ("DISABLE_NETWORK all");
	sta_docmd ("SAVE_CONFIG");
#if !defined(__REALTEK_8192_CHIP__)	
	sta_docmd ("TERMINATE");
	usleep (150000);

	while (count-- > 0) {
		if (check_alive(&sta_manager->sock) == 0) {
			wf_log ("TERMINATE over\n");
			break;
		}
		usleep (100000);
	}
#endif

	g_disable_other_network  = 1;
	sta_manager->close_connection(sta_manager);

	g_wpa_supplicant = 0;

	clear_spot_list();
	memset (g_linked_ap_mac, 0, WIFI_STATION_MAC_LEN);
	g_linked_network_id = -1;
	g_linked_network_id_last = -1;
	has_exec_disconnect = 0;
	webui_select_network = 0;
	sc_cfg_set ("scan_finish", "0");
	sc_cfg_set ("EX_APLIST", "");
	sc_cfg_set ("EX_APLIST1", "");

	sc_cfg_set ("sta_ip_status", WIFI_STATION_IP_STATUS_DISCONNECT);

}


void wifi_station_close()
{
	sta_disconnected();
	wlan_station_deinit();
}


BOOL wlan_station_is_station_msg (unsigned short msg)
{
	if (msg >= MSG_CMD_WIFI_STATION_OPEN &&  msg <= MSG_CMD_WIFI_STATION_END) {
		return TRUE;
	} else if(msg == MSG_CMD_NET_WAN_DIAL_FAIL ||
				msg == MSG_CMD_CARD_MODE_RSP ||
				msg == MSG_CMD_PIN_STATUS_RSP){
		return TRUE;
	}
	else{
		return FALSE;
	}
}

static void wlan_station_msg_handle_card_mode_for_eap (MSG_BUF *pMsg)
{
#if 0
	spot_t *p = NULL;
	char      profile_name[WIFI_STATION_SPOT_PROFILE_NAME_LEN] = {0};
	char      *ssid = NULL;
	char      auth_mode[WIFI_STATION_AUTH_MODE_LEN] = {0};
	char      encrypt_type[WIFI_STATION_ENCRYPT_TYPE_LEN] = {0};
	char      *password_wpa = NULL;
	char      *password_wep = NULL;
#endif
	char       cardmodestr[WIFI_CARD_MODE_LEN+1] = {0};
	int        cardmode = 0;

	if (g_send_count != g_pre_send_count) {
		wf_log ("------------wlan_station_msg_handle_card_mode-----g_send_count is %d -----g_pre_send_count is %d", g_send_count, g_pre_send_count);
		return;
	}
	wf_log ("------------wlan_station_msg_handle_card_mode------------++++++++++++++++++++++++++++++");
	if (pMsg != NULL) {
		//kw 3
		memcpy (cardmodestr, pMsg->aucDataBuf, WIFI_CARD_MODE_LEN);

		wf_log ("------------wlan_station_msg_handle_card_mode--------333----++++++++++++++++++++++++++++++");
		cardmode = atoi (cardmodestr);
		wf_log ("------------wlan_station_msg_handle_card_mode--------cardmode is %d----++++++++++++++++++++++++++++++", cardmode);
		if (cardmode < 0 || cardmode > INT_MAX-1) //kw 3, cardmode 0-2
			cardmode = 0;
	}

	g_cardmode = cardmode;

	if (cardmode != CARD_MODE_USIM && cardmode != CARD_MODE_SIM) {
		wifi_station_connect (MODULE_ID_WIFI);
	} else {
		//eap send msg for pin status
		if (0 == ipc_send_message (MODULE_ID_WIFI, MODULE_ID_AT_CTL, MSG_CMD_PIN_STATUS_REQ, 0, NULL, 0)) {
			wf_log ("------------ipc_send_message-------MSG_CMD_PIN_STATUSREQ-----++++++++++++++++++++++++++++++");
			g_pre_send_count = g_send_count;
			return;
		} else {
			wf_log ("------------ipc_send_message-------MODULE_ID_PIN_STATUS_REQ--ex---++++++++++++++++++++++++++++++");
			wifi_station_connect (MODULE_ID_WIFI);

		}

		//wlan_station_msg_handle_connect();
	}
}

static void wlan_station_msg_handle_pin_status_for_eap (MSG_BUF *pMsg)
{
	char pinstatusstr[WIFI_PIN_STATUS_LEN+1] = {0};
	int pinstatus = 0;
	char sim_zpbic_status[WIFI_ZPBIC_STATUS_LEN] = {0};

	if (g_send_count != g_pre_send_count) {
		wf_log ("------------wlan_station_msg_handle_pin_status_for_eap-----g_send_count is %d -----g_pre_send_count is %d", g_send_count, g_pre_send_count);
		return;
	}
	wf_log ("------------wlan_station_msg_handle_pin_status_for_eap------------++++++++++++++++++++++++++++++");
	if (pMsg != NULL) {
		//kw 3
		memcpy (pinstatusstr, pMsg->aucDataBuf, WIFI_PIN_STATUS_LEN);

		pinstatus = atoi (pinstatusstr);

		if (PIN_STATUS_NO_PIN != pinstatus) {
			wifi_station_connect (MODULE_ID_WIFI);

		} else {
			//ӶԿʼǷɵж
			sc_cfg_get ("sim_zpbic_status", sim_zpbic_status, sizeof (sim_zpbic_status));
			if (0 == strcmp (sim_zpbic_status, SIMCARD_INIT_SUCCESS)) {
				wf_log ("--------------------sim_zpbic_status-----SIMCARD_INIT_SUCCESS ++++++++++++++-------------");
				update_eapsim_spot();
				//   wlan_station_msg_handle_connect();
				wifi_station_connect (MODULE_ID_WIFI);
			} else if (0 == strcmp (sim_zpbic_status, SIMCARD_INIT_UNDEFINED)) {
				wf_log ("--------------------sim_zpbic_status-----SIMCARD_INIT_UNDEFINED ++++++++++++++-------------");
				//g_timer_sim_init_undefined_status_count = 0;
				g_pre_send_count = g_send_count;
				//δɿļĳʼ޷eap֤Ҫʱѯsimʼ״̬
				sc_timer_create (WIFI_STATION_TIMER_SIM_CARD_STATUS,
				                 TIMER_FLAG_ONCE, WIFI_STATION_TIMER_SIM_CARD_STATUS_INTERVAL,
				                 wifi_station_query_sim_card_status, NULL);
			} else {
				wf_log ("--------------------sim_zpbic_status-----wlan_station_msg_handle_ex ++++++++++++++-------------");
				wifi_station_connect (MODULE_ID_WIFI);
			}
		}
	}
}

#ifdef USE_CAP_SUPPORT
static void cap_update_spot_param(wlan_sta_param_t *param)
{
	updateinfo_t info = {0};
	int spot_num = 0;
	char spot_tmp[WIFI_STATION_SPOT_LEN] = {0};
	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};

	snprintf(spot_tmp, sizeof(spot_tmp), "123456789123456789,0,0,0,%s,%s,%s,%s,0,0F:00:00:00:00:00",
		param->ssid, param->authmode, param->encrypt, param->pwd);
	if (g_wpa_supplicant == 1) {
		/*request disconnection from the currently connected
		* network. This will stop any ongoing scans and initiate deauthentication.
		*/
		sta_docmd("DISCONNECT");

		sc_cfg_get("wifi_profile_num", wifi_profile_num, sizeof(wifi_profile_num));
		spot_num = atoi(wifi_profile_num);
		if (spot_num > 0) {
			strncpy(info.action, "delete", sizeof(info.action)-1);
			//strncpy(info.spot, wifi_update_profile, sizeof(info.spot)-1);
			sc_cfg_get("wifi_profile", info.spot, sizeof(info.spot));
			webui_update_spot_list(&info);
			//usleep(100);
			sc_cfg_set("sta_ip_status", "disconnect");
		}
		
		
		sc_cfg_set("wifi_profile_num", "1");
		sc_cfg_set("wifi_profile", spot_tmp);
		memset(&info, 0, sizeof(info));
		strncpy(info.action, "add", sizeof(info.action)-1);
		strncpy(info.spot, spot_tmp, sizeof(info.spot)-1);
		webui_update_spot_list(&info);	
	}
	else {
		//ûгʼʱ
		sc_cfg_set("wifi_profile_num", "1");
		sc_cfg_set("wifi_profile", spot_tmp);
	//wpa_suplicantÿǷҪģѳʼˣӦҪ
	}

}

static void cap_station_enable(wlan_sta_enable_t *sta_ena)
{
	if (sta_ena->enable == 1) {
		g_cap_sta_enable = 1;
		if (1 == g_wpa_supplicant) {
			wf_log("station has opened");
			return;
		}
		//MSG_CMD_WIFI_STATION_OPEN;
		if (g_work_mode == IN_WIFI_WORK_MODE_AP0 || g_work_mode == IN_WIFI_WORK_MODE_AP1) {
			wifi_station_open_apsta();
			//wifi_station_connect(MODULE_ID_WEB_CGI);//򿪵ʱѾһΣûбҪٴ
		}
		else {
			wf_log("-MSG_CMD_WIFI_STATION_OPEN-");
			wlan_station_init();
		}
	}
	else {
		g_cap_sta_enable = 0;
		send_sta_status_to_cap(IN_WIFI_STA_STATUS_NONE, IN_WIFI_REASON_CODE_NONE);
		//sc_cfg_set("wifi_sta_connection", "0");

		if (0 == g_wpa_supplicant) {
			wf_log("station has closed");
			return;
		}
		//MSG_CMD_WIFI_STATION_CLOSE;
		sta_disconnected();
		wlan_station_deinit();
		if (g_work_mode == IN_WIFI_WORK_MODE_AP0 || g_work_mode == IN_WIFI_WORK_MODE_AP1) {
			//no mssid, not need
			//basic_deal_all (WIFI_CFG_RESTART_AP);
		}
	}

}

static int get_cur_ap_rssi(void)
{
    char *reply = NULL;
	int rssi = 0;
    char *start = NULL;
	char *end = NULL;
	
	reply = sta_docmd("SIGNAL_POLL");
	if (reply == NULL) {
        wf_log("SIGNAL_POLL failed\n");
        return 0;
    }
	
	start = strstr(reply, "RSSI=");
    if (start != NULL) {
        start += strlen("RSSI="); // skip "RSSI="
        rssi = strtol(start, &end, 10);
        if (start == end) {
            wf_log("Failed to convert RSSI\n");
            return 0;
        }
    } else {
        wf_log("Could not find RSSI\n");
        return 0;
    }
    return rssi;
}

static int get_cur_ap_signal(char *mac)
{
	int rssi = 0;

	int spot_num = 0;
	int i = 0;

	char wifi_profile_num[WIFI_STATION_PROFILE_NV_NAME_LEN] = {0};
	sc_cfg_get("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));

	spot_num = atoi(wifi_profile_num);

	for (i = 0; i < spot_num; i++) {
		if (strcmp(g_spot_list_p[i]->mac, mac) == 0) {
			rssi = (int)g_spot_list_p[i]->signal;
			break;
		}
	}
	
	return rssi;
}

static unsigned char single_db_to_level(int rssi)
{
	unsigned char level = 0;

	if (rssi > WIFI_STATION_SIGNAL_LEVEL4) {
		level = 4;
	} else if (rssi > WIFI_STATION_SIGNAL_LEVEL3) {//kw 3
		level = 3;
	} else if (rssi > WIFI_STATION_SIGNAL_LEVEL2) {
		level = 2;
	} else if (rssi > WIFI_STATION_SIGNAL_LEVEL1) {
		level = 1;
	} else {
		level = 0;
	}

	return level;
}

static int netmask_length(const char *netmask)
{
    struct in_addr addr;
	int count = 0;
	int i = 0;
	
    inet_pton(AF_INET, netmask, &addr);
    for (i = 0; i < 32; i++) {
        if ((addr.s_addr >> i) & 1) {
            count++;
        }
    }
    return count;
}

int send_sta_status_to_cap(int status, int reason)
{
	int ret = 0;
	wlan_sta_status_t sta_stat = {0};

	sta_stat.status = status;
	//2.4 5Gʱ޸
	strncpy(sta_stat.ifname, sta_manager->drv_proxy.iface_name, sizeof(sta_stat.ifname) - 1);

	if (sta_stat.status == IN_WIFI_STA_STATUS_CONNECTING
		|| sta_stat.status == IN_WIFI_STA_STATUS_ASSOCIATED
		|| sta_stat.status == IN_WIFI_STA_STATUS_CONNECTED) {
		char wifi_mac[20] = {0};
		char wifi_signal[20] = {0};
		sc_cfg_get("EX_mac", wifi_mac, sizeof(wifi_mac));
		//sc_cfg_get("EX_signal", wifi_signal, sizeof(wifi_signal));
		
		strncpy(sta_stat.ap_bssid, wifi_mac, sizeof(sta_stat.ap_bssid) - 1);
		//sta_stat.rssi = get_cur_ap_signal(wifi_mac);
		sta_stat.rssi = get_cur_ap_rssi();
		sta_stat.signal_level = single_db_to_level(sta_stat.rssi);
	}

	if (sta_stat.status == IN_WIFI_STA_STATUS_ERROR) {
		sta_stat.reason_code = reason;
	}

	if (sta_stat.status == IN_WIFI_STA_STATUS_CONNECTED) {
		char wbwanv6_enable[20] = {0};
		char wifiwan_ip[64] = {0};
		char wifiwan_ipv6[64] = {0};
		char nv_wifiwan[20] = {0};
		char nv_wifiwan_ip[32] = {0};
		char nv_wifiwan_ipv6[32] = {0};

		//wlan
		sc_cfg_get("wifiwan", nv_wifiwan, sizeof(nv_wifiwan));
		//ipv4
		sta_stat.has_addr = 1;
		//ip
		snprintf(nv_wifiwan_ip, sizeof(nv_wifiwan_ip), "%s_ip", nv_wifiwan);
		sc_cfg_get(nv_wifiwan_ip, wifiwan_ip, sizeof(wifiwan_ip));
		strncpy(sta_stat.addr.addr, wifiwan_ip, sizeof(sta_stat.addr.addr) - 1);
		//netmask
		memset(nv_wifiwan_ip, 0, sizeof(nv_wifiwan_ip));
		memset(wifiwan_ip, 0, sizeof(wifiwan_ip));
		snprintf(nv_wifiwan_ip, sizeof(nv_wifiwan_ip), "%s_nm", nv_wifiwan);
		sc_cfg_get(nv_wifiwan_ip, wifiwan_ip, sizeof(wifiwan_ip));
		strncpy(sta_stat.addr.netmask, wifiwan_ip, sizeof(sta_stat.addr.netmask) - 1);
		sta_stat.addr.subnet_bits = netmask_length(sta_stat.addr.netmask);
		//gateway
		memset(nv_wifiwan_ip, 0, sizeof(nv_wifiwan_ip));
		memset(wifiwan_ip, 0, sizeof(wifiwan_ip));
		snprintf(nv_wifiwan_ip, sizeof(nv_wifiwan_ip), "%s_gw", nv_wifiwan);
		sc_cfg_get(nv_wifiwan_ip, wifiwan_ip, sizeof(wifiwan_ip));
		strncpy(sta_stat.addr.gateway, wifiwan_ip, sizeof(sta_stat.addr.gateway) - 1);
		//pdns
		memset(nv_wifiwan_ip, 0, sizeof(nv_wifiwan_ip));
		memset(wifiwan_ip, 0, sizeof(wifiwan_ip));
		snprintf(nv_wifiwan_ip, sizeof(nv_wifiwan_ip), "%s_pridns", nv_wifiwan);
		sc_cfg_get(nv_wifiwan_ip, wifiwan_ip, sizeof(wifiwan_ip));
		strncpy(sta_stat.addr.dnsp, wifiwan_ip, sizeof(sta_stat.addr.dnsp) - 1);
		//sdns
		memset(nv_wifiwan_ip, 0, sizeof(nv_wifiwan_ip));
		memset(wifiwan_ip, 0, sizeof(wifiwan_ip));
		snprintf(nv_wifiwan_ip, sizeof(nv_wifiwan_ip), "%s_secdns", nv_wifiwan);
		sc_cfg_get(nv_wifiwan_ip, wifiwan_ip, sizeof(wifiwan_ip));
		strncpy(sta_stat.addr.dnss, wifiwan_ip, sizeof(sta_stat.addr.dnss) - 1);
		
		//ipv6
		sc_cfg_get("wbwanv6_enable", wbwanv6_enable, sizeof(wbwanv6_enable));
		if (atoi(wbwanv6_enable) == 1) {
			sta_stat.has_addr6 = 1;
			snprintf(nv_wifiwan_ipv6, sizeof(nv_wifiwan_ipv6), "%s_ipv6_ip", nv_wifiwan);
			sc_cfg_get(nv_wifiwan_ipv6, wifiwan_ipv6, sizeof(wifiwan_ipv6));
			strncpy(sta_stat.addr6.addr, wifiwan_ipv6, sizeof(sta_stat.addr6.addr) - 1);
			//prefix
			memset(nv_wifiwan_ipv6, 0, sizeof(nv_wifiwan_ipv6));
			memset(wifiwan_ipv6, 0, sizeof(wifiwan_ipv6));
			snprintf(nv_wifiwan_ipv6, sizeof(nv_wifiwan_ipv6), "%s_ipv6_prefix_info", nv_wifiwan);
			sc_cfg_get(nv_wifiwan_ipv6, wifiwan_ipv6, sizeof(wifiwan_ipv6));
			strncpy(sta_stat.addr6.prefix, wifiwan_ipv6, sizeof(sta_stat.addr6.prefix) - 1);
			//len
			memset(nv_wifiwan_ipv6, 0, sizeof(nv_wifiwan_ipv6));
			memset(wifiwan_ipv6, 0, sizeof(wifiwan_ipv6));
			snprintf(nv_wifiwan_ipv6, sizeof(nv_wifiwan_ipv6), "%s_ipv6_prefix_len", nv_wifiwan);
			sc_cfg_get(nv_wifiwan_ipv6, wifiwan_ipv6, sizeof(wifiwan_ipv6));
			sta_stat.addr6.prefix_bits = atoi(wifiwan_ipv6);
			//gateway
			memset(nv_wifiwan_ipv6, 0, sizeof(nv_wifiwan_ipv6));
			memset(wifiwan_ipv6, 0, sizeof(wifiwan_ipv6));
			snprintf(nv_wifiwan_ipv6, sizeof(nv_wifiwan_ipv6), "%s_ipv6_gw", nv_wifiwan);
			sc_cfg_get(nv_wifiwan_ipv6, wifiwan_ipv6, sizeof(wifiwan_ipv6));
			strncpy(sta_stat.addr6.gateway, wifiwan_ipv6, sizeof(sta_stat.addr6.gateway) - 1);
			//pdns
			memset(nv_wifiwan_ipv6, 0, sizeof(nv_wifiwan_ipv6));
			memset(wifiwan_ipv6, 0, sizeof(wifiwan_ipv6));
			snprintf(nv_wifiwan_ipv6, sizeof(nv_wifiwan_ipv6), "%s_ipv6_pridns_auto", nv_wifiwan);
			sc_cfg_get(nv_wifiwan_ipv6, wifiwan_ipv6, sizeof(wifiwan_ipv6));
			strncpy(sta_stat.addr6.dnsp, wifiwan_ipv6, sizeof(sta_stat.addr6.dnsp) - 1);
			//sdns
			memset(nv_wifiwan_ipv6, 0, sizeof(nv_wifiwan_ipv6));
			memset(wifiwan_ipv6, 0, sizeof(wifiwan_ipv6));
			snprintf(nv_wifiwan_ipv6, sizeof(nv_wifiwan_ipv6), "%s_ipv6_secdns_auto", nv_wifiwan);
			sc_cfg_get(nv_wifiwan_ipv6, wifiwan_ipv6, sizeof(wifiwan_ipv6));
			strncpy(sta_stat.addr6.dnss, wifiwan_ipv6, sizeof(sta_stat.addr6.dnss) - 1);
		}
	}
	
	ret = send_soc_msg(FAR_PS, MODULE_ID_WIFI, MSG_CMD_CAP_STA_STATUS, sizeof(sta_stat), &sta_stat);
	if (ret != 0) {
		wf_log("send_soc_msg fail, ret:%d\n", ret);
	}

	return ret;
}

static void cap_station_info(MSG_BUF *pMsg)
{
	wlan_sta_stat_sync_t sta_stat = {0};
	sta_stat.rssi = get_cur_ap_rssi();
	ipc_send_message(MODULE_ID_WIFI, pMsg->src_id, MSG_CMD_CAP_WIFI_STA_STAT_RSP, sizeof(sta_stat), &sta_stat, 0);
}

static void cap_station_scan(void)
{
	char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};
	
	wf_log("cap_station_scan");
	//ܹرֱ˳
	//wpa_supplicantû쳣
	if (check_supplicant_alive() == 0) {
		wf_log("wpa supplicant is not running!xx");
		//nvԿcap
		sc_cfg_set("scan_finish", "2"); //ĿǸwebuiʱײ
		return;
	}

	//״̬˳ ʱڲɨ һϲҪ
	sc_cfg_get("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));
	if (strcmp(sta_ip_status, WIFI_STATION_IP_STATUS_CONNECTING) == 0) {
		wf_log("sta_ip_status=connecting,set scan_finish=2========");
		//sc_cfg_set ("scan_finish", "2"); //ĿǸwebuiʱײconnecting
		//return;
	}

	if (strcmp (sta_ip_status, WIFI_STATION_IP_STATUS_DHCPING) == 0) {
		wf_log ("sta_ip_status=dhcping,set scan_finish=2========");
		//ɨ迴
		//sc_cfg_set ("scan_finish", "2"); //ĿǸwebuiʱײconnecting
		//return;
	}

	//ɨ
	g_cap_scan = 1;
	wpa_supplicant_scan();
	

}

static int transe_sta_auth_mode(char *authmode)
{
	int sc_auth = CAP_WIFI_AUTH_UNSUP;

	if (strcmp(authmode, "OPEN") == 0) {
		sc_auth = CAP_WIFI_AUTH_OPEN;
	}
	else if (strcmp(authmode, "WPA2PSK") == 0) {
		sc_auth = CAP_WIFI_AUTH_WPA2;
	}
	else if (strcmp(authmode, "WPA3Personal") == 0) {
		sc_auth = CAP_WIFI_AUTH_WPA3;
	}
	else if (strcmp(authmode, "WPAPSKWPA2PSK") == 0) {
		sc_auth = CAP_WIFI_AUTH_WPA12;
	}
	else if (strcmp(authmode, "WPA2WPA3") == 0) {
		sc_auth = CAP_WIFI_AUTH_WPA23;
	}
	else {
		wf_log("unsuport authmode:%s\n", authmode);
	}
	return sc_auth;
}

static int transe_sta_encrypt_type(char *etype)
{
	int sc_type = CAP_WIFI_ENCRYPT_UNSUP;

	if (strcmp(etype, "TKIPCCMP") == 0) {
		sc_type = CAP_WIFI_ENCRYPT_AUTO;
	}
	else if (strcmp(etype, "TKIP") == 0) {
		sc_type = CAP_WIFI_ENCRYPT_TKIP;
	}
	else if (strcmp(etype, "CCMP") == 0) {
		sc_type = CAP_WIFI_ENCRYPT_AES;
	}
	else {
		wf_log("unsuport encrypttype:%s\n", etype);
	}
	return sc_type;
}

// ȡźźõǰ30
static int send_scan_result_to_cap(void)
{
	wlan_sta_scan_list_t scan_list = {0};
	int ret = 0;

	int i = 0;
	for (i = 0; i < WIFI_STATION_SCAN_RESULT_LIST_NUM && i < CAP_WIFI_MAX_SCAN_CNT; i++) {
		if (g_scan_result_list_p[i] == NULL) {
			break;
		}
		
		scan_list.info[i].auth = transe_sta_auth_mode(g_scan_result_list_p[i]->auth_mode);
		scan_list.info[i].cipher = transe_sta_encrypt_type(g_scan_result_list_p[i]->encrypt_type);
		scan_list.info[i].channel = g_scan_result_list_p[i]->channel;
		//scan_list.info[i].frequency = g_scan_result_list_p[i]->ch_freq;
		scan_list.info[i].signal_level = g_scan_result_list_p[i]->signal;
		scan_list.info[i].signal = g_scan_result_list_p[i]->signal_db;
		strncpy(scan_list.info[i].essid, g_scan_result_list_p[i]->ssid, sizeof(scan_list.info[i].essid)-1);
		strncpy(scan_list.info[i].bssid, g_scan_result_list_p[i]->mac, sizeof(scan_list.info[i].bssid)-1);
		scan_list.cnt++;
	}
	//Ŀǰ30,˺˼atȡ,3500/2B,hex2str
	ret = send_soc_msg(FAR_PS, MODULE_ID_WIFI, MSG_CMD_CAP_STA_SCAN_RES, sizeof(scan_list), &scan_list);
	if (ret != 0) {
		wf_log("send_soc_msg fail, ret:%d\n", ret);
	}

	return ret;
}

static void scan_result_to_cap(void)
{
	int ret = 0;
	
	if (g_cap_scan == 1) {
		ret = send_scan_result_to_cap();
		if (ret == 0) {
			g_cap_scan = 0;
		}
	}

}
#endif

//wifi station
int  wlan_sta_parse_msg (MSG_BUF *pMsg)
{
	
	int ret =  0;
	switch (pMsg->usMsgCmd) {
	case MSG_CMD_WIFI_STATION_OPEN: {
#if defined(__REALTEK_8192_CHIP__) || defined(__AIC_8800DW_CHIP__)
		wifi_station_open_apsta();
		//wifi_station_connect(MODULE_ID_WEB_CGI);//򿪵ʱѾһΣûбҪٴ
#else
		wf_log("-MSG_CMD_WIFI_STATION_OPEN-");
		wlan_station_init();
#endif
		break;
	}
	case MSG_CMD_WIFI_STATION_CLOSE: {
		sta_disconnected();
		wlan_station_deinit();
#if defined(__REALTEK_8192_CHIP__)|| defined(__AIC_8800DW_CHIP__)
		basic_deal_all (WIFI_CFG_RESTART_AP);
#endif
		break;
	}
	case MSG_CMD_WIFI_STATION_CLOSE_OPEN_MSSID: {
		sta_disconnected();
		wlan_station_deinit();
		basic_deal_all (WIFI_CFG_CLOSESTA_OPENMSSID);
		break;
	}
	case MSG_CMD_WIFI_STATION_SPOT_UPDATE: {
		webui_update_spot_list ( (updateinfo_t*) (pMsg->aucDataBuf));

		//ÿûȵ󣬲Ҫ±signalȫֱɨʱǷб仯
		//ȵ仯Ҫͨscanȵ״̬
		break;
	}
	case MSG_CMD_WIFI_STATION_SCAN: {
		wifi_station_scan();
		break;
	}
	case MSG_CMD_WIFI_STATION_CONNECT: {
		sta_connect (INVALID_NETWORK_ID);
		break;
	}
	case MSG_CMD_WIFI_STATION_DISCONNECT: {
		sta_disconnect();
		break;
	}
	case MSG_CMD_WIFI_STATION_GET_SCAN_RESULTS: {
		wifi_station_get_scan_results();
#ifdef USE_CAP_SUPPORT
		scan_result_to_cap();
#endif
		break;
	}
	case MSG_CMD_WIFI_STATION_SIM_INIT_TIMER_PROCESS: {
		handle_sim_init_status_timer();
		break;
	}
	case MSG_CMD_WIFI_STATION_EVENT_CONNECTED: {
		wf_log ("[wifi event connected , goto dhcp]");
		sc_cfg_set ("sta_ip_status", "dhcping");
		do_dhcp();
#ifdef USE_CAP_SUPPORT
		send_sta_status_to_cap(IN_WIFI_STA_STATUS_ASSOCIATED, IN_WIFI_REASON_CODE_NONE);
#endif
		break;
	}
	case MSG_CMD_WIFI_STATION_EVENT_DISCONNECTED: {
		char  sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};
		sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));

		if (strcmp (sta_ip_status, "connect") == 0 || strcmp (sta_ip_status, "dhcping") == 0) {
			sta_disconnected();
		#ifdef USE_CAP_SUPPORT
			send_sta_status_to_cap(IN_WIFI_STA_STATUS_IDLE, IN_WIFI_REASON_CODE_NONE);
		#endif
		}
		else{
			wf_log ("The Spot connect failed, just set sta_ip_status  disconnect");
			sc_cfg_set ("sta_ip_status", "disconnect");
		}
		break;
	}
	case MSG_CMD_WIFI_STATION_EVENT_CONNECTING: {
		sc_cfg_set("sta_ip_status", WIFI_STATION_IP_STATUS_CONNECTING);
#ifdef USE_CAP_SUPPORT
		send_sta_status_to_cap(IN_WIFI_STA_STATUS_CONNECTING, IN_WIFI_REASON_CODE_NONE);
#endif
		break;
	}

	case MSG_CMD_BLC_OPEN_WIFISTATION_ACCESS: { //  you can connect
		char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};

		g_blc_send_close_apsta = 0;
		sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));

		wf_log ("sta_ip_status=%s", sta_ip_status);

		if (strcmp (sta_ip_status, WIFI_STATION_IP_STATUS_DISCONNECT) == 0) {
			wifi_station_connect (MODULE_ID_MAIN_CTRL);
		} else {
			wf_log ("do not deal connect cmd, sta_ip_status=%s", sta_ip_status);
		}
		break;
	}
	case MSG_CMD_BLC_CLOSE_WIFISTATION_ACCESS: {
		char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};

		g_blc_send_close_apsta = 1;
		sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));
		if (strcmp (sta_ip_status, WIFI_STATION_IP_STATUS_DISCONNECT) != 0) {
			sta_disconnect();//  if wifi not connect ok , then if there is disconnect event??
		} else {
			wf_log ("do not deal disconnect cmd, sta_ip_status=%s", sta_ip_status);

		}
		break;
	}

	case MSG_CMD_WIFI_STATION_BLC_CONNECTED: {
		char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};

		sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));
		if (strcmp (sta_ip_status, WIFI_STATION_IP_STATUS_DHCPING) == 0) {
			wf_log ("[wlan-station] wlan0-vxd get ip success");
			sta_connected();
		#ifdef USE_CAP_SUPPORT
			send_sta_status_to_cap(IN_WIFI_STA_STATUS_CONNECTED, IN_WIFI_REASON_CODE_NONE);
		#endif
		}
		else{
			wf_log (" DO not deal , sta_ip_status=%s", sta_ip_status);
		}
		break;
	}

	case MSG_CMD_NET_WAN_DIAL_FAIL: {
		wf_log ("wlan0-vxd dhcp ip failed");
		ipfail_disconnect_ap();
	#ifdef USE_CAP_SUPPORT
		send_sta_status_to_cap(IN_WIFI_STA_STATUS_ERROR, IN_WIFI_REASON_CODE_DHCP_FAILED);
	#endif
		break;
	}
	case MSG_CMD_CARD_MODE_RSP: {
		wlan_station_msg_handle_card_mode_for_eap (pMsg);
		break;
	}
	case MSG_CMD_PIN_STATUS_RSP: {
		wlan_station_msg_handle_pin_status_for_eap (pMsg);
		break;
	}
	case MSG_CMD_WIFI_STATION_CONNECT_TIMEOUT: {
		char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};
		sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));
		wf_log ("handle connect timeout msg,sta_ip_status=%s", sta_ip_status);
		if (strcmp (sta_ip_status, WIFI_STATION_IP_STATUS_CONNECTING) == 0) {
			sta_disconnect();
			sc_cfg_set ("sta_ip_status", WIFI_STATION_IP_STATUS_DISCONNECT);
			g_connecting_time_out_timer = 0;
		}
		break;
	}

	case MSG_CMD_WIFI_STATION_NO_AVAILABLE_AP:{
		char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};
		sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));
		wf_log ("handle no available ap, sta_ip_status=%s", sta_ip_status);
		if (strcmp (sta_ip_status, WIFI_STATION_IP_STATUS_CONNECTING) == 0) {
			sc_cfg_set ("sta_ip_status", "disconnect");
			if(1 == g_disable_other_network){
				sta_docmd ("ENABLE_NETWORK all");//  the connecting status  will be set by assocating  event, if no assoc , just be disconnect
				g_disable_other_network = 0;
			}
		}
		break;
	}
	case MSG_CMD_WIFI_STATION_TEMP_DISABLED: {
		if (g_wpa_supplicant == 1) {
			//wf_log ("MSG_CMD_WIFI_STATION_TEMP_DISABLED=%s", (char *)(pMsg->aucDataBuf));
			
			sc_cfg_set ("sta_ip_status", WIFI_STATION_IP_STATUS_DISCONNECT);
			process_tmp_disabled((char *)(pMsg->aucDataBuf));
		}
		break;
	}
	case MSG_CMD_WIFI_STATION_FAILED_SET: {
		char sta_ip_status[WIFI_STATION_IP_STATUS_LEN] = {0};
		sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));
		wf_log ("handle Failed to set, sta_ip_status=%s", sta_ip_status);
		if (strcmp (sta_ip_status, WIFI_STATION_IP_STATUS_CONNECTING) == 0) {
			sc_cfg_set ("sta_ip_status", "disconnect");
			//if(1 == g_disable_other_network){
			//	sta_docmd ("ENABLE_NETWORK all");//  the connecting status  will be set by assocating  event, if no assoc , just be disconnect
			//	g_disable_other_network = 0;
			//}
		#ifdef USE_CAP_SUPPORT
			send_sta_status_to_cap(IN_WIFI_STA_STATUS_ERROR, IN_WIFI_REASON_CODE_SET_FAILED);
		#endif
		}
		break;
	}
#ifdef USE_CAP_SUPPORT
	case MSG_CMD_CAP_STA_SET_PARAM: {
		cap_update_spot_param((wlan_sta_param_t *)(pMsg->aucDataBuf));
		break;
	}
	case MSG_CMD_CAP_STA_ENABLE: {
		//ûеstaĹ,apڵ¿sta
		cap_station_enable((wlan_sta_enable_t *)(pMsg->aucDataBuf));		
		break;
	}
	case MSG_CMD_CAP_STA_SCAN: {
		cap_station_scan();
		break;
	}
	case MSG_CMD_CAP_WIFI_STA_STAT_REQ: {
		cap_station_info(pMsg);
		break;
	}
#endif
	default: {
		ret = -1;
		break;
	}
	}

	return ret;
}


int  get_int_from_event (char * buf,  char * tag)
{
	int  ret = -1;
	char * pstr = NULL;

	if(NULL == buf || NULL == tag)
		return -1;

	pstr = strstr (buf, tag);
	if (pstr != NULL)  {
		pstr += strlen (tag);
		ret = atoi (pstr);
	}

	return  ret;
}

/*
˵Ŷhh, ssidȽϳ
\xe7\xbe\x8e\xe4\xb8\xbd\xe5\x86\xbb\xe4\xba\xba\xe7\x9a\x84\xe5\x85\xad\xe6\x9c\x9d\xe5\x8f\xa4\xe9\x83\xbd\xe5\x8d\x97hh
*/
void process_trying_to_assoc (char * buf)
{
	char * start = NULL;
	char * end = NULL;
	char  ssid[WIFI_STATION_SSID_LEN] = {0};
	char  mac[WIFI_STATION_MAC_LEN] = {0};
	unsigned int len = 0;//klocwork

	start = strstr (buf, "SSID=\'") + strlen("SSID=\'");
	if (start != NULL) {
		end = strstr (start, "\' ");//klocwork
	}

	strncpy (mac, buf + strlen ("Trying to associate with "), 17);
	wf_log ("Trying to associate with  mac=%s", mac);
	if (end != NULL && start != NULL) {
		len = end - start;
		len = MIN(len, WIFI_STATION_SSID_LEN-1);
		//strncpy (ssid, start, len);
		//ssid[WIFI_STATION_SSID_LEN-1] = '\0';//klocwork
		snprintf(ssid,len+1,"%s",start);
		wf_log ("Trying to associate with ssid= %s", ssid);
	}

	update_current_EX (ssid,  mac);

}

//Trying to associate with ca:c2:f1:74:2f:f4 (SSID='D_mi_D' freq=2412 MHz)
//SME: Trying to authenticate with 90:1d:27:78:2c:1e (SSID='Ufi_782111' freq=2412 MHz)
static void channel_follow(char * buf)
{
	char * start = NULL;
	char * end = NULL;
	char  freq[WIFI_STATION_FREQ_LEN] = {0};
	unsigned int len = 0;//klocwork
	int frequency = 0;

#ifdef USE_CAP_SUPPORT
	if (g_work_mode == IN_WIFI_WORK_MODE_STA) {
		wf_log("no ap channel_follow not need");
		return;
	}
#endif
	start = strstr(buf, "freq=") + strlen("freq=");
	if (start != NULL) {
		end = strstr (start, " MHz");//klocwork
	}

	if (end != NULL && start != NULL) {
		len = end - start;
		len = MIN(len, WIFI_STATION_FREQ_LEN-1);
		snprintf(freq, len+1, "%s", start);
		frequency = atoi(freq);
		wf_log("Trying to associate with freq= %s[%d]", freq, frequency);
		
#ifdef USE_CAP_SUPPORT
		int i_ch = 0;
		char s_ch[10] = {0};
		i_ch = frequency_to_channel(frequency);
		snprintf(s_ch, sizeof(s_ch), "%d", i_ch);
		sc_cfg_set("flower_channel", s_ch);
#else
		switch (frequency) {
		case WIFI_STATION_CHANNEL1:
			sc_cfg_set("flower_channel", "1");
			break;
		case WIFI_STATION_CHANNEL2:
			sc_cfg_set("flower_channel", "2");
			break;
		case WIFI_STATION_CHANNEL3:
			sc_cfg_set("flower_channel", "3");
			break;
		case WIFI_STATION_CHANNEL4:
			sc_cfg_set("flower_channel", "4");
			break;
		case WIFI_STATION_CHANNEL5:
			sc_cfg_set("flower_channel", "5");
			break;
		case WIFI_STATION_CHANNEL6:
			sc_cfg_set("flower_channel", "6");
			break;
		case WIFI_STATION_CHANNEL7:
			sc_cfg_set("flower_channel", "7");
			break;
		case WIFI_STATION_CHANNEL8:
			sc_cfg_set("flower_channel", "8");
			break;
		case WIFI_STATION_CHANNEL9:
			sc_cfg_set("flower_channel", "9");
			break;
		case WIFI_STATION_CHANNEL10:
			sc_cfg_set("flower_channel", "10");
			break;
		case WIFI_STATION_CHANNEL11:
			sc_cfg_set("flower_channel", "11");
			break;
		case WIFI_STATION_CHANNEL12:
			sc_cfg_set("flower_channel", "12");
			break;
		case WIFI_STATION_CHANNEL13:
			sc_cfg_set("flower_channel", "13");
			break;
		default:
			sc_cfg_set("flower_channel", "0");
			wf_log("channel_follow with unknow freq = [%d]", frequency);
			break;
		}
#endif
	}
	
	ipc_send_message (MODULE_ID_WIFI, MODULE_ID_WIFI, MSG_CMD_WIFI_CHANNEL_FOLLOW, 0, NULL, 0);

}

/*
STA: CTRL-EVENT-SSID-TEMP-DISABLED id=7 ssid="ydh" auth_failures=5 duration=60 reason=CONN_FAILED

*/

static void process_tmp_disabled (char *buf)
{
	char *p_WRONG_KEY   = NULL;
	char *p_AUTH_FAILED = NULL;
	char *p_CONN_FAILED = NULL;
	char  wifi_profile_num[8] = {0};
	char cmd[WIFI_STATION_CMD_LEN] = {0};
	int network_id = -1;
	int auth_failures = 0;

	sc_cfg_get ("wifi_profile_num", wifi_profile_num, sizeof (wifi_profile_num));
	p_WRONG_KEY =  strstr (buf, "WRONG_KEY");
#ifdef USE_CAP_SUPPORT
	p_AUTH_FAILED =  strstr(buf, "AUTH_FAILED");
	p_CONN_FAILED =  strstr(buf, "CONN_FAILED");
#endif
	/*
	иŻ㷨Ч
	*/
	auth_failures = get_int_from_event (buf, "auth_failures=");

	if (atoi (wifi_profile_num) > 1 && (p_WRONG_KEY || auth_failures > 1)) {
		network_id = get_int_from_event (buf, "id=");

		wf_log ("network_id = %d  wrong key  or tmp_disabled_times = %d",  network_id, auth_failures);

		sprintf (cmd, "SET_NETWORK %d priority 0", network_id);
		sta_docmd (cmd);
		sta_docmd ("SAVE_CONFIG");

		wifi_station_connect (MODULE_ID_WIFI);

		if (p_WRONG_KEY) {
			wf_log ("network_id = %d wrong key to disable it", network_id);
			sprintf (cmd , "DISABLE_NETWORK %d", network_id);
			sta_docmd (cmd);
			sta_docmd ("SAVE_CONFIG");
		}
	}

#ifdef USE_CAP_SUPPORT
	if (p_WRONG_KEY) {
		send_sta_status_to_cap(IN_WIFI_STA_STATUS_ERROR, IN_WIFI_REASON_CODE_WRONG_KEY);
	}
	else if (p_AUTH_FAILED) {
		send_sta_status_to_cap(IN_WIFI_STA_STATUS_ERROR, IN_WIFI_REASON_CODE_AUTH_FAILED);
	}
	else if (p_CONN_FAILED) {
		send_sta_status_to_cap(IN_WIFI_STA_STATUS_ERROR, IN_WIFI_REASON_CODE_CONN_FAILED);
	}
#endif
}


void *station_loop (void *param)
{
	char buf[UEVENT_BUFFER_SIZE];
	char name[32] = {0};
	static  int  scan_times = 0;
	int  loop_run = 0;

	strncpy (name, (char*) param, sizeof(name)-1);
	prctl (PR_SET_NAME, name, 0, 0, 0);

	while (1) {    //charging״̬Ĳ
		//if wpa_supplicant is stop ,then wait
		//if recv the sem,  g_wpa_supplicant ==1
		//   wf_log("station_loop: g_wpa_supplicant= %d", g_wpa_supplicant);
		if (g_wpa_supplicant == 0 || 0 == loop_run) {
			sem_wait (&g_wpa_supplicant_id);
		}
		loop_run =1;
		// ¼οwpa_supplantwpa_ctrl.hж
		int nread = wifi_wait_for_event (&sta_manager->sock, buf, sizeof (buf));

		//wake_sta_lock();
		if (nread > 0) {
			wf_log ("STA: %s", buf);

			if (strstr (buf, "CTRL-EVENT-SCAN-RESULTS")) {
				char  sta_ip_status[16] = {0};
				sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));

				if (strcmp (sta_ip_status, "connecting") != 0) {//disconnect connect dhcping
					wf_log ("snd msg to get scan results");
					scan_times = 0; // IF status change to not connecting, then set 0
					ipc_send_message (MODULE_ID_WIFI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_GET_SCAN_RESULTS, 0, NULL, 0);
				} else {
					// 17S  ccan interval,  17*12 =204S about, to disconnect,  just set the nv value, the wpa_supplicant still scan to connect
					// the final status ,is enable all network, and scan to connect ,but sta_ip_status is disconnect
					scan_times ++;
					if (4 == scan_times) {//12-->4 , decrease the waiting time
						wf_log ("can not find available spot, just set sta_ip_status disconnect", buf);
						ipc_send_message (MODULE_ID_WIFI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_NO_AVAILABLE_AP, 0, NULL, 0);
						scan_times = 0;
					}
				#ifdef USE_CAP_SUPPORT
					ipc_send_message (MODULE_ID_WIFI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_GET_SCAN_RESULTS, 0, NULL, 0);
				#endif
				}
			}
			//STA: CTRL-EVENT-CONNECTED - Connection to a6:44:d1:86:c5:d9 completed [id=0 id_str=]

			else if (strstr (buf, "CTRL-EVENT-CONNECTED")) {			
				ipc_send_message (MODULE_ID_WIFI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_CONNECTED_ENABLE_AP_CMD, 0, NULL, 0);
			
				char *p = strstr (buf, "Connection to ");

				scan_times = 0; // IF status change to not connecting, then set 0

				if (p != NULL) {// 
					p += strlen ("Connection to ");
					strncpy (g_linked_ap_mac, p, 17);
				}
				g_linked_network_id = get_int_from_event (buf, "[id=");
				wf_log ("g_linked_network_id_last = %d, g_linked_network_id= %d",  g_linked_network_id_last, g_linked_network_id);
				//wf_send_message( MODULE_ID_WIFI, MODULE_ID_WIFI,  MSG_CMD_WIFI_STATION_EVENT_CONNECTED, 0, NULL);
				ipc_send_message (MODULE_ID_WIFI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_EVENT_CONNECTED, 0, NULL, 0);
			} else if (strstr (buf, "CTRL-EVENT-DISCONNECTED")) {
				ipc_send_message (MODULE_ID_WIFI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_EVENT_DISCONNECTED, 0, NULL, 0);
			}

			//STA: CTRL-EVENT-SSID-REENABLED id=0 ssid="ZONG MBB-MF920W+-000012"
			else if (strstr (buf, "CTRL-EVENT-SSID-REENABLED")) {
				scan_times = 0; // when reenable , it indicate there is available AP, so set it  0
				ipc_send_message (MODULE_ID_WIFI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_EVENT_CONNECTING, 0, NULL, 0);
			}
			//STA: Trying to associate with 00:90:49:58:00:73 (SSID='Wo4G-0073' freq=2412 MHz)
			else if (strstr (buf, "Trying to associate with")) {
#if defined(__AIC_8800DW_CHIP__)
				channel_follow(buf);
#endif
				scan_times = 0; // when begin to assoc , it indicate there is available AP, so set it  0
				//  CTRL-EVENT-SSID-REENABLED   maybe lost
				ipc_send_message (MODULE_ID_WIFI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_EVENT_CONNECTING, 0, NULL, 0);
				process_trying_to_assoc (buf); //ipc_send_messageǰ
			}
			//SME: Trying to authenticate with 90:1d:27:78:2c:1e (SSID='Ufi_782111' freq=2412 MHz)
			else if (strstr (buf, "Trying to authenticate with")) {
#if defined(__SSV_6X5X_CHIP__)
				channel_follow(buf);
#endif
			}
			else if (strstr (buf , "CTRL-EVENT-SIGNAL-CHANGE")) {
				wf_log ("snd msg to update signal level");
			}
			// CTRL-EVENT-SSID-TEMP-DISABLED id=0 ssid="CPE_E3DE4E" auth_failures=2 duration=20 reason=WRONG_KEY AUTH_FAILEDCONN_FAILED
			else if (strstr (buf, "CTRL-EVENT-SSID-TEMP-DISABLED")) {	
				//time sequence sc_cfg_set sta_ip_status, process in another thread with other event
				ipc_send_message (MODULE_ID_WIFI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_TEMP_DISABLED, nread, buf, 0);
			}
			//WPA: Failed to select authenticated key management type --- 1
			//WPA: Failed to set WPA key management and encryption suites --- 2
			else if (strstr (buf, "WPA: Failed to set")) {	
				//sta auth failed
				ipc_send_message (MODULE_ID_WIFI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_FAILED_SET, 0, NULL, 0);
			}
			else if (strstr (buf, "CTRL-EVENT-TERMINATING")) {

				loop_run = 0;
			}
		} else {
			wf_log ("Could not read pending message.");
		}
	}

	return NULL;
}

void wifi_station_cancel_scan(void)
{
	sta_docmd("ABORT_SCAN"); //cancel current scan, and remove scan works
	sta_docmd("SCAN_INTERVAL 15"); //eloop scan timer reset
}

void  wlan_station_open()
{

}

void  wlan_statemachine_init()
{

}


